Ext.define('activeidleuserreport.controller.ActiveIdleUserReport',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	foregroundJspUrl:'/final/reporter/ErActiveIdleUserReportJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErActiveIdleUserReportC',
	backgroundControllerUrl:'../servlet/com.eg.ErStartBackGroundReportC',
	isNewFav:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'activeidlesettings':{
 				'afterrender':this.loadSettings
			},
			'activeidlesettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			/* 'activeidlesettings combo[name="er_excwe"]':{
				'select': this.onWeekendChange
			},*/
			'activeidlesettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'activeidlesettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'activeidleform combo[name="er_compType"]':{
				'select': this.onComponentTypeChange
			},
			'activeidleform button[name="submit"]':{
				'click': this.showResult
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'userinfo trigger[id="userSearch"]':{
				'change': this.filterMultiselect
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'activeidleform button[name="save"]': {
				'click': this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'activeidleform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'activeidleform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	onSelectAnalysisBy: function (obj) 
	{
		this.hideResults();
		var er_option=obj.getValue();
		var params='er_option='+er_option;
		this.getAjaxData(this.foregroundJspUrl,params);
		this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);		 
		this.loadComponentInfo();
	},
	er_siteOnChange:function(obj) 
	{
		this.hideResults();
		var er_site=obj.getValue(); 
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue();
		this.getAjaxData(this.foregroundJspUrl,params);	
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComponentInfo();
	},
	onComponentTypeChange:function(obj)
	{
		this.hideResults();
		var compType=Ext.getCmp('er_compType').getValue();
		var params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_compType='+compType;
		this.getAjaxData(this.foregroundJspUrl,this.getQueryString(true,false,false));
		this.loadComponentInfo();
	},
	loadComponentInfo:function()
	{
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,true,'componentpane',true);
		if(appConstants.publicJsonData.selectedFields.componentTypeSelected=='Virtual_Machine' || (appConstants.showVirtualDesktop && appConstants.publicJsonData.selectedFields.componentTypeSelected=='all'))
		{
			Ext.getCmp('componentpane').hide();
			Ext.getCmp('er_info').show();
		}
		else
		{
			Ext.getCmp('componentpane').show();
			Ext.getCmp('er_info').hide();
		}
		Ext.getCmp('er_info').setValue(appConstants.publicJsonData.selectedFields.selectedVm);
		Ext.getCmp('er_info').setFieldLabel(appConstants.publicJsonData.labelFields.infoTypeLabel);
	},
	goTo: function (obj)
	{
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	saveSchedule:function(obj)
	{
 		if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title: 'Active-Idle User',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var target="/final/reporter/ErSaveSchedule.jsp?"+this.getQueryString(true,true,true)+"&option=data&er_type=No";
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			if(appConstants.menuForVM=='true')
			{
	 			scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
			else
			{
	 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
 	},
	saveFavorite:function(obj)
	{
		var isValid = this.validateMainForm(false);
		/* if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: 'Active-Idle User',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
 		} */
		var target="";
		//&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName;
			
			if(target!=undefined && target.indexOf("FavoriteId")==-1)
				target+='&FavoriteId='+appConstants.favorite_id;
			//document.location=target+'&showWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;
			if(appConstants.menuForVM=='true')
			{
				favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
			else
			{
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
 	},
	saveReportAsPDF:function()
	{
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString(true,true,true)+"&option=data";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function()
	{
 		var s_qryString = "/final/reporter/ErActiveIdleUserReportPrint.jsp?"+appConstants.publicJsonData.urlFields.saveQueryString+"&er_view=PRINT&pdfPrint=yes";
		if(appConstants.menuForVM=='true')
		{
			printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
			parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	filterMultiselect: function (obj) 
	{
		obj.toggleTriggger();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}

		if (obj.getId()=='compSearch')
		{
			appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
		}
    },
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Components',btn);
		}
 	},
	loadReportData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
 		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		this.hideResults();
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		var result = checkDateTime(tmpStartDate, tmpEndDate);
		if (!result) 
		{
			return;
		}
 		if(reportGeneration == 'foreground')
		{
			resultContainerObj.removeAll();

			if(appConstants.publicJsonData.hasOwnProperty('data'))
			{
				if (appConstants.publicJsonData.data.hasOwnProperty('noMeasures'))
				{
					this.disableTools();
 					this.getNomeasurepanel().show();
				}
				else
				{
  					Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
					var publicGridData = appConstants.publicJsonData.data.gridObj;
					if (appConstants.publicJsonData.data != undefined)
					{
						resultContainerObj.show();
						this.loadSummary(appConstants.publicJsonData.data.SUMMARY);
						this.loadGraph(appConstants.publicJsonData.data);
						if (publicGridData != undefined)
						{
							this.loadGrid(publicGridData);
						}
					}
  					this.enableTools();
 				}//end of else
			}
		}
		else if(reportGeneration == 'background')
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor//.slice(0, -3);
				backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
 			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				var sub = backgroundAnchor//.slice(0, -3);
				backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
			}
			else
			{
				backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>');
			}
			backGroundPanel.show();
		}
		else if(reportGeneration=="background-csv")
		{
			var backGroundPanel=Ext.getCmp('backGroundPanel');
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus!= 'undefined')
			{
				if(backgroundReportStatus== 'success')
				{
					var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
					var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
					var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
					var sub = backgroundAnchor//.slice(0, -3);
					backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
				}
				else if(backgroundReportStatus== 'duplicate')
				{
					var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
					var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
					var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
					var sub = backgroundAnchor//.slice(0, -3);
					backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');
				}
			}
			else
			{
				backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>');
			}
			backGroundPanel.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
 	},
	loadSummary:function(SummaryObj)
	{
		if(SummaryObj!=undefined) 
		{
			var resultContainerObj=Ext.getCmp('resultContainer');
			var totalUser = '<div><table align="center"><tboby><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconServerGray"/></div><div class="newFont_bold28" style="margin:5px;">'+SummaryObj.UNIQUE_USER+'</div></div></td></tr><tr><td align="center" nowrap style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+total_user+'</span></td></tr></tbody></table></div>';
			var sessionCompleted = '<div><table align="center"><tboby><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconServerGray"/></div><div class="newFont_bold28" style="margin:5px;">'+SummaryObj.TOTAL_SESSION+'</div></div></td></tr><tr><td align="center" nowrap style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+total_session+'</span></td></tr></tbody></table></div>';
			var highIdleSession = '<div><table align="center"><tboby><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconSessionHighIdleTime"/></div><div class="newFont_bold28" style="margin:5px;">'+SummaryObj.HIGH_IDLE_SESSION+'</div></div></td></tr><tr><td align="center" nowrap style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+session_highTime+'</span></td></tr></tbody></table></div>';
			var highIdleuser = '<div><table align="center"><tboby><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconUserHighIdleTime"/></div><div class="newFont_bold28" style="margin:5px;">'+SummaryObj.HIGH_IDLE_USER+'</div></div></td></tr><tr><td align="center" nowrap style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+user_highTime+'</span></td></tr></tbody></table></div>';

			resultContainerObj.add({
				xtype:'panel',
				columnWidth:1.0,
				//cls:'datapanel',
				ui:'newGraphPanel',
				layout:'column',
				title:overviewTxt,
				margin:'10 0 10 0',
				defaults:{
					margin:'10 0 10 0',
					columnWidth:0.25,
				},
				items:[
				{
					xtype:'container',
					html:totalUser
				},
				{
					xtype:'container',
					html:sessionCompleted
				},
				{
					xtype:'container',
					html:highIdleSession
				},
				{
					xtype:'container',
					html:highIdleuser
				}]
			})
		}
	},
	loadGraph:function(graphData)
	{
		var resultContainerObj = Ext.getCmp('resultContainer');
		if(graphData.pieObj!=undefined)
		{
			var pieObj = graphData.pieObj;
			resultContainerObj.add(
			{
				xtype:'panel',
				//cls:'datapanel',
				ui:'newGraphPanel',
				height:350,
				columnWidth:0.5,
				margin:'0 10 0 0',
				title:overviewActive_idleTxt,
				items:[{
					xtype:'container',
					margin:'10 0 0 0',
					html:'<div id="pieChartId"></div>',
					listeners:
					{
						'boxready':function()
						{
							var chartObj = {};
							chartObj = jQuery.extend(true, {}, getHighChartsBarInstance('pieChartId',pieObj.chartHeight,pieObj.chartWidth), chartObj);
							chartObj.setData(pieObj,'<%=currentDateFormat%>','');
							chartObj.drawChart();
						}
					}
				}]
			});

			var barObj = graphData.barObj;
			resultContainerObj.add(
			{
				xtype:'panel',
				//cls:'datapanel',
				ui:'newGraphPanel',
				height:350,
				columnWidth:0.5,
				title:top_userTxt,
				items:[{
					xtype:'container',
					margin:'10 0 0 0',
					html:'<div id="barChartId"></div>',
					listeners:
					{
						'boxready':function()
						{
							var chartObj = {};
							chartObj = jQuery.extend(true, {}, getHighChartsBarInstance('barChartId',barObj.chartHeight,barObj.chartWidth), chartObj);
							chartObj.setData(barObj,'<%=currentDateFormat%>','');
							chartObj.drawChart();
						}
					}
				}]
			});
		}
	},
	loadGrid:function(jsondata)
	{
		if(jsondata!=undefined)
		{
			var idleTimeLimit = appConstants.publicJsonData.selectedFields.idleTimeLimit;
			var resultContainerObj=Ext.getCmp('resultContainer');
			var col = jsondata.gridCol;
			var data = jsondata.gridData;
			var mainColArray=new Array();
			var fieldsToStore=new Array();
			for (var key in col)
			{
				var align = 'left';
				var mainColumn = col[key];
				var minWidth=100;
				if(key == 'HIGHIDLESESSION')
				{
					minWidth=190;
				}
				if(key == 'TOTAL_SESSION'|| key == 'HIGHIDLESESSION' || key == 'PCT_IDLE_TIME')
				{
					align = 'center';
				}
				fieldsToStore.push(key);
				mainColArray.push({
					header: mainColumn,
					sortable: true,
					resizable :true,
					flex:1.0,
					minWidth:minWidth,
					align:align,
					dataIndex: key,
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qtip="' + value + '"';
						if(value=='iconUserHighIdleTime16')
						{
							value = '<div class="iconUserHighIdleTime16" style="margin-top:2px">&nbsp;&nbsp;&nbsp;</div>';
							metaData.tdAttr = 'data-qtip="High Idle User"';
						}
						return value;
					},
					doSort: function(state) 
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						if(field=='IDLE_TIMEUI')
						{
							field = 'IDLE_TIME';
						}
						if(field=='ACTIVETIMEUI')
						{
							field = 'ACTIVETIME';
						}
						if(field=='DURATIONUI')
						{
							field = 'DURATION';
						}
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));
									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}
								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
				});
				if(key == 'ICON')
				{
					mainColArray[mainColArray.length-1].maxWidth = 36;
				}
			}
			for(var key in data[0])
			{
				if(fieldsToStore.indexOf(key)==-1)
				{
					fieldsToStore.push(key);
				}
			}
			var isPagingHidden=false;
			var gridPageSize=10;
			if (data!=undefined && data.length<=gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj=Ext.create('Ext.data.Store', {
				fields:fieldsToStore,
				proxy: {
					type: 'pagingmemory',
					reader: {
						type: 'json', root : 'data', totalProperty : 'total'
					},
					data : data,
				},
				sorters: { property: fieldsToStore[7], direction : 'ASC' },
				pageSize:gridPageSize,
				autoLoad : true,
				remoteSort:true
			});
			var activePage=1;
			resultContainerObj.add(
			{
				xtype:'customgrid',
				store:storeObj,
				title:user_summary,
				margin:'10 0 0 0',
				padding:'0 10 10 10',
				columnWidth:1.0,
				sortableColumns:true,
				ui:'newGridPanel withHeader',
				border:true,
				id:'vengat',
				columns:mainColArray,
				bodyStyle:
				{
					'border-width':'1px !important',
					'border-bottom':'0px'
				},
				header:
				{
					style:'padding:3px 5px 5px 0px'
				},
				scroll:true,
 				autoScroll:true,
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: {
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params))
								activePage = params.currentPage;
							else
								activePage=1;
						}
					}
				}]
			});
		}
	},
	showResult:function(obj)
	{
		var reportGeneration;
		if (isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background-csv'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV&isBackgroundCSV=Yes",this.getQueryString(true,true,true));
		}
		else if(reportGeneration == 'background' && this.validateMainForm(true)){
			this.getAjaxDataForSubmit(this.backgroundControllerUrl,this.getQueryString(true,true,true));
		}
	},
	/* onWeekendChange:function(obj){
 		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(obj.getValue() == 'Yes')
		{
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
		}
		else
			excludeDaysObj.hide();
	}, */
	disableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		Ext.getCmp("csvTool").setDisabled(false);
	},
	hideResults:function()
	{
		Ext.getCmp('resultContainer').hide();
		Ext.getCmp('backGroundPanel').hide();
		this.getNomeasurepanel().hide();
	},
	onChangeReportGeneration:function(obj)
	{
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	getAjaxData:function(url,query)
	{
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			async:false,
			scope:this,
			success: function(response)
			{
				appConstants.publicJsonData=Ext.decode(response.responseText);
			}
		});
	},
	getAjaxDataForSubmit:function(url,query)
	{
		var me=this;
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			scope:this,
			success: function(response)
			{
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadReportData();
			}
		});
	},
	getQueryString:function(isCompType,isOthers,isSettings)
	{
		var queryString;
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname;
		var idleTimeLimit = appConstants.publicJsonData.selectedFields.idleTimeLimit;
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
			idleTimeLimit = Ext.getCmp('idleTimeLimit').getValue();
 		}
		else
		{
			var selectedFields=appConstants.publicJsonData.selectedFields;
			timefrom=selectedFields.selectedTimeFrom;
			minfrom=selectedFields.selectedMinsFrom;
			timeto=selectedFields.selectedTimeTo;
			minto=selectedFields.selectedMinsTo;
			er_excwe=selectedFields.excludeWeekendsSelected;
			reportGeneration=selectedFields.reportGenerationSelected;
			bg_reportname=selectedFields.reportNameSelected;
 		}
		var er_option=Ext.getCmp('er_option').getValue();
		if (er_option!='Component')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		queryString+='&er_compType='+Ext.getCmp('er_compType').getValue()+'&er_option='+er_option;
		if(!Ext.getCmp('er_info').isHidden())
		{
			queryString+='&er_info='+Ext.getCmp('er_info').getValue();
		}

		if (isSettings)
		{
			var startDateConverted = Ext.getCmp('er_stdate').dataArray;
			var endDateConverted = Ext.getCmp('er_enddate').dataArray;
			var stHr=Ext.getCmp('er_sthr').dataArray;
			
			queryString+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			queryString+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
			queryString+="&er_excwe="+er_excwe;
			queryString+='&idleTimeLimit='+idleTimeLimit;
			var queryArray=new Array();
					
 			if (reportGeneration == 'foreground') 
			{
 				queryString+="&er_reportgenration="+reportGeneration+"&isSubmit=true&responseType=json";
			} 
			else
			{
				bg_reportname=checkFileName(bg_reportname);
				queryString+="&er_reportgenration="+reportGeneration+"&bg_reportname="+bg_reportname+"&isSubmit=true";
			}			
		}
		if (isOthers)
		{
			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
					{
						if(hiddenField!=undefined && hiddenField=='ID')
						{
							continue;
						}
						if(hiddenField!=undefined && hiddenField=='FavoriteId')
						{
							continue;
						}
					}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&chartType="+appConstants.chartType;

		if (isOthers)
		{
			var queryArray=new Array();
			queryArray=Ext.getCmp('er_component').getValue();
			for (var key in queryArray)
			{
				queryString+="&er_component="+queryArray[key];
			}
		}
		return queryString;
	},

	boxready:function()
	{
		registerAjaxEvents();	//this method is included in ErTracker.jsp
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);
		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if(appConstants.frmSchModify!=undefined && appConstants.frmSchModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isSubmit=="true")
			{
				this.loadReportData(appConstants.publicjsonData);
			}
		}
 	},
	loadForm:function()
	{
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes")
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var date=appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component=Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray=date;
		date=appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component=Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray=date;
	
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray=appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray=appConstants.publicJsonData.selectedFields.endHour;
		stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
		enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
		mgr_stmin=appConstants.publicJsonData.selectedFields.startmin;
		mgr_enmin=appConstants.publicJsonData.selectedFields.endmin;
 	},
	loadFormFields:function()
	{
		this.loadComboField('er_option','analysisByCombo','reportTypeLabel','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_timeline','timelineCombo','','selectedTimeline',appConstants.publicJsonData,false,null,false);
		this.loadComboField('er_compType','componentTypeCombo','componentTypeLabel','componentTypeSelected',appConstants.publicJsonData,false,null,true);
		this.loadComponentInfo();
	},
	loadSettings:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		this.loadComboField('er_excwe','excludeWeekendsCombo','excludeWeekendsLabel','excludeWeekendsSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
		
		var selectedFields=appConstants.publicJsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
 		Ext.getCmp('idleTimeLimit').setValue(selectedFields.idleTimeLimit);
		Ext.getCmp('idleTimeLimit').setFieldLabel(appConstants.publicJsonData.labelFields.idleTimeLimitLabel);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		selectedFields =null;delete selectedFields;
	},
	showConfigDropdown:function()
	{
		Ext.widget('configform');
		isSettingsEnabled = true;
 		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
  			thisController.validateAndCloseSettings();
 		});
 	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
  						component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
 				else
					component.setValue(rawData[0].valueField);
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function(){
 		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false, true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag)
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: alert_text,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Active-Idle User','Please choose Component Type');
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
				this.getMessageBox('Active-Idle User','Please choose Components');
				return false;
		}
		if (reportgen == 'foreground')
		{
			if(flag)
			{
				var limitforbg = hiddenFields.limitforbg;
				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		var objAry=obj.getValue();
		if(objAry.length>1 && (objAry.indexOf('All')>-1 || objAry.indexOf('all')>-1))
		{
			this.getMessageBox(alert_text,all_singleErrTxt);
			return false;
		}
		return true;
	},
	validateMainFormForFavAndSch:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: alert_text,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox('Active-Idle User','Please choose Component Type');
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
				this.getMessageBox('Active-Idle User','Please choose Components');
				return false;
		}
		return true;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,this.getQueryString(true,true,true));
			//this.doUpdate(true,false);
		}			
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv' )){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});