Ext.define('BTMSnapshot.view.ResultPanel',{
	extend:'Ext.panel.Panel',
	alias:'widget.resultpanel',
	id: 'resultContainer',
	ui:'newGraphPanel',
	margin:10,
	layout:{
		type:'vbox',
		align:'stretch',
	},
	flex:1,
	border:true,
	hidden: true,
	items:[{
		xtype:'container',
		//height:50,
		margin:'6 10 0 10',
		cls:'selectedCheckValueContainer',
		id:'selectedCheckValueId',
		hidden:true
	},
	{
		xtype:'container',
		id:'filterWithGridContainer',
		flex:1,
		layout:{
			type:'hbox',
			align:'stretch',
		},
		items:[{
			xtype:'filterpanel',
		},
		{
			xtype:'panel',
			id:'resultDataPanel',
			scroll:false,
			margin:'10 0 10 0',
			autoScroll:true,
			flex:1,
			items:[{
				xtype:'container',
				columnWidth:1.0,
				layout:'column',
				cls:'summaryBox',
				id:'summaryPanel',
				hidden:true,
				items:[
				{
					xtype:'container',
					columnWidth:0.13,
					cls:'summaryChild',
					id:'totalHtmlId',
					html:'',
				},
				{
					xtype:'container',
					columnWidth:0.27,
					cls:'summaryChild',
					id:'userExpId',
					html:'',
				},
				{
					xtype:'container',
					columnWidth:0.17,
					cls:'summaryChild',
					id:'avgResponseId',
					html:'',
				},
				{
					xtype:'container',
					columnWidth:0.18,
					cls:'summaryChild',
					id:'uniqueTransId',
					html:'',
				},
				{
					xtype:'container',
					columnWidth:0.11,
					cls:'summaryChild',
					id:'executionTimeCountId',
					html:'',
				},
				{
					xtype:'container',
					columnWidth:0.14,
					cls:'summaryChild',
					id:'avgExecutionTimeId',
					style:
					{
						'border-right':'0px'
					},
					html:'',
				},
				{
					xtype:'container',
					columnWidth:1.0,
					margin:'5 0 0 0',
					hidden:true,
					id:'infoBtn',
					html:'<div><span class="iconInfoCircle" style="padding:0px 8px"></span><span style="font-size:11px;">&nbsp;The total number of SQLs for the Top N transactions that are captured and available in Detailed Diagnosis.</span></div>',
				}]
			},
			{
				xtype:'panel',
				id:'BTMgrid',
				padding:'0 0 0 0',
				columnWidth:1.0,
				items:
				[{
					xtype:'container',
					id:'gridContainerId'
				}]
			},
			{
				xtype:'container',
				columnWidth:1.0,
				margin:'5 0 0 10',
				//hidden:true,
				id:'infoBtn_below',
				html:'<div><span class="iconInfoCircle" style="padding:0px 8px"></span><span style="font-size:11px;">&nbsp;The total number of SQLs for the Top N transactions that are captured and available in Detailed Diagnosis.</span></div>',
			}]
		},
		{
			xtype:'panel',
			id:'appNoMespanel',
			hidden:false,
			scroll:false,
			margin:'0 0 10 0',
			autoScroll:true,
			flex:1,
			margin:10,
			html: '<table align="center" valign="middle" height="100%"><tr><td><table style="font-size:11px" align="center" valign="middle">'
			+'<tr><td style="padding-left:160px;" colspan="2" align="left"><div class="iconInformation"></div></td></tr>'
			+'<tr><td colspan="2"><table style="font-size:13px"><tr><td><div style="border: 1px solid #000000;padding:3px;border-radius: 4px;height:6px;width:6px;"></div></td><td>&nbsp;There are no records available to display for your selection. Here are the possible reasons.</td></tr></table></td></tr>'
			+'<tr><td align="left" width="35px" style="padding-top:5px;"><div style="background-color:#000000;height:6px;width:6px;margin-left:20px"></div></td><td style="padding-top:5px;">There may be no data set available for your selection combination</td></tr>'
			+'<tr><td align="left" width="35px" style="padding-top:5px;"><div style="background-color:#000000;height:6px;width:6px;margin-left:20px"></div></td><td style="padding-top:5px;">The time range you have selected could be out of data retention period</td></tr>'
			+'<tr><td align="left" width="35px" style="padding-top:5px;"><div style="background-color:#000000;height:6px;width:6px;margin-left:20px"></div></td><td style="padding-top:5px;">Detailed Diagnosis Data could have been purged.</td></tr></table></td></tr>'
			+'</td></tr></table>'
			+'</table>',
		}]
	},
	{
		xtype:'container',
		id:'filterAllContainer',
		hidden:true,
		margin:'10 10 10 0',
		flex:1,
		layout:{
			type:'hbox',
			align:'stretch',
		},
		items:[{
			xtype:'container',
			margin:'0 0 0 0',
			layout:{
				type:'vbox',
				align:'auto'
			},
			id:'groupHeadLeft',
			cls:'checkGroupsHeaderButtonOuter',
			width:220,
			listeners:
			{
				afterrender:function(panel)
				{
					var getgridHeight;
					Ext.defer(function(){
						getgridHeight = Ext.getCmp('resultDataPanel').getHeight();
						panel.setHeight(getgridHeight);
					},100);
				}
			}
		},
		{
			xtype:'panel',
			id:'showAllView',
			flex:1,
			hidden:false,
			layout:
			{
				type:'vbox',
				align:'stretch'
			},
			ui:'plain',
			margin:'0 0 0 -12',
			cls:'checkGroupFilterList',
			items:[
			{
				xtype:'container',
				border:true,
				margin:'5 15 0 15',
				padding:'10 0 8 0',
				cls:'searchDivBorder',
				layout:{
					type:'column',
					align:'stretch'
				},
				items:[
					{
						xtype:'trigger',
					//	style:{'float':'right'},
						cls: 'whitedropdown_search_big',
						emptyText:'Search',
						id : 'filterSearchBox',
						name : 'filterSearchBox',
						hideLabel:true,
						width:300,
						labelAlign : 'left',
						margin:'0 15 0 0',
						enableKeyEvents: true,
						onTriggerClick : function(e){
							this.fireEvent('click',this);
						}

					},{
						xtype:'container',
						flex:1,
						style:{
							'float':'right'
						},
						items:[{
							xtype:'button',
							margin:'10 0 10 0',
							style:{
								'background':'none',
								'border':'0px',
							},
							iconCls:'iconCloseNew',
							handler:function()
							{
								Ext.getCmp('filterWithGridContainer').show();
								Ext.getCmp('filterAllContainer').hide();
							}
						}],
					}
				]
			},
			{
				xtype:'dataview',
				margin:10,
				id:'allFilterContainerData',
				dummyArray:null,
				store:Ext.data.Store({
					model:checkBoxDataModel,
					data:[],
				}),
				flex:1,
				layout:{
					type:'fit',
					align:'stretch'
				},
				height:'100%',
				autoScroll:true,
				tpl : new Ext.XTemplate(
					'<tpl for=".">',
						'<tpl for="child">',
							'<tpl if="parent.id == \'URI\'">',
								'<div style="padding:2px;width:100%;float:left;white-space:nowrap;overflow:hidden; text-overflow:ellipsis;" data-qtip="{value}" data-qclass="yellowTip">',
									'<label class="checkLabel"><input class="htmlCheckbox12" type="checkbox"  name="input" onclick=\'javascript:MaxViewfilterEventsChange("{value}","{parent.id}");\' <tpl if="isChecked">checked</tpl> value="{value}"/><span>{name}</span> </label>',
								'</div>',
							'<tpl else>',
								'<div style="padding:2px;width:260px;float:left;white-space:nowrap;overflow:hidden; text-overflow:ellipsis;" data-qtip="{value}" data-qclass="yellowTip">',
									'<label class="checkLabel"><input class="htmlCheckbox12" type="checkbox"  name="input" onclick=\'javascript:MaxViewfilterEventsChange("{value}","{parent.id}");\' <tpl if="isChecked">checked</tpl> value="{value}"/><span>{name}</span> </label>',
								'</div>',
							'</tpl>',
						'</tpl>',
					'</tpl>'
				)
			}],
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				margin:'5 15 0 15',
				padding:'10 0 8 0',
				ui:'plain',
				//align:'center',
				items:[
					{ xtype: 'tbfill' },{
						xtype:'button',
						text:'Apply',
						ui:'newButtonSmall',
						id:'applyFilter',
						name:'applyFilter',
						padding:5,
						margin:'0 10 0 0',
					},{
						xtype:'button',
						ui:'newButtonSmall',
						padding:5,
						id:'cancelFilter',
						name:'cancelFilter',
						text:'Cancel'
					} ,{ xtype: 'tbfill' }
				]
			}]
		}]
	}]
		
	
 });
