
Ext.define('BTMTopNApp.controller.BTMReportsController',{
	extend:'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'BTMReportsForm',ref: 'BTMReportsForm'},
		{selector: 'egcomponent',ref: 'egcomponent'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'BTMReportsFormSettings',ref: 'BTMReportsFormSettings'},
		{selector: 'reporterdata',ref:'reporterdata'},
 		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'utilitiestool':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
           	'BTMReportsFormSettings':{
				'afterrender':this.loadSettingsElements
            },
			'utilitiestool > #printTool > button':
			{
				'click':this.printReport
			},
			'utilitiestool > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'utilitiestool > #mailTool > button':{
					'click':this.sendMail
			},
			'utilitiestool > #csvTool > button':{
					'click':this.saveCsv
			},
			'utilitiestool > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'utilitiestool > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
				'select': this.changeEr_mode
			},
			'mainform multiselectfield[name="select_farm"]':{
				'change': this.zoneOnChange
			},
			'mainform combo[name="rep_genType"]':{
				'select': this.Changerep_genType
			},
			'mainform combo[name="er_type"]':{
				'select': this.reportTypeOnChange
			},
			'mainform combo[name="er_graphType"]':{
				'select': this.graphTypeOnChange
			},
			'mainform multiselect[name="er_server"]':{
				'select': this.serverOnChange
			},
			'mainform button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'mainform combo[name="er_compType"]':{
				'select': this.compTypeOnChange
			},
			'mainform combo[name="er_wrkrGrp"]':{
				'select': this.workerGroupOnChange
			},
			'BTMReportsFormSettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},
			'BTMReportsFormSettings combo[name="er_timeline"]':{
				//'select': this.timeLineOnChange
			},
			'BTMReportsFormSettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'BTMReportsForm button[itemId="submit"]':{
				'click': this.showResult
			},
			'mainform button[itemId="save"]': {
					"click": this.goTo
			},
			'mainform combo[name="er_organize"]':{
				'select': this.organizeOnChange
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform combo[name="er_application"]':{
				'select': this.applicationOnChange
			}
		});
	},
		Changerep_genType:function(obj)
	{
			appConstants.erGraphType=obj.getValue();
			if(!Ext.isEmpty(appConstants.publicjsonDataActivity))
				this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
	},
	goTo: function (btn) {
 		var reportCat=Ext.getCmp('report_category').getValue();
		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite(btn);
		}
    },
	applicationOnChange : function() {
		var mainForm =Ext.getCmp('mainform').getForm();
		var userSelected = Ext.getCmp("er_application").getValue();
		if (userSelected == '-- All --')
		{
			appConstants.isAllUserSelected = true;
			var comboRawData=appConstants.publicjsonDataUsage.organizeCombo;
			var selectedComboOption=appConstants.publicjsonDataUsage.selectedOrganizeby;
			var comboObject=mainForm.findField('er_organize');
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			//if(jsonData.selectedUser == '--All--'){
					comboObject.show();
		} else {
			mainForm.findField('er_organize').hide();
		}
	},
	 changeEr_mode: function (combo) {
		var favorite_id='';
		var from_schModify='';
		var reportCat=Ext.getCmp('report_category').getValue();

		
			favorite_id = appConstants.publicjsonDataActivity['hiddens']["favorite_id"];
			from_schModify = appConstants.publicjsonDataActivity['hiddens']["fromScheduleModify"];
		

		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();

	   appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_server'),appConstants.rawDataForComponents);
    },
	organizeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	compTypeOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		
				urlForAjax="/final/reporter/ErBTMTopNReportJson.jsp";
			
		
			urlForAjax=urlForAjax+"?&er_comptype="+mainForm.findField("er_compType").getValue();
			this.updateQStringActivity();
			Ext.Ajax.request(
			{
				url : urlForAjax,
				params : appConstants.queryStringActivity,
				scope:this,
				method : 'GET',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var screenLabels=jsonData.screenLabels;
					appConstants.publicjsonDataActivity=jsonData
					if(mainForm.findField('er_type').getValue() == 'No'){
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						comboObject=Ext.getCmp('er_server');
						appConstants.rawDataForComponents = comboRawData;
						comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							else
								comboObject.setValue(comboRawData[1].valueField);
								}
						comboRawData=jsonData.userCombo;
						selectedComboOption=jsonData.selectedUser;
						comboObject=mainForm.findField('er_application');
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
					{
						
						
						var screnVal=screenLabels['reporter.thin.User'];
						if(appConstants.er_rep!='null')
							screnVal=appConstants.er_rep;
						comboObject.setFieldLabel(screnVal);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							if(comboRawData[0].valueField!=-1)
								comboObject.setValue(comboRawData[0].valueField);
							else
								comboObject.setValue(comboRawData[1].valueField); //added for components not auto select when change component type
						}
						comboObject.show();

					}
				else
					{
						Ext.getCmp('er_application').hide();
					
					}

							Ext.getCmp('serverMultiSelectLbl').show();
					}else{
						if(!isSettingsEnabled)
							this.showConfigDropdown();
					var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
					var graphval=jsonData.selectedGraphType;
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
							comboObject.show();
						if (graphval == "timeline") {
				                        comboRawData = jsonData.aggbasedOn;
				                        selectedComboOption = jsonData.selectedAgg;
				                        comboObject = thinclientuserSettingsForm.findField("er_perserver");
				                        comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
				                        comboObject.getStore().loadRawData(comboRawData);
				                        if (!Ext.isEmpty(selectedComboOption)) {
				                            comboObject.setValue(selectedComboOption);
				                        } else {
				                            comboObject.setValue(comboRawData[0].valueField);
				                        }
				                        comboObject.show();
				                        comboRawData = jsonData.userCombo;
				                        selectedComboOption = jsonData.selectedUser;
				                        comboObject = mainForm.findField("er_application");
								if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
									{
										
										var screnVal=screenLabels['reporter.thin.User'];
										if(appConstants.er_rep!='null')
											screnVal=appConstants.er_rep;
				                        comboObject.setFieldLabel(screnVal);
				                        comboObject.getStore().loadRawData(comboRawData);
				                        if (!Ext.isEmpty(selectedComboOption)) {
				                            comboObject.setValue(selectedComboOption);
				                        } else {
											comboObject.setValue(comboRawData[0].valueField);
										}
										comboObject.show();
									}
										
								else
									{
									Ext.getCmp('er_application').hide();
									
									}

					}else{
					
						if(Ext.getCmp("er_perserver")!=undefined)
							Ext.getCmp('er_perserver').hide();
						Ext.getCmp('er_application').hide();
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.selectedMeasure;
						comboObject = mainForm.findField("select_testmes");
						comboObject.setFieldLabel(screenLabels["reporter.thin.Measure"]);
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							if (comboRawData.length > 1 && comboRawData[0].valueField != "notapplicable") {
								comboObject.setValue(comboRawData[1].valueField);
							}else{
								comboObject.setValue(comboRawData[0].valueField);
							}
						}
						comboObject.show();
					
					}
					}
				}
			});
		
	},
	workerGroupOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
		
	},
	zoneOnChange:function(){
	
	if(appConstants.isLoad)
	{
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var reportCat=mainForm.findField('report_category').getValue();
		var urlForAjax;
	
			urlForAjax="/final/reporter/ErBTMTopNReportJson.jsp";
		
		var QString="";
		
			if(mainForm.findField('er_type').getValue() == 'No' || mainForm.findField('er_type').getValue() == 'Yes'){			
				var serverArray;
				var select_farmVal=Ext.getCmp('select_farm').getValue();				
						QString+="&select_farm="+select_farmVal;
					
				
				QString+="&er_type="+mainForm.findField("er_type").getValue();
				if(appConstants.isreportsneedService!="null")
						QString+="&isreportsneedService="+appConstants.isreportsneedService;
				if(appConstants.componenttest!="null")
						QString+="&componenttest="+appConstants.componenttest;
				if(appConstants.er_rep!="null")
						QString+="&er_rep="+appConstants.er_rep;
			}
			else{
				//urlForAjax="/final/reporter/ErBTMTopNReportJson.jsp";
				this.updateQStringActivity();
				QString=appConstants.queryStringActivity;
			}
 		
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'GET',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					var screenLabels=jsonData.screenLabels;				
					appConstants.publicjsonDataActivity=jsonData
					if(mainForm.findField('er_type').getValue() == 'No' || mainForm.findField('er_type').getValue() == 'Yes'){
						comboRawData=jsonData.serverCombo;
						selectedComboOption=jsonData.selectedServer;
						comboObject=Ext.getCmp('er_server');
						//comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						
						comboRawData=jsonData.userCombo;
						selectedComboOption=jsonData.selectedUser;
						comboObject=mainForm.findField('er_application');
					if((comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined') || appConstants.isreportsneedService!="null" && mainForm.findField('er_type').getValue() == 'No')
					{
						
						var screnVal=screenLabels['reporter.thin.User'];
						if(appConstants.er_rep!='null')
							screnVal=appConstants.er_rep;
						comboObject.setFieldLabel(screnVal);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
								
				/*	else
					{
						Ext.getCmp('er_application').hide();
						var textBoxObject=	mainForm.findField('er_application_text_box');
						textBoxObject.show();
					}*/

						Ext.getCmp('serverMultiSelectLbl').show();
						
					}
					comboRawData=jsonData.compTypeCombo;
					selectedComboOption=jsonData.selectedCompType;
					comboObject=mainForm.findField('er_compType');
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
				
				}
			}
		});
		}else
			appConstants.isLoad=true;
	},
	 expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('compLbl').text,btn);
	},
	serverOnChange:function(){
		Ext.getCmp('resultPanel').hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
		var s_server=Ext.getCmp('er_server').getValue();
		var s_repType=mainForm.findField('er_type').getValue();
		if(s_repType!=null && s_repType!=undefined && s_repType=='No'){
			this.updateQStringActivity();
			var url1="";
				url1="/final/reporter/ErBTMTopNReportJson.jsp";
			
			
			
			Ext.Ajax.request(
			{
				url : url1,
				params : appConstants.queryStringActivity,
				scope:this,
				method : 'POST',
				success: function(response){

					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
				if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
				{
					
					var screnVal=jsonData.screenLabels['reporter.thin.User'];
						if(appConstants.er_rep!='null')
							screnVal=appConstants.er_rep;
					comboObject.setFieldLabel(screnVal);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					} else {
						if(comboRawData[0].valueField!=-1)
							comboObject.setValue(comboRawData[0].valueField);
						else
							comboObject.setValue(comboRawData[1].valueField); //added for components not auto select
					}
					comboObject.show();
				}
				else
				{
						Ext.getCmp('er_application').hide();
						
				}

					if(s_server!=null && s_server!=undefined && s_server.length>1) {
						comboRawData=jsonData.aggAcrossServer;
						selectedComboOption=jsonData.selectedAggServer;
						comboObject=thinclientuserSettingsForm.findField('er_perserver');
						comboObject.setFieldLabel(jsonData.screenLabels['reporter.thin.Aggregate across servers on']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
				}
			});
		}else{
			if(Ext.getCmp("er_perserver")!=undefined)
				Ext.getCmp('er_perserver').hide();
		}
	},
	graphTypeOnChange:function(obj){
		var val=obj.getValue();
		
		if(val=='timeline')
		{
			Ext.getCmp('showLegend').show();
		}
		else
		{
			Ext.getCmp('showLegend').show();
		}

		Ext.getCmp('resultPanel').hide();
		this.updateQStringActivity();
		var url1="";
		
				url1="/final/reporter/ErBTMTopNReportJson.jsp";
		
		
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				if(!isSettingsEnabled)
					this.showConfigDropdown();
				var mainForm =Ext.getCmp('mainform').getForm();
				var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
				if(val == 'timeline'){
					Ext.getCmp('select_testmes').hide();
					appConstants.publicjsonDataActivity=jsonData;
					comboRawData=jsonData.aggbasedOn;
					selectedComboOption=jsonData.selectedAgg;
					comboObject=thinclientuserSettingsForm.findField('er_perserver');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Aggregate across servers']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
						var screnVal=screenLabels['reporter.thin.User'];
						if(appConstants.er_rep!='null')
							screnVal=appConstants.er_rep;
						comboObject.setFieldLabel(screnVal);
					//comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
					comboObject.getStore().loadRawData(comboRawData);
					
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
				}else{
					mainForm.findField('select_testmes').setFieldLabel(screenLabels['reporter.thin.Measure']);
					Ext.getCmp('select_testmes').show();
					Ext.getCmp('showLegend').hide();
					if(Ext.getCmp("er_perserver")!=undefined)
						Ext.getCmp('er_perserver').hide();
					Ext.getCmp('er_application').hide();
				}
			}
		});
	},
	reportTypeOnChange:function(obj){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('showLegend').hide();
		var val=obj.getValue();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
        this.updateQStringActivity();
		var urlStr="";
		Ext.getCmp('er_sortby').hide();
			urlStr="/final/reporter/ErBTMTopNReportJson.jsp";
		
			
		var url = urlStr+"?er_type="+mainForm.findField("er_type").getValue();
		if(val == 'Yes'){
		
		
			url+="&graphViewtype="+mainForm.findField('er_graphType').getValue();
		
       		}else{	
			url += "&er_comptype=" + mainForm.findField('er_compType').getValue();
		}
		Ext.Ajax.request(
		{
			url : url,
            		params: appConstants.queryStringActivity,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var screenLabels=jsonData.screenLabels;
				appConstants.publicjsonDataActivity=jsonData;
				if(val == 'No'){
					mainForm.findField("select_testmes").hide();
					mainForm.findField('er_mode').hide();
					//mainForm.findField('er_graphType').hide();
					comboRawData=jsonData.serverCombo;
					selectedComboOption=jsonData.selectedServer;
					comboObject=Ext.getCmp('er_server');
					multiServerObject=Ext.getCmp('expandSelector');
					appConstants.rawDataForComponents = comboRawData;
//					comboObject.setFieldLabel(screenLabels['reporter.common.Server']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					multiServerObject.show();
					comboObject.show();

					if(selectedComboOption !=null  && selectedComboOption.indexOf("All ")>-1)
						thinclientuserSettingsForm.findField('er_perserver').show();
			
					comboRawData=jsonData.userCombo;
					selectedComboOption=jsonData.selectedUser;
					comboObject=mainForm.findField('er_application');
					if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
					{
						
							var screnVal=screenLabels['reporter.thin.User'];
							if(appConstants.er_rep!='null')
								screnVal=appConstants.er_rep;
							comboObject.setFieldLabel(screnVal);
						//comboObject.setFieldLabel(screenLabels['reporter.thin.User']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboObject.show();
					}
					else
					{
							Ext.getCmp('er_application').hide();
							
					}
				
				
					Ext.getCmp('serverMultiSelectLbl').show();
					//if(!(val=="No"))
					{	
				
						comboRawData=jsonData.priorityCombo;
						selectedComboOption=jsonData.selectedPriority;
						comboObject=mainForm.findField('er_priority');
						comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						}
						else{
							comboObject.setValue(comboRawData[2].valueField);
						}
						
						comboObject.show();
					}
					/*else
					{
						comboObject=mainForm.findField('er_priority');
						comboObject.hide();
					}*/
					
				}
				else{
					//Ext.getCmp('er_server').hide();
					//mainForm.findField('er_priority').hide();
					mainForm.findField('er_application').hide();
					thinclientuserSettingsForm.findField('er_perserver').hide();
					mainForm.findField('er_mode').hide();
					//mainForm.findField('er_graphType').show();
					//mainForm.findField('select_testmes').show();


					var graphval=jsonData.selectedGraphType;
				//	if(graphval == 'timeline'){
					comboRawData = jsonData.graphTypeArray;
					selectedComboOption = jsonData.selectedGraphType;
					comboObject = mainForm.findField("er_graphType");
					comboObject.setFieldLabel(screenLabels["reporter.thin.Graph Type"]);
						comboObject.getStore().loadRawData(comboRawData);
						if ( !Ext.isEmpty(selectedComboOption) ){
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						
							//comboObject.show();
							comboRawData = jsonData.measureCombo;
							if(!Ext.isEmpty(comboRawData))
							{
							selectedComboOption = jsonData.selectedMeasure;
							comboObject = mainForm.findField("select_testmes");
							comboObject.setFieldLabel(screenLabels["reporter.thin.Measure"]);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								if (comboRawData.length > 1 && comboRawData[0].valueField != "notapplicable") {
									comboObject.setValue(comboRawData[1].valueField);
								}else{
									comboObject.setValue(comboRawData[0].valueField);
								}
							}
							comboObject.show();
						}
						
						//if(!(val=="No"))
						{						
							comboRawData=jsonData.priorityCombo;
			
							selectedComboOption=jsonData.selectedPriority;
							comboObject=mainForm.findField('er_priority');
							comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
							if(!Ext.isEmpty(comboRawData))
							{
								comboObject.getStore().loadRawData(comboRawData);
								if ( !Ext.isEmpty(selectedComboOption) ){
									comboObject.setValue(selectedComboOption);
								}
								else{
									comboObject.setValue(comboRawData[0].valueField);
								}
								
								comboObject.show();
							}
						}
						/*else
						{
							comboObject=mainForm.findField('er_priority');
							comboObject.hide();
						}*/

						if (graphval == "timeline") {
							comboRawData = jsonData.aggbasedOn;
							selectedComboOption = jsonData.selectedAgg;
							comboObject = thinclientuserSettingsForm.findField("er_perserver");
							comboObject.setFieldLabel(screenLabels["reporter.thin.Aggregate across servers"]);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.show();
							comboRawData = jsonData.userCombo;
							selectedComboOption = jsonData.selectedUser;
							comboObject = mainForm.findField("er_application");
					if(comboRawData!=null && comboRawData!=undefined && comboRawData!='undefined')
						{
							
								var screnVal=screenLabels['reporter.thin.User'];
						if(appConstants.er_rep!='null')
							screnVal=appConstants.er_rep;
						comboObject.setFieldLabel(screnVal);
						//	comboObject.setFieldLabel(screenLabels["reporter.thin.User"]);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							comboObject.show();
						}
					else
					{
						Ext.getCmp('er_application').hide();
					
					}

							Ext.getCmp('serverMultiSelectLbl').show();
					}else{
						thinclientuserSettingsForm.findField('er_perserver').hide();
						mainForm.findField('er_application').hide();
					}
				}
				initLdgMask.hide();
			}
		});
	},

	reportCatChange:function(obj){
		initLdgMask.show();
		var value =obj.getValue();
		
		this.LoadFieldsForActivity();
		
		Ext.getCmp('resultPanel').hide();
	},
	LoadFieldsForActivity:function(){
	var url1="";
			
				url1="/final/reporter/ErBTMTopNReportJson.jsp";
			
		
		Ext.Ajax.request(
		{
			url : url1,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForActivity(jsonData);
				var mainForm =Ext.getCmp('mainform').getForm();
				mainForm.findField("er_type").hide();
				mainForm.findField("select_testmes").show();
				mainForm.findField("er_compType").show();
				//Ext.getCmp("er_type").setValue("Yes");
				mainForm.findField("er_mode").show();
				if(Ext.getCmp("sh_timeinuse")!=undefined)
					Ext.getCmp("sh_timeinuse").show();
				mainForm.findField('er_wrkrGrp').hide();
				mainForm.findField("er_application").hide();
				mainForm.findField("er_organize").hide();
				initLdgMask.hide();
			}
		});
	},
	
	
	saveReportAsPDF:function(){
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();		
			saveQString=appConstants.publicjsonDataActivity.saveQString;
			saveQString+="&printGraph=yes&opt=chart";
			if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
				saveQString+="&er_view=PRINT";
		
		
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+saveQString;
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
	  s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString;
		var reportFor = Ext.getCmp('report_category').getValue();		
		saveQString=appConstants.publicjsonDataActivity.saveQString;
		saveQString+="&printGraph=yes&opt=chart";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			saveQString+="&er_view=PRINT";
		var s_qryString = saveQString;
		s_qryString=this.getGridColSortParam(s_qryString);
		return s_qryString;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');

		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}

			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printReport:function(){

		var s_qryString;
		var reportFor = Ext.getCmp('report_category').getValue();		
		var saveQString=appConstants.publicjsonDataActivity.saveQString;		
		s_qryString = "../servlet/com.eg.ErBTMTopNReportC?"+saveQString+"printGraph=yes&pdfPrint=yes";
		if(appConstants.publicjsonDataActivity.selectedreportType == 'No')
			s_qryString+="&er_view=PRINT";
		
	  s_qryString=this.getGridColSortParam(s_qryString);

	
	 if (typeof parent.printWindowFn == "function") {
                   parent.printWindowFn(s_qryString);
                }else
				parent.parent.printWindowFn(s_qryString);
	
		/*if(Ext.isEmpty(parent.printWindowFn(s_qryString)))
			parent.parent.printWindowFn(s_qryString);*/
		//else
	},
	sendMail:function(){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		var isDrillVal=appConstants.isDrillDown;
		if(isDrillVal!="null")
			window.location='../servlet/egurkha.reporter.SaveInCSVFormat?isDrillDown='+isDrillVal;
		else
			window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	
	},
	saveSchedule:function(btn){
		var report_cat = Ext.getCmp('report_category').getValue();
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
			var s_qryString;
			
				this.updateQStringActivity();
				
					s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;
				
			
			
			var target=s_qryString;
			if (btn.getItemId()=='save')
				document.location=target+'&showSchWindow=no';
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Thin Client Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		}
		if(isValid){
			var s_qryString;
		
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringActivity();
				
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity+"&cmd=client";
				
			
			
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName;//+"&FavoriteId="+favorite_id;
			
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm =null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
		var zone=mainForm.findField('select_farm')
		var reporFor=mainForm.findField('report_category').getValue();
		var reportType=mainForm.findField('er_type').getValue();
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Thin Client User',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		if(reporFor == 'RUM'){
			var compType=mainForm.findField('er_compType');
				if( compType.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: compType.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			if(reportType == 'No'){
				var server=Ext.getCmp('er_server');
				var application=mainForm.findField('er_application');
				
				if( server.getValue() == '-1'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: server.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var er_sortByVal=Ext.getCmp('er_sortby').getValue();
			if(appConstants.isreportsneedService!="null")
			{				
				if(er_sortByVal==null || er_sortByVal=='undefined' || er_sortByVal=='-1'){
					Ext.MessageBox.show({
						title: 'Thin Client User',
						msg: 'Please select measure',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
				if( application.isVisible()&& application.getValue() == 'Not Applicable'){
					Ext.MessageBox.show({
					title: 'Thin Client User',
					msg: application.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				
			}else{
				var er_measure=mainForm.findField('select_testmes');
				if(er_measure.getValue()=='-1'){
				Ext.MessageBox.show({
				title:'Thin Client User',
				msg:'Please Choose Measure',
				buttons:Ext.MessageBox.OK,
				icon:Ext.MessageBox.WARNING
				});
				return false;
				}
			}
		}
		
		
		var isSettingsOk = true;

		var hiddenFields;
		hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen = this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty(hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}

		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');


		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){

			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Thin Client User settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			if(flag)
			{
				var limitforbg = hiddenFields["limitforbg"];

				if(!Ext.isEmpty(limitforbg)){
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}
				}
			}
		}
		else{
			var reportName = this.getSettingsFieldValue(thinclientuserSettingsForm,'bgReportName',isSettingsEnabled,'selectedMinsTo');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;

		/*if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}*/
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		var server=Ext.getCmp('er_server');
		var application=mainForm.findField('er_application');
		var isValid = this.validateMainForm(true);

		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;

		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes"){
 			this.submitReport();
		}else{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
			var reportGenType=thinclientuserSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientuserSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	loadGrid:function(reportData){
		var me=this;
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.show();
		if ( !Ext.isEmpty( reportData ) ){
			var gridDataArr=reportData;
			resultPanelObj.removeAll();
			me.loadDataGridtable(gridDataArr,0,gridDataArr.length);
			Ext.getCmp("csvTool").setDisabled(false);
			}else{
			
				this.disableTools();
				resultPanelObj.hide();
 				this.getNomeasurepanel().show();
				initLdgMask.hide();
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
			}
	},
	loadDataGridtable:function(gridDataArr,value,total)
	{
		var me=this;
		var resultPanelObj=Ext.getCmp('resultPanel');
	
		var itemsArray=new Array();
				
			
						var gridDataObj=gridDataArr[value];
				
				var columnDetails=gridDataObj.columns;
				var dataArraytoStore=gridDataObj.dataArray;
				var noOfColumns=gridDataObj.TOTAL_COLUMN_COUNT;
				var singleColumnCount=gridDataObj.SINGLE_SUBCOLUMN_COUNT;
				var viewPortWidth=this.getMain().getWidth();
				var COLUMN_MIN_WIDTH=55;
				var SINGLE_COLUMN_WIDTH=80;
				var SERVER_MIN_WIDTH=120;
				var count=0;
				noOfColumns+=1;// ADDED FOR HEALTH COLUMN;
				var mutipleColumns=noOfColumns-singleColumnCount;
				var widthNeeded=150+(mutipleColumns*COLUMN_MIN_WIDTH)+(singleColumnCount*SINGLE_COLUMN_WIDTH);

				var fieldstoStore =  new Array();
				var mainColumnsObjArray	=  new Array();
				var eachWidth=0;
				if(viewPortWidth>widthNeeded){
					eachWidth=(viewPortWidth-(SERVER_MIN_WIDTH))/noOfColumns;
				}
				else{
					eachWidth=COLUMN_MIN_WIDTH;
				}

				for( var key in columnDetails ){
					var mainColumn=key;
					var subColumns=new Array();
					var subColObjArray=new Array();
					subColumns=columnDetails[key];
					if(subColumns!=undefined && !Ext.isEmpty(subColumns)){
						var subColumnCount=subColumns.length;
						var adujstedWidth=eachWidth;
						if(subColumnCount == 1){
							if(eachWidth<SINGLE_COLUMN_WIDTH)
							adujstedWidth=SINGLE_COLUMN_WIDTH;
						}
						for(var j in subColumns)
						{
							var tmp=subColumns[j];
							fieldstoStore.push(mainColumn+"_"+tmp);
							subColObjArray.push({
								header: tmp,
								sortable:true,
								dataIndex: mainColumn+"_"+tmp,
								align:'center',
								width:adujstedWidth,
									doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														v1 = v1.get(field);
														v2 = v2.get(field);

														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;

														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									if(value.indexOf('~')>-1)
									{
										var text = value.substring( 0, value.indexOf('~') );
										var url = value.substring( value.indexOf('~') + 1 );
										if(text!=null && text=="top.gif")
										{
											text='<img src="/final/reporter/images/top.gif">';
										}
										value = '<a href="javascript:void(0);" onClick="javascript:openInNewWin(\''+url+'\');" >'+text+'</a>';
									}
									return value;
								}
							});
						}
						mainColumnsObjArray.push(
						{
							header: mainColumn,
							columns: subColObjArray
						});
					}
					else{
						if(count==0 || count==1){
							fieldstoStore.push(mainColumn);
							mainColumnsObjArray.push({
								header: mainColumn,
								sortable:true,
								minWidth:SERVER_MIN_WIDTH,
								dataIndex: mainColumn,
								align:'left',
								flex:1,
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									if(value.indexOf('~')>-1)
									{
										var text = value.substring( 0, value.indexOf('~') );
										var url = value.substring( value.indexOf('~') + 1 );
										if(text!=null && text=="top.gif")
										{
											text='<img src="/final/reporter/images/top.gif">';
										}

										value = '<a href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" >'+text+'</a>';
									}
									return value;
								}
							});
						}
						else{
							fieldstoStore.push(mainColumn);
							subColObjArray.push({
									header: '&nbsp',
									sortable:true,
									dataIndex: mainColumn,
									align:'center',
									width:eachWidth,
									doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														v1 = v1.get(field);
														v2 = v2.get(field);

														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;

														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
								},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										if(value.indexOf('~')>-1)
										{
											var text = value.substring( 0, value.indexOf('~') );
											var url = value.substring( value.indexOf('~') + 1 );
											if(text!=null && text=="top.gif")
											{
												text='<img src="/final/reporter/images/top.gif">';
											}
											value = '<a href="javascript:void(0);" onClick="window.location.href=\''+url+'\'" >'+text+'</a>';
										}
										return value;
									}
							});
							mainColumnsObjArray.push(
							{
								header: mainColumn,
								columns: subColObjArray
							});
						}
					}
					count++;
				}
				var fetchedData = function(){
					this.data = null;
					this.total = 0;
				}

				var isPagingHidden;
				if (dataArraytoStore.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var storeObj = Ext.create('Ext.data.Store', {
					fields: fieldstoStore,
					proxy : {
							type : 'memory',
							reader : {
								type: 'array', root : 'data', totalProperty : 'total'
							},
						},
					 sorters: [
								 {
									  property: 'User',
									  direction: 'ASC'
								 }
							],
					pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
					autoLoad : true,
					listeners : {
						beforeload : function(store, operation, eOpts){
							var page = operation.page;
							var limit = operation.limit;
							var dataArraytoStoreLen=dataArraytoStore.length;
							var start=(page-1)*limit;
							var totalRec=page*limit;
							
							fetchedData.data = dataArraytoStore.slice(start,totalRec);
							fetchedData.total =dataArraytoStoreLen;
							store.proxy.data = fetchedData;
							
							if((value+1)<total)
								me.loadDataGridtable(gridDataArr,value+1,gridDataArr.length);
						}
					}

				});
				
				var gridpanel = Ext.widget('customgrid',{
					store:storeObj,
					sortableColumns:true,
					needtoFixColumn:true,
					ui:'newGridPanel',
					//cls:'gridSkin horizontal-scroll',
					columns:mainColumnsObjArray,
					margin:'5 10 10 10',
					title:'<span class="font_bold">'+gridDataObj.gridTitle+'</span>',
					forceFit: true,
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
						},
						render:function(obj){
							Ext.defer(function() {
								obj.columns[0].setSortState("ASC",true,true);
							},100);
						}
					},
					dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'newPagination',
								dock: 'bottom',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display"
							}]

				});
				itemsArray.push(gridpanel);
				resultPanelObj.add(gridpanel);
				
	},

	loadReportData:function(jsonData){
		var itemsArray=new Array();
		var count=0;
		//var itemsArrVal=new Array();
		var itemHbVal=new Array();
		var me=this;
		var reportFor = Ext.getCmp('report_category').getValue();
 		var dataAvailable=false;
		var resultPanelObj=Ext.getCmp('resultPanel');
		if(jsonData.hasOwnProperty('reportData')){
			Ext.getCmp('panelinsidetoggle').setDisabled(false);
			var reportData=jsonData.reportData;
			if(reportFor == 'RUM'){
				resultPanelObj.removeAll();
				appConstants.publicjsonDataActivity=jsonData;
				var chartType=jsonData['chartType'];
				reportType=jsonData.selectedreportType;
					if(reportType=='Yes'){
 						var chartUrlArray =new Array();
						chartUrlArray=reportData.chartUrls;
						noOfchart=chartUrlArray.length;
						var graphType = jsonData.selectedGraphType;
					
						if(graphType == 'distribution'){
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							
						
							for(var i=0;noOfchart>i;i++){
								var url = chartUrlArray[i];
								var chartProperties=this.getXmlForUrl(url);
								if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('XML') ){
								
								
									dataAvailable=true;
									var margin;
									var flex;
									if (i==1)
									{
										margin=10;
										flex=0.65;
									}
									else
									{
										margin='10 10 10 0'
										flex=1;
									}
									var chartbox={
												xtype:'container',
												data: chartProperties,
												//flex:flex, 
												margin:margin,
												autoScroll:true,
												scroll:true,
												width:820,
 												cls:'containerShadow',
												id: 'fusion'+count
											};
											
											
											
									
										itemHbVal.push(chartbox);		
									
									count+=1;
									//itemsArray.push(chartbox);
								}
								if(i+1==noOfchart)
								{
										itemHbVal.push(chartbox);	
										var cb={
										xtype:'panel',
										title:"<span class='font_bold'>"+reportData.sub_titile+"</span>",
										margin:'5 10 10 10',
										cls:'datapanel',
										layout:{type:'vbox',align:'center'},
										//height:600,
										columnWidth:1.0,
										items:itemHbVal,										
										}
										itemsArray.push(cb);
										itemHbVal=new Array();
								}
							}
						
							if(dataAvailable)
							{				
							
									resultPanelObj.add({
										xtype:'panel',
										title:"<span class='font_bold'>"+reportData.title+"</span>",
										margin:'5 10 10 10',
										cls:'datapanel',
										layout:{type:'vbox',align:'stretch'},
										//height:400,
										columnWidth:1.0,
										items:itemsArray
									});
									resultPanelObj.show();
									if (Ext.isEmpty(appConstants.erUtils))
									{
										appConstants.erUtils = Ext.widget("erutils");
									} 
									
 									for ( var i = 0; i < count; i++ )
									{
										var containerObj=Ext.getCmp('fusion'+i);
										var data = containerObj.data;
	
											if ( !Ext.isEmpty( data ) && data.hasOwnProperty('XML') )
											{
												var innerHtml=data.innerHtml;
												var chartFor =data.chartFor;
												var chartHight =data.chartHight;

												if(chartFor =='Top')
												{
													appConstants.erUtils.updateBarChart(appConstants.chartType,data.chartTitle,data.XML,data.swfpath,data,data.chartHeight-30,data.chartWidth,containerObj);
												}
												else if(chartFor =='distribution')
												{												
													
													appConstants.erUtils.updatePieChart(appConstants.chartType,data,'pieColors','urlLinks','pieLabels',data.chartTitle,data.XML,data.swfpath,data,containerObj);
												} 
											}
											else
											{
												containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
											}
										
									}
									Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
 								initLdgMask.hide();								
							}
							else{
								this.disableTools();
								resultPanelObj.hide();
						
 								this.getNomeasurepanel().show();
								initLdgMask.hide();
								Ext.getCmp('panelinsidetoggle').setDisabled(true);
							}
						}
						
				}
				else if(reportType == 'No'){

					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);

					publicGridData=reportData.GridObj;
					this.loadGrid(reportData);
 					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					initLdgMask.hide();
				}
			}
					
		}
		else{
 			this.disableTools();
			resultPanelObj.hide();
			
			this.getNomeasurepanel().show();
			initLdgMask.hide();
			Ext.getCmp('panelinsidetoggle').setDisabled(true);
		}
	},
	loadJsScriptReportData:function(jsonData)
	{
		appConstants.publicjsonDataActivity=jsonData	
		var dataAvailable=false;
		var titleToDispaly="";
		var ismoreUrl=appConstants.isMoreUrl;
		var isDrillD=appConstants.isDrillDown;
		var resultPanelObj=Ext.getCmp('resultPanel');	
		var rtype=Ext.getCmp('er_type').getValue();	
	
		if(rtype=="No")
		{
			var resultJson=jsonData.Results;			
			var content="";
			if(!Ext.getCmp(resultJson))
			{
				titleToDispaly=resultJson.title;
				var type=resultJson.rep_types;
				var noOfCharts=0;
				for(var lm=0;lm<type.length;lm++)
				{
					var rep_typeVal=type[lm];
					var rootjsonArr=resultJson[rep_typeVal];
					if(!Ext.isEmpty(rootjsonArr) && rootjsonArr.length>0)
					{
						noOfCharts++;
					}
				}
				
				if(noOfCharts==1)
				{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlTable"><col width="50%"><tr>';
				}else
				{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlTable"><col width="50%"><col width="50%"><tr>';
				}
				var col=0;
				for(var lm=0;lm<type.length;lm++)
				{
					var rep_typeVal=type[lm];
					var drillUrl=resultJson[rep_typeVal+'_drillDown'];
					var ismore=resultJson[rep_typeVal+'_more'];
					var moreDrillDown=resultJson[rep_typeVal+'_moreUrl'];
					var rootjsonArr=resultJson[rep_typeVal];
					if(!Ext.isEmpty(rootjsonArr) && rootjsonArr.length>0)
					{	
						if (col==2)
						{
									col=0;
									content+='</tr>';
									content+='<tr>';
						}
						dataAvailable=true;
						var column=resultJson[rep_typeVal+'_columns'];
					//	for(var str in rootjsonArr[0])
						//	column.push(str);
						
						var tabledata = '<div class="x-table"  style="overflow-y: auto;height:280px">' + '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer"><col width="45%">' + '<thead>' + '<tr class="x-grid-row">';
						
						for(var i=0;i<column.length;i++)
						{
							tabledata+='<th class=" x-grid-cell x-grid-cell-first" style="border-top-width:0px !important">' + '<div class="x-grid-cell-inner">';
							tabledata+=column[i];
							tabledata+='</div>' + '</th>';
						}
						tabledata+='</tr>' + '</thead>' + '<tbody>' + '<tpl for=".">';
						
						content+='<td style="padding:5px 10px 5px 5px">';							
							
						
						for(var i=0;i<rootjsonArr.length;i++)
						{
							var rootjson=rootjsonArr[i];
							
							tabledata += '<tr class="x-grid-row">' 
						
							for(var j=0;j<column.length;j++)
							{
								var colNm = column[j];
								tabledata+='<td class=" x-grid-cell x-grid-cell-first">';
								if(j==0)
									tabledata+= '<div style="width:95%;display:inline-block;margin-top:4px;margin-left:10px !important;overflow:hidden;text-overflow:ellipsis;white-space:nowrap" data-qtip="'+rootjson[colNm]+'" data-qclass="yellowTip">';
								else
									tabledata+= '<div style="width:100%;display:inline-block;margin-top:4px;margin-left:10px !important;">';
								if(j==(column.length-1) && (column.length==2))
								{
									
									tabledata+='<div style="width:60%;height:15px;background-color:#e2e2e2;float:left" >';
									tabledata+='<div style="height:15px;width:'+rootjson['percentage']+'% !important;background-color:'+rootjson['colorCode']+' !important;">';
									tabledata+='</div>';
									tabledata+='</div><div style="float:left;width:35%;padding-left:4px;">'+rootjson[colNm]+'</div>';
								}else
								{									
									tabledata+=rootjson[colNm];	
								}
									tabledata+= '</div>'  ;
								tabledata+='</td>';
							}
							tabledata+='</tr>';						
						}
						tabledata += '</tpl>' + '</tbody>' + '</table>' + '</div>';	
						
						

						content+='<div width="100%" class="mainDiv">';
						content+='<div class="htmlTableHeader"><div style="float:left;">';
						content+=rep_typeVal;
						content+='</div>';
						content+='<div style="float:right;">';
						if(appConstants.er_rep=='null')
						{				
							content+='<div style="float:right;cursor:pointer;" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+drillUrl+'\');"></div>';
						}
						content+='</div></div>';
						content+='<div  style="width:100%;" class=" ">';
						content+=tabledata;
						content+='</div>';
						
						
						
						if(ismore=="true" && (ismoreUrl!="true" && isDrillD !="true"))
						{
							content+='<div style="float:right;cursor:pointer;margin-right:5px" onclick="javascript:loadUrlInDrillDown(\''+moreDrillDown+'\');"><font size="3"><u><b>More<b></u></font></div>';
						}
						content+='</div>';
						content+='</td>';
					}
					col++;
					if (col==2)
						{
							content+='</tr>';
						}
				}
				content+='</table></div>';
			}
			if(dataAvailable)
			{		
				resultPanelObj.removeAll();
				resultPanelObj.add({
				xtype:'panel',
				title:titleToDispaly,	
				margin: '0 10 10 10',			
				html:content,	
				});
				resultPanelObj.show();
				resultPanelObj.doLayout();
				
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(false);
			}else
			{
				this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().show();
			
				Ext.getCmp('panelinsidetoggle').setDisabled(true);
				Ext.getCmp("saveTool").setDisabled(true);
				Ext.getCmp("bookletTool").setDisabled(true);
				Ext.getCmp("printTool").setDisabled(true);
				Ext.getCmp("mailTool").setDisabled(true);
				Ext.getCmp("csvTool").setDisabled(true);
			}
		}else
		{
			var datajson=jsonData.reportData;
			var chartType=jsonData['chartType'];
			var itemsArray=new Array();
			var count=0;
			var itemHbVal=new Array();
			var me=this;
			var noOfchart=0;
			var chartUrlArray=datajson.chartUrls;
			noOfchart=chartUrlArray.length;
			for(var i=0;noOfchart>i;i++)
			{
				var url = chartUrlArray[i];
				var chartProperties=this.getXmlForUrl(url);
				if (!Ext.isEmpty( chartProperties ) && chartProperties.hasOwnProperty('XML') )
				{
					dataAvailable=true;
					var margin;
					var flex;
					if (i==1)
					{
						margin=10;
						flex=0.65;
					}
					else
					{
						margin='10 10 10 0'
						flex=1;
					}
					var chartbox={
						xtype:'container',
						data: chartProperties,
						margin:margin,
						autoScroll:true,
						scroll:true,
						width:820,
						cls:'containerShadow',
						id: 'fusion'+count
					};
					itemHbVal.push(chartbox);		
										
					count+=1;
				}
				if(i+1==noOfchart)
				{
					itemHbVal.push(chartbox);	
					var cb={
						xtype:'panel',
						//title:"<span class='font_bold'>"+datajson.sub_titile+"</span>",
						margin:'5 10 10 10',
						cls:'datapanel',
						layout:{type:'vbox',align:'center'},
						//height:600,
						columnWidth:1.0,
						items:itemHbVal,										
					}
					itemsArray.push(cb);
					temHbVal=new Array();
				}
			}
			if(dataAvailable)
			{				
				resultPanelObj.add({
					xtype:'panel',
					title:"<span class='font_bold'>"+datajson.title+"</span>",
					margin:'5 10 10 10',
					cls:'datapanel',
					layout:{type:'vbox',align:'stretch'},
					//height:400,
					columnWidth:1.0,
					items:itemsArray
				});
				resultPanelObj.show();
				if (Ext.isEmpty(appConstants.erUtils))
				{
					appConstants.erUtils = Ext.widget("erutils");
				} 
				for ( var i = 0; i < count; i++ )
				{
					var containerObj=Ext.getCmp('fusion'+i);
					var data = containerObj.data;
					if ( !Ext.isEmpty( data ) && data.hasOwnProperty('XML') )
					{
						var innerHtml=data.innerHtml;
						var chartFor =data.chartFor;
						var chartHight =data.chartHight;
						if(chartFor =='Top')
						{
							appConstants.erUtils.updateBarChart(appConstants.chartType,data.chartTitle,data.XML,data.swfpath,data,data.chartHeight-30,data.chartWidth,containerObj);
						}
						else if(chartFor =='distribution')
						{												
							appConstants.erUtils.updatePieChart(appConstants.chartType,data,'pieColors','urlLinks','pieLabels',data.chartTitle,data.XML,data.swfpath,data,containerObj);
						} 
					}
					else
					{
						containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
					}
				}										
				}
				else{
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();
					initLdgMask.hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
		}
		Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		initLdgMask.hide();
	},
	toggleChildTables:function(id){
		var booleanCls=$('#'+id).hasClass('iconTreeExpand');
		
		
		
 		var str=id.split('_');
	
 		if (booleanCls)
		{
   			$('#'+id).removeClass("iconTreeExpand");
			$('#'+id).addClass("iconTreeCollapse");
		}
		else
		{
 			$('#'+id).removeClass("iconTreeCollapse");
			$('#'+id).addClass("iconTreeExpand");
		}
		if (str[0]=='data')
		{
 			var toggleid='child_tr'+str[1]+'_';
 			$("#anbu tr[id^="+toggleid+"]").each(function (i, el) {
				if (booleanCls)
				{					
 					el.style.display='table-row';
 				}
				else
				{
					el.style.display='none';
				}
			});
  		}
		else if(str[0]=='child')
		{

			if (booleanCls)
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='table-row';
			}
			else
			{
				document.getElementById('subChild_tr_'+str[1]+'_'+str[2]).style.display='none';
 			}
		}
		else
		{
			conosle.log('issue in toggling');
		}
		Ext.getCmp('resultPanel').doLayout();
	},
	submitReport:function(){
		initLdgMask.show();
		var url;
		var backgroundUrl;
		var Qstring;
		var dataAvailable=false;
		var mainForm =Ext.getCmp('mainform').getForm();
			if(!isSettingsEnabled)
				this.showConfigDropdown();
		var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
		var reportFor = mainForm.findField('report_category').getValue();
		appConstants.report_for=reportFor;
		
			var rtype=mainForm.findField('er_type').getValue();
			var graphType=mainForm.findField('er_graphType').getValue()
			if(rtype == 'No'){					
				Ext.getCmp('showLegend').hide();				
			}
			this.updateQStringActivity();
			Qstring=appConstants.queryStringActivity;
			backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC";		
			url="../servlet/com.eg.ErBTMTopNReportC?isSubmit=true&responseType=json"			
		
		

 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName;
		
 		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		var reportType='';
 		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		resultPanelObj.removeAll();
	
		if(reportGeneration == 'foreground'){
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);					
						this.loadJsScriptReportData(jsonData);
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;

 			var htmlStr = '';
			initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json",
				method : "POST",
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
						}
					}
					else
					{
						htmlStr = '<span>ErroR In BackGround Generation</span>';
					}
  					me.getBackGroundPanel().update('<div>'+htmlStr+'</div>');
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}

	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	timeLineOnChange:function() {
		var mainForm =Ext.getCmp('mainform').getForm();
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var startDateObj=mainForm.findField('er_stdate');
		var startHrObj=mainForm.findField('er_sthr');
		var endDateObj=mainForm.findField('er_enddate');
		var endHrObj=mainForm.findField('er_endhr');
		var timelineObj=mainForm.findField('er_timeline');
		if(timelineObj.getValue() == 'Any'){
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else{
		timelineObj.suspendEvents(true);
		//this.loadHiddenFields(publicjsonData['hiddenfields']);
		this.updateQStringActivity();
		var url1="";
			
				url1="/final/reporter/ErBTMTopNReportJson.jsp";
			
		Ext.Ajax.request(
		{
			url : url1,
			params : appConstants.queryStringActivity,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataActivity=jsonData;
				var start_hour=jsonData.startHour;
				var end_hour=jsonData.endHour;
				var start_date=jsonData.startDate;
				var end_date=jsonData.endDate;
				startDateObj.setDisabled(true);
				startHrObj.setDisabled(true);
				endDateObj.setDisabled(true);
				endHrObj.setDisabled(true);
				startDateObj.setValue(start_date);
				startHrObj.setValue(start_hour);
				endDateObj.setValue(end_date);
				endHrObj.setValue(end_hour);
			}
		});
		timelineObj.resumeEvents();
		}
	},
	weekendOnChange:function(){
		var reportCat=Ext.getCmp('report_category').getValue();
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');


		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},
	loadTools : function(){
		this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams;
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientuserSettingsForm=null;
		if(isSettingsEnabled)
		 thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();

		var reportType = mainForm.findField('er_type').getValue();
		var componentType = mainForm.findField('er_compType').getValue();

		
		var serverArray;
		var select_farmVal=Ext.getCmp('select_farm').getValue();
				
						FormParams+="&select_farm="+select_farmVal;
					
				
		

		FormParams+="&er_comptype="+mainForm.findField('er_compType').getValue()
					+"&er_type="+reportType
					+"&er_excwe="+this.getSettingsFieldValue(thinclientuserSettingsForm,'er_excwe',isSettingsEnabled,'excludeWeek')
					+"&er_reportgenration="+this.getSettingsFieldValue(thinclientuserSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
				if(Ext.get('showLegend')!=null)
					FormParams=FormParams+"&showLegend="+mainForm.findField('showLegend').getValue();

					FormParams+="&er_priority="+mainForm.findField('er_priority').getValue();
					
					
					
		if(reportType == 'Yes')
		{
			var sel_GraphType = mainForm.findField('er_graphType').getValue();
			FormParams+="&graphViewtype="+sel_GraphType+"&select_testmes="+mainForm.findField('select_testmes').getValue()
						+"&er_mode="+mainForm.findField('er_mode').getValue()
						+"&sh_timeinuse=No";
			if(sel_GraphType=='timeline' || reportType=='No' ){
				
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}else if(sel_GraphType=='distribution'){
				FormParams+="&er_perserver=Yes";
			}
		}
		else
		{
			var er_sortByVal=Ext.getCmp('er_sortby').getValue();
			if(appConstants.isreportsneedService!="null")
			{				
				if(er_sortByVal!=null && er_sortByVal!='undefined'){
					
					FormParams+="&er_sortby="+er_sortByVal;
					
				}else
				{
					FormParams+="&er_sortby=-1";
				}
			}else
			{
				FormParams+="&er_sortby=-1";
			}
			
				FormParams+="&sh_timeinuse="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>1)){
				var er_perserver = this.getSettingsFieldValue(thinclientuserSettingsForm,'er_perserver',isSettingsEnabled,'selectedAggServer')
				if(er_perserver!=null)
					FormParams+="&er_perserver="+er_perserver;
			}
		}
		
			
				FormParams+="&group_by="+this.getSettingsFieldValue(thinclientuserSettingsForm,'sh_timeinuse',isSettingsEnabled,'weightedAvg');
			
		
				serverArray=Ext.getCmp('er_server').getValue();
				if(serverArray ==undefined || serverArray=="-1" ||(serverArray!=null && serverArray!=undefined && serverArray.length>0)){
					for(var m=0;m<serverArray.length;m++)
					{
						FormParams+="&er_workgroupserver="+serverArray[m];
						FormParams+="&er_server="+serverArray[m];
					}
				}	
				
		
		FormParams+="&rep_genType="+Ext.getCmp("rep_genType").getValue();
		var s_timefrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var s_minfrom =this.getSettingsFieldValue(thinclientuserSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var s_timeto =this.getSettingsFieldValue(thinclientuserSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var s_minto =this.getSettingsFieldValue(thinclientuserSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		var timperiodParams="&timefrom="+s_timefrom+"&minfrom="+s_minfrom+"&timeto="+s_timeto+"&minto="+s_minto;

		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}		
		

			FormParams+="&er_application="+Ext.getCmp('er_application').getValue();
		
		if(appConstants.isreportsneedService!="null")
				FormParams+="&isreportsneedService="+appConstants.isreportsneedService;
		if(appConstants.componenttest!="null")
				FormParams+="&componenttest="+appConstants.componenttest;
		if(appConstants.er_rep!="null")
				FormParams+="&er_rep="+appConstants.er_rep;
				FormParams+="&ReportFrom=BTM_Report";
		
		
		
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
  	},
	
	afterMainRender:function(){
		var thisController = this;		
					
		
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
				this.getMain().setTitle(appConstants.er_RmDispName);
			else
				this.getMain().setTitle(appConstants.publicjsonDataActivity.reportTitle);
			
			this.fillFormFieldsForActivity(appConstants.publicjsonDataActivity);
			if(!hideBackButton){
		
			
					Ext.getCmp('BTMReportsForm').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonDataActivity['ID']
					});
				
			}
		
			if(appConstants.er_rep!="null")
			{
				Ext.getCmp("popClose").show();
				Ext.getCmp("favoriteTool").hide();
				Ext.getCmp("scheduleTool").hide();
			}else
			{
				Ext.getCmp("popClose").hide();
				Ext.getCmp("favoriteTool").show();
				Ext.getCmp("scheduleTool").show();
			}
			
		
	},
	loadSettingsElements:function(){
		var thisController  =this;
		
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			var isSettingsOk = thisController.validateSettings();
			//isSettingsOk=true;
 			if(isSettingsOk)
			{
 				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
		});
	},
	refreshReportData:function(){
		var jsonData;
		
		
		jsonData=appConstants.publicjsonDataActivity;
		
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
            initLdgMask.show();
			this.loadJsScriptReportData(jsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	fillFormFieldsForActivity:function(jsonData)
	{
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="";
		var serverSel="";
		
		Ext.getCmp('rep_genType').hide();
		Ext.getCmp('er_type').hide();
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		
			serverSel="select_farm";
			compSel="er_server";
			Ext.getCmp("eg_serverSel").hide();
			Ext.getCmp("er_compSel").hide();
			Ext.getCmp("select_farm").show();
			Ext.getCmp("serverMultiSelectLbl").show();
			
		

			/*var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			var from_schedule = hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}*/
		//select_farm,
		var mainForm =Ext.getCmp('mainform').getForm();
		var screenLabels=jsonData.screenLabels;

		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);
			
			comboObject.getStore().loadRawData(comboRawData);

			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		
		comboRawData=jsonData.compTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
			selectedComboOption=jsonData.selectedCompType;
			comboObject=mainForm.findField('er_compType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Component Type']);
			comboObject.getStore().loadRawData(comboRawData);

			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData=jsonData.reportForCombo;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.reportFor;
			comboObject=mainForm.findField('report_category');
			comboObject.setFieldLabel(screenLabels['reporter.common.Report For']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData=jsonData.reportTypeCombo;
		if ( !Ext.isEmpty(comboRawData) ){
		
			selectedComboOption=jsonData.selectedreportType;
			comboObject=mainForm.findField('er_type');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Report Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			} 
			comboObject.hide();
		}
		
		rep_type=comboObject.getValue();
		comboRawData=jsonData.serverCombo;
			if ( !Ext.isEmpty(comboRawData) ){
				
				selectedComboOption=jsonData.selectedServer;
				comboObject=Ext.getCmp(compSel);
				appConstants.rawDataForComponents = comboRawData;
			//	if(appConstants.erGraphType!="null" && appConstants.erGraphType!="Summary")		
			//		comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
				comboObject.getStore().loadRawData(comboRawData);
				if ( !Ext.isEmpty(selectedComboOption) ){
					comboObject.setValue(selectedComboOption);
				}
				else{
					comboObject.setValue(comboRawData[0].valueField);
				}
				//comboObject.show();
			}
	//if(rep_type!="No" )
	{
		comboRawData=jsonData.priorityCombo;
		
		selectedComboOption=jsonData.selectedPriority;
		comboObject=mainForm.findField('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show Top']);
		if(!Ext.isEmpty(comboRawData))
		{
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
	}/*else
	{
		comboObject=mainForm.findField('er_priority');
		comboObject.hide();
	}*/

		if(rep_type == 'No'){
			mainForm.findField("select_testmes").hide();
			mainForm.findField('er_mode').hide();
			
			if(selectedComboOption!=null && selectedComboOption.indexOf("All ")>-1){
				if(Ext.getCmp('er_perserver')!=undefined)
					Ext.getCmp('er_perserver').show();
			}
			
			comboRawData=jsonData.er_sortCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selecteder_sort;
			comboObject=mainForm.findField('er_sortby');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Based on measure']);
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}	
		
		
				Ext.getCmp('er_application').hide();

		}
		else{
			comboRawData=jsonData.graphTypeArray;
			if(!Ext.isEmpty(comboRawData))
			{
			selectedComboOption=jsonData.selectedGraphType;
			comboObject=mainForm.findField('er_graphType');
			comboObject.setFieldLabel(screenLabels['reporter.thin.Graph Type']);
			
			comboObject.getStore().loadRawData(comboRawData);
			
			if ( !Ext.isEmpty(selectedComboOption) ){
				comboObject.setValue(selectedComboOption);
			}
			else{
				comboObject.setValue(comboRawData[0].valueField);
			}
			
			comboObject.show();
			}
		
			
				if(selectedComboOption=='distribution'){
					comboRawData=jsonData.measureCombo;
					selectedComboOption=jsonData.selectedMeasure;
					comboObject=mainForm.findField('select_testmes');
					comboObject.setFieldLabel(screenLabels['reporter.thin.Measure']);
					comboObject.getStore().loadRawData(comboRawData);
					if ( !Ext.isEmpty(selectedComboOption) ){
						comboObject.setValue(selectedComboOption);
					}
					else{
						comboObject.setValue(comboRawData[0].valueField);
					}
					comboObject.show();
				}
			
		
		}

		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}

        var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = mainForm.findField('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = mainForm.findField('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = mainForm.findField('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = mainForm.findField('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

		 updatingAppSettings();
		 if(appConstants.er_rep!='null')
		 {	
			//Ext.getCmp("Eger_server").hide();
			//Ext.getCmp("er_server").hide();
			Ext.getCmp("reportSettings").hide();
			Ext.getCmp("favoriteSeparator").hide();
			Ext.getCmp("report_tab").hide();
			Ext.getCmp("select_farm").hide();
			Ext.getCmp("serverMultiSelectLbl").hide();
		 }
		 
		
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getBTMReportsFormSettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('er_excwe');		
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			comboObject.setValue(comboRawData[0].valueField);
		}

		comboObject=thinclientuserSettingsForm.findField('sh_timeinuse');
		comboObject.hide();
		
	

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	},
	showConfigDropdown:function(){
			isSettingsEnabled = true;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px" class="settingsfont">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			//config dropdown mode
			Ext.create('Ext.container.Container',{
			width:580,
			padding:5,
			//layout:'vbox',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			//html:tpl.apply(),
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'322px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype : 'BTMReportsFormSettings',
					parent:this
				}
			],
			renderTo:'thinclientuser'
			});

	},
	LoadDrillDownData:function( url){
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				if(jsonData.hasOwnProperty('drillDownData')){
					resultPanelObj.removeAll();
					var DrillDownData = jsonData['drillDownData'];
					for(var k in DrillDownData){
						var tableObj =DrillDownData[k];
						var columnDetails = tableObj['columns'];
						var dataArray = tableObj['data'];

						if(!Ext.isEmpty(dataArray))
						{

							var tabledata = '<div class="x-table" >'
							+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
								+'<thead>'
									+'<tr class="x-grid-row">';
							for( var k in columnDetails){
										tabledata+='<th class=" x-grid-cell">'
											+'<div class="x-grid-cell-inner">'+columnDetails[k]+'</div>'
										+'</th>';
							}
							tabledata+='</tr>'
								+'</thead>'
							+'<tbody>'
							+'<tpl for=".">';
							for(var j in dataArray)
							{
								var realdata=dataArray[j];
								tabledata+='<tr class="x-grid-row">';
								for(var l in realdata){
									tabledata+='<td class=" x-grid-cell x-grid-cell-first">'
										+'<div class="x-grid-cell-inner" >'+realdata[l]+'</div>'
									+'</td>'
								}
								tabledata+='</tr>';
							}
							tabledata+='</tpl>'+'</tbody>'+'</table>' +'</div>';
							if (k == 1)
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									tools: [{
										xtype: 'button',
										text:backText,
										cls: 'backbutton',
										iconCls: 'iconBack',
										id: 'thiClientbckButton',
										name: 'thiClientbckButton',
										listeners: {
											'click': function () {
												meController.submitReport();
											}
										}
									}],
									bodyPadding: '0 0 0 0',
									padding:0,
									title:'<span class="font_bold">'+tableObj.tableTitle+'</span>',
									width: '100%',
									html: tabledata
								});
							else
								resultPanelObj.add({
									xtype: 'panel',
									margin: '0 0 10 0',
									layout: {
										columns: 2,
										align: 'center'
									},
									cls: 'datapanel',
									bodyPadding: '0 0 0 0',
									title:'<span class="font_bold">'+tableObj.tableTitle+'</span>',
									width: '100%',
									padding:0,
									html: tabledata
								});
						}
					}
				}
				else{
 					this.disableTools();
					resultPanelObj.show();			
 					resultPanelObj.removeAll();
					resultPanelObj.add({
					xtype: 'container',
					height: 250,
					cls:'containerShadow',
					margin:'5 10 10 10',
					width: '100%',
					html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
					});
				}
				initLdgMask.hide();
			}
		});
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{

		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataActivity;

		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}



		return value;
	}
});

