Ext.define('BookletApp.controller.bookletController', {
	extend:'Ext.app.Controller',
	views:['BookletApp.view.Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'bookletgrid', ref:'bookletgrid'},
		{selector:'customwindow', ref:'customwindow'},
		{selector:'schedulewindow', ref:'schedulewindow'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController(appConstants.appController).doFilter();
	}),
	init: function () 
	{

		this.control({
			'bookletgrid' : 
			{
				'render' : this.getBookList,
				'viewready' : this.callViewReady,
				'afterrender':this.deleteAllReport,
			},
			'bookletgrid textfield[name="bookletlivesearch"]':
			{
				change:this.typewatch
			},
			'customwindow button[id=bindReport]' : {
				'click' : this.bindReport
			},
			'customwindow button[id=updateBooklet]' : {
				'click' : this.updateReportGrid
			},
			'schedulewindow button[id=scheduleReport]' : {
				'click' : this.scheduleReport
			},
			'schedulewindow':{
				'afterrender':this.getSchedulewindowInfo,
			},
			'bookletReportGrid':{
				'afterrender':this.deleteAllReport,
			},
		})
	},
	typewatch:function(field, event){
		 this.searchTask.delay(500);
	},
	getBookList:function()
	{
		var me = this;
        Ext.Ajax.request({
            url: 'ErShowBookletPDFListJSON.jsp',
			params:'method=getBookletInfo',
			scope:this,
			async:false,
            success: function(response) 
			{
                if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					jsonData = Ext.decode(response.responseText);
					var dataArray=jsonData.bookletArr;
					var datArray=me.getBookletgrid().dataArray;
					var dummyArray=me.getBookletgrid().dummyArray;
					me.getBookletgrid().getStore().removeAll();

					datArray.splice(0, datArray.length);
					dummyArray.splice(0, dummyArray.length);
					for(var i=0;i<dataArray.length;i++)
					{
						datArray.push(dataArray[i]);
						dummyArray.push(dataArray[i]);
					}
					var curpage=me.getBookletgrid().activePage;
					var totalCount=me.getBookletgrid().getStore().totalCount;
					var pageSize=me.getBookletgrid().getStore().pageSize;
					if(Math.round(totalCount/pageSize)<curpage)
					{
						me.getBookletgrid().activePage=Math.round(totalCount/pageSize);
					}
					if(me.getBookletgrid().activePage<=0)
						me.getBookletgrid().activePage=1;
					me.getBookletgrid().getStore().loadPage(me.getBookletgrid().activePage);
				}
            }
        });
	},
	callViewReady:function()
	{
		var meGrid = Ext.getCmp('reportGridID');
		var task1 = {
				run: function()
				{
					var myGridStore = meGrid.store;
					var storeLength = meGrid.store.data.length;
					var processingArray = [];
					var gridIndexArray = [];
					for (var storeLen = 0; storeLen < storeLength; storeLen++)
					{
						if (myGridStore.getAt(storeLen).get('status').toString().indexOf('processing') > 2)
						{
							processingArray.push(myGridStore.getAt(storeLen).get('bookletID'));
							gridIndexArray.push(storeLen);
						}

					}
					if (processingArray.length > 0)
					{
						Ext.Ajax.request({
							url: '/final/servlet/com.eg.ErBookletStatusCheckC',
							method: 'POST',
							params: "bookletIDs=" + processingArray.toString(),
							success: function(response)
							{
								if (response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var statusResponse = Ext.decode(response.responseText);
									for (var gridArr = 0; gridArr < gridIndexArray.length; gridArr++)
									{
										var tmpBID = myGridStore.getAt(gridIndexArray[gridArr]).get('bookletID');
										var status = statusResponse[tmpBID];
										if (status == 'Generated')
										{
											myGridStore.getAt(gridIndexArray[gridArr]).set('status', 'Generated');

										}
									}
								}
							}
						});
					}
				},
			interval: 5000 //5 seconds
		};
		console.log('Test______start____');
		Ext.TaskManager.start(task1);
	},
	getSchedulewindowInfo:function()
	{
		 Ext.Ajax.request({
            url: '../reporter/ErShowScheduleBookletJSON.jsp',
			params:'method=getSchedulewindowInfo',
			scope:this,
			async:false,
            success: function(response) 
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					jsonData = Ext.decode(jsonText);
					
					var mailFrq = Ext.getCmp('schedule_mail_freq');
					var mailOn = Ext.getCmp('schedule_mail_on');
					var schHeld = Ext.getCmp('schedule_held_on');
					var fmHr = Ext.getCmp('fromHours');
					var fmMin = Ext.getCmp('fromMinutes');
					
					mailFrq.getStore().loadRawData(jsonData.mailFreqJSON);
					mailFrq.setValue(jsonData.mailFreqJSON[0].valueField);
					mailOn.getStore().loadRawData(jsonData.mailOnMonthJSON);
					mailOn.setValue(jsonData.mailOnMonthJSON[0].valueField);
					dayOfWeekData=jsonData.mailOnWeekJSON;
					Ext.getCmp('days_of_week').setValue(jsonData.mailOnWeekJSON[0].valueField);
					schHeld.getStore().loadRawData(jsonData.scheduleTypeJson);
					schHeld.setValue(jsonData.scheduleTypeJson[0].valueField);
					fmHr.getStore().loadRawData(jsonData.hrsComboJSON);
					fmHr.setValue(jsonData.hrsComboJSON[0].valueField);
					fmMin.getStore().loadRawData(jsonData.minsComboJSON);
					fmMin.setValue(jsonData.minsComboJSON[0].valueField);
				}
			}
		});
	},
	openScheduleWindow:function(record)
	{
		eachRec=record;
		Ext.widget('schedulewindow');
		//this.getSchedulewindow().setTitle('Schedule Booklets');
		this.getSchedulewindow().down('panel').setTitle('Schedule Booklets');
		this.getSchedulewindow().show();
		Ext.getCmp('scheduleNameField').setValue(eachRec.data['bookletname']);
	},
	openReportWindow:function(record)
	{
		eachRec=record;
		Ext.widget('customwindow');
		//this.getCustomwindow().setTitle('REPORTS UNDER '+eachRec.data['bookletname']);
		this.getCustomwindow().setTitle('Reports in Booklet');
		this.getCustomwindow().show();
		var reportGridIDStore = Ext.getCmp('reportGridID');
		if(eachRec.data['status']=='NotGen' || eachRec.data['status']=='Not Generated')
		{
			Ext.getCmp('bindReport').setDisabled(false);
		}

		reportGridIDStore.getStore().loadRawData(eachRec.data['reports']);
		Ext.getCmp('binderNameField').setValue(eachRec.data['bookletname']);
		Ext.getCmp('descriptionField').setValue(eachRec.data['description']);
		Ext.getCmp('updateBooklet').hide();
		//document.getElementById("booletItemField").innerHTML='<div>Items in Booklet : <span class="font_bold11">'+eachRec.data['reports'].length+'</span></div>';
		Ext.getCmp('booletItemField').setValue(eachRec.data['reports'].length);

	},
	scheduleReport:function()
	{
		var me = this;
		var scheduleNameField = Ext.getCmp('scheduleNameField').getValue();
		var mailFreq = Ext.getCmp('schedule_mail_freq').getValue();
		var mailon = Ext.getCmp('schedule_mail_on').getValue();
		var dayOfWeek = Ext.getCmp('days_of_week').getValue();
		var mailId = Ext.getCmp('mail_id').getValue();
		var scheduleHeldOn = Ext.getCmp('schedule_held_on').getValue();
		var fromHours = Ext.getCmp('fromHours').getValue();
		var fromMinutes = Ext.getCmp('fromMinutes').getValue();
		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var queryStr = '';
		var binderId = '';
		Ext.each(eachRec.data['reports'], function(item){

			if(item.reportID != undefined && item.reportID != 'undefined')
				binderId+=item.reportID+'*'+item.reportNames+',';
			else
				binderId+=item.data.reportID+'*'+item.data.reportNames+',';
		});
		binderId = binderId.substring(0,binderId.length-1);
		queryStr+='binderId='+appConstants.erUtils.specialCharEncode(binderId)+'&needToMerge=yes';
		if(scheduleNameField=='')
		{
			this.getAlertMessage('Schedule Booklets','Please enter the Schedule Booklet Name');
			return false;
		}
		if(!checkspecial(scheduleNameField,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			this.getAlertMessage('Schedule Booklets',alertTxt);
			return false;
		}
		queryStr+='&sBookletName=' + scheduleNameField;
		if(mailFreq == 'Days_of_the_week')
		{
			if(dayOfWeek.length == 0)
			{
				this.getAlertMessage('Schedule Booklets','Please choose mail on details');
				return false;
			}
			queryStr+='&dayOfWeek=' + dayOfWeek;
		}
		else if(mailFreq === 'Weekly' || mailFreq === 'Monthly') 
		{
			queryStr+= '&mailOn='+ mailon;
		}
		queryStr+='&mailFreq=' + mailFreq;
		queryStr+='&mailID=' + mailId;
		if(mailId == '')
		{
			this.getAlertMessage('Schedule Booklets','Please enter the mail id');
			return false;
		}
		else if((isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false") && !checkmultiplemailid(mailId,false))
		{
			Ext.Msg.show({
				title:'Alert',
				msg: _checkmail,
				buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING
			});
			return false;
		}
		else if((isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false") && !validateSingleByte(mailId))
		{
			Ext.Msg.show({
				title:'Alert',
				msg: mailID_DBLerror_msg,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return false;
		}
		queryStr+='&scheduleHeldOn='+ scheduleHeldOn;
		if(scheduleHeldOn == 'AnyTime')
		{
			queryStr+='&hr='+fromHours;
			queryStr+='&min='+fromMinutes;
		}
		queryStr+='&cmd=binder'
		Ext.Ajax.request({
			url: '../servlet/com.eg.ErScheduleBookletC',
			method: 'POST',
			params: queryStr,
			success: function(response)
			{
				var responseText = response.responseText;
				if(responseText.indexOf('bNmeExits')>-1)
				{
					me.getAlertMessage('Schedule Booklets','Booklet schedule is already exist');
					return;
				}
				
				var responseStr = Ext.decode(response.responseText);
				var errorMsg = responseStr.errorMsg;
				if(errorMsg!=undefined && errorMsg!= 'undefined')
				{
					me.getSchedulewindow().doClose();
					Ext.Msg.show({
						title: 'Alert',
						msg: errorMsg,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn : function(buttonValue, inputText, showConfig)
						{
							me.openReportWindow(eachRec);
						},      
					});
				}
				else
				{
					Ext.Msg.show({
						title: 'Alert',
						msg: 'Booklet schedule saved successfully',
						buttons: Ext.Msg.OK,
						icon: 'iconSuccess',
						fn : function(buttonValue, inputText, showConfig)
						{
							me.getSchedulewindow().doClose();
						},      
					});
				}
			}
		});
	},
	bindReport:function()
	{
		var description = Ext.getCmp('descriptionField').getValue();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		eachRec.set('description', description);
		var record = eachRec;
		this.reportBinder(record);
	},
	reportBinder:function(record)
	{
		record.set('status', '<div style="position:relative;"><img src="/final/reporter/images/processing.gif" border="0" /></div>');
		record.set('generate', '<div style="position:relative;height:16px;"><img src="/final/images/Light/regenerate_on.gif" border="0" /></div>');
		if (!Ext.isEmpty(this.getCustomwindow()))
			this.getCustomwindow().doClose();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		Ext.Ajax.request({
			url: '../servlet/com.eg.ErBookletGenerateC',
			method: 'POST',
			params: 'isFileDowload=true&bookletname=' + record.data['bookletname'] + '&bookletID=' + record.data['bookletID'] + '&rOrder=' + record.data['rOrder']+'&description='+ appConstants.erUtils.specialCharEncode(record.data['description']),
			success: function(response) {
				try
				{
					if (response.status == 200)
					{
						record.set('generate','');
						record.set('status','Generated');
					}
				}
				catch (e)
				{
					alert('Error during binding')
				}
			}
		});
	},
	updateReportGrid:function()
	{
		var me = this;
		var thisBooklet = this;
		var description = Ext.getCmp('descriptionField').getValue();
		var bookletname = Ext.getCmp('binderNameField').getValue();
		if(bookletname=="" || bookletname.length==0)
		{
			thisBooklet.getAlertMessage('Booklets','Please enter Booklet name');
			return;
		}
		if(!checkspecial(bookletname,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			thisBooklet.getAlertMessage('Booklets','Special characters are not allowed in Booklet name');
			return ;
		}
		/*if(!checkspecial(description,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/")) //..prakash
		{
			thisBooklet.getAlertMessage('Booklets','Special characters are not allowed in Description');
			return ;
		}//*/
		var mainGrid = Ext.getCmp('bookletgridID');
		var mainGridCnt = mainGrid.getStore().data.items.length;
		for (var j =0 ; j < mainGridCnt; j++)
		{
			var data_inner = mainGrid.getStore().data.items[j].data.bookletname;
			if(eachRec.index!=j && bookletname==data_inner)
			{
				thisBooklet.getAlertMessage('Booklets','Duplicate Booklet names are not allowed');
				return ;
			}
		}
		var viewStoreObj = Ext.getCmp('reportGridID');
		var dataCnt = viewStoreObj.getStore().data.items.length;
		var containSpl = -1;
		var rNames = '';
		for (var i =0 ; i < dataCnt; i++)
		{
			var data = viewStoreObj.getStore().data.items[i].data.reportNames;
			rNames = rNames+data+'#'+viewStoreObj.getStore().data.items[i].data.reportID;
			if(i < dataCnt-1)
				rNames=rNames+',';
			if(!checkspecial(data,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				containSpl = i;
				break;
			}
			for (var j =0 ; j < dataCnt; j++)
			{
				var data_inner = viewStoreObj.getStore().data.items[j].data.reportNames;
				
				if(i!=j && data==data_inner)
				{
					thisBooklet.getAlertMessage('Booklets','Duplicate Report names are not allowed');
					return ;
				}
			}
		}
		if(containSpl > -1)
		{
			Ext.MessageBox.show({
				title: 'Booklets',
				msg: 'Special characters are not allowed in Report name',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING,
				fn : function()
				{
					var data = viewStoreObj.getStore().data.items[containSpl].data.reportNames;
					var rowIndex = viewStoreObj.getStore().find("reportNames",data);
					cellEditing.startEdit(rowIndex,1);
				}
			});
			return ;
		}
		Ext.getCmp('reportGridID').getView().refresh();
		var initMask = new Ext.LoadMask(viewStoreObj.getEl(),{msg : "Loading ..."});
		initMask.show();
		
		Ext.Ajax.request({
			url: '../servlet/com.eg.ErBookletGenerateC',
			method: 'POST',
			params: 'isUpdateBooklet=true&bookletID=' + eachRec.data['bookletID'] + '&rName=' + rNames+'&description='+description+'&bookletname='+bookletname,
			success: function(response)
			{
				try
				{
					if (response.status == 200)
					{
						initMask.hide();
						Ext.getCmp('bindReport').setDisabled(false);
						Ext.getCmp('updateBooklet').setDisabled(true);
						eachRec.set('bookletname', bookletname);
						eachRec.set('description', description);
						eachRec.set('status', 'Not Generated');
						eachRec.set('reports', viewStoreObj.getStore().data.items);
						me.getAlertMessageInfo('BOOKLETS','Booklet is updated successfuly');
					}
				}
				catch (e)
				{
					alert('Error during updateing')
				}
			}
		});
	},
	
	updateOrder:function()
	{
		var me = this;
		Ext.getCmp('bindReport').setDisabled(false);
		eachRec.set('status', 'Not Generated');
		var description = Ext.getCmp('descriptionField').getValue();
		eachRec.set('description', description);
		var reportGridIDStore = Ext.getCmp('reportGridID').getStore();
		var description = Ext.getCmp('descriptionField').getValue();
		var lengthReport = reportGridIDStore.data.length;
		var reorderID = [];
		for (var iR = 0; iR < lengthReport; iR++)
		{
			reorderID.push(reportGridIDStore.getAt(iR).get('reportID'));
		}
		eachRec.set('rOrder', reorderID.toString());
		eachRec.set('reports', reportGridIDStore.data.items);
		Ext.Ajax.request({
			url: '../servlet/com.eg.ErBookletGenerateC',
			method: 'POST',
			params: 'isUpdateOrder=true&bookletID=' + eachRec.data['bookletID'] + '&rOrder=' + reorderID+'&description='+description,
			success: function(response)
			{
				try
				{
					if (response.status == 200)
					{
						//me.getAlertMessage('BOOKLETS','Rearanged successfully!');
					}
				}
				catch (e)
				{
					alert('Error during updateing')
				}
			}
		});
	},
	deleteAllReport:function(grid)
	{
		var me = this;
		var gridId=grid.getId();
		var msgInfo='Are you sure you want to remove the selected Booklets(s)?';
		var removeIconId='';
		if (gridId=='reportGridID')
		{
			removeIconId='#removeAllReport';
			msgInfo='Are you sure you want to remove the selected report(s)?';
		}
		else if (gridId=='bookletgridID')
			removeIconId='#removeAll';
		else
			return;
		grid.mon(Ext.select(removeIconId), 'click', function() {
			var selected = grid.getView().getSelectionModel().getSelection();
			var reportGridStore = grid.getStore();
			var noOfrecords = reportGridStore.getCount();
			var selectionModelObj = grid.getSelectionModel();
			if(removeIconId=='#removeAllReport' && noOfrecords==selectionModelObj.getSelection().length)
			{
				me.getAlertMessage('Booklets','Cannot delete all the reports!');
				return;
			}
			if (noOfrecords > 0)
			{
				var reportSelected = false;
				if (selectionModelObj.getSelection().length > 0)
					reportSelected = true;
				if (reportSelected)
				{
					Ext.Msg.show({
						title: 'Booklets',
						msg: msgInfo,
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn: function(buttonId) {
							if (buttonId == "yes")
							{
								if(removeIconId=='#removeAllReport')
								{
									var rID = "";
									var description = Ext.getCmp('descriptionField').getValue();
									Ext.each(selected, function(item) {
										rID += item.data.reportID + ',';
										var rOrder = eachRec.data['rOrder'].split(',');
										var index = rOrder.indexOf(item.data.reportID);
										if (index > -1) 
										{
											rOrder.splice(index, 1);
										}
										eachRec.set('rOrder', rOrder.toString());
										reportGridStore.remove(item);
									});

									eachRec.set('reports', reportGridStore.data.items);
									eachRec.set('status', 'Not Generated');
									Ext.getCmp('bindReport').setDisabled(false);
									Ext.getCmp('booletItemField').setValue(eachRec.data['reports'].length);
									rID = rID.substring(0, (rID.length - 1));

									Ext.Ajax.request({
										url: '../servlet/com.eg.ErBookletGenerateC',
										method: 'POST',
										params: 'isReportDel=true&reportID=' + rID + '&rOrder=' + eachRec.data['rOrder'] + '&bookletID=' + eachRec.data['bookletID']+'&description='+description,
										success: function(response)
										{
											try
											{
												if (response.status == 200) {
													me.getAlertMessageInfo('Booklets','Reports are deleted successfuly');
												}
											} catch (e) {
												alert(e);
											}
										}
									});
								}
								else if(removeIconId=='#removeAll')
								{
									var rID = "";
									var bID = "";
									Ext.each(selected, function(item) {
										bID += item.data.bookletID + ',';
										rID += item.data.rOrder + ',';
										reportGridStore.remove(item);
									});

									bID = bID.substring(0, (bID.length - 1));
									rID = rID.substring(0, (rID.length - 1));

									Ext.Ajax.request({
										url: '../servlet/com.eg.ErBookletGenerateC',
										method: 'POST',
										params: 'isBookletDel=true&bookletID=' + bID + '&reportID=' + rID,
										success: function(response)
										{
											try
											{
												if (response.status == 200)
												{
													me.getAlertMessageInfo('Booklets','Booklets are deleted successfuly');
												}
											}
											catch (e)
											{
												alert(e);
											}
										}
									});
								}
							}
						}
					});
				} 
				else
				{
					me.getAlertMessage('Booklets','Please select a report!');
					return;
				}
			}
		});
	},
	deleteSingleReport:function(grid,record)
	{
		var me = this;
		var reportGridStore = grid.getStore();
		var description = Ext.getCmp('descriptionField').getValue();
		if(reportGridStore.getCount()==1)
		{
			me.getAlertMessage('Booklets','Cannot delete all the reports!');
			return;
		}
		Ext.Msg.show({
			title: 'Booklets',
			msg: 'Are you sure you want to remove the report?',
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn: function(buttonId)
			{
				if (buttonId == "yes")
				{
					var rID = record.data.reportID;
					var rOrder = eachRec.data['rOrder'].split(',');
					var index = rOrder.indexOf(record.data.reportID);
					if (index > -1) 
					{
						rOrder.splice(index, 1);
					}
					eachRec.set('rOrder', rOrder.toString());
					reportGridStore.remove(record)
					grid.refresh();
					eachRec.set('reports', reportGridStore.data.items);
					eachRec.set('status', 'Not Generated');
					Ext.getCmp('bindReport').setDisabled(false);
					Ext.getCmp('booletItemField').setValue(eachRec.data['reports'].length);
					 Ext.Ajax.request({
						url: '../servlet/com.eg.ErBookletGenerateC',
						method: 'POST',
						params: 'isReportDel=true&reportID=' + rID + '&rOrder=' + eachRec.data['rOrder'] + '&bookletID=' + eachRec.data['bookletID']+'&description='+description,
						success: function(response)
						{
							try
							{
								if (response.status == 200)
								{
									me.getAlertMessageInfo('Booklets','Report is deleted successfuly');
								}
							}
							catch (e)
							{
								alert('Error in Single report delete');
							}
						}
					});
				}
			}
		});
	},
	deleteSingleBooklet:function(grid,record)
	{
		var me = this;
		var reportGridStore = grid.getStore();
		Ext.Msg.show({
			title: 'Booklets',
			msg: 'Are you sure you want to remove the Booklet?',
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn: function(buttonId)
			{
				if (buttonId == "yes")
				{
					var rID =record.data.rOrder;
					var bID = record.data.bookletID;
					reportGridStore.remove(record);
					grid.refresh();

					Ext.Ajax.request({
						url: '../servlet/com.eg.ErBookletGenerateC',
						method: 'POST',
						params: 'isBookletDel=true&bookletID=' + bID + '&reportID=' + rID,
						success: function(response)
						{
							try
							{
								if (response.status == 200)
								{
									me.getAlertMessageInfo('Booklets','Booklet is deleted successfuly');
								}
							}
							catch (e)
							{
								alert(e);
							}
						}
					});
				}
			}
		});
	},
	doFilter:function( ){
		var me=this;
		var field=Ext.getCmp('bookletlivesearch');
		var dataArray=this.getBookletgrid().dataArray;
		var dummyArray=this.getBookletgrid().dummyArray;
		this.getBookletgrid().getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					if(property=="bookletname" || property=="description")
						match = match || regex.test(String(value));
				});
				if(match)
					dataArray.push(obj);
			}
			this.getBookletgrid().getStore().loadRawData(dataArray);
		}
		else
		{
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			this.getBookletgrid().getStore().loadRawData(dataArray);
			this.getBookletgrid().getStore().loadPage(this.getBookletgrid().activePage);
		}
		field.focus();
	},
	getAlertMessage:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},
	getAlertMessageInfo:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			//icon: Ext.MessageBox.INFO
			icon:'iconSuccess'
		});
	}
});