Ext.define('BookletApp.view.BookletListGrid',
{
	extend:'utilities.CustomGrid',
	requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy', 'utilities.CustomGrid', 'utilities.SendMail'],
	alias:'widget.bookletgrid',
	id:'bookletgridID',
	//cls:'gridSkin backgrdgridspace favapp noShadow',
	ui:'newGridPanel withShade',
	border:true,
	autoScroll: false,
	scroll: false,
	screenLabels:null,
	dataArray : null,
	dummyArray : null,
	pageLimit:15,
	activePage:1,
	//flex:1,
	margin:10,
	padding:'0 10 10 10',
	height:500,
	viewConfig:
	{
		emptyText : '<table width="100%" height="100%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconSuccess"></div><div class="font_normal11">Booklets not available</div></td></tr></table>',
		deferEmptyText:false
	},
	initComponent:function(){

		var me=this;
		this.selModel  = new Ext.selection.CheckboxModel(
		{
			checkOnly: true,
			headerWidth:27,
			injectCheckbox: 'first'
		});

		if(Ext.isEmpty(this.dataArray))
			this.dataArray=[];
		this.dummyArray=this.dataArray.slice();
		this.store = Ext.create('Ext.data.Store', {
			 proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:this.pageLimit,
			autoLoad : true,
			data : this.dataArray,
			sortOnLoad: true,
			fields: [{name:'bookletID'},{name:'bookletname',sortType:Ext.data.SortTypes.asUCString},{name:'description',sortType:Ext.data.SortTypes.asUCString},{name:'bookletItems',sortType:Ext.data.SortTypes.asUCString},{name:'status'},{name:'view'},{name: 'reports',type: 'auto'}, 'rOrder'],
			sorters: { property: 'bookletname', direction : 'ASC' },
			id: 'tmpStore'
		});
		this.columns = [
		{
			text: bookletNameLabel,
			dataIndex: 'bookletname',
			flex:.5,
			sortable :true,
			renderer :function(value, metaData, record, row, col, store, gridView)
			{
				metaData.style = 'cursor: pointer;';
				var dispVal = value;
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
				return dispVal;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					appConstants.appObj.getController(appConstants.appController).openReportWindow(record);
				}
			}

		},
		{
			header: descriptionLabel,
			flex: 1,
			sortable :true,
			dataIndex: 'description',
			renderer :function(value, metaData, record, row, col, store, gridView)
			{
				var dispVal = value;
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
				return dispVal;
			}
		},
		{
			header: reportsInBookletLabel,
			align:'center',
			width:150,
			sortable :true,
			dataIndex: 'bookletItems',

			renderer :function(value, metaData, record, row, col, store, gridView)
			{
				var dispVal = record.data['reports'].length;
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
				return dispVal;
			}
		},
		{
			header: statusLabel,
			width:120,
			dataIndex: 'status',
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				if (value != 'Generated' && value != 'Not Generated' && value != 'NotGen')
				{
					metaData.tdCls="iconColumn";
				}
				else if(metaData.tdCls=="iconColumn"){
					metaData.tdCls="";
				}
				return value;
			}

		},
		{
			header: '',
			xtype : 'actioncolumn',
			sortable :false,
			dataIndex : 'generate',
			width : 40,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				var cls='';
				if (record.data['status']=='Generated')
				{
					cls = 'iconGenerateOn';
				}
				else if(record.data['status']=='NotGen' || record.data['status']=='Not Generated')
				{
					cls='iconGenerateOff';
				}
				value = '<div  data-qtip="Generate Booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					appConstants.appObj.getController(appConstants.appController).reportBinder(record);
				}
			}
		},
		{
			header: '',
			xtype : 'actioncolumn',
			sortable :false,
			dataIndex : 'view',
			width : 40,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				var cls='iconReportNotBindDownload';
				if (record.data['status']=='Generated')
				{
					cls = 'iconReportBindDownload';
				}
				value = '<div  data-qtip="Download Booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					if(record.data['status']=='Generated')
					{
						Ext.create('Ext.form.Panel', {
						renderTo: Ext.getBody(),
						standardSubmit: true,
						url: '../servlet/com.eg.ErBookletFileDownloadC?bookletID=' + record.data['bookletID'] + '&bkltName=' + Ext.widget("erutils").specialCharEncode(record.data['bookletname'])
						}).submit();
					}
				}
			}
		},
		{
			header: '',
			xtype : 'actioncolumn',
			sortable :false,
			dataIndex : 'view',
			width : 40,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				var cls='iconMail iconDisabled';
				if (record.data['status']=='Generated')
				{
					cls = 'iconMail ';
				}
				value = '<div  data-qtip="Mail Booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					bookletId = record.data['bookletID'];
					bookletName = record.data['bookletname'];
					if(record.data['status']=='Generated')
					{
						var windowMail = Ext.widget('sendmail');
						windowMail.show();
					}
				}
			}
		},
		{
			header: '',
			xtype : 'actioncolumn',
			sortable :false,
			dataIndex : 'schedule',
			width : 40,
			disabled:true,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				var cls='iconScheduleDisabled';
				var containsAnyTime = false;
				Ext.each(record.data['reports'], function(item) {
					if(item.isAnyTimeline=='Any')
					{
						containsAnyTime=true;
						return false;
					}
					else if(item.data!=undefined && item.data != 'undefined' && item.data.isAnyTimeline=='Any')
					{
						containsAnyTime=true;
						return false;
					}
				});
				if(containsAnyTime)
				{
					value = '<div  style="position:relative;margin: 0px auto;" class="'+cls+'"></div>';
				}
				else
				{
					cls = 'iconSchedule';
					value = '<div  data-qtip="Schedule" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:1px;" class="'+cls+'"   ></div>';
				}
				return value;
			},
			listeners:
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					var containsAnyTime = false;
					Ext.each(record.data['reports'], function(item) {
						if(item.isAnyTimeline=='Any')
						{
							containsAnyTime=true;
							return false;
						}
					});
					if(!containsAnyTime)
					{
						appConstants.appObj.getController(appConstants.appController).openScheduleWindow(record);
					}
				}
			}
		},
		{
			header: '<div style="cursor:pointer" id="removeAll" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Delete All"></div>',
			xtype : 'actioncolumn',
			sortable :false,
			height:20,
			width :40,
			dataIndex : 'remove',//..
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				value = '<div  data-qtip="Delete" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;top:2px;" class="iconDelete"   ></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					appConstants.appObj.getController(appConstants.appController).deleteSingleBooklet(grid,record);
				}
			}
		}];
		var meGrid = this;
		this.dockedItems=[
		{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				style:strSkin =="Light"?{'border-top':'0px !important'}:{'border-top':'1px'},
				id:'FavListPaging',
				name:'FavListPaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayMsg: 'Displaying Booklets {0} - {1} of {2}',
				emptyMsg: errorMsgLabel,
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},
			{
				xtype:'toolbar',
				cls:'toolbar',
				dock:'top',
				flex:1,
				height:38,
				items:[
						{ xtype: 'tbfill' },
						{
							xtype:'trigger',
							id : 'bookletlivesearch',
							name : 'bookletlivesearch',
							labelWidth:40,
							fieldLabel:'',
							cls: 'whitedropdown_search',
							emptyText:searchBookletLabel,
							enableKeyEvents: true,
							margin:'6 0 6 10'
						}
					]
				}
		]
		this.callParent();
	},
	listeners:
	{
		sortchange:function(ct, column, e, t, eOpts )
		{
			 this.getStore().loadPage(this.activePage);
		},
	}
});