var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	id: 'cellEditingPlugin',
});
Ext.define('BookletApp.view.BookletReportGrid',
{
	//extend: 'utilities.CustomGrid',
	extend: 'Ext.grid.Panel',
	requires: ['Ext.ux.grid.FiltersFeature', 'Ext.ux.data.PagingMemoryProxy','utilities.CustomGrid'],
	alias: 'widget.bookletReportGrid',
	id: 'reportGridID',
//	cls:'gridSkin backgrdgridspace favapp noShadow', // noShadow noShadowNoHeader
	ui:'newGridPanel',
	border: true,
	frame:false,
	selModel: {mode: 'SIMPLE', headerWidth:26}, //added
	selType: 'checkboxmodel', //added
	listeners:
	{
		edit: function(editor, e)
		{
			e.grid.store.save();
		}
	},
	viewConfig: {
		emptyText : '<table width="97%" height="97%" align="center" valign="middle"><tr><td align="center" valign="middle"><div  class="iconExclamation"></div><div class="font_normal11">No reports to bind</div></td></tr></table>',
		deferEmptyText:false,
		plugins:
		{
			ptype: 'gridviewdragdrop',
			pluginId: 'gridviewdragdrop',
			dragText: 'Drag and drop to reorganize the configuration',
			onViewRender : function(view){
				var me = this, scrollEl;
				if (me.enableDrag)
				{
					if (me.containerScroll)
					{
							scrollEl = view.getEl();
                    }
                    me.dragZone = new Ext.view.DragZone({
						view: view,
						ddGroup: me.dragGroup || me.ddGroup,
						dragText: me.dragText,
						containerScroll: me.containerScroll,
						scrollEl: scrollEl,
						//to remember if the row was selected originally or not
						onBeforeDrag: function(data, e) {
							var me = this,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							if (!selectionModel.isSelected(record))
							{
								data.rowSelected = false;
							}
							return true;
						},
						onInitDrag: function(x, y){
							var me = this,
								data = me.dragData,
								view = data.view,
								selectionModel = view.getSelectionModel(),
								record = view.getRecord(data.item);
							//for deselect the dragged record
							if (selectionModel.isSelected(record) && data.rowSelected == false) {
								selectionModel.deselect(record, true);
							}
							//added the original row so it will handle that in the drag drop
							data.records = [record];
							me.ddel.update(me.getDragText());
							me.proxy.update(me.ddel.dom);
							me.onStartDrag(x, y);
							return true;
						}
					});
				}
				if (me.enableDrop) {
					me.dropZone = new Ext.grid.ViewDropZone({
						view: view,
						ddGroup: me.dropGroup || me.ddGroup,
						//changed the selection at the end of this method
						handleNodeDrop : function(data, record, position) {
							var view = this.view,
								store = view.getStore(),
								index, records, i, len;

							if (data.copy)
							{
								records = data.records;
								data.records = [];
								for (i = 0, len = records.length; i < len; i++) {
								data.records.push(records[i].copy());
								}
							}
							else
							{
								data.view.store.remove(data.records, data.view === view);
							}
							if (record && position)
							{
								index = store.indexOf(record);
								if (position !== 'before') {
									index++;
								}
								store.insert(index, data.records);
							}
							else
							{
								store.add(data.records);
							}
							if (view != data.view) {
								view.getSelectionModel().select(data.records);
							}
							appConstants.appObj.getController(appConstants.appController).updateOrder();
						}
                    });
                }
			}
		}
	},
	columns: [
	{
		text: 'REPORT NAME',
		dataIndex: 'reportNames',
		flex: 1,
		sortable :false,
		updateEl: true,
		editor: 
		{
            xtype: 'textfield',
            allowBlank: false,
			maxLength:32,
			enforceMaxLength: true,
			listeners:
			{
				change:function( obj, e, eOpts )
				{
					Ext.getCmp('updateBooklet').show();
				}
			}
        },
		renderer :function(value, metaData, record, row, col, store, gridView)
		{
			if(value.trim()=='')
				return;
			metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
			return value;
		}
	},
	{
		header: 'PAGE RANGE',
		width : 110,
		sortable :false,
		dataIndex: 'pageRange',
		hidden:true,
		renderer :function(value, metaData, record, row, col, store, gridView)
		{
			var dispVal = value;
			metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
			return dispVal;
		}
	},
	{
		header: 'TIMELINE',
		width : 140,
		sortable :false,
		dataIndex: 'isAnyTimeline',
		renderer :function(value, metaData, record, row, col, store, gridView)
		{
			var dispVal = value;
			metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
			return dispVal;
		}
	},
	{
		header: 'SIZE',
		width : 110,
		sortable :false,
		dataIndex: 'fileSize',
		renderer :function(value, metaData, record, row, col, store, gridView)
		{
			var dispVal = value;
			metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
			return dispVal;
		}
	},
	{
		header: 'MODIFIED DATE',
		width : 150,
		dataIndex: 'modifiedDate',
		sortable :false,
		doSort: function(state)
		{
			var ds = me.store;
			var field = this.getSortParam();
			ds.sort({
				property: field,
				direction: state,
				sorterFn: function(v1, v2){
					v1 = v1.get(field);
					v2 = v2.get(field);
					 var oldDt = new Date(v1);
					 var newDt = new Date(v2);
					// var diffDays = oldDt.getDate() - newDt.getDate();

					// transform v1 and v2 here
					return oldDt.getTime() > newDt.getTime() ? 1 : (oldDt.getTime() < newDt.getTime() ? -1 : 0);
				}
			});
		},
		renderer :function(value, metaData, record, row, col, store, gridView)
		{
			var dispVal = value;
			var hrefUrl = record.get('favHrefUrl');
			if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
			{
				dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
			}
			metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
			return dispVal;
		}
	},
	{
		header: '<div style="margin-top:-2px;cursor:pointer" id="removeAllReport" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
		xtype : 'actioncolumn',
		sortable :false,
		height:20,
		width :35,
		dataIndex : 'remove',//..
		renderer:function(value, metaData, record, row, col, store, gridView)
		{
			value = '<div  data-qtip="Remove" data-qclass="yellowTip" style="cursor:pointer;position:relative;height:18px;margin: 0px auto;top:2px;" class="iconDelete"   ></div>';
			return value;
		},
		listeners :
		{
			'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
			{
				appConstants.appObj.getController(appConstants.appController).deleteSingleReport(grid,record);
			}
		}
	},

	],
	store: new Ext.data.Store({
		sortOnLoad:false,
		fields: [{name:'reportID'},{name:'reportNames'},{name:'pageRange'},{name:'isAnyTimeline'},{name:'fileSize'},{name:'modifiedDate'}],
		data: []
	}),
	//ptype: 'cellediting',
	plugins:cellEditing,
	
});