Ext.define('BookletApp.view.CustomWindow', {
    extend: 'Ext.window.Window',
	requires:[
	    'BookletApp.view.BookletReportGrid'],
    alias: 'widget.customwindow',
	width:635,
	height:268,
	padding:0,
	header:{
		style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
	},
	ghost:false,
	frame:false,
	border:true,
	ui:'newPopupWindow withBorderShadow newplainHeader_border',
	//cls:'reportBinderWindow',
	modal:true,
	closable:true,
	draggable:false,
	resizable:false,
    layout: 'column',
    closeAction: 'destroy',
	buttonAlign :'center',
	defaults:
	{
		labelSeparator:'',
		labelAlign:'top',
	},
	items: [
		{
			xtype:'textfield',
			cls: 'textbox',
			id:'binderNameField',
			itemId:'binderNameField',
			fieldLabel: 'Booklet Name',
			columnWidth:.27,
			margin : '10 5 10 10',
			maxLength:32,
			enforceMaxLength: true,
			//readOnly:true,
			listeners:
			{
				change:function( obj, e, eOpts )
				{
					Ext.getCmp('updateBooklet').show();
				},
			}
		},
		{
			xtype:'textfield',
			cls: 'textbox',
			id:'descriptionField',
			itemId:'descriptionField',
			fieldLabel: 'Description',
			columnWidth:.53,
			margin : '10 5 10 5',
			listeners:
			{
				change:function( obj, e, eOpts )
				{
					Ext.getCmp('updateBooklet').show();
				},
			}
		},
		{
			//xtype: 'container',
			//html:'<div>Items in Booklet : <span class="font_bold11">3</span></div>',
			xtype:'textfield',
			cls: 'textbox',
			fieldLabel: 'No. of Reports',
			name: 'booletItemField',
			id:'booletItemField',
			columnWidth:.20,
			margin : '10 10 10 5',
			readOnly:true
		},
		{
			xtype:'bookletReportGrid',
			height:124,
			columnWidth:1.0,
			margin:'0 10 0 10'
		},
		{
			xtype:'container',
			margin:'10 0 0 0',
			columnWidth:1.0,
			layout:{
				type:'hbox',
				pack :'center',
			},
			items:[
				{
					xtype: 'button',
					text:'Bind Reports',
					ui:'newButtonSmall',
					width:90,
					id:'bindReport',
					name:'bindReport',
					margin:'0 10 0 0',
					disabled:true,
				},
				{
					xtype: 'button',
					text:'Update',
					ui:'newButtonSmall',
					width:90,
					id:'updateBooklet',
					name:'updateBooklet',
					hidden:true
				}
			]
		}
	],
	listeners:
	{
		beforeclose: function(win) {
			cellEditing.cancelEdit();
		},
	}
});