	Ext.define('BookletApp.view.Days_of', {
		extend: 'Ext.form.FieldContainer',
		alias: 'widget.days_of_the_week',
		fieldLabel:'Mail on',
		layout: 'column',
		id:'days_of',
		//hidden:true,
		items:[
			{
				xtype: 'textfield',
				cls: 'textbox',
				columnWidth:.80,
				value:'',
				margin:'0 5 0 0',
				maskRe: /[A-Za-z0-9 .,]/,
				readOnly:true,
				id: 'days_of_week',
				name:'days_of_week'
			},
			{
				xtype: 'button',
				iconCls: 'iconOneClickMultiselectExpand',
				tooltip: '<b>Days of week</b>',
				columnWidth:.20,
				style:
				{
					 background: 'none',
					 border: '0px'
				 },
				handler:function(obj)
				{
					//appConstants.appObj.getController(appConstants.appController).openOverPopup('DAYS OF WEEK','mailOnTf', daysOfWeekData,true);
					var selectedDaysInfoArray=new Array();
					var ddTxtValue=Ext.getCmp('days_of_week').getValue();
					selectedDaysInfoArray=ddTxtValue.split(",");
					Ext.create('Ext.window.Window',{
						
						width:200,
						ui:'newPopupWindow',
						id:'builderSubWindow',
						border:false,
						frame:false,
						modal: true,
						ghost: false,
						style:{
							'background':'transparent !important'
						},
						bodyStyle:{
							'background':'transparent !important'
						},
						closeAction: 'destroy',
						height:250,
						//padding:'0 10 5 10',
						
						header:false,
						
						listeners:
						{
							afterrender: function () {
								Ext.EventManager.onWindowResize(function () {
									var me = this;
									me.center();
								}, this);
							}
						},
						items:[{
							xtype:'panel',
							layout: 'column',
							title:'Days of Week',
						//	ui:'newFormFieldsInPopup popupHeaderBottomBorder',
							ui:'newFormFieldsInPopup',
							buttonAlign:'center',
							bodyPadding:'0 10 0 10',
							margin:5,
							tools:[
							{
								xtype: 'container',
								margin: '0 1px 0 1px',
								cls: 'iconBg close',
								itemId:'closeTool',
								items: [{
									xtype: 'button',
									iconCls: 'iconCloseNew',
									//tooltip: '<b>Close</b>',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Close'
											});
										},
										click:function(){
											Ext.getCmp('builderSubWindow').doClose();
										}
									}
								}]
							}],
							items:[
								{
									xtype: 'multiselect',
									width:'100%',
									height:160,
									layout: 'fit',
									border : 0,
									autoScroll:false,
									scroll:false,
									labelAlign:'left',
									baseCls: 'egmultiselect',
									multiSelect: true,
									id: 'componentsClone',
									name: 'componentsClone',
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: []
									}),
									value: [],
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									listeners:{
										afterrender: function ()
										{
											this.getStore().loadRawData(dayOfWeekData);
											this.setValue(selectedDaysInfoArray);
										}
									},
								}
							],
							buttons:[
								{
									text:'Select',
									id: 'expand',
									//cls:'quickMenuWhiteButton',
									ui:'newButtonSmall',
									margin:10,
									name: 'expand',
									handler: function()
									{
										if ( Ext.getCmp('componentsClone').getValue() != '')
										{

											var comboVal= Ext.getCmp('componentsClone').getValue();

											Ext.getCmp('days_of_week').setValue(comboVal);
											this.up('window').destroy();
										}
										else
										{
											 Ext.MessageBox.show({
												title: 'Alert',
												msg: 'Please Choose the Day(s)',
												buttons: Ext.MessageBox.OK,
												icon: Ext.MessageBox.WARNING
											});
											return;
										}
									}
								}
							]
						}]
					}).show();
					}
				}
		]
	});

