Ext.apply(Ext.form.VTypes, {
	mail_id_validations: function(value, field)
	{
		var flag = true;
		if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false")
		{
			if(!validateSingleByte(value))
			{
				field.vtypeText=mailID_DBLerror_msg;
				flag = false;
			}
		}
		if(isScheduleSave!=null && isScheduleSave!="undefined" && isScheduleSave.toLowerCase()=="false")
		{
			var mailErrorMsg=checkmultiplemailid(value,false);
			if(mailErrorMsg!=true)
			{
				field.vtypeText=_checkmail;
				flag = false;
			}
		}
		else if(checkmultiplemailid(value,false)!=true)
		{
			field.vtypeText=_checkmail;
			flag = false;
		}
		return flag;
	}
});
Ext.define('BookletApp.view.scheduleWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.schedulewindow',
	requires:[
		'BookletApp.view.Days_of'
		],
	width:550,
	height:218,
	//padding:'10 10 10 10',
	ghost:false,
	frame:true,
	border:true,
	//cls:'reportBinderWindow',
	ui:'newPopupWindow',
	modal:true,
	closable:true,
	draggable:false,
	resizable:false,
	layout:'fit',
	id:'schedulewindowId',
	style:{
		'background':'transparent !important'
	},
	bodyStyle:{
		'background':'transparent !important'
	},
    closeAction: 'destroy',
	buttonAlign :'center',
	//bodyPadding:10,
	header:false,
	items:[{
		xtype:'panel',
		layout: 'column',
		title:'Header',
		ui:'newFormFieldsInPopup popupHeaderBottomBorder',
		id:'windowInnerPanel',
		bodyPadding:'0 10 10 10',
		margin:5,
		defaults:
		{
			labelSeparator:'',
			labelAlign:'top',
			margin : '10 5 5 5',
			columnWidth:.33
		},
		tools:[
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			cls: 'iconBg close',
			itemId:'closeTool',
			items: [{
				xtype: 'button',
				iconCls: 'iconCloseNew',
				//tooltip: '<b>Close</b>',
				style: {
					background: 'none',
					border: '0px'
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Close'
						});
					},
					click:function(){
						Ext.getCmp('schedulewindowId').doClose();
					}
				}
			}]
		}],
		items:[
			{
				xtype:'textfield',
				cls: 'textbox',
				id:'scheduleNameField',
				itemId:'scheduleNameField',
				fieldLabel:'Schedule Booklet Name',
			maxLength:64,
			enforceMaxLength: true
			},
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				id: 'schedule_mail_freq',
				name: 'schedule_mail_freq',
				fieldLabel:'Mail',
				editable:false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				store:new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
				listeners:
				{
					'change':function()
					{
						var weekly = this.getValue();
						var mailOns = Ext.getCmp('schedule_mail_on');
						mailOns.show()
						mailOns.getStore().removeAll();
						if( weekly === 'Weekly')
						{
							Ext.getCmp('days_of').hide()
							mailOns.getStore().loadRawData(jsonData.mailOnWeekJSON);
							mailOns.setValue(jsonData.mailOnWeekJSON[0].valueField);
						}
						else if( weekly === 'Monthly')
						{
							Ext.getCmp('days_of').hide();
							mailOns.getStore().loadRawData(jsonData.mailOnMonthJSON);
							mailOns.setValue(jsonData.mailOnMonthJSON[0].valueField);
						}
						else if( weekly === 'Days_of_the_week')
						{
							mailOns.hide();
							Ext.getCmp('days_of').show();
						}
						else
						{
							mailOns.hide();
							Ext.getCmp('days_of').hide();
						}
					}
				}
			},
			{
				xtype: 'scrollcombo',
				editable:false,
				cls: 'dropdown',
				labelAlign:'top',
				id : 'schedule_mail_on',
				name : 'schedule_mail_on',
				fieldLabel:'Mail On',
				displayField: 'displayField',
				valueField: 'valueField',
				editable:false,
				queryMode: 'local',
				store:new Ext.data.Store(
				{
					fields: ['displayField','valueField'],
					data: []
				})
			},
			{
				xtype: 'days_of_the_week'
			},
			{
				xtype: 'textfield',
				cls: 'textbox',
				fieldLabel:'Mail ID',
				id : 'mail_id',
				name : 'mail_id',
				afterLabelTextTpl: '<span style="color:red;line-height:1em" class="font_bold14" data-qtip="Required">*</span>',
				vtype:'mail_id_validations',
				msgTarget: 'side',
				maxLength:512,
				enforceMaxLength: true
			},
			{
				xtype: 'scrollcombo',
				editable:false,
				cls: 'dropdown',
				fieldLabel:'Schedule Type',
				id : 'schedule_held_on',
				name : 'schedule_held_on',
				displayField: 'displayField',
				valueField: 'valueField',
				editable:false,
				queryMode: 'local',
				store:new Ext.data.Store({
					fields: ['displayField','valueField'],
					data: []
				}),
				listeners:
				{
					'change':function()
					{
						var value = this.getValue();
						if(value == 'AnyTime')
						{
							Ext.getCmp('schedule_at').show();
						}
						else
						{
							Ext.getCmp('schedule_at').hide();
						}
					}
				}
			},
			{
				xtype: 'fieldcontainer',
				id:'schedule_at',
				layout:'column',
				defaults:
				{
					labelSeparator:'',
					labelAlign:'top',
				},
				items:[
					{
						fieldLabel: 'Hrs',
						xtype: 'scrollcombo',
						cls: 'dropdown',
						editable:false,
						id : 'fromHours',
						name : 'fromHours',
						margin:'0 5 0 0',
						columnWidth:.5,
						displayField: 'displayField',
						valueField: 'valueField',
						editable:false,
						queryMode: 'local',
						store:new Ext.data.Store({
							fields: ['displayField','valueField'],
							data: []
						})
					},
					{
						fieldLabel: 'Mins',
						xtype: 'scrollcombo',
						editable:false,
						cls: 'dropdown',
						id : 'fromMinutes',
						name : 'fromMinutes',
						labelSeparator:'',
						displayField: 'displayField',
						valueField: 'valueField',
						columnWidth:.5,
						editable:false,
						queryMode: 'local',
						store:new Ext.data.Store({
							fields: ['displayField','valueField'],
							data: []
						})
					}
				]
			},
			{
				xtype:'container',
				margin:'10 0 10 0',
				columnWidth:1.0,
				layout:{
					type:'hbox',
					pack :'center',
				},
				items:[
					{
						xtype: 'button',
						text:'Save Schedule',
						ui:'newButtonSmall',
						width:100,
						id:'scheduleReport',
						name:'scheduleReport',
					}
				]
			}
		]
	}]
});