Ext.define('CapacityCorrelationReports.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
    ],
    init: function () {
        this.control({
            'main newUtilities': {
                'afterrender': this.loadTools
            },
            'main': {
                'afterrender': this.loadDefaults
            },
			'capacitycorrelationreportssettings': {
                'afterrender': this.loadSettings
            },
            'capacitycorrelationreportsmainform': {
                'render': this.showConfigPopup
            },
            'defineconfigurationpopup  button[name="defineconfigclose"]': {
                'click': this.closePanel
            },
            'defineconfigurationpopup combo[name="er_option"]': {
                'select': this.AnalysisOnChange
            },
            'defineconfigurationpopup combo[name="er_comptype"]': {
                'select': this.compTypeOnchange
            },
            'defineconfigurationpopup combo[name="er_test"]': {
                'select': this.compTypeOnchange
            },
            'defineconfigurationpopup combo[name="er_component"]': {
                'select': this.compTypeOnchange
            },
            'defineconfigurationpopup combo[name="er_site"]': {
                'select': this.compTypeOnchange
            },
            'defineconfigurationpopup combo[name="er_dataZone"]': {
                'select': this.compTypeOnchange
            },
            'defineconfigurationpopup button[name="addMeasure"]': {
                'click': this.addMeasureSelection
            },
            'capacitycorrelationreportsmainform combo[name="er_type"]': {
                'select': this.reportTypeOnChange
            },
            'capacitycorrelationreportssettings combo[name="er_plot"]': {
                'select': this.plotOnChange
            },
            'capacitycorrelationreportssettings combo[name="er_dataoption"]': {
                'select': this.dataOptionChange
            },
            'capacitycorrelationreportssettings combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'capacitycorrelationreportssettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'capacitycorrelationreportssettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
          /*  'capacitycorrelationreportssettings combo[name="er_excwe"]': {
                'select': this.weekendOnChange
            },*/
            'capacitycorrelationreportsmainform button[name="submit"]': {
                'click': this.showResult
            },
            'capacitycorrelationreportsmainform button[name="save"]': {
                'click': this.goTo
            },
			'timeline combo[name="er_mode"]':
						{
				'select': this.changeEr_mode
			  },
            'newUtilities > #printTool > button': {
                'click': this.printReport
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #csvTool > button': {
                'click': this.saveCsv
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.saveSchedule
            },
			'capacitycorrelationreportsmainform button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            }
        });
    },
	goTo: function (btn) {
		var hiddenFields =  appConstants.publicjsonData['hiddenfields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + appConstants.queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite(btn);
		}
	},
    printReport: function () {
        var s_qryString = "/final/reporter/ErCapacityCorrelationReportPrint.jsp?" + appConstants.publicjsonData.saveQString + "&pdfPrint=yes";
      parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    changeEr_mode: function (combo) {
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
		var favorite_id = hiddenFields["favorite_id"];
		//var favorite_id = appConstants.publicjsonData['hiddens']["favorite_id"];
		var from_schModify = hiddenFields["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.showResult();
     },
    saveReportAsPDF: function () {
        var saveQString = appConstants.publicjsonData.saveQString;
        saveQString += "&pageWidthProces=1024";
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
        if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
    },
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQString;
        saveQString += "&pageWidthProces=1024";
        var s_qryString = saveQString;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var finalParams = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails + "&isSubmit=true&isSchedule=true";;
		if(finalParams != null)
			bookletquery=encodeURI(finalParams);
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
    sendMail: function () {
        Ext.widget('sendmail').show();
    },
    saveCsv: function () {
        window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
    },
    saveFavorite: function (btn) {
		var btnID = btn.getId();
        var isValid = this.validateMainForm();
        /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Capactity Correlation',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        } */
        this.updateQueryString();
        var finalParams = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails;
        if (isValid) {
			var hiddenFields = appConstants.publicjsonData['hiddenfields'];
			var favorite_id = hiddenFields["favorite_id"];
			var target = "../servlet/com.eg.ErFavoriteC?" + encodeURI(finalParams) + "&isFavorite=true&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
			if (btnID == 'save')
			{
				//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}else {
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
        } else return;
    },
    saveSchedule: function (btn) {
		var btnID = btn.getId();
        var isValid = this.validateMainForm();
        if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: 'Virtualization',
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            isValid = false;
        }
        this.updateQueryString();
        var finalParams = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails + "&isSubmit=true&isSchedule=true";;
        if (isValid) {
             var target = "/final/reporter/ErSaveSchedule.jsp?" + encodeURI(finalParams)+"&com.eg.CSRF_NONCE="+csrfToken;
			 if (btnID == 'save')
			 {
				// document.location=target+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			 }else {
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			 }

        } else return;
    },
    showResult: function ()
	{
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
        var isValid = this.validateMainForm();
        if (isValid && this.validateSettings()) this.submitReport();
     },
    validateMainForm: function () {
        if (appConstants.firstMeasureDetails == undefined || appConstants.firstMeasureDetails == '') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Report',
                msg: 'Please select the first measure for correlation',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        if (appConstants.secondMeasureDetails == undefined || appConstants.secondMeasureDetails == '') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Report',
                msg: 'Please select the second measure for correlation',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        return true;
    },
    validateSettings: function () {
        var isSettingsOk = true;
        var reportgen;
		if(isSettingsEnabled)
			reportgen=Ext.getCmp('reportGeneration').getValue();
		else
			reportgen=appConstants.publicjsonData.reportGeneration;

        var MaxDaysInMonth = appConstants.publicjsonData['hiddenfields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicjsonData['hiddenfields']['userTimeline'];
        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);
        if (!checkDateTime(stDate, enDate)) {
            isSettingsOk = false;
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Capacity Correlation settings',
                    msg: userTimelineErrorMsg,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }
        if (reportgen != null && reportgen == 'foreground') {
            var limitforbg = appConstants.publicjsonData['hiddenfields']['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    isSettingsOk = false;
                }
            }
        } else {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)) isSettingsOk = false;
        }
        return isSettingsOk;
    },
	showConfirmResult : function(btn){
		if(btn=="yes"){
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			this.submitReport();
		}
		else{
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			this.showResult();
 		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		else if (Ext.getCmp('reportGeneration').getValue() == 'background-csv' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	 },
    submitReport: function () {
        appConstants.initLdgMask.show();
        var reportGeneration;
			if(isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicjsonData.reportGeneration;
        this.updateQueryString(true);
        var finalParams = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails;
        if (reportGeneration == 'foreground') {
            urlforAjax = '../servlet/com.eg.ErCapacityCorrelationReportC';
            finalParams += "&isSubmit=true&responseType=json";
        } else if (reportGeneration == 'background') {
            urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
		else if (reportGeneration == 'background-csv') {
            urlforAjax = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname + "&isSubmit=true&responseType=json";
        }
		//by karthikeyan
 	finalParams += '&er_RmDispName='+appConstants.er_RmDispName;
                //
        Ext.Ajax.request({
            url: urlforAjax,
            params: finalParams,
            method: 'POST',
            scope: this,
            async: true,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.publicjsonData = jsonData;
                this.loadReportData(appConstants.publicjsonData);
            }
        });
		if(isSettingsEnabled)
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
    },
    loadReportData: function (jsonData) {

        var resultPanelObj = Ext.getCmp('resultPanel');
        var reportGeneration = appConstants.publicjsonData.reportGeneration;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
        if (reportGeneration == 'foreground') {
			resultPanelObj.removeAll();
            itemsArray = new Array();
            var reportData = jsonData.reportData;
             var fieldContainerArray = new Array();
			var chartType =jsonData['chartType'];
            //if (jsonData.hasOwnProperty('reportData') && !jsonData.noDataFound) {
				if(!Ext.isEmpty(reportData)){
                var reportType = jsonData.er_type;
                if (reportType == 'Yes') {
					if(!Ext.isEmpty(reportData.chartUrl) && reportData.chartUrl.indexOf('undefined')<0){
						//resultPanelObj.setTitle("<span class='font_bold'>"+reportData.title+"</span>");
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						if(chartType == 'highchart'){
							//resultPanelObj.setTitle("<span class='font_bold'>"+reportData.chartTitle+"</span>");
							resultPanelObj.setTitle(reportData.chartTitle);
							resultPanelObj.add({
								xtype: 'panel',
								//title:reportData.chartTitle,
								ui:'newGraphPanel',
 								style: {
									'text-align': 'center'
								},
								html:'<div id="highChart" style="width:95%;height:400px;"></div>'
							});
							reportHighStockChart(reportData.chartUrl+"&chartType="+chartType,'highChart',300,900);
						}
						else
						{
							var chartImagUrl = reportData.chartUrl;	
							chartImagUrl += "&isChartImag=true&userSkin="+strSkin;
							resultPanelObj.add({
								xtype: 'container',
								padding: '15',
								style: {
									'text-align': 'center'
								},
								items: [{
										xtype: 'image',
										src: chartImagUrl,
										width: 700,
										height: 400
									}
								]
							});
						}
						resultPanelObj.show();
						resultPanelObj.doLayout();
						//reportHighStockChart(reportData.chartUrl+"&chartType="+chartType,'highChart',300,900);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					} else {
						resultPanelObj.hide();
						this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().show();
					}
                } else if (reportType == 'No') {
					if (reportData.columns != undefined || reportData.dataArray != undefined)
					{
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						//Ext.getCmp("upbutton").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						var columnDetails = reportData.columns;
						var dataArraytoStore = reportData.dataArray;
						var fieldstoStore = new Array();
						var mainColumnsObjArray = new Array();
						var align='center';
						if(columnDetails[key]!=null && columnDetails[key] == 'DATE/TIME')
						{
							align='left';
						}
						for (var key in columnDetails) {
							fieldstoStore.push(key);
							mainColumnsObjArray.push({
								header: columnDetails[key],
								sortable: true,
								dataIndex: key,
								align: align,
								flex: 1,
								//prakash
								renderer:function(value)
								{
									value = Ext.getCmp('gridId').getDecimalAlignFormat(value);
									return value;
								}  
								//
							});
						}
						var storeObj = Ext.create('Ext.data.ArrayStore', {
							fields: fieldstoStore,
							data: dataArraytoStore,
							sorters: { property: fieldstoStore[0], direction : 'DESC' }
						});
						/*var gridpanel = Ext.widget('customgrid', {
							store: storeObj,
 							autoScroll:true,
							scroll:true,
							cls:'gridSkin horizontal-scroll',
  							sortableColumns: true,
							columns: mainColumnsObjArray,
							//title: reportData.chartTitle,
						});	 */
						//itemsArray.push(gridpanel);
						itemsArray.push({
							xtype:'panel',
							ui:'newGraphPanel',
							//title:reportData.chartTitle,
							items:[{
								xtype:'customgrid',
								ui:'newGridPanel',
								id:'gridId',
								margin:'0 10 10 10',
								store: storeObj,
								autoScroll:true,
								scroll:true,
								border:true,
								//cls:'gridSkin horizontal-scroll',
								sortableColumns: true,
								columns: mainColumnsObjArray,
							}]
						});
						Ext.getCmp("csvTool").setDisabled(false);		  
						resultPanelObj.removeAll();
						resultPanelObj.setTitle(reportData.chartTitle);
						resultPanelObj.add(itemsArray);
						resultPanelObj.show();
						resultPanelObj.doLayout();
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}else {
						resultPanelObj.hide();
						this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().show();
					}
                }

                appConstants.initLdgMask.hide();
            } else {
                this.disableTools();
                resultPanelObj.hide();
				this.getNomeasurepanel().doLayout();
				this.getNomeasurepanel().show();
                appConstants.initLdgMask.hide();
            }
        } else if (reportGeneration == 'background' || reportGeneration == 'background-csv') {
            resultPanelObj.hide();
 			var htmlStr = '';
            var backgroundReportStatus = jsonData.backgroundReportStatus;
            if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;

               htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';

            } else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
                var bgroundResponseTxt = jsonData.bgroundResponseTxt;
                var bgroundReportsURL = jsonData.bgroundReportsURL;
                var backgroundAnchor = jsonData.backgroundAnchor;
                htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
            } else {
                htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:400px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>';
            }
			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
            appConstants.initLdgMask.hide();
        }
    },
    dataOptionChange: function (obj) {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        if (obj.getValue() != 'Measure') {
            Ext.getCmp('er_trendoption').show();
        } else Ext.getCmp('er_trendoption').hide();
    },
    plotOnChange: function (obj) {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        if (obj.getValue() != 'Data') Ext.getCmp("er_range").show();
        else Ext.getCmp("er_range").hide();
    },
    addMeasureSelection: function () {
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        if (Ext.getCmp('er_option').getValue() != 'Component') {
            var s_group = Ext.getCmp("er_site");
            if (s_group.getValue() == '-1') {
                Ext.MessageBox.show({
                    title: 'Capacity Correlation Measure',
                    msg: s_group.getStore().getAt(0).get('displayField'),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        var s_comptype = Ext.getCmp("er_comptype");
        if (s_comptype.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Measure',
                msg: s_comptype.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var s_component = Ext.getCmp("er_component");
        if (s_component.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Measure',
                msg: s_component.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var s_test = Ext.getCmp("er_test");
        if (s_test.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Measure',
                msg: s_test.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var s_measure = Ext.getCmp("er_measure");
        if (s_measure.getValue() == '-1') {
            Ext.MessageBox.show({
                title: 'Capacity Correlation Measure',
                msg: s_measure.getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        var s_info = Ext.getCmp("er_info");
        if (s_info.getValue() == '-1') {
            if (s_info.getStore().getCount() > 1) {
                Ext.MessageBox.show({
                    title: 'Capacity Correlation Measure',
                    msg: s_info.getStore().getAt(0).get('displayField'),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        if (appConstants.isFirstMeasure) {
            appConstants.firstMeasureDetails = "&er_datafrom=" + Ext.getCmp("er_option").getValue() + "&er_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_component=" + Ext.getCmp("er_component").getValue() + "&er_test=" + Ext.getCmp("er_test").getValue() + "&er_measure=" + Ext.getCmp("er_measure").getValue() + "&er_info=" + appConstants.erUtils.specialCharEncode(Ext.getCmp("er_info").getValue()) + "&er_site=" + Ext.getCmp("er_site").getValue() + "&er_dataZone=" + Ext.getCmp("er_dataZone").getValue();
        } else if (appConstants.isSecondMeasure) {
            appConstants.secondMeasureDetails = "&er_cr_datafrom=" + Ext.getCmp("er_option").getValue() + "&er_cr_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_cr_component=" + Ext.getCmp("er_component").getValue() + "&er_cr_test=" + Ext.getCmp("er_test").getValue() + "&er_cr_measure=" + Ext.getCmp("er_measure").getValue() + "&er_cr_info=" + appConstants.erUtils.specialCharEncode(Ext.getCmp("er_info").getValue()) + "&er_cr_site=" + Ext.getCmp("er_site").getValue() + "&er_cr_dataZone=" + Ext.getCmp("er_dataZone").getValue();
        }
        this.updateQueryString();
        var QString = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails;
        Ext.Ajax.request({
            url: '/final/reporter/ErCapacityCorrelationReportJson.jsp',
            params: QString,
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.publicjsonData = jsonData;
                Ext.getCmp('xaxis').update('<b>' + jsonData.screenLabels['reporter.capacity.X Axis Measure'] + '</b><br/><div style="padding:10px 4px 8px 0px"><a href="javascript:void(0)" id="defineconfigurationx" style="text-decoration:underline">' + jsonData.X_AXIS['TEXT'] + '</a></div>');
                Ext.getCmp('yaxis').update('<b>' + jsonData.screenLabels['reporter.capacity.Y Axis Measure'] + '</b><br/><div style="padding:10px 4px 8px 0px"><a href="javascript:void(0)" id="defineconfigurationy" style="text-decoration:underline">' + jsonData.Y_AXIS['TEXT'] + '</a></div>');

				Ext.getCmp("popup").hide();
                Ext.getCmp('resultPanel').hide();
                this.disableTools();
				 Ext.getCmp('capacitycorrelationreports').doLayout();
				comboRawData = jsonData.dataOptionCombo;
				selectedComboOption = jsonData.er_dataoption;
				comboObject = Ext.getCmp('er_dataoption');
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				if (!Ext.isEmpty(jsonData.trendDataOptionCombo)) {
					if (selectedComboOption != 'Measure') {
						comboObject.show();
					}
					comboRawData = jsonData.trendDataOptionCombo;
					selectedComboOption = jsonData.er_trendoption;
					comboObject = Ext.getCmp('er_trendoption');
					comboObject.setFieldLabel(jsonData.screenLabels['reporter.capacity.Trend Data']);
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
            }
        });
    },
    compTypeOnchange: function (obj) {
        this.updateQStringPopup();
        var QString = appConstants.QstringPopup;;
        var actionfrom = obj.getId();
        if (actionfrom == 'er_comptype') QString += "&compTypeChange=true";
        Ext.Ajax.request({
            url: '/final/reporter/ErCapacityCorrelationMeasureSelection.jsp',
            scope: this,
            params: QString,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                if (actionfrom == 'er_site' || actionfrom == 'er_dataZone') {
                    comboRawData = jsonData.compTypeCombo;
                    selectedComboOption = jsonData.er_comptype;
                    comboObject = Ext.getCmp('er_comptype');
					comboObject.getStore().clearFilter(true); 
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                }
                if (actionfrom == 'er_comptype' || actionfrom == 'er_site' || actionfrom == 'er_dataZone') {
                    comboRawData = jsonData.componentCombo;
                    selectedComboOption = jsonData.er_component;
                    comboObject = Ext.getCmp('er_component');
					comboObject.getStore().clearFilter(true);
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                    comboRawData = jsonData.testCombo;
                    selectedComboOption = jsonData.er_test;
                    comboObject = Ext.getCmp('er_test');
					comboObject.getStore().clearFilter(true);
                    comboObject.getStore().loadRawData(comboRawData);
                    if (!Ext.isEmpty(selectedComboOption)) {
                        comboObject.setValue(selectedComboOption);
                    } else {
                        comboObject.setValue(comboRawData[0].valueField);
                    }
                }
                comboRawData = jsonData.measureCombo;
                selectedComboOption = jsonData.er_measure;
                comboObject = Ext.getCmp('er_measure');
				comboObject.getStore().clearFilter(true);
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
                comboRawData = jsonData.infoCombo;
                selectedComboOption = jsonData.er_info;
                comboObject = Ext.getCmp('er_info');
				comboObject.getStore().clearFilter(true);
                comboObject.getStore().loadRawData(comboRawData);
                if (!Ext.isEmpty(selectedComboOption)) {
                    comboObject.setValue(selectedComboOption);
                } else {
                    comboObject.setValue(comboRawData[0].valueField);
                }
            }
        });
    },
    AnalysisOnChange: function () {
        this.updateQStringPopup();
        Ext.Ajax.request({
            url: '/final/reporter/ErCapacityCorrelationMeasureSelection.jsp?measureOption=first',
            scope: this,
            params: appConstants.QstringPopup,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                this.fillMeasurePopup(jsonData);
            }
        });
    },
    updateQStringPopup: function () {
        var datafrom = Ext.getCmp("er_option").getValue();
        var FormParams = "er_option=" + datafrom + "&er_datafrom=" + datafrom + "&er_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_component=" + Ext.getCmp("er_component").getValue() + "&er_test=" + Ext.getCmp("er_test").getValue() + "&er_measure=" + Ext.getCmp("er_measure").getValue() + "&er_info=" + Ext.getCmp("er_info").getValue() + "&er_site=" + Ext.getCmp("er_site").getValue() + "&er_dataZone=" + Ext.getCmp("er_dataZone").getValue();
        /*if(datafrom != 'Component'){
			FormParams+="&er_site="+Ext.getCmp("er_site").getValue();
			if(datafrom!='Zone')
		}*/
        appConstants.QstringPopup = FormParams;
    },
    loadDefaults: function () {
		if(!appConstants.hideBackButton){
			Ext.getCmp('capacitycorrelationreports').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}
        appConstants.firstMeasureDetails = appConstants.publicjsonData.X_AXIS['firstMeasureDetails'];
        appConstants.secondMeasureDetails = appConstants.publicjsonData.Y_AXIS['secondMeasureDetails'];
        this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
        this.fillFormFields(appConstants.publicjsonData);
        this.refreshReportData();
    },
    refreshReportData: function () {
        if (appConstants.isSubmit == "true") {
            appConstants.initLdgMask.show();
            if (!Ext.isEmpty(appConstants.publicjsonData.reportData) && appConstants.publicjsonData.hasOwnProperty('reportData'))
            {
				this.loadReportData(appConstants.publicjsonData);
            }
			else
			{
				this.showResult();
			}			
        }
    },
    fillFormFields: function (jsonData) {
        var screenLabels = jsonData.screenLabels;
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
        var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
        if ((from_schedule != null && from_schedule == "Yes") ||(fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}

        var comboRawData;
        var selectedComboOption;
        var comboObject;
        comboRawData = jsonData.reportTypeCombo;
        selectedComboOption = jsonData.er_type;
        comboObject = Ext.getCmp('er_type');
        comboObject.setFieldLabel(screenLabels['reporter.common.Report Type']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		if(selectedComboOption == 'No'){
			comboObject = Ext.getCmp('xAxisLabel');
			comboObject.setFieldLabel(screenLabels['reporter.capacity.X Axis Label']);
			comboObject.hide();
			comboObject = Ext.getCmp('yAxisLabel');
			comboObject.setFieldLabel(screenLabels['reporter.capacity.Y Axis Label']);
			comboObject.hide();
		}
		else{
			selectedComboOption = jsonData.xAxisLabel;
			comboObject = Ext.getCmp('xAxisLabel');
			comboObject.setFieldLabel(screenLabels['reporter.capacity.X Axis Label']);
			comboObject.setValue(selectedComboOption);
			selectedComboOption = jsonData.yAxisLabel;
			comboObject = Ext.getCmp('yAxisLabel');
			comboObject.setFieldLabel(screenLabels['reporter.capacity.Y Axis Label']);
			comboObject.setValue(selectedComboOption);
		}
        Ext.getCmp('xaxis').update('<b>' + screenLabels['reporter.capacity.X Axis Measure'] + '</b><br/><div style="padding:10px 4px 8px 0px"><a href="javascript:void(0)" id="defineconfigurationx" style="text-decoration:underline">' + jsonData.X_AXIS['TEXT'] + '</a></div>');
        Ext.getCmp('yaxis').update('<b>' + screenLabels['reporter.capacity.Y Axis Measure'] + '</b><br/><div style="padding:10px 4px 8px 0px"><a href="javascript:void(0)" id="defineconfigurationy" style="text-decoration:underline">' + jsonData.Y_AXIS['TEXT'] + '</a></div>');

        var timelineRawData = jsonData.timelineCombo;
        var selectedTimeline = jsonData.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);
        if (!Ext.isEmpty(timelineRawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                timelineObj.setValue(selectedTimeline);
            } else {
                timelineObj.setValue(timelineRawData[0].valueField);
            }
        }

		var start_hour = jsonData.startHour;
        var end_hour = jsonData.endHour;
        var start_date = jsonData.startDate;
        var end_date = jsonData.endDate;
        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.startDateForDisplay);
        startDateObj.dataArray = start_date;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.startHourForDisplay);
        startHrObj.dataArray = start_hour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.endDateForDisplay);
        endDateObj.dataArray = end_date;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.endHourForDisplay);
        endHrObj.dataArray = end_hour;
        stmin = jsonData.startMinForDisplay;
        enmin = jsonData.endMinForDisplay;
        mgr_stmin = jsonData.startmin;
        mgr_enmin = jsonData.endmin;

    },
	loadSettings:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
 		var jsonData=appConstants.publicjsonData;
		var screenLabels = appConstants.publicjsonData.screenLabels;
 		var comboRawData = jsonData.dataOptionCombo;
        var selectedComboOption = jsonData.er_dataoption;
        var comboObject = Ext.getCmp('er_dataoption');
        comboObject.setFieldLabel(screenLabels['reporter.capacity.Correlate Using']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

		if (!Ext.isEmpty(jsonData.trendDataOptionCombo)) {
            if (selectedComboOption != 'Measure') {
                comboObject.show();
            }
            comboRawData = jsonData.trendDataOptionCombo;
            selectedComboOption = jsonData.er_trendoption;
            comboObject = Ext.getCmp('er_trendoption');
            comboObject.setFieldLabel(screenLabels['reporter.capacity.Trend Data']);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
        }
        comboRawData = jsonData.plotCombo;
        selectedComboOption = jsonData.er_plot;
        comboObject = Ext.getCmp('er_plot');
        comboObject.setFieldLabel(screenLabels['reporter.common.Plot']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        if (selectedComboOption != 'Data') {
			Ext.getCmp('er_range').show();
		}
		comboRawData = jsonData.groupingCombo;
        selectedComboOption = jsonData.er_range;
        comboObject = Ext.getCmp('er_range');

		comboObject.setFieldLabel(screenLabels['reporter.common.X Axis Grouping Unit']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }

        comboRawData = jsonData.excludeWeekCombo;
        selectedComboOption = jsonData.excludeWeek;
        comboObject = Ext.getCmp('er_excwe');
        comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        /*var excludeDaysObj = Ext.getCmp('excludeDays');
        if (selectedComboOption == 'Yes') {
            excludeDaysObj.show();
            excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
        }*/
		var repoMaking ="";
		if (appConstants.reporGene!=undefined)
		{
			repoMaking= appConstants.reporGene;
		}
		else
		{
			repoMaking= jsonData;
		}
		var reportGenCombo = repoMaking.reportGenerationCombo;
        var selreportGeneration = repoMaking.reportGeneration;
        var reportGen = Ext.getCmp('reportGeneration');
        reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
        reportGen.getStore().loadRawData(reportGenCombo);
        reportGen.setValue(selreportGeneration);
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('capacitycorrelationreports');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    updateQueryString: function () {
		var er_dataoption,er_plot,er_trendoption,er_range,reportGeneration,er_excwe;
		if (!isSettingsEnabled)
		{
			var jsonData=appConstants.publicjsonData;
			 er_dataoption=jsonData.er_dataoption
			 er_plot=jsonData.er_plot
			 er_trendoption=jsonData.er_trendoption
			 er_range=jsonData.er_range
			 er_excwe=jsonData.excludeWeek
			 reportGeneration=jsonData.reportGeneration
		}
		else
		{
			 er_dataoption=Ext.getCmp("er_dataoption").getValue();
			 er_plot=Ext.getCmp("er_plot").getValue();
			 er_trendoption=Ext.getCmp("er_trendoption").getValue();
			 er_range=Ext.getCmp("er_range").getValue();
			 er_excwe=Ext.getCmp("er_excwe").getValue();
			 reportGeneration=Ext.getCmp("reportGeneration").getValue();
		}
        var FormParams;
        var hiddenfieldQString = '';
        var timelineParams;
        var reportType = Ext.getCmp('er_type').getValue();
        FormParams = "&er_type=" + reportType + "&er_dataoption=" + er_dataoption + "&er_plot=" + er_plot + "&er_trendoption=" + er_trendoption + "&er_range=" + er_range+ "&er_excwe=" +er_excwe+ "&er_mode=" + Ext.getCmp("er_mode").getValue() + "&er_reportgenration=" + reportGeneration;
		if (reportType == 'Yes') {
            FormParams += "&xAxisLabel=" + Ext.getCmp("xAxisLabel").getValue() + "&yAxisLabel=" + Ext.getCmp("yAxisLabel").getValue();
        }
        FormParams += "&xAxisLabel=" + Ext.getCmp("xAxisLabel").getValue()
        var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
        var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
        var timelineParams = "&er_timeline=" + Ext.getCmp("er_timeline").getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
            var hiddenFields = appConstants.publicjsonData.hiddenfields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        appConstants.queryString = FormParams + timelineParams + hiddenfieldQString;
    },
    showConfigPopup: function () {
		var popupPanle = Ext.getCmp('popup');
		Ext.EventManager.onWindowResize(function()
		{
			popupPanle.doComponentLayout();
			popupPanle.setWidth(Ext.getBody().getViewSize().width-80);
		});

        thisController = this;
        Ext.getBody().on('click', function () {
            Ext.Ajax.request({
                url: "/final/reporter/ErCapacityCorrelationMeasureSelection.jsp?" + appConstants.publicjsonData.X_AXIS['qString'],
                scope: this,
                success: function (response) {
                    appConstants.isFirstMeasure = true;
                    appConstants.isSecondMeasure = false;
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
					if (!isSettingsEnabled)
					{
						thisController.showConfigDropdown();
					}

                    thisController.fillMeasurePopup(jsonData);
                    Ext.getCmp('popup').show();
                }
            });
        }, null, {
            delegate: 'a#defineconfigurationx'
        });
        Ext.getBody().on('click', function () {
            Ext.Ajax.request({
                url: "/final/reporter/ErCapacityCorrelationMeasureSelection.jsp?" + appConstants.publicjsonData.Y_AXIS['qString'],
                scope: this,
                success: function (response) {
                    appConstants.isFirstMeasure = false;
                    appConstants.isSecondMeasure = true;
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
					if (!isSettingsEnabled)
					{
						thisController.showConfigDropdown();
					}
                    thisController.fillMeasurePopup(jsonData);
                    Ext.getCmp('popup').show();
                }
            });
        }, null, {
            delegate: 'a#defineconfigurationy'
        });
    },
	 showConfigDropdown: function () {
 		isSettingsEnabled=true;
		var thisController = this;
        var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
        Ext.create('Ext.container.Container', {
           // padding: 5,
            width: 565,
            id: 'configMod',
            //cls: 'configMode_popup',
			ui:'settingsWindowContainer',
             items: [
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'capacitycorrelationreportssettings',
					parent:this
				}
            ],
			onRender:function(){
				Ext.EventManager.onWindowResize(function () {
					Ext.get('configMod').setStyle('left', '');
				});
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
            renderTo: 'capacitycorrelation-body'
        });
    },
    fillMeasurePopup: function (jsonData) {
        var screenLabels = jsonData.screenLabels;
        var comboRawData;
        var selectedComboOption;
        var comboObject;
        comboRawData = jsonData.analysisCombo;
        selectedComboOption = jsonData.er_option;
        comboObject = Ext.getCmp('er_option');
        comboObject.setFieldLabel(screenLabels['reporter.capacity.Analyze by']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        var datafrom = jsonData.er_option;
        if (datafrom != 'Component') {
            comboRawData = jsonData.siteCombo;
            selectedComboOption = jsonData.er_site;
            comboObject = Ext.getCmp('er_site');
            comboObject.setFieldLabel(screenLabels["reporter.compliance.eventlog." + datafrom]);
            comboObject.getStore().loadRawData(comboRawData);
            if (!Ext.isEmpty(selectedComboOption)) {
                comboObject.setValue(selectedComboOption);
            } else {
                comboObject.setValue(comboRawData[0].valueField);
            }
            Ext.getCmp('er_site').show();
            if (datafrom == 'Zone') {
                Ext.getCmp('er_dataZone').show();
            } else Ext.getCmp('er_dataZone').hide();
        } else {
            Ext.getCmp("er_site").hide();
            Ext.getCmp('er_dataZone').hide();
        }
        comboRawData = jsonData.subzoneCombo;
        selectedComboOption = jsonData.er_dataZone;
        comboObject = Ext.getCmp('er_dataZone');
        comboObject.setFieldLabel(screenLabels["reporter.comparison.Include Subzone"]);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.compTypeCombo;
        selectedComboOption = jsonData.er_comptype;
        comboObject = Ext.getCmp('er_comptype');
        comboObject.setFieldLabel(screenLabels['reporter.consolidated.Component Type']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.componentCombo;
        selectedComboOption = jsonData.er_component;
        comboObject = Ext.getCmp('er_component');
        comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.testCombo;
        selectedComboOption = jsonData.er_test;
        comboObject = Ext.getCmp('er_test');
        comboObject.setFieldLabel(screenLabels['reporter.common.Test']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.measureCombo;
        selectedComboOption = jsonData.er_measure;
        comboObject = Ext.getCmp('er_measure');
        comboObject.setFieldLabel(screenLabels['reporter.common.Measure']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
        comboRawData = jsonData.infoCombo;
        selectedComboOption = jsonData.er_info;
        comboObject = Ext.getCmp('er_info');
        comboObject.setFieldLabel(screenLabels['reporter.comparison.Descriptor']);
		comboObject.getStore().clearFilter(true);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
    },
    closePanel: function () {
        Ext.getCmp('popup').hide();
    },
    loadTools: function () {
        this.getNewUtilities().loadIcon(true, //save
        true, //print
        true, //mail
        false, //data
        true, //cvs
        true, // fav
        true, // schedule
        false, //diagnosis
        false, //togglebutton
        false, //close
        true //booklet
        );
        Ext.getCmp("scheduleTool").setDisabled(false);
        Ext.getCmp("favoriteTool").setDisabled(false);
    },
    reportTypeOnChange: function (obj) {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var er_type= Ext.getCmp("er_type").getValue();
		
		
			var QString = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails;
			Ext.Ajax.request({
				url: '/final/reporter/ErCapacityCorrelationReportJson.jsp?er_type='+er_type,
				params: appConstants.queryString,
				scope: this,
				success: function (response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.reporGene = jsonData;
					if (isSettingsEnabled)
					{
						var reportGenCombo = jsonData.reportGenerationCombo;
						var selreportGeneration = jsonData.reportGeneration;
						var reportGen = Ext.getCmp('reportGeneration');
						reportGen.getStore().loadRawData(reportGenCombo);
						reportGen.setValue(selreportGeneration);
						var reportNameObj = Ext.getCmp('bgReportName');
						if(selreportGeneration!=undefined && selreportGeneration!=null && selreportGeneration=='foreground')
						{
							reportNameObj.hide();
							Ext.getCmp('moreOptionCloseId').show();
							Ext.getCmp('submitViaSetting').hide();
						}
						else
						{
							reportNameObj.show(); 
							Ext.getCmp('submitViaSetting').show();
							Ext.getCmp('moreOptionCloseId').hide();
						}
					}
				}
			 });
		
		var val = obj.value;
		if (val == 'Yes') {
			Ext.getCmp("xAxisLabel").show();
			Ext.getCmp("yAxisLabel").show();
		} else {
			Ext.getCmp("xAxisLabel").hide();
			Ext.getCmp("yAxisLabel").hide();
		}
    },
    reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();
        if (reportGenType == 'background')
		{
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
        } 
		else if (reportGenType == 'background-csv')
		{
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
        } 
		else 
		{
            Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
        }
    },
    timeLineOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var startDateObj = Ext.getCmp('er_stdate');
        var startHrObj = Ext.getCmp('er_sthr');
        var endDateObj = Ext.getCmp('er_enddate');
        var endHrObj = Ext.getCmp('er_endhr');
        var timelineObj = Ext.getCmp('er_timeline');
        if (timelineObj.getValue() == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            timelineObj.suspendEvents(true);
            this.updateQueryString();
            var QString = appConstants.queryString + appConstants.firstMeasureDetails + appConstants.secondMeasureDetails;
            Ext.Ajax.request({
                url: '/final/reporter/ErCapacityCorrelationReportJson.jsp',
                params: QString,
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    appConstants.publicjsonData = jsonData;
                    var start_hour = jsonData.startHour;
                    var end_hour = jsonData.endHour;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
            timelineObj.resumeEvents();
        }
    },
  /*  weekendOnChange: function () {
        var weekendvalue = Ext.getCmp('er_excwe').getValue();;
        var excludeDaysObj = Ext.getCmp('excludeDays');
        if (weekendvalue == 'Yes') {
            excludeDaysObj.show();
            excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
        } else {
            excludeDaysObj.hide();
        }
    },*/
    disableTools: function () {
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
       // Ext.getCmp("upbutton").setDisabled(true);
        Ext.getCmp("csvTool").setDisabled(true);
    }
});