Ext.define('CapacityCumulationReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector : 'defineconfiguration', ref:'defineconfiguration'},
		{selector : 'defineconfigurationpopup', ref:'defineconfigurationpopup'},
		{selector : 'configdatas', ref:'configdatas'},
		{selector : 'selectiondetails', ref:'selectiondetails'},
		{selector : 'print', ref:'print'},
		{selector: 'graphpanel', ref: 'graphpanel'},
		{selector: 'capacitycumulationreportssettings', ref: 'capacitycumulationreportssettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],	
	init : function() {
		this.control({
					'main' : 
					{
						'afterrender' : this.afterMainRender,
						'boxready': this.loadGrid,
 					},
					'main newUtilities' : 
					{
						'afterrender' : this.hideTools
					},
					'defineconfigurationpopup' : 
					{
						'afterrender' : this.renderPopUp
					},
					'capacitycumulationreportssettings':
					{
						'afterrender': this.afterSettingsRender
					},
					'capacitycumulationreportssettings combo[id="er_timeline"]':
					{
						//'select': this.changeTimeline
					},
					'capacitycumulationreportssettings combo[id="reportGeneration"]':
					{
						'select': this.changeReportGeneration
					},
					'capacitycumulationreportssettings button[id="moreOptionCloseId"]': {
						'click': this.validateAndCloseSettings
					},
					'capacitycumulationreportssettings button[id="submitViaSetting"]': {
						'click': this.closeSettingAndSubmit
					},
					'capacitycumulationreportssettings combo[id="cumulate"]':
					{
						'select': this.changeCumulate
					},
					'main button[id="defineconfiguration"]' : 
					{
						'click' : this.defineConfigurationPOPUP
					},
					'defineconfigurationpopup button[id="expandSelectorComponent"]':
					{
						'click':this.expandSelectorComponent
					},
					'defineconfigurationpopup button[id="expandSelectorDescriptor"]':
					{
						'click':this.expandSelectorDescriptor
					},
					'defineconfigurationpopup  button[id="add"]' : 
					{
						'click' : this.addToGrid
					},
					'defineconfigurationpopup  combo[id="test"]':
					{
						'select': this.changeTest
					},
					'defineconfigurationpopup boundlist[id="componentsSelector"]':
					{
						//'itemclick': this.changeComponent
					},
					'defineconfigurationpopup multiselect[id="compname"]':
					{
						'change': this.changeComponent
					},
					'defineconfigurationpopup  button[id="defineconfigclose"]' : 
					{
						'click' : this.closePanel
					},
					'defineconfiguration button[id="submit"]' : 
					{
						'click' : this.formSubmit
					},
					'defineconfiguration button[name="save"]': 
					{
						'click' : this.goTo
					},
					'configdatas' : 
					{
						'afterrender' : function(cmp) 
						{
							var me = this;
							Ext.getBody().on('click', function() 
							{
								me.defineConfigurationPOPUP();
							}, null, {
										delegate : 'b#linkId'
									});
						}
						
					},					
					'timeline combo[name="er_mode"]': 
					{
						'select': this.changeEr_mode
					 },
					'newUtilities > #saveTool > button' : 
					{
						'click' : this.saveFileTool
					},
					'newUtilities > #printTool > button' : 
					{
						'click' : this.printFile
					},
					'newUtilities > #mailTool > button' : 
					{
						'click' : this.sendMail
					},
					'newUtilities > #favoriteTool > button' : 
					{
						'click' : this.sendFavorite
					},
					'newUtilities > #scheduleTool > button' : 
					{
						'click' : this.sendSchedule
					},
					'defineconfigurationpopup trigger[id="compSearch"]':
					{
						'change': this.filterMultiselect
					},
					'defineconfigurationpopup trigger[id="descSearch"]':
					{
						'change': this.filterMultiselect
					},
					'defineconfiguration button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					},
					'main button[id="excelToolBtn"]':{
						'click':this.saveExcel
					}
				});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt =this.getDefineconfiguration();
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},	
	hideTools:function(){
		
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
			);
	},
	goTo: function (btn) {
						// by karthikeyan
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
						title : 'Capacity Reports',
						msg : 'Chosen timeline not allowed',
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				return;
		}
//
 		var hiddenFields =  appConstants.publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.sendSchedule(btn);
		}else{
			this.sendFavorite(btn);
		}
	},
	changeEr_mode: function (combo) {
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (isSettingsEnabled)
		{
				Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		}
	
		this.formSubmit( Ext.getCmp('submit'));
     },
	filterMultiselect: function (obj) {

        var compId = obj.getId();
		if(compId =='compSearch')
		 {
			compStore=appConstants.rawDataForComponents;
			compName='compname';
		 }
		else if(compId =='descSearch')
		 {
			compStore=appConstants.rawDataForDescriptor;
			compName='descriptor';
		 }
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);      
    },
	sendFavorite: function(obj)
	{
		this.getQueryString();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+appConstants.queryString+'&isSubmit=true&cmd=client'+'&er_RmDispName='+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+favorite_id;
		if (obj.text=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
	},
	sendSchedule: function(obj)
	{
		this.getQueryString();
		var target = '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString+'&CSVFileAsExcel=yes&com.eg.CSRF_NONCE='+csrfToken;
		if (obj.text=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveFileTool: function()
	{
		if ( !Ext.isEmpty( appConstants.publicJSON['PDF_URL'] ) )
		{
        		var pdfURL = appConstants.publicJSON['PDF_URL'];
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(pdfURL.indexOf(setLegendVal)==-1){
					if(pdfURL.indexOf("&showLegend=")>-1){
						if(islegendEnabled =='true'){
							pdfURL = pdfURL.replace("&showLegend=false",setLegendVal);
						}else{
							pdfURL = pdfURL.replace("&showLegend=true",setLegendVal);
						}
					}else
						pdfURL+=setLegendVal;
				}
			}		
			if (Ext.isEmpty(appConstants.erUtils))
			{
			appConstants.erUtils = Ext.widget("erutils");
			}
			
  			appConstants.erUtils.savePDF(pdfURL);
		}
	},
	bookletQuery: function(obj)
	{
		if ( !Ext.isEmpty( appConstants.publicJSON['PDF_URL'] ) )
		{
        	var pdfURL = appConstants.publicJSON['PDF_URL'];
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(pdfURL.indexOf(setLegendVal)==-1){
					if(pdfURL.indexOf("&showLegend=")>-1){
						if(islegendEnabled =='true'){
							pdfURL = pdfURL.replace("&showLegend=false",setLegendVal);
						}else{
							pdfURL = pdfURL.replace("&showLegend=true",setLegendVal);
						}
					}else
						pdfURL+=setLegendVal;
				}
			}	
		}
		var s_qryString = '';
		s_qryString = pdfURL.replace('../reporter/ErHtmlToSavePdf.jsp?','');
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile: function()
	{
		//Ext.widget('print').show();
		//Ext.widget('print').setTitle('CAPACITY CUMULATION REPORT');
		//var printContentDiv = Ext.select('#printContentDiv');
		if ( !Ext.isEmpty( appConstants.publicJSON['PRINT_URL'] ) )
		{
        		var printURL = appConstants.publicJSON['PRINT_URL'];
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(printURL.indexOf(setLegendVal)==-1){
					if(printURL.indexOf("&showLegend=")>-1){
						if(islegendEnabled =='true'){
							printURL = printURL.replace("&showLegend=false",setLegendVal);
						}else{
							printURL = printURL.replace("&showLegend=true",setLegendVal);
						}
					}else
						printURL+=setLegendVal;
				}
			}
		parent.printWindowFn(printURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			
		}

	},
	saveExcel:function(){
		window.location="../servlet/com.eg.ErCumulationXlsController";
	},
	sendMail: function()
	{
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 appConstants.drillDownParams = "&showLegend="+islegendEnabled;
		}
	     Ext.widget('sendmail').show();
 	},
	changeCumulate: function( obj )
	{
		var getVal = Ext.getCmp('cumulate').getValue();
		if ( getVal == 'Measure' )
		{
			Ext.getCmp('rtype').hide();
		}
		else
		{
			Ext.getCmp('rtype').show();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeReportGeneration: function( obj )
	{
		var getReportVal = Ext.getCmp('reportGeneration').getValue();
		if ( getReportVal == 'background' )
		{
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		if ( getTimelineVal == 'Any' )
		{
			Ext.getCmp('er_stdate').setDisabled(false);
			Ext.getCmp('er_sthr').setDisabled(false);
			Ext.getCmp('er_enddate').setDisabled(false);
			Ext.getCmp('er_endhr').setDisabled(false);
		}
		else
		{
			Ext.getCmp('er_stdate').setDisabled(true);
			Ext.getCmp('er_sthr').setDisabled(true);
			Ext.getCmp('er_enddate').setDisabled(true);
			Ext.getCmp('er_endhr').setDisabled(true);
		}
		if ( !Ext.isEmpty( obj ) && getTimelineVal != 'Any' )
		{
			this.hideResult();
			this.formSubmit( obj );
		}
	},
	getHiddenQstr: function(flag)
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}
			if(flag && key == 'loadCombination' || key == 'toScrpt' || key == 'toScrpText')
			{
				continue;
			}
			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	formSubmit: function( obj )
	{
		appConstants.isBeforeSubmittedSchedule=true;
 		var configDatas = Ext.getCmp("configdatas");
		var selectionModelObj = configDatas.getSelectionModel();
		if(selectionModelObj.getCount()==0)
        {
		
		Ext.getCmp('graphpane').hide();		
        	Ext.Msg.show({
                                    title : 'Alert',
                                    msg : 'Choose your selection to view the report',
                                    buttons : Ext.Msg.OK,
                                    icon : Ext.Msg.WARNING
                         });
                         return;
        }
		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
		if (!this.validateSettings())
		{
			return;
		}	
		this.submitRequest(obj);
	},
	submitRequest:function(obj){
	
		var me = this;
		var mainFormTimeline = this.getDefineconfiguration().getForm();
		var mainForm = this.getDefineconfigurationpopup().getForm();
		
		var showLegend = Ext.getCmp('showLegend').checked;
		var actionFrom = '';
		var isFromTimeline = false;
		var isSubmit = false;
		var hiddenFields = appConstants.publicJSON['hiddens'];
        var from_schedule = hiddenFields["fromScheduleModify"];
        var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if (fromFavoriteModify !=  null && fromFavoriteModify == "Yes")
		{
			this.sendFavorite(obj);
			return;
		}
		if (from_schedule !=  null && from_schedule == "Yes")
		{
			this.sendSchedule(obj);
			return;
		}
		if ( !Ext.isEmpty( obj ) )
		{
			actionFrom = obj.getId();
		}
		if ( !Ext.isEmpty( actionFrom ) )
		{
			if ( actionFrom == 'er_timeline' )
			{
				isFromTimeline = true;
			}
			else if ( actionFrom == 'submit' )
			{
				isSubmit = true;
			}
		}
	
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		

		if (!isSettingsEnabled)
		{
			er_dataoptionVal = appConstants.publicJSON['selectedValues']['cumulateSelected'];
			er_reportgenrationVal = appConstants.publicJSON['selectedValues']['reportGenSelected'];
			er_summaryTypeVal =appConstants.publicJSON['selectedValues']['summarySelected'];
			decimal_point=appConstants.publicJSON['selectedValues']['selected_decimal_point'];
		}
		else
		{ 
			var settingsForm = Ext.getCmp('settings').getForm(); 
			er_dataoptionVal = settingsForm.findField('cumulate').getValue();
			er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
			er_summaryTypeVal = settingsForm.findField('rtype').getValue();
		}
		//
		var hiddenQstr = '';
		if(er_reportgenrationVal!=null && er_reportgenrationVal == 'foreground')
		{
			hiddenQstr = this.getHiddenQstr(false);
		}
		else
		{
			hiddenQstr = this.getHiddenQstr(true);
		}
		
		var qstr = hiddenQstr+'&showLegend='+showLegend;

			var decimal_point_obj = Ext.getCmp('decimal_point');
			if(decimal_point_obj!=undefined)
				decimal_point = decimal_point_obj.getValue();

		//
		var testVal = mainForm.findField('test').getValue();		
		var startdateVal = mainFormTimeline.findField('er_stdate').dataArray;
		var enddateVal = mainFormTimeline.findField('er_enddate').dataArray;
		var starthrVal = mainFormTimeline.findField('er_sthr').dataArray;
		var endhrVal = mainFormTimeline.findField('er_endhr').dataArray;
		var er_timelineVal = mainFormTimeline.findField('er_timeline').getValue();	
		var er_measureVal = mainForm.findField('Measure').getValue();
		var er_modeVal = mainFormTimeline.findField('er_mode').getValue();
		var descVal = mainForm.findField('descriptor').getValue();
		var er_info_listVal = '';
		for ( var i = 0;i < descVal.length; i++ )
		{
			er_info_listVal += '&er_info_list='+appConstants.erUtils.specialCharEncode(descVal);
		}
		var forwardtoVal = 'ErCapacityCumulationReport';
		
		var gridObj = Ext.getCmp('configdatas')
		var selectionStr = '';
		var combinationStr = '';
		var er_componentStr = ''
		var compVal = mainForm.findField('compname').getValue();
		
		for ( var key in compVal )
		{
			er_componentStr += '&er_component='+encodeURI(compVal[key]);
		}
		var selectedObj = gridObj.getSelectionModel();
		for ( var i = 0; i < gridObj.getStore().getCount() ; i++ )
		{
			if ( selectedObj.isSelected( gridObj.getStore().getAt(i) ) )
			{
				var getVal = gridObj.getStore().getAt(i).get('hiddens');
				if(er_reportgenrationVal!=null && er_reportgenrationVal == 'foreground')
				{
					selectionStr += '&er_selection='+encodeURIComponent(getVal);
				}else
				{
					selectionStr += '&er_selection='+appConstants.erUtils.specialCharEncode(getVal);
				}
				combinationStr += appConstants.erUtils.specialCharEncode(getVal)+'0eghash0eghash0';
			}
		} 
		var er_compination = combinationStr+selectionStr+er_componentStr+er_info_listVal;
		var er_compination = combinationStr;
		qstr += '&er_mode='+er_modeVal+'&er_test='+encodeURI(testVal)+'&includesubzone=null&er_dataoption='+encodeURI(er_dataoptionVal)+'&startdate='+encodeURI(startdateVal)+'&er_timeline='+encodeURI(er_timelineVal)+'&enddate='+encodeURI(enddateVal)+'&starthr='+encodeURI(starthrVal)+'&endhr='+encodeURI(endhrVal)+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+
		'&er_reportgenration='+encodeURI(er_reportgenrationVal)+'&er_summaryType='+encodeURI(er_summaryTypeVal)+'&er_measure='+encodeURI(er_measureVal)+'&er_combination='+er_compination+selectionStr+er_componentStr+er_info_listVal+'&showLegend='+showLegend+"&decimal_point="+decimal_point;
		var URL = '/final/reporter/ErCapacityCumulationReportJSON.jsp'; 
		if ( isSubmit )
		{
			if ( er_reportgenrationVal == 'foreground' )
			{ 
				URL = '/final/servlet/com.eg.ErRepoLiteC';
					
			}
			else
			{
				var reportNameVal = Ext.getCmp('bgReportName').getValue();  
				URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				forwardtoVal = 'ErCapacityCumulationReportJSON';
				reportNameVal=checkFileName(reportNameVal);
				qstr += '&bg_reportname='+encodeURI(reportNameVal);
			}
			qstr += '&isSubmit=true';
		}
		qstr += '&forwardto='+forwardtoVal;
        	qstr +="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = qstr;
		if ( !Ext.isEmpty( appConstants.reqFromSchedule ) )
		{
			if ( appConstants.reqFromSchedule == 'Yes' && obj.getId() == 'submit' )
			{
				document.location = '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString;
			}
		}	
		if ( isSubmit )
		{
			qstr += '&call=json';
			appConstants.initLdgMask.show();
		}
		Ext.Ajax.request({
			url: URL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					appConstants.publicJSON = jsonData;
					if ( isFromTimeline )
					{
						mainFormTimeline.findField('er_stdate').setValue( jsonData['startDateForDisplay'] );
						mainFormTimeline.findField('er_enddate').setValue( jsonData['endDateForDisplay'] );
						mainFormTimeline.findField('er_sthr').setValue( jsonData['startHourForDisplay'] );
						mainFormTimeline.findField('er_endhr').setValue( jsonData['endHourForDisplay'] );
					}
					else if ( isSubmit )
					{
						var resultData = jsonData['RESULTS'];
						chartType =jsonData['chartType'];
						me.getNomeasurepanel().hide();
						me.getBackGroundPanel().hide();
						if ( er_reportgenrationVal == 'foreground' )
						{
 							me.loadChart( resultData );
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
							me.enableTools();
						}
						else
						{
							var backgroundResultsData = jsonData['backgroundResults'];
 							if ( !Ext.isEmpty( backgroundResultsData ) )
							{
								me.loadBackgroundResults(backgroundResultsData);
 							}
						}
					}
				}
				appConstants.initLdgMask.hide();
			}
			
		});
	},
	loadBackgroundResults: function( backgroundResultsData )
	{
		var backgroundrResponseText = backgroundResultsData['backgroundResponseText'];
		var backgroundStatus = backgroundResultsData['status'];
		var backgroundLinkText = backgroundResultsData['backgroundText'];
		var backgroundURL = backgroundResultsData['backgroundLink'];
		var genHtml = '';
		if ( backgroundStatus == 'duplicate' )
		{
			genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundrResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundURL +'>'+ backgroundLinkText + '</a></div></td></tr></table></td></tr></table>'
		}
		else
		{
			genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundrResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundURL +'>'+ backgroundLinkText + '</a></div></td></tr></table></td></tr></table>'
		}
		
		this.getBackGroundPanel().update(genHtml);
		this.getBackGroundPanel().show();
	},
	loadChart: function( results )
	{
		var resultObj = this.getGraphpanel();
		resultObj.getHeader().show();
		if ( !Ext.isEmpty( results ) )
		{
			var title = results['TITLE'];
			var height = results['IMAGE_HEIGHT'];
			var width = results['IMAGE_WIDTH'];
			var imgTitle = results['IMAGE_TITLE'];
			var imageSrc = results['IMAGE_URL'];
			//resultObj.setTitle("<span class='font_bold'>"+title+"</span>");
			resultObj.removeAll();
			resultObj.setHeight(470);
			resultObj.show();
			chartType =appConstants.publicJSON['chartType'];
			if(chartType == 'highchart'){
				resultObj.add({
					items:[{
						xtype: 'panel',
						ui:'newGraphPanel',
						//height: '90%',
						//width: 900,
						//margin:'10 20 20 5', style="width:100%;height:900px;margin-top:-190px"
						html:'<div id="highChart" style="min-height:300px;width:97%;height:100%;" ></div>'
					}]
				});	
				resultObj.doLayout();
				reportHighStockChart(imageSrc+"&chartType="+chartType,'highChart','100%','100%');
			}
			else
			{
				if ( !Ext.isEmpty( results['LEGENDS'] ) )
				{
					var legendsData = results['LEGENDS'];
					var genHTML = '<div style="border:0px solid red;"><table  cellpadding="0" cellspacing="0">';
					for ( var i = 0; i < legendsData.length; i+=2 )
					{
						var color1 = legendsData[i]['COLOR'];
						var infos1 = legendsData[i]['INFOS'];
						
						var color2 = ''
						var infos2 = '';
						if ( i < ( legendsData.length - 1 ) )
						{
							color2 = legendsData[i+1]['COLOR'];
							infos2 = legendsData[i+1]['INFOS'];
						}
						if ( color2 == '' && infos2 == '' )
						{
							genHTML += '<tr><td style="padding:4px !important"><img src="/final/servlet/com.eg.ErImageDrawC?req='+color1+'" /></td><td style="padding:4px 30px 4px 4px !important;">'+infos1+'</td><td style="padding:4px !important">&nbsp;</td><td style="padding:4px 30px 4px 4px !important;">&nbsp;</td></tr>';
						}
						else
						{
							genHTML += '<tr><td style="padding:4px !important"><img src="/final/servlet/com.eg.ErImageDrawC?req='+color1+'" /></td><td style="padding:4px 30px 4px 4px !important;">'+infos1+'</td><td style="padding:4px !important"><img src="/final/servlet/com.eg.ErImageDrawC?req='+color2+'" /></td><td style="padding:4px 30px 4px 4px !important;">'+infos2+'</td></tr>';
						}
						
						
					}
					genHTML += '</table></div>';
					resultObj.add(
					{
						xtype: 'image',
						height: '100%',
						width: '100%',
						tooltip: imgTitle, 
						src: imageSrc+'&isChartImag=true'
					},
					{
						xtype: 'container',
						height: '100%',
						width: '100%',
						margin:'10 20 20 5',
						html: genHTML
					});
				}
				else
				{
					var htmlData="";
					Ext.Ajax.request({
						url : imageSrc,
						method: 'POST',
						params : 'forUI=yes&isChartImag=true',
						async:false,
						success: function( response )
						{
							if ( response.status == 200) 
							{
								htmlData=response.responseText;
							}
						}
					});
					resultObj.add(
					{
						xtype: 'container',
						height: '100%',
						width: '100%',
						tooltip: imgTitle,
						html: htmlData
					});
				}
			}
		}
	},
	changeComponent: function(obj, newValue, oldValue, eOpts)
	{
 		var mainForm = this.getDefineconfigurationpopup().getForm();
		var compObj = mainForm.findField('compname');
		var testObj = mainForm.findField('test');
		var descObj = mainForm.findField('descriptor');
		var getUser = appConstants.publicJSON['hiddens']['userID'];
		var params = '&P0=[NULL]&P1=['+testObj.getValue()+']&P2=['+compObj.getValue()+']&P3=[admin]';
		this.callRemoteScript(mainForm, 'descriptor', '/final/servlet/com.eg.ErRemoteScriptingServlet', params, 'getInfos1');
		compObj.setValue(compObj.getValue());
		var getFirstVal = descObj.getStore().getAt(0).get('valueField');
		if ( getFirstVal != '-1' )
		{
			descObj.getStore().insert(0,
			{
				'valueField': '-1',
				'displayField': 'All Descriptors'
			});
		}
		var task=new Ext.util.DelayedTask(function(){
			descObj.setValue('-1');
 		});
		task.delay(1);
	},
	changeTest: function( obj )
	{
 		var getVal = obj.getValue();
		var mainForm = this.getDefineconfigurationpopup().getForm();
		var measureObj = mainForm.findField('Measure');
		var compObj = mainForm.findField('compname');
		var discObj = mainForm.findField('descriptor');		
		if ( getVal != '-1' )
		{
	
			var cumulateObj = Ext.getCmp('cumulate');
			var remoteURL = '/final/servlet/com.eg.ErAjaxResponseServlet';
			Ext.Ajax.request({
				url : remoteURL,
				method: 'POST',
				async:false,
				params : 'reporttype=capacity&er_test='+Ext.getCmp('test').getValue(),
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseXML ) )
					{
						var jsonXML = response.responseXML;
 						var getVal = Ext.DomQuery.selectNode('options', jsonXML).firstChild.nodeValue;
						cumulateObj.suspendEvents(true);
						appConstants.isTestLoaded=true;
						if ( getVal == 'true' )
						{
							cumulateObj.getStore().removeAll();
							var i=0;
							for ( var key in appConstants.trendEnableArr )
							{
								cumulateObj.getStore().add({
									'displayField': key,
									'valueField': appConstants.trendEnableArr[key]
								});
									//
									if(i==0)
									cumulateObj.setValue(appConstants.trendEnableArr[key]);
									i++;
									//
							}
						}
						else
						{
							cumulateObj.getStore().removeAll();
							for ( var key in appConstants.trendEnableArr )
							{
								cumulateObj.getStore().add({
									'displayField': key,
									'valueField': appConstants.trendEnableArr[key]
								});
								cumulateObj.setValue(appConstants.trendEnableArr[key]);
								break;
							}
						}
						cumulateObj.resumeEvents();
					}
				}
			});
			var params = '&P0=['+mainForm.findField('test').getValue()+']&';
			this.callRemoteScript(mainForm, 'Measure', '/final/servlet/com.eg.ErRemoteScriptingServlet', params, 'getMeasuresForTest1');
			measureObj.getStore().insert(0,
				{
					displayField: appConstants.mapping_measure,
					valueField: '-1'
				}
			);
			measureObj.setValue('-1');
			var getUser = appConstants.publicJSON['hiddens']['userID'];
			params = '&P0=['+mainForm.findField('test').getValue()+']&P1=['+getUser+']';
			this.callRemoteScript(mainForm, 'compname', '/final/servlet/com.eg.ErRemoteScriptingServlet', params, 'getComponentsForTest1');
 			compObj.setValue(compObj.getStore().getAt(0).get('valueField'));
		}
		else
		{
 			this.insertNotApplicable( measureObj );
			this.insertNotApplicable( compObj );	
		}
		this.insertNotApplicable( discObj );
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
 	},
	hideResult: function()
	{
		this.getGraphpanel().hide();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp('bookletTool').setDisabled(true);
		Ext.getCmp('saveTool').setDisabled(true);
		Ext.getCmp('printTool').setDisabled(true);
		Ext.getCmp('mailTool').setDisabled(true);
		Ext.getCmp('excelTool').setDisabled(true);
		Ext.getCmp('favoriteTool').setDisabled(true);
		Ext.getCmp('scheduleTool').setDisabled(true);
		//Ext.getCmp('upbutton').setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp('bookletTool').setDisabled(false);
		Ext.getCmp('saveTool').setDisabled(false);
		Ext.getCmp('printTool').setDisabled(false);
		Ext.getCmp('mailTool').setDisabled(false);
		Ext.getCmp('excelTool').setDisabled(false);
		Ext.getCmp('favoriteTool').setDisabled(false);
		Ext.getCmp('scheduleTool').setDisabled(false);
		//Ext.getCmp('upbutton').setDisabled(false);
	},
	closePanel : function() {
		Ext.getCmp('popup').hide();

		if (Ext.get('linkId')) {
			Ext.get('linkId').show();
		}
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(false);
	},
	afterMainRender: function()
	{
		var localjson=appConstants.publicJSON; 
		if(!appConstants.hideBackButton){
			Ext.getCmp('defineConfig').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: localjson.hiddens['ID']
				}
			);
		}

		var mainForm = this.getDefineconfigurationpopup().getForm();
		this.disableTools();
		this.loadScreenLabels(localjson['screenLabels']);
		var selectedData = localjson['selectedValues'];
		var gridObj = this.getConfigdatas();
		gridObj.loadColumnHeaders(localjson['COLUMN_HEADERS']);

		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var no_params = '';
		var funcName = '';

		/**********To Load Test STARTS***************/
		var testComboData = localjson['testCombo'];
		var testObj = mainForm.findField('test');
		testObj.suspendEvents(true);
		if ( !Ext.isEmpty( testComboData ) )
		{
			testObj.getStore().clearFilter(true); 
			testObj.getStore().loadRawData(testComboData);
		}
		else
		{
			remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
			no_params = '&P0=[Component]&P1=[Component]&P2=[no]';
			funcName = 'getTestsForSite';
			this.callRemoteScript(mainForm, 'test', remoteURL,  no_params, funcName);
			var testObj = mainForm.findField('test');
			testObj.getStore().insert(0,
									{
										displayField: appConstants.chooseTest,
										valueField: '-1'
									}
			);
		}
		if ( !Ext.isEmpty( localjson['selectedValues']['testSelected'] ) )
		{
			testObj.setValue(localjson['selectedValues']['testSelected']);
		}
		else
		{
			testObj.setValue(testObj.getStore().getAt(0).get('valueField'));
		}
		testObj.resumeEvents();
		
		var measuerObj = mainForm.findField('Measure');
		var measureData = localjson['measureCombo'];
		if ( !Ext.isEmpty( measureData ) )
		{
			measuerObj.suspendEvents(true);
			measuerObj.getStore().clearFilter(true); 
			measuerObj.getStore().loadRawData(measureData);
			if ( !Ext.isEmpty( selectedData['measureSelected'] ) )
			{
				measuerObj.setValue(selectedData['measureSelected']);
			}
			else
			{
				measuerObj.setValue(measureData[0]['valueField']);
			}
			measuerObj.resumeEvents();
		}
		else
		{
			this.insertNotApplicable(measuerObj);
		}
		
		var compObj = mainForm.findField('compname');
		var compComboData = localjson['compCombo'];
		
		if ( !Ext.isEmpty( compComboData ) )
		{
			compObj.suspendEvents(true);
			compObj.getStore().loadRawData(compComboData);
			if ( !Ext.isEmpty( selectedData['compSelected'] ) )
			{
				compObj.setValue(selectedData['compSelected']);
			}
			else
			{
				compObj.setValue(compComboData[0]['valueField']);
			}
			compObj.resumeEvents();
		}
		else
		{
			this.insertNotApplicable(compObj);
		}
		
		var infoComboData = localjson['infoCombo'];
		var descObj = mainForm.findField('descriptor');
		if ( !Ext.isEmpty( infoComboData ) )
		{
			appConstants.rawDataForDescriptor=infoComboData;
			descObj.suspendEvents(true);
			descObj.getStore().loadRawData(infoComboData);
			if ( !Ext.isEmpty( selectedData['infoSelected'] ) )
			{
				var infoSelected = selectedData['infoSelected'];
				descObj.setValue(selectedData['infoSelected']);
			}
			descObj.resumeEvents();
		}
		else
		{
			this.insertNotApplicable(descObj);
		}
		
		
		/**********To Load Test ENDS***************/
	
		var hiddenFields = localjson['hiddens'];
        var from_schedule = hiddenFields["fromScheduleModify"];
        var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
        if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp('submit').setText("save");
			this.hideResult();
		}else{
			Ext.getCmp('submit').setText(submitValue);
		}
		
		mainForm = this.getDefineconfiguration().getForm();

		this.setValueWithOptionInList(mainForm, 'er_timeline', localjson['timelineCombo'], localjson['selectedTimeline']);
 		mainForm.findField('er_stdate').setValue(localjson['startDateForDisplay']);
		mainForm.findField('er_stdate').dataArray=localjson['startDate'];
		mainForm.findField('er_enddate').setValue(localjson['endDateForDisplay']);
		mainForm.findField('er_enddate').dataArray=localjson['endDate'];
		mainForm.findField('er_sthr').setValue(localjson['startHourForDisplay']);
		mainForm.findField('er_sthr').dataArray=localjson['startHour'];
		mainForm.findField('er_endhr').setValue(localjson['endHourForDisplay']);
		mainForm.findField('er_endhr').dataArray=localjson['endHour'];
		mainForm.findField('er_mode').setValue(localjson['selectedGraphMode']);

	
		
		 stmin =localjson['startMinForDisplay'];
		 enmin =localjson['endMinForDisplay'];
		 mgr_stmin = localjson['startmin'];
		 mgr_enmin = localjson['endmin']; 
		// this.loadGrid();
	},
	validateSettings: function()
	{
		var hiddens=appConstants.publicJSON['hiddens'];
		var er_usertimeline =hiddens['er_usertimeline'];
		var getMaxDaysInMonth =hiddens['getMaxDaysInMonth'];
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg =hiddens['limitforbg'];
		var reportgenVal;
		if (!isSettingsEnabled)
		{
			reportgenVal=appConstants.publicJSON['selectedValues']['reportGenSelected'];
		}
		else
		{
			reportgenVal= Ext.getCmp('reportGeneration').getValue();
		}
		
		var isSettingsOk = true;
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				}
			}
			return isSettingsOk;
		}
		if ( reportgenVal == 'background' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return false;
			}
			else
			{
				return true;
			}
		}
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});		
			this.submitRequest(getButtonObj);
		}			
		else
		{
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').focus(false, 1000);
			this.formSubmit(getButtonObj);
		}
	},
	loadGrid: function()
	{
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var resultData = appConstants.publicJSON['RESULTS'];
		if (appConstants.publicJSON['selectedValues']['reportGenSelected'] == 'foreground' )
		{
			var loadCombinationData = appConstants.publicJSON['hiddens']['loadCombination'];
			loadCombinationData = appConstants.erUtils.specialCharDecode(loadCombinationData);
			var selectionData = appConstants.publicJSON['hiddens']['toScrpText'];
			selectionData = appConstants.erUtils.specialCharDecode(selectionData);
			if ( !Ext.isEmpty(loadCombinationData) && !Ext.isEmpty( selectionData ) )
			{
				var gridObj = Ext.getCmp('configdatas');
				var tmpStore = gridObj.getStore();
				var getCombination = loadCombinationData.split('0eghash0eghash0');
				var getSelection = selectionData.split('0eghash0');
				for ( var key in getCombination )
				{
					if ( getCombination[key] != undefined && getSelection[key] != undefined )
					{
						var selection = getSelection[key];
						var combination = getCombination[key];
						var getFields = selection.split(',');
						tmpStore.add({
							'Name': getFields[0],
							'Type': getFields[1],
							'Test': getFields[2],
							'Measure': getFields[3],
							'Descriptor': getFields[4],
							'hiddens': combination
						});
					}
				}
				Ext.getCmp('timelineForm').show();
				gridObj.fireEvent('selectgrid', gridObj);
				this.defineConfigurationPOPUP();
				Ext.getCmp('popup').hide();
			}
			if (!Ext.isEmpty( resultData ))
			{
				this.getGraphpanel().show();
				this.loadChart( resultData );
				this.enableTools();
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
			}			
		}
	},
	insertNotApplicable: function(obj)
	{
		var insertNotApplicableArray=[];
		insertNotApplicableArray.push({
			'displayField': appConstants.notApplicabletxt,
			'valueField': '-1'		
		});
		if (obj.getId()=='descriptor')
		{
			appConstants.rawDataForDescriptor=insertNotApplicableArray;
		}		
		else if (obj.getId()=='compname')
		{
			appConstants.rawDataForComponents=insertNotApplicableArray;
		}		
 		obj.suspendEvents(true);
 		obj.getStore().loadRawData(insertNotApplicableArray);
		obj.setValue('-1');
		obj.resumeEvents();
	},
	callRemoteScript: function( form, fieldName, remoteURL, no_params, funcName )
	{
		 
		var me = this;
		var param = 'F='+funcName+'&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
 		Ext.Ajax.request({
			url: remoteURL,
			method: 'POST',
			async: false,
			params: param,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
 					var comboVal = jsonData['combo'];
					if ( !Ext.isEmpty( comboVal ) )
					{
						form.findField(fieldName).getStore().loadRawData(comboVal);
 						if (fieldName == 'compname')
						{
 							appConstants.rawDataForComponents = comboVal;
							
						}
						else if(fieldName == 'descriptor')
						{
						 	appConstants.rawDataForDescriptor = comboVal;
						} 
					}
					else
					{
						me.insertNotApplicable(form.findField(fieldName));
					}
				}
			}
		});
	},
	afterSettingsRender: function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

 		var screenLabels=appConstants.publicJSON.screenLabels;
		var settingsForm = Ext.getCmp('settings').getForm();
 		settingsForm.findField('cumulate').setFieldLabel(screenLabels['reporter.common.CumulateUsing']);
		settingsForm.findField('rtype').setFieldLabel(screenLabels['reporter.common.ReportType']);
		settingsForm.findField('reportGeneration').setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
		settingsForm.findField('bgReportName').setFieldLabel(screenLabels['reporter.consolidated.Report Name']);
//
		settingsForm.findField('decimal_point').setValue(appConstants.publicJSON['selectedValues']['selected_decimal_point']);
//
		if(appConstants.isTestLoaded==undefined || appConstants.isTestLoaded==false)
			this.setValueWithOptionInList(settingsForm, 'cumulate', appConstants.publicJSON['cumulateCombo'], appConstants.publicJSON['selectedValues']['cumulateSelected']);
		
		this.setValueWithOptionInList(settingsForm, 'rtype', appConstants.publicJSON['summaryCombo'], appConstants.publicJSON['selectedValues']['summarySelected']);
		this.changeCumulate();		
		this.setValueWithOptionInList(settingsForm, 'reportGeneration', appConstants.publicJSON['reportGenCombo'], appConstants.publicJSON['selectedValues']['reportGenSelected']);
		this.changeReportGeneration();
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('submit'));
		}
	},
	validateAndCloseSettings :  function()
	{  		
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	 },
	loadScreenLabels: function( screenLabels )
	{
		var mainForm = this.getDefineconfigurationpopup().getForm();
		
		var title = screenLabels['TITLE'];
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else {
			if ( !Ext.isEmpty( title ) )
			{
				this.getMain().setTitle(title);
			}
		}
		var testVal = screenLabels['reporter.common.Test'];
		var measureVal = screenLabels['reporter.CapacityPlan.Measure'];
		var compVal = screenLabels['reporter.common.Component'];
		var descVal = screenLabels['reporter.CapacityPlan.Descriptor'];
		var addVal = screenLabels['reporter.common.Add'];
		
		mainForm.findField('test').setFieldLabel(testVal);
		mainForm.findField('Measure').setFieldLabel(measureVal);
		Ext.getCmp('compLbl').setText(compVal);
		Ext.getCmp('descLbl').setText(descVal);
		Ext.getCmp('add').setText(addVal);
		
		
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);
			
		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	showConfigDropdown : function() {
		
		var thisController = this;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
 		Ext.create('Ext.container.Container', {
					width : 565,
					//padding : 5,
					id : 'configMod',
					//cls : 'configMode_popup',
					ui:'settingsWindowContainer',
					items : [
						{
							xtype:'container',
							cls:'configMode_popupArrow',
							style:{'top':'-14px','left':'355px'}
						},
						{
							xtype:'container',
							html:tpl.apply(),
							cls:'containerHeader',
							style:{'top':'0px','margin':'0px'}
						},
						{
							xtype : 'capacitycumulationreportssettings',
							id: 'settings' 
						}
					],
					onRender:function(){
						Ext.EventManager.onWindowResize(function () {
							Ext.get('configMod').setStyle('left', '');
						});
						Ext.get('closeSettings').on('click', function () {
							thisController.validateAndCloseSettings();
						});
					},
					renderTo : 'capacitycumulationreports-body'
				});

	},
	defineConfigurationPOPUP : function(panel) {		
		if (Ext.get('linkId')) {
			Ext.get('linkId').hide();
		}
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(true);
		var selectionDetails=Ext.getCmp("selectionDetails");
		if (!Ext.isEmpty(selectionDetails) && !selectionDetails.isHidden()) {
			this.toggleForm(selectionDetails);
		}
		Ext.getCmp('popup').show();
	},
	renderPopUp : function(popupPanle) {
		Ext.EventManager.onWindowResize(function() {
			popupPanle.doComponentLayout();
			popupPanle.setWidth(Ext.getBody().getViewSize().width - 80);
		});
	},
	expandSelectorComponent:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('compname'),'Component',btn);		
	},
	expandSelectorDescriptor:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('descriptor'),'Descriptor',btn);			
	},	
	addToGrid: function() 
	{
		var me = this;
		var testObj = Ext.getCmp('test');
		var testVal = testObj.getValue();
		var testVal1 = testObj.getRawValue();
		var measureObj = Ext.getCmp('Measure');
		var measureVal = measureObj.getValue();
		var measureVal1 = measureObj.getRawValue();
		var gridObj = Ext.getCmp('configdatas');
		var tmpStore = gridObj.getStore();
		var compObj = Ext.getCmp('compname');
		var componentVal = compObj.getValue();
		var descObj = Ext.getCmp('descriptor');
		var descName = descObj.getValue();
		descName = Ext.widget("erutils").specialCharEncode(descName);
		var compStore = compObj.getStore();
		var cmpNameWithType = compObj.getValue();
		var result = true;
		var msg = '';
		if ( testObj.getValue() == '-1' )
		{
			result= false;
			msg = appConstants.chooseTest;
		}
		else if ( measureObj.getValue() == '-1' )
		{
			result= false;			
			msg = appConstants.mapping_measure;
		}
		else if ( cmpNameWithType.length == 0 || cmpNameWithType == '' || cmpNameWithType == '-1' )
		{
			result = false;
			msg = appConstants.requiredParamsMsg;
		}
		if ( !result )
		{
			Ext.Msg.show({
				title : 'Alert',
				msg : msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var params='ReportName=cumulation';
		params+='&testNameVal='+testVal;
		params+='&testNameDisp='+appConstants.erUtils.specialCharEncode(testVal1);
		params+='&measureNameVal='+measureVal;
		params+='&measureNameDisp='+appConstants.erUtils.specialCharEncode(measureVal1);
		params+='&descName='+descName;
		params+='&componentVal='+componentVal;
		params+='&appTestVal=';
		params+='&appMeasureVal=';
		if(tmpStore.getCount()>0)
		{
			var gridStoreAry = new Array();
			for ( var k = 0; k < tmpStore.getCount(); k++ )
			{
				//gridStoreAry.push(tmpStore.getAt(k).data);
				var tmpObj = new Object();
				tmpObj = {
					Name : tmpStore.getAt(k).data.Name, 
					Type : tmpStore.getAt(k).data.Type,
					Test : appConstants.erUtils.specialCharEncode(tmpStore.getAt(k).data.Test),
					Measure : appConstants.erUtils.specialCharEncode(tmpStore.getAt(k).data.Measure),
					Descriptor : appConstants.erUtils.specialCharEncode(tmpStore.getAt(k).data.Descriptor), 
					hiddens : appConstants.erUtils.specialCharEncode(tmpStore.getAt(k).data.hiddens) 
				}
				gridStoreAry.push(tmpObj);
			}
			params+='&gridStore='+Ext.encode(gridStoreAry);
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: params,
			async: false,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.hasMultipleTests = false;
				if (!Ext.isEmpty( jsonData ))
				{
					var status = jsonData['status'];
					var errorMsg = jsonData['errorMsg'];
					var gridData = jsonData['gridData'];
					if(status=='success')
					{
						if (tmpStore.getCount() >= 4) 
						{
							//Ext.getCmp('dockitem').show();
							Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
						}
						if (tmpStore.getCount() == 3)
						{ 
							Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
						}
						if (!isSettingsEnabled)
						{
							me.showConfigDropdown();
						}
						tmpStore.removeAll();
						tmpStore.loadRawData(gridData);
						gridObj.getSelectionModel().selectAll();
						gridObj.doLayout();
						gridObj.getSelectionModel().selectAll();
						Ext.getCmp("scheduleTool").setDisabled(false);
						Ext.getCmp("favoriteTool").setDisabled(false);
						Ext.getCmp('timelineForm').show();
					}
					//
					else
					{
						Ext.Msg.show({
							title : 'Alert',
							msg : errorMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return;
					}
					//
				}
			}
		});
		/*
		for ( var i in cmpNameWithType )
		{
			var msgShown = false;
			var record = compStore.findRecord( compObj.valueField, cmpNameWithType[i]);
			var idx = compStore.indexOf(record);
			var getCompRawVal = compStore.getAt(idx).get('displayField');
			var cmpName = getCompRawVal.substring(0, getCompRawVal.lastIndexOf(':'));
			var cmpType = getCompRawVal.substring(getCompRawVal.lastIndexOf(':') + 1);
			var measureRawVal = measureObj.getRawValue();
			var testRawVal = testObj.getRawValue();
			var descriptorVal = Ext.getCmp('descriptor').getValue();
			for ( var key in descriptorVal )
			{
				var descVal = descriptorVal[key];
				var hiddenVal = ''
				if ( descVal == '-1' )
				{
					descVal = '-';
					hiddenVal = cmpNameWithType[i]+'| |'+testObj.getValue()+'|'+measureObj.getValue();
				}
				else
				{
					hiddenVal = cmpNameWithType[i]+'| |'+testObj.getValue()+'|'+measureObj.getValue()+'|'+descriptorVal[key];					
				}
				var getIdx = tmpStore.find('hiddens', hiddenVal, 0, false, true, true);
				if ( getIdx == -1 )
				{
					tmpStore.add([{
								'Name' : cmpName,
								'Type' : cmpType,
								'Test' : testRawVal,
								'Measure' : measureRawVal,
								'Descriptor' : descVal,
								'hiddens': hiddenVal
							}]);
				}
				else if ( !msgShown )
				{
					Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.currentSelMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					msgShown = false;
				}
			}
		}
		gridObj.getSelectionModel().selectAll(tmpStore);
		if (tmpStore.getCount() >= 4) 
		{
			//Ext.getCmp('dockitem').show();
			Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
		}
		if (tmpStore.getCount() === 3)
		{ 
			Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
		}
		gridObj.doLayout();
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp('timelineForm').show();
		*/
	},

	getQueryString:function()	
	{   
		var showLegend = Ext.getCmp('showLegend').getValue();
		var hiddenQstr = this.getHiddenQstr(true);
		var qstr = hiddenQstr;
		var isSubmit = false;
		var mainForm = this.getDefineconfigurationpopup().getForm();
		var mainFormTimeline = this.getDefineconfiguration().getForm();
		var settingsForm = Ext.getCmp('settings').getForm();
		var testVal = mainForm.findField('test').getValue();
		var er_dataoptionVal = settingsForm.findField('cumulate').getValue();
		var startdateVal = mainFormTimeline.findField('er_stdate').dataArray;
		var enddateVal = mainFormTimeline.findField('er_enddate').dataArray;
		var starthrVal = mainFormTimeline.findField('er_sthr').dataArray;
		var endhrVal = mainFormTimeline.findField('er_endhr').dataArray;
		var er_timelineVal = mainFormTimeline.findField('er_timeline').getValue();
		var er_reportgenrationVal = settingsForm.findField('reportGeneration').getValue();
		var reportNameVal = settingsForm.findField('bgReportName').getValue();
		var er_summaryTypeVal = settingsForm.findField('rtype').getValue();
		var decimal_point = settingsForm.findField('decimal_point').getValue();

		var er_measureVal = mainForm.findField('Measure').getValue();
		var er_modeVal = mainFormTimeline.findField('er_mode').getValue();
		var descVal = mainForm.findField('descriptor').getValue();
		var er_info_listVal = '';
		//
			var decimal_point_obj = Ext.getCmp('decimal_point');
			if(decimal_point_obj!=undefined)
				decimal_point = decimal_point_obj.getValue();

		//
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}

		for ( var i = 0;i < descVal.length; i++ )
		{
			er_info_listVal += '&er_info_list='+appConstants.erUtils.specialCharEncode(descVal);
		}
		var forwardtoVal = 'ErCapacityCumulationReport';
		
		var gridObj = Ext.getCmp('configdatas')
		var selectionStr = '';
		var combinationStr = '';
		var er_componentStr = ''
		var compVal = mainForm.findField('compname').getValue();
		
		for ( var key in compVal )
		{
			er_componentStr += '&er_component='+encodeURI(compVal[key]);
		}
		var selectedObj = gridObj.getSelectionModel();
		for ( var i = 0; i < gridObj.getStore().getCount() ; i++ )
		{
			if ( selectedObj.isSelected( gridObj.getStore().getAt(i) ) )
			{
				var getVal = gridObj.getStore().getAt(i).get('hiddens');
				selectionStr += '&er_selection='+appConstants.erUtils.specialCharEncode(getVal);
				combinationStr += appConstants.erUtils.specialCharEncode(getVal)+'0eghash0eghash0';
			}
		}
		var er_compination = combinationStr+selectionStr+er_componentStr+er_info_listVal;
		qstr += '&er_mode='+er_modeVal+'&er_test='+encodeURI(testVal)+'&includesubzone=null&er_dataoption='+encodeURI(er_dataoptionVal)+'&startdate='+encodeURI(startdateVal)+'&er_timeline='+encodeURI(er_timelineVal)+'&enddate='+encodeURI(enddateVal)+'&starthr='+encodeURI(starthrVal)+'&endhr='+encodeURI(endhrVal)+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+
'&er_reportgenration='+encodeURI(er_reportgenrationVal)+'&er_summaryType='+encodeURI(er_summaryTypeVal)+'&er_measure='+encodeURI(er_measureVal)+'&er_combination='+appConstants.erUtils.specialCharEncode(er_compination)+selectionStr+er_componentStr+er_info_listVal+'&showLegend=true'+"&decimal_point="+decimal_point;
		var URL = '/final/reporter/ErCapacityCumulationReportJSON.jsp';
		if ( isSubmit )
		{
			if ( er_reportgenrationVal == 'foreground' )
			{
				URL = '/final/servlet/com.eg.ErRepoLiteC';
			}
			else
			{
				URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				forwardtoVal = 'ErCapacityCumulationReportJSON';
				reportNameVal=checkFileName(reportNameVal);
				qstr += '&bg_reportname='+encodeURI(reportNameVal);
			}
			qstr += '&isSubmit=true';
		}
		qstr += '&forwardto='+forwardtoVal;
        	qstr +="&er_RmDispName="+appConstants.er_RmDispName;

		appConstants.queryString = qstr;

}
	
});


