Ext.define('CapacityCumulationReports.view.Configdatas', {
	requires : ['Ext.selection.CheckboxModel'],
	extend :'Ext.grid.Panel',
	alias : 'widget.configdatas',
	id : 'configdatas',
	margin :10,
	//cls : 'gridSkin',
	ui:'newGridPanel',
	//autoScroll : true,
	//scroll : true,
	//enableColumnResize : false,
	enableColumnMove : false,
	enableColumnHide : false,
	sortableColumns : false,
	selModel : new Ext.selection.CheckboxModel({
				checkOnly : true,
				width : 50,
				injectCheckbox : 0
			}),
	height : 130,
	store : new Ext.data.Store({
		fields : ['Name', 'Type', 'Test', 'Measure', 'Descriptor', 'hiddens']
		}),
	viewConfig : {
		deferEmptyText : false,
		emptyText : '<div style="text-align:center;height:100px;display:flex;justify-content:center;align-items:center;" ><div><b  style="cursor:pointer" id="linkId" ><div class="iconConfigUser" style="margin:0px auto" data-qtip="Please define configuration" data-qclass="yellowTip"></div>'+plsDefineConfigLabel+'</b></div></div>'
	},
	border : true,
	columns : [

			{
				header : 'Name',
				dataIndex : 'Name',
				flex : 1
			}, {
				header : 'Type',
				dataIndex : 'Type',
				flex : 1
			}, {
				header : 'Test',
				dataIndex : 'Test',
				flex : 1
			}, {
				header : 'Measure',
				dataIndex : 'Measure',
				flex : 1
			}, {
				header : 'Descriptor',
				dataIndex : 'Descriptor',
				flex : 1
			},{
				//header : '<img src="/final/images/removeall_single_icon.png" id="removeALL" style="cursor:pointer" />',
				header: '<div style="cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				//tooltip: 'Remove All',
				width : 35,
				renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove"';
								return value;
							},
				items : [{
					//icon : '/final/images/remove-row.png',
					iconCls:'iconDelete',
					tooltip: 'Remove',
					handler : function(grid, htmlRow, index, columnIndex,
							mouseEvent, record)
					{
						grid.getStore().remove(record);
						//grid.reload();
						grid.refresh();
						var noOfrecords =grid.getStore().getCount();
						if (noOfrecords==0)
						{
						Ext.getCmp("scheduleTool").setDisabled(true);
						Ext.getCmp("favoriteTool").setDisabled(true);
							Ext.getCmp('timelineForm').hide();
						}
					}
				}]
			}],

	loadColumnHeaders : function(columnHeaders) {
		if (!Ext.isEmpty(this.columns) && !Ext.isEmpty(columnHeaders))
		{
			for ( var i = 1; i < 5; i++ )
			{
				this.headerCt.getHeaderAtIndex(i).setText(columnHeaders[i-1]);
			}
		}
	},
	listeners : {
		afterLayout : function(c) {
/*
		Ext.select('.hscrollerbase').remove(); // added by jaiwin - for remove horizontal scroll bar.
			if (c.body.dom.fleXcroll) {
				var a = c.body.dom.childNodes;
				var b = [];
				for ( var i = 0, j = 0; i < a.length; i++) {
					if (a[i].id != c.body.id + "_mcontentwrapper"
							&& a[i].id != c.body.id + "_scrollwrapper") {
						b[j] = a[i];
						j++;
					}
				}
				var el = Ext.get(c.body.id + "_contentwrapper");
				for ( var i = 0; i < b.length; i++)
					el.appendChild(b[i]);
			}
			fleXenv.fleXcrollMain(c.body.id);
			var heightOfGrid = c.getView().getHeight();
			var pageSize=c.getStore().pageSize;
			var viewHeight=c.getView().getHeight();
			var totalHeight=0;
			var rowsVisible=viewHeight/24; //24 for row height
			var pendingRows=pageSize-rowsVisible;
			if(c.getStore().getCount()>rowsVisible){
				totalHeight=pendingRows*24;
			}
			Ext.get(c.getView().getId(), this).setHeight(heightOfGrid+totalHeight);
			Ext.get(c.body.id + "_mcontentwrapper", this).setHeight(heightOfGrid);
			Ext.get(c.body.id + "_contentwrapper", this).setHeight(c.getStore().getCount()* 24);
				if(c.scroll_flag==false){
					c.scroll_flag=true;
					c.doComponentLayout();
				}else{
					c.scroll_flag=false;
				}*/
		},
		'afterrender' : function(grid, scle)
		{
			grid.mon(Ext.select('#removeALL'), 'click', function() {
				var selectionArray = grid.getSelectionModel().getSelection();
				var selectionArrayLen=selectionArray.length;
				if (selectionArrayLen>0)
				{
					Ext.Msg.show({
					title : 'Alert',
					msg : 'Are you sure you want to remove selected configurations?',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal) {
							if (buttonVal == "yes") {
								var noOfrecords =grid.getStore().getCount();
								for (i = 0; i < selectionArrayLen; i++) {
									grid.getStore().remove(selectionArray[i]);
								}
							}
							if(selectionArrayLen==noOfrecords)
							{
								Ext.getCmp('timelineForm').hide();
								Ext.getCmp("scheduleTool").setDisabled(true);
								Ext.getCmp("favoriteTool").setDisabled(true);
							}
						}
					});
				}
				else
				{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'No selected configurations to remove',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
			});
		},
		'selectgrid': function(grid)
		{
			grid.getSelectionModel().selectAll(grid.getStore());
		}
	}

});