Ext.define('CapacityPlanningReports.view.CapacityPlanningReportsSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.capacityplanningreportssettings',
	id:'configsettings',
	hidden:true,
	//cls:'formOuter',
	ui:'newFormPanel',
	bodyPadding:10,	
	requires:[	
	
			'utilities.TimeLine',
			'utilities.ReportGeneration',
			'utilities.ScrollCombo'
	],
	layout:'hbox',
	items:[
			{
				xtype:'fieldcontainer',
				flex:1,
				layout:'column',
				items:[
						{xtype:'timeline',margin:0},
						{xtype:'reportgeneration',margin:'0 20 0 -10'},
						{
							xtype:'button',
							text:submitValue,
							id:"submit",
							name:"submit",
							//cls:'button20',
							ui:'newButtonSmall',
							margin: '20 0 0 0'
						},
						{
							xtype:'button',
							text: "Save",
							//cls: "button20",
							ui:'newButtonSmall',
							hidden:true,
							id: "save",
							name: "save",
							margin: '20 0 0 0'
						}
				]			
			},
			{
				xtype:'button',
  				cls:'iconPanelUpArrow',
 				id:'panelinsidetoggle',
 				border:false,
				bodyStyle:{'background':'none'},
				hidden:true
			}
	],
	loadData: function(){
		var thisForm = this.getForm();
		var screenLabels = appConstants.dafaultJSON['screenlabels'];
    
		thisForm.findField('reportGeneration').labelEl.dom.innerHTML = screenLabels['reporter.consolidated.Report Generation'];
		
		var timeline = appConstants.dafaultJSON['timeline'];
		this.setComboOptionsInList(thisForm, 'er_timeline', timeline.timelineCombo, timeline.timeline_value);
        this.setComboOptionsInList(thisForm, 'reportGeneration', timeline.reportgenCombo, timeline.reportgenCombo_value);

        this.setComboValue(thisForm,'er_sthr',timeline.startHourForDisplay);
        this.setComboValue(thisForm,'er_endhr',timeline.endHourForDisplay);
        Ext.getCmp("er_stdate").setValue(timeline.startDateDispValue);
        Ext.getCmp("er_enddate").setValue(timeline.endDateDsipValue);

        Ext.getCmp("er_enddate").dataArray=timeline.endDateValue;
        Ext.getCmp("er_stdate").dataArray=timeline.startDateValue;
        Ext.getCmp("er_sthr").dataArray=timeline.starthour_value;
        Ext.getCmp("er_endhr").dataArray=timeline.endhour_value;
		mgr_stmin=timeline.startmin;
		mgr_enmin=timeline.endmin;

        thisForm.findField('er_mode').hide();
        
	},
	   setComboOptionsInList : function(form, fieldName, list, value){
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        
        form.findField(fieldName).setValue(value);
        form.findField(fieldName).resumeEvents();
    },
     setComboValue : function(form,fieldName,value){
         form.findField(fieldName).suspendEvents(false);
         form.findField(fieldName).setValue(value);
         form.findField(fieldName).resumeEvents();
    }
});   