
Ext.define('CapacityPlanningReports.view.DefineConfigurationPopup', {
	extend : 'Ext.form.Panel',
	alias : 'widget.defineconfigurationpopup',
	floating : true,
	floatable : true,
	draggable : true,
	requires:[
		'utilities.Multiselector',
		'Ext.ux.form.MultiSelect'
	],
	me : null,		 
	ui:'newFormFieldsInPopup popupHeaderBottomBorder',
	border:true,
	//cls : 'alarmsbg defineconfig defineConfigShadow',
	//header:{cls:'defineconfig'},
	id : 'popup',
	frame : false,
	padding:0,
	shadowOffset : 15,
	screenLabel : null,
	isFirstLoad:false,
	title : 'Define Configuration',
	initComponent : function() {
		this.width = Ext.getBody().getViewSize().width - 170;
		this.callParent();
		this.me = this;
	},
	tools : [

			{
				xtype : 'button',
				iconCls : 'iconCloseNew',
				id : 'defineconfigclose',
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Close'
						});
					}
				},
				style : {
					background : 'none',
					border : '0px'
				}
			}

	],
	items : [{
				xtype : 'container',
				border:true,
				layout : 'column',
				//padding:10,
				margin:'5 10 5 10',
				defaults : {
					width : 200,
					labelAlign : 'top',
					margin:'0 15 15 0',
					labelSeparator : ''
				},

				items : [{
							xtype : 'scrollcombo',
							cls : 'dropdown',
							width : 150,
							editable : false,
							fieldLabel : 'Analyze by',
							name : 'er_option',
							id : 'er_option',
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{'displayField' : 'Zone','valueField' : 'valueField'},
												{'displayField' : 'Segment','valueField' : 'valueField2'},
												{'displayField' : 'Service','valueField' : 'valueField3'},
												{'displayField' : 'Component','valueField' : 'valueField4'}
											]

									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						}, {
							xtype : 'scrollcombo',
							width : 150,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Zone',
							name : 'Zone',
							id : 'Zone',
							listConfig:{
										emptyText:noMatch
								},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{'displayField' : 'Chennai', 'valueField' : 'Chennai'},
											{'displayField' : 'Australia', 'valueField' : 'Australia'}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true

						}, {
							xtype : 'scrollcombo',
							cls : 'dropdown',
							//width : 210,
							editable : true,
							name : 'Service',
							id : 'Service',
							fieldLabel : 'Service',
							listConfig:{
										emptyText:noMatch
								},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{'displayField' : 'service1',
													'valueField' : 'service1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}, {
							xtype : 'scrollcombo',
							//width : 210,
							cls : 'dropdown',
							fieldLabel : 'Segment',
							name : 'Segment',
							id : 'Segment',
							editable : true,
							listConfig:{
										emptyText:noMatch
								},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						},{
							xtype : 'scrollcombo',
							//width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Component Type',
							name : 'er_comptype',
							id : 'er_comptype',
							listConfig:{
										emptyText:noComponentTypeMatch
								},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{'displayField' : 'Citrix XenApp','valueField' : 'Citrix XenApp'},
												{'displayField' : 'IIS Web','valueField' : 'IIS Web'},
												{'displayField' : 'Microsoft SQL','valueField' : 'Microsoft SQL'},
												{'displayField' : 'Tomcat','valueField' : 'Tomcat'}
											]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 120,
							cls : 'dropdown',
							labelStyle : 'white-space: nowrap',
							fieldLabel : 'Include Subzones',
							name : 'er_dataZone',
							id : 'er_dataZone',
							value : 'Yes',
							defaultListConfig : {
								loadingHeight : 70,
								minWidth : 50,
								maxHeight : 300,
								shadow : 'sides'
								},
								store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													displayField : 'Yes',
													valueField : 'Yes'
												}, {
													displayField : 'No',
													valueField : 'No'
												}]
								}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}, {
							xtype : 'scrollcombo',
							//width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Test',
							name : 'er_test',
							id : 'er_test',
							listConfig:{
											emptyText:noTestMatch
										},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{'displayField' : 'Disk Space','valueField' : 'Disk Space'}
											]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						},{
							xtype:'fieldcontainer',
							layout:'vbox',
							width : 260,
								items:[
								{
									xtype:'label',
									text:'Measure',
									margins: '5 0 5 0',
									id : 'Measure',
									name : 'Measure'
								},
								{
									xtype:'container',
									layout:'hbox',
									items:[
										{

													width: 200,
													xtype: 'multiselectfield',
													id: 'er_measure',
													name: 'er_measure',
													autoScroll:false,
												//	msgTarget: 'side',
													scroll:false,
													labelAlign:'left',
													height:90,
												//	allowBlank: false,
													store: new Ext.data.Store({
														fields : ['displayField', 'valueField'],
														data : [{'displayField' : 'Free space','valueField' : 'Free space'},
																{'displayField' : 'Percent usage','valueField' : 'Percent usage'},
																{'displayField' : 'Total capacity','valueField' : 'Total capacity'},
																{'displayField' : 'Used space','valueField' : 'Used space'}
																]
													/*listeners:{
															'load': function(store, records)
															{
																var measureObj = Ext.getCmp('measure');
																if ( !Ext.isEmpty( store ) && !Ext.isEmpty( measureObj ) )
																{
																	var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
																	if ( getNAIndex == -1 )
																	{
																		var getModel = store.getAt(0);
																		var getFirstValueField = getModel.get('valueField');
																		measureObj.setValue(getFirstValueField);
																	}
																}
															}
														}*/
													}),
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local'

										},{
												xtype : 'container',
												margin : '2px 5px 0 5px',
												//cls : 'iconBg',
												items : [{
															xtype : 'button',
															iconCls : 'iconMultiselectExpand',
															id:'expandSelectorMeasure',

															listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Measure'
																});
															}
														},
															style : {
																background : 'none',
																border : '0px'
															}
														}]
											}
											]
										}
								]
							}, {
					xtype:'fieldcontainer',
					layout:'vbox',
					width : 245,
					items:[
					{
						xtype:'label',
						id : 'Component',
						name : 'Component',
						text:'Component',
						margins: '0 0 3 0'
					},
					{
						xtype:'container',
						layout:'hbox',
						items:[
							{
										xtype:'container',
										width: 220,
										margin: 0,
										items:[
										{
											xype:'container',
											cls: 'multisearchlist',
											items:[
											{
												xtype: 'customtrigger',
												emptyText:'Search Components',
												id: 'compSearch'
											}
										]
									},
									{
										width: 220,
										xtype: 'multiselectfield',
										autoScroll:false,
										scroll:false,
										height:90,
										labelAlign:'left',
										allowBlank: false,
										id: 'er_component',
										name: 'er_component',
										store: new Ext.data.Store({
											fields : ['displayField', 'valueField'],
											data : []
										}),
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local'
										}
								]
							},
							{
								xtype : 'container',
								margin : '8px 5px 0 5px',
								//cls : 'iconBg',
								items : [{
											xtype : 'button',
											iconCls : 'iconMultiselectExpand',
											id:'expandSelectorComponent',
											name:'expandSelectorComponent',
											listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Components'
																});
															}
														},
											//tooltip : '<b>Components</b>',
											style : {
														background : 'none',
														border : '0px'
													}
									}]
							}
						]
					}
					]
					},{
								xtype:'fieldcontainer',
								layout:'vbox',
								width : 260,
								items:[
								{
									xtype:'label',
									text:'Descriptors',
									margins: '0 0 5 0',
									id : 'Descriptors',
									name : 'Descriptors'

								},
								{
									xtype:'container',
									layout:'hbox',
									items:[
										{
											xtype:'container',
											width: 220,
											margin: 0,
											items:[
													{
														xype:'container',
														cls: 'multisearchlist',
														items:[
														{
															xtype: 'customtrigger',
															emptyText:'Search Descriptors',
															id: 'descSearch'
														}
													]
												},
												{
													width: 220,
													xtype: 'multiselectfield',
													autoScroll:false,
													scroll:false,
													height:90,
													labelAlign:'left',
													allowBlank: false,
													id: 'er_info_list',
													name: 'er_info_list',
													store: new Ext.data.Store({
														fields : ['displayField', 'valueField'],
														data : [{'displayField' : 'All Descriptors','valueField' : 'All Descriptors'},
																{'displayField' : 'C','valueField' : 'C'},
																{'displayField' : 'D','valueField' : 'D'}
															],
														listeners:{
															'load': function(store, records)
															{
																var measureObj = Ext.getCmp('descrip');
																if ( !Ext.isEmpty( store ) && !Ext.isEmpty( measureObj ) )
																{
																	var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
																	if ( getNAIndex == -1 )
																	{
																		var getModel = store.getAt(0);
																		var getFirstValueField = getModel.get('valueField');
																		measureObj.setValue(getFirstValueField);
																	}
																}
															}
														}
													}),
													displayField: 'displayField',
													valueField: 'valueField',
													queryMode: 'local'
													}
												]
											},
											{
												xtype : 'container',
												margin : '8px 5px 0 5px',
												//cls : 'iconBg',
												items : [{
															xtype : 'button',
															iconCls : 'iconMultiselectExpand',
															id:'expandSelectorDescriptor',
															//tooltip : '<b>Descriptor</b>',
															listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Descriptor'
																});
															}
														},
															style : {
																background : 'none',
																border : '0px'
															}
														}]
												}
											]
										}
								]
							}]

			}

	],
	dockedItems : [{
				dock : 'bottom',
				padding : '0 10 5 10',
				style : {
					'text-align' : 'center'
				},
				items : [{
							xtype : 'button',
							//cls : 'quickMenuWhiteButton',
							ui:'newButtonSmall',
							name : 'addtogrid',
							width:70,
							id:'addtogrid',
							text : 'Add'
						}]
			}],
	loadReportForCombo : function(jsonData) {

		var filterconfigForm = this.getForm();
		filterconfigForm.findField('er_option').getStore().loadRawData(jsonData.analysisbyComboArray);
		filterconfigForm.findField('er_option').setValue(jsonData.analysisbycombo_value);
	    var er_datafrom = jsonData.analysisbycombo_value;
	    if(er_datafrom!=null && er_datafrom=="Zone")
        {

        	filterconfigForm.findField('Zone').getStore().loadRawData(jsonData.zoneComboArray);
        	filterconfigForm.findField('Zone').setValue(jsonData.zonecombo_value);

        	filterconfigForm.findField('er_dataZone').getStore().loadRawData(jsonData.subzoneComboArray);
        	filterconfigForm.findField('er_dataZone').setValue(jsonData.subzoneCombo_value);
        }
        else if(er_datafrom!=null && er_datafrom=="Segment")
        {
        	filterconfigForm.findField('Segment').getStore().loadRawData(jsonData.segmentComboArray);
            filterconfigForm.findField('Segment').setValue(jsonData.segmentCombo_value);

        }
        else if(er_datafrom!=null && er_datafrom=="Service")
        {
        	filterconfigForm.findField('Service').getStore().loadRawData(jsonData.serviceComboArray);
            filterconfigForm.findField('Service').setValue(jsonData.serviceCombo_value);

        }


	    filterconfigForm.findField('er_comptype').getStore().loadRawData(jsonData.componenttypeComboArray);
        filterconfigForm.findField('er_comptype').setValue(jsonData.componenttypeCombo_value);
        //if(isSubmit!=null && isSubmit=='true')
        {
        	var testComboArray = jsonData.testComboArray;
        	if(testComboArray!=undefined)
        	{
        		filterconfigForm.findField('er_test').getStore().loadRawData(testComboArray);
                filterconfigForm.findField('er_test').setValue(jsonData.testCombo_valuey);
        	}
        	var measuremultiselectArray = jsonData.measuremultiselectArray;

        	var measuremultiselect_value  = jsonData.measuremultiselect_value;

            if(measuremultiselectArray!=undefined)
            {
            	filterconfigForm.findField('er_measure').getStore().loadRawData(measuremultiselectArray);
                var values = [];

               for(var m in measuremultiselect_value)
               {
                    values.push ( measuremultiselect_value[m] );
               }

                filterconfigForm.findField('er_measure').setValue(values);
            }

            var componentmultiselectArray = jsonData.componentmultiselectArray;
            var componentmultiselect_value = jsonData.componentmultiselect_value;
            if(componentmultiselectArray!=undefined)
            {
            	filterconfigForm.findField('er_component').getStore().loadRawData(jsonData.componentmultiselectArray);
               var values = [];

                for(var m in componentmultiselect_value)
                {
                    values.push ( componentmultiselect_value[m] );
                }

               filterconfigForm.findField('er_component').setValue(values);
            }

            var infomultiselectArray = jsonData.infomultiselectArray;
            var infomultiselect_value = jsonData.infomultiselect_value;
            if(infomultiselectArray!=undefined)
            {
				appConstants.rawDataForDescriptor=jsonData.infomultiselectArray;
				console.log('appConstants.rawDataForDescriptor	111'+appConstants.rawDataForDescriptor);
            	filterconfigForm.findField('er_info_list').getStore().loadRawData(jsonData.infomultiselectArray);
                var values = [];

               for(var m in infomultiselect_value)
               {
                    values.push ( infomultiselect_value[m] );
               }

               filterconfigForm.findField('er_info_list').setValue(values);
            }



        }



	},
	loadScreenLabels : function(screenLabel) {

		var filterconfigForm = this.getForm();
		this.screenLabel = screenLabel;

		filterconfigForm.findField('er_option').setFieldLabel(screenLabel['reporter.capacity.Analyze by']);
		filterconfigForm.findField('er_comptype').setFieldLabel(screenLabel['reporter.consolidated.Component Type']);
		filterconfigForm.findField('Service').setFieldLabel(screenLabel['reporter.compliance.eventlog.Service']);
		filterconfigForm.findField('Segment').setFieldLabel(screenLabel['reporter.compliance.eventlog.Segment']);
		filterconfigForm.findField('er_dataZone').setFieldLabel(screenLabel['reporter.comparison.Include Subzone']);
		filterconfigForm.findField('Zone').setFieldLabel(screenLabel['reporter.compliance.eventlog.Zone']);
		filterconfigForm.findField('er_test').setFieldLabel(screenLabel['reporter.common.Test']);
		Ext.getCmp('Descriptors').setText(screenLabel['reporter.comparison.Descriptor']);
		Ext.getCmp('Component').setText(screenLabel['reporter.common.Component']);
		Ext.getCmp('Measure').setText(screenLabel['reporter.common.Measure']);

		this.setNotApplicable(filterconfigForm, 'er_component',
				screenLabel['reporter.common.Not Applicable']);
				this.setNotApplicable(filterconfigForm, 'er_test',
                screenLabel['reporter.common.Not Applicable']);
		this.setNotApplicable(filterconfigForm, 'er_measure',
				screenLabel['reporter.common.Not Applicable']);
		this.setNotApplicable(filterconfigForm, 'er_info_list',
				screenLabel['reporter.common.Not Applicable']);
	},
	setNotApplicable : function(form, fieldname, value) {
		//form.findField(fieldname).getStore().removeAll();
		var notApplicableArray=[];
		notApplicableArray.push({
			"displayField" : this.screenLabel['reporter.common.Not Applicable'],
			"valueField" : "-1"
		});
		form.findField(fieldname).getStore().loadRawData(notApplicableArray);
		if (fieldname=='er_component')
		{
			appConstants.rawDataForComponents=notApplicableArray;
		}
		else if (fieldname=='er_info_list')
		{
			appConstants.rawDataForDescriptor=notApplicableArray;
		}	
 		form.findField(fieldname).setValue("-1");
	},
	loadEvents : function() {

		var form = this.getForm();
		form.findField('er_option').on('select', this.changeEvent);
		form.findField('er_comptype').on('select', this.changeEvent);

		form.findField('Service').on('select', this.changeEvent);
		form.findField('Segment').on('select', this.changeEvent);
		form.findField('er_dataZone').on('select', this.changeEvent);
		form.findField('Zone').on('select', this.changeEvent);

		form.findField('er_component').on('change', this.changeEvent);
		form.findField('er_test').on('select', this.changeEvent);
		form.findField('er_measure').on('select', this.changeEvent);
		form.findField('er_info_list').on('select', this.changeEvent);

	},
	changeEvent : function(c) {
		var id = c.getId();

		var thisObj = Ext.getCmp("popup");
		if (id == 'er_option') {
			var val = Ext.getCmp(id).getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'er_comptype', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');

			if (val == 'Zone' || val == 'Service' || val == 'Segment') {
				Ext.getCmp(val).show();
				if (val == 'Zone') {
					Ext.getCmp('er_dataZone').show();
					Ext.getCmp('Service').hide();
					Ext.getCmp('Segment').hide();

				} else if (val == 'Service') {
					Ext.getCmp('er_dataZone').hide();
					Ext.getCmp('Zone').hide();
					Ext.getCmp('Segment').hide();

				} else if (val == 'Segment') {
					Ext.getCmp('er_dataZone').hide();
					Ext.getCmp('Zone').hide();
					Ext.getCmp('Service').hide();

				}

				 var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname='+val+'&er_datafrom='+val;
                thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,val,thisObj);

			} else if (val == 'Component') {
				Ext.getCmp('er_dataZone').hide();
				Ext.getCmp('Service').hide();
				Ext.getCmp('Segment').hide();
				Ext.getCmp('Zone').hide();
                var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=component&er_datafrom='+val;
				thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_comptype',thisObj);

			}
		} else if (id == 'Service') {

			var val = Ext.getCmp(id).getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'er_comptype', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');
			var er_datafrom = Ext.getCmp('er_option').getValue();
			var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=component&er_datafrom='+er_datafrom+'&er_site='+val;
			thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_comptype',thisObj);

		} else if (id == 'Segment') {

			var val = Ext.getCmp(id).getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'er_comptype', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');
			var er_datafrom = Ext.getCmp('er_option').getValue();
			var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=component&er_datafrom='+er_datafrom+'&er_site='+val;
			thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_comptype',thisObj);

		} else if (id == 'Zone') {

			var val = Ext.getCmp(id).getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'er_comptype', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_component', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_test', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');
			var er_datafrom = Ext.getCmp('er_option').getValue();
			var er_dataZone = Ext.getCmp('er_dataZone').getValue();
			var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=component&er_datafrom='+er_datafrom+'&er_site='+val+'&er_dataZone='+er_dataZone;
			thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_comptype',thisObj);

		} else if (id == 'er_comptype') {

			var val = Ext.getCmp(id).getValue();

            thisObj.setNotApplicable(thisObj.getForm(), 'er_component', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_test', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');

            var er_datafrom = Ext.getCmp('er_option').getValue();
            var er_site="";
			var er_dataZone="";
			
			if(er_datafrom=='Zone')
			{
				er_site = Ext.getCmp('Zone').getValue();
				er_dataZone = Ext.getCmp('er_dataZone').getValue();
			}
			else if(er_datafrom=='Service')
			{
				er_site = Ext.getCmp('Service').getValue();
			}
			else if(er_datafrom=='Segment')
			{
				er_site = Ext.getCmp('Segment').getValue();
			}
            var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=comptype&er_datafrom='+er_datafrom+'&er_comptype='+val+'&er_site='+er_site+'&er_dataZone='+er_dataZone;
                thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'test',thisObj);

		} else if (id == 'er_component') {

			var val = Ext.getCmp(id).getValue();


            thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');

            var er_datafrom = Ext.getCmp('er_option').getValue();
            var er_comptype =  Ext.getCmp('er_comptype').getValue();
            var er_test = Ext.getCmp('er_test').getValue();

            var values = [];
            for (var tr in val) {
                    values.push(val[tr]);
             }
            if(val!='-1' && val!='')
            {
                var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=compmultiselect&er_datafrom='+er_datafrom+'&er_comptype='+er_comptype+'&er_test='+er_test;
				for(var k=0;k<values.length;k++)
					param+='&er_component='+values[k];
                thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_info_list',thisObj);
            }


		} else if (id == 'er_test') {

			var val = Ext.getCmp(id).getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'er_measure', '-1');
            thisObj.setNotApplicable(thisObj.getForm(), 'er_info_list', '-1');

            var er_datafrom = Ext.getCmp('er_option').getValue();
            var er_comptype = Ext.getCmp('er_comptype').getValue();

            var param = 'from=filtercomp&userID='+appConstants.userID+'&sessionID='+appConstants.sessionID+'&fieldname=test&er_datafrom='+er_datafrom+'&er_comptype='+er_comptype+'&er_test='+val;
            thisObj.filterComponent('/final/servlet/com.eg.ErCapacityReportC',param,'er_test',thisObj);

		} else if (id == 'er_measure') {

		} else if (id == 'er_info_list') {

		}
	},
	filterComponent : function(url, param, val,thisObj) {
var me=this;
		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						var jsontext = response.responseText;
						var jsonObject = Ext.decode(jsontext);
                        if(val=='test')
                        {
                          thisObj.getForm().findField('er_test').getStore().loadRawData(jsonObject.testcomboarray);
                          thisObj.getForm().findField('er_test').setValue(jsonObject.testcombo_value);

                          thisObj.getForm().findField('er_component').getStore().loadRawData(jsonObject.compcomboarray);
							appConstants.rawDataForComponents = jsonObject.compcomboarray;
                           var values = [];

                            thisObj.getForm().findField('er_component').getStore().each( function( re ) {
                                values.push ( re.get('valueField') );
                            }, this);
                          thisObj.getForm().findField('er_component').setValue(values);
                        }
                        else
                        {

						  if(val=='er_test')
						  {

						  	thisObj.getForm().findField('er_measure').getStore().loadRawData(jsonObject.measurecomboarray);
						  	var values = [];

                            thisObj.getForm().findField('er_measure').getStore().each( function( re ) {
                                values.push ( re.get('valueField') );
                            }, this);
                            thisObj.getForm().findField('er_measure').setValue(values);
							me.changeEvent(Ext.getCmp('er_component'));
						  }
						  else if(val == 'er_info_list')
						  {
							appConstants.rawDataForDescriptor=jsonObject.descriptorComboArray;
						  	thisObj.getForm().findField('er_info_list').getStore().loadRawData(jsonObject.descriptorComboArray);
                            var values = [];

                            thisObj.getForm().findField('er_info_list').getStore().each( function( re ) {
                                values.push ( re.get('valueField') );
                            }, this);
                            thisObj.getForm().findField('er_info_list').setValue(values[0]);
						  }
						  else
						  {
						  	   thisObj.getForm().findField(val).getStore().loadRawData(jsonObject.combo);
						       thisObj.getForm().findField(val).setValue(jsonObject.values);
						  }
                        }


					}
				});
	}

});