Ext.require('Ext.grid.ColumnLayout',function(){
	Ext.override(Ext.grid.ColumnLayout,{
		completeLayout: function(ownerContext) {
			
        var me = this,
            owner = me.owner,
            state = ownerContext.state,
            needsInvalidate = false,
            calculated = me.sizeModels.calculated,
            childItems, len, i, childContext, item;

        

        // If we have not been through this already, and the owning Container is configured
        // forceFit, is not a group column and and there is a valid width, then convert
        // widths to flexes, and loop back.
        if (!ownerContext.flexedItems.length && !state.flexesCalculated && owner.forceFit && !owner.isHeader) {
            childItems = ownerContext.childItems;
            len = childItems.length;
			
            for (i = 0; i < len; i++) {
                childContext = childItems[i];
                item = childContext.target;
				
                // For forceFit, just use allocated width as the flex value, and the proportions
                // will end up the same whatever HeaderContainer width they are being forced into.
                if (item.width) {
                    item.flex = ownerContext.childItems[i].flex = item.width;
                    delete item.width;
                    childContext.widthModel = calculated;
					
                    needsInvalidate = true;
                }
            }
		
            // Recalculate based upon all columns now being flexed instead of sized.
            // Set flag, so that we do not do this infinitely
            if (needsInvalidate) {
                me.cacheFlexes(ownerContext);
                ownerContext.invalidate({
                    state: {
                        flexesCalculated: false
                    }
                });
            }
        }
		me.callParent(arguments);
    }
	})
});
Ext.define('CapacityPlanningReports.view.GridPanel',{
	extend:'utilities.CustomGrid',
	alias:'widget.gridpanels',
	title: 'Capacity Report forDisk Space',
	cls:'gridSkin',
	forceFit:true,
	initComponent:function(){
	this.store = new Ext.data.Store({
	extend: 'Ext.data.Store',
	autoLoad: true,
	fields:['compname', 'descriptor', 'avg1','presentile1','avg2', 'presentile2','avg3', 'presentile3','avg4', 'presentile4'],
	data:{'items':[
				{ 'compname':'infoway_sqldb1','descriptor': 'C', "avg1":"1488.58", "presentile1":"1497.16", "avg2":"85.52", "presentile2":"85.56", "avg3":"10275.95", "presentile3":"10275.95", "avg4":"8788.49", "presentile4":"8792.54"},
				{ 'compname':'infoway_sqldb1','descriptor': 'C', "avg1":"1488.58", "presentile1":"1497.16", "avg2":"85.52", "presentile2":"85.56", "avg3":"10275.95", "presentile3":"10275.95", "avg4":"8788.49", "presentile4":"8792.54"},
				{ 'compname':'infoway_sqldb1','descriptor': 'C', "avg1":"1488.58", "presentile1":"1497.16", "avg2":"85.52", "presentile2":"85.56", "avg3":"10275.95", "presentile3":"10275.95", "avg4":"8788.49", "presentile4":"8792.54"},
				{ 'compname':'infoway_sqldb1','descriptor': 'C', "avg1":"1488.58", "presentile1":"1497.16", "avg2":"85.52", "presentile2":"85.56", "avg3":"10275.95", "presentile3":"10275.95", "avg4":"8788.49", "presentile4":"8792.54"}
		]},
	proxy: {
		type: 'memory',
		reader: {
			type: 'json',
			root: 'items'
		}
	}
});
		 this.columns=[
				{ header : 'Component Name',  dataIndex: 'compname'},
				{ header : 'Descriptor',  dataIndex: 'descriptor'},
				{
					text: 'Free space',
					columns:[
						{
							text:'(MB)',
							columns:[
									{
										text: 'Avg', 
										dataIndex: 'avg1',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									},
									{
										text: '95percentile',
										dataIndex: 'presentile1',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									}
								]
						}
					]
				},
				{
					text: 'Percent usage',
					columns:[
						{
							text:'(%)',
							columns:[
									{
										text: 'Avg',
										dataIndex: 'avg2',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									},
									{
										text: '95percentile',
										dataIndex: 'presentile2',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									}
								]
						}
					]
				},
				{
					text: 'Total capacity',
					columns:[
						{
							text:'(MB)',
							columns:[
									{
										text: 'Avg',
										dataIndex: 'avg3',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									},
									{
										text: '95percentile',
										dataIndex: 'presentile3',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									}
								]
						}
					]
				},
				{
					text: 'Used space',
					columns:[
						{
							text:'(MB)',
							columns:[
									{
										text: 'Avg',
										dataIndex: 'avg4',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									},
									{
										text: '95percentile',
										dataIndex: 'presentile4',
										renderer:function(value){
											return '<a href="javascript:void(0);" style="text-decoration:underline">'+value+'</a>'
										}
									}
								]
						}
					]
				}
			];
		this.callParent(arguments);
	}
});


