Ext.require('Ext.grid.ColumnLayout',function(){
	Ext.override(Ext.grid.ColumnLayout,{
		completeLayout: function(ownerContext) {
			
        var me = this,
            owner = me.owner,
            state = ownerContext.state,
            needsInvalidate = false,
            calculated = me.sizeModels.calculated,
            childItems, len, i, childContext, item;

        

        // If we have not been through this already, and the owning Container is configured
        // forceFit, is not a group column and and there is a valid width, then convert
        // widths to flexes, and loop back.
        if (!ownerContext.flexedItems.length && !state.flexesCalculated && owner.forceFit && !owner.isHeader) {
            childItems = ownerContext.childItems;
            len = childItems.length;
			
            for (i = 0; i < len; i++) {
                childContext = childItems[i];
                item = childContext.target;
				
                // For forceFit, just use allocated width as the flex value, and the proportions
                // will end up the same whatever HeaderContainer width they are being forced into.
                if (item.width) {
                    item.flex = ownerContext.childItems[i].flex = item.width;
                    delete item.width;
                    childContext.widthModel = calculated;
					
                    needsInvalidate = true;
                }
            }
		
            // Recalculate based upon all columns now being flexed instead of sized.
            // Set flag, so that we do not do this infinitely
            if (needsInvalidate) {
                me.cacheFlexes(ownerContext);
                ownerContext.invalidate({
                    state: {
                        flexesCalculated: false
                    }
                });
            }
        }
		me.callParent(arguments);
    }
	})
});
Ext.define('CapacityPlanningReports.view.GridPanelView',{
	extend:'utilities.CustomGrid',
	alias:'widget.gridpanelview',
	title: 'Daily 95 Percentile Data for Disk Space:Free space (MB)',
	cls:'gridSkin',
	forceFit:true,
	
	initComponent:function(){
		this.store = new Ext.data.Store({
		extend: 'Ext.data.Store',
		autoLoad: true,
		fields:['compname', 'descriptor', '01', '02', '03', '04', '05', '06', '07'],
		data:{'items':[
					{ 'compname':'infowayctx_farm2','descriptor': 'D', '01':'3650.77', '02':'3650.77', '03':'3650.77', '04':'3650.77', '05':'3650.77', '06':'3650.77', '07':'3650.77'}
			]},
		proxy: {
				type: 'memory',
				reader: {
					type: 'json',
					root: 'items'
				}
			}
		});
		this.columns=[
				{ header : 'Component Name',  dataIndex: 'compname'},
				{ header : 'Descriptor',  dataIndex: 'descriptor'},
				{ header:'Mar 2013', 
					columns:[
						{header:'14', dataIndex:'01'},
						{header:'15', dataIndex:'02'},
						{header:'16', dataIndex:'03'},
						{header:'17', dataIndex:'04'},
						{header:'18', dataIndex:'05'},
						{header:'19', dataIndex:'06'},
						{header:'20', dataIndex:'07'}
					]
				}
			];
		this.callParent(arguments);
	},
	tools : [{
				xtype : 'button',
				text :backText,
				cls : 'backbutton',
				iconCls:'iconBack',
				listeners : {
					'click' : function() {
						history.go(-1);
					}
				}
			}]
});


