Ext.define('cpSystemApp.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'capacityplanningsystemmainform',ref:'capacityplanningsystemmainform'},
		{selector:'capacityplanningsystemsettings',ref:'capacityplanningsystemsettings'},
		{selector:'mainform',ref:'Mainform'},
		{selector:'ReporterSettings',ref:'ReporterSettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'newUtilities':
			{
				'afterrender': this.hideTools
			},
			'main':{
					'afterrender':this.defaultLoad
			},
			/*'capacityplanningsystemsettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},*/
			'capacityplanningsystemsettings':{
				'afterrender': this.loadSettings
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'main button[name="mainformsubmit"]' :
			{
				'click' : this.beforeReportSubmit
			},
			'main button[name="mainformsave"]' :
			{
				'click' : this.addTo
			},
			'capacityplanningsystemmainform button[name="submit"]' :
			{
				'click' : this.beforeReportSubmit
			},
			'capacityplanningsystemmainform button[name="save"]' :
			{
				'click' : this.addTo
			},
			'capacityplanningsystemmainform combo[name="er_site"]':{
					'select':this.changeCompType
			},
			'capacityplanningsystemmainform combo[name="er_type"]':{
					'select':this.changeReportType
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.savePdf
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #printTool > button':
			{
				'click':this.print
			},
			'newUtilities > #favoriteTool > button' : {
						'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'egcomponent button[id="expandSelectorComp"]':
			{
				'click': this.expandMe
			},
			'newUtilities > #csvTool > button':{
				'click': this.saveAsCSV
			},
			'grid':
			{
				//'boxready': this.resizePanel
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController=this;
			var tpl = new Ext.XTemplate('<div style="float:left;margin: 0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
 			width:565,
			//padding:'5 5 5 5',
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
 			items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						style:{'top':'0px','margin':'0px'}
					},
					{
						xtype : 'capacityplanningsystemsettings',
						//margin:10,
						parent:this
					}
			],
			renderTo:'cpsystem-body',
			listeners:{
					render:function(){
						 Ext.get('closeSettings').on('click', function () {
							thisController.validateAndCloseSettings();
						});
					}
				}
			});
	},
	/*weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData['screenLabels']['reporter.common.Excludes']);
		}
		else
			excludeDaysObj.hide();
	},*/
	resizePanel: function()
	{
		var me = this;
		Ext.EventManager.onWindowResize(function()
		{
			if ( !Ext.isEmpty( appConstants.publicJsonData ) )
			{
				me.loadCapacityGridandTable(appConstants.publicJsonData);
			}
		});
	},
	filterMultiselect: function (obj) {

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('components'), appConstants.rawDataForComponents);
    },
	saveAsCSV : function()
	{
		var s_qryString = '../servlet/egurkha.reporter.SaveInCSVFormat?reporttype=null';
		 if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
 	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	savePdf : function()
	{
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var selectedGroup = appConstants.publicJsonData['hiddenParams']['select_group'];
		var paramsForCompChange='';
		if(selectedGroup!=null && (selectedGroup=='Service' || selectedGroup=='Segment'))
		{
			paramsForCompChange = '&select_group='+selectedGroup+'&er_site='+capacitySystemMainForm.findField('er_site').getValue();
		}
		else
		{
			var er_comptype = capacitySystemMainForm.findField('er_site').getValue();
			var compArr = new Array();
			compArr = componentForm.findField('components').getValue();
			var compQStr = '';
			/*if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					compQStr += '&er_component='+encodeURIComponent(compArr[i]);
				}
			}*/
			paramsForCompChange = '&select_group='+selectedGroup+'&er_comptype='+er_comptype+compQStr;
		}
		var er_timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timePeriodFromHrs = '';
		var timePeriodFromMins ='';
		var timePeriodToHrs = '';
		var timePeriodToMins = '';
		var reportgen = '';
		var excludeWeekEnd = '';
		if (isSettingsEnabled){
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			 timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			 timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			 timePeriodToHrs = settingsForm.findField('timeto').getValue();
			 timePeriodToMins = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		else
		{
			var pageParams=appConstants.publicJsonData.pageParams;
			timePeriodFromHrs =pageParams.timefrom ;
			timePeriodFromMins = pageParams.minfrom;
			timePeriodToHrs = pageParams.timeto;
			timePeriodToMins = pageParams.minto;
 			reportgen =pageParams.er_reportgenration
			excludeWeekEnd = pageParams.excludeWeekEnd;
		}
		var startdate_mgr = Ext.Date.dateFormat(capacitySystemMainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate_mgr = Ext.Date.dateFormat(capacitySystemMainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startdate = capacitySystemMainForm.findField('er_stdate').dataArray;
		var enddate = capacitySystemMainForm.findField('er_enddate').dataArray;
		var startHour = capacitySystemMainForm.findField('er_sthr').dataArray;
		var endHour = capacitySystemMainForm.findField('er_endhr').dataArray;

		paramsForCompChange = paramsForCompChange+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var s_qryString="../reporter/ErHtmlToSavePdf.jsp?&inidate="+appConstants.publicJsonData['hiddenParams']['inidate']+"&pageWidthProces=700"+paramsForCompChange;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var selectedGroup = appConstants.publicJsonData['hiddenParams']['select_group'];
		var paramsForCompChange='';
		if(selectedGroup!=null && (selectedGroup=='Service' || selectedGroup=='Segment'))
		{
			paramsForCompChange = '&select_group='+selectedGroup+'&er_site='+capacitySystemMainForm.findField('er_site').getValue();
		}
		else
		{
			var er_comptype = capacitySystemMainForm.findField('er_site').getValue();
			var compArr = new Array();
			compArr = componentForm.findField('components').getValue();
			var compQStr = '';
			paramsForCompChange = '&select_group='+selectedGroup+'&er_comptype='+er_comptype+compQStr;
		}
		var er_timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timePeriodFromHrs = '';
		var timePeriodFromMins ='';
		var timePeriodToHrs = '';
		var timePeriodToMins = '';
		var reportgen = '';
		var excludeWeekEnd = '';
		if (isSettingsEnabled){
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			 timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			 timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			 timePeriodToHrs = settingsForm.findField('timeto').getValue();
			 timePeriodToMins = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}
		else
		{
			var pageParams=appConstants.publicJsonData.pageParams;
			timePeriodFromHrs =pageParams.timefrom ;
			timePeriodFromMins = pageParams.minfrom;
			timePeriodToHrs = pageParams.timeto;
			timePeriodToMins = pageParams.minto;
 			reportgen =pageParams.er_reportgenration
			excludeWeekEnd = pageParams.excludeWeekEnd;
		}
		var startdate_mgr = Ext.Date.dateFormat(capacitySystemMainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate_mgr = Ext.Date.dateFormat(capacitySystemMainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startdate = capacitySystemMainForm.findField('er_stdate').dataArray;
		var enddate = capacitySystemMainForm.findField('er_enddate').dataArray;
		var startHour = capacitySystemMainForm.findField('er_sthr').dataArray;
		var endHour = capacitySystemMainForm.findField('er_endhr').dataArray;
		paramsForCompChange = paramsForCompChange+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var s_qryString="&inidate="+appConstants.publicJsonData['hiddenParams']['inidate']+"&pageWidthProces=700"+paramsForCompChange;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+"isSchedule=true&";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	print : function()
	{
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var selectedGroup = appConstants.publicJsonData['hiddenParams']['select_group'];
		var paramsForCompChange='';
		if(selectedGroup!=null && (selectedGroup=='Service' || selectedGroup=='Segment'))
		{
			paramsForCompChange = '&select_group='+selectedGroup+'&er_site='+capacitySystemMainForm.findField('er_site').getValue();
		}
		else
		{
			var er_comptype = capacitySystemMainForm.findField('er_site').getValue();
			var compArr = new Array();
			compArr = componentForm.findField('components').getValue();
			var compQStr = '';
			/*if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					compQStr += '&er_component='+encodeURIComponent(compArr[i]);
				}
			}*/
			paramsForCompChange = '&select_group='+selectedGroup+'&er_comptype='+er_comptype+compQStr;
		}
		var er_timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timePeriodFromHrs = '';
		var timePeriodFromMins ='';
		var timePeriodToHrs = '';
		var timePeriodToMins = '';
		var reportgen = '';
		var excludeWeekEnd = '';
		if (isSettingsEnabled){
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
		}else{
			var pageParams=appConstants.publicJsonData.pageParams;
			timePeriodFromHrs =pageParams.timefrom ;
			timePeriodFromMins = pageParams.minfrom;
			timePeriodToHrs = pageParams.timeto;
			timePeriodToMins = pageParams.minto;
 			reportgen =pageParams.er_reportgenration
			excludeWeekEnd = pageParams.excludeWeekEnd;
		}
		var startdate =capacitySystemMainForm.findField('er_stdate').dataArray;// Ext.Date.dateFormat(capacitySystemMainForm.findField('er_stdate').getValue(), mgrDateFormat);
		var enddate = capacitySystemMainForm.findField('er_enddate').dataArray;//Ext.Date.dateFormat(capacitySystemMainForm.findField('er_enddate').getValue(), mgrDateFormat);
		var startHour = capacitySystemMainForm.findField('er_sthr').dataArray;
		var endHour = capacitySystemMainForm.findField('er_endhr').dataArray;

		paramsForCompChange = paramsForCompChange+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin;
		var s_qryString="/final/reporter/ErSystemCapacityReportPrint.jsp?inidate="+appConstants.publicJsonData['hiddenParams']['inidate']+"&pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250"+paramsForCompChange;
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	addTo : function(btn)
	{
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Capacity Planning',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		} */
		var validateForm = this.validateForm();
		if(validateForm)
		{
			this.updateQueryString();
			var target= ''; 
			var btnID = btn.getId();
			var formButtonId=btnID; 
			var fromScheduleModify = appConstants.publicJsonData['hiddenParams']["fromScheduleModify"];
			
			if (fromScheduleModify == "Yes")
				btnID = 'scheduleImg';
			
			if (btnID == 'scheduleImg') 
			{					 
				target = "/final/reporter/ErSaveSchedule.jsp?isSchedule=true&"+appConstants.queryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (formButtonId=='save' || formButtonId=='mainformsave')
				{ 
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
					parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
			else
			{ 
				var favorite_id = appConstants.favorite_id;
				if(favorite_id == undefined)
				{
					favorite_id = appConstants.publicJsonData.hiddenParams["favorite_id"];
				}
				target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&cmd=client&"+appConstants.queryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken; 
				if (formButtonId=='save' || formButtonId=='mainformsave')
				{ 
					target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1); 
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
					parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
 		}
	},
	changeCompType : function(combo)
	{
		var selectedGroup  = appConstants.publicJsonData['pageParams']['selectedGroup'];
		var meForm = combo.up('form').getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var erType = appConstants.publicJsonData.hiddenParams.er_type;
		if(selectedGroup!=null && selectedGroup=="Component")
		{
			Ext.Ajax.request({
					url : '/final/reporter/ErSystemCapacityReportJson.jsp',
					params: "&select_group=Component&action=changeComponent&er_comptype="+combo.getValue()+"&er_type="+erType,
					scope:this,
					success: function(response)
					{
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						var componentMultiSelect = componentForm.findField('components');
						appConstants.rawDataForComponents = jsonData['componentList'];
						componentMultiSelect.getStore().loadRawData(jsonData['componentList']);
						componentMultiSelect.setValue(jsonData['pageParams']['selectedComps']);

						appConstants.publicJsonData['pageParams']['startmin'] = jsonData['pageParams']['startmin'];
						appConstants.publicJsonData['pageParams']['endmin'] = jsonData['pageParams']['endmin'];
					}
			});
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.beforeReportSubmit();
		}
	},
	
	changeReportType : function(combo)
	{
		var gridPanelObj = this.getMain().getComponent('gridPanel');
		var tablePanel = Ext.getCmp('tablePanel');
		gridPanelObj.removeAll();
		tablePanel.removeAll();
		gridPanelObj.hide();
		var erType = combo.getValue();
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);

		//this.hideTools();
		/*if(erType == 'Yes')
		{
			
		}*/
		var favorite_id = appConstants.publicJsonData.hiddenParams["favorite_id"]; 
		if(favorite_id != undefined)
		{
			appConstants.favorite_id=favorite_id;
		}
		appConstants.publicJsonData.hiddenParams.er_type = erType;
		var hiddenParamData = appConstants.publicJsonData.hiddenParams;
		var selectedGroup  = appConstants.publicJsonData['pageParams']['selectedGroup'];
		var componentForm = Ext.getCmp('mainform').getForm();
		var paramData = "&select_group="+selectedGroup+"&action=defaultLoad&er_trenddata=Yes&isLegendEnabled=true&er_type="+erType+"&er_RmDispName=System Capacity Analysis  By Component"
		Ext.Ajax.request({
				url : '/final/reporter/ErSystemCapacityReportJson.jsp',
				params: paramData,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicJsonData = jsonData;
					appConstants.publicJsonData.hiddenParams = hiddenParamData;
					
					/*var compType = componentForm.findField('er_site');
					compType.getStore().loadRawData(jsonData['componentTypeList']);
					compType.setValue(jsonData['pageParams']['selectedCompType']);*/

					this.getCapacityplanningsystemmainform().loadFields();


					var componentMultiSelect = componentForm.findField('components');
					appConstants.rawDataForComponents = jsonData['componentList'];
					componentMultiSelect.getStore().loadRawData(jsonData['componentList']);
					componentMultiSelect.setValue(jsonData['pageParams']['selectedComps']);

					appConstants.publicJsonData['pageParams']['startmin'] = jsonData['pageParams']['startmin'];
					appConstants.publicJsonData['pageParams']['endmin'] = jsonData['pageParams']['endmin'];					
				}
		});
	},
	validateAndCloseSettings :  function()
	{
 		var settingsForm = this.getCapacityplanningsystemsettings().getForm();
		var timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
		var timePeriodFromMins = settingsForm.findField('minfrom').getValue();
		var timePeriodToHrs = settingsForm.findField('timeto').getValue();
		var timePeriodToMins = settingsForm.findField('minto').getValue();
 		if(!checkTimePeriod(timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins))
		{
			return;
		}
 		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
  			return false;
		}
		else if (Ext.getCmp('reportGeneration').getValue() == 'background-csv' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
  			return false;
		}
 		Ext.getCmp('submit').setDisabled(false);
		Ext.getCmp('mainformsubmit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
 	},
	validateSettings :  function()
	{
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		var reportgen,reportName;
		if (isSettingsEnabled)
		{
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{
			var pageParams=appConstants.publicJsonData.pageParams;
 			reportgen =pageParams.er_reportgenration;
 			reportName = pageParams.bgReportName;
		}
		var stDate = capacitySystemMainForm.findField('er_stdate').getValue();
		var enDate = capacitySystemMainForm.findField('er_enddate').getValue();
		stDate.setHours(capacitySystemMainForm.findField('er_sthr').getValue());
		enDate.setHours(capacitySystemMainForm.findField('er_endhr').getValue());

		var er_timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return;
			}
		}
		//var reportgen = settingsForm.findField('reportGeneration').getValue();
		var getMaxDaysInMonth = appConstants.publicJsonData['hiddenParams']['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = appConstants.publicJsonData['hiddenParams']['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}
		var isSettingsOk = true;
		/*	var bgenabled = "";
		var bgenabledObj = Ext.getCmp("bgenabled");
		if(bgenabledObj!=null && bgenabledObj!="undefined")
		{
			bgenabled = bgenabledObj.getValue();
		}*/

		/*	if(bgenabled!=null && bgenabled.toLowerCase() =="yes")
		{*/
		if (reportgen == 'foreground' )
		{
			var limitforbg = appConstants.publicJsonData['hiddenParams']['limitforbg'];

			if(!Ext.isEmpty(limitforbg))
			{
				if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				}
			}
		}
		else
		{
				//var reportNameObj = settingsForm.findField('bgReportName');
				//var reportName = reportNameObj.getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					reportNameObj.focus();
					return false;
				}
		}
	//	}
		if(isSettingsOk && isSettingsEnabled)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			var mainformsubmit = Ext.getCmp('mainformsubmit');
			mainformsubmit.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			if (isSettingsEnabled)
			{
				var getButtonObj = Ext.getCmp('submit');
				getButtonObj.setDisabled(false);
				var mainformsubmit = Ext.getCmp('mainformsubmit');
				mainformsubmit.setDisabled(false);
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
			this.submitReport();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			settingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = settingsForm.findField('bgReportName');
			reportNameObj.show();
 			this.beforeReportSubmit();
 		}
	},
	validateForm : function()
	{
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		//var settingsForm = this.getCapacityplanningsystemsettings().getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var selectedGroup = appConstants.publicJsonData['hiddenParams']['select_group'];
		if(selectedGroup!=null && (selectedGroup=='Service' || selectedGroup=='Segment'))
		{
			var selectedGrpVal = capacitySystemMainForm.findField('er_site').getValue();
			if(selectedGrpVal!=null && selectedGrpVal=="-1")
			{
				alert("Please choose a "+selectedGroup);
				return false;
			}
		}
		else
		{
			var er_comptype = capacitySystemMainForm.findField('er_site').getValue();
			var selectedGrpVal = capacitySystemMainForm.findField('er_site').getValue();
			if(er_comptype!=null && er_comptype=="-1")
			{
				alert("Please choose a component type");
				return false;
			}
			var compArr = new Array();
			compArr = componentForm.findField('components').getValue();
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					compQStr += '&er_component='+encodeURIComponent(compArr[i]);

				}
			}
			if(compQStr!=null && compQStr=="")
			{
				alert("Please choose a component");
				return false;
			}
		}
		var strtdt = capacitySystemMainForm.findField("er_stdate").getValue();
		var enddt = capacitySystemMainForm.findField("er_enddate").getValue();
		var strthour = capacitySystemMainForm.findField("er_sthr").getValue();
		var endhr = capacitySystemMainForm.findField("er_endhr").getValue();

		var sdate = capacitySystemMainForm.findField("er_stdate").parseDate(strtdt);
		var eDate = capacitySystemMainForm.findField("er_enddate").parseDate(enddt);
		var formated_sdate = Ext.Date.dateFormat(sdate, mgrDateFormat);
		var formated_edate = Ext.Date.dateFormat(eDate, mgrDateFormat);
		var starttime = formatDate(new Date(getDateFromFormat(formated_sdate, appConstants.iniDateFormat)), "MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(formated_edate, appConstants.iniDateFormat)), "MM/dd/yyyy");

        var bool = checktime(starttime, endtime, strthour, endhr);

        if (!bool)
        {
            Ext.Msg.show({
                title: 'Alert',
                msg: appConstants.datealert,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            return;
        }
		return true;
	},
	beforeReportSubmit: function()
	{
		var isValidForm = this.validateForm();
		if(isValidForm && this.validateSettings())
		{
			this.submitReport();
		}
	},
	updateQueryString: function()
	{

		var timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins,reportgen,excludeWeekEnd,reportName;
		if (isSettingsEnabled)
		{
			var settingsForm = this.getCapacityplanningsystemsettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('er_excwe').getValue();
			reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{
			var pageParams=appConstants.publicJsonData.pageParams;
			timePeriodFromHrs =pageParams.timefrom ;
			timePeriodFromMins = pageParams.minfrom;
			timePeriodToHrs = pageParams.timeto;
			timePeriodToMins = pageParams.minto;
			reportgen =pageParams.er_reportgenration;
			excludeWeekEnd ="Yes" ;
			reportName = pageParams.bgReportName;
		}
		var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
		var componentForm = Ext.getCmp('mainform').getForm();
		var selectedGroup = appConstants.publicJsonData['hiddenParams']['select_group'];
		var paramsForCompChange='';
		if(selectedGroup!=null && (selectedGroup=='Service' || selectedGroup=='Segment'))
		{
			paramsForCompChange = '&er_site='+capacitySystemMainForm.findField('er_site').getValue();
		}
		else
		{
			var er_comptype = capacitySystemMainForm.findField('er_site').getValue();
			var compArr = new Array();
			compArr = componentForm.findField('components').getValue();
			var compQStr = '';
			if(compArr!=null && (compArr!="" && compArr!="null"))
			{
				for ( var i = 0; i < compArr.length; i++ )
				{
					compQStr += '&er_component='+encodeURIComponent(compArr[i]);
				}
			}
			paramsForCompChange = '&er_comptype='+er_comptype+compQStr;
		}
		var er_timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		var startdate = capacitySystemMainForm.findField('er_stdate').dataArray;
		var enddate = capacitySystemMainForm.findField('er_enddate').dataArray;
		var startHour = capacitySystemMainForm.findField('er_sthr').dataArray;
		var endHour = capacitySystemMainForm.findField('er_endhr').dataArray;
		var timeline = capacitySystemMainForm.findField('er_timeline').getValue();
		paramsForCompChange = paramsForCompChange+"&er_timeline="+timeline+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		var erType = hiddenData['er_type'];
		var opt = 'chart';
		if(erType == 'No')
			opt = 'data';
		paramsForCompChange += '&opt='+opt;
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			paramsForCompChange = hiddenQstr+paramsForCompChange;
		}

		if ( reportgen!=null && reportgen == 'background' )
		{
			reportName=checkFileName(reportName);
			paramsForCompChange = paramsForCompChange+"&forwardto=ErSystemCapacityReportJson&bg_reportname="+reportName;
			appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC";
		}
		else if ( reportgen!=null && reportgen == 'background-csv' )
		{
			reportName=checkFileName(reportName);
			paramsForCompChange = paramsForCompChange+"&forwardto=ErSystemCapacityReportJson&bg_reportname="+reportName;
			appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
		}
		else
		{
			paramsForCompChange = paramsForCompChange+"&forwardto=ErSystemCapacityReport";
			appConstants.urlForSubmit = "../servlet/com.eg.ErSystemCapacityReportC";
		}
		appConstants.queryString = paramsForCompChange+'&isSubmit=true';
	},
	loadCapacityGridandTable: function(resultData){
		var gridPanelObj = this.getMain().getComponent('gridPanel');
		var hasAdminTab=resultData.hasAdminTab;
		var isCompletedUserRole=resultData.isCompletedUserRole;
		var capacityTrendEnabled=resultData.isCapacityTrendEnabled.toLowerCase();
		var tablePanel = Ext.getCmp('tablePanel');
		gridPanelObj.removeAll();
		tablePanel.removeAll();
		gridPanelObj.show();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		//tablePanel.show();
		if(!Ext.isEmpty(resultData))
		{
				appConstants.publicJsonData = resultData;
				var reportgen;
				if (isSettingsEnabled)
				{
					reportgen= Ext.getCmp('reportGeneration').getValue();
				}
				else
				{
					reportgen=resultData.pageParams.er_reportgenration;
				}
				Ext.getCmp('selectionDetails').setSelectionDetailsData(resultData.selDetailsJson);
			    

				if(reportgen!=null && reportgen == "foreground")
				{
					var erType = resultData.hiddenParams['er_type'];
					if(erType == 'No')
					{
						var dataAvailable = resultData['dataAvailable'];
						if(dataAvailable!=null && dataAvailable=='true')
						{							
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("csvTool").setDisabled(false);
							Ext.getCmp("upbutton").setDisabled(false);

						var gridDataObj = resultData['gridObj'];
						var title = gridDataObj['GRID_TITLE'];
						var columns = gridDataObj['COLUMNS'];
						var genColumns = new Array();
						var gridIndexVals = gridDataObj['gridData'];
						var gridWidth = gridPanelObj.getWidth();
						var subColCount=  gridDataObj['gridColumnCnt'];
						var calcWidth = ( gridWidth / subColCount );
						calcWidth = Math.round(calcWidth);
						var gridStore = gridIndexVals;
						var gridFields = new Array();
						var index = 1;
						for ( var i = 0; i < columns.length; i++ )
						{
							var colObj = columns[i];
							var colName = colObj['colName'];
							var measureColumnName = colObj['Measurement'];
							var subColumnsCount =colObj['SUB_COLUMNS'];
							var subColumns = colObj['subHeadingsForMeasure'];
							if ( measureColumnName == 'NONE' )
							{
								measureColumnName = '&nbsp;';
							}
							var subCols = new Array();

								for ( var j = 0; j < subColumnsCount; j ++ )
								{
									var subColumnName = subColumns[j];
									if(j==0 && subColumnsCount==4)
									{
										gridFields.push({ name : 'COLUMN_'+index  , type : 'string' });
									}
									else
									{
										gridFields.push({ name : 'COLUMN_'+index  , type : 'float' });
									}
									gridFields.push({ name : 'COLUMN_Color'+index , type : 'string' });
					//				gridFields.push('COLUMN_'+(index));
									if ( subColumnName == 'NONE' )
									{
										subColumnName = '&nbsp;';
									}
									var colWidth = 0;
									if ( subColumnsCount == 1 )
									{
										if ( columns.length < 6 )
										{
											colWidth = 90;
										}
										else
										{
											colWidth = 90;
										}
									}
									else
									{
										if ( columns.length < 6 )
										{
											colWidth = 110;
										}
										else
										{
											colWidth = 55;
										}
									}
									subCols.push({
										header: subColumnName,
										sortable: true,
										//width: calcWidth,
										align: 'center',
										dataIndex: 'COLUMN_'+(index),
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											if(typeof value == 'number')
											{
												if(isNaN(value))
												{
													value="-";
												}
												var cellCls = record.get('COLUMN_Color'+col); 
												if(value!='' && (cellCls!=null && cellCls!="undefined" && cellCls!=undefined) && (cellCls!='-' && cellCls!=''))
												{ 
													//metaData.tdCls = cellCls;
											value='<div style="background-color:'+cellCls+';height:14px;line-height:16px;margin-top:-2px">'+value+'</div>';
												}
											}
											return value;
										}
									});

							index++;
						}
						var measureColumns = new Array();
						measureColumns.push({
							header : measureColumnName,
							sortable: true,
							//width: 160,
							//flex :1,
							align: 'center',
							columns: subCols
						});
						if ( i == 0 )
						{
							gridFields.push({ name : 'COLUMN_0'  , type : 'string' });
							genColumns.push(
							{
								header: colName,
								sortable: true,
							//	flex: 1,
								//width: 220,
								align: 'center',
								dataIndex: 'COLUMN_0',
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							});
						}
						else
						{
							var tmpColName = colName;
							genColumns.push(
							{
								header: tmpColName,
								sortable: true,
								align: 'center',
								columns: measureColumns
							});
						}
					}
					appConstants.initLdgMask.hide();
					gridPanelObj.add(
					{
						xtype:'panel',
						ui:'newGraphPanel',
						title:title,
						margin:'10 10 10 10',
						columnWidth:1.0,
						items:[{
							xtype:'customgrid',
							store: Ext.data.Store(
								{
									fields: gridFields,
									data:gridIndexVals,
									groupField: 'COLUMN_0'
								}),
							border:true,
							ui:'newGridPanel',
							//layout: 'auto',
								//title: "<div id='font_bold'>"+title+"</span>",
							scroll:true,
							frame: false,
							margin:'5 10 5 10',
							//margin: '0 0 10 0',
							autoScroll:true,
								//cls:'gridSkin',
							popUpData:'grid',//add this to avoid tooltip in customgrid
							needtoFixColumn:true,
							columns:genColumns,
							features : [{
								id: 'group',
								ftype: 'grouping',
								groupHeaderTpl: '{name}',
								hideGroupedHeader: true,
								enableGroupingMenu: false
							}]
						}]
					});
					gridPanelObj.doLayout();
					var measThreshDataArr = resultData['measThreshDataArr'];
					tablePanel.add({
						xtype:'dataview',
						id:'measureStateView',
						margin:'10 10 10 10',
						//ui:'newGraphpanel',
						store: new Ext.data.Store({
						fields:['measure','major','critical'],
						data:measThreshDataArr
					}),
					tpl:new Ext.XTemplate(
				'<div class="newTable" >',
				'<table cellspacing="0" cellpadding="0" align="center" border="0" width="100%">',
					'<thead>',
						'<tr>',
							'<th style="text-align:left">',
								'<div>'+resultData['screenLabels']['reporter.common.Measurements']+'</div>',
							'</th>',
							'<th style="text-align:center">',
								'<div><div style="float:left;margin-right:4px;margin-left:25%" class="state_footer_INTERMEDIATE"></div><div style="float:left">'+resultData['screenLabels']['reporter.capacity.Major']+'</div>',
							'</th>',
							'<th style="text-align:center">',
								'<div><div style="float:left;margin-right:4px;margin-left:25%" class="state_footer_HIGH"></div><div style="float:left">'+resultData['screenLabels']['reporter.capacity.Critical']+'</div>',
							'</th>',
						'</tr>',
					'</thead>',
					'<tbody>',
					'<tpl for=".">',
						'<tr>',
							'<td style="text-align:left">',
								'<div>{measure}</div>',
							'</td>',
							'<td style="text-align:center">',
								'<div>{major}</div>',
							'</td>',
							'<td style="text-align:center">',
								'<div>{critical}</div>',
							'</td>',
						'</tr>',
					'</tpl>',
					'</tbody>',
				'</table>',
				'</div>'
						),
					itemSelector: 'div.newTable'
					});
					tablePanel.doLayout();
					gridPanelObj.show();
					tablePanel.show();
				}
				else
				{
					if(capacityTrendEnabled != null && capacityTrendEnabled=="false")
					{
 						if(hasAdminTab || isCompletedUserRole)
						{
							gridPanelObj.update('<div style="text-align:center;margin-top: 7%;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /><div> Capacity trend computation is currently not enabled.<a href="javascript:void(0)" onclick="callAdminToEnableCP()"> Please <span style="text-decoration:underline">click here</span> to enable the flag</a></div></div>');
							gridPanelObj.doLayout();
							appConstants.initLdgMask.hide();
						}else
						{
							gridPanelObj.update('<div style="text-align:center;margin-top: 17%;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>');
							gridPanelObj.doLayout();
							appConstants.initLdgMask.hide();
						}
					}
					else {
							gridPanelObj.hide();
							this.getNomeasurepanel().doLayout();
							this.getNomeasurepanel().show();
				        	appConstants.initLdgMask.hide();
					}
				}
			}
			else if(erType == 'Yes')
			{
				var chartObj = resultData.chartDataArr;
				if(chartObj != null && chartObj != "undefined")
				{	

					appConstants.opt = 'chart';
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(true);
					Ext.getCmp("upbutton").setDisabled(false);
					
					/*gridPanelObj.add({
						xtype:'panel',
						cls:'reporterContentPanelBody',
						title:'rrrrr',
						margin:'10 10 10 10',
						layout:'column',
						id:'chartPannel',
						autoScroll:true
					});*/
//						
					for(var comp in chartObj)
					{
						var chartDataVal = chartObj[comp];
						var chartTit = chartDataVal['title'];
						chartDataVal['title'] = '';								
						var idVal = 'chartPannel'+comp;
						marginVal = '10 10 10 10';
						if(comp%2 != 0)
						{
							marginVal = '10 10 10 0';
						}
						var columnwWdth = 1;
						if(chartObj.length>1)
						{
							columnwWdth = 0.5;
						}								
							var applFailContent='<div id='+idVal+' style="height:100%;width:100% !important;overflowY:hidden;padding-top:10px"></div>';
						gridPanelObj.add(
						{
							xtype:'panel',
								ui:'newGraphPanel',
							title:chartTit,
							height:340,
							columnWidth:columnwWdth,
							margin:marginVal,
							autoScroll:false,
							html:applFailContent
						});
						var topNAppSBar = {};
						topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance(idVal,270,490), topNAppSBar);
						topNAppSBar.setData(chartDataVal, '<%=currentDateFormat%>','');
						topNAppSBar.drawChart();							
					}
				}
				else
				{
					gridPanelObj.hide();
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
					appConstants.initLdgMask.hide();
				}
					appConstants.initLdgMask.hide();
				}
			}
			else if (reportgen!=null &&(reportgen == "background" || reportgen == "background-csv"))
			{
					gridPanelObj.hide();
					var resultObj = this.getBackGroundPanel();
					resultObj.removeAll();
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
					Ext.getCmp("upbutton").setDisabled(false);

					var bgGroundMsg = resultData.pageParams['bggroundStr'];
					var status = resultData.pageParams['status'];
					var langSupportString = resultData.pageParams['bgRrtMsg'];
					var bgReportUrl = resultData.pageParams['bgRrtUrl'];
					var bgreportlinkMsg = resultData.pageParams['bgRptLinkMsg'];
					var tableTitle='';
					var htmlStr = "";
					var statusCssClass='iconInformation';
					if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
					{
						statusCssClass = 'iconExclamation';
					}

						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';

						resultObj.add({
						xtype: 'panel',
							//style:{'background':'#ff0000'},
							margin:0,
							bodyPadding:0,
							//height: '100%',
							//width: '100%',
							html:htmlStr
						});
						resultObj.doLayout();
						resultObj.show();
					appConstants.initLdgMask.hide();
			}
		}
		else
		{
			gridPanelObj.update('<div style="text-align:center""><div class="iconExclamation" style="margin:15% auto 0 auto;"></div><div>No Measures Available</div></div>');
			gridPanelObj.doLayout();
			appConstants.initLdgMask.hide();
		}
	},
	submitReport : function(combo)
	{
 		var reportgen;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen=appConstants.publicJsonData.pageParams.er_reportgenration;
		}
 		this.updateQueryString();
		if(reportgen == "foreground")
		{
			appConstants.queryString = appConstants.queryString+'&responseType=json';
		}
	 	appConstants.queryString += '&er_RmDispName='+appConstants.er_RmDispName;
 		appConstants.initLdgMask.show();
		Ext.Ajax.request({
			url : appConstants.urlForSubmit,
			params: appConstants.queryString,
 			scope:this,
			success: function(response)
			{
				var jsonText  = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.loadCapacityGridandTable(jsonData);
			}
		});
	},
	showBackgroundReport: function(combo)
	{
		var settingsForm = this.getCapacityplanningsystemsettings().getForm();
		var val = combo.getValue();
		var reportNameObj = settingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( val == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	defaultLoad :  function()
	{   
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
		var from_schedule = appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.publicJsonData['hiddenParams']["fromFavoriteModify"];

		if (!Ext.isEmpty(appConstants.publicJsonData['gTypeArr'])) {
			var gTypeArrData = appConstants.publicJsonData['gTypeArr'];
			var er_typeObj = Ext.getCmp('er_type');
			er_typeObj.suspendEvents(true);
			er_typeObj.getStore().loadRawData(gTypeArrData);
			if (!Ext.isEmpty(appConstants.publicJsonData.hiddenParams)) {
				er_typeObj.setValue(appConstants.publicJsonData.hiddenParams['er_type']);
			} else {
				er_typeObj.setValue(gTypeArrData[0].valueField);
			}
			er_typeObj.resumeEvents();
		}

		this.getCapacityplanningsystemmainform().loadFields();
		if(!appConstants.hideBackButton){

			Ext.getCmp('capacityplanningsystem').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		isTrend = true;
		var selectedGroup = appConstants.publicJsonData['pageParams']['selectedGroup'];

		if(selectedGroup!=null && !(selectedGroup=="Service" || selectedGroup=="Segment"))
		{
			var capacitySystemMainForm = this.getCapacityplanningsystemmainform().getForm();
			//this.changeCompType(capacitySystemMainForm.findField('components'));
		}
		//this.getCapacityplanningsystemsettings().loadSettingsData();
		if(appConstants.isSubmit=='true' && fromFavoriteModify == null && from_schedule == null)
		{
//			this.loadCapacityGridandTable(appConstants.publicJsonData);
			this.beforeReportSubmit();
		}else {
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeReportSubmit();
			}
		}
	},
	loadSettings:function(){
				Ext.getCmp('moreOptionCloseId').show();
				var hiddenFields = appConstants.publicJsonData.hiddenParams;
				var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
					Ext.getCmp('reportGeneration').setDisabled(true);
				}
				if(isSettingsEnabled)
					this.getCapacityplanningsystemsettings().loadSettingsData();
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	hideMode:function(){
		Ext.get('er_mode').hide();
	},
	hideTools:function(){

		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //cvs
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
			);

		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	expandMe:function(btn){
 		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),'Components',btn);
	}
});