Ext.define('cpSystemApp.view.CapacityPlanningSystemMainForm',{
	extend:'Ext.form.Panel',
	alias:'widget.capacityplanningsystemmainform',
	id:'capacityplanningsystem',
	collapseMode: 'mini',		
	layout: 'column',
	defaults:{
		labelAlign:'top',
		margin:'0 20 10 0',
		queryMode : 'local',
		labelSeparator:''
	},
	items:[
				{
		xtype:'fieldcontainer',
		layout:'column',
		items:[
				{
					xtype:'scrollcombo',
					width: 100,
					cls: 'dropdown',
					editable : false,
					margin:'0 20 10 0',
					fieldLabel:'Report Type',
					name: 'er_type',
					id: 'er_type',
					labelSeparator : '',
					labelAlign:'top',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : ['Graph', 'Data']
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					width: 150,
					editable : true,
					margin:'0 20 10 0',
					id: 'er_site',
					name: 'er_site',
					labelSeparator : '',
					labelAlign:'top',
					fieldLabel:'Service',
					listConfig:{
							emptyText:noMatch
						},
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden: false
				},
				{
						xtype:'timeline',
						margin:0
				},
	]},
				{
				xtype:'container',
				layout:'column',
				id:'capacityformcontainer',
				hidden:true,
				margin:'20 0 0 10',
				items:[
				{
					xtype:'button',
					text: submitValue,
					hidden:true,
					//cls: 'button20',
					ui:'newButtonSmall',
					id: 'submit',					
					name: 'submit'
					
				},
				{
					xtype:'button',
					text: "Save",
					//cls: "button20",
					ui:'newButtonSmall',
					id: "save",					
					name: "save",
					hidden:true
				}
				]}
				
		],
	loadFields : function()
	{
		var meForm = this.getForm();
		var  repGrpObj = meForm.findField('er_site');
		var localjson=appConstants.publicJsonData;
		var selectedGroup = localjson['pageParams']['selectedGroup'];
		var from_schedule = appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
		var fromFavoriteModify = appConstants.publicJsonData['hiddenParams']["fromFavoriteModify"];
		if(selectedGroup!=null && (selectedGroup=="Service" || selectedGroup=="Segment"))
		{
			repGrpObj.getStore().loadRawData(localjson['selectedGrpList']);
			repGrpObj.setValue(localjson['pageParams']['selectedGroupValue']);
			repGrpObj.setFieldLabel(localjson['screenLabels']['selectedGroup']);
			Ext.getCmp('capacityformcontainer').show();
			if (from_schedule == "Yes"|| fromFavoriteModify == "Yes") {
				Ext.getCmp('save').show(); 
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}
			else
			{
				Ext.getCmp('submit').show();
			}
			Ext.getCmp('mainformsubmit').hide();
		
		}
		else
		{
			repGrpObj.getStore().loadRawData(localjson['componentTypeList']);
			repGrpObj.setValue(localjson['pageParams']['selectedCompType']);
			repGrpObj.setFieldLabel(localjson['screenLabels']['reporter.capacity.Component Type']);
			
			Ext.getCmp('compLbl').setText(localjson['screenLabels']['reporter.capacity.Component']);
   			Ext.getCmp('components').getStore().loadRawData(localjson['componentList']);
			Ext.getCmp('components').setValue(localjson['pageParams']['selectedComps']);
 			Ext.getCmp('componentFieldContainer').show();
			Ext.getCmp('capacityformcontainer').hide();
			if (from_schedule == "Yes"|| fromFavoriteModify == "Yes") {
				Ext.getCmp('mainformsave').show(); 
			}
			else
			{
				Ext.getCmp('mainformsubmit').show();
			}
					
		}
		var timelineLbl=localjson.screenLabels['reporter.common.Timeline'];
		var timelineJSONArray = localjson['timelineComboArray'];
		var timeLineComboObj = meForm.findField('er_timeline');
		timeLineComboObj.getStore().loadRawData(timelineJSONArray);
		timeLineComboObj.setValue(localjson.pageParams.selectedTimeline);
		timeLineComboObj.setFieldLabel(timelineLbl);

		var startdateObj = meForm.findField('er_stdate');
		var enddateObj = meForm.findField('er_enddate');
		var startHourObj = meForm.findField('er_sthr');
		var endHourObj = meForm.findField('er_endhr');

		var stDate = localjson.pageParams['startDateJSON'];
		var endDate = localjson.pageParams['endDateJSON'];
		var startHr = localjson.pageParams['startHourJSON'];
		var endHr = localjson.pageParams['endHourJSON'];

		/*startdateObj.setFieldLabel(fromLbl);
		enddateObj.setFieldLabel(toLbl);
		startHourObj.setFieldLabel(hrsLbl);
		endHourObj.setFieldLabel(hrsLbl);

		startdateObj.setValue(stDate);
		enddateObj.setValue(endDate);
		startHourObj.setValue(startHr);
		endHourObj.setValue(endHr);*/


        startdateObj.setValue(localjson.pageParams['startDateForDisplay']);
        startdateObj.dataArray = stDate;
        startHourObj.setValue(localjson.pageParams['startHourForDisplay']);
        startHourObj.dataArray = startHr;
        enddateObj.setValue(localjson.pageParams['endDateForDisplay']);
        enddateObj.dataArray = endDate;
        endHourObj.setValue(localjson.pageParams['endHourForDisplay']);
        endHourObj.dataArray = endHr;
        stmin = localjson.pageParams['startMinForDisplay'];
        enmin = localjson.pageParams['endMinForDisplay'];
        mgr_stmin = localjson.pageParams['startmin'];
        mgr_enmin = localjson.pageParams['endmin'];

		meForm.findField('er_mode').hide();
		appConstants.rawDataForComponents = localjson['componentList'];
	
	}
})