	Ext.define('CapacityPredictionReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main','DetailTimeLine'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'graphpanel', ref:'graphpanel'},
		{selector : 'defineconfiguration', ref:'defineconfiguration'},
		{selector : 'capacitypredictionreportssettings', ref:'capacitypredictionreportssettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init : function() {
		this.control({
					'main':{
						'boxready':this.loadDefualtData
					},
					'capacitypredictionreportssettings':{
						'afterrender':this.loadSettings
					},
					'main newUtilities' : {
						'afterrender' : this.hideTools
					},
					'defineconfigurationpopup' : {
						'afterrender' : this.renderPopUp
					},
					'main button[id="defineconfiguration"]' : {
						'click' : this.defineConfigurationPOPUP
					},
					'defineconfigurationpopup  button[id="addtogrid"]' : {
						'click' : this.addToGrid
					},
					'modifyconfigurationpopup button[id="update"]':{
						'click':this.modifyGrid
					},
					'defineconfigurationpopup button[id="expandSelectorComponent"]':{
						 'click':this.expandSelectorComponent
					},
					 'defineconfigurationpopup button[id="expandSelectorDescriptor"]':{
						 'click':this.expandSelectorDescriptor
					},
					'capacitypredictionreportssettings combo[name="reportGeneration"]':{
							'select': this.reportGenChange
					 },
					'capacitypredictionreportssettings button[id="moreOptionCloseId"]': {
					'click': this.validateAndCloseSettings
					},
					'capacitypredictionreportssettings button[id="submitViaSetting"]': {
						'click': this.closeSettingAndSubmit
					},
					'defineconfigurationpopup  button[id="defineconfigclose"]' : {
						'click' : this.closePanel
					},
					'modifyconfigurationpopup  button[id="modifyconfigclose"]' : {
						'click' : this.closeModifyPanel
					},
					/*'capacitypredictionreportssettings  combo[id="er_excwe"]' : {
						'select' : this.enableExcludeWeekendLabel
					},*/
					'defineconfiguration button[id="submit"]' : {
						'click' : this.showGraph
					},
					'defineconfiguration button[id="save"]' : {
						'click' : this.add
					},
					'capacitypredictionreportssettings combo[name="er_dataoption"]':{
						'select':this.predictUsingComboChange
					},
					'configdatas' : {
						afterrender : function(cmp) {
							var me = this;
							Ext.getBody().on('click', function() {
									me.defineConfigurationPOPUP();
									}, null, {
										delegate : 'b#linkId'
									});
						}
					},
					'timeline combo[name="er_mode"]': 
					 {
						 'select': this.changeEr_mode
					 },
					'graphtypeanddata combo[name=showdata]' : {
						'select' : this.trenddetail
					},
					'newUtilities > #saveTool > button' : {
						'click' : this.saveFileTool
					},
					'newUtilities > #printTool > button' : {
						'click' : this.printFile
					},
					'newUtilities > #mailTool > button' : {
						'click' : this.sendMail
					},
					'newUtilities > #dataTool > button' : {
						'click' : this.dataFile
					},
					'newUtilities > #favoriteTool > button' : {
						'click' : this.add
					},
					'newUtilities > #scheduleTool > button' : {
						'click' : this.add
					},
					'defineconfigurationpopup trigger[id="compSearch"]' : {
						'change' : this.filterMultiselect
					},
					'defineconfigurationpopup trigger[id="descSearch"]' : {
						'keyup' : this.filterMultiselect
					},
					'defineconfiguration button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					}
				});
	},
	loadSettings:function(){	
		Ext.getCmp('moreOptionCloseId').show();
		var favorite_id = appConstants.dafaultJSON["hiddenFields"]["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		this.getCapacitypredictionreportssettings().loadData();
	},
		enableExcludeWeekendLabel : function(combo) { 
		if (combo.getValue() == 'Yes') {
			Ext.getCmp('excludeDays').show();
		} else
			Ext.getCmp('excludeDays').hide();
	},
	loadDefualtData : function(thisObj){
		var localjson=appConstants.dafaultJSON;

		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);        
		//var submitObj = Ext.getCmp("submit");		
		var thisForm=this.getDefineconfiguration().getForm();
		var screenLabels = localjson['screenlabels'];
		var timeline = localjson['timeline'];
		this.setComboOptionsInList(thisForm, 'er_look_forward', timeline.predictforCombo, timeline.predictforCombo_value);
		this.setComboOptionsInList(thisForm, 'er_timeline', timeline.timelineCombo, timeline.timeline_value);
		this.setComboValue(thisForm,'er_sthr',timeline.starthour_value);
		this.setComboValue(thisForm,'er_endhr',timeline.endhour_value);
		Ext.getCmp("er_stdate").setValue(timeline.startDateDispValue);
		Ext.getCmp("er_stdate").dataArray=timeline.startDateValue;
		Ext.getCmp("er_enddate").setValue(timeline.endDateDsipValue);
		Ext.getCmp("er_enddate").dataArray=timeline.endDateValue;
		Ext.getCmp("er_sthr").setValue(timeline.starthourDispvalue);
		Ext.getCmp("er_sthr").dataArray=timeline.starthour_value;
		Ext.getCmp("er_endhr").setValue(timeline.endhourDsipvalue);
		Ext.getCmp("er_endhr").dataArray=timeline.endhour_value;
		mgr_stmin=timeline.startmin;
		mgr_enmin=timeline.endmin;

		if(!appConstants.hideBackButton){
			this.getDefineconfiguration().add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: localjson['ID']
				}
			);
		}

		if(appConstants.frmSchModify == "Yes" || appConstants.fromFavoriteModify == "Yes")
		{
			issubmit = "false";
			appConstants.updateSelection = "true";
			//submitObj.setText(localjson.screenlabels['reporter.common.SAVE']);
			 Ext.getCmp("save").show();
			 Ext.getCmp("submit").hide();
			if ( !Ext.isEmpty( localjson['gridValues'] ) )
			{
				var gridValues = localjson['gridValues'];
				var gridObj = Ext.getCmp('configdatas');
				gridObj.getStore().loadRawData(gridValues);
				gridObj.getSelectionModel().selectAll(gridObj.getStore());
				Ext.getCmp('timelineForm').show();
			}
			//Ext.getCmp('dockitem').show(); 
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
		else
		{
			if(appConstants.isSubmit=='true')
			{
				if(appConstants.fromFavSch == 'true')
				{
					if ( !Ext.isEmpty( localjson['gridValues'] ) )
					{
						var gridValues = localjson['gridValues'];
						var gridObj = Ext.getCmp('configdatas');
						gridObj.getStore().loadRawData(gridValues);
						gridObj.getSelectionModel().selectAll(gridObj.getStore());
						Ext.getCmp('timelineForm').show();
					}				
					//submitObj.setText(localjson.screenlabels['reporter.common.SUBMIT']);
					//Ext.getCmp('dockitem').show(); 
				}
				else
				{
					 this.addToGrid();
					var gridObj =  Ext.getCmp('configdatas');
					gridObj.getSelectionModel().selectAll(gridObj.getStore());
				
				}
				this.showGraph();
			}
		}
		if( Ext.getCmp('showLegend') != undefined){
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				  Ext.getCmp('showLegend').setValue(true);
		}

	},
	 setComboOptionsInList : function(form, fieldName, list, value){

		form.findField(fieldName).getStore().clearFilter(true); 
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		
		form.findField(fieldName).setValue(value);
		form.findField(fieldName).resumeEvents();
	},
	 setComboValue : function(form,fieldName,value){
		 form.findField(fieldName).suspendEvents(false);
		 form.findField(fieldName).setValue(value);
		 form.findField(fieldName).resumeEvents();
	},
	changeEr_mode: function (combo) {
		var favorite_id = appConstants.dafaultJSON["hiddenFields"]["favorite_id"];
		var from_schModify = appConstants.dafaultJSON["hiddenFields"]["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		this.showGraph();
	 },
	filterMultiselect: function (obj) {
		 var compId = obj.getId();
		if(compId=='compSearch')
		 {
			compName='er_component';
			compStore=appConstants.rawDataForComponents;
		}
		else if(compId=='descSearch')
		 {
			compName='er_info_list';
			compStore=appConstants.rawDataForDescription;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
			);
			this.disableTools();
	  },
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	  //  Ext.getCmp("upbutton").setDisabled(true);

	},
	enableTools : function(){
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
	 //   Ext.getCmp("upbutton").setDisabled(false);

	},
	closePanel : function() {
		Ext.getCmp('popup').hide();

		if (Ext.get('linkId')) {
			Ext.get('linkId').show();
		}
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(false);
	},
	closeModifyPanel:function(){
		Ext.getCmp('modifypopup').hide();
	},
	loadpageTitle : function() {
		this.getMain().loadFields();
	//	if(er_selection!="null")
	  //   {
			var gridObj = Ext.getCmp('configdatas');
			//Ext.getCmp('dockitem').show();
		   // this.submitData();
		// }
	},
	defineConfigurationPOPUP : function(panel) {
		
		if (Ext.get('linkId')) {
			Ext.get('linkId').hide();
		}
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(true);
		var selectionDetails=Ext.getCmp("selectionDetails");
		if (!Ext.isEmpty(selectionDetails) && !selectionDetails.isHidden()) {
			this.toggleForm(selectionDetails);
		}
		Ext.getCmp('popup').show();
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showGraph();
		}
	},
	validateAndCloseSettings : function()
	{
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	showConfigDropdown : function() {
		
		isSettingsEnabled=true;
		var tpl =  new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container', {
					width : 565,
					//padding : 5,
					id : 'configMod',
					//cls : 'configMode_popup',
					ui:'settingsWindowContainer',
					//html : tpl.apply(),
					items : [
						{
							xtype:'container',
							cls:'configMode_popupArrow',
							style:{'top':'-14px','left':'380px'}
						},
						{
							xtype:'container',
							html:tpl.apply(),
							cls:'containerHeader',
							style:{'top':'0px','margin':'0px'}
						},
						{
							xtype:'capacitypredictionreportssettings',
							parent:this
						}],
					renderTo : 'capacitypredictionreports-body',
					listeners : {
						render : function() {
							Ext.get('closeSettings').on('click', function() {
										//Ext.get('configMod').slideOut();
											if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
											{
												return false;
											}
											Ext.getCmp('submit').setDisabled(false);
											Ext.get('configMod').animate({duration: 500,to: {y: -500}});
									});
						}
					}
				});
	},
	showGraphPOPUP:function(){
		Ext.widget('detailtimeline').show();
	},
	renderPopUp : function(popupPanle) {
		var isFirstLoad = popupPanle.isFirstLoad;
		if(!isFirstLoad)
		{
			popupPanle.loadScreenLabels(appConstants.dafaultJSON['screenlabels']);
			popupPanle.loadReportForCombo(appConstants.dafaultJSON);
			popupPanle.loadEvents();
			isFirstLoad=true;   
		}
	   
		Ext.EventManager.onWindowResize(function() {
					popupPanle.doComponentLayout();
					popupPanle.setWidth(Ext.getBody().getViewSize().width - 80);
		});

	},
	addToGrid : function() {
		// this code is for demo please remove in development
		var formObj = Ext.getCmp('popup').getForm();
		var gridObj = Ext.getCmp('configdatas');
		var tmpStore = gridObj.getStore();
		
		
		var compName = Ext.getCmp('er_component').getValue();
	//		if(compName.length>1)
	//			Ext.getCmp('er_info_list').setValue("-1");
	   
		var desc = Ext.getCmp('er_info_list').getValue();
		desc = encodeURIComponent(Ext.widget("erutils").specialCharEncode(desc));
		var test = Ext.getCmp('er_test').getValue();
		var testname = Ext.getCmp('er_test').getRawValue();
		var type = Ext.getCmp('er_comptype').getRawValue();
		var measures = Ext.getCmp('er_measure').getValue();
		var measurename = Ext.getCmp('er_measure').getRawValue();
		var type_val = Ext.getCmp('er_comptype').getValue();
		
		var er_option = formObj.findField('er_option').getValue();
		var siteVal = "";
		var includezone = "";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}


		// server side grid loading start
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var params='ReportName=prediction';
		params+='&er_option='+er_option;
		
		if(er_option == "Zone")
		{
			var zoneName = Ext.getCmp('Zone').getValue();
			params+='&Zone='+zoneName;
			includezone = Ext.getCmp('er_dataZone').getValue();
			params+='&includeZone='+includezone;
		}
		if(er_option == "Segment")
		{
			var segmentName = Ext.getCmp('Segment').getValue();
			params+='&Segment='+segmentName;
		}
		if(er_option == "Service")
		{
			var serviceName = Ext.getCmp('Service').getValue();
			params+='&Service='+serviceName;
		}

		params+='&desc='+desc;
		params+='&test='+test;
		params+='&testname='+appConstants.erUtils.specialCharEncode(Ext.String.htmlEncode(testname));
		params+='&type='+type;
		params+='&measures='+measures;
		params+='&measurename='+appConstants.erUtils.specialCharEncode(measurename);
		params+='&type_val='+type_val;
		params+='&componentVal='+compName;
		if(tmpStore.getCount()>0)
		{
			var gridStoreAry = new Array();
			for ( var k = 0; k < tmpStore.getCount(); k++ )
			{
				var tempObj =tmpStore.getAt(k).data;
				var gridsArr = new Object();
				gridsArr.Name = tempObj['Name'];
				gridsArr.Hiddens = appConstants.erUtils.specialCharEncode(tempObj['Hiddens']);
				gridsArr.Type = tempObj['Type'];
				gridsArr.Test = appConstants.erUtils.specialCharEncode(tempObj['Test']);
				gridsArr.Measure = tempObj['Measure'];
				gridsArr.Descriptor = appConstants.erUtils.specialCharEncode(tempObj['Descriptor']);
				gridsArr.Name_value = tempObj['Name_value'];
				gridsArr.Type_value = tempObj['Type_value'];
				gridsArr.Test_value = tempObj['Test_value'];
				gridsArr.Measure_value = tempObj['Measure_value'];
				gridsArr.Descriptor_value = appConstants.erUtils.specialCharEncode(tempObj['Descriptor_value']);
				gridStoreAry.push(gridsArr);
			}
			params+='&gridStore='+Ext.encode(gridStoreAry);
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: params,
			async: false,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var gridData = jsonData['gridData'];
				var status = jsonData['status'];
				var errorMsg = jsonData['errorMsg'];
				if (!Ext.isEmpty( jsonData ))
				{
					if(status=='success')
					{
						tmpStore.removeAll();
						tmpStore.loadRawData(gridData);
						if(appConstants.isSubmit=="null" )
						{
							gridObj.getSelectionModel().selectAll();
						}
					  	if (tmpStore.getCount() >= 4) 
						{
							Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
						}
						if (tmpStore.getCount() == 3)
						{ 
							Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
						}
						gridObj.doLayout();
						Ext.getCmp("scheduleTool").setDisabled(false);
						Ext.getCmp("favoriteTool").setDisabled(false);
						Ext.getCmp('timelineForm').show();
						if( Ext.getCmp('showLegend') != undefined)
						{
							if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
								  Ext.getCmp('showLegend').setValue(true);
						}
					}
				   else
				   {
						Ext.Msg.show({
							title : 'Alert',
							msg : errorMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return;
					}
			   }
			}
		});
		// server side grid loading end
		/*
		if(er_option!=null)
		{
			if(er_option == "Zone")
			{
				siteVal = Ext.getCmp('Zone').getValue();
				includezone = Ext.getCmp('er_dataZone').getValue();
			}
			else if(er_option == "Segment")
				siteVal = Ext.getCmp('Segment').getValue();
			else if (er_option == "Service")
				siteVal = Ext.getCmp('Service').getValue();
		}
		if(test == '-1' || measures == '-1' || type == 'Please choose a Component Type')
		   {
				
				   Ext.Msg.show({
					title : 'Alert',
					msg : 'No selection to add',
					buttons : Ext.Msg.OK,
					icon : Ext.Msg.WARNING
						 });
					return;
		   }
		var compArray = [];
	  
		var descArray = [];
	   for (var tr in compName) {
		  compArray.push(compName[tr]);
	   }
	   for (var tr in desc) {
		   if(desc[tr] == '-1')
		   {
			descArray.push('-');
			break;
		   }
		   else
		   {
				descArray.push(desc[tr]);
		   }
	   }
	   var noOfrecords = tmpStore.getCount();
		
	   var group = "";
	   var flag = 0;
	   var selectionModelObj = gridObj.getSelectionModel();   
	   
	   for (var kk = 0; kk < noOfrecords; kk++) {

			var rec1 = tmpStore.getAt(kk);
			var compname = rec1.get('Name');
			var Type = rec1.get('Type');
			var Type_value = rec1.get('Type_value');
			var Test = rec1.get('Test');
			var Measure = rec1.get('Measure');
			var Descriptor = rec1.get('Descriptor');
			
			group = compname+"|" + Type+ "|" + Test + "|" + Measure;
			var selection= compname+"|" + Type+ "|" + Test + "|" + Measure+"|"+Descriptor;
			var selgroup=  Type+ "|" + Test + "|" + Measure;
		
			for (var tr in compName) {
				var compvalue=compName[tr];
				if(compvalue.indexOf(":")>-1)
					compvalue=compvalue.substring(0,compvalue.indexOf(":"));
				
				for(var k in descArray)
				{
					var descValue=descArray[k];
					
					var currentSelection= compvalue+"|" + type+ "|" + testname +"|" + measurename+"|"+descValue;
					var currentgroup= compvalue+"|" + type+ "|" + testname +"|" + measurename;
					var sel_curgroup= type+ "|" + testname +"|" + measurename;
					
					if(currentSelection==selection)
					{
						Ext.Msg.show({
							title : 'Alert',
							msg : 'Your current selection has already been added',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						 });
						return;
					}
					if(group==currentgroup && (descValue=="-"))
					{
						Ext.Msg.show({
							title : 'Alert',
							msg : 'Some Individual Descriptor selections added for this component.So All Descriptor selection is not allowed',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
						return;
					}
					
					if(group==currentgroup && (Descriptor=="-"))
					{
						Ext.Msg.show({
							title : 'Alert',
							msg : 'All Descriptor selection has already been added,Individual selection is not allowed',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
						return;
					}
					if(selgroup==sel_curgroup && compvalue=="All Components" && group!=currentgroup)
					{
						Ext.Msg.show({
							title : 'Alert',
							msg : 'Your current selection has already been added',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						 });
							return;
					}
				}
			}
		}
	   for(var i in compArray)
	   {
			
			var comp = compArray[i];
			var org_comp = comp;
			if(comp !="All Components")
				comp = comp.substring(0,comp.indexOf(":"));

			var  co="All Components";
			if(org_comp.lastIndexOf(":") != -1)
				co = org_comp.substring(0,org_comp.lastIndexOf(":"));
			var  all_type="All Component Types";
			if(org_comp.indexOf(":") != -1)
				all_type = org_comp.substring(org_comp.lastIndexOf(":")+1,org_comp.length);
			if(org_comp.indexOf("#$#") != -1)
				all_type = org_comp.substring(org_comp.lastIndexOf("#$#")+3);
			var  mapco=co+":"+all_type;

			if(compName == "All Components"){// for adding all component section
			var datafrom = appConstants.dataFrom;
			var selectionString = "";
			var combdisp = "";
			if(datafrom == "Component"){
				selectionString = "ComponentType#$#" + type_val;
			} else if(datafrom == "Segment"){
				selectionString = "Segment#$#" + siteVal +"#$#componentType#$#"+type_val;
			}else if(datafrom == "Service"){
				selectionString = "Service#$#" + siteVal+"#$#componentType#$#"+type_val;
			}else if(datafrom == "Zone"){
				selectionString = "Zone#$#" + siteVal+"#$#includeSubzone#$#"+includezone +"#$#componentType#$#"+type_val;
			}
			//var genHiddens = mapco+"||"+test+"|"+measures+"|"+desc;
			var genHiddens = selectionString+"| |"+test+"|"+measures+"|"+desc;
			for(var k in descArray)
			{
				var desc = descArray[k];
				if(desc=='-1')
					  desc='-';
				  
					tmpStore.add([{
					'Name' :comp,
					'Name_value':selectionString,
					'Type' : type,
					'Test' : testname,
					'Measure' : measurename,
					'Descriptor' : desc,
					'Test_value':test,
					'Descriptor_value':desc,
					'Measure_value':measures,
					'Type_value':type_val,
					'Hiddens':genHiddens
					}]);
			}
			}
			else
			{
				var selectionString = "";
				if(er_option!=null && (er_option == "Zone"|| er_option == "Segment" || er_option == "Service"))
					selectionString = siteVal + "||";
				selectionString += org_comp;
				
				 for(var k in descArray)
				{
					var desc = descArray[k];
					var genHiddens = selectionString+"| |"+test+"|"+measures+"|"+desc;
					if(desc=='-')
					{
						tmpStore.add([{
									'Name' :comp,
									'Name_value':org_comp,
									'Type' : type,
									'Test' : testname,
									'Measure' : measurename,
									'Descriptor' : desc,
									'Test_value':test,
									'Measure_value':measures,
									'Type_value':type_val,
									'Descriptor_value':desc,
									'Hiddens':genHiddens
									}]);
						break;
					}
					else
					{
							tmpStore.add([{
									'Name' :comp,
									'Name_value':selectionString,
									'Type' : type,
									'Test' : testname,
									'Measure' : measurename,
									'Descriptor' : desc,
									'Test_value':test,
									'Measure_value':measures,
									'Type_value':type_val,
									'Descriptor_value':desc,
									'Hiddens':genHiddens
									}]);
					}
				}
			}
	   }
	   if(appConstants.isSubmit=="null" )
	   {
		 gridObj.getSelectionModel().selectAll(tmpStore);
	   }
	   if (tmpStore.getCount() >= 4) {
		   // Ext.getCmp('dockitem').show();
			Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
		}
		if (tmpStore.getCount() == 3){ 
			Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
		}
		
	   // Ext.getCmp('dockitem').show();
		
		gridObj.doLayout();
	Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp('timelineForm').show();
		if( Ext.getCmp('showLegend') != undefined){
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
				  Ext.getCmp('showLegend').setValue(true);
		}
		*/
	},
		//omit repeated selection item IN er_selection
	findList : function (lst,entry)
	{
		for(var i=0;i<lst.length;i++)
		{
			if(lst[i] == entry)  {
				return true;
			}
		}
		return false;
	},
	modifyGrid : function(record){
		var grid = Ext.getCmp('configdatas');
		var store = grid.getStore();
		var count=store.getCount();

		var oldMeasureValue =appConstants.rec.get('Measure_value');
		var oldDescriptorValue =appConstants.rec.get('Descriptor_value');
		var newMeasureValue = Ext.getCmp('modifymeasure').getValue();
		var newMeasureRawValue = Ext.getCmp('modifymeasure').getRawValue();
			var newDescArray = Ext.getCmp('itemselector-field').getValue();
		
		var oldMeasureBasedRecordsArray=new Array();
		var oldMeasureBasedRecordsMap = new Ext.util.HashMap();//contains unique values
		store.each(function(record){
			if (oldMeasureValue==record.get("Measure_value"))
			{
				oldMeasureBasedRecordsArray.push(record);
				oldMeasureBasedRecordsMap.add(record.get("Name"),record);
			}
		}, this);

		if (newDescArray=='-1')
		{
			if (oldMeasureBasedRecordsArray.length>0)
			{
				if (oldMeasureBasedRecordsArray.length==1)
				{
					var record=oldMeasureBasedRecordsArray[0];
					record.set("Measure",newMeasureRawValue);
					record.set("Measure_value",newMeasureValue);
					record.set("Descriptor",'-');
					record.set("Descriptor_value",'-');
					record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|-');
					record.commit();
					
				}
				else
				{
					if (oldMeasureValue==newMeasureValue)
					{
						for (var key in oldMeasureBasedRecordsArray)
						{
							var record =oldMeasureBasedRecordsArray[key];
							if (record.get('Descriptor_value')==oldDescriptorValue)
							{
								record.set("Descriptor",'-');
								record.set("Descriptor_value",'-');
								record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|-');
								record.commit();
							}
							else
							{
								store.remove(record); 
							}
						} 
					}
					else
					{
						var record=appConstants.rec;
						record.set("Measure",newMeasureRawValue);
						record.set("Measure_value",newMeasureValue);
						record.set("Descriptor",'-');
						record.set("Descriptor_value",'-');
						record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|-');
						record.commit();
					}
				}
			}
		}
		else
		{
			if (oldMeasureBasedRecordsArray.length>0)
			{
				var tempDescValue = newDescArray;
				if(tempDescValue!=null && tempDescValue == "-1")
				{
					tempDescValue = "-";
				}
				if (oldMeasureBasedRecordsArray.length==1)
				{
					var record=oldMeasureBasedRecordsArray[0];
					if (newDescArray.length==1)
					{
						record.set("Measure",newMeasureRawValue);
						record.set("Measure_value",newMeasureValue);
						record.set("Descriptor",tempDescValue);
						record.set("Descriptor_value",newDescArray);
						record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|'+newDescArray);
						record.commit();
					}
					else
					{
						var index = store.indexOf(record);
						for (var key in newDescArray)
						{
							var newDescValue=newDescArray[key];
							var tempDescValue = newDescValue;
							if(newDescValue == "-1")
								tempDescValue = "-";
							if (key==0)
							{
								record.set("Measure",newMeasureRawValue);
								record.set("Measure_value",newMeasureValue);
								record.set("Descriptor",tempDescValue);
								record.set("Descriptor_value",newDescValue);
								record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|'+newDescValue);
								record.commit();
							}
							else
							{
								record = {
									Descriptor: tempDescValue,
									Descriptor_value: newDescValue,
									Hiddens:appConstants.rec.get('Type_value')+'| |'+appConstants.rec.get('Test_value')+''+newMeasureValue+'|'+newDescValue,
									Measure: newMeasureRawValue,
									Measure_value: newMeasureValue,
									Name: appConstants.rec.get('Name'),
									Name_value: appConstants.rec.get('Name_value'),
									Test: appConstants.rec.get('Test'),
									Test_value: appConstants.rec.get('Test_value'),
									Type: appConstants.rec.get('Type'),
									Type_value: appConstants.rec.get('Type_value')
								}; 
									
								index++;
								store.insert(index,record);
							}
						}
					}
					
				}
				else
				{
					if (newDescArray.length==1)
					{
						var flag=false;
						for (var key in oldMeasureBasedRecordsArray)
						{
							var oldRecord=oldMeasureBasedRecordsArray[key];
							if (oldRecord.get("Name_value")==appConstants.rec.get('Name_value') && oldRecord.get("Measure_value")==newMeasureValue && oldRecord.get("Descriptor_value")==newDescArray)
							{
								Ext.MessageBox.show({
									title: 'Capacity Predition Reports',
									msg: 'Config is already exist',
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								});
								flag=true;
							}
						}
						if (!flag)
						{
							var record=appConstants.rec;
							record.set("Measure",newMeasureRawValue);
							record.set("Measure_value",newMeasureValue);
							record.set("Descriptor",tempDescValue);
							record.set("Descriptor_value",newDescArray);
							record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|'+newDescArray);
							record.commit();
						}
					}
					else
					{
						if (oldMeasureValue==newMeasureValue)
						{
							var index = store.indexOf(appConstants.rec);
							//store.remove(appConstants.rec);
							for (var key in newDescArray)
							{
								var newDescValue=newDescArray[key];
								var tempDescVal = newDescValue;
								if(tempDescVal!=null && tempDescVal == "-1")
								{
									tempDescVal = "-";
								}
								
								var flag=false;
								var oldRecord;
								for (var key in oldMeasureBasedRecordsArray)
								{
									oldRecord=oldMeasureBasedRecordsArray[key];
									if (oldRecord.get("Name_value")==appConstants.rec.get('Name_value') && oldRecord.get("Descriptor_value")==newDescValue)
									{
										/*Ext.MessageBox.show({
											title: 'Capacity Predition Reports',
											msg: 'Config is already exist',
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});*/
										flag=true;
										break;
									}
								}
								
								 if (!flag)
								 {
									var record = {
										Descriptor: tempDescVal,
										Descriptor_value: newDescValue,
										Hiddens:appConstants.rec.get('Type_value')+'| |'+appConstants.rec.get('Test_value')+''+newMeasureValue+'|'+newDescValue,
										Measure: newMeasureRawValue,
										Measure_value: newMeasureValue,
										Name: appConstants.rec.get('Name'),
										Name_value: appConstants.rec.get('Name_value'),
										Test: appConstants.rec.get('Test'),
										Test_value: appConstants.rec.get('Test_value'),
										Type: appConstants.rec.get('Type'),
										Type_value: appConstants.rec.get('Type_value')
									}; 
										
									index++; 
									store.insert(index,record);
									
								}
								else
								{
									//var record=appConstants.rec;
									oldRecord.set("Descriptor",tempDescVal);
									oldRecord.set("Descriptor_value",newDescValue);
									oldRecord.set("Hiddens",oldRecord.get('Type_value')+'| |'+oldRecord.get('Test_value')+''+newMeasureValue+'|'+newDescValue);
									oldRecord.commit(); 
								}
							}	
						}
						else
						{
							var record=appConstants.rec;
							var index = store.indexOf(record);
							for (var key in newDescArray)
							{
								var newDescValue=newDescArray[key];
								var tempDescVal = newDescValue;
								if(tempDescVal!=null && tempDescVal == "-1")
								{
									tempDescVal = "-";
								}
								if (key==0)
								{
									record.set("Measure",newMeasureRawValue);
									record.set("Measure_value",newMeasureValue);
									record.set("Descriptor",tempDescVal);
									record.set("Descriptor_value",newDescValue);
									record.set("Hiddens",record.get('Type_value')+'| |'+record.get('Test_value')+''+newMeasureValue+'|'+newDescValue);
									record.commit();
								}
								else 
								{
									record = {
										Descriptor: tempDescVal,
										Descriptor_value: newDescValue,
										Hiddens:appConstants.rec.get('Type_value')+'| |'+appConstants.rec.get('Test_value')+''+newMeasureValue+'|'+newDescValue,
										Measure: newMeasureRawValue,
										Measure_value: newMeasureValue,
										Name: appConstants.rec.get('Name'),
										Name_value: appConstants.rec.get('Name_value'),
										Test: appConstants.rec.get('Test'),
										Test_value: appConstants.rec.get('Test_value'),
										Type: appConstants.rec.get('Type'),
										Type_value: appConstants.rec.get('Type_value')
									}; 
									index++;
									store.insert(index,record);
								}
							}
							
						}
					}
					
				}
			}
		}
		//Ext.Array.indexOf(selectedItems, record.get("valueField")) !== -1;
		//var oldMeasureBasedRecordsArray = store.findRecord('Measure_value', newMeasureValue);
	},
	modifyGridOld : function(){
		
		
		var grid = Ext.getCmp('configdatas');
		var configDatasGrid = grid.getStore();
		var s = grid.getSelectionModel().getSelection();
		
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = grid.getSelectionModel();
		var s_measures = [];
		var s_desc = [];
		
		var test;
		var type;
		var name;
		var name_value;
		var displaycomptype;
		var displayTest;
		var measure;
		var Descriptor;
		var recordToDelete;
		/*//for (var i = 0; i < noOfrecords; i++) 
		{

			//var rec = configDatasGrid.getAt(i);
			var rec = appConstants.rec;
			//if(selectionModelObj.isSelected(rec))
			{
				name_value = rec.get('Name_value');
				type = rec.get('Type_value');
				test = rec.get('Test_value');
				name = rec.get('Name');
				displayTest = rec.get('Test');
				displaycomptype = rec.get('Type');
				Descriptor = rec.get('Descriptor');
			
			}
		}*/
	   var modifyMeasure = Ext.getCmp('modifymeasure').getValue();
	   var descValue = Ext.getCmp('itemselector-field').getValue();
	   var selectedMeas = [];
	   var descArr = [];
	   for (var tr in modifyMeasure) {

		  selectedMeas.push(modifyMeasure[tr]);
	   }
	   for (var tr in descValue) {

		  descArr.push(descValue[tr]);
	   }

	   for(var d in descArr)
	   {
		   var desc = descArr[d];
		   if(desc=='-1' && descArr.length>1)
		   {
					Ext.Msg.show({
						title : 'Alert',
						msg : 'Please remove All descriptors',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
							 });
					return;
		   }
	   }
	   Ext.getCmp('er_info_list').setValue(descArr);

	   var measuredisplayArray = [];
	   var measureArray = [];
	   for(var ms in selectedMeas)
	   {
			var selecmeas = selectedMeas[ms];
			
			Ext.getCmp('modifymeasure').getStore().data.each(function(item, index, totalItems ) {
				
				if(selecmeas==item.data ['valueField'])
				{
					
					measuredisplayArray.push(item.data ['displayField']);
					measureArray.push(item.data ['valueField']);
				}
			});
	   }
	  /* for(var rem in s)
	   {
		
		   configDatasGrid.remove(s[rem]);
	   }
	   */
	   var deletearr=new Array();
	   var addarr=new Array();
	   var duplicatesArr=new Array();
		 var oldgrp,currgrp;
	   var removeFlag=false;
	   for(var j in selectedMeas)
	   {
			var meas = measuredisplayArray[j];
			var measval = measureArray[j];
			
			for(var k in descArr)
			{
				var desc = descArr[k];
				if(desc=='-1')
					  desc='-';
				  if (true)
					{
						  var noOfrecords = configDatasGrid.getCount();
						  
						  for (var i = 0; i < noOfrecords; i++) 
							{
								
								recordToDelete = configDatasGrid.getAt(i);
								//var rec = appConstants.rec;
								
								name_value = recordToDelete.get('Name_value');
								type = recordToDelete.get('Type_value');
								test = recordToDelete.get('Test_value');
								name = recordToDelete.get('Name');
								measure = recordToDelete.get('Measure');
								displayTest = recordToDelete.get('Test');
								displaycomptype = recordToDelete.get('Type');
								Descriptor = recordToDelete.get('Descriptor');
								
								 oldgrp=name+"|"+displaycomptype+"|"+displayTest+"|"+measure;//+"|"+Descriptor;
								 currgrp=appConstants.jsonObject.compname+"|"+appConstants.jsonObject.comptype+"|"+appConstants.jsonObject.test+"|"+meas;//+"|"+desc;
								
								 if(currgrp==oldgrp)
								 {
									
									if(Descriptor=='-' && desc!='-')
									{
										deletearr.push(recordToDelete);
										removeFlag=true;
									}
									else if(Descriptor!='-' && desc=='-')
									{
										deletearr.push(recordToDelete);
										removeFlag=true;
									}
									else if(Descriptor==desc)
									{
										//removeFlag=false;
									}
									else if(Descriptor!=desc)
									{
										removeFlag=true;
										duplicatesArr.push(currgrp+"|"+desc);
									}
									//if (removeFlag)
									//break;
								 }
							}
							
							//configDatasGrid.remove(deletearr);
							if (removeFlag)
							{
								addarr.push({
									'Name' :name,
									'Name_value':name_value,
									'Type' : displaycomptype,
									'Test' : displayTest,
									'Measure' : meas,
									'Descriptor' : desc,
									'Test_value':test,
									'Measure_value':measval,
									'Descriptor_value':desc,
									'Type_value':type
								});
								removeFlag=false;
							}
						 
					}                    
			}
		}
		configDatasGrid.remove(deletearr);
		configDatasGrid.add(addarr);
		
		
		//below block is for removing duplicates with with descriptor entries
		noOfrecords = configDatasGrid.getCount();
		var count=0;

		deletearr=new Array();
		 for (var k in duplicatesArr)
		 {
			 currgrp=duplicatesArr[k];
			 count=0;
			 for (var i = 0; i < noOfrecords; i++) 
			 {
				recordToDelete = configDatasGrid.getAt(i);
				name_value = recordToDelete.get('Name_value');
				type = recordToDelete.get('Type_value');
				test = recordToDelete.get('Test_value');
				name = recordToDelete.get('Name');
				measure = recordToDelete.get('Measure');
				displayTest = recordToDelete.get('Test');
				displaycomptype = recordToDelete.get('Type');
				Descriptor = recordToDelete.get('Descriptor');
				
				oldgrp=name+"|"+displaycomptype+"|"+displayTest+"|"+measure+"|"+Descriptor;
				 if (currgrp==oldgrp)
				 {
					 count++;
					 if(count>1)
					 deletearr.push(recordToDelete);
				 }
			 }
		 }
		configDatasGrid.remove(deletearr);
		grid.getSelectionModel().selectAll(configDatasGrid);
		if (configDatasGrid.getCount() >= 4) {
		   // Ext.getCmp('dockitem').show();
			Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
		}
		if (configDatasGrid.getCount() === 3){ 
			Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
		}
		grid.doLayout();
	},
	showGraph : function()
	{
		var thisForm=this.getDefineconfiguration().getForm();
	   
		var startdate = thisForm.findField('er_stdate').dataArray;
		var starthr = thisForm.findField('er_sthr').dataArray;
		var enddate = thisForm.findField('er_enddate').dataArray;
		var endhr = thisForm.findField('er_endhr').dataArray;
		var er_mode = thisForm.findField('er_mode').getValue();
		var er_look_forward = thisForm.findField('er_look_forward').getValue();
	   
		var er_timeline = thisForm.findField('er_timeline').getValue();
	  
		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		
		 var er_dataoption,er_trendoption,er_reportgenration;
		if (isSettingsEnabled)
		{
			 var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			 er_dataoption = otherFiltersForm.findField('er_dataoption').getValue();
			 er_trendoption = otherFiltersForm.findField('er_trendoption').getValue();
			 er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		else
		{
			 er_dataoption =appConstants.dafaultJSON.timeline.predictusingCombo;
			 er_trendoption =appConstants.dafaultJSON.timeline.trenddatacombo_value; 
			 er_reportgenration =appConstants.dafaultJSON.timeline.reportgenCombo;
		}

		var stDate_Time = Ext.getCmp('er_stdate').getValue();
		var tmpStart_Hour = Ext.getCmp('er_sthr').getValue();
		stDate_Time.setHours(tmpStart_Hour);
		var enDate_Time = Ext.getCmp('er_enddate').getValue();
		var tmpEnd_Hour = Ext.getCmp('er_endhr').getValue();
		enDate_Time.setHours(tmpEnd_Hour);
		var result = checkDateTime(stDate_Time, enDate_Time);
		
		if(!result) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		var configDatas = Ext.getCmp("configdatas");
		var selectionModelObj = configDatas.getSelectionModel();
		   if(selectionModelObj.getCount()==0)
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Choose your selection to view the report',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
			   });
			return;
		}
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		
		var param='';
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
		}
		param +='&er_option='+er_option;
		 
		if(er_option!=null)
		{
			if(er_option=='Component')
			{
				
			}
			else if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
				param+='&er_site='+er_site;
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
				param+='&er_site='+er_site;
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
				param+='&er_site='+er_site+'&er_dataZone='+er_dataZone;
			}
		}
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
		param+='&er_comptype='+er_comptype;
		var er_test = mainFilterForm.findField('er_test').getValue();
		
		param+='&er_test='+er_test+'&er_datafrom='+er_option+'&selectedTest='+er_test+'&er_trendoption='+er_trendoption;
		
		//var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();
		
		var configDatasGrid = configDatas.getStore();

		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var er_component = new Array();
		var infolist = [];
		var er_retainSelection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			if(selectionModelObj.isSelected(rec))
			{
				var name = rec.get('Name');
				var name_value = rec.get('Name_value');
				var Type = rec.get('Type_value');
				var Test = rec.get('Test_value');
				var Measure = rec.get('Measure_value');
				var Descriptor = rec.get('Descriptor');
				
				//group = name +":"+Type+ "| |" +  Test + "|"
					  //  + Measure +"|"+Descriptor;
				group = name_value +"| |" +  Test + "|"
						+ Measure +"|"+Descriptor;
						
				/*if(er_info_list=='-1' && mainFilterForm.findField('er_info_list').getStore().getCount()>1)
				{
					//er_selection = [];
					//infolist = [];
					mainFilterForm.findField('er_info_list').getStore().data.each(function(item, index, totalItems ) {
						
					   
						if(item.data ['valueField']!=-1)
						{
							
							er_selection.push(name_value +":"+Type+ "| |" +  Test + "|"
							+ Measure +"|"+item.data ['valueField']);
							infolist.push(item.data ['valueField']);
						}
						
					});
				}
				else
				{
					er_selection.push(group);
					infolist.push(Descriptor);
				}*/
				s_measures.push(Measure);
				infolist.push(Descriptor);
				er_selection.push(group);
				er_component.push(name_value);
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		for (var j = 0; j < er_selection.length; j++) {
			param += "&er_selection=" + appConstants.erUtils.specialCharEncode(er_selection[j]);
		}
		var fromMultiMeasure=false;
		
		for (var j = 0; j < s_measures.length; j++) {
			param += "&er_measure=" + s_measures[j];
		}
		
		for (var j = 0; j < er_component.length; j++) {
			param += "&er_component=" + er_component[j];
		}
		
		for (var j = 0; j < infolist.length; j++) {
			
			param += "&er_info_list=" + appConstants.erUtils.specialCharEncode(infolist[j]);
		}
		   
		 if (er_comptype == -1 || er_test==-1 || er_component==-1) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.componentalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		 param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr+'&startdate='+startdate+'&er_timeline=' + er_timeline+'&er_type=Yes&er_mode='+er_mode+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		
				
		 param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+'&schedule_id='+appConstants.schedule_id1+'&er_look_forward='+er_look_forward+'&er_combination='
		 
					+'&er_dataoption='+er_dataoption+'&er_excwe=Yes';
		 
		
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
	   
		var showLegend = Ext.getCmp('showLegend').getValue();
		 var selectbackground = er_reportgenration;
		if (bgenabled == 'Yes' || bgenabled == 'yes') {
				
				var bgtime = getTimeValues(limitforbg, msxdays,startdate, enddate,inidate);
				var getimeline = getTimeValues(er_timeline, msxdays,startdate, enddate,inidate);
			   
				var bgprocess = false;
				
				if (getimeline >bgtime && selectbackground == 'foreground') {
					
					 var confrimation = hiddenFields['confrimation'];
					 
					 if (confrimation != null && (confrimation =="TRUE" || confrimation.toLowerCase()=="yes" )) {
						
							bgprocess = true;
							var e_obj = Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn){
							   
								if(btn=="no")
								{
										Ext.get("configMod").animate({
											to: {
												"top": 45
											},
											listeners: {
												afteranimate: function () {
													Ext.get("configMod").setStyle("left", "");
												}
											}
										}).show();
									var bg_reportname=Ext.getCmp('bgReportName');
									Ext.getCmp('reportGeneration').setValue('background');
									bg_reportname.setValue("");
									bg_reportname.show();
									bg_reportname.focus(false, 1000);
									  if (validateTextBoxWithSpecialChars(bg_reportname.getValue(),'Attachment',true)) {                   
										var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
										if (timeVal) {
												var reportName = Ext.getCmp('bgReportName').getValue();
												 reportName=checkFileName(reportName);
												 param += '&bg_reportname='+reportName+'&er_reportgenration='+selectbackground+'&client=true';
												var url= '/final/servlet/com.eg.ErStartBackGroundReportC';
												this.submitReport(url,param,er_reportgenration,fromMultiMeasure,false);
										} 
									}
								   
								}
								else if(btn=="yes")
								{
									if (result) {
												var old_width = 0;
												var val = false;
												var timeVal = true;
												timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
												if (timeVal) {
													param += '&er_reportgenration='+selectbackground;
													var url= '../servlet/com.eg.ErCapacityPredictionReportC?isSubmit=true&showLegend='+showLegend;
													this.submitReport(url,param,er_reportgenration,fromMultiMeasure,false);
						
												} else
													return;
						
											} else {
												Ext.Msg.show({
															title : 'Alert',
															msg : appConstants.datealert,
															buttons : Ext.Msg.OK,
															icon : Ext.Msg.WARNING
														});
											}
								}
							},this);
							
					}
				}
				
				if (selectbackground == 'background' && bgprocess==false) {
					 
					var bg_reportname = Ext.getCmp('bgReportName').getValue();
					 if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
								 bg_reportname=checkFileName(bg_reportname);
					param += '&bg_reportname=' + bg_reportname+'&er_reportgenration='+selectbackground+'&client=true';
								var url= '/final/servlet/com.eg.ErStartBackGroundReportC?showLegend='+showLegend;
								this.submitReport(url,param,er_reportgenration,fromMultiMeasure,false);
						} else
							return;
					}
				} else if(!bgprocess){
				   
						var old_width = 0;
						var val = false;
						var timeVal = true;
						timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
						if (timeVal) {
							param += '&er_reportgenration='+selectbackground;
							var url= '../servlet/com.eg.ErCapacityPredictionReportC?isSubmit=true&showLegend='+showLegend;
							this.submitReport(url,param,er_reportgenration,fromMultiMeasure,false);
						} else
							return;
				}
			} else {
				
					var val = false;
					var timeVal = true;
					timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
					if (timeVal) {
						param += '&er_reportgenration='+selectbackground;
							var url=  '../servlet/com.eg.ErCapacityPredictionReportC?isSubmit=true&showLegend='+showLegend;
							this.submitReport(url,param,er_reportgenration,fromMultiMeasure,false);
					} else
						return;
			}
		
	},
	submitReport : function(url,param,er_reportgenration,fromMultiMeasure,navigate)
	{
		var myMask=null;
		myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading ...'});
		myMask.show();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var me =  this;
		param+= '&er_RmDispName='+appConstants.er_RmDispName
		Ext.Ajax.request({
			  url:url,
			  params:param,
			  scope:this,
			  async:false,
			  success : function(response){
				   var jsontext = response.responseText;
				   var jsonData = Ext.decode(jsontext);
				   myMask.hide();
				   me.enableTools();
				   if(!Ext.isEmpty(jsonData))
				   {
						if(er_reportgenration=='background')
						{
							 var grpahQueryString = jsonData.grpahQueryString;
							var status = grpahQueryString.status;

								if(status!=undefined && status =='success')
								{
									//htm = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>' + grpahQueryString.bgstr1
									//	+ '</b>.</br>' + '<a  class="backgroundMsgLink" href='
									//	+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2
									//	+ '</a> </div></div></center>';
								
									htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
								}
								else
								{
									htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
								}
								me.getBackGroundPanel().update(htm);
								me.getBackGroundPanel().show();
								Ext.getCmp('graphdisplay').hide();
								return;
						}
						else
						{                          
							Ext.getCmp('graphdisplay').show();
							me.getGraphpanel().loadGraph(jsonData);
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectiondetails);

						}
						Ext.getCmp("favoriteTool").setDisabled(false);
						Ext.getCmp("scheduleTool").setDisabled(false);
				  }
			  }
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = this.getDefineconfiguration();
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},	
	removeDatas : function(sm, selections) {
		var gridObj = Ext.getCmp('configdatas');
		if (selections.length >= 0) {
			Ext.getCmp('dockitem').hide();
		}

		gridObj.doLayout();

		if (gridObj.store.getCount() == 0) {
			Ext.getCmp('dockitem').hide();
		} else {
			Ext.getCmp('dockitem').show();
		}
	},
	expandSelectorComponent:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),'Component',btn);		
	},
	expandSelectorDescriptor:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_info_list'),'Descriptor',btn);		
	},    
	timeLineOnChange:function(combo) {
		
		var thisForm=this.getDefineconfiguration().getForm();
		var form = combo.up('form').getForm();
		if (combo.getValue() == 'Any') {
			thisForm.findField('er_enddate').setDisabled(false);
			thisForm.findField('er_endhr').setDisabled(false);
			thisForm.findField('er_sthr').setDisabled(false);
			thisForm.findField('er_stdate').setDisabled(false);
		} else {
			thisForm.findField('er_enddate').setDisabled(true);
			thisForm.findField('er_endhr').setDisabled(true);
			thisForm.findField('er_sthr').setDisabled(true);
			thisForm.findField('er_stdate').setDisabled(true);
			
			var timeline = thisForm.findField("er_timeline").getValue();
			var strtdt = thisForm.findField("er_stdate").getValue();
			var enddt = thisForm.findField("er_enddate").getValue();
			var strthour = thisForm.findField("er_sthr").getValue();
			var endhr = thisForm.findField("er_endhr").getValue();

			var strtdt = thisForm.findField("er_stdate").getValue();
			var enddt = thisForm.findField("er_enddate").getValue();
			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
								   
			var hiddenFields = appConstants.dafaultJSON.hiddenFields;        
			var msxdays = hiddenFields['getMaxDaysInMonth'];
			var inidate = hiddenFields['inidate'];
			var usertimeline = hiddenFields['er_usertimeline'];
			var er_reportgenration = form.findField('reportGeneration').getValue();
			var bgenabled = hiddenFields['bgenabled'];
				

			var no_params = "&P0=[" + timeline + "]&P1=["
							+ strtdt + "]&P2=[" + enddt
							+ "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=["
							+ mgrDateFormat + "]";

			var param = "F=getTime&C=id" + no_params;
			
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param,
						scope : this,
						method : 'POST',
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData)) {

								var timedata = jsonData.timeline;
								var startDate = "";
								var endDate = "";
								var starthr = "";
								var endhr = "";
								var startmin = "";
								var endmin = "";
								for (var ctr = 0; ctr < timedata.length; ctr = ctr+ 5) {
									startDate = timedata[0];
									endDate = timedata[1];
									starthr = timedata[2];
									endhr = timedata[3];

									startmin = timedata[4];
									endmin = timedata[5];

								}                
								
							   formated_sdate = Ext.Date.dateFormat(startDate, mgrDateFormat);
							   formated_edate = Ext.Date.dateFormat(endDate, mgrDateFormat);
							   
							   thisForm.findField("er_stdate")
											.setValue(startDate);
							   thisForm.findField("er_enddate")
											.setValue(endDate);   
							   thisForm.findField("er_sthr")
											.setValue(starthr);
							   thisForm.findField("er_endhr")
											.setValue(endhr);             
							}
						}
					});



			 if (bgenabled == 'Yes' || bgenabled == 'yes') {
			
					var limitforbg = hiddenFields['limitforbg'];
					
					var bgtime = getTimeValues(limitforbg, msxdays,strtdt, enddt,inidate);
					var getimeline = getTimeValues(timeline, msxdays,strtdt, enddt,inidate);
					var selectbackground = er_reportgenration;
					var bgprocess = false;
					
					if (getimeline >= bgtime && selectbackground == 'foreground') {
						
						 form.findField("bgReportName").show();
						 form.findField('reportGeneration').setValue('background');
					}
					else
					{
						form.findField("bgReportName").hide();
						 form.findField('reportGeneration').setValue('foreground');
					}
				}               
		}
		
	},
	reportGenChange : function(){
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	 },
	 predictUsingComboChange : function(thisObj){
		
		var form = thisObj.up('.form').getForm();
		var val = thisObj.getValue();
		var trendoption = form.findField('er_trendoption');
		if(val=='Measure')
		{
			trendoption.hide();
		}
		else
		{
			trendoption.show();
		}

	 }, 
	 sendMail:function(){
	var islegendEnabled = Ext.getCmp('showLegend').getValue();
	if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
		 drillDownParams = "&showLegend="+islegendEnabled;
	}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	 printFile : function(){
		 var thisForm=this.getDefineconfiguration().getForm();
		
		var otherFiltersForm = Ext.getCmp('configsettings').getForm();
		var startdate = thisForm.findField('er_stdate').dataArray;
		var starthr = thisForm.findField('er_sthr').dataArray;
		var enddate = thisForm.findField('er_enddate').dataArray;
		var endhr = thisForm.findField('er_endhr').dataArray;
		
		var er_timeline=thisForm.findField('er_timeline').getValue();
		
	   // startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
	   // enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		
		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");   
		
		
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		
		if(er_option!=null)
		{
			if(er_option=='Component')
			{
				
			}
			else if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
				
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
				
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
			}
		}
	 
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
	 
		var er_test = mainFilterForm.findField('er_test').getValue();
		
		var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();

		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
		var er_reportgenration = otherFiltersForm.findField('reportGeneration')
				.getValue();

	   var er_look_forward = thisForm.findField('er_look_forward').getValue();
	   var s_qryString="/final/reporter/ErCapacityPredictionReportPrint.jsp?er_comptype="+er_comptype+"&er_datafrom="+er_option+"&er_type=No&er_site="+er_site+"&startdate="+startdate+"&enddate="+enddate+"&timefrom="+hiddenFields['timefrom']+"&minfrom="+hiddenFields['minfrom']+"&timeto="+hiddenFields['timeto']+"&minto="+hiddenFields['minto']+"&starthr="+starthr+"&endhr="+endhr+"&er_timeline="+er_timeline+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+inidate+'&er_look_forward='+er_look_forward+"&pdfPrint=yes";

		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
	   parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		
	  /*  Ext.widget('print',{title:''}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
				src :s_qryString
			}); 
			
		 printWindow.on('show',function(){
	   // var s_qryString = "YOUR QUERY"  //query string to load the popup
		var printContentDiv = parent.Ext.select('#printContentDiv1');  // id of the popup window
					printContentDiv.set({
						src: s_qryString
					});
	});
		 printWindow.show();*/

	},
	saveFileTool : function(){
		var thisForm=this.getDefineconfiguration().getForm();
		
	   var otherFiltersForm = Ext.getCmp('configsettings').getForm();
		var startdate = thisForm.findField('er_stdate').dataArray;
		var starthr = thisForm.findField('er_sthr').dataArray;
		var enddate = thisForm.findField('er_enddate').dataArray;
		var endhr = thisForm.findField('er_endhr').dataArray;
		
		var er_timeline=thisForm.findField('er_timeline').getValue();
		
	   // startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
	   // enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		
		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");   
		
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		if(er_option!=null)
		{
			if(er_option=='Component')
			{
				
			}
			else if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
				
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
				
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
			  
			}
		}
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
	 
		var er_test = mainFilterForm.findField('er_test').getValue();
		var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();

		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();

		var param = "";
		var group = "";
		var er_selection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = configDatas.getSelectionModel();
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			if(selectionModelObj.isSelected(rec))
			{
				var name = rec.get('Name');
				var name_value = rec.get('Name_value');
				var Type = rec.get('Type_value');
				var Test = rec.get('Test_value');
				var Measure = rec.get('Measure_value');
				var Descriptor = rec.get('Descriptor');
				
				group = name_value+"| |" +  Test + "|"
						+ Measure +"|"+Descriptor;
				er_selection.push(rec.get("Hiddens"));
			}
		}
		for (var j = 0; j < er_selection.length; j++) {
			param += '&er_selection='+ encodeURIComponent(er_selection[j]);
		}
		
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
		var er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		var er_look_forward = thisForm.findField('er_look_forward').getValue();

	   var s_qryString="../reporter/ErHtmlToSavePdf.jsp?er_comptype="+er_comptype+"&er_datafrom="+er_option+"&er_type=Yes&er_site="+er_site+"&startdate="+startdate+"&enddate="+enddate+"&timefrom="+hiddenFields['timefrom']+"&minfrom="+hiddenFields['minfrom']+"&timeto="+hiddenFields['timeto']+"&minto="+hiddenFields['minto']+"&starthr="+starthr+"&endhr="+endhr+"&er_timeline="+er_timeline+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+inidate+'&er_look_forward='+er_look_forward+param+"&pdfPrint=yes";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}     
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var thisForm=this.getDefineconfiguration().getForm();
	   var otherFiltersForm = Ext.getCmp('configsettings').getForm();
		var startdate = thisForm.findField('er_stdate').dataArray;
		var starthr = thisForm.findField('er_sthr').dataArray;
		var enddate = thisForm.findField('er_enddate').dataArray;
		var endhr = thisForm.findField('er_endhr').dataArray;
		var er_timeline=thisForm.findField('er_timeline').getValue();
	   // startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
	   // enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");   
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		if(er_option!=null)
		{
			if(er_option=='Component')
			{
			}
			else if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
			}
		}
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
		var er_test = mainFilterForm.findField('er_test').getValue();
		var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();
		var param = "";
		var group = "";
		var er_selection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = configDatas.getSelectionModel();
		for (var i = 0; i < noOfrecords; i++) {
			var rec = configDatasGrid.getAt(i);
			if(selectionModelObj.isSelected(rec))
			{
				var name = rec.get('Name');
				var name_value = rec.get('Name_value');
				var Type = rec.get('Type_value');
				var Test = rec.get('Test_value');
				var Measure = rec.get('Measure_value');
				var Descriptor = rec.get('Descriptor');
				group = name_value+"| |" +  Test + "|"
						+ Measure +"|"+Descriptor;
				er_selection.push(rec.get("Hiddens"));
			}
		}
		for (var j = 0; j < er_selection.length; j++) {
			param += '&er_selection='+ encodeURIComponent(er_selection[j]);
		}
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
		var er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		var er_look_forward = thisForm.findField('er_look_forward').getValue();
	   var s_qryString="er_comptype="+er_comptype+"&er_datafrom="+er_option+"&er_type=Yes&er_site="+er_site+"&startdate="+startdate+"&enddate="+enddate+"&timefrom="+hiddenFields['timefrom']+"&minfrom="+hiddenFields['minfrom']+"&timeto="+hiddenFields['timeto']+"&minto="+hiddenFields['minto']+"&starthr="+starthr+"&endhr="+endhr+"&er_timeline="+er_timeline+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin+"&inidate="+inidate+'&er_look_forward='+er_look_forward+param+"&pdfPrint=yes";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var thisForm=this.getDefineconfiguration().getForm();
		var er_timeline = thisForm.findField('er_timeline').getValue();
		var startdate = thisForm.findField('er_stdate').getValue();
		var starthr = thisForm.findField('er_sthr').dataArray;
		var er_starthr = thisForm.findField('er_sthr').getValue();
		startdate.setHours(er_starthr);
		var enddate = thisForm.findField('er_enddate').getValue();
		var endhr = thisForm.findField('er_endhr').dataArray;
		var er_endhr = thisForm.findField('er_endhr').getValue();
		enddate.setHours(er_endhr);
		var er_mode = thisForm.findField('er_mode').getValue();
		var er_look_forward = thisForm.findField('er_look_forward').getValue();
		var er_dataoption,er_trendoption,er_reportgenration;
		if (isSettingsEnabled)
		{
			 var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			 er_dataoption = otherFiltersForm.findField('er_dataoption').getValue();
			 er_trendoption = otherFiltersForm.findField('er_trendoption').getValue();
			 er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		else
		{
			 er_dataoption =appConstants.dafaultJSON.timeline.predictusingCombo_value;
			 er_trendoption =appConstants.dafaultJSON.timeline.trenddatacombo_value; 
			 er_reportgenration =appConstants.dafaultJSON.timeline.reportgenCombo_value;
		}
		if(!checkDateTime(startdate, enddate)) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			bookletquery += hiddenField + "=" + val;
			bookletquery += "&";
			
		}
		bookletquery +='&er_option='+er_option;
		 
		if(er_option!=null)
		{
			if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
				bookletquery+='&er_site='+er_site;
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
				bookletquery+='&er_site='+er_site;
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
				bookletquery+='&er_site='+er_site+'&er_dataZone='+er_dataZone;
			}
		}
	 
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
		bookletquery+='&er_comptype='+er_comptype;
		var er_test = mainFilterForm.findField('er_test').getValue();
		
		bookletquery+='&er_test='+er_test+'&er_datafrom='+er_option+'&selectedTest='+er_test+'&er_trendoption='+er_trendoption;
		
		var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();
		
		
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();

		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var infolist = [];
		var er_retainSelection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = configDatas.getSelectionModel();
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			if(selectionModelObj.isSelected(rec))
			{
				var name = rec.get('Name');
				var name_value = rec.get('Name_value');
				var Type = rec.get('Type_value');
				var Test = rec.get('Test_value');
				var Measure = rec.get('Measure_value');
				var Descriptor = rec.get('Descriptor');
				
				infolist.push(Descriptor);
				group = name_value+"| |" +  Test + "|"
						+ Measure +"|"+Descriptor;
				er_selection.push(group);
				s_measures.push(Measure);
			}
		}
		for (var j = 0; j < er_selection.length; j++) {
			bookletquery += "&er_selection=" + appConstants.erUtils.specialCharEncode(er_selection[j]);
		}
		var fromMultiMeasure=false;
		
		for (var j = 0; j < s_measures.length; j++) {
			bookletquery += "&er_measure=" + s_measures[j];
		}
		
		for (var j = 0; j < er_component.length; j++) {
			bookletquery += "&er_component=" + er_component[j];
		}
		
		for (var j = 0; j < infolist.length; j++) {
			
			bookletquery += "&er_info_list=" + appConstants.erUtils.specialCharEncode(replaceAll(infolist[j],"#","0eghash0"));
		}
		if(selectionModelObj.getCount()==0)
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Choose your selection to view the report',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
			   });
			return;
		}
		
		 if (er_comptype == -1 || er_test==-1 || er_component==-1) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.componentalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		 bookletquery += "&starthr=" + starthr + "&enddate=" +  thisForm.findField('er_enddate').dataArray + "&endhr="
				+ endhr+'&startdate='+thisForm.findField('er_stdate').dataArray+'&er_timeline=' + er_timeline+'&er_type=Yes&er_mode='+er_mode;
		
				
		 bookletquery+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+'&schedule_id='+appConstants.schedule_id1+'&er_look_forward='+er_look_forward+'&er_combination='
		 
					+'&er_dataoption='+er_dataoption+'&er_excwe=Yes';
		 
		
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
		var getServers = '';
		var getCompTypes = '';
		var getTests = '';
		var getMeasures = '';
		var getDesc = '';
		var getHiddens = '';
		for ( var i = 0; i < configDatasGrid.getCount(); i++ )
		{
			getServers += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Name'));
			getCompTypes += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Type'));
			getTests += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Test'));
			getMeasures += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Measure'));
			getDesc += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Descriptor'));
			getHiddens += '|amp|'+appConstants.erUtils.specialCharEncode(configDatasGrid.getAt(i).get('Hiddens'));
		}
	   bookletquery+='&er_reportgenration='+er_reportgenration;
		var target = "";
		var fromFavoriteModify = appConstants.dafaultJSON['hiddenFields']["fromFavoriteModify"];
		bookletquery += '&servers='+getServers+'&comptypes='+getCompTypes
					 +'&tests='+getTests+'&measures='+getMeasures
					 +'&infos='+getDesc+'&hiddens='+getHiddens;

		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	add : function(button){
		 var thisForm=this.getDefineconfiguration().getForm();
	  
		var er_timeline = thisForm.findField('er_timeline').getValue();

		/* if(er_timeline == 'Any'){
				Ext.MessageBox.show({
				title: 'Capacity Predition Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			return;
		} */ 	
		var startdate = thisForm.findField('er_stdate').getValue();
		var starthr = thisForm.findField('er_sthr').dataArray;
		var er_starthr = thisForm.findField('er_sthr').getValue();
		startdate.setHours(er_starthr);
		var enddate = thisForm.findField('er_enddate').getValue();
		var endhr = thisForm.findField('er_endhr').dataArray;
		var er_endhr = thisForm.findField('er_endhr').getValue();
		enddate.setHours(er_endhr);
		var er_mode = thisForm.findField('er_mode').getValue();
		var er_look_forward = thisForm.findField('er_look_forward').getValue();
		var er_dataoption,er_trendoption,er_reportgenration;
		if (isSettingsEnabled)
		{
			 var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			 er_dataoption = otherFiltersForm.findField('er_dataoption').getValue();
			 er_trendoption = otherFiltersForm.findField('er_trendoption').getValue();
			 er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		else
		{
			 er_dataoption =appConstants.dafaultJSON.timeline.predictusingCombo_value;
			 er_trendoption =appConstants.dafaultJSON.timeline.trenddatacombo_value; 
			 er_reportgenration =appConstants.dafaultJSON.timeline.reportgenCombo_value;
		}
		if(!checkDateTime(startdate, enddate)) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		var mainFilterForm = Ext.getCmp('popup').getForm();
		var er_option = mainFilterForm.findField('er_option').getValue();
		
		var er_comptype='';
		var er_site='';
		var er_dataZone='';
		
		var param='';
		var hiddenFields = appConstants.dafaultJSON.hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
			
		}
		param +='er_option='+er_option;
		
		 
		if(er_option!=null)
		{
			if(er_option=='Service')
			{
				er_site = mainFilterForm.findField('Service').getValue();
				param+='&er_site='+er_site;
			}
			else if(er_option=='Segment')
			{
				er_site = mainFilterForm.findField('Segment').getValue();
				param+='&er_site='+er_site;
			}
			else if(er_option=='Zone')
			{
				er_site = mainFilterForm.findField('Zone').getValue();
				er_dataZone = mainFilterForm.findField('er_dataZone').getValue();
				param+='&er_site='+er_site+'&er_dataZone='+er_dataZone;
			}
		}
	 
		er_comptype = mainFilterForm.findField('er_comptype').getValue();
		param+='&er_comptype='+er_comptype;
		var er_test = mainFilterForm.findField('er_test').getValue();
		
		param+='&er_test='+er_test+'&er_datafrom='+er_option+'&selectedTest='+er_test+'&er_trendoption='+er_trendoption;
		
		var er_component = mainFilterForm.findField('er_component').getValue();
		var er_measure = mainFilterForm.findField('er_measure').getValue();
		var er_info_list = mainFilterForm.findField('er_info_list').getValue();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();

		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var infolist = [];
		var er_retainSelection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = configDatas.getSelectionModel();
		//var getHiddens = "";
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			if(selectionModelObj.isSelected(rec))
			{
				var name = rec.get('Name');
				var name_value = rec.get('Name_value');
				var Type = rec.get('Type_value');
				var Test = rec.get('Test_value');
				var Measure = rec.get('Measure_value');
				var Descriptor = rec.get('Descriptor');
				
				infolist.push(Descriptor);
				group = name_value+"| |" +  Test + "|"
						+ Measure +"|"+Descriptor;
				er_selection.push(group);
				s_measures.push(Measure);
			}
		}
		for (var j = 0; j < er_selection.length; j++) {
			param += "&er_selection=" + appConstants.erUtils.specialCharEncode(er_selection[j]);
		}
		var fromMultiMeasure=false;
		
		for (var j = 0; j < s_measures.length; j++) {
			param += "&er_measure=" + s_measures[j];
		}
		
		for (var j = 0; j < er_component.length; j++) {
			param += "&er_component=" + er_component[j];
		}
		
		for (var j = 0; j < infolist.length; j++) {
			
			//param += "&er_info_list=" + replaceAll(infolist[j],"#","0eghash0");
			param += "&er_info_list=" + appConstants.erUtils.specialCharEncode(infolist[j]);
		}
		if(selectionModelObj.getCount()==0)
		{
			Ext.Msg.show({
							title : 'Alert',
							msg : 'Choose your selection to view the report',
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
			   });
			return;
		}
		
		 if (er_comptype == -1 || er_test==-1 || er_component==-1) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.componentalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		 param += "&starthr=" + starthr + "&enddate=" +  thisForm.findField('er_enddate').dataArray + "&endhr="
				+ endhr+'&startdate='+thisForm.findField('er_stdate').dataArray+'&er_timeline=' + er_timeline+'&er_type=Yes&er_mode='+er_mode;
		
				
		 param+='&sessionID='+appConstants.sessionID+'&userID='+appConstants.userID+'&schedule_id='+appConstants.schedule_id1+'&er_look_forward='+er_look_forward+'&er_combination='
		 
					+'&er_dataoption='+er_dataoption+'&er_excwe=Yes';
		 
		
		var msxdays = hiddenFields['getMaxDaysInMonth'];
		var inidate = hiddenFields['inidate'];
		var usertimeline = hiddenFields['er_usertimeline'];
		var limitforbg = hiddenFields['limitforbg'];
		var bgenabled = hiddenFields['bgenabled'];
		var getServers = '';
		var getCompTypes = '';
		var getTests = '';
		var getMeasures = '';
		var getDesc = '';
		var getHiddens = '';
		for ( var i = 0; i < configDatasGrid.getCount(); i++ )
		{
			getServers += '|amp|'+configDatasGrid.getAt(i).get('Name');
			getCompTypes += '|amp|'+configDatasGrid.getAt(i).get('Type');
			getTests += '|amp|'+configDatasGrid.getAt(i).get('Test');
			getMeasures += '|amp|'+configDatasGrid.getAt(i).get('Measure');
			getDesc += '|amp|'+configDatasGrid.getAt(i).get('Descriptor');
			getHiddens += '|amp|'+configDatasGrid.getAt(i).get('Hiddens');
		}
	   param+='&er_reportgenration='+er_reportgenration;
		var target = "";
		var fromFavoriteModify = appConstants.dafaultJSON['hiddenFields']["fromFavoriteModify"];
		param += '&servers='+encodeURIComponent(getServers)+'&comptypes='+encodeURIComponent(getCompTypes)
					 +'&tests='+appConstants.erUtils.specialCharEncode(getTests)+'&measures='+encodeURIComponent(getMeasures)
					 +'&infos='+appConstants.erUtils.specialCharEncode(getDesc)+'&hiddens='+appConstants.erUtils.specialCharEncode(getHiddens);

		var windowClass;
		var frameId;
		if ((button.getId() == "scheduleImg" || button.getText() == "Save") && (fromFavoriteModify == null))
		{
			
			target = "/final/reporter/ErSaveSchedule.jsp?" + param+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.updateSelection =='true')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else{ //if (button.getId() == "favImg")
			var hiddenFields =  appConstants.dafaultJSON.hiddenFields;
			var favorite_id = hiddenFields["favorite_id"];
			
			if(Ext.isEmpty(favorite_id))
			{
				target = "../servlet/com.eg.ErFavoriteC?cmd=client&newFavorite=yes&"+ param+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
			}
			else
			{
				target = "../servlet/com.eg.ErFavoriteC?cmd=client"+"&"+ param;
				if (appConstants.updateSelection =='true')
				{
					//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
					target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
			}
		}
	}
	});
