Ext.define('CapacityPredictionReports.view.Configdatas', {
	requires : ['Ext.selection.CheckboxModel'],
	extend :'Ext.grid.Panel',
	alias : 'widget.configdatas',
	id : 'configdatas',
	margin : 10,
	//cls : 'gridSkin',
	ui:'newGridPanel',
	//enableColumnResize : false,
	//autoScroll : true,
	//scroll : true,
	enableColumnMove : false,
	enableColumnHide : false,
	sortableColumns : false,
	selModel : new Ext.selection.CheckboxModel({
				checkOnly : true,
				width : 50,
				injectCheckbox : 0
			}),
	height : 130,
	store : new Ext.data.Store({
		fields : ['Name', 'Type', 'Test', 'Measure', 'Descriptor',
				'Name_value', 'Type_value', 'Test_value',
				'Measure_value', 'Descriptor_value','Hiddens']
		}),
	viewConfig : {
		deferEmptyText : false,
		emptyText : '<div style="text-align:center;height:100px;display:flex;justify-content:center;align-items:center;"><div><b  style="cursor:pointer" id="linkId" ><div class="iconConfigUser" style="margin:0px auto" data-qtip="Please define configuration" data-qclass="yellowTip"></div>'+plsDefineConfigLabel+'</b></div></div>'
	},
	border : true,
	columns : [

			{
				text : nameLabel,
				dataIndex : 'Name',
				flex : 1
			}, {
				text : typeLabel,
				dataIndex : 'Type',
				flex : 1
			}, {
				text : testLabel,
				dataIndex : 'Test',
				flex : 1
			}, {
				text : measureLabel,
				dataIndex : 'Measure',
				flex : 1
			}, {
				text : descriptorLabel,
				dataIndex : 'Descriptor',
				flex : 1
			}, {
			//	header : '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconModify" id="modifyALL" style="cursor:pointer;margin-top: 5px" />',
 				header : '',
 				xtype : 'actioncolumn',
				//tooltip: 'Modify All',
				style:{'padding':'0px !important'},
				width : 30,
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Modify Configuration'
						});
					}
				},
				items : [{
					iconCls: 'iconModify',
					tooltip: 'Edit',
					style:{'padding':'0px'},
					handler : function(grid, htmlRow, index, columnIndex,
                            mouseEvent, record) {
						
                        Ext.getCmp('configdatas').showModificationWindow(grid,record);
                    }

				}]
			},{
				//header : '<img src="/final/images/removeall_single_icon.png" id="removeALL" style="cursor:pointer" />',
				header: '<div style="margin-top: 2px;cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				//tooltip: 'Remove All',
				width : 30,
				style:{'padding':'0px'},
				renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove" style="margin-top:2px"';
								return value;
							},
				items : [{
					//icon : '/final/images/remove-row.png',
					iconCls:'iconDelete',
					tooltip: 'Remove',
					style:{'padding':'0px'},
					handler : function(grid, htmlRow, index, columnIndex,
							mouseEvent, record) {
						grid.getStore().remove(record)
						grid.refresh();
						//grid.reload();
						var noOfrecords =grid.getStore().getCount();
						if (noOfrecords==0)
						{
						 Ext.getCmp("scheduleTool").setDisabled(true);
        					 Ext.getCmp("favoriteTool").setDisabled(true);
							Ext.getCmp('timelineForm').hide();
						}
					}
				}]
			}],

	loadColumnHeaders : function(screenLabels) {
		if (!Ext.isEmpty(this.columns)) {
			this.columns[1].setText(screenLabels["graphLang"]);
			this.columns[2].setText(screenLabels["nameLang"]);
			this.columns[3].setText(screenLabels["typeLang"]);
			this.columns[4].setText(screenLabels["layerLang"]);
			this.columns[5].setText(screenLabels["testLang"]);
			this.columns[6].setText(screenLabels["measureLang"]);
			this.columns[7].setText(screenLabels["descLang"]);
		}
	},
	listeners : {
		afterLayout : function(c) {
		/*Ext.select('.hscrollerbase').remove(); // added by jaiwin - for remove horizontal scroll bar.
			if (c.body.dom.fleXcroll) {
				var a = c.body.dom.childNodes;
				var b = [];
				for ( var i = 0, j = 0; i < a.length; i++) {
					if (a[i].id != c.body.id + "_mcontentwrapper"
							&& a[i].id != c.body.id + "_scrollwrapper") {
						b[j] = a[i];
						j++;
					}
				}
				var el = Ext.get(c.body.id + "_contentwrapper");
				for ( var i = 0; i < b.length; i++)
					el.appendChild(b[i]);
			}
			fleXenv.fleXcrollMain(c.body.id);
			var heightOfGrid = c.getView().getHeight();
			//set the view height to display all the rows
			var pageSize=c.getStore().pageSize;
			var viewHeight=c.getView().getHeight();
			var totalHeight=0;
			var rowsVisible=viewHeight/24; //24 for row height
			var pendingRows=pageSize-rowsVisible;
			if(c.getStore().getCount()>rowsVisible){
				totalHeight=pendingRows*24;
			}
			Ext.get(c.getView().getId(), this).setHeight(heightOfGrid+totalHeight);
			Ext.get(c.body.id + "_mcontentwrapper", this).setHeight(heightOfGrid);
			//Ext.get(c.body.id + "_contentwrapper", this).setHeight(heightOfGrid+totalHeight);
			Ext.get(c.body.id + "_contentwrapper", this).setHeight(c.getStore().getCount()* 24);
				if(c.scroll_flag==false){
					c.scroll_flag=true;
					c.doComponentLayout();
				}else{
					c.scroll_flag=false;
				}*/
		},
		'afterrender' : function(grid, scle) {
			grid.mon(Ext.select('#modifyALL'),'click',function(){
				Ext.getCmp('configdatas').showModificationWindow(grid,grid.getSelectionModel().getSelection());
			});
			grid.mon(Ext.select('#removeALL'), 'click', function() {
				var selectionArray = grid.getSelectionModel().getSelection();
				var selectionArrayLen=selectionArray.length;
				if (selectionArrayLen>0)
				{
					Ext.Msg.show({
					title : 'Alert',
					msg : 'Are you sure you want to remove selected configurations?',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal) {
							if (buttonVal == "yes") {
								var noOfrecords =grid.getStore().getCount();
								for (i = 0; i < selectionArrayLen; i++) {
									grid.getStore().remove(selectionArray[i]);
								}
								if(selectionArrayLen==noOfrecords)
								{
									Ext.getCmp('timelineForm').hide();
									Ext.getCmp("scheduleTool").setDisabled(true);
        								Ext.getCmp("favoriteTool").setDisabled(true);
								}
							}
						}
					});
				}
				else
				{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'No selected configurations to remove',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
			});
		}
	},
	   showModificationWindow : function(grid,record){
		appConstants.rec=record;

        var configDatasGrid = grid.getStore();
        var noOfrecords = configDatasGrid.getCount();
        var selectionModelObj = grid.getSelectionModel();
        var s_measures = [];
        var s_desc = [];
        var comparr = [];
        var test;
        var type;
        var name;
		var name_value;
        var meas;
        var measname;
		var desc_value;
		var isAllComponentsSelected = false;
		var hiddens;
       // for (var i = 0; i < noOfrecords; i++) 
		{
            //var rec = configDatasGrid.getAt(i);
            var rec = record;
           // if(selectionModelObj.isSelected(rec))
            {

                var Descriptor = rec.get('Descriptor');
                type = rec.get('Type_value');
                test = rec.get('Test_value');
                name = rec.get('Name');
                meas = rec.get('Measure_value');
                measname = rec.get('Measure');
				name_value = rec.get('Name_value');
				hiddens = rec.get('Hiddens');
				desc_value = rec.get('Descriptor_value');
				comparr.push(name);
				if(Descriptor=='-')
					Descriptor="-1";
                s_desc.push(Descriptor);
				//break;
            }

        }
		
		var tmpcomp;
		for(var c in comparr)
		{
			var cname = comparr[c];
			if (cname == "All Components" || cname.indexOf("#$#") != -1)
			{
				isAllComponentsSelected = true;
				Ext.Msg.show({
						title : 'Alert',
						msg : 'All Components are chosen. Please select single component',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
				});
				return;

			}


			if(tmpcomp!=undefined && tmpcomp!=cname)
			{
				Ext.Msg.show({
						title : 'Alert',
						msg : 'MultipleComponents are chooses.',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
							 });
					return;
			}
			tmpcomp = cname;
		}


        var param = 'modifyTest='+test+'&modifycompname='+name+'&type='+type+'&from=modify';

        for (var k = 0; k < s_desc.length; k++) {
            param += "&er_moddify_desc=" + s_desc[k];
        }

		
        Ext.Ajax.request({
              url:'../servlet/com.eg.ErCapacityPredictionViewResolver',
              params:param,
              scope:this,
              success:function(response)
              {
                var jsontext = response.responseText;
                var jsonObject = Ext.decode(jsontext);
                var modifymeasure = Ext.getCmp('modifymeasure');
				
				appConstants.jsonObject=jsonObject;
                //var measdata = [{'displayField' : measname,'valueField' : meas}];
                //modifymeasure.getStore().loadRawData(measdata);
				modifymeasure.getStore().loadRawData(jsonObject.measureCombo);
                modifymeasure.setValue(meas);
 
                var itemselector = Ext.getCmp('itemselector-field');
                var itemselectorinclude = Ext.getCmp('itemselector-field');


                itemselector.getStore().loadRawData(jsonObject.excludedDesc);
                itemselector.setValue(s_desc);

				//itemselectorinclude.getStore().loadRawData(jsonObject.includeDesc_value);
				//itemselectorinclude.setValue(s_desc);
                Ext.getCmp('comp').update('<span  style="width:100px" class="font_normal12">Component</b></span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.compname+'</span>');
                Ext.getCmp('type').update('<span  style="width:100px" class="font_normal12">Type</span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.comptype+'</span>');
                Ext.getCmp('test').update('<span  style="width:100px" class="font_normal12">Test</span>&nbsp;:&nbsp;<span class="font_bold12">'+jsonObject.test+'</span>');

              }
        });

        Ext.getCmp('modifypopup').doLayout();
        Ext.getCmp('modifypopup').show();
    }

});