Ext.define('citrixCapacityPlanning.controller.Main',{
extend:'Ext.app.Controller',
views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector: 'resultpanel', ref: 'resultpanel'},
		{selector:'CitrixCapacityPlanningForm', ref:'CitrixCapacityPlanningForm'},
		{selector: 'CitrixCapacityPlanningSettings', ref: 'CitrixCapacityPlanningSettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'},
		{selector: 'ReporterSettings',ref: 'ReporterSettings'},
	],
	init:function(){ 
		this.control({
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities':
			{
				'afterrender':this.loadTools
			},
			'CitrixCapacityPlanningSettings':
			{
				'afterrender':this.afterSettingsRender
			},
			'CitrixCapacityPlanningForm':
			{
				'boxready': this.afterCapacityFormRender
			},
			'CitrixCapacityPlanningForm combo[id="er_comptype"]':
			{
				'select': this.changeCompType
			},
			'CitrixCapacityPlanningForm combo[id="er_option"]':
			{
				'select': this.changeAnalysBy
			},
			'CitrixCapacityPlanningForm combo[id="er_site"]':
			{
				'select': this.changeBySite
			},
			/*'CitrixCapacityPlanningSettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},*/
			'CitrixCapacityPlanningSettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'CitrixCapacityPlanningSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'CitrixCapacityPlanningSettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'CitrixCapacityPlanningForm button[id="submit"]':
			{
				'click': this.formSubmit
			},
			'CitrixCapacityPlanningForm button[name="save"]':
			{
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
		});
	},

	goTo: function (btn) 
	{
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title : 'Citrix Capacity Planning Reports',
				msg : 'Chosen timeline not allowed',
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites();
		}else{
			this.showSchedules();
		}
	},
	changeEr_mode: function (combo) 
	{
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if(Ext.get('configMod')!=null){
			Ext.get('configMod').animate({
				duration: 250,
				to: {
					y: -530
				}
			});
		}
		this.formSubmit(Ext.getCmp('submit'));
	},
	showFavorites: function( obj )
	{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var hiddenFields =  appConstants.publicJSON["hiddens"];
			var favorite_id = hiddenFields["favorite_id"];
			var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+favorite_id;
				if(target!=undefined&&target.indexOf('er_rtype')==-1)
					target += '&er_rtype=Citrix Servers';
			if (appConstants.formButtonId=='save')
			{
				if((favorite_id=="null" ||  favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
					favorite_id=appConstants.favorite_id;

				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	showSchedules: function( obj )
	{
		if ( this.checkValidate(false) )
		{
			this.formSubmit( obj );
			var qString = appConstants.queryString;
			var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&er_rtype=Citrix Server&com.eg.CSRF_NONCE='+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		var prntURL=appConstants.publicJSON['PDF_URL'];
		if(Ext.getCmp('grid') != undefined && Ext.getCmp('grid').isHidden()){
			prntURL+='&isSummaryView=yes';
		}else if(Ext.getCmp('grid_Summary') != undefined && Ext.getCmp('grid_Summary').isHidden()){
			prntURL+='&isSummaryView=no';
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(prntURL);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&er_rtype=Citrix Server';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		var prntURL=appConstants.publicJSON['PRINT_URL'];
		if(Ext.getCmp('grid') != undefined && Ext.getCmp('grid').isHidden()){
			prntURL+='&isSummaryView=yes';
		}else if(Ext.getCmp('grid_Summary') != undefined && Ext.getCmp('grid_Summary').isHidden()){
			prntURL+='&isSummaryView=no';
		}
		parent.printWindowFn( prntURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeReportGeneration: function( obj )
	{
		var settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var reportGenVal = settingsForm.findField('reportGeneration').getValue();
		var bgReportObj = settingsForm.findField('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			bgReportObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var getTimelineVal = mainForm.findField('er_timeline').getValue();
		var stDateObj = mainForm.findField('er_stdate');
		var endDateObj = mainForm.findField('er_enddate');
		var stHrObj = mainForm.findField('er_sthr');
		var endHrObj = mainForm.findField('er_endhr');
		if ( getTimelineVal == 'Any' )
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
		}
	},
	/* changeExcludeWeekEnd: function ( obj )
	{
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		var weenendOn=Ext.getCmp("er_excwe").getValue();
		if(weenendOn =='Yes')
			Ext.getCmp('excludeDays').update(excludeMsgs);
		else
			Ext.getCmp('excludeDays').update('');
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},*/
	changeCompType: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeAnalysBy: function( obj )
	{
		var objVal=obj.getValue();
		if(objVal != undefined && objVal == 'Zone'){
			Ext.getCmp('er_componentname').hide();
		}else{
			Ext.getCmp('er_componentname').show();
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	changeBySite: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit(obj);
			this.hideResult();
		}
	},
	afterMainRender: function()
	{
		this.hideResult();
	},
	hideResult: function()
	{
		this.getResultpanel().hide();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}

			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	checkValidate: function(flag)
	{
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
			var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var zone=mainForm.findField('er_site')
		var er_Comp=mainForm.findField('er_componentname')
		var er_option=mainForm.findField('er_option').getValue();
		if((er_option!=null || er_option!=undefined) && er_option!="Component" )
		{
			if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please select a valid Zone',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}else if((er_option!=null || er_option!=undefined) && er_option =="Component" ){
			if(er_Comp.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please select a valid Component',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}

		var compType=mainForm.findField('er_comptype');
		if( compType.getValue() == '-1'){
			Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Please select a valid Component Type',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = mainForm.findField('er_stdate').getValue();
		tmpStartDate.setHours(mainForm.findField('er_sthr').getValue());
		var tmpEndDate = mainForm.findField('er_enddate').getValue();
		tmpEndDate.setHours(mainForm.findField('er_endhr').getValue());

		var timeFrom =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timeTo =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minFrom =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var minTo =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');

		if ( !checkTimePeriod(timeFrom, minFrom, timeTo, minTo ) )
		{
			return false;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var isSettingsOk = true;
		if ( reportgenVal!=null && reportgenVal == 'foreground' )
		{
//			if(flag)
//			{
//				if ( !Ext.isEmpty(limitforbg ) )
//				{
//					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
//					{
//						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
//						isSettingsOk = false;
//					}
//				}
//			}
		}
		else
		{
			var reportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	formSubmit: function( obj )
	{
		appConstants.fromvCenter = false;
		appConstants.fromTimeline = false;
		appConstants.fromSubmit = false;
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
		var starthr = mainForm.findField('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = mainForm.findField('er_enddate').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) 
		{
			return;
		}
		var me = this;
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var actionFrom = '';
		appConstants.fromFav = false;
		appConstants.fromSch = false;
		var frmCom=false;
		appConstants.er_comptype = false;
		appConstants.er_option = false;
		appConstants.er_site = false;
//		appConstants.subZone= false;
		if ( !Ext.isEmpty( obj ) )
		{
			actionFrom = obj.getId();
			if ( actionFrom == 'reporttype' )
			{
				fromReportType = true;
			}

			else if ( actionFrom == 'er_comptype' )
			{
			frmCom=true;
			appConstants.er_comptype = true;
			}
			else if ( actionFrom == 'er_option' )
			{
			frmCom=true;
			appConstants.er_option = true;
			}
			else if ( actionFrom == 'er_site' )
			{
			frmCom=true;
			appConstants.er_site = true;
			}

			else if ( actionFrom == 'er_timeline' )
			{
				appConstants.fromTimeline = true;
			}
			else if ( actionFrom == 'submit' ||  actionFrom == 'hideSubmit' )
			{
				appConstants.fromSubmit = true;
				if ( actionFrom == 'submit'){
					if ( !me.checkValidate(true) )
					{
						return;
					}
				}
			}
			else if ( actionFrom == 'favoriteTool' || actionFrom == 'favImg' )
			{
				//appConstants.fromFav = true;
			}
			else if ( actionFrom == 'scheduleImg' || actionFrom == 'scheduleTool' )
			{
				appConstants.fromSch = true;
			}
			else if ( actionFrom == 'submitViaSetting')
			{
				appConstants.fromSubmit = true;
				if ( !me.checkValidate(true) )
				{
					return;
				}
			}
		}
		this.updateQueryString();
		if ( appConstants.fromFav )
		{
			appConstants.queryString += '&call=json';
			return;
		}
		else if ( appConstants.fromSch )
		{
			return;
		}


		if(frmCom)
			this.generateResult();
		if ( appConstants.fromSubmit )
		{
			appConstants.queryString += '&isSubmit=true';
			this.generateResult();
		}
	},
	generateResult : function()
	{
		this.updateQueryString();
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		if ( appConstants.fromSubmit )
		{
			appConstants.queryString += '&isSubmit=true';
		}
		var me = this;
		var qstr = appConstants.queryString;
		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');

		var reporTypeVal = mainForm.findField('reportype').getValue();
		var er_optionVal = mainForm.findField('er_option').getValue();
		var remoteURL = '';
		{
			if ( er_reportgenrationVal == 'foreground' )
			{
				if(appConstants.fromSubmit)
				{
					remoteURL = '/final/servlet/com.eg.ErCitrixCapacityPlanningReportC';
				}
				else
				{
				remoteURL = '/final/reporter/ErCitrixCapacityPlanningReportJson.jsp';
				}

				qstr += '&call=json';
			}
			else
			{
				remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				qstr += '&call=json&isSubmit=true&forwardto=ErCitrixCapacityPlanningReportJson';
			}
		}
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		initLdgMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: qstr,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					var selectedData = appConstants.publicJSON['selectedValues'];
					appConstants.rawDataForComponents = appConstants.publicJSON['componentCombo'];
					if ( appConstants.er_comptype )
					{
						var componentCombo = appConstants.publicJSON['componentCombo'];
						var er_comptypeSelected = selectedData['er_componentname'];
						if ( !Ext.isEmpty( componentCombo ) ){
							var  comboObject = Ext.getCmp('er_componentname');
							comboObject.getStore().loadRawData(componentCombo);
							if (!Ext.isEmpty(er_comptypeSelected)) {
									comboObject.setValue(er_comptypeSelected);
							} else {
									comboObject.setValue(componentCombo[0].valueField);
							}
						}else{
							var  obj = Ext.getCmp('er_componentname');
							obj.getStore().removeAll();
							obj.getStore().add({
								'displayField': appConstants.notApplicable,
								'valueField': '-1'
							});
							obj.setValue('-1');
						}

						initLdgMask.hide();
					}
					else if ( appConstants.er_option )
					{
						var screenLabels = appConstants.publicJSON['screenLabels'];
						if(er_optionVal!=undefined && er_optionVal!='Component')
						{
							var comboObject = Ext.getCmp('er_site');
							comboObject.setFieldLabel(screenLabels['reporter.common.' + er_optionVal]);

							var siteCombo = appConstants.publicJSON['siteCombo'];
							var er_siteSelected = selectedData['er_site'];
							if ( !Ext.isEmpty( siteCombo ) )
							{
								me.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
							}
							else
							{
								me.insertNotApplicable(mainForm, 'er_site');
							}
							var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
							var er_comptypeSelected = selectedData['er_comptype'];
							if ( !Ext.isEmpty( compTypeCombo ) )
							{
								me.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
							}
							else
							{
								me.insertNotApplicable(mainForm, 'er_comptype');
							}


							var  comboObject = Ext.getCmp('er_componentname');
							comboObject.getStore().removeAll();
							comboObject.getStore().add({
								'displayField': appConstants.notApplicable,
								'valueField': '-1'
							});
							comboObject.setValue('-1');


							Ext.getCmp('er_site').show();
							initLdgMask.hide();
						}
						else
						{
							Ext.getCmp('er_site').hide();

							var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
							var er_comptypeSelected = selectedData['er_comptype'];
							if ( !Ext.isEmpty( compTypeCombo ) )
							{
								me.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
							}
							else
							{
								me.insertNotApplicable(mainForm, 'er_comptype');
							}
							var componentCombo = appConstants.publicJSON['componentCombo'];

							var er_comptypeSelected = selectedData['er_componentname'];
							if ( !Ext.isEmpty( componentCombo ) ){
								var  comboObject = Ext.getCmp('er_componentname');
								comboObject.getStore().loadRawData(componentCombo);
								if (!Ext.isEmpty(er_comptypeSelected)) {
										comboObject.setValue(er_comptypeSelected);
								} else {
										comboObject.setValue(componentCombo[0].valueField);
								}
							}else{
								var  obj = Ext.getCmp('er_componentname');
								obj.getStore().removeAll();
								obj.getStore().add({
									'displayField': appConstants.notApplicable,
									'valueField': '-1'
								});
								obj.setValue('-1');
							}


							initLdgMask.hide();
						}
					}
					else if ( appConstants.er_site )
					{
						var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
						var er_comptypeSelected = selectedData['er_comptype'];
						if ( !Ext.isEmpty( compTypeCombo ) )
						{
							me.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
						}
						else
						{
							me.insertNotApplicable(mainForm, 'er_comptype');
						}
						var componentCombo = appConstants.publicJSON['componentCombo'];


						var er_comptypeSelected = selectedData['er_componentname'];
						if ( !Ext.isEmpty( componentCombo ) ){
							var  comboObject = Ext.getCmp('er_componentname');
							comboObject.getStore().loadRawData(componentCombo);
							if (!Ext.isEmpty(er_comptypeSelected)) {
									comboObject.setValue(er_comptypeSelected);
							} else {
									comboObject.setValue(componentCombo[0].valueField);
							}
						}else{
							var  obj = Ext.getCmp('er_componentname');
							obj.getStore().removeAll();
							obj.getStore().add({
								'displayField': appConstants.notApplicable,
								'valueField': '-1'
							});
							obj.setValue('-1');
						}


						initLdgMask.hide();
					}
					else if ( appConstants.fromTimeline )
					{
						var startDate = selectedData['startDate'];
						var endDate = selectedData['endDate'];
						var startHour = selectedData['startHour'];
						var endHour = selectedData['endHour'];
						mainForm.findField('er_stdate').setValue(startDate);
						mainForm.findField('er_enddate').setValue(endDate);
						mainForm.findField('er_sthr').setValue(startHour);
						mainForm.findField('er_endhr').setValue(endHour);
					}
					else if ( appConstants.fromSubmit )
					{
						me.getResultpanel().removeAll();
						me.getResultpanel().show();
						var resultData = appConstants.publicJSON['RESULTS'];
						if ( er_reportgenrationVal == 'foreground')
						{
							if ( !Ext.isEmpty( resultData ) )
							{
								me.loadData(resultData);
							}
							else
							{
								me.getNomeasurepanel().show();
								me.getResultpanel().hide();
							}
						}
						else
						{
							resultData = appConstants.publicJSON['backgroundResults'];
							me.loadBackground(resultData);
						}
						initLdgMask.hide();
					}
				}
			}
		});

	},
	updateQueryString: function()
	{
		var qstr = '';
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var reporTypeVal = mainForm.findField('reportype').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_option = mainForm.findField('er_option').getValue();
		var er_siteVal = mainForm.findField('er_site').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var startdateVal = mainForm.findField('er_stdate').dataArray;
		var enddateVal = mainForm.findField('er_enddate').dataArray;
		var starthrVal = mainForm.findField('er_sthr').dataArray;
		var er_endhrVal = mainForm.findField('er_endhr').dataArray;
		var er_modeVal = mainForm.findField('er_mode').getValue();
		var er_optionVal = mainForm.findField('er_option').getValue();
		var er_compname = mainForm.findField('er_componentname').getValue();
		var serverTable_view = mainForm.findField('server_view').getValue();
		var er_excweVal = this.getSettingsFieldValue(settingsForm,'er_excwe',isSettingsEnabled,'excludeWeekSelected');
		var timefromVal =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timetoVal =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minfromVal =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var mintoVal =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');
//		var pvsEnv =this.getSettingsFieldValue(settingsForm,'ShowpvsEnvironment',isSettingsEnabled,'ShowpvsEnvironment');

		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var bgReportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
		bgReportName=checkFileName(bgReportName);
		qstr +=  this.getHiddenQstr();
		qstr +=  '&er_type='+encodeURIComponent(reporTypeVal)
				+'&er_timeline='+encodeURIComponent(er_timelineVal)
				+'&startdate='+encodeURIComponent(startdateVal)+'&enddate='+encodeURIComponent(enddateVal)
				+'&starthr='+encodeURIComponent(starthrVal)+'&endhr='+encodeURIComponent(er_endhrVal)
				+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin
				+'&timefrom='+encodeURIComponent(timefromVal)+'&timeto='+encodeURIComponent(timetoVal)
				+'&minfrom='+encodeURIComponent(minfromVal)+'&minto='+encodeURIComponent(mintoVal)
				+'&er_mode='+encodeURIComponent(er_modeVal)+'&er_excwe='+encodeURIComponent(er_excweVal)
				+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)+'&bg_reportname='+encodeURIComponent(bgReportName)
//				+'&ShowpvsEnvironment='+encodeURIComponent(pvsEnv)
				+'&serverTable_view='+encodeURIComponent(serverTable_view)
		qstr +='&er_comptype='+encodeURIComponent(er_comptype);
		qstr +='&er_option='+encodeURIComponent(er_option);
		if(er_option != null && er_option == 'Component'){
			qstr +='&er_component='+encodeURIComponent(er_compname);
		}

		qstr +='&er_site='+encodeURIComponent(er_siteVal);

		qstr+="&er_RmDispName="+encodeURIComponent(appConstants.er_RmDispName);
		appConstants.queryString = qstr;
		if(qstr!=undefined&&qstr.indexOf('er_rtype')==-1)
		{
			appConstants.queryString += '&er_rtype=Citrix Report';
		}
	},
	loadBackground: function( resultData )
	{
		var backgroundResultsData = resultData;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+backgroundResultURLLinkText+'</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{

				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+backgroundResultURLLinkText+'</a></div></td></tr></table></td></tr></table>';
			}
			resultObj.add({
				xtype: 'container',
				cls:'measuresErrorPanelBg',
				margin:0,
				bodyPadding:0,
				html:htmlStr,
			});
			resultObj.doLayout();
			resultObj.show();
			this.disableTools();
		}
	},
	loadData: function( resultData )
	{
		var resultObj = this.getResultpanel();
		var resultType = resultData['isServerwise'];
		this.enableTools();
		if(resultType)//For Single Server
		{
			var summaryResults = resultData['Overview'];
			var usage = resultData['Usage'];
			var SessnBasedCalculatn = resultData['SessnBasedCalculatn'];
			var tableResults = resultData['Table1']
			var recommandatn = resultData['Recommandatn'];
			var cpuGraph = resultData['CPUGraph'];
			var memoryGraph = resultData['MemoryGraph'];
			var diskGraph = resultData['DiskGraph'];
			var networkGraph = resultData['NetworkGraph'];
			if(summaryResults !=undefined)
			{
				var summaryTable ='<div class="highlightContainerBox">'
								+'<table width="100%" height="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr>'
								+'<td width="100%" height="80px" align="center" style="text-align:center"><h1 class="newFont_normal14" style="padding:5px 10px 13px 10px">'+additionalSessionsPossibleTxt+'</h1><table border="0px" align="center" cellpadding="0px" cellspacing="0px"><tr><td align="center" valign="middle" ><div  class="highlightColorBox newFont_bold28" >'+summaryResults.Possible_Sessions+'<img src="/final/images/spacer.gif" class="iconThumsUpColor" valign="middle" style="margin:-3px 0 0 5px;" /></div></td></tr></table></td></tr></table>'
								+'<table width="100%" height="100%" border="0px" cellpadding="0px" cellspacing="0px"><tr>'
								+'<td width="100%" height="80px"><h1 class="newFont_normal14" style="padding:5px 10px 13px 10px">'+capacityLimitedByTxt+'</h1><table border="0px" width="100%" height="40px"><tr><td align="center" valign="top" >';
				for (var key in summaryResults.Limit_By)
				{
					var mainColumn = summaryResults.Limit_By[key];
					if(mainColumn == 'Memory' || mainColumn == 'MEMORY')
						summaryTable+='<span class="newFont_normal13 highlightImageBox">'+mainColumn+'<img src="/final/images/spacer.gif" class="iconMemory32" style="vertical-align:middle;margin:-1px 0px 0px 10px" ></span>'
					else if(mainColumn == 'CPU' || mainColumn == 'CPU')
						summaryTable+='<span class="newFont_normal13 highlightImageBox">'+mainColumn+'<img src="/final/images/spacer.gif" class="iconCpu32" style="vertical-align:middle;margin:-1px 0px 0px 10px" ></span>'
					else if(mainColumn == 'Disk' || mainColumn == 'DISK')
						summaryTable+='<span class="newFont_normal13 highlightImageBox"> Disk IOPS<img src="/final/images/spacer.gif" class="iconDisk32" style="vertical-align:middle;margin:-1px 0px 0px 10px" ></span>'
					else 
						summaryTable+='<span class="newFont_normal13 highlightImageBox">'+mainColumn+'<img src="/final/images/spacer.gif" class="iconNetwork32" style="vertical-align:middle;margin:-1px 0px 0px 10px" ></span>'
				}
				summaryTable +=	'</td></tr></table></td></tr></table></div>'
			}

			if(SessnBasedCalculatn !=undefined)
			{
				var sessionBasedRecommendation='<table  width="100%"><tr>'
						+'<td style="padding-top:4px"><div class="recommendationText">*'+SessnBasedCalculatn+'</div></td></tr> </table></br>'
			}

			var usagedata='<table width="100%" border="0"><tr><td width="20%" height="100%" valign="top"><div style="position:relative;margin-right:20px;height:186px;min-width:100px" class="highlightFieldsetBox" ><div class="newFont_bold13 highlightFieldsetTitleBg" style="position:absolute;top:-12px;left:20px;padding:4px;">'+sessionsTxt+'</div><div align="center" class="ctxSessionsValueBlue">'+usage.AtCapacity+'<br><span class="ctxSessionsTextBlue">'+atCapacityTxt+'</span></div><div align="center" class="ctxSessionsValueBrown">'+usage.currentUsage+'<br><span class="ctxSessionsTextBrown">'+currentUsageTxt+'</span></div></td><td width="80%" style="padding-bottom:5px"><div style="position:relative;" class="highlightFieldsetBox"><div class="newFont_bold13 highlightFieldsetTitleBg" style="position:absolute;top:-12px;left:20px;padding:4px;">'+resourceUtilCapacityTxt+'</div><table width="100%"><tr><td width="25%" class="graphSeperatorLineRight">';
			
				if(cpuGraph.highlightEnable)
					usagedata+='<div class="chartOuterBox highlight">';
				else
					usagedata+='<div class="chartOuterBox">';
				usagedata+='<div class="header">'+CPUTxt+'</div><div class="triangleTopRight"></div><div id="id1" ></div><div class="rectBox">'+cpuGraph.val+'%</div></div></td><td width="25%" class="graphSeperatorLineRight">';
				
				if(memoryGraph.highlightEnable)
					usagedata+='<div class="chartOuterBox highlight">';
				else
					usagedata+='<div class="chartOuterBox">';
				usagedata+='<div class="header">'+memoryTxt+'</div><div class="triangleTopRight"></div><div id="id2" ></div><div class="rectBox">'+memoryGraph.val+'%</div></div></td><td width="25%" class="graphSeperatorLineRight">';
				
				if(diskGraph.highlightEnable)
					usagedata+='<div class="chartOuterBox highlight">';
				else
					usagedata+='<div class="chartOuterBox">';
				usagedata+='<div class="header">'+diskIOPSTxt+'</div><div class="triangleTopRight"></div><div id="id3" ></div><div class="rectBox">'+diskGraph.val+'%</div></td><td width="25%">';
				
				if(networkGraph.highlightEnable)
					usagedata+='<div class="chartOuterBox highlight">';
				else
					usagedata+='<div class="chartOuterBox">';
			
			usagedata+='<div class="header" style="width:140px;">'+networkBandwidthTxt+'</div><div class="triangleTopRight"></div><div id="id4" ></div><div class="rectBox">'+networkGraph.val+'%</div></div></td></tr></table></div></td></tr></table>';

			usagedata+='<div style="position:absolute;right:20px;border:0px solid red;display:flex;"><div class="ctxSessionsTextBrownLegend" style="float:left"></div><div class="ctxSessionsTextBrown11" style="float:left;margin-right:10px;">'+currentUsageTxt+'</div><div class="ctxSessionsTextBlueLegend" tyle="float:left"></div><div class="ctxSessionsTextBlue11" style="float:left;">'+atCapacityTxt+'</div></div>';

			resultObj.add(
			{
				xtype: 'panel',
				margin:'10 10 5 10',
				ui:'newGraphPanel',
				title:analysisHeader,
				items:[{
					xtype:'container',
					margin:'10 20 20 20',
					html:summaryTable+sessionBasedRecommendation+usagedata
				},
				{
					xtype:'container',
					margin:'30 20 20 20',
					columnWidth:1,
					cls:'newLineBottom',
					html:'<div class="notesBlue" style="width:100%"><div class="paperPin"> </div><div class="notesBlueText" style="text-align:center">'+recommandatn+'</div></div>'
				}]
			});
			
			resultObj.add({
				xtype: 'panel',
				margin:'5 10 10 10',
				ui:'newGraphPanel',
				title:detailedStatisticsTxt,
				layout:'column',
				items:[
					{
						xtype:'container',
						cls:'graphSeperatorLineBottomRight',
						columnWidth:.5,
						margin:'10 0 0 20',
						items:[
							{
								xtype:'container',
								html:'<div style="padding:10px 10px 10px 10px;text-align:center" class="newFont_bold13 ">'+activeSessionsTxt+'</div>'
							},	
							{
								xtype:'container',
								margin:'10 20 20 0',
								id:'id_2',
								columnWidth:1,
								height:300,
								listeners:
								{
									'boxready':function(c)
									{
										var activeSessionGraph=resultData['graph2']
										var lineChart_1 = {};
										lineChart_1 = jQuery.extend(true, {}, getHighChartsInstance('id_2',250,400), lineChart_1);
										lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}
								}
							}
						]
					
					},{
					xtype:'container',
					cls:'graphSeperatorLineBottom',
					margin:'10 20 0 0',
					columnWidth:.5,
					items:[
						{
							xtype:'container',
							html:'<div style="padding:10px 10px 10px 10px;text-align:center" class="newFont_bold13">'+totalSessionsTxt+'</div>'
						},	
						{
							xtype:'container',
							margin:'10 0 20 20',
							id:'id_1',
							columnWidth:1,
							height:300,					
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['graph1']
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('id_1',250,400), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}
							}
						},
					]
				},
				{
					xtype:'container',
					cls:'graphSeperatorLineRight',
					margin:'0 0 10 20',
					columnWidth:.5,
					items:[
						{
							xtype:'container',
							html:'<div style="padding:20px 10px 10px 10px;text-align:center" class="newFont_bold13 ">'+CPUMemoryUsageTxt+'</div>'
						},	
						{
							xtype:'container',
							margin:'10 20 10 0',
							id:'id_3',
							height:300,
							columnWidth:1,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['graph3']
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsInstance('id_3',250,400), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}
							}
						}
					]
				
				},
				{
					xtype:'container',
					margin:'0 20 10 0',
					columnWidth:.5,
					items:[
						{
							xtype:'container',
							html:'<div style="padding:20px 10px 10px 10px;text-align:center" class="newFont_bold13">'+diskNetworkUsageTxt+'</div>'
						},	
						{
							xtype:'container',
							margin:'10 0 10 20',
							id:'id_4',
							columnWidth:.5,
							height:300,
							listeners:
							{
								'boxready':function(c)
								{
									var activeSessionGraph=resultData['graph4']
									var lineChart_1 = {};
									lineChart_1 = jQuery.extend(true, {}, getHighChartsInstance('id_4',250,400), lineChart_1);
									lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
									lineChart_1.drawChart();
								}
							}
						}
					]
				}]
			});
 
			if(!cpuGraph.NodataFound)
			{
				var donutChart = {};
				donutChart = jQuery.extend(true, {}, getHighChartsBarInstance('id1',80,80), donutChart);
				donutChart.setData(cpuGraph,'','','donut');
				donutChart.drawChart();
			}
		
			if(!memoryGraph.NodataFound)
			{
				var donutChart = {};
				donutChart = jQuery.extend(true, {}, getHighChartsBarInstance('id2',80,80), donutChart);
				donutChart.setData(memoryGraph,'','','donut');
				donutChart.drawChart();
			}
			if(!diskGraph.NodataFound)
			{
				var donutChart = {};
				donutChart = jQuery.extend(true, {}, getHighChartsBarInstance('id3',80,80), donutChart);
				donutChart.setData(diskGraph,'','','donut');
				donutChart.drawChart();
			}
			if(!networkGraph.NodataFound)
			{
				var donutChart = {};
				donutChart = jQuery.extend(true, {}, getHighChartsBarInstance('id4',80,80), donutChart);
				donutChart.setData(networkGraph,'','','donut');
				donutChart.drawChart();
			}
		}
		else//for Multiple Servers
		{
			var reportData=resultData;
			if(reportData != undefined){
				var analyssData=reportData.AnalysisDatas;
				var servertableViewBy=reportData.servertableViewBy;
				if(analyssData != undefined){
					var analysisNote='';
					if(analyssData.AnalysisText != undefined)
						analysisNote='<div class="newFont_normal14" style="padding: 0 20px;">'+analyssData.AnalysisText+'</div>';
//					var consumptionperSession=analyssData.UsagePerSession;
					var consumptionperSessionTmp=analyssData.SingleSessionUsageFromZoneTable;
					var bottleneckValue=analyssData.bottleneckValue;
					var consumptionperSessionTitVal=analyssData.usagePerSessionTitVal;
					if(analyssData !=undefined && analyssData.TotalServers != undefined)
					{
						var summaryTable='<div class="highlightContainerBoxFlex">'

							+'<div class="div1"><div class="alignMiddle"><table border="0px"><tbody><tr><td align="center" style="padding:5px 0px 0px 0px"><div class="iconLogonUser"></div></td><td style="text-align:left;" class="highLightValue48" rowspan="2">'+analyssData.uniqueUsersCount+'</td></tr><tr><td style="text-align:center;padding:5px;" class="newFont_normal16">'+usersTxt+'</td></tr></tbody></table></div></div>'
								
							+'<div class="div1"><div class="alignMiddle"><table border="0px"><tbody><tr><td align="center" style="padding:5px 0px 0px 0px"><div class="iconServerGray"></div></td><td style="text-align:left;" class="highLightValue48" rowspan="2">'+analyssData.TotalServers+'</td></tr><tr><td style="text-align:center;padding:5px;" class="newFont_normal16">'+serversTxt+'</td></tr></tbody></table></div></div>'

							+'<div class="div1"><div class="alignMiddle"><table border="0px"><tbody><tr><td align="center" style="padding:5px 0px 0px 0px"><div class="iconSessionsCompleted"></div></td><td style="text-align:left;" class="highLightValue48" rowspan="2">'+analyssData.CompletedSessions+'</td></tr><tr><td style="text-align:center;padding:5px;" class="newFont_normal16">'+sessionCompletedTxt+'</td></tr></tbody></table></div></div></div>'
					}
					var consumptionValTmp;
					if(consumptionperSessionTmp !=undefined)
					{
						consumptionValTmp='<div>'
							+'<div style="line-height:0px;">'
								+'<div class="consumptionperSessionTitleBgLine" style=""></div>'
								+'<div align="center" style="position:relative; top:-2px; ">'
									+'<span class="consumptionperSessionTitleBig">'+consumptionperSessionTitVal+'</span>'
								+'</div>'
							+'</div>'
							+'<div class="consumptionperSessionBox">';
						for (var indx in consumptionperSessionTmp){
							var cons=consumptionperSessionTmp[indx];

					
							consumptionValTmp+='<div class="childDiv"><table align="center"  border="0px" ><tr><td class="resourceUsability" valign="bottom" align="center">'+cons.value+'<span class="resourceUnit">%</span></td></tr><tr><td style="vertical-align:top;" align="center" class="resourceName">'+cons.name+'</td></tr></table></div>';
						}
						consumptionValTmp+='</div></div>';
					}
					resultObj.add({
						xtype: 'panel',
						margin:'10 10 5 10',
						ui:'newGraphPanel',
						style:{'padding':'0px'},
						title:analysisHeader,
						layout:'column',
						items:[
						{
							xtype:'container',
							margin:'5 0 0 0',
							columnWidth:1,
							html:summaryTable
						},
						{
							xtype:'container',
							margin:'5 20 10 20',
							columnWidth:1,
							html:analysisNote
						},
						{
							xtype:'container',
							margin:'10 0 10 0',
							columnWidth:1,
							items:[
							{
								xtype:'container',
								html:'<div class="newFont_bold13" style="padding-left: 10px;">'+peakLoadvsservrUsedTxt+'</div>'
							},
							{
								xtype:'container',
								id:'z_id_1',
								margin:'10 10 10 10',
//								height:300,
								listeners:{
									'boxready':function(){
										var totalServrandSessnGraph=analyssData.peakUsagevsServerCountGraph;
										if(totalServrandSessnGraph != undefined){
											Ext.get('z_id_1').setHeight(300);
											var lineChart_1 = {};
											lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance_combine('z_id_1',300,400), lineChart_1);
											lineChart_1.setData(totalServrandSessnGraph,appConstants.currentDateFormat,'');
											lineChart_1.drawChart();
										}else{
											Ext.get('z_id_1').setHeight(150);
											Ext.get('z_id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
										}

									}
								}
							}]
							
						},
						{
							xtype:'container',
							margin:'10 0 10 0',
							columnWidth:1,
							items:[
							{
								xtype:'container',
								html:'<div class="newFont_bold13" style="padding-left: 10px;">'+resourceConsumptnTxt+'</div>'
							},
							{
								xtype:'container',
								margin:'10 10 10 10',
								id:'z_id_2',
//								height:300,
								listeners:{
									'boxready':function(){
										var totalServrandSessnGraph=analyssData.resourceConsumptionGraph;
										if(totalServrandSessnGraph != undefined){
											Ext.get('z_id_2').setHeight(300);
											var lineChart_1 = {};
											lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('z_id_2',300,300), lineChart_1);
											lineChart_1.setData(totalServrandSessnGraph,appConstants.currentDateFormat,'');
											lineChart_1.drawChart();
										}else{
											Ext.get('z_id_2').setHeight(150);
											Ext.get('z_id_2').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
										}
									}
								}
							}]
						},{
							xtype:'container',
							margin:'20 10 0 10',
							columnWidth:1,
							html:consumptionValTmp,
						}]
					});
				}

				var distrbutnData=reportData.DistributionDatas;
				if(distrbutnData != undefined)
				{
					var distrbutnTable=distrbutnData.distributionTable;
					var distrbutnGraph=distrbutnData.distributionGraph;
					var possiblesessnCnt=distrbutnData.possiblesessnCnt;
					var serverLoads=distrbutnData.serverLoads;
					var ServrCapacityGraphTitle=distrbutnData.ServrCapacityGraphTitle;
					var ServrCapacityGraph=distrbutnData.ServrCapacityGraph;
					var CapacityDemandTableData=distrbutnData.CapacityDemandTable;
					var TotalCapacityTableData=distrbutnData.TotalCapacityTable;
					var distributionSummary=distrbutnData.distributionSummary;
			//DistributionDatas
					var serverTable='<div class="newTable"><table width="100%" border="0px"><thead><tr><th style="text-align:center">'+noofSessionsTxt+'</th><th style="text-align:center">'+noofServersTxt+'</th><th style="text-align:center">'+additionalSessionsTxt+' <br/> '+PossibleTxt+'</th></tr></thead><tbody>';
					for(var i=0;i<Object.keys(distrbutnTable).length;i++){
						serverTable+='<tr align="center" ">'
						serverTable+='<td>'+distrbutnTable[i].SessionCount+'</td>';
						if(distrbutnTable[i].ServerCount > 0)
							serverTable+='<td><div align="center" style="cursor:pointer;" onclick="javascript:openNewPopupWindow(\''+distrbutnTable[i].url+'\');"><span class="anchorLink" >'+distrbutnTable[i].ServerCount+'</span></div></td>';
						else
							serverTable+='<td>0</td>';
						serverTable+='<td>'+distrbutnTable[i].PossibleSessionCount+'</td>';
						serverTable+='</tr>';
					}
					serverTable+='</tbody></table></div>';
					var loadDatas;
					if(serverLoads != undefined){
						loadDatas='<div><table><tr>'
						for(var indx in serverLoads){
							var tmp=serverLoads[indx];
							loadDatas+='<td>'+tmp.name+' - </td><td style="padding-right:10px;" class="newFont_bold12">'+tmp.value+'</td>';
						}
						loadDatas+='</tr></table></div>'
					}
					var currentUsageData='';
					if(CapacityDemandTableData != undefined){
						currentUsageData='<div><div style="line-height:0px;"><div class="consumptionperSessionTitleBgLine" style=""></div><div align="center" style="position:relative; top:-2px; "><span class="consumptionperSessionTitleBig">'+usedvsAvailCapacityTxt+'</span></div></div><div class="consumptionperSessionBox">';
						for(var indx in CapacityDemandTableData){
							var tmp=CapacityDemandTableData[indx];

							currentUsageData+='<div class="childDiv" ><table align="center"  border="0px" ><tr><td class="resourceUsability" valign="bottom" align="center">'+tmp.value+'<span class="resourceUnitText"> &nbsp;</span></td></tr><tr><td style="vertical-align:top;" align="center" class="resourceName">'+tmp.name+'</td></tr></table></div>';
						}
						currentUsageData+='</div></div>';
					}
					var totalCapacityData='';
					if(TotalCapacityTableData != undefined){
						totalCapacityData='<div><div style="line-height:0px;"><div class="consumptionperSessionTitleBgLine" style=""></div><div align="center" style="position:relative; top:-2px; "><span class="consumptionperSessionTitleBig">'+infraTotalCapacityTxt+'</span></div></div><div class="consumptionperSessionBox">';
						for(var indx in TotalCapacityTableData){
							var tmp=TotalCapacityTableData[indx];

							totalCapacityData+='<div class="childDiv" ><table align="center"  border="0px" ><tr><td class="resourceUsability" valign="bottom" align="center">'+tmp.value+'<span class="resourceUnitText">&nbsp;</span></td></tr><tr><td style="vertical-align:top;" align="center" class="resourceName">'+tmp.name+'</td></tr></table></div>';
						}
						totalCapacityData+='</div></div>';
					}

					resultObj.add({
						xtype: 'panel',
						margin:'5 10 5 10',
						ui:'newGraphPanel',
						padding:0,
						title:distributionTxt,
						layout:'column',
						items:[
							{
								xtype:'container',
								margin:'10 10 10 10',
								columnWidth:.45,
								html:serverTable
							},
							{
								xtype:'container',
								margin:'0 10 0 10',
								columnWidth:.55,
								id:'dist_id_3',
								listeners:{
									'boxready':function(){
										if(distrbutnGraph != undefined){
											var lineChart_1 = {};
											lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance_combine('dist_id_3',200,400), lineChart_1);
											lineChart_1.setData(distrbutnGraph,appConstants.currentDateFormat,'');
											lineChart_1.drawChart();
										}else{
											Ext.get('dist_id_3').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
										}
									}
								}
							},
							{
								xtype:'container',
								margin:'0 10 10 10',
								columnWidth:.45,
							//	html:'<div class="newFont_normal12" align="center" >Total additional sessions possible -  '+possiblesessnCnt+'</div>'
							},
							{
								xtype:'container',
								margin:'0 10 10 10',
								columnWidth:.55,
								html:'<div class="newFont_normal12" align="center" >'+loadDatas+'</div>'
							},
							{
								xtype:'container',
								margin:'5 10 5 10',
								columnWidth:1,
								layout:{
									type:'column',
									align:'stretch',
								},
								items: [{
									xtype:'container',
									columnWidth:1,
									margin:'10 0 0 0',
									layout:{
										type:'hbox',
										//pack:'center',
									},
									items: [
									{
										xtype: 'label',
										text: ServrCapacityGraphTitle,
										cls:'newFont_bold14',
									},{
										xtype:'button',
										iconCls: 'iconMaximize',
										tooltip:'Show all Servers',
										padding :'0 0 0 10',
										style:{
											background:'none',
											border:'none'
										},
										listeners:{
											'click':function(){
												initLdgMask.show();
												var gWindow = Ext.create('utilities.GenericWindow', {
													flex : 1,
													scroll: false,
													resizable:false,
													autoScroll: false,
													layout: 'fit',
													border:false,
													id:'GenericWindowId1',
													ghost: false,
													modal:true,
													closeAction: 'destroy',
													closable:true,
													ui:'newPopupWindow newplainHeader_border',
													header:true,
													height:420,
													width:700,
													title:serverswithmoreCapacityTxt,
													layout : {
														type : 'vbox',
														align : 'stretch',
														pack : 'center'
													},
													listeners:{
														'boxready':function(){
															initLdgMask.hide();
														},
														'close':function(){
															var win = Ext.getCmp('GenericWindowId1');
															if(win)win[win.closeAction]();
														},
														'hide':function(){
															var win = Ext.getCmp('GenericWindowId1');
															if(win)win[win.closeAction]();
														},
													},
													items:[
													{
														xtype:'container',
														frame:false,
														scroll: true,
														autoScroll: true,
														margin : '0 10 20 0',
														width:800,
														height:400,
														id:'dist_drill_id_1',
														overflowY : 'auto',
														listeners:{
															'boxready':function(c)
															{
																var totalServrandSessnGraph=distrbutnData.ServrCapacityGraph_Drill;
																if(totalServrandSessnGraph != undefined){
																	var chartHeight=350;
																	if(totalServrandSessnGraph.datasetSize != undefined){
																		var len=totalServrandSessnGraph.datasetSize;
																		if(len > 10){
																			chartHeight+=(len-10)*20;
																		}
																	}
																	var lineChart_1 = {};
																	lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('dist_drill_id_1',chartHeight,300), lineChart_1);
																	lineChart_1.setData(totalServrandSessnGraph,appConstants.currentDateFormat,'');
																	lineChart_1.drawChart();
																}else{
																	Ext.get('dist_drill_id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
																}
															}
														}
													}]
												}).show();
											}
										}
									}]
								},
								{
									xtype:'container',
									margin:'5 5 0 0',
									columnWidth:1,
									id:'dist_id_1',
									height:300,
									listeners:
									{
										'boxready':function()
										{
											var totalServrandSessnGraph=distrbutnData.ServrCapacityGraph;
											if(totalServrandSessnGraph != undefined){
												var lineChart_1 = {};
												lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('dist_id_1',250,300), lineChart_1);
												lineChart_1.setData(totalServrandSessnGraph,appConstants.currentDateFormat,'');
												lineChart_1.drawChart();
											}else{
												Ext.get('dist_id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
											}
										}
									}
								}]
							},
							{
								xtype:'container',
								margin:'20 0 10 10',
								padding:'0 20 0 0',
								columnWidth:.5,
								border:true,
								html:totalCapacityData,
							},{
								xtype:'container',
								margin:'20 10 10 20',
								columnWidth:.5,
								html:currentUsageData,
							},{
								xtype:'container',
								margin:'10 20 25 20',
								columnWidth:1,
								html:'<div style="padding: 0 20px;" class="newFont_normal12">'+distributionSummary+'</div>'
							}
						]
					});
				}
				var OptimizatnData=reportData.OptmizingCapacityDatas;
				if(OptimizatnData != undefined)
				{
					var limitingFactrGrph=OptimizatnData.limitingFactorGraph;
					var resource=OptimizatnData.limitingFactorTable;
					var recommendationData=OptimizatnData.RecommendationNotes;
					var optimizationSummary=OptimizatnData.optimizationSummary;
					var zoneName=OptimizatnData.zoneName;

					var recommendation=OptimizatnData.RecommendationNote;
					var resource_Table='';
					var resoureUsageTable='';
					var tabwidth='50%';
					var padLeft = '';
					var padRight = '';
					if(limitingFactrGrph != undefined){
						resource_Table+='<div class="gunPoint"><div id="optimze_id_1"></div></div>';
						tabwidth='33%';
						padLeft = 'padding-left:50px';
						padRight = 'padding-Right:50px';
					}
					resource_Table+='<table width="100%"  border="0px" height="100%"><tr><td width='+tabwidth+' align="center" class="newLineBottomRight" valign="middle" style="'+padRight+'">';
					resoureUsageTable='<div class="newTable" style="column-count:1; height:100%; display:flex; flex-direction:column; justify-content: center;"><table class="" border="0px" width= "100%" style="border-right:0px; border-left:0px;">';
					resource_Table+='<table border="0px" ><tr><td align="left" valign="middle" colspan="2">';
					if(resource.CPU.ServerCount >0 ){
						var qstr=resource.CPU.url;
						resource_Table+='<div align="center" style="cursor:pointer;" onclick="javascript:openNewPopupWindow(\''+qstr+'\');"><span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconCpu32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.CPU.ServerCount+'<span class="newFont_normal13">&nbsp;&nbsp;('+resource.CPU.percent+'%)</span></span></div>';
						resoureUsageTable+='<tr><td style="padding:15px;"><div class="resoureUsageTableDiv"><table border="0px" height="30px"><tr style="background:transparent"><td valign="bottom" style="padding:0px;line-height:100%"><div class="iconServerGray"></div></td><td valign="bottom" style="text-align:right;padding:0px 10px;"><div class="newFont_normal30">'+resource.CPU.ServerCount+'</div></td><td style="vertical-align:bottom;text-align:left;padding:0px;line-height:100%"><div class="newFont_normal13">'+serversTxt+' </div></td></tr></table></div></td><td><div style="float:left; padding:0px 0px 0px 0px;"  class="newFont_normal12">'+reachmaximumcapacityTxt+', '+cpuConsumedTxt+'</div></td></tr>'
					}
					else{
						var qstr=resource.CPU.url;//color
						resource_Table+='<span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconCpu32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.CPU.ServerCount+'</span>';
					}
					resource_Table+='</td></tr><tr><td align="middle" class="newFont_normal13" style="padding-top:5px"><span style="background:'+resource.CPU.color+'; color:#fff; padding:2px 4px; position:relative; top:-7px;">'+cpuTxt+'</span></td></tr></table>';
					resource_Table+='</td>';
					resource_Table+='<td align="center" valign="middle" class="newLineBottom" width='+tabwidth+' style="'+padLeft+'">'
					resource_Table+='<table border="0px" ><tr><td align="left" valign="middle" colspan="2">';
					if(resource.Memory.ServerCount >0 ){
						var qstr=resource.Memory.url;
						resource_Table+='<div align="center" style="cursor:pointer;" onclick="javascript:openNewPopupWindow(\''+qstr+'\');"><span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconMemory32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Memory.ServerCount+'<span class="newFont_normal13">&nbsp;&nbsp;('+resource.Memory.percent+'%)</span></span></div>';
						resoureUsageTable+='<tr><td style="padding:15px;"><div class="resoureUsageTableDiv"><table border="0px" height="30px"><tr  style="background:transparent"><td valign="bottom" style="padding:0px;line-height:100%"><div class="iconServerGray"></div></td><td valign="bottom" style="text-align:right;padding:0px 10px;"><div class="newFont_normal30">'+resource.Memory.ServerCount+'</div></td><td style="vertical-align:bottom;text-align:left;padding:0px;line-height:100%"><div class="newFont_normal13">'+serversTxt+' </div></td></tr></table></div></td><td><div style="float:left; padding:0px 0px 0px 0px;"  class="newFont_normal12">'+reachmaximumcapacityTxt+', '+memoryConsumedTxt+'</div></td></tr>'
					}else{
						resource_Table+='<span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconMemory32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Memory.ServerCount+'</span>';
					}
					resource_Table+='</td></tr><tr><td align="middle" class="newFont_normal13" style="padding-top:5px"><span style="background:'+resource.Memory.color+'; color:#fff; padding:2px 4px; position:relative; top:-7px;">'+memoryTxt+'</span></td></tr></table>';
					resource_Table+='</td></tr><tr><td align="center" valign="middle" class="newLineRight" width='+tabwidth+' style="'+padRight+';padding-top:15px">'
					resource_Table+='<table border="0px" ><tr><td align="left" valign="middle" colspan="2">';
					if(resource.Disk.ServerCount >0 ){
						var qstr=resource.Disk.url;
						resource_Table+='<div align="center" style="cursor:pointer;" onclick="javascript:openNewPopupWindow(\''+qstr+'\');"><span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconDisk32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Disk.ServerCount+'<span class="newFont_normal13">&nbsp;&nbsp;('+resource.Disk.percent+'%)</span></span></div>';
						resoureUsageTable+='<tr><td style="padding:15px;"><div class="resoureUsageTableDiv"><table border="0px" height="30px"><tr  style="background:transparent"><td valign="bottom" style="padding:0px;line-height:100%"><div class="iconServerGray"></div></td><td valign="bottom" style="text-align:right;padding:0px 10px;"><div class="newFont_normal30">'+resource.Disk.ServerCount+'</div></td><td style="vertical-align:bottom;text-align:left;padding:0px;line-height:100%"><div class="newFont_normal13">'+serversTxt+' </div></td></tr></table></div></td><td><div style="float:left; padding:0px 0px 0px 0px;"  class="newFont_normal12">'+reachmaximumcapacityTxt+', '+diskConsumedTxt+'</div></td></tr>'
					}else{
						resource_Table+='<span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconDisk32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Disk.ServerCount+'</span>';
					}

					resource_Table+='</td></tr><tr><td align="middle" class="newFont_normal13" style="padding-top:5px"><span style="background:'+resource.Disk.color+'; color:#fff; padding:2px 4px; position:relative; top:-7px;" >'+diskTxt+'</span></td></tr></table>';
					resource_Table+='</td><td align="center" valign="middle" width='+tabwidth+' style="'+padLeft+';padding-top:15px">'
					resource_Table+='<table border="0px" ><tr><td align="left" valign="middle" colspan="2" >';
					if(resource.Network.ServerCount >0 ){
						var qstr=resource.Network.url;
						resource_Table+='<div align="center" style="cursor:pointer;" onclick="javascript:openNewPopupWindow(\''+qstr+'\');"><span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconNetwork32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Network.ServerCount+'<span class="newFont_normal13">&nbsp;&nbsp;('+resource.Network.percent+'%)</span></span></div>';
						resoureUsageTable+='<tr><td style="padding:15px;"><div class="resoureUsageTableDiv"><table border="0px" height="30px"><tr  style="background:transparent"><td valign="bottom" style="padding:0px;line-height:100%"><div class="iconServerGray"></div></td><td valign="bottom" style="text-align:right;padding:0px 10px;"><div class="newFont_normal30" style="text-align:right;">'+resource.Network.ServerCount+'</div></td><td style="vertical-align:bottom;text-align:left;padding:0px;line-height:100%"><div class="newFont_normal13">'+serversTxt+' </div></td></tr></table></div></td><td><div style="float:left; padding:0px 0px 0px 0px;"  class="newFont_normal12">'+reachmaximumcapacityTxt+', '+networkConsumedTxt+'</div></td></tr>'
					}else{
						resource_Table+='<span class="newFont_normal30 highlightImageBoxWithoutCurve"><img src="/final/images/spacer.gif" class="iconNetwork32" style="vertical-align:middle;margin:-6px 6px 0px 0px" >'+resource.Network.ServerCount+'</span>';
					}
					if(resource.Idle_Servers != undefined){
						resoureUsageTable+='<tr><td style="padding:15px;"><div class="resoureUsageTableDiv"><table border="0px" height="30px"><tr  style="background:transparent"><td valign="bottom" style="padding:0px;line-height:100%"><div class="iconServerGray"></div></td><td valign="bottom" style="text-align:right;padding:0px 10px;"><div class="newFont_normal30" style="text-align:right;">'+resource.Idle_Servers.ServerCount+'</div></td><td style="vertical-align:bottom;text-align:left;padding:0px;line-height:100%"><div class="newFont_normal13">'+serversTxt+' </div></td></tr></table></div></td><td><div style="float:left; padding:0px 0px 0px 0px;"  class="newFont_normal12">'+idleServersTxt+'</div></td></tr>'
					}
					resoureUsageTable+='</table></div>'
					resource_Table+='</td></tr><tr><td align="middle" class="newFont_normal13" style="padding-top:5px"><span style="background:'+resource.Network.color+'; color:#fff; padding:2px 4px; position:relative; top:-7px;" >'+networkTxt+'</span></td></tr></table>';
					resource_Table+='</tr></table><br/><br/>';
					
					var optimizationSummaryTable='';

					if(optimizationSummary != undefined){
						optimizationSummaryTable='<div><div style="line-height:0px;"><div class="consumptionperSessionTitleBgLine" style=""></div><div align="center" style="position:relative; top:-2px; "><span class="consumptionperSessionTitleBig">'+overallcapacityTxt+'</span></div></div><div class="consumptionperSessionBox">';
						optimizationSummaryTable+='<div class="childDiv" style="background:none"><table align="left"  border="0px" ><tr><td class="resourceUsability" valign="bottom" style="padding-left:7px;padding-right:7px">&nbsp;</td></tr><tr><td style="vertical-align:bottom;" class="resourceName">&nbsp;</td></tr></table></div>';
						for(var indx in optimizationSummary){
							var tmp=optimizationSummary[indx];

							optimizationSummaryTable+='<div class="childDiv" ><table align="center"  border="0px" ><tr><td class="resourceUsability" valign="bottom" align="center">'+tmp.value+'<span class="resourceUnitText">&nbsp;</span></td></tr><tr><td style="vertical-align:top;" align="center" class="resourceName">'+tmp.name+'</td></tr></table></div>';
						}
						optimizationSummaryTable+='<div class="childDiv" style="background:none"><table align="left"  border="0px" ><tr><td class="resourceUsability" valign="bottom" style="padding-left:7px;padding-right:7px">&nbsp;</td></tr><tr><td style="vertical-align:bottom;" class="resourceName">&nbsp;</td></tr></table></div>';
						optimizationSummaryTable+='</div></div>';
					}
					resultObj.add(
					{
						xtype: 'panel',
						margin:'5 10 10 10',
						ui:'newGraphPanel',
						title:optimizationTxt,
						layout:'column',
						id:'optimizingCapacity',
						items:[
						{
							xtype:'container',
							margin:'5 10 0 10',
							columnWidth:.85,
							html:'<div class="newFont_bold13" align="left">'+factorslimitingcapacityTxt+'</div>'
						},
						{
							xtype:'container',
							margin:'5 0 0 10',
							columnWidth:.15,
							items:[
							{
								xtype:'button',
								margin :'0 10 0 0',
								text:'<div id="showDetailed" class="showDetailed">'+showdetailedanalysisTxt+'</div>',
								style:{
									'float':'right',
									background:'none',
									border:'none'
								},
								listeners:{
									'click':function(){
										if(Ext.getCmp('grid_detailed').isHidden()){
											Ext.getCmp('grid_Summary').hide();
											Ext.getCmp('grid_detailed').show();
											Ext.getCmp('server_view').setValue("detailed");
										}else{
											if(Ext.getCmp('grid_detailed') != undefined)
												Ext.getCmp('grid_detailed').hide();
											Ext.getCmp('grid_Summary').show();
											Ext.getCmp('server_view').setValue("summary");
										}
									}
								}
								
							}]
						},
						{
							xtype:'container',
							margin:'5 0 10 0',
							columnWidth:1,
							id:'grid_detailed',
							hidden:true
						},
						{
							xtype:'container',
							margin:'5 0 10 0',
							columnWidth:1,
							id:'grid_Summary'
						},
						{
							xtype:'container',
							padding:'5 10 10 10',
							columnWidth:.5,
							height:300,
							margin:'5 10 10 0',
							cls:'resoureUsageTableContainer',
							html:resoureUsageTable
						},{
							xtype:'container',
							margin:'15 10 10 10',
							columnWidth:.5,
							items:[
								{
									xtype:'container',
									padding:'0 20 0 20',
									html:'<div style="padding:10px 10px 10px 0px;" class="newFont_bold13" align="center">'+factorslimitingcapacityTxt+'</div>',
								},
								{
									xtype:'container',
									height:190,
									padding:'10 40 0 20',
									columnWidth:1,
									style:{'position':'relative'},
									html:resource_Table,
									listeners:
									{
										'afterrender':function()
										{
											if(limitingFactrGrph != undefined){
												var lineChart_1 = {};
												lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('optimze_id_1',250,300), lineChart_1);
												lineChart_1.setData(limitingFactrGrph,appConstants.currentDateFormat,'');
												lineChart_1.drawChart();
											}else{
												Ext.get('optimze_id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
											}
										}
									}
								},
							]
						}]
					});
					if(recommendationData != undefined){
						recmdtn='<div class="highlightContainerBox" style="column-count:1;"><div class="recommendationTitle  align="left"><div class="recommendationTitleText">'+recommendationsforTxt+' '+zoneName+' '+ZoneTxtlwr+'</div></div><table style="margin:10px;">';
						for(var ind in recommendationData){
							var resrceVal=ind;
							var recmnData=recommendationData[ind];
							if(ind != undefined && ind == 'Cpu'){
								resrceVal='CPU';
							}
							if(recmnData != undefined){
								recmdtn+='<tr><td colspan="2" align="left" style="padding-top: 5px;padding-bottom: 6px;">Additional capacity gains by increasing '+resrceVal+'</td></tr>';
								for(var indx in recmnData){
									recmdtn+='<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><img src="/final/images/spacer.gif" class="iconArrowBullet" style="vertical-align:middle"></td><td style="padding-left: 10px;float:left">'+recmnData[indx]+'</td></tr>'
								}
							}
						}
						recmdtn+='</table></div>';
						Ext.getCmp("optimizingCapacity").add(
						{
							xtype:'container',
							margin:'10 10 10 10',
							columnWidth:1,
							cls:'',
							html:recmdtn
							
						});
					}
					if(optimizationSummary != undefined){
						Ext.getCmp("optimizingCapacity").add({
							xtype:'container',
							margin:'10 10 10 10',
							columnWidth:1,
							html:optimizationSummaryTable
						});
					}

					//Summary View
					if(OptimizatnData.ServerDetails.Summary_columns != undefined && OptimizatnData.ServerDetails.Summary_dataArray != undefined)
					{
						//grid_Summary
						var me=this;
						var activePage=1;
						var gridColumn=OptimizatnData.ServerDetails.Summary_columns;
						var gridData=OptimizatnData.ServerDetails.Summary_dataArray;
						var mainColArray=new Array();
						for (var key in gridColumn)
						{
							var colAlign='center';
							mainColumn = gridColumn[key];
							if(mainColumn != undefined && mainColumn == 'Server Name'){
								colAlign='left';
							}
							mainColArray.push({
								header:mainColumn,
								sortable: true,
								align:colAlign,
//								minWidth:315,
								flex:1,
								dataIndex: mainColumn,
								doSort: function(state) {
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
												v1= isNaN(v1) ? 0 : v1;
												v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							});
						}
						var fields=[];
						for(var key in gridData[0])
						{
							fields.push(key);
						}
					//	fields.push('app');
						var storeObj = Ext.create('Ext.data.Store', {
							fields: fields,
							proxy : {
									type : 'pagingmemory',
									reader : {
										type: 'json', root : 'data', totalProperty : 'total'
									},
								},
							pageSize:5,	//gridPageSize is added in ErTracker.jsp
							autoLoad : true,
							data:gridData,
						});

						var isPagingHidden;
						if (gridData.length<5)
							isPagingHidden=true;
						else
							isPagingHidden=false;
						Ext.getCmp("grid_Summary").add({
							xtype:'customgrid',
							store:storeObj,
							sortableColumns:false,
							ui:'newGridPanel noHoverColor headerTextWrap',
							id:'mainGrid1',
							margin:'0 10 10 10',
							activePage:1,
							border:true,
							scroll:true,
							autoScroll:true,
							columns:mainColArray,
							forcefit:true,
							needtoFixColumn:true,
							bodyPadding:'0 0 0 0',
							listeners:{
								sortchange:function(ct, column, e, t, eOpts ){
									me.gridColIndexParam=column.getIndex();
									me.gridColStateParam=column.sortState;
									this.getStore().loadPage(activePage);
								},
								render:function(obj){
									Ext.defer(function() {
									},100);
								}
							},
							dockedItems:[{
								xtype:'pagingtoolbar',
								dock: 'bottom',
								cls:'newPagination',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params) && !isPagingHidden)
										{
											Ext.getCmp('mainGrid1').activePage = params.currentPage;
										}
										else
											Ext.getCmp('mainGrid1').activePage=1;
									}
								}
							}]
						});

					}
					if(OptimizatnData.ServerDetails.columns != undefined && OptimizatnData.ServerDetails.dataArray != undefined)
					{
						var me=this;
						var activePage=1;
						var gridColumn=OptimizatnData.ServerDetails.columns;
						var gridData=OptimizatnData.ServerDetails.dataArray;
						var mainColArray=new Array();
						var clWidth=100;
						for (var key in gridColumn)
						{
							mainColumn = gridColumn[key];
							if(mainColumn != undefined && mainColumn.indexOf('(%) '+perSessionTxtLwr) > -1){
								var subColArray = new Array();
								var subHdr=mainColumn.substring(mainColumn.indexOf("(%)")+3);
								var hdr=mainColumn.substring(0,mainColumn.indexOf("(%)")+3);
								var hdrTmp=mainColumn.substring(0,mainColumn.indexOf("(%)")-1);
								var cpuCurrent='';
								var currentResource='';
								var projectedResource='';
								if(hdrTmp != undefined && hdrTmp == usageCPUTxt){
									currentResource=currentCPUTxt;
									projectedResource=projectedCPUTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageMemoryTxt){
									currentResource=currentMemoryTxt;
									projectedResource=projectedMemoryTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageDiskTxt){
									currentResource=currentDiskTxt;
									projectedResource=projectedDiskTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageNetworkTxt){
									currentResource=currentNetworkTxt;
									projectedResource=projectedNetworkTxt;
								}
								subColArray.push({ 
									header: perSessionTxt,
									align:'center',
									width:90,
									dataIndex: mainColumn,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid_detailed').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;
														v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
//										value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
										return value;
									}
								});
								subColArray.push({ 
									header: currentTxt,
									align:'center',
									width:70,
									dataIndex:currentResource,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid_detailed').store;
										var field = this.getSortParam();
														ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
													v1= isNaN(v1) ? 0 : v1;

													v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
//										value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
										return value;
									}
								});
								subColArray.push({ 
									header: projectedTxt,
									width:80,
									align:'center',
									dataIndex: projectedResource,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid_detailed').store;
										var field = this.getSortParam();
													ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(v1!=undefined && v1.indexOf('$')>-1)
												v1 = v1.substring( 0, v1.indexOf('$') );
											if(v2!=undefined && v2.indexOf('$')>-1)
												v2 = v2.substring( 0, v2.indexOf('$') );
											if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										
										if(value != undefined && value.indexOf('$') > -1){
											value=value.substring(0,value.indexOf('$'));
											metaData.tdAttr = 'data-qtip="' + value + '"';
//											value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
											value='<div align="center"><table width="100%"><tr><td width="70%" align="right">'+value+'</td><td width="30%" align="left"><img src="/final/images/spacer.gif" class="iconArrowOrange" style="border:0px solid red;vertical-align:middle" border="0px" width="16px" height="16px"></td></tr></table></div>';
										}else{
											metaData.tdAttr = 'data-qtip="' + value + '"';
//											value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
											value='<div align="center"><table width="100%"><tr><td width="70%" align="right">'+value+'</td><td width="30%" align="left"><img src="/final/images/spacer.gif"  style="border:0px solid red;vertical-align:middle" border="0px" style="width:16px;height:16px"></td></tr></table></div>';
										}
										return value;
									}
								});
								mainColArray.push({ 
									header: hdr,
									dataIndex: hdr,
									sortable: false,
									resizable :false,
									columns:subColArray,
								})
							}
							else if(mainColumn != undefined && ( mainColumn.indexOf('(%) '+currentTxt) > -1 || mainColumn.indexOf('(%) '+projectedTxt) > -1)){
								continue;
							}
							else{
								var summaryby='';
								if(mainColumn != undefined && mainColumn == capacityTxt)
									summaryby='sum';
								var colAlign='center';
								if(mainColumn != undefined && mainColumn == serverNameTxt){
									clWidth=160;
									colAlign='left';
								}
								else{
									clWidth=100;
								}
								mainColArray.push({
									header:mainColumn,
									sortable: true,
									align:colAlign,
									summaryType: summaryby,
									summaryRenderer: function(value, summaryData, dataIndex) {
										if( dataIndex != undefined && dataIndex == serverNameTxt )
											return 'TOTAL';
										return value;
									},
									width:clWidth,
									dataIndex: mainColumn,
									doSort: function(state) {
										var ds = this.up('grid_detailed').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									}
								});
							}
						}
						for(var index in gridData)
						{
							var dataInfo = gridData[index];
							var suggestion=dataInfo.Suggestion;
							var recommendation=dataInfo.Recommendation;
							
							var subTable='<div style="margin: 5px 0px 5px 15px;"><table>';
							if(suggestion != undefined)
							{
								subTable+='<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><img src="/final/images/spacer.gif" class="iconArrowBullet" style="vertical-align:middle"/></td><td width="100%" style="border:0px;padding:0px">'+suggestion+'</td></tr>';
							}
							if(recommendation != undefined)
							{
								subTable+='<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><img src="/final/images/spacer.gif" class="iconArrowBullet" style="vertical-align:middle"/></td><td width="100%" style="border:0px;padding:0px">'+recommendation+'</td></tr>';
							}
							subTable+='</table></div>';
							gridData[index]['app']=subTable;
						}
						var fields=[];
						for(var key in gridData[0])
						{
							fields.push(key);
						}
						fields.push('app');
						var storeObj = Ext.create('Ext.data.Store', {
							fields: fields,
							proxy : {
									type : 'pagingmemory',
									reader : {
										type: 'json', root : 'data', totalProperty : 'total'
									},
								},
							pageSize:5,	//gridPageSize is added in ErTracker.jsp
							autoLoad : true,
							data:gridData,
						});

						var isPagingHidden;
						if (gridData.length<5)
							isPagingHidden=true;
						else
							isPagingHidden=false;

						Ext.getCmp('grid_detailed').add({
							xtype:'customgrid',
							store:storeObj,
							sortableColumns:false,
							ui:'newGridPanel noHoverColor headerTextWrap',
							id:'mainGrid',
							margin:'0 10 10 10',
							activePage:1,
							border:true,
							scroll:true,
							autoScroll:true,
							columns:mainColArray,
							bodyPadding:'0 0 0 0',
							plugins: [{
								ptype: 'rowexpander',
								selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
								expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
								expandOnEnter : false,
								collapsible: true,
								animCollapse: false,
								rowBodyTpl: [
									'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
								]
							}],
							features: [{
								ftype: 'summary',
								dock: 'bottom'
							}],
							viewConfig:
							{
								stripeRows: true,
								getRowClass: function (record, rowIndex, rowParams, store)
								{
									if (record.data.app.length>0)
									{
										return ;
									}
									else
									{
										return 'hidePlus';
									}
								}
							},
							listeners:{
								sortchange:function(ct, column, e, t, eOpts ){
									me.gridColIndexParam=column.getIndex();
									me.gridColStateParam=column.sortState;
									this.getStore().loadPage(activePage);
								},
								render:function(obj){
									Ext.defer(function() {
									},100);
								}
							},
							dockedItems:[{
								xtype:'pagingtoolbar',
								dock: 'bottom',
								cls:'newPagination',
								displayInfo: true,
								store: storeObj,
								hidden:isPagingHidden,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{
										if(!Ext.isEmpty(params) && !isPagingHidden)
										{
											Ext.getCmp('mainGrid').activePage = params.currentPage;
										}
										else
											Ext.getCmp('mainGrid').activePage=1;
									}
								}
							}]
						});
					}
					//servertableViewBy
					if(Ext.getCmp('grid_Summary') != undefined && Ext.getCmp('grid') != undefined){
						if(servertableViewBy != undefined && servertableViewBy == 'detailed'){
							Ext.getCmp('grid_Summary').hide();
							Ext.getCmp('grid').show();
							Ext.getCmp('server_view').setValue("detailed");
						}else{
							Ext.getCmp('grid').hide();
							Ext.getCmp('grid_Summary').show();
							Ext.getCmp('server_view').setValue("summary");
						}
					}
				}
				/*var showpsvData=reportData.showPvsData;
				var pvsEnvData=reportData.PVSEnvData;
				if(showpsvData == 'Yes' && pvsEnvData != undefined){
					var pvshtml='<table><tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><div class="iconArrowBullet" style="vertical-align:middle;margin-top: 1px;"></div></td><td width="100%" style="border:0px;padding:0px">'+pvsEnvData.for25Percent+'</td></tr>'
					pvshtml+=	'<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><div class="iconArrowBullet" style="vertical-align:middle;margin-top: 1px;"></div></td><td width="100%" style="border:0px;padding:0px">'+pvsEnvData.for50Percent+'</td></tr>'
					pvshtml+=	'<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><div class="iconArrowBullet" style="vertical-align:middle;margin-top: 1px;"></div></td><td width="100%" style="border:0px;padding:0px">'+pvsEnvData.for75Percent+'</td></tr></table>'
				//pvsEnvData
					resultObj.add({
						xtype: 'panel',
						margin:'0 10 10 10',
						ui:'newGraphPanel',
						title:'PVS Environment',
						items:[
						{
							xtype:'container',
							margin:'10 20 20 20',
							html:pvshtml
						}]
					});
				}*/
			}
		}
		Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
	},
	openNewPopupWindow:function(qryString){
		initLdgMask.show();
		var nn=qryString.substring(qryString.indexOf("?")+1);
		var qString='/final/servlet/com.eg.ErCitrixCapacityPlanningReportC?chrt=yes&fromDrildown=true&'+nn;
		 Ext.Ajax.request({
				url: qString,
				method: 'POST',
				success: function(b) {
					if (b.status == 200 && !Ext.isEmpty(b.responseText)) {
						var c = b.responseText;
						var jsonData=Ext.decode(b.responseText);
						var gridData=jsonData.GridObj;
						var gWindow = Ext.create('utilities.GenericWindow', {
							flex : 1,
							scroll: true,
							resizable:false,
							autoScroll: true,
							layout: 'fit',
							border:false,
							id:'GenericWindowId2',
							ghost:false,
							closeAction: 'destroy',
							closable:true,
							modal:true,
							ui:'newPopupWindow newplainHeader',
							header:true,
							width:1000,
							height:450,
							header:{
								style:{
									'padding':'4px 10px 10px 10px'
								}
							},
							title:jsonData.chartTitle,
							layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'start'
							},
							listeners:{
								'boxready':function(){
									initLdgMask.hide();
								},
								'close':function(){
									var win = Ext.getCmp('GenericWindowId2');
									if(win)win[win.closeAction]();
								},
								'hide':function(){
									var win = Ext.getCmp('GenericWindowId2');
									if(win)win[win.closeAction]();
								},
							},
							tools:[
								{
									xtype: 'container',
									margin:'0 3px 0 3px',
									cls: 'iconBg',
									disabled: false,
									items: [{
										xtype: 'button',
										iconCls: 'iconPdfDownload',
										style: {
											background: 'none',
											border: '0px'
										},
										tooltip:'Save as PDF',
										listeners:{
											'click':function(){
												var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?&pdf=yes&&isFromDrillDown=y&drillSes=yes&pageWidthProces=1400&"+nn;
												if (Ext.isEmpty(appConstants.erUtils))
													appConstants.erUtils = Ext.widget("erutils");
												appConstants.erUtils.savePDF(s_qryString);
											}
										}
									}]
								},{
									xtype: 'container',
									margin:'0 3px 0 3px',
									cls: 'iconBg',
									disabled: false,
									items: [{
										xtype: 'button',
										iconCls: 'iconPrinter',
										style: {
											background: 'none',
											border: '0px'
										},
										tooltip:'PRINT',
										listeners:{
											'click':function(){
												parent.printWindowFn(qryString);
											}
										}
									}]
								},{
									xtype: 'container',
									margin:'0 3px 0 3px',
									cls: 'iconBg',
									disabled: false,
									items: [{
										xtype: 'button',
										iconCls: 'iconCsv',
										style: {
											background: 'none',
											border: '0px'
										},
										tooltip:'CSV',
										listeners:{
											'click':function(){
												window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
											}
										}
									}]
								},{
									xtype:'tbseparator',
									margin:'0 5 0 5',
									height:20,
								}
							],
						}).show();
						var me=this;
						var activePage=1;
						var gridColumn=gridData.columnsTmp;
						var gridData=gridData.dataArrayTmp;
						var mainColArray=new Array();
						var clWidth=100;
						for (var key in gridColumn)
						{
							mainColumn = gridColumn[key];
							if(mainColumn != undefined && mainColumn.indexOf('(%) '+perSessionTxtLwr) > -1){
								var subColArray = new Array();
								var subHdr=mainColumn.substring(mainColumn.indexOf("(%)")+3);
								var hdr=mainColumn.substring(0,mainColumn.indexOf("(%)")+3);
								var hdrTmp=mainColumn.substring(0,mainColumn.indexOf("(%)")-1);
								var currentResource='';
								var projectedResource='';
								if(hdrTmp != undefined && hdrTmp == usageCPUTxt){
									currentResource=currentCPUTxt;
									projectedResource=projectedCPUTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageMemoryTxt){
									currentResource=currentMemoryTxt;
									projectedResource=projectedMemoryTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageDiskTxt){
									currentResource=currentDiskTxt;
									projectedResource=projectedDiskTxt;
								}
								else if(hdrTmp != undefined && hdrTmp == usageNetworkTxt){
									currentResource=currentNetworkTxt;
									projectedResource=projectedNetworkTxt;
								}
								subColArray.push({ 
									header: perSessionTxt,
									align:'center',
									width:90,
									dataIndex: mainColumn,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
													v1= isNaN(v1) ? 0 : v1;

													v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
//										value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
										return value;
									}
								});
								subColArray.push({ 
									header: currentTxt,
									align:'center',
									width:70,
									dataIndex: currentResource,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid').store;
										var field = this.getSortParam();
														ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
													v1= isNaN(v1) ? 0 : v1;

													v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
//										value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
										return value;
									}
								});
								subColArray.push({ 
									header: projectedTxt,
									width:80,
									align:'center',
									dataIndex: projectedResource,
									sortable: true,
									doSort: function(state) {
										var ds = this.up('grid').store;
										var field = this.getSortParam();
													ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
											{
												v2=new Date(v2).getTime(); 
												v1=new Date(v1).getTime(); 
											}
											else if(!isNaN(v1) && !isNaN(v2))
											{
												v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
												v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
												if (state=='ASC')
												{
													v1= isNaN(v1) ? 999999 : v1;
													v2= isNaN(v2) ? 999999 : v2;
												}
												else
												{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
												}
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										
										if(value != undefined && value.indexOf('$') > -1){
											value=value.substring(0,value.indexOf('$'));
											metaData.tdAttr = 'data-qtip="' + value + '"';
//											value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
											value='<div align="center"><table width="100%"><tr><td width="70%" align="right">'+value+'</td><td width="30%" align="left"><img src="/final/images/spacer.gif" class="iconArrowOrange" style="border:0px solid red;vertical-align:middle" border="0px" width="16px" height="16px"></td></tr></table></div>';
										}else{
											metaData.tdAttr = 'data-qtip="' + value + '"';
											value = Ext.getCmp('mainGrid').getDecimalAlignFormat(value);
											value='<div align="center"><table width="100%"><tr><td width="70%" align="right">'+value+'</td><td width="30%" align="left"><img src="/final/images/spacer.gif"  style="border:0px solid red;vertical-align:middle" border="0px" style="width:16px;height:16px"></td></tr></table></div>';
										}
										return value;
									}
								});
								mainColArray.push({ 
									header: hdr,
									dataIndex: hdr,
									sortable: false,
									resizable :false,
									columns:subColArray,
								})
							}
							else if(mainColumn != undefined && ( mainColumn.indexOf('(%) Current') > -1 || mainColumn.indexOf('(%) Projected') > -1)){
								continue;
							}
							else{
								var summaryby='';
								if(mainColumn != undefined && mainColumn == 'Projected Sessions')
									summaryby='sum';
								var colAlign='center';
								if(mainColumn != undefined && mainColumn == 'Server Name'){
									clWidth=160;
									colAlign='left';
								}
								else{
									clWidth=100;
								}
								mainColArray.push({
									header:mainColumn,
									sortable: true,
									align:colAlign,
									summaryType: summaryby,
									summaryRenderer: function(value, summaryData, dataIndex) {
										if( dataIndex != undefined && dataIndex == 'Server Name' )
											return 'TOTAL';
										return value;
									},
									width:clWidth,
									dataIndex: mainColumn,
									doSort: function(state) {
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2){
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
													v1= isNaN(v1) ? 0 : v1;
													v2= isNaN(v2) ? 0 : v2;
													}
												}
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										});
									},
									renderer: function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									}
								});
							}
						}
						for(var index in gridData)
						{
							var dataInfo = gridData[index];
							var suggestion=dataInfo.Suggestion;
							var recommendation=dataInfo.Recommendation;
							
							var subTable='<div style="margin: 5px 0px 5px 15px;"><table>';
							if(suggestion != undefined)
							{
								subTable+='<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><img src="/final/images/spacer.gif" class="iconArrowBullet" style="vertical-align:middle"/></td><td width="100%" style="border:0px;padding:0px">'+suggestion+'</td></tr>';
							}
							if(recommendation != undefined)
							{
								subTable+='<tr><td style="width:10px;border:0px;padding:0px" valign="top" align="left"><img src="/final/images/spacer.gif" class="iconArrowBullet" style="vertical-align:middle"/></td><td width="100%" style="border:0px;padding:0px">'+recommendation+'</td></tr>';
							}
							subTable+='</table></div>';
							gridData[index]['app']=subTable;
						}
						var fields=[];
						for(var key in gridData[0])
						{
							fields.push(key);
						}
						fields.push('app');
						var storeObj = Ext.create('Ext.data.Store', {
							fields: fields,
							proxy : {
									type : 'pagingmemory',
									reader : {
										type: 'json', root : 'data', totalProperty : 'total'
									},
								},
							pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
							autoLoad : true,
							data:gridData,
						});

						var isPagingHidden;
						if (gridData.length<gridPageSize)
							isPagingHidden=true;
						else
							isPagingHidden=false;

						Ext.getCmp("GenericWindowId2").add({
								xtype:'customgrid',
								store:storeObj,
								sortableColumns:false,
								ui:'newGridPanel noHoverColor headerTextWrap',
								id:'mainGrid',
								margin:'0 10 10 10',
								activePage:1,
								border:true,
								scroll:true,
								autoScroll:true,
								columns:mainColArray,
								bodyPadding:'0 0 0 0',
								plugins: [{
									ptype: 'rowexpander',
									selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
									expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
									expandOnEnter : false,
									collapsible: true,
									animCollapse: false,
									rowBodyTpl: [
										'<div style="padding:0px 0px 0px 0px;display:inline-block;position:relative;width:100%;">{app}</div>',	
									]
								}],
								features: [{
									ftype: 'summary',
									dock: 'bottom'
								}],
								viewConfig:
								{
									stripeRows: true,
									getRowClass: function (record, rowIndex, rowParams, store)
									{
										if (record.data.app.length>0)
										{
											return ;
										}
										else
										{
											return 'hidePlus';
										}
									}
								},
								listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										me.gridColIndexParam=column.getIndex();
										me.gridColStateParam=column.sortState;
										this.getStore().loadPage(activePage);
									},
									render:function(obj){
										Ext.defer(function() {
										},100);
									}
								},
								dockedItems:[{
									xtype:'pagingtoolbar',
									dock: 'bottom',
									cls:'newPagination',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying topics {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params) && !isPagingHidden)
											{
												Ext.getCmp('mainGrid').activePage = params.currentPage;
											}
											else
												Ext.getCmp('mainGrid').activePage=1;
										}
									}
								}]
						});
					}
				},
				failure: function(){
					initLdgMask.hide();
				}
			});
	},
	openSmallPopupWindow:function(resultDatas,qString){
		var dataoption="/final/reporter/ErCitrixCapacityPlanningReport.jsp?isSubmit=true&enableBack=true&ForPopup=yes"+qString;
		var vals=resultDatas.split(",");
		var popupData='<div class="newTableWithoutHeader" style="margin:0px 10px 10px 10px;height:244px"><table width="100%" cellpadding="0px" cellspacing="0px" border="0px"><tbody>';
		for ( var key in vals )
		{
			var dataoption="/final/reporter/ErCitrixCapacityPlanningReport.jsp?isSubmit=true&component="+vals[key]+"&ForPopup=yes"+qString;
			popupData+='<tr><td style="cursor:pointer;"><a href='+dataoption+'>'+vals[key]+'</a></td></tr>';

		}
		popupData+='</tbody></table></div>';
		var gWindow = Ext.create('utilities.GenericWindow', {
			flex : 1,
			scroll: false,
			resizable:false,
			autoScroll: false,
			layout: 'fit',
			border:false,
			id:'GenericWindowId',
			ghost: true,
			closeAction: 'destroy',
			closable:false,
			ui:'egNewPlainWindow',
			header:false,
			layout : {
				type : 'vbox',
				align : 'stretch',
				pack : 'center'
			},
			items:[
			{
				xtype:'panel',
				title:'<img src="/final/images/spacer.gif" class="iconDefaultServer" style="vertical-align:middle;margin:-2px 5px 0px 0px" /><span class="newLineRight" ></span><span class="font_normal13" style="padding-left:5px">Servers - <span class="font_bold13">'+vals.length+' nos.</span></span>',
				ui:'newOuterPanelForWindow',
				frame:false,
				closable:true,
				closeAction:'destroy',
				width:225,
				height:292,
				
				html:popupData,
				listeners:{
					'close':function(){
						var win = Ext.getCmp('GenericWindowId');
						if(win)win[win.closeAction]();
					},
					'hide':function(){
						var win = Ext.getCmp('GenericWindowId');
						if(win)win[win.closeAction]();
					}
				},
			}]
		}).show();
	},
	loadTools: function()
	{
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
			);

	},
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:580,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'396px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'CitrixCapacityPlanningSettings',
				parent:this
			}
		],
		renderTo:'citrixcapacityForm'
		});

	},
	afterSettingsRender:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['er_excwe'] = screenLabels['reporter.common.excludeweekends'];
		ObjectArr['timeperiodLbl'] = screenLabels['reporter.common.Timeperiod'];
		ObjectArr['fromTimeLbl'] = screenLabels['reporter.common.From'];
		ObjectArr['toTimeLbl'] = screenLabels['reporter.common.To'];
		ObjectArr['fromHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['fromMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['toHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['toMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['reportGeneration'] = screenLabels['reporter.consolidated.reportGeneration'];
		ObjectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];

		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});


		this.loadScreenLabels( settingsForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];
		var excludeWeekCombo = appConstants.publicJSON['excludeWeekCombo'];
		var excludeWeekSelected = selectedData['excludeWeekSelected'];
		if ( !Ext.isEmpty( excludeWeekCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_excwe', excludeWeekCombo, excludeWeekSelected);
		}
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		if ( !Ext.isEmpty( excludeMsgs ) )
		{
		//	Ext.getCmp('excludeDays').update(excludeMsgs);
		}
		else
		{
		//	Ext.getCmp('excludeDays').update('');
		}
//		var componentVal = Ext.getCmp('er_option').getValue();
//		if(componentVal != undefined && componentVal == 'Zone')
//		{
//			Ext.getCmp('ShowpvsEnvironment').show();
//		}
//		else{
//			Ext.getCmp('ShowpvsEnvironment').hide();
//		}

		settingsForm.findField('timefrom').setValue(selectedData['timePeriodFromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodFromMinSelected']);

		settingsForm.findField('timeto').setValue(selectedData['timePeriodToHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodToMinSelected']);

		var reportGenCombo = appConstants.publicJSON['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenSelected'];
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}
		updatingAppSettings();
	},
	validateAndCloseSettings:function()
	{
		var result = this.validateSettings();
		if(result)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.formSubmit(Ext.getCmp('submitViaSetting'));
		}
	},
	afterCapacityFormRender: function()
	{
		this.hideResult();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJSON['TITLE']);
		var mainForm = this.getCitrixCapacityPlanningForm().getForm();
		var selectedData = appConstants.publicJSON['selectedValues'];
		var anlyzeCombo = appConstants.publicJSON['anlyzeCombo'];
		var er_optionSelected = selectedData['er_option'];
		if ( !Ext.isEmpty( anlyzeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_option',anlyzeCombo, er_optionSelected);
		}
		var screenLabels = appConstants.publicJSON['screenLabels'];
		if(er_optionSelected!=undefined && er_optionSelected!='Component')
		{
			var comboObject = Ext.getCmp('er_site');
			comboObject.setFieldLabel(screenLabels['reporter.common.' + er_optionSelected]);
			var siteCombo = appConstants.publicJSON['siteCombo'];
			var er_siteSelected = selectedData['er_site'];
			if ( !Ext.isEmpty( siteCombo ) )
			{
				this.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
			}
			else
			{
				this.insertNotApplicable(mainForm, 'er_site');
			}
			Ext.getCmp('er_site').show();
		}
		else
		{
			Ext.getCmp('er_site').hide();
		}




		var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
		var er_comptypeSelected = selectedData['er_comptype'];

		if ( !Ext.isEmpty( compTypeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
		}


		var analyseComp=Ext.getCmp('er_option');
		if(analyseComp != undefined){
			var analyseCompVal= analyseComp.getValue();
			if(analyseCompVal != undefined && analyseCompVal == 'Component'){
				Ext.getCmp('er_componentname').show();
			}else{
				Ext.getCmp('er_componentname').hide();
			}
		}
		var compCombo = appConstants.publicJSON['componentCombo'];
		var er_comptypeSelected = selectedData['er_componentname'];

		if ( !Ext.isEmpty( compCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_componentname', compCombo, er_comptypeSelected);
		}
		
		appConstants.rawDataForComponents = appConstants.publicJSON['componentCombo'];


		var timelineCombo = appConstants.publicJSON['timelineCombo'];
		var selectedTimeline = selectedData['selectedTimeline'];
		if ( !Ext.isEmpty( timelineCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_timeline', timelineCombo, selectedTimeline);
			this.changeTimeline();
		}

		mainForm.findField('er_mode').setValue(selectedData['selectedGraphMode']);

		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		startdateObj.setValue(selectedData['startDateForDisplay']);
		startdateObj.dataArray =selectedData['startDate'];
		startHourObj.setValue(selectedData['startHourForDisplay']);
		startHourObj.dataArray = selectedData['startHour'];
		enddateObj.setValue(selectedData['endDateForDisplay']);
		enddateObj.dataArray =selectedData['endDate'];
		endHourObj.setValue(selectedData['endHourForDisplay']);
		endHourObj.dataArray = selectedData['endHour'];
		stmin =selectedData['startMinForDisplay'];
		enmin = selectedData['endMinForDisplay'];
		mgr_stmin =selectedData['startmin'];
		mgr_enmin = selectedData['endmin'];

		var hiddenFields =  appConstants.publicJSON["hiddens"];
			var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];

		if(!hideBackButton){
			Ext.getCmp('CitrixCapacityPlanningForm').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJSON['ID']
				}
			);
		}
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			this.getResultpanel().removeAll();
			this.getResultpanel().hide();
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ( appConstants.isSubmit == 'true' && from_favorite != "Yes")
		{
			this.getResultpanel().removeAll();
			this.getResultpanel().show();
			if ( selectedData['reportGenSelected'] == 'foreground')
			{
				var resultData = appConstants.publicJSON['RESULTS'];
				if ( !Ext.isEmpty( resultData ) )
				{
					this.formSubmit(Ext.getCmp('submit'));
				}
				else
				{
					this.getResultpanel().add(
						{
							xtype: 'container',
							height: 270,
							html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
						}
					);
				}
			}
			else
			{
				var resultData = appConstants.publicJSON['backgroundResults'];
				this.loadBackground(resultData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.formSubmit(Ext.getCmp('submit'));
			}
		}
	},
	validateSettings: function()
	{
		var isSettingsOk = true;
		var settingsForm = this.getCitrixCapacityPlanningSettings().getForm();
		var reportgenVal = settingsForm.findField('reportGeneration').getValue();
		if ( reportgenVal!=null && (reportgenVal == 'background' || reportgenVal == 'background'))
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			this.generateResult();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.setValue("");
			reportNameObj.show();
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);

		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
		if(isEnabled){
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}else
			value = appConstants.publicJSON.selectedValues[jsonParam];

		return value;
	},
});
