var fromRunButton = true;
Ext.define('citrixCapacityPrediction.controller.Main',{
extend:'Ext.app.Controller',
views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'resultpanel', ref: 'resultpanel'},
		{selector:'CitrixCapacityPredictionForm', ref:'CitrixCapacityPredictionForm'},
		{selector:'CitrixCapacityPredictionSettings', ref: 'CitrixCapacityPredictionSettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector:'backGroundPanel',ref: 'backGroundPanel'},
		{selector:'ReporterSettings',ref: 'ReporterSettings'},
	],
	init:function(){ 
		this.control({
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities':
			{
				'afterrender':this.loadTools
			},
			'CitrixCapacityPredictionSettings':
			{
				'afterrender':this.afterSettingsRender
			},
			'CitrixCapacityPredictionForm':
			{
				'boxready': this.afterCapacityFormRender
			},
			'CitrixCapacityPredictionForm combo[id="er_comptype"]':
			{
				'select': this.changeCompType
			},
			'CitrixCapacityPredictionForm combo[id="er_option"]':
			{
				'select': this.changeAnalysBy
			},
			'CitrixCapacityPredictionForm combo[id="er_site"]':
			{
				'select': this.changeBySite
			},
			'CitrixCapacityPredictionSettings combo[id="er_excwe"]':
			{
				'select': this.changeExcludeWeekEnd
			},
			'CitrixCapacityPredictionSettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'CitrixCapacityPredictionSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'CitrixCapacityPredictionSettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			},
			'CitrixCapacityPredictionForm button[id="submit"]':
			{
				'click': this.submitReport
			},
			'CitrixCapacityPredictionForm button[name="save"]':
			{
				'click': this.goTo
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
		});
	},

	goTo: function (btn) 
	{
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title : alert_text,
				msg : timelineErrTxt,
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.showFavorites();
		}else{
			this.showSchedules();
		}
	},
	showFavorites: function( obj )
	{
		this.updateQueryString();
		var qString = appConstants.queryString;
		var hiddenFields =  appConstants.publicJSON["hiddens"];
		var favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&er_view=GRAPH'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId='+favorite_id;
			if(target!=undefined&&target.indexOf('er_rtype')==-1)
				target += '&er_rtype=Citrix Servers';
		if (appConstants.formButtonId=='save')
		{
			if((favorite_id=="null" ||  favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
				favorite_id=appConstants.favorite_id;

			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}

	},
	showSchedules: function( obj )
	{
		if ( this.checkValidate(false) )
		{
			this.updateQueryString();
			var qString = appConstants.queryString;
			var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&er_rtype=Citrix Server&com.eg.CSRF_NONCE='+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		var prntURL=appConstants.publicJSON['PDF_URL'];
		if(Ext.getCmp('grid') != undefined && Ext.getCmp('grid').isHidden())
		{
			prntURL+='&isSummaryView=yes';
		}
		else if(Ext.getCmp('grid_Summary') != undefined && Ext.getCmp('grid_Summary').isHidden())
		{
			prntURL+='&isSummaryView=no';
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(prntURL);
	},
	bookletQuery: function(obj)
	{
		return appConstants.publicJSON['PDF_URL'];
	},
	bookletScheduleQuery: function(obj)
	{
		this.updateQueryString();
		var bookletquery=appConstants.queryString+'&er_rtype=Citrix Server';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		var prntURL=appConstants.publicJSON['PRINT_URL'];
		if(Ext.getCmp('grid') != undefined && Ext.getCmp('grid').isHidden())
		{
			prntURL+='&isSummaryView=yes';
		}
		else if(Ext.getCmp('grid_Summary') != undefined && Ext.getCmp('grid_Summary').isHidden())
		{
			prntURL+='&isSummaryView=no';
		}
		parent.printWindowFn( prntURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	changeReportGeneration: function( obj )
	{
		var settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var reportGenVal = settingsForm.findField('reportGeneration').getValue();
		var bgReportObj = settingsForm.findField('bgReportName');
		if ( reportGenVal == 'background' )
		{
			bgReportObj.show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			bgReportObj.hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}

		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},
	changeTimeline: function( obj )
	{
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
		var getTimelineVal = mainForm.findField('er_timeline').getValue();
		var stDateObj = mainForm.findField('er_stdate');
		var endDateObj = mainForm.findField('er_enddate');
		var stHrObj = mainForm.findField('er_sthr');
		var endHrObj = mainForm.findField('er_endhr');
		if (getTimelineVal == 'Any')
		{
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		else
		{
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}
	},
	/* changeExcludeWeekEnd: function ( obj )
	{
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		var weenendOn=Ext.getCmp("er_excwe").getValue();
		if(weenendOn =='Yes')
			Ext.getCmp('excludeDays').update(excludeMsgs);
		else
			Ext.getCmp('excludeDays').update('');
		if ( !Ext.isEmpty( obj ) )
		{
			this.hideResult();
		}
	},*/
	changeCompType: function( obj )
	{
		if (!Ext.isEmpty(obj))
		{
			this.hideResult();
			var url = '/final/reporter/ErCitrixCapacityPredictionReportJson.jsp';
			var er_optionVal = Ext.getCmp('er_option').getValue()
			var params = 'er_option='+er_optionVal;
			if(er_optionVal!='Component')
			{
				params+= '&er_site='+Ext.getCmp('er_site').getValue();
			}
			params+= '&er_comptype='+Ext.getCmp('er_comptype').getValue();
			this.callAjaxRequest(obj,url,params);
		}
	},
	changeAnalysBy: function(obj)
	{
		var objVal=obj.getValue();
		if(objVal != undefined && objVal == 'Zone')
		{
			Ext.getCmp('er_componentname').hide();
			Ext.getCmp('er_site').show();
		}
		else
		{
			Ext.getCmp('er_componentname').show();
			Ext.getCmp('er_site').hide();
		}
		this.hideResult();
		var url = '/final/reporter/ErCitrixCapacityPredictionReportJson.jsp';
		var params = 'er_option='+Ext.getCmp('er_option').getValue();
		this.callAjaxRequest(obj,url,params);
	},
	changeBySite: function( obj )
	{
		if (!Ext.isEmpty(obj))
		{
			this.hideResult();
			var url = '/final/reporter/ErCitrixCapacityPredictionReportJson.jsp';
			var params = 'er_option='+Ext.getCmp('er_option').getValue();
			params+= '&er_site='+Ext.getCmp('er_site').getValue();
			this.callAjaxRequest(obj,url,params);
		}
	},
	callAjaxRequest:function(obj,url,params)
	{
		var me=this;
		initLdgMask.show();
		Ext.Ajax.request({
			url: url,
			params: params,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					initLdgMask.hide();
					me.loadAjaxSucess(obj);
				}
			}
		});
	},
	loadAjaxSucess:function(obj)
	{
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
		if(obj.id=='er_option' || obj.id=='er_site' || obj.id=='er_comptype')
		{
			var objVal = obj.getValue();
			var screenLabels = appConstants.publicJSON['screenLabels'];
			var selectedData = appConstants.publicJSON['selectedValues'];
			if(obj.id=='er_option')
			{
				if(objVal != undefined && objVal != 'Component')
				{
					var comboObject = Ext.getCmp('er_site');
					comboObject.setFieldLabel(screenLabels['reporter.common.siteLabel']);
					var siteCombo = appConstants.publicJSON['siteCombo'];
					var er_siteSelected = selectedData['er_site'];
					if ( !Ext.isEmpty( siteCombo ) )
					{
						this.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
					}
					else
					{
						this.insertNotApplicable(mainForm, 'er_site');
					}
				}
			}
			if(obj.id=='er_option' || obj.id=='er_site')
			{
				var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
				var er_comptypeSelected = selectedData['er_comptype'];
				if ( !Ext.isEmpty( compTypeCombo ) )
				{
					this.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
				}
				else
				{
					this.insertNotApplicable(mainForm, 'er_comptype');
				}
			}
			var componentCombo = appConstants.publicJSON['componentCombo'];
			var selectedComp = selectedData['er_componentname'];
			if ( !Ext.isEmpty( componentCombo ) )
			{
				this.setValueWithOptionInList(mainForm, 'er_componentname', componentCombo, selectedComp);
			}
			else
			{
				this.insertNotApplicable(mainForm, 'er_componentname');
			}
		}
	},
	hideResult: function()
	{
		this.getResultpanel().hide();
		this.getResultpanel().removeAll();
		this.disableTools();
	},
	disableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
	},
	getHiddenQstr: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		var hiddenQstr = '';
		for ( var key in hiddens )
		{
			if ( key == 'forwardto' )
			{
				continue;
			}
			hiddenQstr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQstr;
	},
	checkValidate: function(flag)
	{
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
			var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var zone=mainForm.findField('er_site')
		var er_Comp=mainForm.findField('er_componentname')
		var er_option=mainForm.findField('er_option').getValue();
		if((er_option!=null || er_option!=undefined) && er_option!="Component" )
		{
			if(zone.getValue() == '-1')
			{
				Ext.MessageBox.show({
				title: alert_text,
				msg: 'Please select a valid Zone',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}else if((er_option!=null || er_option!=undefined) && er_option =="Component" ){
			if(er_Comp.getValue() == '-1'){
				Ext.MessageBox.show({
				title: alert_text,
				msg: 'Please select a valid Component',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
		}
		var compType=mainForm.findField('er_comptype');
		if( compType.getValue() == '-1')
		{
			Ext.MessageBox.show({
			title: alert_text,
				msg: 'Please select a valid Component Type',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}

		var hiddenJSON = appConstants.publicJSON['hiddens'];
		var er_usertimeline = hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = mainForm.findField('er_stdate').getValue();
		tmpStartDate.setHours(mainForm.findField('er_sthr').getValue());
		var tmpEndDate = mainForm.findField('er_enddate').getValue();
		tmpEndDate.setHours(mainForm.findField('er_endhr').getValue());

		var timeFrom =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timeTo =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minFrom =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var minTo =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');

		if (!checkTimePeriod(timeFrom, minFrom, timeTo, minTo))
		{
			return false;
		}
		if (er_usertimeline != '-1')
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: alert_text,
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: alert_text,
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = hiddenJSON['limitforbg'];
		var reportgenVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var isSettingsOk = true;
		if ( reportgenVal!=null && reportgenVal == 'foreground' )
		{
			/*if(flag)
			{
				if ( !Ext.isEmpty(limitforbg ) )
				{
					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
			}*/
		}
		else
		{
			var reportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
	},
	submitReport: function(obj)
	{
		var me = this;
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
		var starthr = mainForm.findField('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = mainForm.findField('er_enddate').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		enddate.setHours(endhr);
		this.updateQueryString();
		appConstants.queryString += '&isSubmit=true&call=json';
		var result = checkDateTime(startdate, enddate);
		if (!result) 
		{
			return;
		}
		if (!me.checkValidate(true))
		{
			return;
		}
		this.generateResult();
	},
	generateResult : function()
	{
		var me = this;
		var qstr = appConstants.queryString;
		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var remoteURL = '';
		
		if ( er_reportgenrationVal == 'foreground' )
		{
			remoteURL = '/final/servlet/com.eg.ErCitrixCapacityPredictionReportC';
		}
		else
		{
			remoteURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
			qstr += '&forwardto=ErCitrixCapacityPredictionReportJson';
		}
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		initLdgMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: qstr,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					initLdgMask.hide();
					var jsonText = response.responseText;
					appConstants.publicJSON = Ext.decode(jsonText);
					me.getResultpanel().removeAll();
					me.getResultpanel().show();
					var resultData = appConstants.publicJSON['RESULT_DATA'];
					var noData = appConstants.publicJSON['NO_DATA'];
					if (er_reportgenrationVal == 'foreground')
					{
						if (!Ext.isEmpty(resultData))
						{
							if(noData!=undefined && noData=='yes')
							{
								me.getNomeasurepanel().show();
								me.getResultpanel().hide();
							}
							else
							{
								me.loadData(resultData);
								me.enableTools();
							}
						}
						else
						{
							me.getNomeasurepanel().show();
							me.getResultpanel().hide();
						}
					}
					else
					{
						resultData = appConstants.publicJSON['backgroundResults'];
						me.loadBackground(resultData);
					}
				}
			}
		});
	},
	updateQueryString: function()
	{
		var qstr = '';
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
		var settingsForm =null;
		if(isSettingsEnabled)
			 settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_option = mainForm.findField('er_option').getValue();
		var er_siteVal = mainForm.findField('er_site').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var startdateVal = mainForm.findField('er_stdate').dataArray;
		var enddateVal = mainForm.findField('er_enddate').dataArray;
		var starthrVal = mainForm.findField('er_sthr').dataArray;
		var er_endhrVal = mainForm.findField('er_endhr').dataArray;
		var er_modeVal = mainForm.findField('er_mode').getValue();
		var er_optionVal = mainForm.findField('er_option').getValue();
		var er_compname = mainForm.findField('er_componentname').getValue();
		var er_excweVal = this.getSettingsFieldValue(settingsForm,'er_excwe',isSettingsEnabled,'excludeWeekSelected');
		var timefromVal =this.getSettingsFieldValue(settingsForm,'timefrom',isSettingsEnabled,'timePeriodFromHrSelected');
		var timetoVal =this.getSettingsFieldValue(settingsForm,'timeto',isSettingsEnabled,'timePeriodToHrSelected');
		var minfromVal =this.getSettingsFieldValue(settingsForm,'minfrom',isSettingsEnabled,'timePeriodFromMinSelected');
		var mintoVal =this.getSettingsFieldValue(settingsForm,'minto',isSettingsEnabled,'timePeriodToMinSelected');

		var er_reportgenrationVal = this.getSettingsFieldValue(settingsForm,'reportGeneration',isSettingsEnabled,'reportGenSelected');
		var bgReportName = this.getSettingsFieldValue(settingsForm,'bgReportName',isSettingsEnabled,'reportName');
		bgReportName=checkFileName(bgReportName);
		qstr +=  this.getHiddenQstr();
		qstr +=  '&er_timeline='+encodeURIComponent(er_timelineVal)
				+'&startdate='+encodeURIComponent(startdateVal)+'&enddate='+encodeURIComponent(enddateVal)
				+'&starthr='+encodeURIComponent(starthrVal)+'&endhr='+encodeURIComponent(er_endhrVal)
				+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin
				+'&timefrom='+encodeURIComponent(timefromVal)+'&timeto='+encodeURIComponent(timetoVal)
				+'&minfrom='+encodeURIComponent(minfromVal)+'&minto='+encodeURIComponent(mintoVal)
				+'&er_mode='+encodeURIComponent(er_modeVal)+'&er_excwe='+encodeURIComponent(er_excweVal)
				+'&er_reportgenration='+encodeURIComponent(er_reportgenrationVal)+'&bg_reportname='+encodeURIComponent(bgReportName)
		qstr +='&er_comptype='+encodeURIComponent(er_comptype);
		qstr +='&er_option='+encodeURIComponent(er_option);
		if(er_option != null && er_option == 'Component')
		{
			qstr +='&er_component='+encodeURIComponent(er_compname);
		}
		qstr +='&er_site='+encodeURIComponent(er_siteVal);

		qstr+="&er_RmDispName="+encodeURIComponent(appConstants.er_RmDispName);
		
		if(!fromRunButton)
		{
			qstr+="&fromRunButton=no";
			if(Ext.getCmp('factorSlider')!=undefined)
			{
				qstr+="&increaseBy="+Ext.getCmp('factorSlider').getValue();
			}
		}
		else
		{
			qstr+="&fromRunButton=yes";
		}
		appConstants.queryString = qstr;
		if(qstr!=undefined&&qstr.indexOf('er_rtype')==-1)
		{
			appConstants.queryString += '&er_rtype=Citrix Report';
		}
	},
	loadBackground: function( resultData )
	{
		var backgroundResultsData = resultData;
		if ( !Ext.isEmpty( backgroundResultsData ) )
		{
			var resultObj = this.getBackGroundPanel();
			resultObj.removeAll();
			var backgroundResultStatus = backgroundResultsData['status'];
			var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
			var backgroundResultURL = backgroundResultsData['backgroundResponseURLLink'];
			var backgroundResultURLLinkText = backgroundResultsData['backgroundResponseURLText'];
			var htmlStr = '';
			if ( backgroundResultStatus == 'success' )
			{
				
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+backgroundResultURLLinkText+'</a></div></td></tr></table></td></tr></table>';
			}
			else if ( backgroundResultStatus == 'duplicate' )
			{

				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResultURL +'>'+backgroundResultURLLinkText+'</a></div></td></tr></table></td></tr></table>';
			}
			resultObj.add({
				xtype: 'container',
				cls:'measuresErrorPanelBg',
				margin:0,
				bodyPadding:0,
				html:htmlStr,
			});
			resultObj.doLayout();
			resultObj.show();
			this.disableTools();
		}
	},
	loadData: function(resultData)
	{
		var me = this;
		if(fromRunButton)
		{
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJSON.selectionDetails);
		}
		fromRunButton = true;
		var resultPanel = Ext.getCmp('resultPanel');
		resultPanel.removeAll();
		var summaryData = '<div style="padding: 5px 0px 0px 0px;" width="100%"><table width="100%" style="border:0px;"><tr >';
		summaryData+= '<td style="border-right:0px solid #e9e9e9;">';
		summaryData+= '<div style="margin:10px 0px 0px 20px" class="newFont_bold14">'+Total_ServersTxt+'</div>';
		summaryData+= '<div><table height="172px" align="center" valign="middle"><tr><td><div class="iconServerGray"/></td><td><div class="newFont_light50" style="text-align:center;margin-left:5px">'+resultData.TOTAL_SERVERS+'</div></td></tr></table></div>';
		summaryData+= '</td>';
		summaryData+= '</tr>';
		summaryData+= '<tr>';
		summaryData+= '<td style="background-color:#3f51b5;padding:0px" >';
		summaryData+= '<div style="margin:14px 0px 0px 18px;color:#FFFFFF" class="newFont_bold14">'+Additonal_ServerRequriedTxt+'</div>';
		summaryData+= '<div><table height="170px" align="center" valign="middle"><tr><td><div class="iconServerWhite"/></td><td><div class="newFont_light50" style="text-align:center;color:#FFFFFF;margin-left:5px">'+resultData.ADDITIONAL_SERVER+'</div></td></tr></table></div>';
		summaryData+= '</td>';
		summaryData+= '</tr></table></div>';

		var prefixText = '';
		var er_option = Ext.getCmp('er_option').getValue();
		if(er_option!='Component')
		{
			prefixText = Ext.getCmp('er_site').getValue();
		}
		else
		{
			prefixText = Ext.getCmp('er_componentname').getValue();
		}
		resultPanel.add({
			xtype:'panel',
			columnWidth:1.0,
			layout:{
				type:'column',
				align:'stretch'
			},
			ui:'newGraphPanel',
			margin:'10 10 10 10',
			items:[
			{
				xtype:'container',
				columnWidth:1.0,
				margin:'10 10 0 10',
				html:'<div style="display:flow-root;white-space:wrap"><span class="newFont_bold12">'+prefixText+'</span><span class="newFont_normal12">&nbsp;'+Ext.getCmp('er_option').getRawValue()+'&nbsp;currently supports&nbsp;</span><span class="newFont_bold12">'+resultData.UNIQUE_USER_ORIGINAL+'&nbsp;users&nbsp;('+resultData.SESSIONS_ORIGINAL+' Concurrent sessions)</span><span class="newFont_normal12"> on </span><span class="newFont_bold12">'+resultData.TOTAL_SERVERS_ORIGINAL+' servers.</span><span class="newFont_normal12"> To understand resource usage patterns for variations in load, use the slider below.</span>&nbsp;&nbsp;&nbsp;</div>'
			},
			{
				xtype:'panel',
				columnWidth:1.0,
				padding:'5 0 0 20',
				layout:
				{
					type:'hbox',
					align:'stretch',
					pack:'center'
				},
				margin:'20 10 20 0',
				items:[
				{
					xtype:'container',
					layout:'hbox',
					margin:'5 0 5 0',
					items:[
					{
						xtype: 'slider',
						cls:"mesrslider",
						id: 'factorSlider',
						name: 'factorSlider',
						fieldLabel:'<div class="newFont_bold14">'+userTxt+'</div>',
						labelSeparator: '',
						labelAlign: 'left',
						labelWidth:60,
						animate:true,
						increment:resultData.SliderRange,
						minValue: 0,
						value:resultData.factorValue,
						maxValue: 300,
						width:420,
						plugins:['fillslider'],
						tipText: function (t) 
						{
							var retVal = ''
							retVal = 'Increased by '+t.value+' %';
							return retVal;
						},
						listeners:
						{
							'changecomplete':function()
							{
								fromRunButton = false;
								me.submitReport();
							}
						}
					},
					{
						xtype:'container',
						margin:'1 10 0 20',
						//html:'<div class="newFont_bold16">'+resultData.factorValue+'&nbsp;%</div>'
						html:'<div><span class="newFont_bold16">'+resultData.UNIQUE_USER+'&nbsp;</span><span class="newFont_normal14">'+usersTxt+'</span></div>'
					}]
				},
				{
					xtype:'container',
					margin:'2 10 5 0',
					html:'<div style="height:30px;width:100%;border-left:1px solid #e9e9e9">&nbsp;</div>'
				},
				{
					xtype:'container',
					html:'<div style="margin:7px 0px 5px 0px"><span class="newFont_bold16">'+resultData.SESSIONS+'</span><span class="newFont_normal14">&nbsp;'+numberOfSession+'<span></div>'
				}]
			},
			{
				xtype:'container',
				columnWidth:1.0,
				margin:'0 10 5 5',
				html:'<div class="newFont_normal10" style="font-style:italic;float:right">*Predictions are based on extrapolation of past resource usage patterns.</div>'
			}]
		},{
			
			xtype:'panel',
			columnWidth:1.0,
			layout:'column',
			height:415,
			//ui:'newGraphPanel',
			//margin:'10 10 10 10',
			items:[
			{
				xtype:'container',
				layout:'column',
				height:405,
				ui:'newContainer',
				//ui:'newGraphPanel',
				padding:10,
				margin:'0 10 10 10',
				columnWidth:0.6,
				items:[
				{
					xtype:'container',
					columnWidth:0.5,
					style:{
						'border-bottom':'1px solid #e9e9e9'
					},
					html:'<div style="margin:10px 0px 0px 10px;"><div class="newFont_bold14">'+resultData.CPU_UTIL_CHART.title+'</div><div id="gaugeId_cpu" style="height:150px"></div></div>'
				},
				{
					xtype:'container',
					columnWidth:0.5,
					style:
					{
						'border-left':'1px solid #e9e9e9',
						'border-bottom':'1px solid #e9e9e9'
					},
					html:'<div style="margin:10px 0px 0px 10px;"><div class="newFont_bold14">'+resultData.MEM_UTIL_CHART.title+'</div><div id="gaugeId_mem" style="height:150px"></div></div>'
				},
				{
					xtype:'container',
					columnWidth:0.5,
					html:'<div style="margin:20px 0px 0px 10px;"><div class="newFont_bold14">'+resultData.DISK_USAGE_CHART.title+'</div><div id="gaugeId_disk" style="height:150px"></div></div>'
				},
				{
					xtype:'container',
					columnWidth:0.5,
					style:
					{
						'border-left':'1px solid #e9e9e9'
					},
					html:'<div style=margin:20px 0px 0px 10px;"><div class="newFont_bold14">'+resultData.NETWORK_USAGE_CHART.title+'</div><div id="gaugeId_net" style="height:150px"></div></div>'
				}]
			},{
				xtype:'container',
				height:405,
				ui:'newContainer',
				padding:0,
				margin:'0 10 10 0',
				columnWidth:0.4,
				html:summaryData
			}]
		});
		var gaugeChart_cpu = {};
		gaugeChart_cpu = jQuery.extend(true, {}, getHighChartsGuage('gaugeId_cpu',resultData.CPU_UTIL_CHART,''), gaugeChart_cpu);
		var gaugeChart_mem = {};
		gaugeChart_mem = jQuery.extend(true, {}, getHighChartsGuage('gaugeId_mem',resultData.MEM_UTIL_CHART,''), gaugeChart_mem);
		var gaugeChart_disk = {};
		gaugeChart_disk = jQuery.extend(true, {}, getHighChartsGuage('gaugeId_disk',resultData.DISK_USAGE_CHART,''), gaugeChart_disk);
		var gaugeChart_net = {};
		gaugeChart_net = jQuery.extend(true, {}, getHighChartsGuage('gaugeId_net',resultData.NETWORK_USAGE_CHART,''), gaugeChart_net);

	},
	loadTools: function()
	{
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //csv
			true, // fav
			true,// schedule
			false, //diagnosis
			false, //togglebutton
			false, //close
			true //booklet
		);
	},
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
		id:'configMod',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'381px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'CitrixCapacityPredictionSettings',
				parent:this
			}
		],
		renderTo:'citrixcapacityForm'
		});
	},
	afterSettingsRender:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();
		var ObjectArr = new Array();
		var screenLabels = appConstants.publicJSON['screenLabels'];
		ObjectArr['er_excwe'] = screenLabels['reporter.common.excludeweekends'];
		ObjectArr['timeperiodLbl'] = screenLabels['reporter.common.Timeperiod'];
		ObjectArr['fromTimeLbl'] = screenLabels['reporter.common.From'];
		ObjectArr['toTimeLbl'] = screenLabels['reporter.common.To'];
		ObjectArr['fromHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['fromMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['toHrsLbl'] = screenLabels['reporter.common.Hrs'];
		ObjectArr['toMinsLbl'] = screenLabels['reporter.common.Mins'];
		ObjectArr['reportGeneration'] = screenLabels['reporter.consolidated.reportGeneration'];
		ObjectArr['bgReportName'] = screenLabels['reporter.consolidated.reportName'];

		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			me.validateAndCloseSettings();
		});

		this.loadScreenLabels( settingsForm, ObjectArr );

		var selectedData = appConstants.publicJSON['selectedValues'];
		var excludeWeekCombo = appConstants.publicJSON['excludeWeekCombo'];
		var excludeWeekSelected = selectedData['excludeWeekSelected'];
		if ( !Ext.isEmpty( excludeWeekCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'er_excwe', excludeWeekCombo, excludeWeekSelected);
		}
		var excludeMsgs = appConstants.publicJSON['excludeWeekEndMsg'];
		/*if ( !Ext.isEmpty( excludeMsgs ) )
		{
			Ext.getCmp('excludeDays').update(excludeMsgs);
		}
		else
		{
			Ext.getCmp('excludeDays').update('');
		}*/
		var componentVal = Ext.getCmp('er_option').getValue();

		settingsForm.findField('timefrom').setValue(selectedData['timePeriodFromHrSelected']);
		settingsForm.findField('minfrom').setValue(selectedData['timePeriodFromMinSelected']);
		settingsForm.findField('timeto').setValue(selectedData['timePeriodToHrSelected']);
		settingsForm.findField('minto').setValue(selectedData['timePeriodToMinSelected']);

		var reportGenCombo = appConstants.publicJSON['reportGenCombo'];
		var reportGenSelected = selectedData['reportGenSelected'];
		if ( !Ext.isEmpty( reportGenCombo ) )
		{
			this.setValueWithOptionInList(settingsForm, 'reportGeneration', reportGenCombo, reportGenSelected);
			this.changeReportGeneration();
		}
	},
	validateAndCloseSettings:function()
	{
		var result = this.validateSettings();
		if(result)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeAndSubmitSettings:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	afterCapacityFormRender: function()
	{
		this.hideResult();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJSON['TITLE']);
		var mainForm = this.getCitrixCapacityPredictionForm().getForm();

		var selectedData = appConstants.publicJSON['selectedValues'];

		var anlyzeCombo = appConstants.publicJSON['anlyzeCombo'];
		var er_optionSelected = selectedData['er_option'];

		if ( !Ext.isEmpty( anlyzeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_option',anlyzeCombo, er_optionSelected);
		}

		var screenLabels = appConstants.publicJSON['screenLabels'];
		if(er_optionSelected!=undefined && er_optionSelected!='Component')
		{
			var comboObject = Ext.getCmp('er_site');
			comboObject.setFieldLabel(screenLabels['reporter.common.siteLabel']);

			var siteCombo = appConstants.publicJSON['siteCombo'];
			var er_siteSelected = selectedData['er_site'];

			if ( !Ext.isEmpty( siteCombo ) )
				{
					this.setValueWithOptionInList(mainForm, 'er_site', siteCombo, er_siteSelected);
				}
				else
				{
					this.insertNotApplicable(mainForm, 'er_site');
				}
			Ext.getCmp('er_site').show();
		}
		else
		{
			Ext.getCmp('er_site').hide();
		}
		var compTypeCombo = appConstants.publicJSON['compTypeCombo'];
		var er_comptypeSelected = selectedData['er_comptype'];

		if ( !Ext.isEmpty( compTypeCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_comptype', compTypeCombo, er_comptypeSelected);
		}
		var analyseComp=Ext.getCmp('er_option');
		if(analyseComp != undefined){
			var analyseCompVal= analyseComp.getValue();
			if(analyseCompVal != undefined && analyseCompVal == 'Component'){
				Ext.getCmp('er_componentname').show();
			}else{
				Ext.getCmp('er_componentname').hide();
			}
		}
		var compCombo = appConstants.publicJSON['componentCombo'];
		var er_comptypeSelected = selectedData['er_componentname'];

		if ( !Ext.isEmpty( compCombo ) )
		{
			this.setValueWithOptionInList(mainForm, 'er_componentname', compCombo, er_comptypeSelected);
		}
		
		appConstants.rawDataForComponents = appConstants.publicJSON['componentCombo'];


		var timelineCombo = appConstants.publicJSON['timelineCombo'];
		var selectedTimeline = selectedData['selectedTimeline'];
		if (!Ext.isEmpty(timelineCombo))
		{
			this.setValueWithOptionInList(mainForm, 'er_timeline', timelineCombo, selectedTimeline);
			this.changeTimeline();
		}

		mainForm.findField('er_mode').setValue(selectedData['selectedGraphMode']);

		var startdateObj = mainForm.findField('er_stdate');
		var enddateObj = mainForm.findField('er_enddate');
		var startHourObj = mainForm.findField('er_sthr');
		var endHourObj = mainForm.findField('er_endhr');

		startdateObj.setValue(selectedData['startDateForDisplay']);
		startdateObj.dataArray =selectedData['startDate'];
		startHourObj.setValue(selectedData['startHourForDisplay']);
		startHourObj.dataArray = selectedData['startHour'];
		enddateObj.setValue(selectedData['endDateForDisplay']);
		enddateObj.dataArray =selectedData['endDate'];
		endHourObj.setValue(selectedData['endHourForDisplay']);
		endHourObj.dataArray = selectedData['endHour'];
		stmin =selectedData['startMinForDisplay'];
		enmin = selectedData['endMinForDisplay'];
		mgr_stmin =selectedData['startmin'];
		mgr_enmin = selectedData['endmin'];

		var hiddenFields =  appConstants.publicJSON["hiddens"];
			var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];

		if(!hideBackButton){
			Ext.getCmp('CitrixCapacityPredictionForm').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJSON['ID']
			}
			);
		}
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			this.getResultpanel().removeAll();
			this.getResultpanel().hide();
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ( appConstants.isSubmit == 'true' && from_favorite != "Yes")
		{
			this.getResultpanel().removeAll();
			this.getResultpanel().show();
			if (selectedData['reportGenSelected'] == 'foreground')
			{
				var resultData = appConstants.publicJSON['RESULT_DATA'];
				var noData = appConstants.publicJSON['NO_DATA'];
				if ( !Ext.isEmpty(resultData))
				{
					if(noData!=undefined && noData=='yes')
					{
						this.getResultpanel().add(
						{
							xtype: 'container',
							height: 270,
							margin:10,
							class:'newContainer',
							html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
						});
					}
					else
					{
						this.loadData(resultData);
						this.enableTools();
					}
				}
				else
				{
					this.getResultpanel().add(
					{
						xtype: 'container',
						height: 270,
						margin:10,
						class:'newContainer',
						html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>'
					});
				}
			}
			else
			{
				var resultData = appConstants.publicJSON['backgroundResults'];
				this.loadBackground(resultData);
			}
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.submitReport(Ext.getCmp('submit'));
			}
		}
	},
	validateSettings: function()
	{
		var isSettingsOk = true;
		var settingsForm = this.getCitrixCapacityPredictionSettings().getForm();
		var reportgenVal = settingsForm.findField('reportGeneration').getValue();
		if ( reportgenVal!=null && (reportgenVal == 'background' || reportgenVal == 'background'))
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				return false;
			}
		}
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if (btn == 'yes')
		{
			this.generateResult();
		}
		else
		{
			if(!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.setValue("");
			reportNameObj.show();
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			{
				reportNameObj.focus();
				isSettingsOk = false;
			}
		}
	},
	insertNotApplicable: function ( form, fieldName )
	{
		var obj = form.findField(fieldName);
		obj.getStore().removeAll();
		obj.getStore().add({
			'displayField': appConstants.notApplicable,
			'valueField': '-1'
		});
		obj.setValue('-1');
	},
	loadScreenLabels: function ( form, ObjectArr )
	{
		var obj = '';
		for ( var key in ObjectArr )
		{
			obj = !Ext.isEmpty(form.findField(key))?form.findField(key):Ext.getCmp(key);
			if ( obj.getXType() != 'label' )
			{
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
			else
			{
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);
		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var value='';
		if(isEnabled)
		{
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}
		else
		{
			value = appConstants.publicJSON.selectedValues[jsonParam];
		}
		return value;
	}
});