Ext.define('CitrixCapacitySummaryApp.controller.CitrixCapacitySummaryController', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'EgComponentsGroup'],
	refs: [
		{
			selector: 'main',
			ref: 'main'
		},
		{
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{
			selector: 'egcomponentsGroup',
			ref: 'egcomponentsGroup'
		}, 
		{
			selector: 'citrixCapacitySummaryDetailsForm',
			ref: 'citrixCapacitySummaryDetailsForm'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
			selector: 'resultpanel',
			ref: 'resultpanel'
		},
		{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		},
		{
			selector: 'customtrigger',
			ref:'customtrigger'
		},
		{
			selector: 'backGroundPanel',
			ref:'backGroundPanel'
		}
	],
	init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click': this.modifyScheduleFavorite
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'citrixCapacitySummaryDetailsForm combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'citrixCapacitySummaryDetailsForm combo[id="er_compType"]':
			{
				'select': this.onSelectComponentType
			},
			'egcomponentsGroup multiselectfield[name="er_CompGrp"]':
			{
				//'change': this.ComponentOnChange
			},
			'mainform trigger[id="compGroupSearch"]':
			{
				'change': this.compMultiselect
			},
			'citrixCapacitySummarySettings':
			{
				'afterrender': this.closeSetting
			},
			'citrixCapacitySummarySettings combo[name="reportGeneration"]':
			{
				'select': this.reportGenChange
			},
			'citrixCapacitySummarySettings button[name="moreOptionCloseId"]':
			{
				'click' : this.validateAndCloseSettings
			},
			'citrixCapacitySummarySettings button[name="submitViaSetting"]':
			{
				'click' : this.closeSettingAndSubmit
			},
		   'citrixCapacitySummarySettings combo[id="er_excwe"]': {
				'select': this.excludeWeekendsChange
			},
	       'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	loadTools: function() 
	{
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function()
	{
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData = appConstants.defaultLoadData
		this.setErReportType(jData);
		this.setErOptionData(jData);
		this.setComponentTypeData(jData);
		this.setComponentGroupData(jData);
		var erTimeline = Ext.getCmp('er_timeline');
		erTimeline.getStore().loadRawData(jData['timelineCombo']);
		erTimeline.setValue(jData['selectedTimeline']);
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray = jData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray = jData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		Ext.getCmp('CitrixCapacitySummaryDetailForm').add({
			xtype: 'hidden',
			id: 'ID',
			name: 'ID',
			value: jData['ID']
		});
	},
	expandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_CompGrp'), Ext.getCmp('compLbl').text, btn);
	},
	setErReportType: function(jData)
	{
		var reportType=Ext.getCmp('er_type');
		reportType.getStore().loadRawData(jData['reportType']);
		reportType.setValue(jData.selectedField['selectedReportType']);
	},
	setErOptionData: function(jData)
	{ 
		var analysisBy = Ext.getCmp('er_option');
		analysisBy.getStore().loadRawData(jData['analysisBy']);
		analysisBy.setValue(jData.selectedField['selectedAnalysisBy']);
	},
	setComponentTypeData:function(jData)
	{
		var er_componentType=Ext.getCmp('er_compType');
		er_componentType.getStore().loadRawData(jData['componentTypeCombo']);
		er_componentType.setValue(jData.selectedField['selectedCompTypeArry']);
	},
	setComponentGroupData:function(jData)
	{
		var selectedAnalysisBy=jData.selectedField['selectedAnalysisBy'];
		Ext.getCmp('compLbl').setText(selectedAnalysisBy);
		var compGroup=Ext.getCmp('er_CompGrp');
		compGroup.getStore().clearFilter(true);
		compGroup.getStore().loadRawData(jData['groupList']);
		if(!Ext.isEmpty(jData.selectedField['selectedGroups']) && jData.selectedField['selectedGroups'] != undefined)
		{
			compGroup.setValue(jData.selectedField['selectedGroups']);
		}
		else
		{
			compGroup.setValue(jData['groupList'][0].valueField);
		}
	},	
	
	onSelectAnalysisBy: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var reportBy = 'analysisBy=' + thisVal;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCapacitySummaryReportJSON.jsp',
			scope: this,
			method: 'POST',
			params: reportBy,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentTypeData(jsonData);
				formObj.setComponentGroupData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectComponentType: function()
	{
		var er_type = Ext.getCmp('er_type').getValue();		
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var params='reportType='+er_type+'&analysisBy='+er_option;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErCapacitySummaryReportJSON.jsp',
			scope:this,
			method: 'POST',
			params: params,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentGroupData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
		

	},
	ComponentOnChange: function(obj, newValue, oldValue, eOpts)
	{
		var er_option = Ext.getCmp('er_option').getValue();
		if(er_option != undefined && er_option == 'Aggregate')
		{
			return;
		}
		if (newValue.length > 1 && (newValue.indexOf('All') > -1 || newValue.indexOf("all") > -1))
		{
			this.showMessage('Chosen components group not allowed');
			return;
		}
		if (Ext.isEmpty(oldValue) || oldValue == undefined) 
		{
			return false;
		}
		var er_type = Ext.getCmp('er_type').getValue();		
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_CompGrp = Ext.getCmp('er_CompGrp').getValue();
		var params='reportType='+er_type+'&analysisBy='+er_option;
		params += "&er_compType=all";
		for(var c=0;c<er_CompGrp.length;c++)
		{
			params += "&selectedGroups="+er_CompGrp[c];
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCapacitySummaryReportJSON.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				formObj.setComponentTypeData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	saveReportAsPDF: function() 
	{
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = 'er_rtype=CitrixCapacitySummary';
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString();
		bookletquery+="&er_rtype=CitrixCapacitySummary&er_trgttype=&er_ViewName=ErCapacitySummaryReport.jsp&er_RmDispName=CitrixCapacitySummary";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	printReport: function() 
	{
		var s_qryString = "/final/reporter/ErCitrixCapacitySummaryPrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate;
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{
		window.location = '../servlet/com.eg.ErCitrixCapcitySummaryReportC?er_view=CSV';
	},
	saveSchedule: function(obj)
	{
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype=CitrixCapacitySummary&er_trgttype=&er_ViewName=ErCapacitySummaryReport.jsp&er_RmDispName=CitrixCapacitySummary&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.scheduleWindowFn(qryString);
	},
	saveFavorite: function()
	{
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=&er_rtype=CitrixCapacitySummary&er_ViewName=ErCapacitySummaryReport.jsp&er_RmDispName=CitrixCapacitySummary&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.favouriteWindowFn(target);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype=&er_rtype=CitrixCapacitySummary&er_ViewName=ErCapacitySummaryReport.jsp&er_RmDispName=CitrixCapacitySummary&fromFavoriteModify=Yes&cmd=client'
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=CitrixCapacitySummary';
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no";
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: qryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	compMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_CompGrp'), appConstants.defaultLoadData['groupList']);
	},

	submitReport: function(qryStr)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if(!isSettingsEnabled)
			this.showConfigDropdown();//..
		var params ='';
		
		if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
		{
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			stDate.setHours(startHr);
			enDate.setHours(endHr);          
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			params += '&servletName=ErCitrixCapcitySummaryReportC&er_rtype=CitrixCapacitySummary&er_ViewName=ErCapacitySummaryReport.jsp&er_RmDispName=CitrixCapacitySummary';
			params += '&er_trgttype=&forwardto=CitrixCapacitySummary&er_bgreportfrom=CitrixCapacitySummary&bgenabled=Yes&savereport=save';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
			}
			appConstants.LoadingMask.show();
			Ext.Ajax.request({
				url: bgUrl,
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					var resultObj = Ext.getCmp('backGroundPanel');
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
					if ( status == 'success' )
					{
						//htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					else if ( status == 'duplicate' )
					{
						//htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}
			});
		}
	},
	submitReportByAjaxCall:function(params)
	{
		this.getBackGroundPanel().hide();
		appConstants.LoadingMask.show();
		params += '&er_view=submit';
		var me=this;
		var url='/final/servlet/com.eg.ErCitrixCapcitySummaryReportC';
		this.getNomeasurepanel().hide();
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');
				resultPanelObj.removeAll();
				var jsonObject=response.responseText;
				var jsonData=Ext.decode(jsonObject);
				
				var reportType=Ext.getCmp('er_type').getValue();
				resultPanelObj.show();
			
				if(jsonData.isData != undefined && jsonData.isData)
				{
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);	
					if(reportType=='data')
					{
						resultPanelObj.add(this.getGrid(jsonData));
						this.getNomeasurepanel().hide();
					}	
					else if(reportType == 'graph')
					{
						var chartHeight=jsonData.summaryGraphDataObj.chartHeight;
						var graphContentHtml='';
						var panelHeight=Ext.getBody().getHeight()-150;	
						if(chartHeight<panelHeight)
						{
							panelHeight=chartHeight+90;
						}
						graphContentHtml='<div id="graphContentId" style="width:97% !important;padding:0px">';
						var graphContent='';
						graphContent=Ext.create('Ext.panel.Panel',{
							//cls:'datapanel',
							ui:'newGraphPanel',
							title:'Max Sessions',
							height:panelHeight,
							autoScroll:true,
							overflowX:'hidden',
							overflowY:'auto',
							html:graphContentHtml
						});
						resultPanelObj.add(graphContent);
						var highChart_bar = {};
						highChart_bar = jQuery.extend(true, {}, getHighChartsBarInstance('graphContentId',chartHeight,150), highChart_bar);
						highChart_bar.setData(jsonData.summaryGraphDataObj,'<%=currentDateFormat%>','');
						highChart_bar.drawChart();
						this.getNomeasurepanel().hide();
					}
				}
				else
				{				
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();			
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
				appConstants.LoadingMask.hide();			
			}
		});
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	getGrid:function(jsonData)
	{
		var gridCol=jsonData.summaryGridColObj;
		var gridData=jsonData.summaryGridArray;
		var colmServerGrp=new Array();
		var colName='';
		var colAlign='';
		var colWidth='';
		var me=this;
		
		var fieldArry=new Array();
		for (var i=0;i<gridCol.length;i++)
		{
			var eachObj=gridCol[i];
			colName=eachObj['colDispVal'];
			fieldArry.push(eachObj['colKey']);
			colAlign=eachObj['colAlign'];
			colWidth=eachObj['colWidth'];
			if(colWidth != undefined)
			{
				colWidth=parseFloat(colWidth);
			}
			else
				colWidth=100;
			colmServerGrp.push({
				header:colName,
				dataIndex:eachObj['colKey'],
				align:colAlign,
				width:colWidth,
				//style:'vertical-align:middle',
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var val=value;
					var color='';
					if(val.indexOf("$") != -1)
					{
						color=val.substring(val.indexOf("$")+1);
						val=val.substring(0,val.indexOf("$"));
						val="<div style='position:relative;margin:auto!important;text-align:center;width:50px;height:18px;color:#ffffff;border-radius:2px;background:"+color+";'>"+val+"<div/>";
					}
					/*else
					{
						val=me.getNumberFormat(val);
					}*/
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
					//metaData.tdCls = 'vertical-align:middle';
					return val;
				}
			});
		}
		var pageSize=15;
		var storeServerGrp=Ext.create('Ext.data.Store',{
				fields:fieldArry,						
				proxy : {
				  type : 'pagingmemory',
				},
				autoLoad : true,
				data:gridData,
				pageSize:pageSize
		});
		var isPaginationHidden=true;
		if(pageSize<gridData.length)
		{
			isPaginationHidden=false;
		}
		var panelHeight=Ext.getBody().getHeight()-150;
		return{
			xtype:'panel',
			ui:'newGraphPanel',
			title:'<span class="font_bold">Capacity Summary</span>',
			items:[{
				xtype:'customgrid',
				sortableColumns: false,
				//cls:'gridSkin horizontal-scroll',
				//style:'vertical-align:middle',
				ui:'newGridPanel',
				//title:'<span class="font_bold">Capacity Summary</span>',
				margin:'0 10 10 10',
				autoScroll:true,
				scroll:true, 
				border:true,
				forceFit:true,
				layout:'fit',
				align:'stretch',
				store: storeServerGrp,
				columns:colmServerGrp ,	
				listeners: 
				{
					render:function(obj)
					{
						this.getView().on('refresh', this.updateRowSpan, this);
					}
				},
				updateRowSpan: function() {
					var columns = this.columns,
						view = this.getView(),
						store = this.getStore(),
						rowCount = store.getCount(),
						
						column = columns[0],
						dataIndex = column.dataIndex,
						
						spanCell = null,
						spanCount = null;
						spanValue = null;
					
					for (var row = 0; row < rowCount; ++row) {
						var cell = view.getCellByPosition({ row: row, column: 0 }).dom,
							record = store.getAt(row),
							value = record.get(dataIndex);
						
						if (spanValue != value) {
							if (spanCell !== null) {
								spanCell.rowSpan = spanCount;
							}
							
							Ext.fly(cell).setStyle('display', '');
							spanCell = cell;
							spanCount = 1;
							spanValue = value;
						} else {
							spanCount++;
							Ext.fly(cell).setStyle('display', 'none');
						}
					}
					
					if (spanCell !== null) {
						spanCell.rowSpan = spanCount;
					}
				},
			dockedItems:[{
			xtype:'pagingtoolbar',
			cls:'pagingtoolbar',
			dock: 'bottom',
			displayInfo: true,
			store: storeServerGrp,
			hidden:isPaginationHidden,
			displayInfo: true,
			displayMsg: 'Total Records : {2}',
			emptyMsg: "No Data to display",
			listeners: {
				change : function(thisd, params)
				{
						//activePage = params.currentPage;
				},
				afterrender: function() {
					this.down('#refresh').hide();
				}
			}
		}],
		}],
		};
	},
	
	excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },	
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:580,
			padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'370px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype : 'citrixCapacitySummarySettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 
		var utilCritical=Ext.getCmp('upperCritical');
		var utilMajor=Ext.getCmp('uppermajor');
		var utilMinor=Ext.getCmp('upperminor');
		utilCritical.setValue(appConstants.defaultLoadData.sessUtilCritical);
		utilMajor.setValue(appConstants.defaultLoadData.sessUtilMajor);
		utilMinor.setValue(appConstants.defaultLoadData.sessUtilMinor);

		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 

		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		var me = this;
		Ext.getCmp('moreOptionCloseId').show();
		/*var me = this;
		Ext.get('closeSettings').on('click', function() {
			if(me.validateSettings())
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: 
					{
						y: -500
					}
				 });
			}
		});*/
		Ext.get('closeSettings').on('click', function () {
					me.validateAndCloseSettings();
				});
	},
	validateSettings :function(){
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		var fiedStatus=true;
		var value=Ext.getCmp('upperCritical').getValue();
		if(value=="" || value == '-1' || value == '-'  || (!isNaN(value) && !isNaN(parseFloat(value)) && parseFloat(value) > -1))
			fiedStatus=true;
		else
		{
			Ext.Msg.show({
				title: "Alert",
				msg: 'Enter Valid Number',
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return false;
		}
		value=Ext.getCmp('uppermajor').getValue();
		if(value=="" || value == '-1' || value == '-' || (!isNaN(value) && !isNaN(parseFloat(value)) && parseFloat(value) > -1))
			fiedStatus=true;
		else
		{
			Ext.Msg.show({
				title: "Alert",
				msg: 'Enter Valid Number',
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return false;
		}
		value=Ext.getCmp('upperminor').getValue();
		if(value=="" || value == '-1' || value == '-' || (!isNaN(value) && !isNaN(parseFloat(value)) && parseFloat(value) > -1))
			fiedStatus=true;
		else
		{
			Ext.Msg.show({
				title: "Alert",
				msg: 'Enter Valid Number',
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
			return false;
		}
		return fiedStatus;
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var er_type = Ext.getCmp('er_type').getValue();
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_CompGrp = Ext.getCmp('er_CompGrp').getValue();
		if(er_CompGrp[0] == '-1')
		{
			this.showMessage('Components is Not Applicable');
			return false;
		}
		if (er_CompGrp.length > 1 && (er_CompGrp.indexOf('All') > -1 || er_CompGrp.indexOf('all') > -1))
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		var params='reportType='+er_type+'&analysisBy='+er_option;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		for(var c=0;c<er_CompGrp.length;c++)
		{
			params += "&selectedGroups="+er_CompGrp[c];
		}
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue()
		startDate.setHours(startHr);
		endDate.setHours(endHr); 
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+appConstants.defaultLoadData.startmin+'&endmin='+appConstants.defaultLoadData.endmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var sessUtilCritical=Ext.getCmp('upperCritical').getValue();
			var sessUtilMajor=Ext.getCmp('uppermajor').getValue();
			var sessUtilMinor=Ext.getCmp('upperminor').getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
			}
			params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
			params2 += '&sessUtilCritical='+sessUtilCritical+'&sessUtilMajor='+sessUtilMajor+'&sessUtilMinor='+sessUtilMinor;
			params2+= '&er_reportgenration='+rGenType+'&bg_reportname='+reportName;

		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		params += params1;
		params += params2;
		params += userID;
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	validateAndCloseSettings:function()
	{
		var me  = this;
		if(!me.validateSettings())
		{
			return false;
		}
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title: 'Citrix Capacity Planning Summary Report',
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});