Ext.define('CitrixConnectionDetail.controller.CitrixConnectionDetail', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'EgComponent'],
	refs: [
		{
			selector: 'main',
			ref: 'main'
		},
		{
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{
			selector: 'egcomponent',
			ref: 'egcomponent'
		}, 
		{
			selector: 'CitrixConnectionDetailForm',
			ref: 'CitrixConnectionDetailForm'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
			selector: 'resultpanel',
			ref: 'resultpanel'
		},
		{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		},
		{
			selector: 'CitrixConnectionDetailSettings',
			ref: 'CitrixConnectionDetailSettings'
		},
		{
			selector: 'citrixConnectionDetailPie',
			ref: 'citrixConnectionDetailPie'
		}

	],
	init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click': this.modifyScheduleFavorite
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'mainform button[id="expandSelectorUser"]':
			{
				'click': this.expandMeUser
			},
			'CitrixConnectionDetailForm combo[id="er_option"]':
			{
				'select': this.onSelectReportBy
			},
			'CitrixConnectionDetailForm combo[id="select_farm"]':
			{
				'select': this.onSelectReportSubType
			},
			'CitrixConnectionDetailForm combo[id="erOsMachine_type"]':
			{
				'select': this.onSelectMachineType
			},
			'egcomponent multiselectfield[name="er_server"]':
			{
				'change': this.ComponentOnChange
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.compMultiselect
			},
			'erapplication trigger[id="userSearch"]':
			{
				'change': this.filterMultiselect
			},
			'CitrixConnectionDetailSettings':
			{
				'afterrender': this.closeSetting
			},
			'CitrixConnectionDetailSettings combo[name="reportGeneration"]':
			{
					'select': this.reportGenChange
			},
			'CitrixConnectionDetailSettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'CitrixConnectionDetailSettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
		   'CitrixConnectionDetailSettings combo[id="er_excwe"]': {
				"select": this.excludeWeekendsChange
			},
				'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	loadTools: function() 
	{
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function()
	{
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData = appConstants.defaultLoadData
		this.setErOptionData(jData);
		if(enableDeliveryDetails)
		{
			this.setMachineTypeData(jData);
			this.setDeliveryGroupData(jData);
			this.setMeasurementData(jData);
		}
		this.setSelectFarmData(jData);
		this.setServerData(jData);
		var erTimeline = Ext.getCmp('er_timeline');
		erTimeline.getStore().loadRawData(jData['timelineCombo']);
		erTimeline.setValue(jData['selectedTimeline']);
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray = jData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray = jData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		mgr_stmin=appConstants.defaultLoadData.startmin;
		mgr_enmin=appConstants.defaultLoadData.endmin;
		Ext.getCmp('CitrixConnectionDetailForm').add({
			xtype: 'hidden',
			id: 'ID',
			name: 'ID',
			value: jData['ID']
		});
	},
	expandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'), Ext.getCmp('compLbl').text, btn);
	},
	expandMeUser: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'), Ext.getCmp('appLbl').text, btn);
	},
	setErOptionData: function(jData)
	{ 
		//Report By
		var reportBy = Ext.getCmp('er_option');
		reportBy.getStore().loadRawData(jData['reportBy']);
		reportBy.setValue(jData['selectedreportBy']);
	},
	setDeliveryGroupData:function(jData)
	{
		var deliverGrup = Ext.getCmp('er_deliverGrup');
		deliverGrup.getStore().loadRawData(jData['deliveryGroupArrry']);
		deliverGrup.setValue(jData['selectedDeliveryGroup']);		
	},
	setMachineTypeData:function(jData)
	{
		var erOsMachine_type=Ext.getCmp('erOsMachine_type');		
		erOsMachine_type.getStore().loadRawData(jData['MachineTypeTypeArry']);
		erOsMachine_type.setValue(jData['selectedMachineType']);
	},
	setMeasurementData:function(jData)
	{
		var measureby=Ext.getCmp('er_measureBy');
		measureby.getStore().loadRawData(jData['measureCombo']);
		measureby.setValue(jData['selectedMeasure']);
	},
	setSelectFarmData: function(jData)
	{ 
		// Values of Zone  or segments or service ..
		var screenLable = jData.screenLabelJson;
		var reportSubType = Ext.getCmp('select_farm');
		reportSubType.setFieldLabel(screenLable['reportByLabel']);
		reportSubType.getStore().clearFilter(true);
		reportSubType.getStore().loadRawData(jData['zoneCombo']);
		reportSubType.setValue(jData['selectedreportBySubType']);
	},
	setServerData: function(jData)
	{
		//components
		var components = Ext.getCmp('er_server');
		components.getStore().clearFilter(true);
		components.getStore().loadRawData(jData['serverCombo']);
		if (!Ext.isEmpty(jData['selectedServer']) && jData['selectedServer']!=undefined)
		{
			components.setValue(jData['selectedServer']);
		}
		else
		{
			components.setValue(jData['serverCombo'][0].valueField);
		}
		
	},
	//Onchange drop down value setting starts from here 
	onSelectReportBy: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var reportBy = 'reportBy=' + thisVal;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixConnectionDetailJson.jsp',
			scope: this,
			method: 'POST',
			params: reportBy,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				if (thisVal == 'Component')
				{
					Ext.getCmp('select_farm').hide();
				}
				else 
				{
					Ext.getCmp('select_farm').show();
					formObj.setSelectFarmData(jsonData);
				}
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectMachineType: function(obj)
	{
		var erMachineType=obj.getValue();
		var params='erOsMachine_type='+erMachineType+'&method=getMachines';
		var formObj=this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
				url: '/final/reporter/ErCitrixConnectionDetailJson.jsp',
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.defaultLoadData = jsonData;
					formObj.setDeliveryGroupData(jsonData);
					appConstants.LoadingMask.hide();
				}
		});
	},
	onSelectReportSubType: function(obj)
	{
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType;
		var formObj = this;

		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixConnectionDetailJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectCompType: function(obj)
	{
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType + '&comptype=' + comptype;
		var formObj = this;

		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixConnectionDetailJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	ComponentOnChange: function(obj, newValue, oldValue, eOpts)
	{
		if (newValue.length > 1 && newValue.indexOf('All') > -1)
		{
			this.showMessage('Chosen component group not allowed');
			return;
		}
		if (Ext.isEmpty(oldValue) || oldValue == undefined) 
		{
			return false;
		}
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var selectedcompArray = Ext.getCmp('er_server').getValue();
		var erMachineType=Ext.getCmp('erOsMachine_type');
		var er_deliverGrup=Ext.getCmp('er_deliverGrup');
		var component = '';
		var temCom = '&component='
		for (var ci = 0; ci < selectedcompArray.length; ci++) 
		{
			component += temCom + selectedcompArray[ci];
		}
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType  + component;
		if(erMachineType != undefined)
			params+='&erOsMachine_type='+erMachineType.getValue();
		if(er_deliverGrup != undefined)
			params+='&er_deliverGrup='+er_deliverGrup.getValue();
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixConnectionDetailJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setDeliveryGroupData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	userOnChange: function(obj, newValue, oldValue, eOpts)
	{
		if (newValue.length > 1 && newValue.indexOf('All') > -1) 
		{
			this.showMessage('Chosen user group not allowed');
			return;
		}
	},
	saveReportAsPDF: function() 
	{
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	//
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.defaultLoadData;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString();
		bookletquery+="&er_rtype=CitrixConnectionDetail&er_trgttype=Citrix_Connection_Detail&er_ViewName=ErCitrixConnectionDetail.jsp&er_RmDispName=Citrix_Connection_Detail";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	//
	printReport: function() 
	{
		var s_qryString = "/final/reporter/ErCitrixConnectionDetailPrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate;
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{
		window.location = '../servlet/com.eg.ErCitrixConnectionDetailReportC?er_view=CSV';
	},
	saveSchedule: function(obj)
	{
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype=CitrixConnectionDetail&er_trgttype=Citrix_Connection_Detail&er_ViewName=ErCitrixConnectionDetail.jsp&er_RmDispName=Citrix_Connection_Detail&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.scheduleWindowFn(qryString);
	},
	saveFavorite: function()
	{
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=Citrix_Connection_Detail&er_rtype=CitrixConnectionDetail&er_ViewName=ErCitrixConnectionDetail.jsp&er_RmDispName=Citrix_Connection_Detail&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		} */
		parent.favouriteWindowFn(target);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype=Citrix_Connection_Detail&er_rtype=CitrixConnectionDetail&er_ViewName=ErCitrixConnectionDetail.jsp&er_RmDispName=Citrix_Connection_Detail&fromFavoriteModify=Yes&cmd=client'
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=CitrixConnectionDetail';
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: qryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	compMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_server'), appConstants.defaultLoadData['serverCombo']);
	},
	filterMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_application'), appConstants.defaultLoadData['userCombo']);
	},
	submitReport: function(qryStr)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var params ='';
		
		if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
		{
			//params =  qryStr;
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			//this.toggleForm();
			stDate.setHours(startHr);
			enDate.setHours(endHr);          
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			params += '&servletName=ErCitrixConnectionDetailReportC&er_rtype=CitrixConnectionDetail&er_ViewName=ErCitrixConnectionDetail.jsp&er_RmDispName=Citrix_Connection_Detail';
			params += '&er_trgttype=Citrix_Connection_Detail&forwardto=CitrixConnectionDetail&er_bgreportfrom=CitrixConnectionDetail&bgenabled=Yes&savereport=save';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
					
			}
			appConstants.LoadingMask.show();
			Ext.Ajax.request({
				url: bgUrl,
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					//var resultObj = Ext.getCmp('backgroundresults');
					var resultObj = Ext.getCmp('backGroundPanel');
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
					if ( status == 'success' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href="'+ reportValString.queryString +'">'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					else if ( status == 'duplicate' )
					{
						//htmlStr = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+reportValString.bgstr1+'</b><br /><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href="'+ reportValString.queryString +'">'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}
			});
		}
	},
	submitReportByAjaxCall:function(params)
	{
		appConstants.LoadingMask.show();
		params += '&er_view=submit';
		var me=this;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErCitrixConnectionDetailReportC',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');
				var legIndex=0;
				resultPanelObj.removeAll();
				var pieChat = Ext.getCmp("resultPie");
				pieChat.show();
				pieChat.removeAll();
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				var jsonObject = response.responseText;
				var  jsonData = Ext.decode(jsonObject);
				Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				var legendDataArray;
				var leftChartContentLegends = '';
				var connectionContentBarLegends = '';
				var content ='';
				var connectionContent='';
				if(appConstants.reportFor == 'ConnectionFailers')
				{
					if(jsonData['isDataFoundCon']==true)
					{
						content+='<div id="leftChartContent" style="overflow:auto;padding:0px 0px 0px 20px" >';
						content+='</div>';
						connectionContent+='<div id="connectionContentBar" style="height:312px;width:100% !important;overflow:auto;padding:0px" class="htmlTableBody">';
						connectionContent+='</div>';
						
						legendDataArray=jsonData.userConnection.DataSet[0].data;
					
						leftChartContentLegends+='<div><table>';
						connectionContentBarLegends+='<div><table>';
						for(var i=0;i<legendDataArray.length;i++)
						{
							leftChartContentLegends+='<tr><td><div style="background-color:'+legendDataArray[i].color+';" class="legendCircleNew">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td></tr>';
						}
						leftChartContentLegends+='</table></div>';
						legendDataArray=jsonData.connectionBar.DataSet;
						for(var i=0;i<legendDataArray.length;i=i+2)
						{
							if(i%2==0)
							{
								connectionContentBarLegends+='<tr>';
							}
							connectionContentBarLegends+='<td><div style="background-color:'+legendDataArray[i].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td>';
							legIndex=legIndex+1;
							if((i+1)<legendDataArray.length)
							{
								connectionContentBarLegends+='<td><div style="background-color:'+legendDataArray[i+1].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i+1].name+'</div></td></tr>';
								legIndex=legIndex+1;
							}
							else if(legendDataArray.length==1)
							{
								connectionContentBarLegends+='</tr>';
							}
							else
							{
								connectionContentBarLegends+='<td></td><td></td></tr>';
							}
						}
						connectionContentBarLegends+='</table></div>';
						
					}
					else
					{
						content = appConstants.defaultLoadData['noFailMSG'];
						connectionContent = appConstants.defaultLoadData['noFailMSG'];
					}
				}
				var content1 = '';
				var serverContent = '';
				var serverContentByDeliveryGp = '';
				var leftChartContent1Legends='';
				var serverContentBarLegends='';
				if(jsonData['isDataFoundServer']==true)
				{
					content1+='<div id="leftChartContent1" style="height:220px;width:450px !important;overflow:auto;padding:0px" class="htmlTableBody">';
					content1+='</div>';
					serverContentByDeliveryGp+='<div id="serverByDeliveryGp" style="height:220px;width:450px !important;overflow:auto;padding:0px" class="htmlTableBody">';
					serverContentByDeliveryGp+='</div>';
					serverContent+='<div id="serverContentBar" style="height:250px;width:500px !important;overflow:auto;padding:12px" class="htmlTableBody">';
					serverContent+='</div>';					
					legendDataArray=jsonData.serverOSChart.DataSet[0].data;
					leftChartContent1Legends+='<div><table>';
					serverContentBarLegends+='<div><table>';
					for(var i=0;i<legendDataArray.length;i++)
					{
						leftChartContent1Legends+='<tr><td><div style="background-color:'+legendDataArray[i].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td></tr>';
					}
					leftChartContent1Legends+='</table></div>';
					legendDataArray=jsonData.serverOSBar.DataSet;
					for(var i=0;i<legendDataArray.length;i++)
					{
						serverContentBarLegends+='<tr><td><div style="background-color:'+legendDataArray[i].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td></tr>';
					}
					serverContentBarLegends+='</table></div>';
				}
				else
				{
				   content1 = "<div align='center' style=\"height:220px;\"><img style='margin-top:50px;margin-left:5px' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
				   serverContentByDeliveryGp = "<div align='center' style=\"height:220px;\"><img style='margin-top:50px;margin-left:5px' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
				   serverContent="<div align='center' style=\"height:250px;\"><img style='margin-top:100px;' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
				}

				var content2 = '';
				var desktopContent = '';
				var desktopContentByDeliveryGp = '';
				var leftChartContent2Legends='';
				var desktopContentBarLegends='';
				if(jsonData['isDataFoundDesktop']==true)
				{
					content2+='<div id="leftChartContent2" style="height:220px;width:100%;padding:0px" class="htmlTableBody">';
					content2+='</div>';
					desktopContentByDeliveryGp+='<div id="desktopByDeliveryGp" style="height:220px;width:100%;padding:0px" class="htmlTableBody">';
					desktopContentByDeliveryGp+='</div>';
					desktopContent+='<div id="desktopContentBar" style="height:250px;width:100%;padding:12px" class="htmlTableBody">';
					desktopContent+='</div>';
						
					legendDataArray=jsonData.desktopOSChart.DataSet[0].data;
					leftChartContent2Legends+='<div><table>';
					desktopContentBarLegends+='<div><table>';
					for(var i=0;i<legendDataArray.length;i++)
					{
						leftChartContent2Legends+='<tr><td><div style="background-color:'+legendDataArray[i].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td></tr>';
					}
					leftChartContent2Legends+='</table></div>';
					legendDataArray=jsonData.desktopOSBar.DataSet;
					for(var i=0;i<legendDataArray.length;i=i+2)
					{
						if(i%2==0)
						{
							desktopContentBarLegends+='<tr>';
						}
						desktopContentBarLegends+='<td><div style="background-color:'+legendDataArray[i].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i].name+'</div></td>';
						legIndex=legIndex+1;
						if((i+1)<legendDataArray.length)
						{
							desktopContentBarLegends+='<td><div style="background-color:'+legendDataArray[i+1].color+';" class="legendSquare">&nbsp;</div></td><td style="padding:2px 20px 2px 5px;float:left" class="pieLegendFont"><div id="customLeg'+legIndex+'" style="cursor:pointer">'+legendDataArray[i+1].name+'</div></td></tr>';
							legIndex=legIndex+1;
						}
						else if(legendDataArray.length==1)
						{
							desktopContentBarLegends+='</tr>';
						}
						else
						{
							desktopContentBarLegends+='<td></td><td></td></tr>';
						}
					}
					desktopContentBarLegends+='</table></div>';
				}
				else
				{
					content2 = "<div align='center' style=\"height:220px;\"><img style='margin-top:50px;margin-left:5px' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
					desktopContentByDeliveryGp = "<div align='center' style=\"height:220px;\"><img style='margin-top:50px;margin-left:5px' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
					desktopContent="<div align='center' style=\"height:250px;\"><img style='margin-top:100px;' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
				}
				var gridPageSize=15;
				var isPagingHiddenConnection=false;
				
				if(appConstants.reportFor == 'ConnectionFailers')
				{
					if (jsonData.connectionData.length<gridPageSize)
						isPagingHiddenConnection = true;
					else
						isPagingHiddenConnection = false;
				}
				
				var activePageCon=1;
				var headings = new Array();
				if (!Ext.isEmpty(jsonData.heading_1) && jsonData.heading_1!=undefined)
				{
					var s=0;
					for(var key in jsonData.heading_1)
					{
						headings[s] = key;
						s++;
					}
				}
				headings[s] = 'dataDetails';
				var colLength = jsonData.colLength;
				var connectionDetails =  '';
				var conExpandDetail = '';
				if(jsonData['expandFoundCon']!=''){
					conExpandDetail=[{
							ptype: 'rowexpander',
							selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
							expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
							expandOnEnter : false,
							collapsible: true,
							animCollapse: false,
							rowBodyTpl: ['<div style="padding:10px 20px 10px 10px;" >{dataDetails}</div>']
						}];
				}
				if(appConstants.reportFor == 'ConnectionFailers')
				{
				var colm = new Array();
				for(var keys in jsonData.heading_1)
				{
					colm.push({
						header: jsonData.heading_1[keys],
						sortable: true,
						dataIndex: keys,
						align:keys=='info'?'left':'center',
						width:keys=='clientConnFailures'?200:160,
						renderer :function(value, metaData, record, row, col, store, gridView)
						{
							value=me.getNumberFormat(value.toString());
							return value;
						}
					});
				}
				var store = Ext.create('Ext.data.Store', {
					fields: headings,
					data: jsonData.connectionData,
					pageSize:gridPageSize,
					autoLoad : true,
					proxy : {
					  type : 'pagingmemory'
					}
				});
				
					if(jsonData['isDataFoundCon']==true){
							connectionDetails = Ext.create('Ext.container.Container', {
								layout :'column',
								margin:'0 0 0 0',
								items:[
								{
									xtype:'container',
									columnWidth:0.4,
									margin:'5 0 5 0',
									layout:'column',
									items:[
										{
											xtype:'panel',
											title : 'Total User Connection Failures',
											ui:'newGraphPanel',
											columnWidth:1.0,
											align:'stretch',
											margin:'0 10 5 0',
											padding:'0 0 0 0',
											html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconFailedSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData['total'] +'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">Number</span></td></tr></table>'

										//	html: '<table align="center"><tr><td><img src="/final/images/spacer.gif" class="iconFailedSimulations"/></td><td align="center" style="padding:0px 0px 0px 5px"><span class="newFont_bold28">'+jsonData['total'] +'</span></td></tr><tr><td>&nbsp;</td><td align="center" ><span class=newFont_normal13>Number</span></td></tr></table>',
										},
										{
											xtype:'panel',
											//title : 'User Connection Failures by Type',
											title : 'Types of User Connection Failures',
											ui:'newGraphPanel',
											flex:1,
											layout:{
												type:'hbox',
												align:'stretch',
											},
											columnWidth:1,
											margin:'5 10 5 0',
											items:[
												{
													xtype:'container',
													html: content,
												},
												{
													xtype:'container',
													margin:'0 0 10 0',
													flex:1,
													layout: {
														type:'fit',
														align:'stretch',
														pack : 'center'
													},
													cls:'egFlexCenterByColumnWise',
													html: leftChartContentLegends
												}
											]
										}
									]
								},
								{
									xtype:'panel',
									ui:'newGraphPanel',
									title : 'User Connection Failures Trend',
									margin:'5 2 5 0',
									columnWidth:0.6,
									html:connectionContent
								}
								]
							});
						}else{
								connectionDetails = Ext.create('Ext.panel.Panel', {
								title : 'Total User Connection Failures',
								//layout :'column',
								ui:'newGraphPanel',
								margin:'5 2 10 0',
								height:200,
								layout:'fit',
								items:[{
									xtype:'container',
									cls:'egFlexCenterByColumnWise',
									flex:1,
									html: '<div class="iconExclamation"></div><div class="">'+ appConstants.defaultLoadData['noFailMSG']+'</div>'
								}],								
							});
						}
						resultPanelObj.add(connectionDetails);
						if(jsonData['isDataFoundCon']==true)
						{
							connectionDetails=Ext.create('Ext.panel.Panel',{
								title : 'Types of User Connection Failures by Delivery Group',
								ui:'newGraphPanel',
								margin:'0 2 10 0',
								items:[
									{
										xtype:'customgrid',
										sortableColumns: true,
										//cls: 'newGridSkinRE',
										ui:'newGridPanel noHoverColor',
										id:'grid0',
										margin:'0 10 10 10',
										border:true,
										scroll: true,
										autoScroll:true,
										forceFit:true,
										store: store,
										columns: colm,
										plugins: conExpandDetail,
										viewConfig:
										{
											stripeRows: true,
											getRowClass: function (record, rowIndex, rowParams, store)
											{
												if (record.raw.dataDetails =='')
												{
													return 'hidePlus';
												}
												else
												{
													return;
												}
											},
											listeners: 
											{
												sortchange:function(ct, column, e, t, eOpts ){
													me.gridColIndexParam=column.getIndex();
													me.gridColStateParam=column.sortState;
													this.getStore().loadPage(activePageCon);
												}
											}
										},
										dockedItems:[{
											xtype:'pagingtoolbar',
											//cls:'pagingtoolbar',
											cls:'newPagination',
											dock: 'bottom',
											displayInfo: true,
											store: store,
											hidden:isPagingHiddenConnection,
											displayInfo: true,
											displayMsg: 'Displaying topics {0} - {1} of {2}',
											emptyMsg: "No topics to display",
											listeners: {
												change : function(thisd, params)
												{   
													if(!Ext.isEmpty(params))
														activePageCon = params.currentPage;
													else
														activePageCon=1;
												}
											}
										}]
									}
								]
							});
						}
						else
						{
							connectionDetails = Ext.create('Ext.panel.Panel', {
							ui:'newGraphPanel',
							title : 'User Connection Failures',
							margin:'0 2 2 0',
							html:"<div align='center' style=\"height:250px;\"><img style='margin-top:50px;' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>"
						});
						}
						resultPanelObj.add(connectionDetails);
					}
				
				resultPanelObj.show();			
				if(jsonData['isDataFoundCon']==true)
				{
					var highChart_pie = {};
					highChart_pie = jQuery.extend(true, {}, getHighChartsBarInstance('leftChartContent',200,170), highChart_pie);
					highChart_pie.setData(jsonData.userConnection,'<%=currentDateFormat%>','');
					highChart_pie.drawChart();

					var highChart_bar1 = {};
					highChart_bar1 = jQuery.extend(true, {}, getHighChartsBarInstance('connectionContentBar',290,600), highChart_bar1);
					highChart_bar1.setData(jsonData.connectionBar,'<%=currentDateFormat%>','');
					highChart_bar1.drawChart();				
				}
				var isPagingHiddenServer=false;
				if(appConstants.reportFor == 'MachineFailers' || appConstants.reportFor == 'MachineFailersDetail')
				{
				if(appConstants.reportFor == 'MachineFailers')
				{	
					var showDesktopPie=jsonData['isDataFoundDesktop']==true?false:true;				
					var serverOSfailure =  '';			
					serverOSfailure = Ext.create('Ext.container.Container', {		
					layout :'column',
					margin:'5 2 10 0',
					items:[{
						xtype:'panel',
						margin:'0 10 0 0',			
						columnWidth:0.5,	
						ui:'newGraphPanel',
						title:'Server OS Failures By Type',
						html: content1,
					},	
					{
						xtype:'panel',		
						columnWidth:0.5,
						ui:'newGraphPanel',
						title:'Desktop OS Failures By Type',
						html: content2
					},
					]
				});			
				resultPanelObj.add(serverOSfailure);	
				if(jsonData['isDataFoundServer']==true)
				{
					var highChart_pie1 = {};
					highChart_pie1 = jQuery.extend(true, {}, getHighChartsBarInstance('leftChartContent1',210,400), highChart_pie1);
					highChart_pie1.setData(jsonData.serverOSChart,'<%=currentDateFormat%>','');
					highChart_pie1.drawChart();
				}				
				if(jsonData['isDataFoundDesktop']==true)
				{
					var highChart_pie2 = {};
					highChart_pie2 = jQuery.extend(true, {}, getHighChartsBarInstance('leftChartContent2',210,400), highChart_pie2);
					highChart_pie2.setData(jsonData.desktopOSChart,'<%=currentDateFormat%>','');
					highChart_pie2.drawChart();			 
				}				
					
				var serverOsByDeliveryGp='';
				serverOsByDeliveryGp=Ext.create('Ext.container.Container',{
					layout :'column',				
					margin:'10 2 10 0',
					items:[
						{
							xtype:'panel',
							ui:'newGraphPanel',
							margin:'0 10 0 0',
							columnWidth:0.5,
							title:'Server OS Failures By Delivery Group',			
							html:serverContentByDeliveryGp,
						},
						{
							xtype:'panel',
							ui:'newGraphPanel',
							title:'Desktop OS Failures By Delivery Group',
							columnWidth:0.5,					
							html:desktopContentByDeliveryGp,
						},
					]
				});
				resultPanelObj.add(serverOsByDeliveryGp);	
				if(jsonData['isDataFoundServer']==true)
				{
					var highChart_pie1 = {};
					highChart_pie1 = jQuery.extend(true, {}, getHighChartsBarInstance('serverByDeliveryGp',200,400), highChart_pie1);
					highChart_pie1.setData(jsonData.serverOSFailByDeliveryGroup,'<%=currentDateFormat%>','');
					highChart_pie1.drawChart();
				}				
				if(jsonData['isDataFoundDesktop']==true)
				{
					var highChart_pie2 = {};
					highChart_pie2 = jQuery.extend(true, {}, getHighChartsBarInstance('desktopByDeliveryGp',200,400), highChart_pie2);
					highChart_pie2.setData(jsonData.desktopOSFailByDeliveryGroup,'<%=currentDateFormat%>','');
					highChart_pie2.drawChart();			 
				}
				var desktopOSfailure = '';			
				desktopOSfailure = Ext.create('Ext.container.Container', {
					layout :'column',				
					margin:'10 2 10 0',
					items:[
					{
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'0 10 0 0',
						columnWidth:0.5,
						title:'Server OS Failures Trend',			
						html:serverContent,
					},
					{
						xtype:'panel',
						ui:'newGraphPanel',
						title:'Desktop OS Failures Trend',
						columnWidth:0.5,					
						html:desktopContent,
					},
					]
					});			
					resultPanelObj.add(desktopOSfailure);
					if(jsonData['isDataFoundDesktop']==true)
					{
						reportForHighChart('desktopContentBar',jsonData.desktopOSBar);
					}
					if(jsonData['isDataFoundServer']==true)
					{
						reportForHighChart('serverContentBar',jsonData.serverOSBar);
					}

				}
				if(appConstants.reportFor == 'MachineFailersDetail')
				{
					var detailDataLine=jsonData.detailDataLine;
					var isLineData=false;
					var detailLineHtml='';
					if(jsonData.isDetailLineEnable)
					{
						isLineData=true;
						detailLineHtml+='<div id="detailLineId" style="height:300px;width:97% !important;overflow:auto;padding:0px" class="htmlTableBody">';
						detailLineHtml+='</div>';
					}
					else
						detailLineHtml = "<div align='center' style=\"height:220px;\"><img style='margin-top:50px;margin-left:5px' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>";
					var detailLine='';
					detailLine=Ext.create('Ext.container.Container',{
						layout :'column',				
						margin:'5 2 10 0',
						items:[
							{
								xtype:'panel',
								ui:'newGraphPanel',
								columnWidth:1.0,
								title:jsonData.lineChartTitle,
								html:detailLineHtml,
							}
						],
						
					});
					resultPanelObj.add(detailLine);	
					if(isLineData)
					{
						reportForHighChart('detailLineId',detailDataLine);
					}							
					var gridContent = '';
					if(!jsonData['isDetailTableEnable'])
					{
						gridContent = Ext.create('Ext.panel.Panel', {
							ui:'newGraphPanel',
							title:jsonData.gridTitle,
							html:"<div align='center' style=\"height:250px;\"><img style='margin-top:50px;' src='/final/images/"+strSkin+"/nomeasures_custom.png' /></div>"
						});
					}
					else
					{
						var gridArry=new Array();
						gridArry.push(this.getGrid_machineFail_detail(jsonData));
						gridContent = Ext.create('Ext.panel.Panel', {
							layout :'column',
							ui:'newGraphPanel',
							title:jsonData.gridTitle,
							id:'machinFailId',
							margin:'5 2 10 0',
							tools:[
								{
									xtype:'container',
									id:'machinToolId',
									html:'<img src="/final/images/spacer.gif" class="iconMagnify" id="callTooltip" style="vertical-align:middle;margin:5px 3px 0px 3px;" border="0px" onclick="javascript:openSmallPopupWindow(\''+jsonData.headingSelCol+'\',\''+jsonData.heading+'\');"/>'
								}
							],
							items:gridArry
						});
					}
					resultPanelObj.add(gridContent);
					}
				}
				resultPanelObj.doLayout();
				appConstants.LoadingMask.hide();
			}
		});
	},
	openSmallPopupWindow:function(headingSelCol,heading1){
		if(Ext.isEmpty(Ext.getCmp('GenericWindowId')))
		{
			var allColumnArray=[];
			var me= this;
			var heading=heading1.split(",");
			var headingGrid=heading;	
			if(headingSelCol != undefined && headingSelCol != 'undefined' && headingSelCol.length > 0)
			{
				headingGrid=headingSelCol.split(",");
			}		
			for(var n in heading)
			{
				var eachCol=heading[n];
				var checkedField=false;
				if(headingGrid.includes(eachCol))
				{
					checkedField=true;
				}
				var citBxLable=eachCol;
				if(citBxLable.indexOf("$") != -1)
					citBxLable=citBxLable.substring(0,citBxLable.indexOf("$"));
				if(citBxLable.indexOf("|") != -1)
				{					
					citBxLable=citBxLable.substring(citBxLable.indexOf("|")+1);
				}
				allColumnArray.push(
					{
						xtype:'checkbox',
						cls:'checkbt',
						boxLabel:citBxLable,
						name:eachCol,
						inputValue:eachCol,
						checked:checkedField,
						style:{'overflow-x':'hidden','white-space': 'nowrap','margin-right':'12px'},
					}	
				);
			}
			var gWindow = Ext.create('Ext.tip.ToolTip', {
				anchor:'top',
				anchorToTarget:true,
				anchorOffset:470,
				//trackMouse:true,
				//mouseOffset:'40,40',
				target:'callTooltip',
				scroll: false,
				layout: 'fit',
				autoHide:false,
				border:false,
				width:540,
				maxWidth:540,
				//margin:'10 40 40 10',
				height:246,
				id:'GenericWindowId',
				closeAction: 'destroy',
				closable:true,
				ui:'newTooltipPopup',
				title:'Select Required Columns',
//				layout : {
//					type : 'vbox',
//					align : 'stretch',
//					pack : 'center'
//				},
				listeners:{
					hide:function(){
						if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
							Ext.getCmp('GenericWindowId').doClose();
						}
					},
					el:{
						'mouseenter':function(){
							if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
								Ext.getCmp('GenericWindowId').show();
							}
						},
						'mouseleave':function(){
							if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
								Ext.getCmp('GenericWindowId').doClose();
							}
						}
					}
				},
				items:[
					{
						xtype:'container',
						id:'chkPanel',
						layout: {            
							type:'vbox',
							align:'center'
						},
						items:[
							{
								xtype:'panel',
								id:'chekboxAllCitrixCol',
								style:{'overflow-x':'hidden'},
								items:[
									{
										xtype:'checkboxgroup',
										columns:3,											
										vertical:true,
										margin:6,
										labelAlign:'right',
										id:'multiColCitrixchkboxgroup',
										items:allColumnArray,
									}
								]
							},
							{
								xtype: 'button',
								text: 'Update',
								id:'updateBtn',
								itemId: 'Update',
								margin:'0 0 0 0',
								ui:'newButtonSmall',
								listeners: {
									'click': function () 
									{
										var selectedCols=Ext.getCmp('multiColCitrixchkboxgroup').getChecked();		
										colm_2 = new Array();
										colWidth=150;
										colName='';								
										var machinFailId=Ext.getCmp('machinFailId');
										machinFailId.removeAll();					
										var selColArry=[];
										appConstants.selectedGridColumns='';
										Ext.each(selectedCols,function(obj,index){
											selColArry.push(obj.getSubmitValue());
											appConstants.selectedGridColumns+=obj.getSubmitValue();//..
											if(index < selectedCols.length-1)
											{
												appConstants.selectedGridColumns+=",";
											}
										});
										var param='gridChange=yes&selColArry='+Ext.encode(selColArry)+"&selectedGridColumns="+appConstants.selectedGridColumns;

										Ext.Ajax.request({
											url:'/final/reporter/ErCitrixConnectionDetailJson.jsp',
											params:param,
											scope:this,
											method:'POST',
											success:function(response)
											{
												var jsontext=response.responseText;
												var newJsonDataGrid = Ext.decode(jsontext);
												machinFailId.add(me.getGrid_machineFail_detail(newJsonDataGrid));
												if(!Ext.isEmpty(Ext.getCmp('GenericWindowId'))){
													Ext.getCmp('GenericWindowId').doClose();
												}
												Ext.getCmp('machinToolId').update('<img src="" class="iconMagnify" id="callTooltip" style="vertical-align:middle;margin:5px 0px 0px 3px;" onclick="javascript:openSmallPopupWindow(\''+newJsonDataGrid.headingSelCol+'\',\''+newJsonDataGrid.heading+'\');"/>');
											}
										});
									}
								}
							}
						]
					}
				]
			}).show();
		}
	},	
	getGrid_machineFail_detail:function(jsonData)
	{	
		var gridArry=[];
		var me= this;
		var isPagingHiddenServer=false;
		var gridPageSize=15;
		if (jsonData.detailData.length<gridPageSize)//..
			isPagingHiddenServer = true;
		else
			isPagingHiddenServer = false;
		var headingGrid=jsonData.heading;
		if(jsonData.headingSelCol != undefined && jsonData.headingSelCol.length > 0)
		{
			headingGrid=jsonData.headingSelCol;
		}
		var storeServer = Ext.create('Ext.data.Store', {
			fields: headingGrid,
			data: jsonData.detailData,
			pageSize:gridPageSize,
			autoLoad : true,
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'array'
				}
			}
		});
		var colm_2 = new Array();
		var colWidth=150;
		var colName='';
		for(var keys_2 in headingGrid)
		{
			colName=headingGrid[keys_2];
			if(colName != undefined && colName.indexOf("$") != -1)
			{
				colWidth=colName.substring(colName.indexOf("$")+1);
				colName=colName.substring(0,colName.indexOf("$"));
			}
			if(colName.indexOf("|") != -1)
			{					
				colName=colName.substring(colName.indexOf("|")+1);
			}
			colWidth=parseFloat(colWidth);
			colm_2.push({
				header: colName,
				sortable: true,
				dataIndex: headingGrid[keys_2],
				align:'left',
				sortable: true,
				customWidth:colWidth,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			});
		}
		var forceFitColsCount=8;
		var forceFit = true;
		if(forceFitColsCount < headingGrid.length)
			forceFit=false;
		return {
			xtype:'customgrid_builder',	
			columnWidth:1,
			sortableColumns: true,						
			ui:'newGridPanel',
			frame:false,
			border:true,
			scroll: true,
			autoScroll:true,
			needtoFixColumn:true,
			forceFit: forceFit,
			layout:'fit',
			align:'stretch',				
			id :'grid1',
			margin:'0 10 10 10',
			hidden:!jsonData['isDetailTableEnable'],
			store: storeServer,
			columns: colm_2,	
			dockedItems:[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				store: storeServer,
				hidden:isPagingHiddenServer,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{   
						if(!Ext.isEmpty(params))
							activePageServer = params.currentPage;
						else
							activePageServer=1;
					}

				}					
			}]
		};
	},
	 //prakash
	/* excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },*/	//end

	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:569,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'385px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'CitrixConnectionDetailSettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		 
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 
		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 
		Ext.getCmp('glduration').hide();
		Ext.getCmp('duraSelect').hide();
		Ext.getCmp('duration').hide();
		 
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		Ext.getCmp('moreOptionCloseId').show();	
		var me = this;
		   Ext.get('closeSettings').on('click', function() {
			   me.validateAndCloseSettings();
		   });
	},
	validateAndCloseSettings:function()
	{
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.get('configMod').animate({
			duration: 500,
			to: 
			{
				y: -500
			}
		 });
		return true;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var reportBy = Ext.getCmp('er_option').getValue();
		var er_deliverGrup=Ext.getCmp('er_deliverGrup').getValue();
		var erOsMachine_type=Ext.getCmp('erOsMachine_type').getValue();
		var er_measureBy=Ext.getCmp('er_measureBy').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
	   
		var selectedcompArray = Ext.getCmp('er_server').getValue();
	
   
		if( reportBy== '-1')
		{
			this.showMessage('Report By is Not Applicable');
			return false;
		}
		else if(!(reportBy == 'Component') && repSubType=='-1')
		{
			this.showMessage(reportBy+'is Not Applicable');
			return false;
		}
		else if(selectedcompArray[0] == '-1')
		{
		   this.showMessage('Components is Not Applicable');
		   return false;
		}
		if (selectedcompArray.length > 1 && selectedcompArray.indexOf('All') > -1)
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		var component = '';
		var usr = '';
		var temCom = '&component='
		var tmpUsr = '&usr='
		
		for (var ci = 0; ci < selectedcompArray.length; ci++) {
			component += temCom + selectedcompArray[ci];
		}
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType  + component;
		if(enableDeliveryDetails)
			params+='&er_deliverGrup='+er_deliverGrup+'&er_measureBy='+er_measureBy+'&erOsMachine_type='+erOsMachine_type;
		//Timeline Variables 
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue();

		startDate.setHours(startHr);
		endDate.setHours(endHr);          
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var durationType = Ext.getCmp("glduration").getValue();
			var duration = Ext.getCmp("duration").getValue().toString();
			var unit = Ext.getCmp("duraSelect").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
			}
			params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
			params2+= '&er_reportgenration='+rGenType+'&bg_reportname='+reportName;
		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		var comptype = '&comptype=Citrix_XcXenDesktop_Director';
		params += params1;
		params += params2;
		params += userID;
		params += comptype;
		params += "&selectedGridColumns="+encodeURIComponent(appConstants.selectedGridColumns);//..for selected grid column
		params +="&er_reportFor="+appConstants.reportFor; 
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title: 'User log no summary',
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});