Ext.create('Ext.panel.Panel', {
					title : 'User connection Failure',
					layout :'column',
					ui:'newPanelWidget',
					margin:'5 2 10 0',
					items:[{
						xtype:'container',
						margin:'0 5 20 10',
						columnWidth:0.4,
						cls:'graphSeperatorLineRight',
						layout:'column',
						items:[{
							xtype:'container',
							columnWidth:1.0,
							align:'stretch',
							height:'70',
							margin:'0 0 0 0',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items: [
							{
								xtype:'container',
								height:'60',
								margin:'10 0 0 0',
								html: '<table><tr><td><img src="/images/spacer.gif" class="iconFailedSimulations"/></td><td align="center" style="padding:0px 0px 0px 5px"><span class="newFont_bold28">'+jsonData['total'] +'</span></td></tr><tr><td>&nbsp;</td><td align="center" ><span class=newFont_normal13>Total</span></td></tr></table>',
							}]
						},
						{
							xtype:'container',
							columnWidth:1.0,
							html: content
						},
						{	
							xtype:'container',
							columnWidth:1.0,
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items: [
							{
								xtype:'container',
								html: leftChartContentLegends
							}]
							
						}]
					},
					{
						xtype:'container',
						margin:'0 10 0 5',
						columnWidth:0.6,
						layout:'column',
						items:[
						{
							xtype:'container',
							html:connectionContent,
							columnWidth:1.0,
						},
						{	
							xtype:'container',
							columnWidth:1.0,
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items: [
							{
								xtype:'container',
								html: connectionContentBarLegends
							}]
						}]
					},
					{
						xtype:'grid',
						sortableColumns: true,
						cls: 'newGridSkinRE',
						style:{'box-shadow':'none'},
						id:'grid0',
						columnWidth:1,
						margin:10,
						scroll: false,
						autoScroll:true,
						store: store,
						columns: [
						{
							text: 'Delivery Group Name',
							dataIndex: 'info',
							flex:1,
						},
						{
							text: 'Client connection failures',
							dataIndex: 'clientConnFailures',
							flex:1,
						},
						{
							text: 'Configuration errors',
							dataIndex: 'configErrors',
							flex:1,
						},
						{
							text: 'Machine failures',
							dataIndex:'machineFailures',
							flex:1,
						},
						{
							text: 'Unavailable capacity',
							dataIndex:'unavailCapacity',
							flex:1,
						},
						{
							text: 'Unavailable licenses',
							dataIndex:'unavailLicenses',
							flex:1,
						}],
						plugins: [{
							ptype: 'rowexpander',
							selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
							expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
							expandOnEnter : false,
							collapsible: true,
							animCollapse: false,
							rowBodyTpl: ['<div style="padding:10px 20px 10px 10px;" >{dataDetails}</div>']
						}],
						viewConfig:
						{
							stripeRows: true,
							getRowClass: function (record, rowIndex, rowParams, store)
							{
								if (record.data.dataDetails =='')
								{
									return 'hidePlus';
								}
								else
								{
									return;
								}
							},
							listeners: 
							{
								sortchange:function(ct, column, e, t, eOpts ){
									me.gridColIndexParam=column.getIndex();
									me.gridColStateParam=column.sortState;
									this.getStore().loadPage(activePageCon);
								}
							}
						},	dockedItems:[{
								xtype:'pagingtoolbar',
								cls:'pagingtoolbar',
								dock: 'bottom',
								displayInfo: true,
								cls:'pagingtoolbar',
								store: store,
								hidden:isPagingHiddenConnection,
								displayInfo: true,
								displayMsg: 'Displaying topics {0} - {1} of {2}',
								emptyMsg: "No topics to display",
								listeners: {
									change : function(thisd, params)
									{   
										if(!Ext.isEmpty(params))
											activePageCon = params.currentPage;
										else
											activePageCon=1;
									}
 									}
								
				}]
					}]
				})