Ext.define('CitrixConnectionDetailDrillDown.controller.CitrixConnectionDetailDrillDown', {
	extend: 'Ext.app.Controller',
	views: ['Main'],
	refs: [
			{
				selector: 'main',
				ref: 'main'
			},
		
			{
				selector: 'newUtilities',
				ref: 'newUtilities'
			},
			{
				selector: 'resultpanel',
				ref: 'resultpanel'
			},
			{
				selector: 'nomeasurepanel',
				ref: 'nomeasurepanel'
			}
		],
    init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
    loadTools: function()
	{
        this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
    },
    afterMainRender: function()
	{
		var jData = appConstants.defaultLoadData;
		Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.defaultLoadData.connectionBar.selectionDetails);
		Ext.getCmp('selectionDetails').show();
		Ext.getCmp('upbutton').hide();
		this.submitReport();
    },
	saveReportAsPDF: function() 
	{
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	printReport: function() 
	{
		var s_qryString = "/final/reporter/ErCitrixConnectionDetailDrillDownPrint.jsp?&pdfPrint=yes";
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{
		window.location = '../servlet/com.eg.ErCitrixConnectionDetailDrillDownReportC?er_view=CSV';
	},
    submitReport: function(qryStr)
	{
		var resultPanelObj = Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var connectionDetails = Ext.create('Ext.panel.Panel', {
			renderTo: Ext.getBody(),
			ui:'newGraphPanelForWindow',
			border : true,
			autoScroll:false,
			scroll: false,
			frame : false,
			items: [
			{
				xtype:'container',
				margin:'10 10 0 10',
				layout: 
				{
					type:'fit'
				},
				border:true,
				html: '<div id="leftChartContent1" style="width:95%;height:350px;" class="htmlTableBody"></div>'
			}]
		});
		resultPanelObj.show();
		var timelineChart = {};
		timelineChart = jQuery.extend(true, {}, getHighChartsInstance('leftChartContent1',appConstants.defaultLoadData.connectionBar.chartHeight,appConstants.defaultLoadData.connectionBar.chartWidth), timelineChart);
		timelineChart.setData(appConstants.defaultLoadData.connectionBar,appConstants.currentDateFormat,'');
		timelineChart.drawChart();
		resultPanelObj.add(connectionDetails);
		
	},
	toggleForm:function(obj){}
});