Ext.define('CitrixMachineReport.controller.CitrixMachineReport', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'EgComponent'],
	refs: [
		{selector: 'main',ref: 'main'},
		{selector: 'newUtilities',ref: 'newUtilities'},
		{selector: 'egcomponent',ref: 'egcomponent'}, 
		{selector: 'CitrixMachineReportForm',ref: 'CitrixMachineReportForm'},
		{selector: 'mainform',ref: 'mainform'},
		{selector: 'resultpanel',ref: 'resultpanel'},
		{selector: 'nomeasurepanel',ref: 'nomeasurepanel'},
		{selector: 'CitrixMachineReportSettings',ref: 'CitrixMachineReportSettings'}
	],
	init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click': this.modifyScheduleFavorite
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'mainform button[id="expandSelectorUser"]':
			{
				'click': this.expandMeUser
			},
			'CitrixMachineReportForm combo[id="er_option"]':
			{
				'select': this.onSelectReportBy
			},
			'CitrixMachineReportForm combo[id="select_farm"]':
			{
				'select': this.onSelectReportSubType
			},
			'CitrixMachineReportForm combo[id="erOsMachine_type"]':
			{
				'select': this.onSelectMachineType
			},
			'CitrixMachineReportForm combo[id="er_dataFor"]':
			{
				'select': this.onSelectReportFor
			},
			'egcomponent multiselectfield[name="er_server"]':
			{
				'change': this.ComponentOnChange
			},
			'mainform trigger[id="compSearch"]':
			{
				'change': this.compMultiselect
			},
			'erapplication trigger[id="userSearch"]':
			{
				'change': this.filterMultiselect
			},
			'CitrixMachineReportSettings':
			{
				'afterrender': this.closeSetting
			},
			'CitrixMachineReportSettings combo[name="reportGeneration"]':
			{
				'select': this.reportGenChange
			},
			'CitrixMachineReportSettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'CitrixMachineReportSettings button[id="moreOptionCloseId"]':
			{
				'click': this.validateAndCloseSettings
			},
		   'CitrixMachineReportSettings combo[id="er_excwe"]': {
				"select": this.excludeWeekendsChange
			},
				'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	loadTools: function() 
	{
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function()
	{
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData = appConstants.defaultLoadData
		
		this.setErOptionData(jData);
		this.setMachineTypeData(jData);
		this.setDeliveryGroupData(jData);
		this.setReportForData(jData);
		this.setSelectFarmData(jData);
		this.setServerData(jData);

		var erTimeline = Ext.getCmp('er_timeline');
		erTimeline.getStore().loadRawData(jData['timelineCombo']);
		erTimeline.setValue(jData['selectedTimeline']);
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray = jData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray = jData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		Ext.getCmp('CitrixMachineReportForm').add({
			xtype: 'hidden',
			id: 'ID',
			name: 'ID',
			value: jData['ID']
		});
	},
	expandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'), Ext.getCmp('compLbl').text, btn);
	},
	expandMeUser: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'), Ext.getCmp('appLbl').text, btn);
	},
	setErOptionData: function(jData)
	{ 
		//Report By
		var reportBy = Ext.getCmp('er_option');
		reportBy.getStore().loadRawData(jData['reportBy']);
		reportBy.setValue(jData['selectedreportBy']);
		if (jData['selectedreportBy'] == 'Component')
		{
			Ext.getCmp('select_farm').hide();
		}
		else 
		{
			Ext.getCmp('select_farm').show();
		}
		reportBy.setFieldLabel(jData.screenLabelJson['reportByLabel']);
	},
	setDeliveryGroupData:function(jData)
	{
		var deliverGrup = Ext.getCmp('er_deliverGrup');
		deliverGrup.getStore().loadRawData(jData['deliveryGroupArrry']);
		deliverGrup.setValue(jData['selectedDeliveryGroup']);		
		deliverGrup.setFieldLabel(jData.screenLabelJson['lblDeliveryGrp']);
	},
	setMachineTypeData:function(jData)
	{
		var erOsMachine_type=Ext.getCmp('erOsMachine_type');		
		erOsMachine_type.getStore().loadRawData(jData['MachineTypeTypeArry']);
		erOsMachine_type.setValue(jData['selectedMachineType']);
		erOsMachine_type.setFieldLabel(jData.screenLabelJson['lblMachineType']);
	},
	setReportForData:function(jData)
	{
		var measureby=Ext.getCmp('er_dataFor');
		measureby.getStore().loadRawData(jData['dataForCombo']);
		var selectedDataFor = jData['selectedDataFor']
		var er_timelineVal = '1 day';
		if(selectedDataFor=='Current')
		{
			Ext.getCmp('timeline_ID').hide();
			er_timelineVal = appConstants.CurrentTimePeriod;
		}
		else
		{
			Ext.getCmp('timeline_ID').show();
		}
		measureby.setValue(selectedDataFor);
		measureby.setFieldLabel(jData.screenLabelJson['lblMeasureType']);
	},
	setSelectFarmData: function(jData)
	{ 
		// Values of Zone  or segments or service ..
		var screenLable = jData.screenLabelJson;
		var reportSubType = Ext.getCmp('select_farm');
		reportSubType.setFieldLabel(screenLable['lblAnalysisBySub']);
		reportSubType.getStore().clearFilter(true);
		reportSubType.getStore().loadRawData(jData['zoneCombo']);
		reportSubType.setValue(jData['selectedreportBySubType']);
	},
	setServerData: function(jData)
	{
		//components
		var components = Ext.getCmp('er_server');
		components.getStore().clearFilter(true);
		components.getStore().loadRawData(jData['serverCombo']);
		if (!Ext.isEmpty(jData['selectedServer']) && jData['selectedServer']!=undefined)
		{
			components.setValue(jData['selectedServer']);
		}
		else
		{
			components.setValue(jData['serverCombo'][0].valueField);
		}
		
	},
	//Onchange drop down value setting starts from here 
	onSelectReportBy: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var reportBy = 'reportBy=' + thisVal+'&er_reportFor='+appConstants.reportFor;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixMachineReportJson.jsp',
			scope: this,
			method: 'POST',
			params: reportBy,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				if (thisVal == 'Component')
				{
					Ext.getCmp('select_farm').hide();
				}
				else 
				{
					Ext.getCmp('select_farm').show();
					formObj.setSelectFarmData(jsonData);
				}
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectMachineType: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var select_farm = Ext.getCmp('select_farm').getValue();
		var erMachineType=obj.getValue();
		var selectedcompArray = Ext.getCmp('er_server').getValue();
		var temCom = '&component=';
		var component = '';
		for (var ci = 0; ci < selectedcompArray.length; ci++) 
		{
			component += temCom + selectedcompArray[ci];
		}
		var params='erOsMachine_type='+erMachineType+'&method=getMachines&er_reportFor='+appConstants.reportFor+component;
		params+= '&reportBy=' + thisVal;
		params+= '&reportBySubType=' + select_farm;
		var formObj=this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
				url: '/final/reporter/ErCitrixMachineReportJson.jsp',
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.defaultLoadData = jsonData;
					formObj.setDeliveryGroupData(jsonData);
					appConstants.LoadingMask.hide();
				}
		});
	},
	onSelectReportFor:function(obj)
	{
		var objVal = Ext.getCmp('er_dataFor').getValue();
		var er_timelineVal = '1 day';
		if(objVal=='Current')
		{
			Ext.getCmp('timeline_ID').hide();
			er_timelineVal = appConstants.CurrentTimePeriod;
		}
		else
		{
			Ext.getCmp('timeline_ID').show();
		}
		var params = 'er_timeline=' + er_timelineVal;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixMachineReportJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				appConstants.LoadingMask.hide();
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var jData =jsonData;
		
				var erTimeline = Ext.getCmp('er_timeline');
				erTimeline.getStore().loadRawData(jData['timelineCombo']);
				erTimeline.setValue(jData['selectedTimeline']);
				var startDateObj = Ext.getCmp('er_stdate');
				startDateObj.setValue(jData.startDateForDisplay);
				startDateObj.dataArray = jData.startDate;
				var startHrObj = Ext.getCmp('er_sthr');
				startHrObj.setValue(jData.startHourForDisplay);
				startHrObj.dataArray = jData.startHour;
				var endDateObj = Ext.getCmp('er_enddate');
				endDateObj.setValue(jData.endDateForDisplay);
				endDateObj.dataArray = jData.endDate;
				var endHrObj = Ext.getCmp('er_endhr');
				endHrObj.setValue(jData.endHourForDisplay);
				endHrObj.dataArray = jData.endHour;
				if(objVal=='Current')
				{
					//var startHr = Ext.getCmp("er_sthr");
					//startHr.setValue(jData.startMinForDisplay);
					appConstants.defaultLoadData.startmin = jData.startmin;

					//var endHr = Ext.getCmp("er_endhr");
					//endHr.setValue(jData.endMinForDisplay);
					appConstants.defaultLoadData.endmin = jData.endmin;
				}


			}
		});
	},
	onSelectReportSubType: function(obj)
	{
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType;
		var formObj = this;

		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixMachineReportJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectCompType: function(obj)
	{
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType + '&comptype=' + comptype;
		var formObj = this;

		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixMachineReportJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setServerData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	ComponentOnChange: function(obj, newValue, oldValue, eOpts)
	{
		if (newValue.length > 1 && newValue.indexOf('All') > -1)
		{
			this.showMessage('Choosen component group not allowed');
			return;
		}
		if (Ext.isEmpty(oldValue) || oldValue == undefined) 
		{
			return false;
		}
		var reportBy = Ext.getCmp('er_option').getValue();
		var repSubType = Ext.getCmp('select_farm').getValue();
		var selectedcompArray = Ext.getCmp('er_server').getValue();
		var erOsMachine_type=Ext.getCmp('erOsMachine_type').getValue();
		var component = '';
		var temCom = '&component='
		for (var ci = 0; ci < selectedcompArray.length; ci++) 
		{
			component += temCom + selectedcompArray[ci];
		}
		var params = 'reportBy=' + reportBy + '&reportBySubType=' + repSubType  + component+'&erOsMachine_type='+erOsMachine_type+'&er_reportFor='+appConstants.reportFor;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCitrixMachineReportJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				formObj.setDeliveryGroupData(jsonData);				
				appConstants.defaultLoadData = jsonData;
				appConstants.LoadingMask.hide();
			}
		});
	},
	saveReportAsPDF: function() 
	{
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	//
	bookletQuery: function(obj)
	{
		var s_qryString = '&er_reportFor='+appConstants.reportFor;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString();
		bookletquery+="&er_rtype="+appConstants.reportFor+"&er_trgttype=Citrix Machine Report&er_ViewName=ErCitrixMachineReport.jsp&er_RmDispName=Citrix_Connection_Detail";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	//
	printReport: function() 
	{
		var s_qryString = "/final/reporter/ErCitrixMachineReportPrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate+'&er_reportFor='+appConstants.reportFor;
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{
		window.location = '../servlet/com.eg.ErCitrixMachineReportC?isSubmitData=CSV';
	},
	saveSchedule: function(obj)
	{
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype="+appConstants.reportFor+"&er_trgttype=Citrix Machine Report&er_ViewName=ErCitrixMachineReport.jsp&er_RmDispName=Citrix_Connection_Detail&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.scheduleWindowFn(qryString);
	},
	saveFavorite: function()
	{
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=Citrix Machine Report&er_rtype="+appConstants.reportFor+"&er_ViewName=ErCitrixMachineReport.jsp&er_RmDispName=Citrix_Connection_Detail&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.favouriteWindowFn(target);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype=Citrix Machine Report&er_rtype='+appConstants.reportFor+'&er_ViewName=ErCitrixMachineReport.jsp&er_RmDispName=Citrix_Connection_Detail&&cmd=client'
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite;
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: qryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	compMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_server'), appConstants.defaultLoadData['serverCombo']);
	},
	filterMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_application'), appConstants.defaultLoadData['userCombo']);
	},
	submitReport: function(qryStr)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var params ='';
		this.getNomeasurepanel().hide();
		if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
		{
			//params =  qryStr;
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		console.log(rGenType)
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			//this.toggleForm();
			stDate.setHours(startHr);
			enDate.setHours(endHr);   
			params = encodeURI(params);
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			params += '&servletName=ErCitrixMachineReportC&er_rtype='+appConstants.reportFor+'&er_ViewName=ErCitrixMachineReport.jsp&er_RmDispName=Citrix_Connection_Detail';
			params += '&er_trgttype=Citrix Machine Report&forwardto=CitrixMachineReport&er_bgreportfrom=Citrix Machine Report&bgenabled=Yes&savereport=save';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
					
			}
			params = encodeURI(params);
			appConstants.LoadingMask.show();
			Ext.Ajax.request({
				url: bgUrl,
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					var resultPanelObj = Ext.getCmp('resultPanel');	
					resultPanelObj.removeAll();					
					var resultObj = Ext.getCmp('backGroundPanel');
					resultObj.removeAll();
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;					
					var htm='';
					if(status!=undefined && status =='success')
					{
						htm = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:115px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + reportValString.bgstr1
								+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
								+ reportValString.queryString + '>' + reportValString.bgstr2
								+ '</a> </div></div></center>';
					}
					else
					{
						htm = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:150px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + reportValString.bgstr1
								+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
								+ reportValString.queryString + '>' + reportValString.bgstr2
								+ '</a> </div></div></center>';
					}
					resultObj.update(htm);
					resultObj.show();
				}
			});
		}
	},
	submitReportByAjaxCall:function(params1)
	{
		appConstants.LoadingMask.show();
		var param = params1 + '&isSubmitData=submit';
		var me=this;
		Ext.Ajax.request({
			url: '../servlet/com.eg.ErCitrixMachineReportC?',			
			scope: this,
			method: 'POST',	
			params: param,
			success: function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');
				var legIndex=0;
				resultPanelObj.removeAll();
				resultPanelObj.show();
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(false);
				var jsonObject = response.responseText;
				var  jsonData = Ext.decode(jsonObject);		
				
				var summaryTitle = '<center>Summary</center>';
				var gridTitle = '';
				var isData = jsonData['isData'];
				var col1 = '';
				var col2 = '';
				if(isData && appConstants.reportFor == 'unregistered')
				{
					gridTitle = 'Details of Unregistered Machines';
					if(jsonData.summaryData != undefined)
					{							
						col1 = 'Total Unregistered Machines';
						col2 = 'Total Unique Delivery Groups'; 			
					}
				}
				else if(appConstants.reportFor == 'maintenance')
				{
					gridTitle = 'Details of Maintenance Mode Machines';
					if(jsonData.summaryData != undefined)
					{	
						col1 = 'Total Machines in Maintenance Mode';
						col2 = 'Total Unique Delivery Groups'; 	
					}
				}
				if(isData)
				{
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					//Summary 
					var summaryData = jsonData.summaryData;
					var machineCount = summaryData['machineCount'];
					var deliveryGrpCount = summaryData['deliveryGrpCount'];
					var uniqueTblStr ='';
					uniqueTblStr += '<div class="newTable"><table align="left" valign="middle" width="50%">';
					uniqueTblStr += '<thead><tr><th  align="center" colspan ="2">Summary</th></tr></thead>';
					uniqueTblStr += '<tbody>';
					uniqueTblStr += '<tr><td>'+col1+'</td><td>'+machineCount+'</td></tr>';
					uniqueTblStr += '<tr><td>'+col2+'</td><td>'+deliveryGrpCount+'</td></tr></tbody></table></div>';	
					resultPanelObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 10 10 10',
						id:'new_chk',
						title:title,
						items:[{
							xtype:'container',									
							margin:'0 10 10 10',
							html:uniqueTblStr
						}]
					});
					//Table
					var gridColumn = jsonData.columnData;
					var gridData = jsonData.gridData;
					var userViewColunmArray = new Array();
					var userDetailsFields = new Array();
					for(var key in gridColumn)
					{
						var align = 'left';
						var mainColumn = gridColumn[key];
						userDetailsFields.push(mainColumn);
						userViewColunmArray.push({
							header: mainColumn,
							sortable: true,
							resizable :true,
							//flex:1,
							align:align,
							dataIndex: mainColumn,
							renderer :function(value, metaData, record, row, col, store, gridView)
							{
								metaData.tdAttr = 'data-qtip="' + value + '"';
								return value;
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);

										if(v1.indexOf('.')>-1)
										{
											var tmp = v1.substring(0, v1.lastIndexOf(' '));
											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
										}
										if(v2.indexOf('.')>-1)
										{
											var tmp = v2.substring(0, v2.lastIndexOf(' '));

											var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
											var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
											v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
										}	
										if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
										{
											v2=new Date(v2).getTime(); 
											v1=new Date(v1).getTime(); 
										}
										else if(!isNaN(v1) && !isNaN(v2))
										{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
											}
										}									
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							},
						});	
					}
					var gridPageSize = 15;
					var isPagingHidden=false;
					if (gridData!=undefined && gridData.length<gridPageSize)
						isPagingHidden=true;
					else
						isPagingHidden=false;
					var gridDataObj=Ext.create('Ext.data.Store', {
						fields:userDetailsFields,
						proxy: {
							type: 'pagingmemory',
							reader: {
								type: 'array', root : 'data', totalProperty : 'total'
							}
						},
						data : gridData,
						pageSize:gridPageSize,
						autoLoad : true,
					});
					var activePage=1;
					Ext.getCmp("new_chk").add({
						xtype:'customgrid',
						store:gridDataObj,
						sortableColumns:false,
						columnWidth:1.0,							
						ui:'newGridPanel',
						border:true,							
						id:'grid0',
						margin:'10 10 10 10',
						columns:userViewColunmArray,
						scroll:true,
						autoScroll:true,
						forceFit:true,
						viewConfig:
						{
							stripeRows: true,
							getRowClass: function (record, rowIndex, rowParams, store)
							{
								if (record.raw.length>0)
								{
									return ;
								}
								else
								{
									return 'hidePlus';
								}
							}
						},
						listeners:{
							sortchange:function(ct, column, e, t, eOpts ){
								me.gridColIndexParam=column.getIndex();
								me.gridColStateParam=column.sortState;
								this.getStore().loadPage(activePage);
							},
							render:function(obj){
								Ext.defer(function() {
								},100);
							}
						},
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,							
							store: gridDataObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							hidden:false,
							listeners: {
								change : function(thisd, params)
								{
									if(!Ext.isEmpty(params))
										activePage = params.currentPage;
									else
										activePage=1;
								}
							}
						}]
					});
				}
				else
				{
					resultPanelObj.hide();
					this.getNomeasurepanel().show();			
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					this.disableTools();
				}
				resultPanelObj.doLayout();
				appConstants.LoadingMask.hide();
			}
		});
	},			
	 //prakash
	excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },	//end

	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'357px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'},
					cls:'containerHeader',
				},
				{
					xtype : 'CitrixMachineReportSettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		 
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 
		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 
		Ext.getCmp('glduration').hide();
		Ext.getCmp('duraSelect').hide();
		Ext.getCmp('duration').hide();
		 
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		console.log('logo')
		Ext.getCmp('moreOptionCloseId').show();
		var me = this;
	    Ext.get('closeSettings').on('click', function() {
		    me.validateAndCloseSettings();
	    });
	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({
				duration: 500,
				to: 
				{
					y: -500
				}
			 });	
			return true;
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	validateSettings :function()
	{
		console.log('test')
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}		
		return true;
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var reportBy = Ext.getCmp('er_option').getValue();
		var erOsMachine_type=Ext.getCmp('erOsMachine_type').getValue();
		var er_deliverGrup=Ext.getCmp('er_deliverGrup').getValue();		
		var er_dataFor=Ext.getCmp('er_dataFor').getValue();
		
		var repSubType = Ext.getCmp('select_farm').getValue();
		var selectedcompArray = Ext.getCmp('er_server').getValue();
		if( reportBy== '-1')
		{
			this.showMessage('Report By is Not Applicable');
			return false;
		}
		else if(!(reportBy == 'Component') && repSubType=='-1')
		{
			this.showMessage(reportBy+'is Not Applicable');
			return false;
		}
		else if(selectedcompArray[0] == '-1')
		{
		   this.showMessage('Components is Not Applicable');
		   return false;
		}
		if (selectedcompArray.length > 1 && selectedcompArray.indexOf('All') > -1)
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		if(er_deliverGrup == '-1')
		{
		   this.showMessage('Delivery Groups is Not Applicable');
		   return false;
		}
		var component = '';
		var usr = '';
		var temCom = '&component='
		var tmpUsr = '&usr='
		
		for (var ci = 0; ci < selectedcompArray.length; ci++) {
			component += temCom + selectedcompArray[ci];
		}
		var params = 'reportBy=' + reportBy  + component;
		if(!(reportBy == 'Component'))
			params += '&reportBySubType=' + repSubType ;
		params+='&er_deliverGrup='+er_deliverGrup+'&er_dataFor='+er_dataFor+'&erOsMachine_type='+erOsMachine_type;
		//Timeline Variables 		
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue();

		startDate.setHours(startHr);
		endDate.setHours(endHr);          
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		mgr_stmin=appConstants.defaultLoadData.startmin;
		mgr_enmin=appConstants.defaultLoadData.endmin;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var durationType = Ext.getCmp("glduration").getValue();
			var duration = Ext.getCmp("duration").getValue().toString();
			var unit = Ext.getCmp("duraSelect").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
			}
			params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
			params2+= '&er_reportgenration='+rGenType;
		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		params += params1;
		params += params2;
		params += userID;
		//params += "&selectedGridColumns="+appConstants.selectedGridColumns;//..for selected grid column
		params +="&er_reportFor="+appConstants.reportFor; 
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title: 'User log no summary',
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	}
});