Ext.define('CitrixOverviewApp.controller.CitrixOverviewController', {
		extend: 'Ext.app.Controller',
		views:['Main'],
		refs:[
				{
					selector: 'main',
					ref: 'main'
				},
				{
					selector: 'newUtilities',
					ref: 'newUtilities'
				},
				{
					selector: 'resultpanel',
					ref: 'resultpanel'
				},
				{
					selector: 'nomeasurepanel',
					ref: 'nomeasurepanel'
				},
				{
					selector: 'customtrigger',
					ref:'customtrigger'
				},
				{
					selector:'CitrixOverviewSettings',
					ref:'citrixOverviewSettings'
				},
				{
					selector:'CitrixOptionSettings',
					ref:'citrixOptionSettings'
				},
				{
					selector:'CitrixDefaultSettings',
					ref:'citrixDefaultSettings'
				}
		],
		init: function() 
		{
			this.control({
				'newUtilities': 
				{
					'afterrender': this.loadTools
				},
				'resultpanel':
				{
					'afterrender': this.hi
				},
				'main':
				{
					'afterrender': this.afterMainRender,					
				},
				'citrixOverviewSettings':
				{
					'afterrender': this.closeSetting
				},
			   'citrixDefaultSettings combo[id="er_excwe"]': {
					//'select': this.excludeWeekendsChange
				},
				'citrixOptionSettings combo[id="er_option"]':
				{
					'select': this.onSelectAnalysisBy
				},
				'citrixOptionSettings combo[id="er_site"]':
				{
					'select': this.onSelectSiteBy
				},
				'citrixDefaultSettings combo[name="reportGeneration"]':
				{
					'select': this.reportGenChange
				},
				'citrixDefaultSettings button[id="submitViaSetting"]':
				{
					'click': this.closeSettingAndSubmit
				},
				'citrixDefaultSettings checkbox[id="experAllWidget"]':
				{
					'change': this.onChangeExperAllWidget
				},
				'citrixOptionSettings button[id="expandSelector"]':
				{
					'click': this.expandMe
				},
				'citrixOptionSettings button[id="expandXenAppSelector"]':
				{
					'click': this.expandXenAppSelector
				},
				'citrixOptionSettings trigger[id="compGroupSearch"]':
				{
					'change': this.compMultiselect
				},
				'citrixOptionSettings trigger[id="xenAppCompSearch"]':
				{
					'change': this.xenAppCompMultiselect
				},
				'newUtilities > #printTool > button':
				{
					'click': this.printReport
				},
				'newUtilities > #mailTool > button':
				{
					'click': this.sendMail
				},
				'newUtilities > #saveTool > button':
				{
					'click': this.saveReportAsPDF
				},
				'newUtilities > #favoriteTool > button':
				{
					'click': this.saveFavorite
				},
				'newUtilities > #scheduleTool > button':
				{
					'click': this.saveSchedule
				},
				'citrixOverviewSettings button[name="save"]':
				{
					'click': this.modifyScheduleFavorite
				},
			});
		},
		expandMe: function(btn)
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_siteDirectComponent'), Ext.getCmp('compLbl').text, btn);
		},
		expandXenAppSelector: function(btn)
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_XenAppComponents'), Ext.getCmp('compXenAppLbl').text, btn);
		},
		compMultiselect: function(obj)
		{
			if (Ext.isEmpty(appConstants.erUtils))
				appConstants.erUtils = Ext.widget("erutils");
			obj.toggleTriggger();
			appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_siteDirectComponent'), appConstants.defaultLoadData['siteDirectComponent']);
		},
		xenAppCompMultiselect: function(obj)
		{
			if (Ext.isEmpty(appConstants.erUtils))
				appConstants.erUtils = Ext.widget("erutils");
			obj.toggleTriggger();
			appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_XenAppComponents'), appConstants.defaultLoadData['siteDirectComponent']);
		},
		onChangeExperAllWidget:function(obj,newValue,oldValue){
			appConstants.experAllWidget=newValue;
		},
		validateAndCloseSettings:function()
		{
			if(this.validateSettings())
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: 
					{
						y: -500
					}
				 });	
				return true;
			}
		},
		closeSettingAndSubmit:function()
		{
			if(this.validateAndCloseSettings())
			{
				this.submitReport(appConstants.buttonId);
			}
		},
		hi:function()
		{
			Ext.Ajax.disableCaching=false;
			Ext.Ajax.on('beforerequest', function(conn, response, opts) {				
				//Ext.get(document.body).mask('Loading...');
			});
			Ext.Ajax.on('requestcomplete', function(conn, response, opts) {
				requestCount++;
				if(totalPanelCount > 0)
				{
					if(requestCount == totalPanelCount)
					{
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
					}
				}
			});
		},
		reportGenChange:function()
		{
			Ext.getCmp('resultPanel').hide();
			var reportGenType=Ext.getCmp('reportGeneration').getValue();
			if(reportGenType != 'foreground')
			{
				Ext.getCmp('bgReportName').setValue("");
				Ext.getCmp('bgReportName').show();
				Ext.getCmp('moreOptionCloseId').hide();				
				Ext.getCmp('submitViaSetting').show();
				Ext.getCmp('submit').hide();
			}
			else
			{
				Ext.getCmp('bgReportName').hide();
				Ext.getCmp('submitViaSetting').hide();
				Ext.getCmp('moreOptionCloseId').hide();//..no need done button because already submit button is there in this report only
				Ext.getCmp('submit').show();
			}
		},
		loadTools: function() 
		{
			this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
			Ext.getCmp("favoriteTool").setDisabled(false);
			Ext.getCmp("scheduleTool").setDisabled(false);
		},
		hideTools:function()
		{
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);
		},
		afterMainRender: function()
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();//..
			var reportTitle=appConstants.defaultLoadData.reportTitle;
			this.getMain().setTitle(reportTitle);
			var jData = appConstants.defaultLoadData;
			this.setErOptionData(jData);
			var analysisBy = Ext.getCmp('er_option');
			var er_site=Ext.getCmp('er_site');
			var er_subZone=Ext.getCmp('er_subZone');
			if(analysisBy != undefined && analysisBy.getValue() != undefined && analysisBy.getValue() != '-1' && analysisBy.getValue() != 'Component')
			{
				this.setSiteOptionData(jData);
				er_site.show();
			}
			else
			{
				er_site.hide();
			}		
			if(jData['isSiteOrDirectory'] != undefined && jData['isSiteOrDirectory'] == 'yes')
			{
				Ext.getCmp('siteDirectoryComponentsId').show();	
				this.setSiteDirectoryComponentData(jData);
			}
			else
				Ext.getCmp('siteDirectoryComponentsId').hide();
			this.setXenAppComponentData(jData);
			
			var erTimeline = Ext.getCmp('er_timeline');
			erTimeline.getStore().loadRawData(jData['timelineCombo']);
			erTimeline.setValue(jData['selectedTimeline']);
			var startDateObj = Ext.getCmp('er_stdate');
			startDateObj.setValue(jData.startDateForDisplay);
			startDateObj.dataArray = jData.startDate;
			var startHrObj = Ext.getCmp('er_sthr');
			startHrObj.setValue(jData.startHourForDisplay);
			startHrObj.dataArray = jData.startHour;
			var endDateObj = Ext.getCmp('er_enddate');
			endDateObj.setValue(jData.endDateForDisplay);
			endDateObj.dataArray = jData.endDate;
			var endHrObj = Ext.getCmp('er_endhr');
			endHrObj.setValue(jData.endHourForDisplay);
			endHrObj.dataArray = jData.endHour;
			mgr_stmin=appConstants.defaultLoadData.startmin;
			mgr_enmin=appConstants.defaultLoadData.endmin;
			var er_logon=Ext.getCmp('er_logon');
			er_logon.setValue(jData.logonLimit);
			var dispUserDomain=Ext.getCmp('dispUserDomain');
			dispUserDomain.setValue(jData.dispUserDomain);
			var er_launch=Ext.getCmp('er_launch');
			er_launch.setValue(jData.launchLimit);
			if(jData.dispUserDomain != undefined && jData.dispUserDomain=='true')
			{
				Ext.getCmp('dispUserDomain').setValue(true);
			}
			else
			{
				Ext.getCmp('dispUserDomain').setValue(false);
			}
			Ext.getCmp('citrixOptionSettings').add({
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: jData['ID']
			});
		},
		onSelectAnalysisBy: function(obj)
		{
			var thisVal = Ext.getCmp('er_option').getValue();
			var reportBy = 'analysisBy=' + thisVal;
			var formObj = this;
			appConstants.LoadingMask.show();
			Ext.Ajax.request({
				url: '/final/reporter/ErCtxOverviewJSON.jsp',
				scope: this,
				method: 'POST',
				params: reportBy,
				success: function(response) 
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.defaultLoadData = jsonData;
					if(thisVal != 'Component')
					{
						formObj.setSiteOptionData(jsonData);
						Ext.getCmp('er_site').show();
					}
					else
					{
						Ext.getCmp('er_site').hide();
					}
					if(jsonData['isSiteOrDirectory'] != undefined && jsonData['isSiteOrDirectory'] == 'yes')
					{
						Ext.getCmp('siteDirectoryComponentsId').show();
						formObj.setSiteDirectoryComponentData(jsonData);
					}
					else
						Ext.getCmp('siteDirectoryComponentsId').hide();
					formObj.setXenAppComponentData(jsonData);
					
					appConstants.LoadingMask.hide();
				}
			});
		},
		onSelectSiteBy: function(obj)
		{
			var thisVal=Ext.getCmp('er_site').getValue();
			var paramsObj='analysisBy='+Ext.getCmp('er_option').getValue()+"&er_site="+thisVal+"&er_subZone="+Ext.getCmp('er_subZone').getValue();
			paramsObj += '&supportedComponents='+appConstants.supportedComponents;
			var formObj = this;
			appConstants.LoadingMask.show();
			Ext.Ajax.request({
				url: '/final/reporter/ErCtxOverviewJSON.jsp',
				scope: this,
				method: 'POST',
				params: paramsObj,
				success: function(response) 
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.defaultLoadData = jsonData;
					if(jsonData['isSiteOrDirectory'] != undefined && jsonData['isSiteOrDirectory'] == 'yes')
					{
						Ext.getCmp('siteDirectoryComponentsId').show();
						formObj.setSiteDirectoryComponentData(jsonData);
					}
					else
						Ext.getCmp('siteDirectoryComponentsId').hide();
					formObj.setXenAppComponentData(jsonData);
				
					appConstants.LoadingMask.hide();
				}
			});
		},
		setSiteDirectoryComponentData:function(jData)
		{
			var er_Component=Ext.getCmp('er_siteDirectComponent');
			er_Component.getStore().clearFilter(true);
			er_Component.getStore().loadRawData(jData['siteDirectComponent']);
			if(!Ext.isEmpty(jData.selectedField['selectedSiteOrDirectory']) && jData.selectedField['selectedSiteOrDirectory'] != undefined)
			{
				er_Component.setValue(jData.selectedField['selectedSiteOrDirectory']);
			}
			else
			{
				er_Component.setValue(jData['siteDirectComponent'][0].valueField);
			}
		},
		setXenAppComponentData:function(jData)
		{
			var er_Component=Ext.getCmp('er_XenAppComponents');
			er_Component.getStore().clearFilter(true);
			er_Component.getStore().loadRawData(jData['xenAppComponents']);
			if(!Ext.isEmpty(jData.selectedField['selectdXenAppArry']) && jData.selectedField['selectdXenAppArry'] != undefined)
			{
				er_Component.setValue(jData.selectedField['selectdXenAppArry']);
			}
			else
			{
				er_Component.setValue(jData['xenAppComponents'][0].valueField);
			}
		},
		setSiteOptionData:function(jData)
		{
			var siteBy = Ext.getCmp('er_site');
			var er_subZone = Ext.getCmp('er_subZone');
			var analysisBy = Ext.getCmp('er_option');	
			if(jData.subZoneCombo != undefined && analysisBy.getValue() != undefined && analysisBy.getValue() != '-1')
			{
				siteBy.setFieldLabel(analysisBy.getRawValue());
				siteBy.getStore().loadRawData(jData['siteCombo']);
				siteBy.setValue(jData.selectedField['selectedSiteCombo']);
				var er_subZone=Ext.getCmp('er_subZone');
				er_subZone.getStore().loadRawData(jData['subZoneCombo']);
				er_subZone.setValue(jData.selectedField['selectedSubZone']);
				er_subZone.setFieldLabel(jData.selectedField['subZoneLabel']);
				siteBy.show();
			}
			else
			{
				siteBy.hide();
			}
		},
		setErOptionData: function(jData)
		{ 
			var analysisBy = Ext.getCmp('er_option');
			var analysisByArry=jData['analysisBy'];
			analysisBy.getStore().loadRawData(analysisByArry);
			analysisBy.setFieldLabel(jData.selectedField['analysisByLabel']);
			if(jData.selectedField['selectedAnalysisBy'] != undefined)
				analysisBy.setValue(jData.selectedField['selectedAnalysisBy']);
			else
			{
				if(analysisByArry.length > 0)
				{
					var fistZone=analysisByArry[0];
					analysisBy.setValue(fistZone.valueField);
				}
			}
		},
		printReport: function() 
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var reporttype="";
			if(appConstants.columnRowCountPrint != undefined && appConstants.columnRowCountPrint!='two')
				reporttype="CitrixOverview";
			var s_qryString = "/final/reporter/ErCtxOverviewPrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate+"&buttonId="+appConstants.buttonId+"&columnRowCountPrint="+appConstants.columnRowCountPrint;
			parent.printWindowFn(s_qryString);
		},
		sendMail: function()
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			Ext.widget('sendmail').show();
		},
		saveSchedule: function(obj)
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var params = this.getQueryString();
			var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype=CitrixOverview&er_trgttype=CitrixOverview&er_ViewName=ErCtxOverview.jsp&er_RmDispName=CitrixOverview&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
			if (Ext.getCmp('er_timeline').getValue() == 'Any')
			{
			   this.showMessage('Chosen timeline not allowed');
				  return;
			}
			parent.scheduleWindowFn(qryString);
		},
		saveReportAsPDF: function() 
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var reporttype="";
			if(appConstants.columnRowCountPrint != undefined && appConstants.columnRowCountPrint!='two')
				reporttype="CitrixOverview";
			var qryString = "../reporter/ErHtmlToSavePdf.jsp?buttonId="+appConstants.buttonId+"&reporttype="+reporttype+"&columnRowCountPrint="+appConstants.columnRowCountPrint;
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			appConstants.erUtils.savePDF(qryString);
		},
		saveFavorite: function()
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var params = this.getQueryString();
			var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=CitrixOverview&er_rtype=CitrixOverview&er_ViewName=ErCtxOverview.jsp&er_RmDispName=CitrixOverview&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
			if (Ext.getCmp('er_timeline').getValue() == 'Any')
			{
				  this.showMessage('Chosen timeline not allowed');
				  return;
			}
			parent.favouriteWindowFn(target);
		},
		modifyScheduleFavorite: function()
		{
			var qryStr = this.getQueryString();
			var commonQStr = '&er_trgttype=CitrixOverview&er_rtype=CitrixOverview&er_ViewName=ErCtxOverview.jsp&er_RmDispName=CitrixOverview&fromFavoriteModify=Yes&cmd=client'
			var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
			var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=CitrixOverview';
			var urlNw         = "";
			if(appConstants.isModifyFavorite == 'Yes')
			{
				urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
				qryStr += commonQStr+forFavorite;
			}
			else
			{
				urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
				qryStr += commonQStr+forSchedule;
			}
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url: urlNw,
				params: qryStr,
				standardSubmit: true,
				method: 'POST'
			});
		},
		bookletQuery: function(obj)
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var s_qryString = appConstants.defaultLoadData+"&buttonId="+appConstants.buttonId;
			return s_qryString;
		},
		bookletScheduleQuery: function(obj)
		{
			if(appConstants.experAllWidget)
			{
				this.exportDataAlert();
				return '';
			}
			var bookletquery=this.getQueryString();
			bookletquery+="&er_rtype=CitrixOverview&er_trgttype=&er_ViewName=ErCtxOverview.jsp&er_RmDispName=CitrixOverview";
			return bookletquery;
		},
		bookletPreview:function()
		{
			this.printReport();
		},		
		submitReport: function(buttonId)
		{
			this.hideTools();
			requestCount=0;
			appConstants.buttonId=buttonId;
			var repsultpanel=Ext.getCmp('resultPanel');
			if(!isSettingsEnabled)
				this.showConfigDropdown();//..
			var params ='';
		
			if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
			{
				params = this.getQueryString();
			}
			else
			{
				params =  this.getQueryString();
				if(params==false) 
					return;
			}			
			var formObj = this;
			var rGenType ='foreground';
			if(isSettingsEnabled)
			{
			   rGenType = Ext.getCmp("reportGeneration").getValue();
			}
			if(rGenType =='foreground')
			{
				var me1 = this;
				var limitforbg = appConstants.defaultLoadData.limitforbg;
				var maxDays    = appConstants.defaultLoadData.maxDays;

				var stDate    = Ext.getCmp("er_stdate").getValue();
				var startHr   = Ext.getCmp("er_sthr").getValue();
				var enDate    = Ext.getCmp("er_enddate").getValue();
				var endHr     = Ext.getCmp("er_endhr").getValue();
				stDate.setHours(startHr);
				enDate.setHours(endHr);   
				if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
				{
					Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						//this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params,buttonId);
					}
					}, this);
				}
				else
				{
					me1.submitReportByAjaxCall(params,buttonId);					
				}
				Ext.getCmp('backGroundPanel').hide();
			}
			else
			{
				params += '&servletName=ErCitrixOverviewReportC&er_rtype=CitrixOverview&er_ViewName=ErCtxOverview.jsp&er_RmDispName=CitrixOverview';
				params += '&er_trgttype=CitrixOverview&forwardto=CitrixOverview&er_bgreportfrom=CitrixOverview&bgenabled=Yes&savereport=save&buttonId='+appConstants.buttonId+'&experAllWidget='+appConstants.experAllWidget;
				if(rGenType == 'background')
				{
					bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
				}
				else if (rGenType == 'background-csv')
				{
					bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
						
				}
				appConstants.LoadingMask.show();
				Ext.Ajax.request({
					url: bgUrl,
					scope: this,
					method: 'POST',
					params: params,
					success: function(response)
					{
						var resultObj = Ext.getCmp('backGroundPanel');
						appConstants.LoadingMask.hide(); 
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var reportValString = jsonData.reportVal;
						var status = reportValString.status;
						var htmlStr='';
						if ( status == 'success' )
						{							
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';

						}
						else if ( status == 'duplicate' )
						{							
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
						}
						resultObj.update(htmlStr);
						resultObj.show();
					}
				});
			}
		},
		getQueryString:function()
		{
			var isSettingsOk = true;
			var er_option = Ext.getCmp('er_option').getValue();
			var params='&analysisBy='+er_option;
			if(er_option != 'Component')
			{
				params += '&er_site='+Ext.getCmp('er_site').getValue();
				params += '&er_subZone='+Ext.getCmp('er_subZone').getValue();
			}
			else
			{
				params += '&er_site=null';
				params += '&er_subZone=null';
			}
			var timeline = Ext.getCmp("er_timeline").getValue();
			var startDate = Ext.getCmp("er_stdate").getValue();
			var startHr = Ext.getCmp("er_sthr").getValue();
			var endDate = Ext.getCmp("er_enddate").getValue();
			var endHr = Ext.getCmp("er_endhr").getValue()
			startDate.setHours(startHr);
			endDate.setHours(endHr); 
			if(!checkDateTime(startDate,endDate))
			{
				return false;
			}
			startDate = Ext.getCmp("er_stdate").dataArray;
			startHr = Ext.getCmp("er_sthr").dataArray;
			endDate = Ext.getCmp("er_enddate").dataArray;
			endHr = Ext.getCmp("er_endhr").dataArray;
			var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
			if(Ext.getCmp('er_siteDirectComponent') != undefined)
			{
				var er_siteDirectComponent = Ext.getCmp('er_siteDirectComponent').getValue();
				if(er_siteDirectComponent != undefined)
				{
					if(er_siteDirectComponent[0] == '-1')
					{
						this.showMessage('Director Components is Not Applicable');
						return false;
					}
					if (er_siteDirectComponent.length > 1 && (er_siteDirectComponent.indexOf('All') > -1 || er_siteDirectComponent.indexOf('all') > -1))
					{
						this.showMessage('All and Individual Components are not allowed simultaneously!');
						return false;
					}
					for(var c=0;c<er_siteDirectComponent.length;c++)
					{
						params += "&er_siteDirectComponent="+er_siteDirectComponent[c];
					}
				}
			}
			if(Ext.getCmp('er_XenAppComponents') != undefined)
			{
				var er_XenAppComponents = Ext.getCmp('er_XenAppComponents').getValue();
				if(er_XenAppComponents != undefined)
				{
					if(er_XenAppComponents[0] == '-1')
					{
						this.showMessage('Xen Components is Not Applicable');
						return false;
					}
					if (er_XenAppComponents.length > 1 && (er_XenAppComponents.indexOf('All') > -1 || er_XenAppComponents.indexOf('all') > -1))
					{
						this.showMessage('All and Individual Components are not allowed simultaneously!');
						return false;
					}
					for(var c=0;c<er_XenAppComponents.length;c++)
					{
						params += "&er_XenAppComponents="+er_XenAppComponents[c];
					}
				}
			}
			var er_logon=Ext.getCmp('er_logon').getValue();
			var er_launch=Ext.getCmp('er_launch').getValue();
			params1 += '&er_logon='+er_logon+'&er_launch='+er_launch;
			params1 += '&dispUserDomain='+Ext.getCmp('dispUserDomain').getValue();
			if(Ext.getCmp('er_status') != undefined)
			{
				var er_status=Ext.getCmp('er_status').getValue();
				params1 +='&er_status='+er_status;
			}
			else
			{
				params1 +='&er_status='+appConstants.er_status;
			}
			if(Ext.getCmp('er_eventTest') != undefined)
			{
				var er_eventTest=Ext.getCmp('er_eventTest').getValue();
				params1 +='&er_eventTest='+er_eventTest;
			}
			else
			{
				params1 +='&er_eventTest='+appConstants.er_eventTest;
			}
			var params2 = '';
			if(isSettingsEnabled)
			{
				var timeFrom = Ext.getCmp("timefrom").getValue();
				var minFrom = Ext.getCmp("minfrom").getValue();
				var timeTo = Ext.getCmp("timeto").getValue();
				var minTo = Ext.getCmp("minto").getValue();
				var exculdeWeek = Ext.getCmp("er_excwe").getValue();
				var rGenType = Ext.getCmp("reportGeneration").getValue();
				var reportName = '';

				if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
				{
					return false;
				}
				if(rGenType != 'foreground')
				{
					reportName = Ext.getCmp("bgReportName").getValue();
					if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
					{
						return false;
					}
				}
				params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
				params2+= '&er_reportgenration='+rGenType+'&bg_reportname='+reportName;

			}
			var userID   = '&userID='+appConstants.defaultLoadData.loginid;
			params += params1;
			params += params2;
			params += userID;
			params += "&buttonId="+appConstants.buttonId;
			return params;
		},
		submitReportByAjaxCall:function(params,buttonId)
		{
			requestCount=0;
			params += '&method=getButtonInfo&fromMenu='+appConstants.fromMenu;
			var me=this;
			var url="/final/reporter/ErCtxOverviewJSON.jsp";
			var requests = Ext.Ajax.requests;
			for (id in requests)
			{
				if (requests.hasOwnProperty(id)) 
				{
				  Ext.Ajax.abort(requests[id]);
				}
			}
			var buttonArry=new Array();
			if(buttonId == 'All')
			{				
				buttonArry.push("citrixUserExperience");
				buttonArry.push("citrixSessions");
				buttonArry.push("citrixApplications");
				buttonArry.push("citrixEvents");
				buttonArry.push("citrixServer");
				buttonArry.push("citrixLicense");
			}
			else
			{
				buttonArry.push(buttonId);
			}
			requestId=Ext.Ajax.request({
				url:url,
				scope:this,
				method:'POST',
				params:params,
				success:function(response)
				{
					requestCount=0;
					var resultPanelObj = Ext.getCmp('resultPanel');
					resultPanelObj.removeAll();		
					var jsonObject=response.responseText;
					var jsonData=Ext.decode(jsonObject);	
					totalPanelCount=jsonData.totalPanel;	
					resultPanelObj.show();		
					this.getMain().setTitle(jsonData.reportTitle);
					if(jsonData['isSiteOrDirectory'] != undefined && jsonData['isSiteOrDirectory'] == 'yes')
					{
						appConstants.siteOrDirectoryLabel=jsonData.selectedField['siteOrDirectoryLabel'];
						Ext.getCmp('compLbl').setText(appConstants.siteOrDirectoryLabel);
						Ext.getCmp('expandSelector').setTooltip(appConstants.siteOrDirectoryLabel);
						Ext.getCmp('siteDirectoryComponentsId').show();
						
						this.setSiteDirectoryComponentData(jsonData);
					}
					else
						Ext.getCmp('siteDirectoryComponentsId').hide();
					this.setXenAppComponentData(jsonData);				
					for(var v in buttonArry)
					{
						var eachButton=buttonArry[v];
						switch(eachButton)
						{
							case "citrixUserExperience":
								me.createCitrixUserExperience(jsonData,resultPanelObj,eachButton);
								break;
							case "citrixSessions":
								me.createCitrixUserExperience(jsonData,resultPanelObj,eachButton);
								break;
							case "citrixApplications":
								me.createCitrixUserExperience(jsonData,resultPanelObj,eachButton);
								break;
							case "citrixServer":
								me.createCitrixUserExperience(jsonData,resultPanelObj,eachButton);
								break;
							case "citrixEvents":
								me.createCitrixEvents(jsonData,resultPanelObj,eachButton);
								break;
							case "citrixLicense":
								me.createCitrixLicense(jsonData,resultPanelObj,eachButton);
							default:
								break;
						}
					}
					
				}
			});
		},
		createCitrixLicense:function(jsonData,resultPanelObj,buttonId)
		{
			var buttonInfoObj=jsonData.buttonInfo;
			var buttonInfo=buttonInfoObj[''+buttonId+''];
			var me=this;
			var ctxLicenceArry=new Array();		
			for(var key in buttonInfo)
			{
				var eachColumn=buttonInfo[key];
				for(var i=0;i<eachColumn.length;i++)
				{
					var eachWidget=eachColumn[i];
					var templateType=eachWidget['type'];
					var title=eachWidget['title'];
					var panelName=eachWidget['panelName'];
					var panelHeight=eachWidget['panelHeight'];
					panelHeight=parseFloat(panelHeight);
					var params = me.getQueryString();
					params +='&buttonId='+buttonId+'&er_view=submit';
					var paramsNew=params;
					ctxLicenceArry.push(
					{
						xtype:'panel',
						ui:'newGraphPanel',					
						title:title,
						columnWidth:1,
						id:buttonId+panelName,
						name:panelName,
						type:templateType,
						height:panelHeight,
						listeners:{
							boxready:function(obj){		
								var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
								initMask.show();
								var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
								params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
								Ext.Ajax.request({
									url:url,
									params:params,
									scope:this,
									success:function(response){		
										initMask.hide();
										var jsonObject=response.responseText;
										var jsonData=Ext.decode(jsonObject);
										me.loadChart(jsonData,buttonId,this.id,this.type,this.name,panelHeight-25,'');
									},
									failure:function(err)
									{
										//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
									}
								});
							}
						}
						
					});
				}
			}
			resultPanelObj.add({
				xtype:'panel',
				padding:0,
				layout:'fit',
				border:true,
				scroll:true,
				bodyPadding:'10 10 5 10',
				autoScroll:true,
				defaults:{
					columnWidth:1,
				},
				items:ctxLicenceArry,
			});
		},
		createCitrixEvents:function(jsonData,resultPanelObj,buttonId)
		{
			var me=this;
			var citrixEventsArry=new Array();
			var params = me.getQueryString();
			params +='&buttonId='+buttonId+'&er_view=submit';
			var paramsNew=params;
			var buttonInfoObj=jsonData.buttonInfo;
			var buttonInfo=buttonInfoObj[''+buttonId+''];
			for(var key in buttonInfo)
			{
				var eachColumn=buttonInfo[key];
				var eachColumnArry=new Array();				
				for(var i=0;i<eachColumn.length;i++)
				{
					var eachWidget=eachColumn[i];
					var title=eachWidget['title'];
					var panelName=eachWidget['panelName'];
					var panelHeight=eachWidget['panelHeight'];
					var panelDetails=eachWidget['panelDetails'];	
					var subWidgetItem=new Array();				
					if(i==0)
					{			
						for(var subKey in panelDetails)
						{
							var eachSubColumn=panelDetails[subKey];
							var subPanelName=eachSubColumn['panelName'];
							var subPanelHeight=eachSubColumn['panelHeight'];
							var subPanelTitle=eachSubColumn['title'];
							var templateType=eachSubColumn['type'];
			
							if(subKey == 1)
							{
								subWidgetItem.push({
								xtype:'container',
								flex:0.4,
								layout:{
									type:'vbox',
									align:'stretch',
									pack:'center',
								},
								id:buttonId+subPanelName,
								name:subPanelName,
								title:subPanelTitle,
								height:subPanelHeight,
								type:templateType,
								items:[],
								listeners:{
											
									boxready:function(obj){
										var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
										initMask.show();
										var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
										params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
										Ext.Ajax.request({
											url:url,
											params:params,
											scope:this,
											success:function(response){		
												initMask.hide();
												var jsonObject=response.responseText;
												var jsonData=Ext.decode(jsonObject);
												me.loadChart(jsonData,buttonId,this.id,this.type,this.name,this.height,'');
												
											}
										});
									}
								},									
								
							});
							}
							else if(subKey == 0)
							{
								subWidgetItem.push({
									xtype:'container',
									flex:0.3,
									layout:{
										type:'vbox',
										align:'stretch',
									},
									items:[
									],
									id:buttonId+subPanelName+subKey,
									height:subPanelHeight,
									name:subPanelName,
									title:subPanelTitle,
									type:templateType,
									listeners:{
										boxready:function(obj){
											var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
											initMask.show();
											var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
											params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
											Ext.Ajax.request({
													url:url,
													params:params,
													scope:this,
													success:function(response){		
														initMask.hide();
														var jsonObject=response.responseText;
														var jsonData=Ext.decode(jsonObject);
														me.loadChart(jsonData,buttonId,this.id,'template3Pie',this.name,this.height,this.title);
													},
													failure:function(err)
													{
													//	Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
													}
												});
											}
										}
									}
								);
							}
							else if(subKey == 2 || subKey == 3 )
							{
								subWidgetItem.push({
									xtype:'container',
									//flex:2.4,
									flex:0.3,
									layout:'fit',
									items:[],
									layout:{
										type:'vbox',
										align:'stretch',
									},
									id:buttonId+subPanelName+subKey,
									name:subPanelName,
									title:subPanelTitle,
									type:templateType,
									height:subPanelHeight,
									listeners:{
										boxready:function(obj){
											var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
											initMask.show();
											var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
											params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
											Ext.Ajax.request({
												url:url,
												params:params,
												scope:this,
												success:function(response){		
													initMask.hide();
													var jsonObject=response.responseText;
													var jsonData=Ext.decode(jsonObject);
													me.loadChart(jsonData,buttonId,this.id,'template2Graph',this.name,this.height,this.title);
												},
												failure:function(err)
												{
												//	Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
												}
											});
										}
									}
								});
							}
						}
						citrixEventsArry.push({
						title:title,
						id:buttonId+panelName,
						name:panelName,
						height:panelHeight,
						layout:{
							type:'hbox',
							align:'stretch',
							pack:'start'
						},
						defaults:{
							padding:'0 10 0 0',
							cls:'widgetcon',
							margin:'0 10 0 10',
						},
						items:subWidgetItem	
						});
					}
					if(i==1)
					{
						var newPanelLineCls='newLineBottomRight';
						for(var subKey in panelDetails)
						{
							var eachSubColumn=panelDetails[subKey];
							var subPanelName=eachSubColumn['panelName'];
							var subPanelHeight=eachSubColumn['panelHeight'];
							var subPanelTitle=eachSubColumn['title'];
							var templateType=eachSubColumn['type'];
							if(subKey == 2)
								newPanelLineCls='newLineBottom';
							else if(subKey == 3 || subKey == 4)
								newPanelLineCls='newLineRight';
							else if(subKey == 5)
								newPanelLineCls='';
							else
								newPanelLineCls='newLineBottomRight';
							subWidgetItem.push({
								xtype:'panel',
								title:subPanelTitle,
								cls:newPanelLineCls,									
								items:[
								{
									xtype:'container',
									border:true,
									height:180,
									id:buttonId+subPanelName,
									name:subPanelName,
									type:templateType,
									margin:'0 0 0 -7',
									listeners:{
										/*boxready:function(obj){		
											var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
											initMask.show();
											var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
											params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
											Ext.Ajax.request({
												url:url,
												params:params,
												scope:this,
												success:function(response){		
													initMask.hide();
													var jsonObject=response.responseText;
													var jsonData=Ext.decode(jsonObject);
													me.loadChart(jsonData,buttonId,this.id,this.type,this.name,subPanelHeight,'');
												},
												failure:function(err)
												{
													//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
												}
											});
										}*/
									}
								}]
							});
						}
						var toolsArry=[];
						toolsArry.push(
						{
							xtype: "scrollcombo",
							width: 100,
							cls: "dropdown",
							editable: false,
							margin:'0 4px 0 0',
							name: "er_eventTest",
							id: "er_eventTest",
							store: new Ext.data.Store({
								fields: ["displayField", "valueField"],
								data: [{"displayField":"Application","valueField":"AppEvtLogTest_DDD"},{"displayField":"System","valueField":"SystemEvtLogTest_DDD"}]
							}),

							displayField: "displayField",
							valueField: "valueField",
							queryMode: "local",
							listeners: {
								boxready:function(obj){
									var jData = appConstants.defaultLoadData;
									Ext.getCmp('er_eventTest').setValue(appConstants.er_eventTest);
								},
								change: function (e, d, a, b) {		
									var panelNameArry=new Array();//citrixEvents
									panelNameArry.push("citrixEvents_panel4");
									panelNameArry.push("citrixEvents_panel5");
									panelNameArry.push("citrixEvents_panel6");
									panelNameArry.push("citrixEvents_panel7");
									panelNameArry.push("citrixEvents_panel8");
									panelNameArry.push("citrixEvents_panel9");
									for(var e=0;e<panelNameArry.length;e++)
									{
										var panelName=panelNameArry[e];
										var buttonPanelName='citrixEvents'+panelName;
										var buttonPanelId=Ext.getCmp(buttonPanelName);												
										buttonPanelId.removeAll();
										var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
										buttonPanelId.setLoading(initMask, buttonPanelId.body);												
										appConstants.er_eventTest=d;
										var params1 = me.getQueryString();
										params1 +='&buttonId='+buttonId+'&er_view=submit';
										var paramsNew1=params1;
										var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
										params1=paramsNew1+'&panelName='+panelName+'&templateType=template2Graph';												
										Ext.Ajax.request({
											url:url,
											params:params1,
											scope:this,
											success:function(response){														
												var jsonObject=response.responseText;
												var jsonData=Ext.decode(jsonObject);														
												try
												{															
													var otherInfo='';
													for (var key in jsonData) {
													  if (jsonData.hasOwnProperty(key)) {
														  var val = jsonData[key];
														  if(key.indexOf(buttonId) != -1)
														  {
															otherInfo=val.otherInfo;
														  }
													  }
													}	
													var panelName=otherInfo['panelName'];
													var templateType=otherInfo['templateType'];
													var templateHeight=otherInfo['height'];
													var buttonPanelName=buttonId+panelName;
													var buttonPanelId1=Ext.getCmp(buttonPanelName);						
													buttonPanelId1.setLoading(false);
													me.loadChart(jsonData,buttonId,buttonPanelName,'template2Graph',panelName,templateHeight,'');
												}
												catch (e)
												{
													//console.log("==>>>>>"+e);
												}
												
											},
											failure:function(err)
											{
												//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
											}
										});
									}
								},
							}
						}
					);
					citrixEventsArry.push({				
					title:'<span style="margin-left:10px">'+title+'</span>',
					id:buttonId+panelName,
					name:panelName,
					height:panelHeight,				
					header:{
						titlePosition:1,
						items:toolsArry
					},
					layout:'column',							
					bodyPadding:'0 0 10 10',
					defaults:{
						ui:'newPlainPanel',
						columnWidth:.33,
					},
					items:subWidgetItem	
					
					
					});
					}
				}
			}
			resultPanelObj.add({
				xtype:'panel',
				padding:0,
				layout:{
					type:'column',
					align:'stretch',
					pack:'start'
				},
				id:buttonId+'events',
				border:true,
				scroll:true,
				bodyPadding:'5 5 5 5',
				autoScroll:true,
				defaults:{
					columnWidth:1,
					xtype:'panel',
					ui:'newGraphPanel',
					margin:'5 5 5 5',
					bodyPadding:'0 0 10 0',
				},
				items:citrixEventsArry,
				
			});
			
		},
		createCitrixUserExperience:function(jsonData,resultPanelObj,buttonId)
		{
			var me=this;
			var buttonInfoObj=jsonData.buttonInfo;
			var buttonInfo=buttonInfoObj[''+buttonId+''];
			var userexperienceviewArry=new Array();
			for(var key in buttonInfo)
			{
				var eachColumn=buttonInfo[key];
				var eachColumnArry=new Array();
				for(var i=0;i<eachColumn.length;i++)
				{
					var eachWidget=eachColumn[i];
					var templateType=eachWidget['type'];
					var title=eachWidget['title'];
					var panelName=eachWidget['panelName'];
					var panelHeight=eachWidget['panelHeight'];
					panelHeight=parseFloat(panelHeight);
					var params = me.getQueryString();
					params +='&buttonId='+buttonId+'&er_view=submit';
					var paramsNew=params;
					var packVal='center';
					if(panelName=='ctxServer_panel11')
					{
						packVal='top';
					}
					var toolsArry=[];
					if(panelName=='userExp_panel3')
					{
						toolsArry.push(
							{
								xtype: "scrollcombo",
								width: 100,
								cls: "dropdown",
								editable: false,
								margin:'1px 0 0 0',
								name: "er_status",
								id: "er_status",
								store: new Ext.data.Store({
									fields: ["displayField", "valueField"],
									data: [{"displayField":Average,"valueField":"Avg"},{"displayField":Maximum,"valueField":"Max"}]
								}),

								displayField: "displayField",
								valueField: "valueField",
								queryMode: "local",
								listeners: {
									boxready:function(obj){
										var jData = appConstants.defaultLoadData;
										Ext.getCmp('er_status').setValue(appConstants.er_status);
									},
									change: function (e, d, a, b) {								
										var buttonPanelName='citrixUserExperienceuserExp_panel3';
										var buttonPanelId=Ext.getCmp(buttonPanelName);
										buttonPanelId.removeAll();
										if (!buttonPanelId.loading) 
											buttonPanelId.loading = true;
										else 
											buttonPanelId.loading = false;
										var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
										buttonPanelId.setLoading(initMask, buttonPanelId.body);
										appConstants.er_status=d;
										var params1 = me.getQueryString();
										params1 +='&buttonId='+buttonId+'&er_view=submit';
										var paramsNew1=params1;
										var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
										params1=paramsNew1+'&panelName=userExp_panel3&templateType=template1DigitalWithGraph';
										Ext.Ajax.request({
											url:url,
											params:params1,
											scope:this,
											success:function(response){	
												buttonPanelId.setLoading(false);
												var jsonObject=response.responseText;
												var jsonData=Ext.decode(jsonObject);
												me.loadChart(jsonData,buttonId,buttonPanelName,'template1DigitalWithGraph','userExp_panel3',panelHeight,'');
											},
											failure:function(err)
											{
												//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
											}
										});										
									},
								}
							}
						);
					
					}
					eachColumnArry.push(
						{
							xtype:'panel',
							title:title,
							id:buttonId+panelName,
							name:panelName,
							tools:toolsArry,
							type:templateType,
							ui:'newGraphPanel',
							layout:{
								type:'vbox',
								align:'stretch',
								pack:packVal,
							},
							height:panelHeight,
							flex:1,
							items:[],
							listeners:{
								boxready:function(obj){		
									var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
									initMask.show();
									var url='/final/servlet/com.eg.ErCitrixOverviewReportC';	
									params=paramsNew+'&panelName='+this.name+'&templateType='+this.type;
									Ext.Ajax.request({
										url:url,
										params:params,
										scope:this,
										success:function(response){		
											initMask.hide();
											var jsonObject=response.responseText;
											var jsonData=Ext.decode(jsonObject);
											me.loadChart(jsonData,buttonId,this.id,this.type,this.name,this.height,'');
										},
										failure:function(err)
										{
											//Ext.MessageBox.alert("Error occured in ErCtxOverview.jsp page");
										}
									});
								},
								render:function(){
									var infoLink=Ext.get('infoLink');
									if(infoLink != null && infoLink != undefined)
									{
										Ext.get('infoLink').on('mouseover', function() {
											if(Ext.isEmpty(Ext.getCmp('InfoWindowId')))
											{
												var gWindow = Ext.create('Ext.tip.ToolTip', {
													anchor:'top',
													anchorToTarget:true,
													target:'infoLink',
													scroll: false,
													layout: 'fit',
													autoHide:true,
													border:false,
													width:'auto',
													id:'InfoWindowId',
													closable:false,
													ui:'newTooltipPopup',
													items:[
														{
															xtype:'container',
															padding:5,
															html:'<span class="newFont_normal13">Avg Logon Time Per Day Across XenApp Servers</span>',
														}
													]
												}).show();
											}
										});
									}
								}
							}
						}	
					);
				}
				userexperienceviewArry.push(
					{
						xtype:'panel',
						layout:{
							type:'vbox',
							align:'stretch',
						},
						scroll:true,
						autoScroll:true,
						defaults:{
							xtype:'panel',
							ui:'newGraphPanel',
							columnWidth:1,
							margin:'5 5 5 5',
							bodyPadding:'0 10 10 10',
						},
						items:eachColumnArry
					}
				);
				
			}
			resultPanelObj.add({
				xtype:'panel',
				padding:0,
				layout:'column',
				border:true,
				scroll:true,
				bodyPadding:'5 5 5 5',
				autoScroll:true,
				defaults:{
					columnWidth:(1/3),
				},
				items:userexperienceviewArry
			});
			
		},
		loadChart:function(jsonData,buttonId,widgetId,templateType,panelName,panelHeight,containerTitle)
		{
			var chartCollection=jsonData[buttonId+panelName];
			if(templateType != undefined && chartCollection != undefined)
			{
				var isData=chartCollection['isData'];
				var widgetIdStr=Ext.getCmp(widgetId);
				widgetIdStr.removeAll();
				if(isData)
				{
					switch(templateType)
					{
						case "template1DigitalWithGraph":
						{
							var template1Arry=new Array();
							var digitalChartArry=chartCollection['digitalChartArry'];
							var anyChartObj=chartCollection['anyChartObj'];
							
							var digitalArry=new Array();
							if(anyChartObj['minMaxAvg'] != undefined && anyChartObj['minMaxAvg']=='no')
							{
								var digitalPercent=false;
								if(anyChartObj['digitalPercent'] != undefined)
								{
									digitalPercent=true;
								}
								var digitalHtml='';
								if(digitalPercent)
									digitalHtml+='<table align="center"><tr><td>';
								digitalHtml+='<div style="text-align:center;display:block"><div class="font_normal23" style="line-height:normal">';
								var marginDigital='';								
								for(var d=0;d<digitalChartArry.length;d++)
								{
									var eachObj=digitalChartArry[d];
									var textColor='';
									if(eachObj.bgColor != undefined)
										textColor=eachObj.bgColor;
									if(anyChartObj['digitalPart'] == 'two' && d==0)
									{
										marginDigital='0 10 0 0';
									}
									else
										marginDigital='0 0 0 0';
									var url=eachObj.url;
									var totalHtmlContent=digitalHtml;
									if(url != undefined)
										totalHtmlContent +='<a class="anchorLink" href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+eachObj.value+'</a>';
									else
										totalHtmlContent +=eachObj.value;
									totalHtmlContent +='</div><div class="crl"></div><table align="center"><tr><td><div style="background-color:'+textColor+';width:8px;height:8px;border-radius:4px;">&nbsp;</div></td><td style="padding-left:3px"><div class="font_normal12">'+eachObj.name+'</div></td><tr></table></div>';
									if(digitalPercent)
									{
										totalHtmlContent+='</td>';
										if(d==1)
											totalHtmlContent+='<td><div style="background:'+anyChartObj['digitalBgColor']+';padding:5px 4px 3px 4px;margin-left:4px;color:#ffffff;font-family:arial;display:inline-block;text-align:left;line-height:.8em;font-size:12px">'+anyChartObj['digitalPercent']+'<span style="font-size:10px">%</span> <br/> <span style="font-size:8px">SLOW</span></div> </td>';
										totalHtmlContent+='</tr></table>';
									}					
									digitalArry.push({
										xtype:'container',
										cls:'chartMinmax',
										html:totalHtmlContent,
										margin:marginDigital,
										padding:'10 10 8 10',
										flex:.5
									});
								}
								template1Arry.push(
								{
										xtype:'container',
										height:65,
										layout:{
											type:'hbox',
											align:'center',
											pack:'center',
										},
										items:digitalArry
								});
							}
							else
							{
								var digitalHtml='<div style="text-align:center;display:block"><div class="font_normal23" style="line-height:normal">';
								var minMaxAvgHtml='<table width="100%"><tr>';
								var digitalPart="two";
								var multiAxis='no';
								if(anyChartObj['digitalPart'] != undefined && anyChartObj['digitalPart']=='one')
									digitalPart="one";
								if(anyChartObj['chartType'] != undefined && anyChartObj['chartType']=='combinedChart' && anyChartObj['multiAxis'] != undefined && anyChartObj['multiAxis']=='true')
								{
									multiAxis="yes";
								}
								for(var d=0;d<digitalChartArry.length;d++)
								{
									var eachObj=digitalChartArry[d];
									var textColor='';
									var tdWidth=''
									var paddingLeftPx='0px';
									if(eachObj.bgColor != undefined)
									{
										textColor=eachObj.bgColor;
										paddingLeftPx='3px';
									}
									var url=eachObj.url;
									if(url != undefined)
										digitalHtml+='<a class="anchorLink" href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+eachObj.value+'</a>';
									else
										digitalHtml+=eachObj.value;
									digitalHtml+='</div><div class="crl"></div><table align="center"><tr><td><div style="background-color:'+textColor+';width:8px;height:8px;border-radius:4px">&nbsp;</div></td><td style="padding-left:'+paddingLeftPx+'"><div class="font_normal12">'+eachObj.name+'</div></td></tr></table></div>';
									
									if(d==0 && digitalPart=='two')
									{
										digitalArry.push(
										{
											xtype:'container',
											cls:'chartMinmax',
											html:digitalHtml,
											height:65,
											margin:'0 10 0 0',
											padding:'10 10 8 10',
											flex:.35
										});
									}
									else
									{
										tdWidth='';
										if(d>=2)
											tdWidth="33%";
										minMaxAvgHtml+='<td width="'+tdWidth+'"><div style="text-align:center;"><div class="font_normal20" style="line-height:normal">';
										if(url != undefined)
											minMaxAvgHtml+='<a class="anchorLink" href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+eachObj.value+'</a>';
										else
											minMaxAvgHtml+=eachObj.value;
										minMaxAvgHtml+='</div><div class="crl"></div><table align="center"><tr><td><div style="background-color:'+textColor+';width:8px;height:8px;border-radius:4px;">&nbsp;</div></td><td style="padding-left:'+paddingLeftPx+'"><div class="font_normal11">'+eachObj.name+'</div></td></tr></table></div></td>';
										if(d != digitalChartArry.length-1)
											minMaxAvgHtml+='<td><div class="chartLegendDivider" style="width:1px;"></div></td>';
									}
								}
								minMaxAvgHtml+='</tr></table>';
								digitalArry.push({
										xtype:'container',
										html:minMaxAvgHtml,
										margin:'0 0 0 0',
										padding:'10 10 8 10',
										height:65,
										cls:'chartMinmax',
										flex:.65
								});
								template1Arry.push(
								{
										xtype:'container',
										height:65,
										layout:{
											type:'hbox',
											align:'center',
											pack:'center',
										},
										items:digitalArry
								});
							}
							var panelHeightTemp1=panelHeight-130;
							if(panelName=='ctxServer_panel11')
							{
								panelHeightTemp1=panelHeight-140;
								template1Arry.push(
									{
										xtype:'container',
										margin:'20 0 10 0',
										html:'<span class="newFont_normal13">Max OS Connection Failures Across XA Servers</span>',
									});
							}							
							template1Arry.push({
								xtype:'container',
								border:true,
								height:panelHeightTemp1,
								id:'barChartId'+widgetId,
								listeners:{
									'boxready':function(c){
										try
										{
											var lineChart = {};	
											if(multiAxis == 'yes')
											{
												lineChart = jQuery.extend(true, {}, getHighChartsBarInstance_combine(this.id,this.height+20,''), lineChart);
											}
											else
												lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,''), lineChart);											
											lineChart.setData(anyChartObj,'<%=currentDateFormat%>','');
											lineChart.drawChart();
										}
										catch (e)
										{
											console.log("template one exveption::::::"+this.id+"===>>>>>"+e);
										}
									}
								},	
							});
							widgetIdStr.add(template1Arry);
							break;
						}
						case "template2Graph":
						{
							var anyChartObj=chartCollection['anyChartObj'];
							template1Arry=new Array();
							containerTitle=anyChartObj.titleUi;
							anyChartObj.titleUi='';							
							if(containerTitle != undefined && containerTitle != '')
							{
								template1Arry.push(
									{
										xtype:'container',
										margin:'0 0 0 0',
										html:'<span class="newFont_normal13">'+containerTitle+'</span>',
									}
								);
							}
							template1Arry.push({
								xtype:'container',
								border:true,
								height:panelHeight-20,
								id:'barChartId'+widgetId,
								flex:1,
								listeners:{
									'boxready':function(c){
										try
										{
											var lineChart = {};			
											if(anyChartObj.TimeFormatOut != undefined)
											{
												lineChart = jQuery.extend(true, {}, getHighChartsInstance(this.id,this.height,""), lineChart);
											}
											else
												lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,''), lineChart);
											lineChart.setData(anyChartObj,currentDateFormat,'');
											lineChart.drawChart();
										}
										catch (e)
										{
											console.log("template two exveption::::::"+this.id+"===>>"+e);
										}
									}
								}
							});
							widgetIdStr.add(template1Arry);
							break;
						}
						case "template3Pie":
						{						
							var anyChartObj=chartCollection['anyChartObj'];
							var pieLegend=anyChartObj['legend'];
							var dataSetObj=anyChartObj['DataSet'][0]['data'];
							var pieLegendHtml='<table height="100%" width="100%" border="0px" style="table-layout: fixed;"><tr><td valign="middle" style="vertical-align:middle" height="100%"><table cellspacing="0" cellpadding="0" valign="middle" width="100%"><tbody>';
							for(var i in dataSetObj)
							{
								var eachObj=dataSetObj[i];
								var legendName=eachObj['name'];
								var legendColor=eachObj['color'];
								var legendVal=eachObj['y'];
								var url=eachObj['url'];
								var pieLengendWidth='100';			
								var mainDivWidth=document.getElementById("viewMain").offsetWidth-40;
								mainDivWidth=mainDivWidth/3;
								if(mainDivWidth <= 350)
									pieLengendWidth='73';
								else if(mainDivWidth <= 450)
									pieLengendWidth='100';
								else if(mainDivWidth <= 600)
									pieLengendWidth='180';
								else if(mainDivWidth <= 650)
									pieLengendWidth='200';
								else if(mainDivWidth <= 800)
									pieLengendWidth='250';
								else if(mainDivWidth > 800)
									pieLengendWidth='350';
								pieLegendHtml+='<tr><td nowrap style="padding-top:2px;padding-right:0px;width:10px;vertical-align:top"><div style="background-color:'+legendColor+';" class="legend"></div></td>';
								if(panelName=='citrixEvents_panel1')
								{
									pieLengendWidth='50';
									pieLegendHtml+='<td class="font_normal11" style="text-overflow: ellipsis;line-height:1.2em;vertical-align:top"><div id="pieLegendId" style="text-overflow: ellipsis; overflow:hidden;width:'+pieLengendWidth+'px;"><a href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+legendName+'</a></div></td><td class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+legendVal+'</td></tr>';
								}
								else
								{
									if(url != undefined && url != 'undefined' && url != '' )
									{
										pieLegendHtml+='<td class="font_normal11" style="word-wrap:break-word;line-height:1.2em;vertical-align:top"><div id="pieLegendId" data-qtip="'+legendName+'" style="text-overflow: ellipsis; overflow:hidden;width:'+pieLengendWidth+'px;"><a href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+legendName+'</a></div></td><td nowrap class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+legendVal+'</td></tr>';
									}
									else
									{
										pieLegendHtml+='<td class="font_normal11" style="word-wrap:break-word;line-height:1.2em;vertical-align:top;"><div id="pieLegendId" data-qtip="'+legendName+'" style="text-overflow: ellipsis; overflow:hidden;width:'+pieLengendWidth+'px;">'+legendName+'</div></td><td nowrap class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+legendVal+'</td></tr>';
									}
								}
								if(eachObj != undefined && eachObj.innerMeasure != undefined){
									var tmpDataObj=eachObj.innerMeasure;
									if(tmpDataObj != undefined){
										for(var indx in tmpDataObj){
											var innerLegObj=tmpDataObj[indx];
											pieLegendHtml+='<tr><td>&nbsp;</td>';
											if(innerLegObj.url != undefined && innerLegObj.url != 'undefined' && innerLegObj.url != '' )
											{
												pieLegendHtml+='<td class="font_normal11" style="line-height:1.2em;vertical-align:top"><div id="pieLegendId" data-qtip="'+innerLegObj.name+'" style="text-overflow: ellipsis; overflow:hidden;width:'+pieLengendWidth+'px;padding-left:5px;"><a href="javascript:void(0);" onclick="javascript:linkURL(\''+url+'\');">'+innerLegObj.name+'</a></div></td><td nowrap class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+innerLegObj.y+'</td></tr>';
											}
											else
											{
												pieLegendHtml+='<td class="font_normal11" style="line-height:1.2em;vertical-align:top;"><div id="pieLegendId" data-qtip="'+innerLegObj.name+'" style="text-overflow: ellipsis; overflow:hidden;width:'+pieLengendWidth+'px;padding-left:5px;">'+innerLegObj.name+'</div></td><td nowrap class="font_normal11" style="text-overflow: ellipsis;width:40px;vertical-align:top">'+innerLegObj.y+'</td></tr>';
											}
										}
									}
								}
								
							}
							pieLegendHtml+='</tbody></table></td></tr></table>';
							template1Arry=new Array();
							if(containerTitle != undefined && containerTitle != '')
							{
								template1Arry.push(
									{
										xtype:'container',
										margin:'0 0 0 0',
										html:'<span class="newFont_normal13">'+containerTitle+'</span>',
									}
								);
							}
							var pieItemArry=new Array();	
							var pieFlex=.53;
							if(pieLegend != undefined && pieLegend=='false')
								pieFlex=1;
							pieItemArry.push(
								{
									xtype:'container',
									flex:pieFlex,
									id:'donutChartId'+widgetId,
									layout:'fit',
									listeners:{
										'boxready':function(c){
											try
											{
												var lineChart = {};			
												lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,150,150), lineChart);
												lineChart.setData(anyChartObj,'<%=currentDateFormat%>','');
												lineChart.drawChart();
											}
											catch (e)
											{
												console.log("template two exveption::::::"+this.id+"===>>"+e);
											}
										},										
									},
								}	
							);
							if(pieLegend != undefined && pieLegend=='false')
							{
								
							}
							else
							{
								pieItemArry.push(
									{
										xtype:'container',
										border:true,
										flex:.47,
										cls:'legendWithValue',
										style:{'top':'0px','left':'100px'},
										layout:{
											type:'fit',
											align:'center',
											pack:'center'
										},
										html:pieLegendHtml
									}	
								);
							}
							template1Arry.push({
								xtype:'panel',
								layout:{
									type:'hbox',
									align:'stretch',
								},
								flex:1,
								items:pieItemArry
							});
							widgetIdStr.add(template1Arry);
							break;
						}
						case "template4Grid":
						{
							var anyChartObj=chartCollection['anyChartObj'];
							widgetIdStr.add(this.getGrid(anyChartObj));
							break;
						}
						case "template5DigitalWithBarSameQuery":
						{
							var digitalChartArry=chartCollection['digitalChartArry'];
							var anyChartObj=chartCollection['anyChartObj'];
							var template1Arry=new Array();
							var digitalArry=new Array();
							var digitalHtml='<div style="text-align:center;display:block"><div class="font_normal23" style="line-height:normal">';
							var minMaxAvgHtml='<table width="100%"><tr>';
							var digitalPart="two";
							if(anyChartObj['digitalPart'] != undefined && anyChartObj['digitalPart']=='one')
								digitalPart="one";
							var legendHtml='<table style="margin-top:10px"><tr>';
							var barHtml='<div id="" class="" style="width: 100%; height: 25px;margin-bottom:20px">';
							var spanWidth='100';
							for(var d=0;d<digitalChartArry.length;d++)
							{
								var eachObj=digitalChartArry[d];
								var textColor='';
								var tdWidth=''
								var paddingLeftPx='0px';
								var spancolor=eachObj.color;
								var spanName=eachObj.name;
								if(eachObj.bgColor != undefined)
								{
									textColor=eachObj.bgColor;
									paddingLeftPx='10px';
								}
								spanWidth=eachObj.spanWidth;
								if(d != 0)
								{
									var url1=eachObj.url;
									barHtml +='<a class="anchorLink" href="javascript:void(0);" onClick="javascript:linkURL(\''+url1+'\',);" ><span style="width:'+spanWidth+'%;height:23px;" class="'+eachObj.spanClass+'"><b style="visibility:hidden">'+spanName+'%</b></span></a>';
								}
								if(d==0 && digitalPart=='two')
								{
									digitalArry.push(
									{
										xtype:'container',
										cls:'chartMinmax',
										html:digitalHtml+eachObj.value+'</div><div class="crl"></div><table align="center"><tr><td nowrap><div style="background-color:'+textColor+';width:8px;height:8px;border-radius:4px">&nbsp;</div></td><td nowrap style="padding-left:'+paddingLeftPx+'"><div class="font_normal12">'+eachObj.name+'</div></td></tr></table></div>',
										margin:'0 10 0 0',
										padding:'10 10 8 10',
										flex:.30
									});
								}
								else
								{
									tdWidth='';
									if(d>=2)
										tdWidth="33%";
									minMaxAvgHtml+='<td width="'+tdWidth+'"><div style="text-align:center;"><div class="font_normal20" style="line-height:normal">'+eachObj.value+'</div><div class="crl"></div><div class="font_normal11">'+eachObj.name+'</div></td>';
									if(d != digitalChartArry.length-1)
										minMaxAvgHtml+='<td><div class="chartLegendDivider" style="width:1px;"></div></td>';
								}
								if(d != 0)
								{
									legendHtml += '<td><div class="'+eachObj.imageCls+'"></div></td><td style="padding:0px 10px 0px 5px" class="font_normal11">'+eachObj.name+'</td>';
								}
							}
							legendHtml+='</tr></table>';
							barHtml+='</div>';
							minMaxAvgHtml+='</tr></table>';
							digitalArry.push({
									xtype:'container',
									html:minMaxAvgHtml,
									margin:'0 0 0 0',
									padding:'10 10 8 10',
									cls:'chartMinmax',
									height:65,
									flex:.70
							});
							template1Arry.push(
							{
									xtype:'container',
									height:65,
									margin:'5 5 10 5',
									layout:{
										type:'hbox',
										align:'center',
										pack:'center',
									},
									items:digitalArry
							});
							template1Arry.push({
								xtype:'container',
								border:true,
								height:panelHeight-100,
								id:'barChartId'+widgetId,
								listeners:{
									'boxready':function(c){
										try
										{
											var lineChart = {};	
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,''), lineChart);											
											lineChart.setData(anyChartObj,'<%=currentDateFormat%>','');
											lineChart.drawChart();
										}
										catch (e)
										{
											console.log("template one exveption::::::"+this.id+"===>>>>>"+e);
										}
									}
								},	
							});							
							widgetIdStr.add(template1Arry);

						}
						default:
						{
							break;
						}
					}
				}
				else
				{
					var template1Arry=new Array();
					if(containerTitle != undefined && containerTitle != '')
					{
						template1Arry.push(
							{
								xtype:'container',
								margin:'0 0 0 0',
								html:'<span class="newFont_normal13">'+containerTitle+'</span>',
							}
						);
					}
					template1Arry.push(this.getNoMeasure());
					widgetIdStr.add(template1Arry);
				}
			}
			panelHeight='';
			
		},
		getGrid:function(anyChartObj)
		{
			var columnsArr=new Array();
			var fieldsArr=new Array();
			var columns=anyChartObj.gridColumns;
			var data=anyChartObj.gridData;
			var url=anyChartObj.url;
			var url1='';
			for (var k in columns)
			{
				var col=columns[k];
				var headerAlign='left';
				if(col.indexOf("@@") != -1)
				{
					headerAlign=col.substring(col.indexOf("@@")+2);
					col=col.substring(0,col.indexOf("@@"));
					if(col.indexOf("$m$") != -1)
					{
						col=col.substring(0,col.indexOf("$m$"));
					}
				}
				fieldsArr.push(col);
				columnsArr.push({
					header:col,
					align:headerAlign,
					dataIndex:col,
					width:k==0?200:160,
					sortable: true,
					renderer:function(value, meta, record, rowIndex, colIndex, store,view){						
						url1=url;
						var strDecimal='';
						var str=''
						if(value.indexOf("~DD~") != -1)
						{
							url1=url+'&'+value.substring(value.indexOf("~DD~")+4);
							value=value.substring(0,value.indexOf("~DD~"));
						}
						if(!isNaN(value) && !isNaN(parseFloat(value)))
						{							
							if(value!=null && value.indexOf(".")>-1)
							{
								strDecimal = value.substring(value.indexOf("."));
								str = value.substring(0,value.indexOf("."));
								value='<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url1+'\',);" >'+str+'</a></span><span class="decimal-align2"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url1+'\',);" >'+strDecimal+'</a></span>';
							}
							else
							{
								value='<span class="decimal-align"><a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url1+'\',);" >'+value+'</a></span>';
							}
						}
						else
							value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="javascript:linkURL(\''+url1+'\',);" >'+value+'</a>';
						return value;
					}
				});
			}
			var store = Ext.create('Ext.data.ArrayStore', {
				fields:fieldsArr,
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'array'
					}
				},
				sortable: true,
				autoLoad : true,
				data : data,
			});
				var gridObj=
					{
						xtype:'customgrid',
						sortableColumns: true,						
						ui:'newGridPanel',
						id:'grid0',
						margin:'0 0 0 0',
						height:270,//
						border:true,
						scroll: true,
						autoScroll:true,
						forceFit:true,
						store: store,
						columns: columnsArr,
					};
			return gridObj;
		},
		getNoMeasure:function()
		{
			return {
						xtype:'container',
						flex:1,
						html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
					};
		},
		disableTools: function(){
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);
		},	
		showConfigDropdown:function()
		{
			isSettingsEnabled = true;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:-2px 0px 0px 4px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
				width:580,
				padding:5,
				id:'configMod',
				ui:'settingsWindowContainer',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'370px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						style:{'top':'0px','margin':'2px','border':'0px !important'}
					},
					{
						xtype:'citrixOverviewSettings',
						parent:this
					}
				],
				renderTo:'viewMain'
			});
			var timefromObj = Ext.getCmp('timefrom');
			timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
			 
			var minfromObj = Ext.getCmp('minfrom');
			minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
			 
			var timetoObj = Ext.getCmp('timeto');
			timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
			 
			var mintoObj = Ext.getCmp('minto');
			mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);


			var erExcweObj = Ext.getCmp('er_excwe');
			erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
			erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			erExcweObj.setFieldLabel(appConstants.defaultLoadData.sExclweekLbl);
				 

			var reportGen = Ext.getCmp('reportGeneration');
			reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
			reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
		},
		closeSetting:function()
		{
			var me = this;
			Ext.get('closeSettings').on('click', function() {
			if(me.validateSettings())
			{
				me.validateAndCloseSettings();
			}
			});
		},
		validateAndCloseSettings:function()
		{
			if(this.validateSettings())
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: 
					{
						y: -650
					}
				 });	
				return true;
			}
		},
		validateSettings :function(){
			var reportgen=Ext.getCmp('reportGeneration').getValue();
			if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
				var reportName = Ext.getCmp('bgReportName').getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
					return false;
			}		
			return true;
		},
		exportDataAlert:function()
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Exporting the report may take too long to complete. Choose the Background option to export this report',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		},
		showMessage:function(msg)
		{
			Ext.MessageBox.show({
				title: 'Citrix Overview Report',
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
});