Ext.define('CompareTestsApp.controller.Main', {
	extend: 'Ext.app.Controller',
	views: ['Main'],
	refs: [{
			selector: 'main',
			ref: 'main'
		}, {
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{selector: 'nomeasurepanel', ref: 'nomeasurepanel'},
		{selector: 'backGroundPanel', ref: 'backGroundPanel'}
	],
	init: function() {
		this.control({
			'main newUtilities': {
			   'afterrender': this.loadTools
			},
			'main': {
				'boxready': this.loadDefaults
			},
			'MainForm': {
				'render': this.showConfigPopup
			},
			'MainForm  checkboxgroup[name="checkboxgroup"]': {
				'change': this.onCheckBoxSelect
			},
			'defineconfigurationpopup  button[name="defineconfigclose"]': {
				'click': this.closePanel
			},
			'TestConfigurationPopup  button[name="addSelectValue"]': {
				'click': this.addSelectionValues
			},
			'TestConfigurationPopup  button[id="addBtn"]': {
				'click': this.addToGrid
			},
		   'TestConfigurationPopup actioncolumn[id="deleteInView"]':
			{
				'click': this.removeSelectedRows
			},
			'TestConfigurationPopup  button[name="defineconfigclose"]': {
				'click': this.closeTestPanel
			},
			'defineconfigurationpopup combo[name="er_comptype"]': {
				'select': this.compTypeOnchange
			},
			'defineconfigurationpopup combo[name="er_timeline"]': {
				'select': this.timeLineOnChange
			},
			'TestConfigurationPopup combo[name="er_test"]': {
				'select': this.testTypeOnchange
			},
			'defineconfigurationpopup button[name="addSelection"]': {
				'click': this.addTestSelection
			},
			'MainForm button[name="submit"]': {
				'click': this.showResult
			},
			'MainForm button[name="save"]': {
				'click': this.goTo
			},
			'newUtilities > #printTool > button': {
				'click': this.printReport
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.saveSchedule
			},
			'MainForm combo[id="reportGeneration"]':
			{
				'select': this.reportGenChange
			},
			'main button[id="defineconfiguration"]' : {
				'click' : this.testConfiguration
			},
			'TestConfigurationPopup trigger[id="measureSearch"]':
			{
				'change': this.filterMultiselect
			}
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger(); 
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_measure'),appConstants.measureCombo);
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	addToGrid:function()
	{		
		var er_test=Ext.getCmp("er_test").getValue(); 
		if (er_test!='-1')
		{
			var store=Ext.getCmp("mainGrid").getStore();
			var er_testRaw=Ext.getCmp("er_test").getRawValue(); 
			var measValue="";
			var measureRawArray = new Array(); 
			var measureRawValue = ""; 

			var selection = Ext.getCmp('er_measure').boundList.getSelectionModel().getSelection(); 
			for (var i=0; i < selection.length; i++) {
				measureRawArray.push(selection[i].get('displayField'));
				measureRawValue+=selection[i].get('displayField');
				if(i!=(selection.length-1))
					measureRawValue+=',';
			}
			var recordFound=false;
			for(var i=0;i<store.getCount();i++)
			{
				record = store.getAt(i);
				test = record.get('Test');
				measure = record.get('Measures');
				
				if(test==er_testRaw)
				{
					record.set('Measures',measureRawValue);
					record.commit();
					recordFound=true;
					break;
				}
			}
			if (!recordFound)
			{
				store.add({Test:er_testRaw, Measures: measureRawValue});
			}
			appConstants.entireTableStore=store;
		}
		else
		{
			Ext.MessageBox.show({
				title: appConstants.alertTitleName,
				msg: "Please Select Test and measure values",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		} 
		
		
	},
	Arrcontains:function (a, obj) {
		for (var i = 0; i < a.length; i++) {
			if (a[i] === obj) {
				return true;
			}
		}
		return false;
	},
	addSelectionValues:function()
	{
		var flag=this.validateStoreTable();
		if(!flag)
		{
		 Ext.MessageBox.show({
				title: appConstants.alertTitleName,
				msg: "Please Select Test and measure values",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}else
		{
			//this.changeTestSelectionPopupText(true);
			this.closeTestPanel();
		}
	},
	validateStoreTable:function()
	{ 
		if (!Ext.isEmpty(appConstants.entireTableStore))
		{
			if(appConstants.entireTableStore.getCount()>0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}		
	},
	removeSelectedRows:function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		Ext.Msg.show({
			title : 'Alert',
			msg : 'Are you sure you want to remove selected configurations?',
			buttons : Ext.Msg.YESNO,
			icon : Ext.Msg.QUESTION,
			fn : function(buttonVal) {
					if (buttonVal == "yes") {
						var viewStoreObj = Ext.getCmp('mainGrid');
						var store = viewStoreObj.getStore();
						var record = store.getAt(rowIndex);
						var displaytestName = record.get('Test');
						viewStoreObj.getStore().remove(record);
						appConstants.entireTableStore=viewStoreObj.getStore(); 
					}
				}
		});
	},
	addTestSelection: function()
	{
		if(!appConstants.isUpdateBtnCicked)
		{
		   var isValid = this.validateConfigPopup(false);
			if (isValid)
			{
				if (appConstants.isFrstSelectn == true)
					appConstants.firstSelection="null";
				else
					appConstants.secondSelection="null";
			   this.addResults(true);
			}
		}
	},
	validateConfigPopup: function(flag)
	{
		var val;
		val = Ext.getCmp("er_comptype");
		if (val.getValue() == '-1') {
			Ext.MessageBox.show({
				title: appConstants.alertTitleName,
				msg: val.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		val = Ext.getCmp("er_component");
		if (val.getValue() == '-1') {
			Ext.MessageBox.show({
				 title: appConstants.alertTitleName,
				msg: val.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		stDate.setHours(Ext.getCmp('er_sthr').getValue());
		enDate.setHours(Ext.getCmp('er_endhr').getValue());

		var er_timeline =Ext.getCmp('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return false;
			}
		}
		var JsonData;
		if (appConstants.isFrstSelectn)
			   JsonData=appConstants.firstJson;
		   else
			{
				if(!Ext.isEmpty(appConstants.firstJson) && appConstants.firstJson !="null")
					JsonData=appConstants.firstJson;
				else
					JsonData=appConstants.secondJson;
			}

		var getMaxDaysInMonth = JsonData.hiddenParams['getMaxDaysInMonth'];
		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}

		var er_usertimeline = "";
		var er_usertimelineObj = JsonData.hiddenParams['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}
		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				return false;
			}
		}
		if(flag)
		{
			var limitforbg = JsonData.hiddenParams['limitforbg'];
			if(!Ext.isEmpty(limitforbg))
			{
				if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.confirmResult,this);
					return;
				}
			}
		}
			
		return true;
	},
	confirmResult:function(btn)
	{
		if(btn=="yes")
		{
			this.addResults(false);
		}
	},
	addResults:function(flag)
	{
		appConstants.entireTableStore=null; 
		var qString=this.updateQueryStringPopup();
		var formString;

		if(qString !="null")
		{
			var val2="";
			var val1="";
			var param=qString.split("*");
			for(var i=0;i<param.length;i++)
			{
				var value=param[i];
				var key=value.substring(0,value.indexOf("="));
				var val=value.substring(value.indexOf("=")+1);
				if(key=="er_component")
				{
					if(val.indexOf(":")>1)
						val2=val.substring(0,val.indexOf(":"));
					elseval2=val;
				}else if(key=="er_comptype")
				{
					val1=val;
				}
			}
		}

			formString=val1+"   "+val2;

			if(formString.length>20)
				formString=formString.substring(0,19);
			if(appConstants.isFrstSelectn)
			{
				appConstants.firstSelection=qString;
				if (appConstants.reportType!='null' && appConstants.reportType=='migration')
				{
					if(!appConstants.initialLoading)
					{
						appConstants.secondSelection = qString;
					}else
						appConstants.initialLoading=false;
				}
			   
			}
			else
			{
				appConstants.secondSelection=qString;
			}

			var selectionNameText=Ext.getCmp('selectionNameText').getValue().trim(); 
			if (!Ext.isEmpty(selectionNameText))
			{
				if (appConstants.targetName == "firstSelection")
				{
					appConstants.timeline1=Ext.getCmp("er_timeline").getValue();
					Ext.get('firstSelectDom').update(Ext.getCmp('selectionNameText').getValue());
				}
				else if (appConstants.targetName == "secondSelection")
				{
					appConstants.timeline2=Ext.getCmp("er_timeline").getValue();
					Ext.get('secondSelectDom').update(Ext.getCmp('selectionNameText').getValue());
				}
			}
			
			this.closePanel();

			if(flag)
			Ext.MessageBox.show({
					title: appConstants.alertTitleName,
					msg: selectionAddedLabel,
					buttons: Ext.MessageBox.OK,
					icon: 'iconSuccess'
				});
	},
	updateQueryStringPopup:function()
	{
		var QString="";
		if((appConstants.isFrstSelectn && appConstants.firstSelection=="null") || (appConstants.isSecondSelectn && appConstants.secondSelection=="null") )
		{
			if (appConstants.isFrstSelectn && (appConstants.firstSelection=="null" || appConstants.firstSelection=="" ))
			{
				appConstants.firstSelectionStartDate=startdate;
				appConstants.firstSelectionEnddate=enddate;
			}
			var er_compTyp=Ext.getCmp("er_comptype").getValue();
			var er_comp=Ext.getCmp("er_component").getValue();
			var er_timeLine=Ext.getCmp("er_timeline").getValue();
			
			var startdate =Ext.getCmp('er_stdate').dataArray;
			var enddate =Ext.getCmp('er_enddate').dataArray;
			var startHour =Ext.getCmp('er_sthr').dataArray;
			var endHour = Ext.getCmp('er_endhr').dataArray;
			var displayStartdate = Ext.getCmp('er_stdate').getValue();
			var displayEnddate = Ext.getCmp('er_enddate').getValue();
			var displayStartHour = Ext.getCmp('er_sthr').getValue();
			var displayEndHour = Ext.getCmp('er_endhr').getValue();
			displayStartdate = Ext.Date.dateFormat(displayStartdate, mgrDateFormat);
			displayEnddate = Ext.Date.dateFormat(displayEnddate, mgrDateFormat);
			var displayTimeQry = '';
			displayTimeQry +=  '*displayStartdate='+displayStartdate+'*displayEnddate='+displayEnddate+'*displayStartHour='+displayStartHour+'*displayEndHour='+displayEndHour;			
			if (er_timeLine!=undefined && er_timeLine!=null && er_timeLine=='Any')
			{
				QString='er_comptype='+er_compTyp+'*er_component='+er_comp+'*er_timeline='+er_timeLine+'*er_enddate='+enddate+'*er_stdate='+startdate+'*er_sthr='+startHour+'*er_endhr='+endHour+'*startmin='+mgr_stmin+'*endmin='+mgr_enmin+displayTimeQry;
			}
			else
			{
				QString='er_comptype='+er_compTyp+'*er_component='+er_comp+'*er_timeline='+er_timeLine+'*er_enddate='+enddate+'*er_stdate='+startdate+'*er_sthr='+startHour+'*er_endhr='+endHour+'*startmin='+appConstants.publicjsonData.startmin+'*endmin='+appConstants.publicjsonData.endmin+displayTimeQry;
			}
		
		}else if(appConstants.isFrstSelectn && (appConstants.firstSelection!="null" && appConstants.firstSelection!="" ))
		{
			appConstants.firstSelectionStartDate=startdate;
			appConstants.firstSelectionEnddate=enddate;
			QString=appConstants.firstSelection;
		}else if((appConstants.isSecondSelectn && appConstants.secondSelection!="null"))
		{
			QString=appConstants.secondSelection;
		}

		if (appConstants.targetName == "firstSelection")
		{
			appConstants.timeline1=Ext.getCmp("er_timeline").getValue();
		}
		else
		{
			appConstants.timeline2=Ext.getCmp("er_timeline").getValue();
		}
		return QString;
	},
	updateChgEvntQString: function() {

		var FormParams = "&er_comptype=" + Ext.getCmp("er_comptype").getValue() + "&er_component=" + Ext.getCmp("er_component").getValue();

		appConstants.QstringPopup = FormParams;
	},
	testTypeOnchange: function(obj) {
		this.updateChgEvntQString();
		var qString=this.selectionQueryString()+"&er_test="+Ext.getCmp("er_test").getValue();
		var me=this;
		var actionfrom = obj.getId();

		Ext.Ajax.request({
			url: '/final/reporter/ErTestComparisonReportJson.jsp',
			scope: this,
			params: qString,
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if (!Ext.isEmpty(jsonData))
				{
				   appConstants.testJson=jsonData;

					if (actionfrom == 'er_test') {
						comboRawData = jsonData.measureCombo;
						selectedComboOption = jsonData.er_measure;
						comboObject = Ext.getCmp('er_measure');
						comboObject.getStore().loadRawData(comboRawData);
						appConstants.measureCombo=comboRawData;
						var selectedComboValueFromJson;
						if (!Ext.isEmpty(selectedComboOption)) {
							selectedComboValueFromJson=selectedComboOption;
						} else {
						  selectedComboValueFromJson=comboRawData[0].valueField;
						} 

						if (!Ext.isEmpty(comboRawData) && comboRawData.length>1)
						{
							me.selectMeasuresForLoadedTest(obj,selectedComboValueFromJson);
						}
						else
						{
							comboObject.setValue(selectedComboValueFromJson);
						}
						
					}
				}
			}
		});
	},
	selectMeasuresForLoadedTest: function(obj,selectedComboValueFromJson) {
		var testValue=obj.getValue(); 
		if (testValue!='-1')
		{
			var store=Ext.getCmp("mainGrid").getStore();
			var testRawValue=obj.getRawValue();  
			var recordFound=false;
			for(var i=0;i<store.getCount();i++)
			{
				record = store.getAt(i); 
				var storeTestRawValue = record.get('Test');
				var storeMeasureRawValue = record.get('Measures');
				
				if(storeTestRawValue==testRawValue)
				{
					recordFound=true;
					var storeMeasureValueArray=new Array();
					if (storeMeasureRawValue.indexOf(',')>-1)
					{
						var storeMeasureRawArray=storeMeasureRawValue.split(',');
						
						for (var key in storeMeasureRawArray)
						{
							storeMeasureValueArray.push(appConstants.commonMeasureDisplayObject[storeTestRawValue+':'+storeMeasureRawArray[key]]);
						}
					}
					else
					{
						storeMeasureValueArray.push(appConstants.commonMeasureDisplayObject[storeTestRawValue+':'+storeMeasureRawValue]);
						 
					}
					if (!Ext.isEmpty(storeMeasureValueArray) && storeMeasureValueArray.length>0)
					{
						Ext.getCmp('er_measure').setValue(storeMeasureValueArray);
					}
					else
					{
						Ext.getCmp('er_measure').setValue(selectedComboValueFromJson);
					}
					break;
				}
			}  
			if (!recordFound)
			{
				Ext.getCmp('er_measure').setValue(selectedComboValueFromJson);
			}
		}
	},
	compTypeOnchange: function() {
		this.updateChgEvntQString();
		var QString = appConstants.QstringPopup;
			QString += "&compTypeChange=true";

		Ext.Ajax.request({
			url: '/final/reporter/ErTestComparisonReportJson.jsp',
			scope: this,
			params: QString,
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if (!Ext.isEmpty(jsonData))
				{
					if (appConstants.isFrstSelectn == true)
						appConstants.firstJson = jsonData;
					else
						appConstants.secondJson = jsonData;

					appConstants.isCompTypeChanged=true;
			//		this.changeTestSelectionPopupText(false);
					comboRawData = jsonData.componentCombo;
					selectedComboOption = jsonData.er_component;
					comboObject = Ext.getCmp('er_component');
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
			}
		});
	},
	onCheckBoxSelect: function(obj)
	{
		var timeLine = Ext.getCmp("commonTimeLine");
		var secondSelection = Ext.getCmp("secondSelection");
		var checkboxobj = Ext.getCmp('checkboxgroup');

		if (checkboxobj.getComponent(0).getValue())
		{
			appConstants.er_selection2 = "";
			secondSelection.hide();
			timeLine.show();
		} else
		{
			secondSelection.show();
			timeLine.hide();
		}
	},

	fillMeasurePopup: function(jsonData) { 
		var screenLabels = jsonData.screenLabels;
		var comboRawData;
		var selectedComboOption;
		var comboObject;

		comboRawData = jsonData.compTypeCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption = jsonData.er_comptype;
			comboObject = Ext.getCmp('er_comptype');
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Component Type']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData = jsonData.componentCombo;
		if (!Ext.isEmpty(comboRawData)) {
			selectedComboOption = jsonData.er_component;
			comboObject = Ext.getCmp('er_component');
			comboObject.setFieldLabel(screenLabels['reporter.common.Component']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		var reqParam=this.setFromSelectionDetails(); 
		if(reqParam !="null" && reqParam !="")
		{
			var startDateObj = Ext.getCmp('er_stdate');
			var endDateObj = Ext.getCmp('er_enddate');
			var startHrObj = Ext.getCmp('er_sthr');
			var endHrObj = Ext.getCmp('er_endhr');
			var param=reqParam.split("*");
			for(var i=0;i<param.length;i++)
			{
				var value=param[i];
				var key=value.substring(0,value.indexOf("="));
				var val=value.substring(value.indexOf("=")+1);
				if(key!='er_stdate' && key!='er_enddate' && key!='er_sthr' && key!='er_endhr' && key!= 'startmin' && key!='endmin' && key!='displayStartdate' && key!='displayEnddate' && key!='displayStartHour' && key!='displayEndHour')
				{
					Ext.getCmp(key).setValue(val);
				}
				else
				{
					if(key=='er_stdate')
					{												
						startDateObj.dataArray = val;
					}
					if(key=='displayStartdate')
					{
						startDateObj.setValue(val); 
					}
					if(key=='er_sthr')
					{												
						startHrObj.dataArray = val;
					}
					if(key=='displayStartHour')
					{
						startHrObj.setValue(val);
					}
					if(key=='er_enddate')
					{						
						endDateObj.dataArray = val;
					}
					if(key=='displayEnddate')
					{						
						endDateObj.setValue(val); 
					}
					if(key=='er_endhr')
					{						
						endHrObj.dataArray = val;
					}
					if(key=='displayEndHour')
					{						
						endHrObj.setValue(val);
					}
				}
			}
		}

	   /* comboRawData = jsonData.timelineCombo;
		var startDateObj = Ext.getCmp('er_stdate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endDateObj = Ext.getCmp('er_enddate');
		var endHrObj = Ext.getCmp('er_endhr');
		if (!Ext.isEmpty(comboRawData)) {
			selectedComboOption = jsonData.selectedTimeline;           
			comboObject = Ext.getCmp('er_timeline');
			comboObject.setFieldLabel(screenLabels['reporter.common.Timeline']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			var start_hour = jsonData.startHour;
			var end_hour = jsonData.endHour;
			var start_date = jsonData.startDate;
			var end_date = jsonData.endDate;
			
			startDateObj.setValue(jsonData.startDateForDisplay); 
			startDateObj.dataArray = start_date;
		   
			startHrObj.setValue(jsonData.startHourForDisplay);
			startHrObj.dataArray = start_hour;
			
			endDateObj.setValue(jsonData.endDateForDisplay);
			endDateObj.dataArray = end_date;
		   
			endHrObj.setValue(jsonData.endHourForDisplay);
			endHrObj.dataArray = end_hour;
			stmin = jsonData.startMinForDisplay;
			enmin = jsonData.endMinForDisplay;
			mgr_stmin = jsonData.startmin;
			mgr_enmin = jsonData.endmin;
		}
		var reqParam=this.setFromSelectionDetails(); 
		if(reqParam !="null" && reqParam !="")
		{
			var param=reqParam.split("*");
			for(var i=0;i<param.length;i++)
			{
				var value=param[i];
				var key=value.substring(0,value.indexOf("="));
				var val=value.substring(value.indexOf("=")+1);
				Ext.getCmp(key).setValue(val);
			}
		}
		 /*var timelineObj = Ext.getCmp('er_timeline').getValue();
		 if(timelineObj!="Any")
		 {
			 startDateObj.setDisabled(true);
			 endDateObj.setDisabled(true);
			 startHrObj.setDisabled(true);
			 endHrObj.setDisabled(true);
		 }else{
			 startDateObj.setDisabled(false);
			 endDateObj.setDisabled(false);
			 startHrObj.setDisabled(false);
			 endHrObj.setDisabled(false);
		 }*/
	},
		///
	timeLineOnChange:function() {
		var timelineObj = Ext.getCmp('er_timeline').getValue();
		var currDate = appConstants.publicjsonData.hiddenParams.currentformat;
		var startDateObj = Ext.getCmp('er_stdate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endDateObj = Ext.getCmp('er_enddate');
		var endHrObj = Ext.getCmp('er_endhr');
		if(timelineObj!="Any")
		{
			startDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			startHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}
		else
		{
			startDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		}
		var timeline = Ext.getCmp("er_timeline").getValue();
		var strthour = Ext.getCmp("er_sthr").getValue();
		var endhr = Ext.getCmp("er_endhr").getValue();
		var strtdt = Ext.getCmp("er_stdate").getValue();
		var enddt = Ext.getCmp("er_enddate").getValue();

		strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
		enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);

		var no_params = "&P0=[" + timeline + "]&P1=["
						+ strtdt + "]&P2=[" + enddt
						+ "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=["
						+ currDate + "]";
		var param = "F=getTime&C=id" + no_params;
		Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param,
						scope : this,
						method : 'POST',
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{
								var timedata = jsonData.timeline;
								var startDate = "";
								var endDate = "";
								var starthr = "";
								var endhr = "";
								var startmin = "";
								var endmin = "";
								var startDateForDisplay="";
								var endDateForDisplay="";
								var startHourForDisplay = "";
								var endHourForDisplay = "";
								for (var ctr = 0; ctr < timedata.length; ctr = ctr+ 5) {
									startDate = timedata[0];
									endDate = timedata[1];
									starthr = timedata[2];
									endhr = timedata[3];
									startmin = timedata[4];
									endmin = timedata[5];
									startDateForDisplay = timedata[6];
									endDateForDisplay = timedata[7];
									startHourForDisplay = timedata[8];
									endHourForDisplay = timedata[9];
								}
								Ext.getCmp("er_stdate").setValue(startDateForDisplay);
								Ext.getCmp("er_enddate").setValue(endDateForDisplay);
								Ext.getCmp("er_sthr").setValue(startHourForDisplay);
								Ext.getCmp("er_endhr").setValue(endHourForDisplay);
							}
						}
					});
	},
	setFromSelectionDetails:function()
	{ 
		var reqParam;
		if(appConstants.isFrstSelectn)
		{
			reqParam=appConstants.firstSelection;
		}else
		{
			if(appConstants.secondSelection!="null")
				reqParam=appConstants.secondSelection;
			else
				reqParam=appConstants.firstSelection;
		}
		return reqParam;
	},
	selectionQueryString:function()
	{
		var str="er_Selection1="+encodeURIComponent(appConstants.firstSelection)+"&er_Selection2="+encodeURIComponent(appConstants.secondSelection);
		return str;
	},
	storeQueryString:function()
	{
		var str="";
		var store=appConstants.entireTableStore;
		for(var i=0;i<store.getCount();i++)
		{
			var record = store.getAt(i);
			var test = record.get('Test');
			
			var measure = record.get('Measures'); 
			//str+="&er_comb="+test+":"+measure;
			str+="&er_comb="+appConstants.commonTestDisplayObject[test]+":";
			var measureArray;
			if (measure.indexOf(",")>-1)
			{
				measureArray=measure.split(",");
				for (var key in measureArray)
				{ 
					
					if (key==measureArray.length-1)
					{
						str+=appConstants.commonMeasureDisplayObject[test+':'+measureArray[key]];
					}
					else
					{
						str+=appConstants.commonMeasureDisplayObject[test+':'+measureArray[key]]+",";
					}
				}
			}
			else
			{
				str+=appConstants.commonMeasureDisplayObject[test+':'+measure];
			}
		}
		return str;
	},
	mainFormQuerystring:function()
	{
		var qString="";
		//if(!appConstants.hitUsringUrlQry)
		{
			if(this.validateStoreTable())
			{
				var graphmode = Ext.getCmp('er_mode').getValue();
				var reportgen=Ext.getCmp("reportGeneration").getValue();
				var firstSelectDom=Ext.get('firstSelectDom').dom.textContent;
				var secondSelectDom=Ext.get('secondSelectDom').dom.textContent;
				
				firstSelectDom=replaceAll(firstSelectDom,"&","|amp|");
				secondSelectDom=replaceAll(secondSelectDom,"&","|amp|");
				qString+=this.selectionQueryString()+this.storeQueryString()+"&er_reportgenration="+encodeURIComponent(reportgen)+"&isSubmit="+appConstants.isSubmit+'&divStatus=none'+ '&uid=' + appConstants.getUserID+'&us_id=' + appConstants.getUserID+'&er_userid=' + encodeURIComponent(appConstants.getUserID)+'&er_mode=' + graphmode + '&showLegend='+Ext.getCmp('showLegend').getValue()+'&screenWidth=1002&er_gtype=Measure&er_RmDispName='+appConstants.er_RmDispName+'&selectionName1='+encodeURIComponent(firstSelectDom)+'&selectionName2='+encodeURIComponent(secondSelectDom)+'&inidate=' +encodeURIComponent(dateFormat);
				var hiddenFields=appConstants.publicjsonData.hiddenParams;
				if(!Ext.isEmpty(hiddenFields))
				{
					for (var hiddenField in hiddenFields){
						qString+="&"+hiddenField+"="+hiddenFields[hiddenField];
					}
				}
				if(qString.indexOf('&userID=')==-1)
					qString += '&userID=' + appConstants.getUserID;			// To Avoid ClassCastException in ErBackgroundTaskBean.java
				var timeline = Ext.getCmp("er_timeline").getValue();
				var startdate =Ext.getCmp('er_stdate').dataArray;
				var enddate =Ext.getCmp('er_enddate').dataArray;
				var startHour =Ext.getCmp('er_sthr').dataArray;				
				var endHour = Ext.getCmp('er_endhr').dataArray;
				if(appConstants.fromFavSch!=null && appConstants.fromFavSch!=undefined && appConstants.fromFavSch=='true')
				{
					qString+="&er_timeline="+appConstants.publicjsonData.selectedTimeline+"&startdate="+appConstants.publicjsonData.startDate+"&enddate="+appConstants.publicjsonData.endDate+"&startHour="+appConstants.publicjsonData.startHour+"&endHour="+appConstants.publicjsonData.endHour;//+"&startmin="+appConstants.publicjsonData.startmin+"&endmin="+appConstants.publicjsonData.endmin;
				}
				else
				{
					qString+="&er_timeline="+timeline+"&startdate="+startdate+"&enddate="+enddate+"&startHour="+startHour+"&endHour="+endHour+"&er_sthr="+startHour+"&er_endhr="+endHour;
					//+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
				}
				if(timeline!=null && timeline!=undefined && timeline=='Any')
				{
					qString+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
				}
				else
				{
					qString+="&startmin="+appConstants.publicjsonData.startmin+"&endmin="+appConstants.publicjsonData.endmin;
				}
				if (reportgen!=null && reportgen == 'background')
				{
					var reportNameObj = Ext.getCmp('bgReportName');
					var reportName = reportNameObj.getValue();
					if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
					{
						reportNameObj.focus();
						return;
					}
				}
				
			}
			else
			{
				appConstants.removeStoreval=true;
				Ext.MessageBox.show({
					title: appConstants.alertTitleName,
					msg: "Please Select Test and measure values",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			}
		}
		/*else
		{
			qString=appConstants.QueryStringFromURL;
		} */
		return qString;
	},
	testSelectionPopup: function(isNotShowPopUp)
	{ 
		var qString=this.selectionQueryString();
		var url = "/final/reporter/ErTestComparisonReportJson.jsp";

		if(!Ext.isEmpty(appConstants.er_comb) && !appConstants.isCompTypeChanged)
		{
			for(var i=0;i<appConstants.er_comb.length;i++)
			{
				var val=appConstants.er_comb[i];
				if(val.length>0 && val!="null" && val!=null)
				qString+="&er_comb="+val;
			}
		}
		
	
		var thisController = this;
		Ext.Ajax.request({
			url: url,
			params: qString,
			async:false,
			scope: this,
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
			  if (!Ext.isEmpty(jsonData)) {
					appConstants.testJson = jsonData;
					appConstants.commonMeasureDisplayObject = jsonData.commonMeasureDisplayObject;
					appConstants.commonTestDisplayObject = jsonData.commonTestDisplayObject;
					thisController.setTestSelectionPopupDetails(jsonData,isNotShowPopUp);
				}
			}});

	},
	changeTestSelectionPopupText:function (flag)
	{
		if(flag)
		{
			Ext.getCmp('Test').update('<b>Selection Test</b><br/><div style="padding:14px 4px 4px 4px"><a href="javascript:void(0)" name="Test" id="defineconfigurationx" style="text-decoration:underline">Test Configured</a></div>');
		}else
		{
			appConstants.hitUsringUrlQry=false;
			Ext.getCmp('Test').update('<b>Selection Test</b><br/><div style="padding:14px 4px 4px 4px"><a href="javascript:void(0)" name="Test" id="defineconfigurationx" style="text-decoration:underline">Configure Test</a></div>');
		}
	},
	setTestSelectionPopupDetails:function(jsonData,isNotShowPopUp)
	{
		var screenLabels = jsonData.screenLabels;
		var comboRawData;
		var selectedComboOption;
		var comboObject;

		comboRawData = jsonData.testCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption = jsonData.er_test;
			comboObject = Ext.getCmp('er_test');
		//	comboObject.setFieldLabel(screenLabels['reporter.consolidated.Test']);
			comboObject.setFieldLabel('Test');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);

			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		 comboRawData = jsonData.measureCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption = jsonData.er_measure;
			comboObject = Ext.getCmp('er_measure');
			comboObject.getStore().loadRawData(comboRawData);
			appConstants.measureCombo=comboRawData;
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		comboRawData = jsonData.tblDisplayInfo;
		appConstants.isCompTypeChanged=false;
		if(!Ext.isEmpty(comboRawData))
		{
			this.setTableDataInTestPopup(comboRawData);
		}
		if (Ext.isEmpty(isNotShowPopUp))
		{
			Ext.getCmp("testpopup").show();
		}
	},
	setTableDataInTestPopup:function(jsonData)
	{
		var viewStoreObj = Ext.getCmp('mainGrid');
		viewStoreObj.getStore().loadRawData(jsonData);
		appConstants.entireTableStore=viewStoreObj.getStore();
	},
	firstSelectionPopup: function()
	{
		var url = "/final/reporter/ErTestComparisonReportJson.jsp?measureOption=first";
		
		if(appConstants.firstSelection!="null")
		{
			var qString=appConstants.firstSelection;
			if(qString !="null")
			{
				var param=qString.split("*");
				for(var i=0;i<param.length;i++)
				{
					var value=param[i];
					var key=value.substring(0,value.indexOf("="));
					var val=value.substring(value.indexOf("=")+1);
					if(key!="er_component")
					{
						url+="&"+key+"="+val;
					}
				}
			}
		}
		var thisController = this;
		Ext.Ajax.request({
			url: url,
			scope: this,
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if (!Ext.isEmpty(jsonData)) {
					  appConstants.firstJson = jsonData;
					if (appConstants.reportType!='null' && appConstants.reportType=='migration')
					{
						appConstants.secondJson = jsonData;
					}
					thisController.fillMeasurePopup(jsonData);
					thisController.timeLineOnChange();
				}
			}});
		
		
	},
	secondSelectionPopup: function()
	{
		var url = "/final/reporter/ErTestComparisonReportJson.jsp?measureOption=second";
		if(appConstants.secondSelection!="null")
		{
			var qString=appConstants.secondSelection;
			if(qString !="null")
			{
				var param=qString.split("*");
				for(var i=0;i<param.length;i++)
				{
					var value=param[i];
					var key=value.substring(0,value.indexOf("="));
					var val=value.substring(value.indexOf("=")+1);
					if(key=="er_comptype")
					{
						url+="&"+key+"="+val;
					}
				}
			}
		}
		else
		{
			var er_comptype=Ext.getCmp('er_comptype').getValue();
			if (!Ext.isEmpty(er_comptype))
			{
				url+="&er_comptype="+er_comptype;
			}
		}
		var thisController = this;
		Ext.Ajax.request({
			url: url,
			scope: this,
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if (!Ext.isEmpty(jsonData)) {
					appConstants.secondJson = jsonData;
					thisController.fillMeasurePopup(jsonData);
					thisController.timeLineOnChange();
				}

			}});
	},
	goTo: function(btn) {
		var hiddenFields =  appConstants.publicjsonData.hiddenParams; 
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
	},
	printReport: function() {

		var thisController = this;
		if(appConstants.isCompTypeChanged)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please configure test information',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
		else{
			var qString="/final/reporter/ErTestComparisonReportPrint.jsp?"+this.mainFormQuerystring()+"&pdfPrint=yes";
			parent.printWindowFn(qString);
		}
	},
	saveReportAsPDF: function() {

		var thisController = this;
		if(appConstants.isCompTypeChanged)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please configure test information',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
		else{
			var qString="../reporter/ErHtmlToSavePdf.jsp?"+this.mainFormQuerystring()+'&pdfPrint=yes';
			var erUtils = Ext.widget("erutils");
			erUtils.savePDF(qString);
			appConstants.initLdgMask.hide();
		}
	},
	bookletQuery: function(obj)
	{
		var thisController = this;
		if(appConstants.isCompTypeChanged)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please configure test information',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
		else
		{
			var qString=this.mainFormQuerystring()+'&pdfPrint=yes';
			return qString;
		}
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.mainFormQuerystring();
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	sendMail: function() {
		Ext.widget('sendmail').show();
	},
	saveFavorite: function(btn) {
		 
		 
		/* if (appConstants.timeline1=='Any' || appConstants.timeline2=='Any')
		{
			Ext.Msg.alert('Msg','"Any" timeline is not allowed');
			return;
		} */
		if (appConstants.firstSelection=='null' ||  appConstants.secondSelection=='null' || Ext.isEmpty(appConstants.firstSelection) || Ext.isEmpty(appConstants.secondSelection))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please select selections to proceed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		else if (!Ext.isEmpty(appConstants.firstSelection) && !Ext.isEmpty(appConstants.secondSelection) && appConstants.firstSelection!='null' && appConstants.secondSelection!='null' )
		{
			if (Ext.isEmpty(appConstants.entireTableStore))
			{
				this.testSelectionPopup(true); 
			}
			else
			{
				if(appConstants.isCompTypeChanged)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please configure test information',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
			}
		}
		var favorite_id="";
		var s_qryString;

		var hiddenFields = appConstants.publicjsonData.hiddenParams;
		favorite_id = hiddenFields["favorite_id"];
		appConstants.isSubmit=true;
		var qString=this.mainFormQuerystring();
		s_qryString="/final/reporter/ErSaveFavorite.jsp?"+qString+"&cmd=client&isSubmit=true";
		var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
		if (btn.getItemId()=='save')
			document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	 
	},
	saveSchedule: function(btn) {
	   
		if (appConstants.timeline1=='Any' || appConstants.timeline2=='Any')
		{
			Ext.Msg.alert('Msg','"Any" timeline is not allowed');
			return;
		}
 
		if (appConstants.firstSelection=='null' ||  appConstants.secondSelection=='null' || Ext.isEmpty(appConstants.firstSelection) || Ext.isEmpty(appConstants.secondSelection))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please configure test information',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		else if (!Ext.isEmpty(appConstants.firstSelection) && !Ext.isEmpty(appConstants.secondSelection) && appConstants.firstSelection!='null' && appConstants.secondSelection!='null' )
		{
			if (Ext.isEmpty(appConstants.entireTableStore))
			{
				this.testSelectionPopup(true); 
			}
			else
			{
				if(appConstants.isCompTypeChanged)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please configure test information',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
			}
		}
		var s_qryString;
		appConstants.isSubmit=true;
		var qString=this.mainFormQuerystring();
		s_qryString="/final/reporter/ErSaveSchedule.jsp?"+qString;
		var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
		if (btn.getItemId()=='save')
			document.location=target+'&showSchWindow=no';
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	 
	},
	showResult: function()
	{
		appConstants.isSubmit=true; 
		if (!Ext.isEmpty(appConstants.firstSelection) && !Ext.isEmpty(appConstants.secondSelection) && appConstants.firstSelection!='null' && appConstants.secondSelection!='null' )
		{
			if (Ext.isEmpty(appConstants.entireTableStore))
			{
				this.testSelectionPopup(true);
				this.submitReport();
			}
			else
			{
				this.submitReport();
			}
			
		}
		else
		{
			if(appConstants.isCompTypeChanged)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Please configure test information',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			}
			else
			{
				this.submitReport();
			}
		} 
		
	},
	submitReport:function()
	{
		 var thisController = this;
		var qString=this.mainFormQuerystring();
		var reportGeneration= Ext.getCmp('reportGeneration').getValue();
		if(reportGeneration == 'foreground'){
			 Ext.Ajax.request({
				url: '/final/reporter/ErTestComparisonReportJson.jsp',
				scope: this,
				params: qString,
				success: function(response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (!Ext.isEmpty(jsonData))
					{
						appConstants.publicjsonData=jsonData;
						var resultJson=jsonData.Results;
						if (!Ext.isEmpty(resultJson))
						{
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("printTool").setDisabled(false);
							thisController.loadGrid(resultJson);
						}else
						{
							thisController.getNomeasurepanel().show();
						}
					}
				}
			});
		}else
		{
			if(appConstants.firstSelectionStartDate=="null" || appConstants.firstSelectionStartDate=="")
			{
				appConstants.firstSelectionStartDate=appConstants.publicjsonData.startdate;
			}
			if(appConstants.firstSelectionEnddate=="null" || appConstants.firstSelectionEnddate=="")
			{
				appConstants.firstSelectionEnddate=appConstants.publicjsonData.enddate;
			}
			var resultPanelObj=Ext.getCmp('resultPanel'); 
			//var backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json&startdate="+appConstants.firstSelectionStartDate+"&enddate="+appConstants.firstSelectionEnddate;
			var backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
			resultPanelObj.hide();
			var me=this;
			var htmlStr = '';
			appConstants.initLdgMask.show();
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
				params : qString+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;

							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;

							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>';
					}
					me.getBackGroundPanel().update(htmlStr);
					me.getBackGroundPanel().show();
					appConstants.initLdgMask.hide();
				}
			});
		}
	},
	loadGrid:function(jsonData)
	{
		var selection1Json=jsonData.firstOutputJsonArray;
		var selection2Json=jsonData.secondOutputJsonArray;
		reportgenVal=jsonData.er_reportgenration_combo_selected;
		var count;

		if (reportgenVal == 'foreground') {
			var saveObj = Ext.getCmp('bookletTool');
			var saveObj = Ext.getCmp('saveTool');
			var printObj = Ext.getCmp('printTool');
			var mailObj = Ext.getCmp('mailTool');
			var csvObj = Ext.getCmp('csvTool');
			var graphPanelObj = Ext.getCmp('resultPanel');

			this.getNomeasurepanel().hide();
			this.getBackGroundPanel().hide();

			if(!Ext.isEmpty(selection1Json))
			{
				graphPanelObj.removeAll();
				graphPanelObj.show();
				count=selection1Json.length;

				var doms = new Array();
				var imgURLs = new Array(); 
				//var chartDataMap = new Ext.util.HashMap();
				var chartPanelsArray = new Array(); 
				for (var i = 0; i < count; i++) {

					var compName=selection1Json[i]['title'];
					var url1=selection1Json[i]['url'];
					var url2=selection2Json[i]['url'];
					var title1=selection1Json[i]['sub_title'];
					var title2=selection2Json[i]['sub_title'];
					var drill1=selection1Json[i]['drillDown'];
					var drill2=selection2Json[i]['drillDown'];

					var content='<div id="submitreport'+i+'_table" style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';
				//	var content='<div id="submitreport'+i+'_table" style="width:100%"><table width="100%" border="0" class="compareTestTable"><col width="50%"><col width="50%"><tr><td class="header">'+compName+'</td><td class="header">'+compName+'</td></tr><tr>';
					var col=0; 
					var chartDataRowArray = new Array();
					var chartDataDomArray = new Array();
					for (var key=0;key<2;key++)
					{
						var title,url,data,csv,drillDown;
						if(key==0)
						{
							title=title1;
							url=url1;
							drillDown=drill1;
							content+='<td style="padding:5px 5px 10px 10px;">';
						}else
						{
							title=title2;
							url=url2;
							drillDown=drill2;
							content+='<td style="padding:5px 10px 10px 5px;">';
						}
						
						title=replaceAll(title,"|amp|","&");
						data=url+"&option=data";
						var dataoption=url+"&dataoption=data";
						csv=url+"&dataoption=csv";
						drillDown=drillDown+"&reportName=ErMeasure&drillDown=yes&drilldownenabled=Yes&";
						url+="&option=graph&chartType=highchart"; 
						content+='<div width="100%" class="graphMainDiv">';
						content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
						content+=title;
						content+='</div>';
						content+='<div style="float:right;margin:3px 0px 4px 5px;">';
						content+='<div style="float:right;cursor:pointer;margin:0px 5px 0 5px" class="iconCsv" onclick="window.location=\''+csv+'\'"></div>';
						content+='<div style="float:right;cursor:pointer;margin:0px 5px 0 5px" class="iconData" onclick="javascript:loadDataWindow(\''+dataoption+'\');"></div>';
						content+='</div></div>';
						content+='<div class="headerBottomBorder" ></div>';
						imgURLs.push(url);
						var dom='img_'+i+'_'+key;
						doms.push(dom);
						content+='<div id="'+dom+'" style="height:250px;width:100%;padding:0 10 0 0" class="htmlGraphTableBody showDiv">';
						content+='</div>';
						content+='<div style="height:60px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
						content+='<div id="'+dom+'_legend" style="height:55px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
						content+='</div></div>';
						content+='</div></td>';
						col++;
					}

					content+='</tr>';
					content+='</table></div>';

					chartPanelsArray.push({
						 xtype: 'panel',		
						ui:'multiGraphPanel',
						margin:'10 10 5 10',
						title:compName,
						id: 'submitreport' + i,
						html:content
					});
					/*if (!$.isEmptyObject(chartDataRowArray[0]) || !$.isEmptyObject(chartDataRowArray[1]))
					{
						chartDataMap.add(chartDataDomArray[0],chartDataRowArray[0]);
						chartDataMap.add(chartDataDomArray[1],chartDataRowArray[1]);
						chartPanelsArray.push({
							xtype: 'panel',
							id: 'submitreport' + i,
							html:content
						}); 
						chartDataRowArray=null;
						delete chartDataRowArray;
					}*/
				}
				if (chartPanelsArray.length>0)
				{
					graphPanelObj.add(chartPanelsArray);
				 
					/*chartDataMap.each(function(key, value, length){
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsInstance(key,'',''), lineChart);
						lineChart.setData(value,mgrDateFormat,'');
						lineChart.drawChart();
						lineChart=null;
						delete lineChart;
					});*/
					graphPanelObj.doLayout();
					for(var key in imgURLs){
						reportHighStockChart(imgURLs[key],doms[key]);
					}
				}
				else
				{
					this.getNomeasurepanel().show();
				} 
				
				//chartDataMap=null;
				//delete chartDataMap;
			}
			else
			{
				this.getNomeasurepanel().show();
			}
		}
		
	},
	loadDefaults: function() {
		registerAjaxEvents();	//this method is included in ErTracker.jsp
		if (appConstants.selectionName1!='null' && appConstants.selectionName2!='null') 
		{
			appConstants.selectionName1=replaceAll(appConstants.selectionName1,"|amp|","&");
			appConstants.selectionName2=replaceAll(appConstants.selectionName2,"|amp|","&");
			Ext.get('firstSelectDom').update(appConstants.selectionName1); 
			Ext.get('secondSelectDom').update(appConstants.selectionName2);  
		}
		if (!appConstants.hideBackButton) {
			Ext.getCmp('MainForm').add(
					{
						xtype: 'hidden',
						id: 'ID',
						name: 'ID',
						value: appConstants.publicjsonData['ID']
					}
			);
		}
		if(!Ext.isEmpty(appConstants.publicjsonData.repGenOptions))
		{
			var comboRawData;
			var selectedComboOption;
			var comboObject;
			comboRawData = appConstants.publicjsonData.repGenOptions;
			selectedComboOption = appConstants.publicjsonData.selectedReportGen;
			comboObject = Ext.getCmp('reportGeneration');

			comboObject.getStore().loadRawData(comboRawData);


			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}

		if(appConstants.firstSelection!="null")
		{
			appConstants.isFrstSelectn=true;
			appConstants.isSecondSelectn=false;
			var qString=appConstants.firstSelection;
			if(qString !="null")
			{
				var param=qString.split("*");
				for(var i=0;i<param.length;i++)
				{
					var value=param[i];
					var key=value.substring(0,value.indexOf("="));
					var val=value.substring(value.indexOf("=")+1);
					if(key=="er_component")
					{
						Ext.getCmp(key).setValue(val);
					}else if(key=="er_comptype")
					{
						Ext.getCmp(key).setValue(val);
					}
				}
			}
			appConstants.initialLoading=true;
			this.addResults(false);
		}
		if(appConstants.secondSelection!="null")
		{
			appConstants.isSecondSelectn=true;
			appConstants.isFrstSelectn=false;

			var qString=appConstants.secondSelection;
			if(qString !="null")
			{
				var param=qString.split("*");
				for(var i=0;i<param.length;i++)
				{
					var value=param[i];
					var key=value.substring(0,value.indexOf("="));
					var val=value.substring(value.indexOf("=")+1);
					if(key=="er_component")
					{
						Ext.getCmp(key).setValue(val);
					}else if(key=="er_comptype")
					{
						Ext.getCmp(key).setValue(val);
					}
				}
			}
			
			this.addResults(false);
		}

		if(appConstants.firstSelection !="null" && appConstants.secondSelection!="null")
		{
			appConstants.hitUsringUrlQry=true;
		//	this.changeTestSelectionPopupText(true);
			appConstants.isCompTypeChanged=false;
			if(appConstants.frmSchModify!="true"  && appConstants.isSubmit=="true" && appConstants.fromFavouriteModify!="Yes")
				this.showResult();
		}
						//////
		var jsonData =appConstants.publicjsonData;
		var comboRawData = jsonData.timelineCombo;
		var startDateObj = Ext.getCmp('er_stdate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endDateObj = Ext.getCmp('er_enddate');
		var endHrObj = Ext.getCmp('er_endhr');
		if (!Ext.isEmpty(comboRawData)) {
		   var selectedComboOption = jsonData.selectedTimeline;           
			var comboObject = Ext.getCmp('er_timeline');
			//comboObject.setFieldLabel(screenLabels['reporter.common.Timeline']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			var start_hour = jsonData.startHour;
			var end_hour = jsonData.endHour;
			var start_date = jsonData.startDate;
			var end_date = jsonData.endDate;
			
			startDateObj.setValue(jsonData.startDateForDisplay); 
			startDateObj.dataArray = start_date;

			startHrObj.setValue(jsonData.startHourForDisplay);
			startHrObj.dataArray = start_hour;
			
			endDateObj.setValue(jsonData.endDateForDisplay);
			endDateObj.dataArray = end_date;
		   
			endHrObj.setValue(jsonData.endHourForDisplay);
			endHrObj.dataArray = end_hour;
		}

		///////

	},
	showConfigPopup: function() { 
		Ext.EventManager.onWindowResize(function()
		{
//			var popupPanle = Ext.getCmp('popup');
//			var task = new Ext.util.DelayedTask(function(){ 
//				popupPanle.doLayout();
//			});
//			task.delay(10);
//			var popupPanle1 = Ext.getCmp('testpopup');
//			popupPanle.setWidth(Ext.getBody().getViewSize().width - 80);
//			popupPanle.doComponentLayout(); 
//			popupPanle1.setWidth(Ext.getBody().getViewSize().width - 80);
//			popupPanle1.doComponentLayout();
		});
		var thisController = this;
		Ext.getBody().on('click', function(e) {
			var target = e.getTarget(); 
			var targetName = target.name;
			var jsonObj;
			
			if ($(target).hasClass("compReportSelectionIcon"))
			{
				targetName=target.childNodes[0].name;
			}
			appConstants.targetName=targetName; 
			if (targetName == "firstSelection")
			{
				appConstants.isFrstSelectn = true;
				appConstants.isSecondSelectn = false;
				if (typeof appConstants.firstJson != "undefined")
				{
					jsonObj = appConstants.firstJson;
					if (appConstants.reportType!='null' && appConstants.reportType=='migration')
					{
						if(appConstants.secondSelection=="null")
							appConstants.secondJson = jsonObj;
					}
					
					thisController.fillMeasurePopup(jsonObj);
				} else
				{
					thisController.firstSelectionPopup(); 
				}
				var value= Ext.get('firstSelectDom').dom.innerHTML;
					value=replaceAll(value,"|amp|","&");
					Ext.getCmp('selectionNameText').setValue(value);
					Ext.get('selectionNameId').update(value);
					Ext.getCmp('popup').show();
					
			} 
			else if (targetName == "secondSelection")
			{
				if (!Ext.isEmpty(appConstants.firstJson) && appConstants.secondSelection=="null")
				{
					appConstants.isFrstSelectn = false;
					appConstants.isSecondSelectn = true;
					if (appConstants.reportType=='null') //this block for KPI metrics report only
					{
						if (typeof appConstants.secondJson != "undefined" || !Ext.isEmpty(appConstants.secondJson))
						{
							jsonObj = appConstants.secondJson;
							thisController.fillMeasurePopup(jsonObj);
						}
						else
						{
							thisController.secondSelectionPopup();
						}
					}
				  
					var value= Ext.get('secondSelectDom').dom.innerHTML;
					value=replaceAll(value,"|amp|","&");
					Ext.getCmp('selectionNameText').setValue(value);
					Ext.get('selectionNameId').update(value);
					Ext.getCmp('popup').show();
				}else if(appConstants.secondSelection!="null")
				{
					appConstants.isFrstSelectn = false;
					appConstants.isSecondSelectn = true;
					
					thisController.secondSelectionPopup();
					var value= Ext.get('secondSelectDom').dom.innerHTML;
					value=replaceAll(value,"|amp|","&");
					Ext.getCmp('selectionNameText').setValue(value);
					Ext.get('selectionNameId').update(value);
					Ext.getCmp('popup').show();
				}
				else
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: 'Please select first selection to proceed',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				}
			}
			else
			{
				thisController.testConfiguration();
			}
			
		}, null, {
			delegate: 'a#defineconfigurationx'
		});
	},
	removeStoreValues:function(flag)
	{
		if(flag || appConstants.isCompTypeChanged)
		{
			var viewStoreObj = Ext.getCmp('mainGrid');
			viewStoreObj.getStore().removeAll();
			appConstants.removeStoreval=false;
		}
	},
	testConfiguration:function()
	{
		this.removeStoreValues(appConstants.removeStoreval);
		var thisController = this;
		if(appConstants.firstSelection !="null" && appConstants.secondSelection !="null")
		{
			if(appConstants.isCompTypeChanged)
				thisController.testSelectionPopup();
			else
			{
				if (typeof appConstants.testJson == "undefined")
					thisController.testSelectionPopup();
				else
					Ext.getCmp("testpopup").show();
			}
		}
		else
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Please select selection to proceed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
		}
		this.testTypeOnchange(Ext.getCmp("er_test"));
	},
	closePanel: function() {
		Ext.getCmp('popup').hide();
	},
	 closeTestPanel: function() {
		Ext.getCmp('testpopup').hide();
	},
	loadTools: function() {
		this.getNewUtilities().loadIcon(true, //save
				true, //print
				true, //mail
				false, //data
				false, //cvs
				true, // fav
				true, // schedule
				false, //diagnosis
				false, //togglebutton
				false, //close
				true //close
				);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);

	},
	disableTools: function() {
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		// Ext.getCmp("upbutton").setDisabled(true);
		//Ext.getCmp("csvTool").setDisabled(true);
	}
});