Ext.define('CompareTestsApp.view.TestConfigurationPopup', {
    extend: 'Ext.window.Window',
    alias: 'widget.TestConfigurationPopup',
    id: 'testpopup',
	modal: true,
	ghost: false,
	//	height:300,
	constrain:true,
	closeAction:'hide',
	renderTo:Ext.getBody(),
   // title: 'Define Configuration',
	header:false,
    initComponent: function() {
        this.width = Ext.getBody().getViewSize().width - 80;
        this.callParent();
        this.me = this;
    },
	ui:'newPopupWindow',
	//maskCls:'windowModalNoBg',
	border:false,
	style:{
		'background':'transparent !important'
	},
	bodyStyle:{
		'background':'transparent !important'
	},
	frame:false,
	listeners: {
		afterrender: function () {
			Ext.EventManager.onWindowResize(function () {
				var me = this;
				me.center();
			}, this);
		}
	},
	items:[
		{
			xtype:'panel',
			title:'Define Configuration',
			margin:5,
			layout:{
				type:'vbox',
				pack:'center',
				align:'stretch'
			},
			buttonAlign:'center',
			ui:'newFormFieldsInPopup popupHeaderBottomBorder',
			items:[
				 {
					xtype: 'container',
				   // ui: 'newFormContainer',
					border:false,
					margin:10,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items: [
						{
							xtype: 'container',
							padding: 10,
							layout: 'hbox',
							defaults: {
								width: 200,
								labelAlign: 'top',
								margin: '0 20 0 0',
								labelSeparator: ''
							},
							items: [{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									editable: true,
									fieldLabel:'Tests',
									id: 'er_test',
									name: 'er_test',
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data: []
									}),
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									width: 220,
									listConfig:
									{
										emptyText:noTestMatch
									}
								}, 
								{
									xtype: 'fieldcontainer',
									width: 220,
									margin: 0,
									layout: 'vbox',
									labelAlign:'top',
									labelSeparator:'',
									items: [
										{
											xtype: 'label',
											name: 'Measures',
											id: 'Measures',
											text: 'Measures',
											margins: '0 0 5 0'
										},
										{
											xype: 'container',
											cls: 'multisearchlist',
											width: 220,
											margins: '3 0 0 0',
											items: [
												{
													xtype: 'customtrigger',
													emptyText: 'Search Measure',
													id: 'measureSearch'
												}]
										},
										{
											width: 220,
											xtype: 'multiselectfield',
											autoScroll: false,
											scroll: false,
											height: 90,
											labelAlign: 'left',
											allowBlank: false,
											id: 'er_measure',
											name: 'er_measure',
											store: new Ext.data.Store(
											{
												fields: ['displayField', 'valueField'],
												data: []
											}),
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local'
										}
									]
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center',
							},
							margin: '5 0 5 0',
							items: [
								{
									xtype: 'button',
									ui:'newButtonSmall',
									text: "Add",
									id: 'addBtn',
									width: 80
								}
							]
						},
						{
							xtype: 'customgrid',
							//cls: 'gridSkin',
							ui:'newGridPanel',
							id: 'mainGrid',
							store: new Ext.data.Store({
								fields: ['Test', 'Measures'],
								data: []
							}),
							flex: 1,
							border:true,
							queryMode: 'local',
							autoScroll: true,
							scroll: true,
							margin: 5,
							height:140,
							columns: {
								defaults: {
									sortable: true,
									hideable: false,
									menuDisabled: true,
									draggable: false,
									resizable: false
								},
								items: [
									{
										text: "Test",
										dataIndex: 'Test',
										width: 280
									},
									{
										text: "Measures",
										dataIndex: 'Measures',
										flex: 1,
										sortable: false,
										renderer: function(value) {
											return '<table width="100%" cellspacing="0" cellpadding="0"><tr><td valign="top" style="font-size:8pt;font-family:Tahoma,Calibri,Arial,Helvetica,sans-serif;">' + value + '</td></tr></table>';
										}
									},
									{
										header: '<div style="margin-top: 2px;cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
										xtype: 'actioncolumn',
										width: 36,
										iconCls: 'iconDelete',
										//tooltip: 'Delete',
										sortable: false,
										id: 'deleteInView',
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
										   metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove" style="margin-top:2px"';
											return value;
										}
									}
								]
							},
							listeners:{
								'afterrender' : function(grid) {
									grid.mon(Ext.select('#removeALL'), 'click', function() {
										var selectionArray = Ext.getCmp("mainGrid").getStore();
										var selectionArrayLen=selectionArray.getCount();
										if (selectionArrayLen>0)
										{
											Ext.Msg.show({
											title : 'Alert',
											msg : 'Are you sure<br/> You want to remove selected Configuration?',
											buttons : Ext.Msg.YESNO,
											icon : Ext.Msg.QUESTION,
											fn : function(buttonVal) {
													if (buttonVal == "yes") {
														selectionArray.removeAll();
													}
												}
											});
										}
										else
										{
											 Ext.MessageBox.show({
													title: 'Alert',
													msg: 'No selected configuration to remove',
													buttons: Ext.MessageBox.OK,
													icon: Ext.MessageBox.WARNING
											});
										}
									});
								}
							}
						},{
							xtype:'container',
							buttonAlign:'center',
							padding: '5 10 5 10',
							columnWidth:1.0,
							layout:{
								type:'hbox',
								pack :'center',
							},
							items:[{
								xtype:'button',
								id: 'addSelectValue',
								width: 90,
								name: 'addSelectValue',
								text: 'Done',
								ui:'newButtonSmall',
							}]
						}
					]
				}
			],
			tools:[
				{
					xtype:'button',
					iconCls: 'iconCloseNew',
					listeners: {
						afterrender: function () {
							Ext.create('Ext.tip.ToolTip', {
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Close'
							});
						},
						click:function(){
							Ext.getCmp('testpopup').doClose();
						}
					},
					style: {
						background: 'none',
						border: '0px'
					}
				},
			],
		}
	]
});