Ext.define('ComparisonReportComponents.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	store : ['ComparisonReportComponents.store.Configdatas'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'newUtilities',
				ref : 'newUtilities'
			}, {
				selector : 'defineconfiguration',
				ref : 'defineconfiguration'
			}, {
				selector : 'defineconfigurationpopup',
				ref : 'defineconfigurationpopup'
			}, {
				selector : 'configdatas',
				ref : 'configdatas'
			}, {
				selector : 'showcomparsionreport',
				ref : 'showcomparsionreport'
			}, {
				selector : 'graphtypeanddata',
				ref : 'graphtypeanddata'
			}, {
				selector : 'comparsionreportsettings',
				ref : 'comparsionreportsettings'
			}, {
				selector : 'selectiondetails',
				ref : 'selectiondetails'
			}, {
				selector : 'print',
				ref : 'print'
			}, {
				selector : 'ReporterSettings',
				ref : 'ReporterSettings'
			},{
				selector : 'newwindow',
				ref : 'newwindow'
			}],
	init : function() {
		this.control({
					'main' : {
						'boxready' : this.loadpageTitle,
						'beforerender':this.showLoadIcon
					},
					'main newUtilities' : {
						'afterrender' : this.hideTools
					},
					'comparsionreportsettings' : {
						'afterrender' : this.afterSettingsrender
					},
					'defineconfigurationpopup' : {
						'afterrender' : this.renderPopUp
					},
					'main button[id="defineconfiguration"]' : {
						'click' : this.defineConfigurationPOPUP
					},

					'defineconfigurationpopup  button[id="addtogrid"]' : {
						'click' : this.addToGrid
					},
					'defineconfigurationpopup  button[id="defineconfigclose"]' : {
						'click' : this.closePanel
					},
					'defineconfiguration button[id="submit"]' : {
						'click' : this.loadComparsionChart
					},
					'defineconfiguration button[text="Save"]' : {
						'click' : this.add
					},
					'configdatas' : {
						afterrender : function(cmp) {
							var me = this;
							Ext.getBody().on('click', function() {

										me.defineConfigurationPOPUP();
									}, null, {
										delegate : 'b#linkId'
									});
						}
					},
					'graphtypeanddata combo[name=showdata]' : {
						'select' : this.trenddetail
					},
					'graphtypeanddata combo[id="duration"]':
					{
						'select': this.changeTrendTimeline
					},
					'timeline combo[name="er_mode"]':
					 {
						 'select': this.changeEr_mode
					  },
					'newUtilities > #saveTool > button' : {
						'click' : this.saveFileTool
					},
					'newUtilities > #printTool > button' : {
						'click' : this.printFile
					},
					'newUtilities > #mailTool > button' : {
						'click' : this.sendMail
					},
					'newUtilities > #dataTool > button' : {
						'click' : this.dataFile
					},
					'newUtilities > #favoriteTool > button' : {
						'click' : this.add
					},
					'newUtilities > #scheduleTool > button' : {
						'click' : this.add
					},
					 'defineconfiguration button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					},
					'comparsionreportsettings combo[name="reportGeneration"]':{
						'select': this.reportGenChange
					},
					'reportgeneration button[id="moreOptionCloseId"]': {
						'click': this.validateAndCloseSettings
					},
					'reportgeneration button[id="submitViaSetting"]': {
						'click': this.closeSettingAndSubmit
					},
					'main button[id="excelToolBtn"]':{
						'click':this.saveExcel
					}
				});
	},
	showConfigDropdown : function() {
		isSettingsEnabled = true;
		 var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		var me = this;
		Ext.create('Ext.container.Container', {
					width : 565,
					//padding : 5,
					id : 'configMod',
					//cls : 'configMode_popup',
					ui:'settingsWindowContainer',
					//html : tpl.apply(),
					items : [
						{
							xtype:'container',
							cls:'configMode_popupArrow',
							style:{'top':'-14px','left':'329px'}
						},
						{
							xtype:'container',
							html:tpl.apply(),
							cls:'containerHeader',
							style:{'top':'0px','margin':'0px'}
						},
						{
							xtype:'comparsionreportsettings',
							parent:this
						}
					],
					renderTo : 'ComparisonReportComponents-body',
					listeners : {
						render : function() {

							Ext.get('closeSettings').on('click', function() {
								me.validateAndCloseSettings();
								});
						}
					}
				});
	},
	validateAndCloseSettings:function()
	{
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportgenVal == 'background' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return false;
			}
		}
		Ext.get('configMod').animate({
			duration : 500,
					to : {
						y : -500
						}
				});
		return true;
	},
	afterSettingsrender : function() {
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = this.getMain().hiddenFields;
		var favorite_id = hiddenFields["favorite_id"];
		var isShow = hiddenFields["isShowdata"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var screenLabels = defaultJSON.screenLabels;
		var configsettings = Ext.getCmp("configsettings");
		configsettings.loadScreenLabels(screenLabels);
		configsettings.loadDatas(defaultJSON.timelinepopupdetails);
		configsettings.setHiddenField(defaultJSON.hiddenFields['trendenable']);
		var durationCmbo=Ext.getCmp('duration');
		var trendgrphCmbo=Ext.getCmp('gtype');
		if(defaultJSON.timelinepopupdetails.showDataComboArray_value != undefined && defaultJSON.timelinepopupdetails.showDataComboArray_value == 'Yes' ){
			if(durationCmbo != undefined && trendgrphCmbo != undefined){
				durationCmbo.show();
				trendgrphCmbo.show();
			}
		}else{
			if(durationCmbo != undefined && trendgrphCmbo != undefined){
				durationCmbo.hide();
				trendgrphCmbo.hide();
			}
		}
		if (isShow== "false" ||isShow==false)
		{
			Ext.getCmp('showdata').hide();
		}
		else
		{
			Ext.getCmp('showdata').show();
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.loadComparsionChart();
		}
	},
	reportGenChange:function(){
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
		Ext.getCmp('showcomparsionreport').hide();
	},
	showLoadIcon:function(){
		appConstants.initLdgMask.show();
	},
	closePanel : function() {
		Ext.getCmp('popup').hide();

		if (Ext.get('linkId')) {
			Ext.get('linkId').show();
		}
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(false);
	},
	 changeEr_mode: function (combo) {
		var hiddenFields = this.getMain().hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schedule == null || from_schedule == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		this.loadComparsionChart();
     },
	loadComparsionChart : function() 
	{
		 var isService=false;
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var showReportObj = this.getShowcomparsionreport();
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();
		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var er_retainSelection = new Array();
		var noOfrecords = configDatasGrid.getCount();
		var selectionModelObj = configDatas.getSelectionModel();
		if(selectionModelObj.getCount()==0)
		{selectionModelObj.selectAll();}
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
		    if(selectionModelObj.isSelected(rec))
		    {
			var dispName = rec.get('Display Name');
			var name = rec.get('Name_value');
			var Type = rec.get('Type');
			var Layer = rec.get('Layer_value');
			var Test = rec.get('Test_value');
			var Measure = rec.get('Measure_value');
			var Descriptor = rec.get('Descriptor_value');
				Descriptor = appConstants.erUtils.specialCharEncode(Descriptor); 
    			var displayName = rec.get('Name');
    			var layername = rec.get('Layer');
    			var testname = rec.get('Test');
				testname = appConstants.erUtils.specialCharEncode(testname);
    			var measurename = rec.get('Measure');
			dispName=replaceAll(dispName,"&","|amp|");
			group = dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test + "|"
					+ Measure+"|"+Descriptor;
			er_selection.push(group);
			er_combination += dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test
					+ "|" + Measure+"|"+Descriptor;
                er_retainSelection.push(dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test + "|"
                                        + Measure + "|" +Descriptor + "|" +displayName +"|" +Type+"|" +layername+ "|" +testname +"|" +appConstants.erUtils.specialCharEncode(measurename));
			er_combination += "0eghash0eghash0";
			dispnams += dispName;
			if (i < noOfrecords - 1)
				dispnams += ",";
			s_measures.push(Measure);
		    }
		}
        if(selectionModelObj.getCount()==0)
        {
			Ext.getCmp('showcomparsionreport').hide();
        	Ext.Msg.show({
				title : 'Alert',
				msg : 'Choose your selection to view the report',
				buttons : Ext.Msg.OK,
				icon : Ext.Msg.WARNING
				 });
				 return;
        }
		var er_trenddata = defaultJSON.timelinepopupdetails.showDataComboArray_value;
		var er_graphtype = 'Single';//defaultJSON.timelinepopupdetails.graphTypeComboArray_value;
		var er_reportgenration = defaultJSON.timelinepopupdetails.reportgenCombo_value;
		if(appConstants.er_graphtype != "null")
			er_graphtype=appConstants.er_graphtype;
		if (isSettingsEnabled)
		{
			var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			er_trenddata = otherFiltersForm.findField('showdata').getValue();
			er_graphtype = otherFiltersForm.findField('graphtype').getValue();
			er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		var hiddenFields = this.getMain().hiddenFields;
		var thisform=this.getDefineconfiguration().getForm();
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			//
			if(hiddenField!=undefined && hiddenField=='er_service')
				isService=true;
				if(hiddenField!=undefined && hiddenField=='er_dataFrom')
				{
				if(val==undefined ||val=='undefined'||val=='null'||val==null||val=="-1"||val=="")
					continue;
				}
				if(hiddenField!=undefined && hiddenField=='er_service')
				{
				if(val==undefined ||val=='undefined'||val=='null'||val==null||val=="-1"||val=="")
					continue;
				}
			if (appConstants.isSubmit==undefined || appConstants.isSubmit==null || appConstants.isSubmit=='null' || appConstants.isSubmit != 'true')
			{
				if(hiddenField!=undefined && hiddenField!=null && (hiddenField=='er_datafrom'||hiddenField=='er_dataFrom'||hiddenField=='er_service'))
					continue;
			}
			//
			if (val == "NONE")
				val = "";
				param += hiddenField + "=" + val;
				param += "&";
		}
		param = param + "group=" + group + "&er_combination=" + er_combination+ "&dispnams="+ dispnams + "&er_measures=" + s_measures
					+"&showLegend="+thisform.findField('showLegend').getValue();
		for (var j = 0; j < er_selection.length; j++) {
			param += "&er_selection=" +encodeURIComponent(er_selection[j]);
		}
		for(var m=0;m<er_retainSelection.length;m++)
		{
			param +="&er_retainselection="+er_retainSelection[m];
		}
		var er_timeline = thisform.findField('er_timeline').getValue();
		var er_mode = thisform.findField('er_mode').getValue();
		var startdate = thisform.findField('er_stdate').dataArray;
		var starthr = thisform.findField('er_sthr').dataArray;
		var enddate = thisform.findField('er_enddate').dataArray;
		var endhr = thisform.findField('er_endhr').dataArray;

		var mainFilterForm = Ext.getCmp('popup').getForm();

		var er_option = mainFilterForm.findField('Report').getValue();
		var er_service = null;
		if (er_option == 'Service')
			er_service = mainFilterForm.findField('Service').getValue();
		if (er_option == 'Segment')
			er_service = mainFilterForm.findField('Segment').getValue();
		if (er_option == 'Zone')
			er_service = mainFilterForm.findField('Zone').getValue();

		if (er_service == "" || er_service == "-1")
			er_service = null;

		var er_component = mainFilterForm.findField('Component').getValue();
		var er_layer = mainFilterForm.findField('layer').getValue();
		var er_test = mainFilterForm.findField('test').getValue();
		var er_measure = mainFilterForm.findField('measure').getValue();
		var er_info_list = mainFilterForm.findField('descriptors').getValue();

		if (er_component == -1) {
			Ext.Msg.show({
				title : 'Alert',
				msg : appConstants.componentalert,
				buttons : Ext.Msg.OK,
				icon : Ext.Msg.WARNING
			});
			return;
		}
		param += "&er_layer=" + er_layer + "&er_test=" + er_test
				+ "&er_measure=" + s_measures + "&er_info_list=" + appConstants.erUtils.specialCharEncode(er_info_list);

		param += "&er_option=" + er_option 
				+ "&er_timeline=" + er_timeline + "&er_mode=" + er_mode
				+ "&startdate=" + startdate;

		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="
				+ endhr + "&isSubmit=true&modify=true&er_component="
				+ er_component+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
			if (appConstants.isSubmit==undefined || appConstants.isSubmit==null || appConstants.isSubmit=='null' || appConstants.isSubmit != 'true')
			{
				param += '&er_dataFrom='+er_option+'&er_datafrom='+er_option+ "&er_service=" + er_service;
			}
			if(isService!=undefined && !isService)
						param += "&er_service=" + er_service;

		var dataShow = "true";
		if (er_graphtype == 'Multiple') {
			dataShow = "false";
		}
		var len = 24;
		if (er_option == null || er_option == "Component")
			len = 24;
		else if (er_option == "Service" || er_option == "Segment")
			len = 25;
		else if (er_option == "Zone")
			len = 27;
		var p = len + ",";
		var selcount = 0;

		param += "&selectCount=" + p + "&er_displayname=" + dispName
				+ "&er_trenddata=" + er_trenddata + "&er_graphtype="
				+ er_graphtype + "&er_reportgenration=" + er_reportgenration;
		if(er_trenddata != undefined && er_trenddata == 'Yes'){
			var er_duration = defaultJSON.timelinepopupdetails.durationComboArray_value;
			var er_trendGraphType = defaultJSON.timelinepopupdetails.trendGraphComboArray_value;
			if (isSettingsEnabled)
			{
				var otherFiltersForm = Ext.getCmp('configsettings').getForm();
				er_duration = otherFiltersForm.findField('duration').getValue();
				er_trendGraphType = otherFiltersForm.findField('gtype').getValue();
			}
			param += '&er_duration='+encodeURIComponent(er_duration)+'&er_trendGraphType='+encodeURIComponent(er_trendGraphType);
		}

		param += "&dataShow=" + dataShow + "&fromResult=true&userID="+appConstants.userID;
		//var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)),"MM/dd/yyyy");
        //var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)),"MM/dd/yyyy");
		
		var starttime =Ext.getCmp('er_stdate').getValue();
		starttime.setHours(Ext.getCmp('er_sthr').getValue());
		var endtime =  Ext.getCmp('er_enddate').getValue();
		endtime.setHours(Ext.getCmp('er_endhr').getValue());

		var timeVal = true;
		var bool = checkDateTime(starttime, endtime);
        var msxdays = hiddenFields["getMaxDaysInMonth"];
        var inidate = hiddenFields["inidate"];
        var usertimeline =hiddenFields["er_usertimeline"];
		var bdenabled =hiddenFields['bgenabled'];
		if (bool) {
			if (bdenabled == 'Yes' || bdenablede == 'yes') {
				var limitforbg = hiddenFields['limitforbg'];

				var bgtime = getTimeValues(limitforbg, msxdays,startdate, enddate,inidate);
				var getimeline = getTimeValues(er_timeline, msxdays,startdate, enddate,inidate);
				var selectbackground = er_reportgenration;
				var bgprocess = false;
			
				timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline,er_timeline,msxdays,inidate);
				if(!timeVal)
					return;
				if (getimeline >bgtime && selectbackground == 'foreground') 
				{
					var confrimation =hiddenFields['confrimation'];					
					if (confrimation != null && (confrimation =="TRUE" || confrimation.toLowerCase()=="yes" )) {
						bgprocess = true;
						var e_obj = Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn){
							if(btn=="no")
							{
								if (!isSettingsEnabled)
								{
									this.getReporterSettings().down('button').fireHandler();
								}
								var otherFiltersForm = Ext.getCmp('configsettings').getForm();
								otherFiltersForm.findField('reportGeneration').setValue('background');
								otherFiltersForm.findField('bgReportName').setValue("");
								validateTextBoxWithSpecialChars(otherFiltersForm.findField('bgReportName').getValue(),'Attachment',true);
							}
							else
							{
							  if (bool) {
								var old_width = 0;
									var val = false;
									url_value='/final/servlet/com.eg.ErRepoLiteC?showLegend='+Ext.getCmp('showLegend').getValue();
									this.submitData(param, showReportObj,mainFilterForm, dispnams,'/final/servlet/com.eg.ErRepoLiteC');
								} else {
									Ext.Msg.show({
										title : 'Alert',
										msg : appConstants.datealert,
										buttons : Ext.Msg.OK,
										icon : Ext.Msg.WARNING
									});
								}
							}
						},this);
					}
				}
				var selectbackground = defaultJSON.timelinepopupdetails.reportgenCombo_value;
				if (isSettingsEnabled)
				{
					Ext.get('configMod').animate({duration: 500,to: {y: -500}});
					var otherFiltersForm = Ext.getCmp('configsettings').getForm();
					selectbackground = otherFiltersForm.findField('reportGeneration').getValue();
				}
				
				if (selectbackground == 'background' && bgprocess==false) 
				{
					var bg_reportname = otherFiltersForm.findField('bgReportName').getValue();

					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var val = false;

                    bg_reportname=checkFileName(bg_reportname);
					param += "&bg_reportname=" + bg_reportname;
					this.submitData(param + '&isSubmit=true',showReportObj, mainFilterForm,dispnams,'/final/servlet/com.eg.ErStartBackGroundReportC');						
					}
				} else if(!bgprocess){
					if (bool) {
						var old_width = 0;
						var val = false;
						this.submitData(param, showReportObj,mainFilterForm, dispnams,'/final/servlet/com.eg.ErRepoLiteC');
					} else {
						Ext.Msg.show({
									title : 'Alert',
									msg : appConstants.datealert,
									buttons : Ext.Msg.OK,
									icon : Ext.Msg.WARNING
								});
					}
				}
			} else {
				if (bool) {
					var val = false;
					this.submitData(param, showReportObj, mainFilterForm,dispnams, '/final/servlet/com.eg.ErRepoLiteC');
				} else {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.datealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;
				}
			}
		} else {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
	},
	submitData : function(param, showReportObj, mainFilterForm, dispnams, url) {
		showReportObj.show();
		var noItems = new Array();
				//by karthikeyan
		if(appConstants.er_RmDispName == null || appConstants.er_RmDispName == "null")
		{
			appConstants.er_RmDispName="Comparison_Reports - Components";
		}
		param+= '&er_RmDispName='+appConstants.er_RmDispName;
              //
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
		loadMask.show();
		Ext.Ajax.request({
			url : url,
			params : param,
			scope : this,
			method : 'POST',
			success : function(response) {
				loadMask.hide();
				var jsontext = response.responseText;
				var jsonObject = Ext.decode(jsontext);
				var graphtype = jsonObject.graphtype;
				showReportObj.removeAll();
				//showReportObj.getEl().addCls('dataPanel');
				var chartType = jsonObject['chartType'];
				var highChartUrls = new Array();
				var highChartdrilldwonUrls = new Array();
				var highChartIds = new Array();
				if (graphtype == 'single') {
					this.getShowcomparsionreport().getHeader().el.show();
					var grpahQueryString = jsonObject.grpahQueryString;
					var utilitiesJSON = jsonObject.utilitiesJSON;
					this.getMain().utilitiesJSON = utilitiesJSON;
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);
                     Ext.getCmp("dataTool").setDisabled(false);
					if(chartType == "highchart"){
						highChartIds.push('highChart1');
						highChartUrls.push(jsonObject.grpahQueryString+"&chartType="+chartType);
						genHTML='<div id="highChart1" /*style="width:97%;height:98%;"*/ style="height:420px;width:100%;" class="htmlTableBody showDiv"></div>'
						genHTML+='<div style="height:65px;margin-right: 10px;" id="commonLeg_highChart1" class="showDiv commonLeg">';
						genHTML+='<div id="highChart1_legend" style="height:55px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
						genHTML+='</div></div>';
					}
					else{
						genHTML='<img src="' + jsonObject.grpahQueryString+ '" height="400" />';
					}
					var additems = {
						xtype : 'panel',
						//title : 'Comparisosssssn',
						ui:'newGraphPanel',
						margin:'0 10 10 10',
						html : genHTML,
						columnWidth : '1',
						id : 'mulitiplechart',
						height : 485
					}
					noItems.push(additems);
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp('excelTool').setDisabled(false);
					Ext.getCmp("backGroundPanel").hide();
					showReportObj.add(noItems);
				} 
				else if (graphtype == 'multiple') {
				var doms = new Array();
				var content='';
				var col=0;
					content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';
				
					Ext.getCmp("dataTool").setDisabled(true);
					var grpahQueryString = jsonObject.grpahQueryString;
					var utilitiesJSON = jsonObject.utilitiesJSON;

					this.getMain().utilitiesJSON = utilitiesJSON;
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);
 					Ext.get('timeformate').update('<span class="xAxisLabelFontForReporter ">'+jsonObject.timeformat+'</span>'); // adding to tools
					if (grpahQueryString.length > 1) {
						var dispnamesArray = dispnams.split(',');
						for (var k = 0; k < grpahQueryString.length; k++) {
							var evenLastTd=false;
							var imgString = grpahQueryString[k].imgString;
							var drilldownQueryStr = grpahQueryString[k].drilldownQueryStr;
							var s_qryString = drilldownQueryStr.substring(drilldownQueryStr.indexOf("?") + 1,
									drilldownQueryStr.length);
							var s_test_qs = s_qryString.substring(s_qryString.indexOf("er_selection"),s_qryString.length);
							var s_url = "../reporter/ErMeasureDrillDown.jsp?"+ encodeURI(s_test_qs) + "&drillDown=yes";
							var dataURL = grpahQueryString[k].QstringForDataAndCsv+ "&option=data";
							var csvURL = grpahQueryString[k].QstringForDataAndCsv+ "&option=csv";

							if (col==2)
							{
								col=0;
								content+='</tr>';
								content+='<tr>';
							}
							if(k == 0){
								if (grpahQueryString.length>2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else if(grpahQueryString.length==2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else
								{
									content+='<td style="padding:0px 10px 10px 10px">';
								}
							}
							else if(k == 1){
								if (grpahQueryString.length>2)
								{
									content+='<td style="padding:0px 10px 10px 5px">';
								}
								else
								{
									content+='<td style="padding:0px 10px 10px 5px">';
								}
							}
							else if((k%2) == 0){
								if (k==grpahQueryString.length-1)
								{
									evenLastTd=true;
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else if (k==grpahQueryString.length-2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
							}
							else if((k%2) != 0){
								if (k==grpahQueryString.length-1)
								{
									content+='<td style="padding:0px 10px 10px 5px">';
								}
								else{
									content+='<td style="padding:0px 10px 10px 5px">';
								}
							}
							content+='<div width="100%" class="graphMainDiv">';

							var dispName=replaceAll(dispnamesArray[k],"|amp|","&");
							content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+dispName+'">';
							content+=dispName;
							content+='</div>';
							content+='<div style="float:right;margin:3px 0px 4px 5px;">';
							content+='<div style="float:right;cursor:pointer;margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+drilldownQueryStr+'\');"></div>';
							content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconCsv" onclick="window.location=\''+csvURL+'\'" title="CSV"></div>';
							content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconData" onclick="javascript:loadDataWindow(\''+dataURL+'\');" title="Data"></div>';
							content+='</div></div>';
							content+='<div class="headerBottomBorder" ></div>';

							if(chartType == "highchart"){
								var dom="img_" + k;
								doms.push(dom);

								content+='<div id="'+dom+'" style="height:330px;width:100%;" class="htmlTableBody showDiv">';
								highChartIds.push("img_" + k);
								highChartdrilldwonUrls.push(s_url);
								highChartUrls.push(imgString+"&chartType="+chartType);
								genHTML='<div id="highChart'+k+'" style="width:97%;height:260;"></div>';
							}
							else{
								content+='<div style="height:270px;width:100%;" class="htmlTableBody">';
								genHTML='<img src="' + imgString + '" id="img'+ k + '" style="width:100%;height:100%" />';
								content+='<img src="' + imgString + '" id="img'+ k + '" style="width:100%;height:100%" />';
							}
								content+='</div>';
								content+='<div style="height:60px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
								content+='<div id="'+dom+'_legend" style="height:55px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
								content+='</div></div>';
							content+='</div></td>';
							if (evenLastTd)
							{
								content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
							}
							col++;
							}
					}
					if (col==2)
				{
					content+='</tr>';
				}
				content+='</table></div>';

				showReportObj.removeAll();

					showReportObj.add({
						columnWidth:1,
						cls:'newChk',
						html:content,
						listeners:{
							boxready:function(){
								var islegendEnabled = Ext.getCmp('showLegend').getValue();
								if(islegendEnabled == "false" || islegendEnabled ==false){
									var elms = document.getElementsByClassName("commonLeg");
									for(var i = 0; i < elms.length; i++) {
										var chkkk=elms[i].id;
										var tmp_div=document.getElementById(chkkk);
										if(tmp_div != null && tmp_div != undefined)
											tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
									}
								}
							}
						}
					});
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp('excelTool').setDisabled(false);
				} else if(graphtype == "background"){
					this.getShowcomparsionreport().getHeader().el.hide();
					//this.getShowcomparsionreport().addCls("block1");
					//showReportObj.el.removeCls('dataPanel');
					//showReportObj.getEl().removeCls('dataPanel');


					var grpahQueryString = jsonObject.grpahQueryString;
					var status  = grpahQueryString.status;
					var htm='';
						if(status!=undefined && status =='success')
						{
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
						}
						else
						{
							htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
						}

					/*var additems = {
						xtype : backGroundPanel,
						title : '',
						html : htm,
						frame : false,
						margin : '10',
						columnWidth : '1',
//						id : 'backgroundpanel',
						height : 100
					}*/
					 Ext.getCmp("backGroundPanel").update(htm);
					 Ext.getCmp("backGroundPanel").show();
					//noItems.push(additems);
					showReportObj.removeAll();
					showReportObj.hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(false);
				}
				else{
					Ext.getCmp("backGroundPanel").hide();
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
					var additems = {
						xtype : 'commonPanel',
						title : '',
						html : '<img src="/final/images/'+strSkin+'/nomeasures_custom.png" />',
						frame : true,
						margin : '10',
						columnWidth : '1',
						id : 'errorMsg',
						height : 100
					}
					noItems.push(additems);
					showReportObj.add(noItems);
				}
				
				/*if (graphtype == 'multiple')
					showReportObj.body.setStyle("cursor","pointer");*/
				showReportObj.doLayout();
				if(chartType == "highchart"){
					for( var l in highChartIds){
						reportHighStockChart(highChartUrls[l],highChartIds[l],15,20,highChartdrilldwonUrls[l]);
					}
				}
			}
		});
	},
	openDrilldown : function(obj) {

		obj.body.on('click', function() {
					var clickedObj = obj.getId();
					var drilldownURL = obj.dataURL;
					var windowPrintFile = Ext.widget('newwindow'); // call from measurepopupapp
					windowPrintFile.show();
					var printContentDiv = Ext.get('drilldownDiv');
					printContentDiv.set({
								src : drilldownURL
							});
		});
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = this.getDefineconfiguration();
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	renderPopUp : function(popupPanle) {

		var isLoadedFirst = popupPanle.isLoadedFirst;
		if(!isLoadedFirst)
		{

			popupPanle.loadScreenLabels(this.getMain().screenLabels);
			popupPanle.loadReportForCombo(this.getMain().filterJSON);
			var hiddenFields = this.getMain().hiddenFields;

			var userid = hiddenFields['userID'];
			var val = "no";
			var no_params = "&P0=[" + val + "]&P1=[" + userid + "]";
			var param = "F=selectComponents&C=jsrs1" + no_params+ "&U=12233333&fromajax=true&compType=-1";

			Ext.Ajax.request({
						url : '/final/servlet/ErRemoteScriptingServlet',
						params : param,
						scope : this,
						success : function(response) {

							var jsonText = response.responseText;
							var jsonObject = Ext.decode(jsonText);

							var filterForm = popupPanle.getForm();

							// set data for component from JSON
						filterForm.findField('Component').getStore().clearFilter(true); 
						filterForm.findField('Component').getStore().loadRawData(jsonObject.combo);
						filterForm.findField('Component').setValue(jsonObject.values);
						filterForm.findField('displayname').setValue('selection1');
							// set Data for componentType from JSON
						filterForm.findField('Component').getStore().clearFilter(true); 
						filterForm.findField('ComponentType').getStore().loadRawData(jsonObject.CompType);

							popupPanle.isLoadedFirst=true;
							popupPanle.loadEvents();
						}
					});
		}
		Ext.EventManager.onWindowResize(function() {
					popupPanle.doComponentLayout();
					popupPanle.setWidth(Ext.getBody().getViewSize().width - 80);

				});
 	},
	loadpageTitle : function() {
 		this.getMain().loadFields();
		if(appConstants.er_selection!="null")
         {
         	var gridObj = Ext.getCmp('configdatas');
			Ext.getCmp('my_formouter').show();
         //	Ext.getCmp('dockitem').show();
          }
		var jsonData=defaultJSON.timelinepopupdetails;
		var screenLabels=defaultJSON.screenLabels;
		var thisform=this.getDefineconfiguration().getForm();
		this.setComboOptionsInList(thisform, 'er_timeline', jsonData.timelineCombo, jsonData.timeline_value);
       // this.setComboOptionsInList(thisform, 'er_mode', jsonData.graphModeCombo, jsonData.graphMode_value);
        Ext.getCmp("er_stdate").dataArray = jsonData.startDateValue;
        Ext.getCmp("er_stdate").setValue(jsonData.startDateForDisplay);
        Ext.getCmp("er_enddate").dataArray = jsonData.endDateValue;
        Ext.getCmp("er_enddate").setValue(jsonData.endDateForDisplay);
		thisform.findField("er_sthr").setValue(jsonData.startHourForDisplay);
		thisform.findField("er_sthr").dataArray = jsonData.starthour_value;
		thisform.findField("er_endhr").setValue(jsonData.endHourForDisplay);
		thisform.findField("er_endhr").dataArray = jsonData.endhour_value;
		//
			stmin = jsonData.startMinForDisplay;
			enmin = jsonData.endMinForDisplay;
			mgr_stmin = jsonData.startmin;
			mgr_enmin = jsonData.endmin;
        if(jsonData.timeline_value=='Any')
        {
        	thisform.findField("er_stdate").setDisabled(false);
        	thisform.findField("er_enddate").setDisabled(false);
        	thisform.findField("er_sthr").setDisabled(false);
        	thisform.findField("er_endhr").setDisabled(false);
        }

	    //        this.loadComparsionChart();
		var hiddenFields = defaultJSON.hiddenFields;
		var from_schedule = hiddenFields['fromScheduleModify'];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
			if (appConstants.isSubmit == 'true')
			{
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);
				this.loadComparsionChart();
			}
		}
		if(!hideBackButton){
		Ext.getCmp('defineConfig').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value:defaultJSON['ID']
			}
		);
	}
	},
	setComboOptionsInList : function(form, fieldName, list, value){
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        var valueAssigned = false;
        for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
            if(list[listCounter].valueField == value && value != "" && value != null){
                form.findField(fieldName).setValue(value);
                valueAssigned = true;
            }
        }
        if(!valueAssigned){
            form.findField(fieldName).setValue(list[0].valueField);
        }
        form.findField(fieldName).resumeEvents();
    },
	hideTools : function() {
		this.getNewUtilities().loadIcon(true, // save
				true, // print
				true, // mail
				true, // data
				false, // cvs
				true, // fav
				true,// schedule
				false, // daignosis
				false, // togglebutton
				false, // close
				true // close
				);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("dataTool").setDisabled(true);
		Ext.getCmp('excelTool').setDisabled(true);
	},
	sendMail : function() {
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveExcel:function(){
		window.location="../servlet/com.eg.ErXlsController?er_csvrequest=yes";
	},
	defineConfigurationPOPUP : function(panel) {
		if (Ext.get('linkId')) {
			Ext.get('linkId').hide();
		}
		var buttonConObj = Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(true);
		var selectionDetails=Ext.getCmp("selectionDetails");
		if (!Ext.isEmpty(selectionDetails) && !selectionDetails.isHidden()) {
			this.toggleForm(selectionDetails);
		}
		Ext.getCmp('popup').show();
	},
	addToGrid : function(c) {
		// this code is for demo please remove in development
		var formObj = Ext.getCmp('popup').getForm();
		var gridObj = Ext.getCmp('configdatas');
		var tmpStore = gridObj.getStore();

		var componnent = formObj.findField('Component').getRawValue();
		var layer = formObj.findField('layer').getRawValue();
		var test = formObj.findField('test').getRawValue();
		var measure = formObj.findField('measure').getRawValue();
		var descriptior = formObj.findField('descriptors').getRawValue();

		var componnent_value = formObj.findField('Component').getValue();
		var layer_value = formObj.findField('layer').getValue();
		var test_value = formObj.findField('test').getValue();
		var measure_value = formObj.findField('measure').getValue();
		var descriptior_value = formObj.findField('descriptors').getValue();
		var type = componnent.substring(componnent.lastIndexOf(":")+1);
		var report = formObj.findField('displayname').getValue();
		
		if (descriptior_value == 'All' || descriptior_value == 'Not Applicable' || descriptior_value == 'Not Applicable!' || descriptior_value == '-1' || descriptior_value == '')
			descriptior_value = "-";
			
			var flag=checkSpecialCharacters(report);
			if(flag)
			{
				Ext.Msg.show({
					title : 'Alert',
					msg : 'Display Name should not contains Any special characters !',
					buttons : Ext.Msg.OK,
					icon : Ext.Msg.WARNING
				});
				return;
			}

		if (!checkGridValues(componnent_value, layer_value, test_value,
				measure_value, descriptior_value, report))
			return;

		var currentgroup = componnent_value + "|" + layer_value + "|"
				+ test_value + "|" + measure_value + "|" +descriptior_value;
		var noOfrecords = tmpStore.getCount();
		var group = "";
		var flag = 0;
		for (var i = 0; i < noOfrecords; i++) {

			var rec = tmpStore.getAt(i);
			var name = rec.get('Name_value');
			var Type = rec.get('Type');
			var Layer = rec.get('Layer_value');
			var Test = rec.get('Test_value');
			var Measure = rec.get('Measure_value');
			var Descriptor = rec.get('Descriptor_value');
			group = name + "|" + Layer + "|" + Test + "|" + Measure + "|" +Descriptor;
			if (currentgroup == group)
				flag = 1;
		}

		if (flag > 0) {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Your current selection has already been added',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		tmpStore.add([{
					'Display Name' : report,
					'Name' : componnent,
					'Type' : type,
					'Layer' : layer,
					'Test' : test,
					'Measure' : measure,
					'Descriptor' : descriptior_value,
					'Name_value' : componnent_value,
					'Layer_value' : layer_value,
					'Test_value' : test_value,
					'Measure_value' : measure_value,
					'Descriptor_value' : descriptior_value
				}]);
		gridObj.getSelectionModel().selectAll(tmpStore);
		if (tmpStore.getCount() >= 4) {
			//Ext.getCmp('dockitem').show();
			Ext.select('.x-action-col-icon').setStyle('margin-left','-3px'); // icon align to center
		}
		if (tmpStore.getCount() == 3){
			Ext.select('.x-action-col-icon').setStyle('margin-left','0px'); // icon align to orginal state
		}
		dispcount = tmpStore.getCount()+1;
		var t='selection'+dispcount;
		formObj.findField('displayname').setValue(t);
		gridObj.doLayout();
 		Ext.getCmp('my_formouter').show();
		if( Ext.getCmp('showLegend') != undefined){
			if(appConstants.isshowLegend == "true" || appConstants.isshowLegend==true)
				  Ext.getCmp('showLegend').setValue(true);
		}
	},
	removeDatas : function(sm, selections) {
		var gridObj = Ext.getCmp('configdatas');
		if (selections.length >= 0) {
			Ext.getCmp('dockitem').hide();
		}
		gridObj.doLayout();
		if (gridObj.store.getCount() == 0) {
			Ext.getCmp('dockitem').hide();
		} else {
			Ext.getCmp('dockitem').show();
		}
	},
	trenddetail : function(combo) {
		var thisform=this.getDefineconfiguration().getForm();
		var form = this.getComparsionreportsettings().getForm();
		var trenden = form.findField('trendenable').getValue();
		var er_timelineVal = Ext.getCmp('er_timeline').getValue();
		var op = "No";
		var time = Ext.getCmp('er_timeline').getValue();
		var durtnCombo=Ext.getCmp("duration");
		var gtypeCombo=Ext.getCmp("gtype");
		if (trenden == 'true') {
			op = combo.getValue();
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + op + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(comboVal);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == time)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(time);
							else
								timelineCombo.setValue("1 day");
						}
					});
		}
		if(durtnCombo != undefined && gtypeCombo != undefined){
			if(combo.getValue() == 'Yes'){
					durtnCombo.show();
					gtypeCombo.show();
			}
			else{
					durtnCombo.hide();
					gtypeCombo.hide();
			}
		}
		var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
		var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
		var er_sthr =Ext.getCmp('er_sthr');
		var er_endhr = Ext.getCmp('er_endhr');
		var inidateVal = appConstants.currdtFormat;
		var param_val = "";
		if (op == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js
			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr.getValue()
					+ "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal + "]";
		} 
		else
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsontext = response.responseText;
						var jsonObject = Ext.decode(jsontext);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
					}
				});
	},
	changeTrendTimeline: function(combo)
	{
		var mainform=this.getDefineconfiguration().getForm();
		var settingsForm = Ext.getCmp('configsettings').getForm();
		var time = Ext.getCmp('er_timeline').getValue();
		var er_trenddata;
		if(isSettingsEnabled)
		{
			er_trenddata = settingsForm.findField('duration').getValue();
		}
		else
		{
			 er_trenddata = defaultJSON.timelinepopupdetails.durationComboArray_value;
		}
			
		var param1 = "F=getTrendTimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
			params : param1,
			scope : this,
			async : false,
			success : function(response) {
				var jsontext = response.responseText;
				var jsonData = Ext.decode(jsontext);
				var comboVal=jsonData.combo;
				var timelineCombo = mainform.findField('er_timeline');
				timelineCombo.getStore().removeAll();
				timelineCombo.getStore().loadRawData(jsonData.combo);
				if(er_trenddata == 'D')
					timelineCombo.setValue("1 week");
				else if(er_trenddata == 'M')
					timelineCombo.setValue("3 months");
				else
					timelineCombo.setValue("1 day");
			}
		});
		
		var er_stdateObj = mainform.findField('er_stdate');
		var er_sthrObj = mainform.findField('er_sthr');
		var er_enddateObj = mainform.findField('er_enddate');
		var er_endhrObj = mainform.findField('er_endhr');
		var getVal = mainform.findField('er_timeline').getValue();
		if ( getVal == 'Any' )
		{
			er_stdateObj.setDisabled(false);
			er_sthrObj.setDisabled(false);
			er_enddateObj.setDisabled(false);
			er_endhrObj.setDisabled(false);
		}
		else
		{
			er_stdateObj.setDisabled(true);
			er_sthrObj.setDisabled(true);
			er_enddateObj.setDisabled(true);
			er_endhrObj.setDisabled(true);
		}
		var er_timeline = mainform.findField('er_timeline');
		var er_timelineVal = er_timeline.getValue();
		var er_stdate = mainform.findField('er_stdate');
		var er_enddate = mainform.findField('er_enddate');
		var er_sthr = mainform.findField('er_sthr');
		var er_endhr = mainform.findField('er_endhr');
		var inidateVal = appConstants.currdtFormat;
		var er_stdateVal = Ext.Date.dateFormat(er_stdate.getValue(), mgrDateFormat);
		var er_enddateVal = Ext.Date.dateFormat(er_enddate.getValue(), mgrDateFormat);
		var param_val = "";  
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if (er_timelineVal.indexOf("hour") > -1)
				er_timelineVal = "1 day";
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
		var mainform=this.getDefineconfiguration().getForm();
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param_val,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonObject = Ext.decode(jsonText);
					var values = jsonObject.timeline;
					Ext.getCmp('er_stdate').dataArray=values[0];
					Ext.getCmp('er_enddate').dataArray=values[1];
					Ext.getCmp('er_sthr').dataArray=values[2];
					Ext.getCmp('er_endhr').dataArray=values[3]; 
					mgr_stmin = values[4];
					mgr_enmin = values[5];
					Ext.getCmp('er_stdate').setValue(values[6]);
					Ext.getCmp('er_enddate').setValue(values[7]); 
					Ext.getCmp('er_sthr').setValue(values[8]);
					Ext.getCmp('er_endhr').setValue(values[9]); 
					stmin =values[10];
					enmin = values[11];
			}
		});
	},
	enableTimeFields : function(combo) {
		var form=this.getDefineconfiguration().getForm();
		//var form = combo.up('form').getForm();
		if (combo.getValue() == 'Any') {
			form.findField('er_enddate').setDisabled(false);
			form.findField('er_endhr').setDisabled(false);
			form.findField('er_sthr').setDisabled(false);
			form.findField('er_stdate').setDisabled(false);
		} else {
			form.findField('er_enddate').setDisabled(true);
			form.findField('er_endhr').setDisabled(true);
			form.findField('er_sthr').setDisabled(true);
			form.findField('er_stdate').setDisabled(true);
            var timeline = form.findField("er_timeline").getValue();
            var strthour = form.findField("er_sthr").getValue();
            var endhr = form.findField("er_endhr").getValue();
            var strtdt = form.findField("er_stdate").getValue();
            var enddt = form.findField("er_enddate").getValue();
            strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
            enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			var no_params = "&P0=[" + timeline + "]&P1=["
                            + strtdt + "]&P2=[" + enddt
                            + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=["
                            + appConstants.currdtFormat + "]";
            var param = "F=getTime&C=id" + no_params;
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param,
						scope : this,
						method : 'POST',
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData)) {
							    var timedata = jsonData.timeline;
                                var startDate = "";
                                var endDate = "";
                                var starthr = "";
                                var endhr = "";
                                var startmin = "";
                                var endmin = "";
                                for (var ctr = 0; ctr < timedata.length; ctr = ctr+ 5) {
                                    startDate = timedata[0];
                                    endDate = timedata[1];
                                    starthr = timedata[2];
                                    endhr = timedata[3];
                                    startmin = timedata[4];
                                    endmin = timedata[5];
                                }
                               formated_sdate = Ext.Date.dateFormat(startDate, mgrDateFormat);
                               formated_edate = Ext.Date.dateFormat(endDate, mgrDateFormat);
                               form.findField("er_stdate").setValue(startDate);
                               form.findField("er_enddate").setValue(endDate);
                               form.findField("er_sthr").setValue(starthr);
                               form.findField("er_endhr").setValue(endhr);
							}
						}
					});
		}
	},
	saveFileTool : function(tool) {

		var progressBar = Ext.MessageBox.progress({
			title : 'Downloading',
			value : 5,
			width : 350,
			increment : 15,
			closable : false,
			progressText : 'Connecting..',
			wait : true,
			waitConfig : {
				interval : 200
			},
			msg : '<b>Downloading Please wait...</b>',
			scope : this,
			handler : function() {
				this.updateText('Done!');
			}
				// buttons: Ext.MessageBox.CANCEL
			});

		var iFrameExists = Ext.query("#pdfIframe");

		var utilitiesJSON = this.getMain().utilitiesJSON;

		var qs = utilitiesJSON.saveandprintQuery;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + qs+ "&option=Graph&printGraph=yes&er_type=comparison";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var utilitiesJSON = this.getMain().utilitiesJSON;
		var qs = utilitiesJSON.saveandprintQuery;
		var s_qryString = qs+ "&option=Graph&printGraph=yes&er_type=comparison";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var hiddenFields = this.getMain().hiddenFields;
		var form=this.getDefineconfiguration().getForm();
		var mainForm = Ext.getCmp("popup").getForm();
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
				if(hiddenField!=undefined && hiddenField!=null && (hiddenField=='er_datafrom'||hiddenField=='er_dataFrom'||hiddenField=='er_service'))
				continue;

			bookletquery += hiddenField + "=" + val;
			bookletquery += "&";
		}
		if(Ext.isEmpty(appConstants.erUtils)) {
			appConstants.erUtils = Ext.widget("erutils");
		}
		var time = form.findField('er_timeline').getValue();
		var compareLimit = hiddenFields['compareLimit'];
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();

		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var noOfrecords = configDatasGrid.getCount();
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			var dispName = rec.get('Display Name');
			var name = rec.get('Name_value');
			var Type = rec.get('Type');
			var Layer = rec.get('Layer_value');
			var Test = rec.get('Test_value');
			var Measure = rec.get('Measure_value');
			var Descriptor = rec.get('Descriptor_value');
			Descriptor = appConstants.erUtils.specialCharEncode(Descriptor);
			Descriptor=replaceAll(Descriptor,"#","0eghash0");
			dispName=replaceAll(dispName,"&","|amp|");
			group = dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test + "|"+ Measure+"|"+Descriptor;
			er_selection.push(group);
			er_combination += dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test+ "|" + Measure+"|"+Descriptor;
			er_combination += "0eghash0eghash0";
			dispnams += dispName;
			if (i < noOfrecords - 1)
				dispnams += ",";
			s_measures.push(Measure);
		}
		bookletquery+="er_combination=" + encodeURIComponent(er_combination) + "&group=" +  encodeURIComponent(group)+ "&dispnams=" + dispnams + "&er_measures=" + s_measures;
		for (var j = 0; j < er_selection.length; j++) {
			bookletquery+= "&er_selection=" + encodeURIComponent(er_selection[j]);
		}
		var er_timeline = form.findField('er_timeline').getValue();
		var er_mode = form.findField('er_mode').getValue();
		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var er_trenddata = defaultJSON.timelinepopupdetails.showDataComboArray_value;
		var er_graphtype;
		var er_reportgenration = defaultJSON.timelinepopupdetails.reportgenCombo_value;
		if (isSettingsEnabled)
		{
			var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			er_trenddata = otherFiltersForm.findField('showdata').getValue();
			er_graphtype = otherFiltersForm.findField('graphtype').getValue();
			er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		else
		{
			er_graphtype=defaultJSON.timelinepopupdetails.graphTypeComboArray_value;
		}
		var er_option = mainForm.findField('Report').getValue();
		var er_service = null;
		if (er_option == 'Service')
			er_service = mainForm.findField('Service').getValue();
		if (er_option == 'Segment')
			er_service = mainForm.findField('Segment').getValue();
		if (er_option == 'Zone')
			er_service = mainForm.findField('Zone').getValue();

		if (er_service == "" || er_service == "-1")
			er_service = null;

		var er_component = mainForm.findField('Component').getValue();
		var er_layer = mainForm.findField('layer').getValue();
		var er_test = mainForm.findField('test').getValue();
		var er_measure = mainForm.findField('measure').getValue();
		var er_info_list = mainForm.findField('descriptors').getValue();
		er_info_list = appConstants.erUtils.specialCharEncode(er_info_list);

		if(er_info_list != null){
			er_info_list=replaceAll(er_info_list,"#","0eghash0");
		}
		bookletquery+= "&er_layer=" + er_layer + "&er_test=" + er_test+ "&er_measure=" + s_measures + "&er_info_list=" + encodeURIComponent(er_info_list);

		bookletquery+= "&er_option=" + er_option + "&er_service=" + er_service+ "&er_timeline=" + er_timeline + "&er_mode=" + er_mode+ "&startdate="+ startdate+'&er_dataFrom='+er_option+'&er_datafrom='+er_option;

		bookletquery+= "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="+ endhr + "&isSubmit=true&modify=true&er_component="+ er_component;

		var dataShow = "true";
		if (er_graphtype == 'Multiple')
			dataShow = "false";

		var len = 24;
		if (er_option == null || er_option == "Component")
			len = 24;
		else if (er_option == "Service" || er_option == "Segment")
			len = 25;
		else if (er_option == "Zone")
			len = 27;
		var p = len + ",";

		bookletquery+= "&selectCount=" + p + "&er_displayname=" + dispName+ "&er_trenddata=" + er_trenddata + "&er_graphtype="+ er_graphtype + "&er_reportgenration=" + er_reportgenration;
		bookletquery+= "&dataShow=" + dataShow + "&fromResult=true";
		 bookletquery+='&userID='+appConstants.userID+'&CSVFileAsExcel=yes';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile : function() {

		//var windowSaveFile = Ext.widget('print');
		//windowSaveFile.show();
				var utilitiesJSON = Ext.getCmp("ComparisonReportComponents").utilitiesJSON;

		var qs = utilitiesJSON.saveandprintQuery;
		var s_qryString = "../servlet/com.eg.ErRepoLiteC?"
				+ qs
				+ "&option=Graph&printGraph=yes&er_type=comparison&pdfPrint=yes";
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
				}else
					s_qryString+=setLegendVal;
			}
		}
				parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

				/*var utilitiesJSON = this.getMain().utilitiesJSON;
				var qs = utilitiesJSON.saveandprintQuery;

		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + qs
				+ "&option=Graph&printGraph=yes&er_type=comparison";*/

	},
	sendMail : function() {
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 drillDownParams = "&showLegend="+islegendEnabled;
		}
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	dataFile : function() {
		var utilitiesJSON = Ext.getCmp("ComparisonReportComponents").utilitiesJSON;
		//var graphtype = Ext.getCmp("graphtype").getValue();
            var s_qryString = utilitiesJSON.dataQuery;
           parent.maximizeDataWindowLightBox( utilitiesJSON.dataQuery,'REPORTER DATA');//this method is defined in ErReporterMenuDashBoard.jsp for loading drilldown app
	},
	add : function(button) {
// by karthikeyan
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title : 'Comparison Reports',
				msg : 'Chosen timeline not allowed',
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		} */
//
		var thisForm = document.forms[0];
		var form=this.getDefineconfiguration().getForm();
		var mainForm = Ext.getCmp("popup").getForm();

		if (Ext.getCmp("popup").screenLabel == null)
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.combinationalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
		var hiddenFields = this.getMain().hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			//
				if(hiddenField!=undefined && hiddenField!=null && (hiddenField=='er_datafrom'||hiddenField=='er_dataFrom'||hiddenField=='er_service'))
				continue;
			//
			param += hiddenField + "=" + val;
			param += "&";
		}
		var time = form.findField('er_timeline').getValue();
		var scheduleid = hiddenFields['schedule_id'];
		var compareLimit = hiddenFields['compareLimit'];

		if (scheduleid == "NONE" || scheduleid == "undefined" || scheduleid == undefined)
			scheduleid = "";
		var qry = "?";
		var configDatas = Ext.getCmp("configdatas");
		var configDatasGrid = configDatas.getStore();
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}

		var group = "";
		var er_combination = "";
		var dispnams = "";
		var er_selection = new Array();
		var s_measures = new Array();
		var noOfrecords = configDatasGrid.getCount();
		for (var i = 0; i < noOfrecords; i++) {

			var rec = configDatasGrid.getAt(i);
			var dispName = rec.get('Display Name');
			var name = rec.get('Name_value');
			var Type = rec.get('Type');
			var Layer = rec.get('Layer_value');
			var Test = rec.get('Test_value');
			var Measure = rec.get('Measure_value');
			var Descriptor = rec.get('Descriptor_value');
			Descriptor = appConstants.erUtils.specialCharEncode(Descriptor);
			Descriptor=replaceAll(Descriptor,"#","0eghash0");
			dispName=replaceAll(dispName,"&","|amp|");
			group = dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test + "|"+ Measure+"|"+Descriptor;
			er_selection.push(group);
			er_combination += dispName + '0EGSEPeql0EGSEP>' + name + "|" + Layer + "|" + Test+ "|" + Measure+"|"+Descriptor;
			er_combination += "0eghash0eghash0";
			dispnams += dispName;
			if (i < noOfrecords - 1)
				dispnams += ",";
			s_measures.push(Measure);
		}
		param = param+"er_combination=" + encodeURIComponent(er_combination) + "&group=" +  encodeURIComponent(group)+ "&dispnams=" + dispnams + "&er_measures=" + s_measures;
		for (var j = 0; j < er_selection.length; j++) {
			param += "&er_selection=" + encodeURIComponent(er_selection[j]);
		}
		var er_timeline = form.findField('er_timeline').getValue();
		var er_mode = form.findField('er_mode').getValue();
		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var er_trenddata = defaultJSON.timelinepopupdetails.showDataComboArray_value;
		var er_duration = defaultJSON.timelinepopupdetails.durationComboArray_value;
		var er_trendGraphType = defaultJSON.timelinepopupdetails.trendGraphComboArray_value;
		var er_graphtype;
		var er_reportgenration = defaultJSON.timelinepopupdetails.reportgenCombo_value;
		if (isSettingsEnabled)
		{
			var otherFiltersForm = Ext.getCmp('configsettings').getForm();
			er_trenddata = otherFiltersForm.findField('showdata').getValue();
			er_graphtype = otherFiltersForm.findField('graphtype').getValue();
			er_duration = otherFiltersForm.findField('duration').getValue();
			er_trendGraphType = otherFiltersForm.findField('gtype').getValue();
			er_reportgenration = otherFiltersForm.findField('reportGeneration').getValue();
		}
		else
		{
			er_graphtype=defaultJSON.timelinepopupdetails.graphTypeComboArray_value;
		}
		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);
		var er_option = mainForm.findField('Report').getValue();
		var er_service = null;
		if (er_option == 'Service')
			er_service = mainForm.findField('Service').getValue();
		if (er_option == 'Segment')
			er_service = mainForm.findField('Segment').getValue();
		if (er_option == 'Zone')
			er_service = mainForm.findField('Zone').getValue();

		if (er_service == "" || er_service == "-1")
			er_service = null;

		var er_component = mainForm.findField('Component').getValue();
		var er_layer = mainForm.findField('layer').getValue();
		var er_test = mainForm.findField('test').getValue();
		var er_measure = mainForm.findField('measure').getValue();
		var er_info_list = mainForm.findField('descriptors').getValue();
		er_info_list = appConstants.erUtils.specialCharEncode(er_info_list);

		if (er_component == -1) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.componentalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		//by ezhil
		if(er_info_list != null){
			er_info_list=replaceAll(er_info_list,"#","0eghash0");
		}
		param += "&er_layer=" + er_layer + "&er_test=" + er_test+ "&er_measure=" + s_measures + "&er_info_list=" + encodeURIComponent(er_info_list);

		param += "&er_option=" + er_option + "&er_service=" + er_service+ "&er_timeline=" + er_timeline + "&er_mode=" + er_mode+ "&startdate="+ startdate+'&er_dataFrom='+er_option+'&er_datafrom='+er_option;

		param += "&starthr=" + starthr + "&enddate=" + enddate + "&endhr="+ endhr + "&isSubmit=true&modify=true&er_component="+ er_component;

		var dataShow = "true";
		if (er_graphtype == 'Multiple')
			dataShow = "false";

		var len = 24;
		if (er_option == null || er_option == "Component")
			len = 24;
		else if (er_option == "Service" || er_option == "Segment")
			len = 25;
		else if (er_option == "Zone")
			len = 27;
		var p = len + ",";
		var selcount = 0;

		param += "&selectCount=" + p + "&er_displayname=" + dispName+ "&er_trenddata=" + er_trenddata + "&er_graphtype="+ er_graphtype + "&er_reportgenration=" + er_reportgenration;
		param += "&dataShow=" + dataShow + "&fromResult=true";
		if(er_trenddata != undefined && er_trenddata == 'Yes' ){
			param += "&er_duration=" + er_duration + "&er_trendGraphType="+ er_trendGraphType ;
		}
		if (group < 0 || group == "-1")
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.combinationalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
		if (compareLimit > 0) {
			if (er_graphtype == 'Single' && noOfrecords > compareLimit) {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.compare1 + compareLimit + appConstants.compare2,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
		} else if (er_trenddata != null && er_timeline <= 24
				&& er_trenddata == "Yes")
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.timelineallowedalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});

		else if (time != null && time == "Any")
			Ext.Msg.show({
						title : 'Alert',
						msg : _checkspecial,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});

		/*else if (er_trenddata != null && er_trenddata == "Yes" && time == "1 day")
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.timelineallowedalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});*/
		var target = "";
		var hiddenFields =  defaultJSON.hiddenFields;//this.getMain().hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];

		 param+='&userID='+appConstants.userID;
		var windowClass;
		var frameId;
		if (button.getId() == "scheduleImg" || from_schedule == "Yes")
		{
			qry += "&schedule_id=" + scheduleid;
			target = "/final/reporter/ErSaveSchedule.jsp" + qry + "&" + param+"&com.eg.CSRF_NONCE="+csrfToken;
			target+='&CSVFileAsExcel=yes';
			if (button.getId() == "save")
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			} else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
		{
			target = "../servlet/com.eg.ErFavoriteC?cmd=client&" + param+"&com.eg.CSRF_NONCE="+csrfToken;//+ '&FavoriteId='+favorite_id;
			if (button.getId() == "save")
			{
				target+='&showWindow=no'+'&FavoriteId='+favorite_id+'&showLegend='+Ext.getCmp('showLegend').getValue();
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
				//document.location=target;
			} else
			{
				target+='&showLegend='+Ext.getCmp('showLegend').getValue();
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
	}
});