Ext.define('ComparisonReportComponents.view.ComparisonReportComponentsSettings',{
	extend:'Ext.form.Panel',
	alias:'widget.comparsionreportsettings',
	id:'configsettings',
	//cls:'configMode_popup_inner',
	layout:'column',
	screenLabels:null,
	requires:[


			'ComparisonReportComponents.view.GraphTypeAndData',
			'utilities.ReportGeneration',
			'utilities.TimePeriod',
			'utilities.ScrollCombo',
			'utilities.TimeLineSave'
	],
	defaults:{
			labelSeparator : '',
			labelAlign: 'top',
			margin: '0 20 0 0'
		},
	items:[
				{xtype:'graphtypeanddata', margin: '0 0 0 0'},
				{
					xtype: 'splitter',
					height: 2,
					margin: '10px 0px 10px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},
				{xtype:'reportgeneration', margin: '0 0 0 0'}

	],
	loadDatas : function(jsonData){
		var me = this;
		var comparisionSettingsForm = me.getForm();
		me.setComboOptionsInList(comparisionSettingsForm, 'graphtype', jsonData.graphTypeComboArray, jsonData.graphTypeComboArray_value);
		me.setComboOptionsInList(comparisionSettingsForm, 'showdata', jsonData.showDataComboArray, jsonData.showDataComboArray_value);
		me.setComboOptionsInList(comparisionSettingsForm, 'reportGeneration', jsonData.reportgenCombo, jsonData.reportgenCombo_value);
		me.setComboOptionsInList(comparisionSettingsForm, 'duration', jsonData.durationComboArray, jsonData.durationComboArray_value);
		me.setComboOptionsInList(comparisionSettingsForm, 'gtype', jsonData.trendGraphComboArray, jsonData.trendGraphComboArray_value);
		updatingAppSettings();
	},
	setComboOptionsInList : function(form, fieldName, list, value){
        form.findField(fieldName).getStore().loadRawData(list);
        form.findField(fieldName).suspendEvents(false);
        var valueAssigned = false;
        for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
            if(list[listCounter].valueField == value && value != "" && value != null){
                form.findField(fieldName).setValue(value);
                valueAssigned = true;
            }
        }
        if(!valueAssigned){
            form.findField(fieldName).setValue(list[0].valueField);
        }
        form.findField(fieldName).resumeEvents();
    },
    setComboValue : function(form,fieldName,value){
    	 form.findField(fieldName).suspendEvents(false);
    	  form.findField(fieldName).setValue(value);
    	 form.findField(fieldName).resumeEvents();
    },
	loadScreenLabels : function(screenLabels){
		var me = this;
		var comparisionSettingsForm = me.getForm();
		this.screenLabels=screenLabels;


	},
	setHiddenFields : function(hiddenFields)
       {


            var form = this.me.getForm();

                for (var hiddenField in hiddenFields) {

                    if (!form.findField("'" + hiddenField + "'")) {
                        this.add({
                                    xtype : 'hidden',
                                    name : hiddenField,
                                    value : hiddenFields[hiddenField]
                                });
                    } else {

                        form.findField("'" + hiddenField + "'")
                                .setValue(hiddenFields[hiddenField]);
                    }
                }
       },
	setHiddenField: function(hiddenField){
            this.add({
					xtype : 'hidden',
					name : 'trendenable',
					value : hiddenField
		    });

	}
});