Ext.define('ComparisonReportComponents.view.Configdatas', {
	requires : ['Ext.selection.CheckboxModel'],
	extend:'Ext.grid.Panel',
	alias : 'widget.configdatas',
	id : 'configdatas',
	margin : '10 10',
	ui:'newGridPanel',
	maintainFlex:true,
	//padding:'20',
	//title:'Panel Grid',
	//cls : 'gridSkin',
	border:true,
	frame:false,
	//scroll:true,
	//autoScroll:true,
	//enableColumnResize : false,
	enableColumnMove : false,
	enableColumnHide : false,
	sortableColumns : false,
	selModel : new Ext.selection.CheckboxModel({
				checkOnly:true,
				width:50,
				injectCheckbox:0,
			}),
	height : 130,
	store : new Ext.data.Store({
		fields : ['Display Name', 'Name', 'Type', 'Layer', 'Test', 'Measure',
				'Descriptor', 'Name_value', 'Layer_value', 'Test_value',
				'Measure_value', 'Descriptor_value']

			// data:[{'Display
			// Name':'ssd','Name':'pipi','Type':'oip','Layer':'iop','Test':'fd','Measure':'fgf','Descriptor':'ggsdfg'}]
		}),
	viewConfig : {
		deferEmptyText : false,
		emptyText : '<div class="x-grid-empty" style="padding-top:27px;text-align:center" ><div><b  style="cursor:pointer" id="linkId" title="Please define configuration"><div class="iconConfigUser" style="margin:0px auto" ></div>Please define configuration</b></div></div></div>',

		plugins: {
			ptype: 'gridviewdragdrop',
			dragText:'Drag and drop to reorganize',
			
			onViewRender : function(view) {
                var me = this,
                    scrollEl;
                if (me.enableDrag) {
                    if (me.containerScroll) {
                        scrollEl = view.getEl();
                    }                   
                    me.dragZone = new Ext.view.DragZone({
                        view: view,
                        ddGroup: me.dragGroup || me.ddGroup,
                        dragText: me.dragText,
                        containerScroll: me.containerScroll,
                        scrollEl: scrollEl,
                        //to remember if the row was selected originally or not
                        onBeforeDrag: function(data, e) {                            
                            var me = this,                               
                                view = data.view,
                                selectionModel = view.getSelectionModel(),
                                record = view.getRecord(data.item);
                            if (!selectionModel.isSelected(record)) {
                                data.rowSelected = false;
                            } 
                            return true;
                        },

                        onInitDrag: function(x, y) {
                            var me = this,
                                data = me.dragData,
                                view = data.view,
                                selectionModel = view.getSelectionModel(),
                                record = view.getRecord(data.item);
                            //for deselect the dragged record
                            if (selectionModel.isSelected(record) && data.rowSelected == false) {
                                selectionModel.deselect(record, true);                                
                            }
                            //added the original row so it will handle that in the drag drop
                            data.records = [record];                            
                            me.ddel.update(me.getDragText());
                            me.proxy.update(me.ddel.dom);
                            me.onStartDrag(x, y);
                            return true;
                        }
                    });
                }
				if (me.enableDrop) {
                    me.dropZone = new Ext.grid.ViewDropZone({
                        view: view,
                        ddGroup: me.dropGroup || me.ddGroup,
                        //changed the selection at the end of this method
                        handleNodeDrop : function(data, record, position) {
                            var view = this.view,
                                store = view.getStore(),
                                index, records, i, len;

                            if (data.copy) {
                                records = data.records;
                                data.records = [];
                                for (i = 0, len = records.length; i < len; i++) {
                                    data.records.push(records[i].copy());
                                }
                            } else {                                
                                data.view.store.remove(data.records, data.view === view);
                            }                    
                            if (record && position) {
                                index = store.indexOf(record);
                                if (position !== 'before') {
                                    index++;
                                }
                                store.insert(index, data.records);
                            }                            
                            else {
                                store.add(data.records);
                            }
                            if (view != data.view) {
                                view.getSelectionModel().select(data.records);
                            }                                                   
                        }
                    });
                }
			}
		}
		
	},
	columns : [

			{
				text : 'Display Name',
				dataIndex : 'Display Name',
				flex : 1
			}, {
				text : 'Name',
				dataIndex : 'Name',
				flex : 1
			}, {
				text : 'Type',
				dataIndex : 'Type',
				flex : 1
			}, {
				text : 'Layer',
				dataIndex : 'Layer',
				flex : 1
			}, {
				text : 'Test',
				dataIndex : 'Test',
				flex : 1
			}, {
				text : 'Measure',
				dataIndex : 'Measure',
				flex : 1
			}, {
				text : 'Descriptor',
				dataIndex : 'Descriptor',
				flex : 1
			}, {
				//header : '<img src="/final/images/removeall_single_icon.png" id="removeALL" style="cursor:pointer" />',
					header: '<div style="cursor:pointer" id="removeALL" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
				xtype : 'actioncolumn',
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Remove"';
					return value;
				},
				width : 40,
				items : [{
					//icon : '/final/images/remove-row.png',
						iconCls:'iconDelete',
						handler : function(grid, htmlRow, index, columnIndex,
							mouseEvent, record) {
						grid.getStore().remove(record);
						grid.refresh();
						var showReportObj =Ext.getCmp('showcomparsionreport');
						var noOfrecords =grid.getStore().getCount();
  						if (noOfrecords==0)
						{
							Ext.getCmp('my_formouter').hide();
							showReportObj.hide();
						}
						//grid.reload();
					}
				}]
			}],

	loadColumnHeaders : function(screenLabels) {
		if (!Ext.isEmpty(this.columns)) {
			this.columns[1].setText(screenLabels["graphLang"]);
			this.columns[2].setText(screenLabels["nameLang"]);
			this.columns[3].setText(screenLabels["typeLang"]);
			this.columns[4].setText(screenLabels["layerLang"]);
			this.columns[5].setText(screenLabels["testLang"]);
			this.columns[6].setText(screenLabels["measureLang"]);
			this.columns[7].setText(screenLabels["descLang"]);
		}
	},
	listeners : {
		afterLayout : function(c) {
/*
		Ext.select('.hscrollerbase').remove(); // added by jaiwin - for remove horizontal scroll bar.
			if (c.body.dom.fleXcroll) {
				var a = c.body.dom.childNodes;
				var b = [];
				for ( var i = 0, j = 0; i < a.length; i++) {
					if (a[i].id != c.body.id + "_mcontentwrapper"
							&& a[i].id != c.body.id + "_scrollwrapper") {
						b[j] = a[i];
						j++;
					}
				}
				var el = Ext.get(c.body.id + "_contentwrapper");
				for ( var i = 0; i < b.length; i++)
					el.appendChild(b[i]);
			}
			fleXenv.fleXcrollMain(c.body.id);
			var heightOfGrid = c.getView().getHeight();
			//set the view height to display all the rows
			var pageSize=c.getStore().pageSize;
			var viewHeight=c.getView().getHeight();
			var totalHeight=0;
			var rowsVisible=viewHeight/24; //24 for row height
			var pendingRows=pageSize-rowsVisible;
			if(c.getStore().getCount()>rowsVisible){
				totalHeight=pendingRows*24;
			}
			Ext.get(c.getView().getId(), this).setHeight(heightOfGrid+totalHeight);
			Ext.get(c.body.id + "_mcontentwrapper", this).setHeight(heightOfGrid);
			//Ext.get(c.body.id + "_contentwrapper", this).setHeight(heightOfGrid+totalHeight);
			Ext.get(c.body.id + "_contentwrapper", this).setHeight(c.getStore().getCount()* 24);
				if(c.scroll_flag==false){
					c.scroll_flag=true;
					c.doComponentLayout();
				}else{
					c.scroll_flag=false;
				}*/

		},
		'afterrender' : function(grid, scle) {
			grid.mon(Ext.select('#removeALL'), 'click', function() {
				var selectionArray = grid.getSelectionModel().getSelection();
				var selectionArrayLen=selectionArray.length;
				if (selectionArrayLen>0)
				{
					Ext.Msg.show({
					title : 'Alert',
					msg : 'Are you sure you want to remove selected configurations?',
					buttons : Ext.Msg.YESNO,
					icon : Ext.Msg.QUESTION,
					fn : function(buttonVal) {
							if (buttonVal == "yes") {
								var showReportObj =Ext.getCmp('showcomparsionreport');
								var noOfrecords =grid.getStore().getCount();
								for (i = 0; i < selectionArrayLen; i++) {
									grid.getStore().remove(selectionArray[i]);
								}
								if(selectionArrayLen==noOfrecords)
									Ext.getCmp('my_formouter').hide();
									showReportObj.hide();
							}
						}
					});
				}
				else
				{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'No selected configurations to remove',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
			});
		}
	}
});