Ext.define('ComparisonReportComponents.view.DefineConfigurationPopUp', {
	extend : 'Ext.form.Panel',
	alias : 'widget.defineconfigurationpopup',
	floating : true,
	floatable : true,
	draggable : true,
	me : null,
	ui:'newFormFieldsInPopup popupHeaderBottomBorder',
	//cls:'alarmsbg defineconfig defineConfigShadow',
	id : 'popup',
	frame : false,
	//shadowOffset : 15,
	screenLabel : null,
	isLoadedFirst:false,
	title : 'Define Configuration',
	initComponent : function() {
		this.width = Ext.getBody().getViewSize().width - 80;
		this.callParent();
		this.me = this;
	},
	tools : [

	{
				xtype : 'container',
				margin : '0 3px 0 3px',
				cls : 'iconBg close',

				items : [{
							xtype : 'button',
							iconCls : 'iconCloseNew',
							id : 'defineconfigclose',
							//tooltip : '<b>Close</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Close'
											});
											}
										}
						}]
			}

	],
	items : [{
				xtype : 'panel',
				//cls:'formOuter',
				//ui:'newFormPanel',
				bodyPadding:'5 10 0 10',
				margin:'0 10 5 0',
				layout : 'column',
				defaults : {
					labelAlign : 'top',
					labelSeparator : '',
					 margin:'0 20 10 0'
					
				},
				items : [
						{
							xtype : 'scrollcombo',
							cls : 'dropdown',
							width : 130,
							editable : false,
							fieldLabel : 'Report For',
							name : 'Report',
							id : 'Report',
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'report for1',
													'valueField' : 'valueField'
												}, {
													'displayField' : 'report for2',
													'valueField' : 'valueField2'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						}, {
							xtype : 'scrollcombo',
							cls : 'dropdown',
							width : 220,
							editable : true,
							name : 'Service',
							id : 'Service',
							fieldLabel : 'Service',
							listConfig:{
										emptyText:noMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'service1',
													'valueField' : 'service1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}, {
							xtype : 'scrollcombo',
							width : 220,
							cls : 'dropdown',
							fieldLabel : 'Segment',
							name : 'Segment',
							id : 'Segment',
							listConfig:{
										emptyText:noMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}, {
							xtype : 'scrollcombo',
							width : 120,
							margin : '0 20 0 0',
							cls : 'dropdown',
							editable:false,
							labelStyle : 'white-space: nowrap',
							fieldLabel : 'Include Subzones',
							name : 'subzone',
							id : 'subzone',
							value : 'Yes',
							defaultListConfig : {
								loadingHeight : 70,
								minWidth : 50,
								maxHeight : 300,
								shadow : 'sides'
							},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													displayField : yesTxt,
													valueField : 'Yes'
												}, {
													displayField : noTxt,
													valueField : 'No'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}, {
							xtype : 'scrollcombo',
							width : 220,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Zone',
							name : 'Zone',
							id : 'Zone',
							listConfig:{
										emptyText:noMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true

						}, {
							xtype : 'scrollcombo',
							width : 220,
							cls : 'dropdown',
							editable : true,
							fieldLabel : componentTypeTxt,
							name : 'ComponentType',
							id : 'ComponentType',
							listConfig:{
										emptyText:noComponentTypeMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'Component Type1',
													'valueField' : 'Component Type1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 220,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Component Type',
							name : 'Component',
							id : 'Component',
							listConfig:{
										emptyText:noComponentMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'Component Type1',
													'valueField' : 'Component Type1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Layer',
							name : 'layer',
							id : 'layer',
							listConfig:{
										emptyText:noLayerMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'layer1',
													'valueField' : 'layer1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Test',
							name : 'test',
							id : 'test',
							listConfig:{
										emptyText:noTestMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'Test1',
													'valueField' : 'Test1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Measure',
							name : 'measure',
							id : 'measure',
							listConfig:{
										emptyText:noMeasureMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : [{
													'displayField' : 'Measure1',
													'valueField' : 'Measure1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'scrollcombo',
							width : 210,
							cls : 'dropdown',
							editable : true,
							fieldLabel : 'Descriptors',
							name : 'descriptors',
							id : 'descriptors',
							listConfig:{
										emptyText:noDescriptorsMatch
									},
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										fields:[{name:'displayField',convert:function(value, record){
											return Ext.String.htmlDecode(value);
										}}, 'valueField'],
										data : [{
													'displayField' : 'descriptors1',
													'valueField' : 'descriptors1'
												}]
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'

						}, {
							xtype : 'textfield',
							width : 210,
							cls : 'textbox',
							editable : false,
							fieldLabel : 'Display Name',
							name : 'displayname'

						}]

			}

	],
	dockedItems : [{
				dock : 'bottom',
				padding : '0 10 10 10',
				style : {
					'text-align' : 'center',
					'border':'none !important'
				},
				items : [{
							xtype : 'button',
							//cls : 'quickMenuWhiteButton',
							ui:'newButtonSmall',
							width:70,
							id : 'addtogrid',
							text : addLabel
						}]
			}],
	loadReportForCombo : function(jsonData) {

		var filterconfigForm = this.me.getForm();
		filterconfigForm.findField('Report').getStore()
				.loadRawData(jsonData.reporttypeCombo);

		filterconfigForm.findField('Report')
				.setValue(jsonData.defaultreptype_value);

	},
	loadScreenLabels : function(screenLabel) {

		var filterconfigForm = this.me.getForm();
		this.screenLabel = screenLabel;

		filterconfigForm.findField('Report')
				.setFieldLabel(analysisByTxt);
		filterconfigForm.findField('Component')
				.setFieldLabel(screenLabel['reporter.comparison.Component']);
		//filterconfigForm.findField('Report').setFieldLabel(screenLabel['reporter.comparison.Report for']);
		filterconfigForm.findField('Service')
				.setFieldLabel(screenLabel['reporter.comparison.Service']);
		filterconfigForm.findField('Segment')
				.setFieldLabel(screenLabel['reporter.comparison.Segment']);
		filterconfigForm
				.findField('subzone')
				.setFieldLabel(screenLabel['reporter.comparison.Include Subzones']);
		filterconfigForm.findField('Zone')
				.setFieldLabel(screenLabel['reporter.comparison.Zone']);
		// filterconfigForm.findField('compType').setFieldLabel(screenLabel['reporter.comparison.Component']);
		filterconfigForm.findField('layer')
				.setFieldLabel(screenLabel['reporter.comparison.Layer']);
		filterconfigForm.findField('test')
				.setFieldLabel(screenLabel['reporter.common.Test']);
		filterconfigForm.findField('measure')
				.setFieldLabel(screenLabel['reporter.common.Measure']);
		filterconfigForm.findField('descriptors')
				.setFieldLabel(screenLabel['reporter.comparison.descriptors']);
		filterconfigForm.findField('displayname')
				.setFieldLabel(screenLabel['reporter.comparison.Display Name']);
				
		// By Gowtham
		this.me.setAllValue(filterconfigForm, 'ComponentType',
				screenLabel['reporter.common.All']);
				
		this.me.setNotApplicable(filterconfigForm, 'layer',
				screenLabel['reporter.common.Not Applicable']);
		this.me.setNotApplicable(filterconfigForm, 'test',
				screenLabel['reporter.common.Not Applicable']);
		this.me.setNotApplicable(filterconfigForm, 'measure',
				screenLabel['reporter.common.Not Applicable']);
		this.me.setNotApplicable(filterconfigForm, 'descriptors',
				screenLabel['reporter.common.Not Applicable']);
	},
	setAllValue : function(form, fieldname, value) {
		form.findField(fieldname).getStore().removeAll();
		form.findField(fieldname).getStore().loadRawData([{
			"displayField" : this.screenLabel['reporter.common.All'],
			"valueField" : "-1",
		}]);
		form.findField(fieldname).setValue("-1");
	
	},
	setNotApplicable : function(form, fieldname, value) {
		form.findField(fieldname).getStore().removeAll();
		form.findField(fieldname).getStore().loadRawData([{
			"displayField" : this.screenLabel['reporter.common.Not Applicable'],
			"valueField" : "-1"
		}]);
		form.findField(fieldname).setValue("-1");
	},
	loadEvents : function() {

		var form = this.me.getForm();
		form.findField('Report').on('select', this.changeEvent);
		form.findField('Component').on('select', this.changeEvent);
		// By Gowtham
		form.findField('ComponentType').on('select', this.changeEvent);

		form.findField('Service').on('select', this.changeEvent);
		form.findField('Segment').on('select', this.changeEvent);
		form.findField('subzone').on('select', this.changeEvent);
		form.findField('Zone').on('select', this.changeEvent);

		form.findField('layer').on('select', this.changeEvent);
		form.findField('test').on('select', this.changeEvent);
		form.findField('measure').on('select', this.changeEvent);
		form.findField('descriptors').on('select', this.changeEvent);

	},
	changeEvent : function(c) {
		var id = c.getId();

		var thisObj = Ext.getCmp("popup");

		var hiddenFields = Ext.getCmp('ComparisonReportComponents').hiddenFields;

		
		if (id == 'Report') {
			var val = this.getValue();
			thisObj.getForm().findField('ComponentType').setValue("-1");
			thisObj.setNotApplicable(thisObj.getForm(), 'Component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');

			if (val == 'Zone' || val == 'Service' || val == 'Segment') {
				Ext.getCmp(val).show();
				if (val == 'Zone') {
					Ext.getCmp('subzone').show();
					Ext.getCmp('Service').hide();
					Ext.getCmp('Segment').hide();

				} else if (val == 'Service') {
					Ext.getCmp('subzone').hide();
					Ext.getCmp('Zone').hide();
					Ext.getCmp('Segment').hide();

				} else if (val == 'Segment') {
					Ext.getCmp('subzone').hide();
					Ext.getCmp('Zone').hide();
					Ext.getCmp('Service').hide();

				}
				var userid =  hiddenFields['userID'];
				var no_params = "&P0=[" + val + "]&P1=[" + userid + "]";
				var param = "F=selectSites&C=jsrs1" + no_params
						+ "&U=12233333&fromajax=true";
				if (val == 'Service') {

					param = "F=selectSites&C=jsrs1&U=12233333&fromajax=true";

				}
				thisObj.filterComponent(
						'/final/servlet/ErRemoteScriptingServlet', param, val);
			} else if (val == 'Component') {
				Ext.getCmp('subzone').hide();
				Ext.getCmp('Service').hide();
				Ext.getCmp('Segment').hide();
				Ext.getCmp('Zone').hide();

				var param = "filtercomponent=true&callto=getSites&s_value="
						+ val;
				var userid =  hiddenFields['userID'];
				var value_param = "no";
				var no_params = "&P0=[" + value_param + "]&P1=[" + userid + "]";
				var param = "F=selectComponents&C=jsrs1" + no_params
						+ "&U=12233333&fromajax=true";
				thisObj.filterComponent(
						'/final/servlet/ErRemoteScriptingServlet', param, val);
			}
		} else if (id == 'Service') {

			var val = this.getValue();

			//thisObj.getForm().findField('ComponentType').setValue("-1");
			//thisObj.setAllValue(thisObj.getForm(), 'ComponentType', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'Component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var userid =  hiddenFields['userID'];
			var no_params = "&P0=[" + val + "]&P1=[" + userid + "]";
			var param = "F=selectComponents&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
				thisObj.filterComponentAndCompType('/final/servlet/ErRemoteScriptingServlet',
					param, 'Component');

		} else if (id == 'Segment') {

			var val = this.getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'Component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var no_params = "&P0=[" + id + "]&P1=[" + val + "]&P2=No";
			var param = "F=selectComponents&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponentAndCompType('/final/servlet/ErRemoteScriptingServlet',
					param, 'Component');

		} else if (id == 'subzone') {

		} else if (id == 'Zone') {

			var val = this.getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'Component', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var inclusub_zone = thisObj.getForm().findField('subzone')
					.getValue();
			var no_params = "&P0=[" + id + "]&P1=[" + val + "]&P2="
					+ inclusub_zone;
			var param = "F=selectComponents&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponentAndCompType('/final/servlet/ErRemoteScriptingServlet',
					param, 'Component');
		} else if (id == 'Component') {

			var val = this.getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var userid =  hiddenFields['userID'];
			var no_params = "&P0=[" + val + "]&P1=[" + userid + "]";
			var param = "F=selectLayers&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponent('/final/servlet/ErRemoteScriptingServlet',
					param, 'layer');
		} else if (id == 'layer') {

			var val = this.getValue();

			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var userid = hiddenFields['userID'];
			var datafrom = thisObj.getForm().findField('Report').getValue();
			var site = "";
			if (datafrom != null && datafrom == 'Service') {
				site = thisObj.getForm().findField('Service').getValue();
			} else {
				site = "NULL";
			}
			var component = thisObj.getForm().findField('Component').getValue();

			var no_params = "&P0=[" + site + "]&P1=[" + component + "]&P2=["
					+ val + "]&P3=[" + userid + "]";
			var param = "F=selectTests&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponent('/final/servlet/ErRemoteScriptingServlet',
					param, 'test');

		} else if (id == 'test') {

			var val = this.getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');
			var userid = hiddenFields['userID'];
			var layer = thisObj.getForm().findField('layer').getValue();

			var no_params = "&P0=[" + layer + "]&P1=[" + val + "]&P2=["
					+ userid + "]";
			var param = "F=selectMeasures&C=jsrs1" + no_params
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponent('/final/servlet/ErRemoteScriptingServlet',
					param, 'measure');

			var datafrom = thisObj.getForm().findField('Report').getValue();
			var site = "";
			if (datafrom != null && datafrom == 'Service')
			{
				site = thisObj.getForm().findField('Service').getValue();
			}
			else
			{
				site = "NULL";
			}
			var component = thisObj.getForm().findField('Component').getValue();

			no_params = "&P0=[" + site + "]&P1=[" + component + "]&P2=["
					+ layer + "]&P3=[" + val + "]&P4=[" + userid + "]";

			param = "F=selectDescriptors1&C=jsrs2" + no_params
					+ "&U=123453423434&fromajax=true";
			thisObj.filterComponent('/final/servlet/ErRemoteScriptingServlet',
					param, 'descriptors');
		} else if (id == 'measure') {

		} else if (id == 'descriptors') {

		}else if (id == 'ComponentType') {
			var val = this.getValue();
			thisObj.setNotApplicable(thisObj.getForm(), 'layer', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'test', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'measure', '-1');
			thisObj.setNotApplicable(thisObj.getForm(), 'descriptors', '-1');


			var hiddenFields = Ext.getCmp('ComparisonReportComponents').hiddenFields;

			var userid = hiddenFields['userID'];
			var value = "no";

		// by karthikeyan-for particuular zon,segment,service -components only show
		var er_option = thisObj.getForm().findField('Report').getValue();
		var er_service = null;
			if (er_option == 'Service')
			{
				er_service = thisObj.getForm().findField('Service').getValue();
			}
			if (er_option == 'Segment')
			{
				er_service = thisObj.getForm().findField('Segment').getValue();
			}
			if (er_option == 'Zone')
			{
				er_service = thisObj.getForm().findField('Zone').getValue();
			}

			var inclusub_zone = thisObj.getForm().findField('subzone')
					.getValue();
			var no_params = "&P0=["+er_option+"]&P1=["+er_service+"]&P2="
					+ inclusub_zone;
			
			var param = "F=selectComponents&C=jsrs1" + no_params
					+ "&U=12233333&fromajax=true&compType="+val;
			thisObj.filterComponent('/final/servlet/ErRemoteScriptingServlet',
					param, 'Component');
		}
	},
	filterComponent : function(url, param, val) {

		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						var jsontext = response.responseText;
						var jsonObject = Ext.decode(jsontext);
						this.me.getForm().findField(val).getStore()
								.loadRawData(jsonObject.combo);
						
						if (val == 'descriptors') {
							this.me.getForm().findField(val).setValue(this.me
									.getForm().findField(val).getStore()
									.getAt(0));
						} else {
						  this.me.getForm().findField(val)
								.setValue(jsonObject.values);
                       }

					}
				});
	},
		filterComponentAndCompType : function(url, param, val) {
		
		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						var jsontext = response.responseText;
						var jsonObject = Ext.decode(jsontext);

						//
						this.me.getForm().findField('ComponentType').getStore()
								.loadRawData(jsonObject.CompType);
						//

						this.me.getForm().findField(val).getStore()
								.loadRawData(jsonObject.combo);
						if (val == 'descriptors') {
							this.me.getForm().findField(val).setValue(this.me
									.getForm().findField(val).getStore()
									.getAt(0));
						} else {
						  this.me.getForm().findField(val)
								.setValue(jsonObject.values);
                       }

					}
				});
	}

});