Ext.define('ComparisonReportTests.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'defineconfiguration',ref:'defineconfiguration'},
		{selector:'defineconfigurationpopup',ref:'defineconfigurationpopup'},
		{selector:'configdatas',ref:'configdatas'},
		{selector:'showcomparisonreport',ref:'showcomparisonreport'},
		//{selector:'defineconfigurationpopup',ref:'defineconfigurationpopup'},
		{selector:'backgroundresults',ref:'backgroundresults'},
		{selector:'backGroundPanel',ref:'backGroundPanel'},
		//{selector:'print',ref:'print'}
		{selector:'comparisonreportsettings',ref:'comparisonreportsettings'}
	],
	init:function()
	{
		this.control(
		{
			'main':
			{
				'boxready':this.loadDefaults,
			},
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'comparisonreportsettings':
			{
				'afterrender': this.afterSettingsrender
			},
			'defineconfigurationpopup':
			{
				'afterrender':this.renderPopUp
			},
			'main button[id="defineconfiguration"]':
			{
				'click':this.defineConfigurationPOPUP
			},
			'defineconfigurationpopup  button[id="expandSelector"]':
			{
				'click':this.expandMe
			},
			'defineconfigurationpopup  button[id="expandSelector2"]':
			{
				'click':this.expandMe2
			},
			'defineconfigurationpopup  button[id="addtogrid"]':
			{
				'click':this.addToGrid
			},
			'defineconfiguration button[id="submit"]':
			{
				'click':this.beforeFormSubmit
			},
		   	'timeline combo[name="er_mode"]': 
			{
			  'select': this.changeEr_mode
			},
			'defineconfiguration button[name="save"]':
			{
				'click':this.goTo
			},
			
			'configdatas':
			{
				afterrender: function(cmp)
				{
					var me = this;
					Ext.getBody().on('click',function(){ // call dom ref 
						me.defineConfigurationPOPUP();
					},null,{ delegate:'b#linkId'});
				}
			},
			'defineconfigurationpopup button[id="defineConfiguration"]':
			{
				'click': this.showConfiguration
			},
			'defineconfigurationpopup combo[id="criteria"]':
			{
				'select': this.changeCriteria
			},
			'defineconfigurationpopup combo[id="Report"]':
			{
				'select': this.selectReportFor
			},
			'comparisonreportsettings combo[id="CommonMaximum"]':
			{
				'select': this.changeCommonMaximum
			},
			'comparisonreportsettings combo[id="autoMaximum"]':
			{
				'select': this.changeAutoMaximum
			},
			'defineconfigurationpopup combo[id="test"]':
			{
				'select': this.changeTest
			},
			'defineconfigurationpopup combo[id="metric"]':
			{
				'select': this.changeMetric
			},
			'defineconfigurationpopup combo[id="zone"]':
			{
				'select': this.changeZone
			},
			'defineconfigurationpopup combo[id="segment"]':
			{
				'select': this.changeSegment
			},
			'defineconfigurationpopup combo[id="service"]':
			{
				'select': this.changeService
			},
			'defineconfigurationpopup combo[id="subzone"]':
			{
				'select': this.changeZone
			},
			'defineconfigurationpopup multiselect[id="component"]':
			{
				'change': this.selectComponents
			},
			'defineconfigurationpopup trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'defineconfigurationpopup trigger[id="descSearch"]':
			{
				'change': this.filterMultiselect
			},
			'comparisonreportsettings combo[id="showdata"]':
			{
				'select': this.changeTimeline
			},
			'comparisonreportsettings combo[id="duration"]':
			{
				'select': this.changeTrendTimeline
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'comparisonreportsettings combo[id="reportGeneration"]':
			{
				'select': this.changeReportGeneration
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReport
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #dataTool > button':
			{
				'click': this.showReportData
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorite
			},
			  'defineconfiguration button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'main button[id="excelToolBtn"]':{
				'click':this.saveExcel
			}
		});
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		 var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');	
		//config dropdown mode
		Ext.create('Ext.container.Container',{
		width:564,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		//html:tpl.apply(),
		items:[	 
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'327px'}
			},
			{
				xtype:'container',
				html:tpl.apply(),
				cls:'containerHeader',
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype:'comparisonreportsettings',
				parent:this
			}
		],
		renderTo:'comparisonreporttests-body'
		});
			
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			var result = me.validateSettings();
			if ( !result )
			{
				return;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		});
	},
	afterSettingsrender : function() {
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicJSON['hiddens'];
		favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData = appConstants.publicJSON;
		var screenLabels = jsonData['screenLabels']
		var settingsForm = Ext.getCmp('configsettings').getForm();

		var graphtypeObj = settingsForm.findField('graphtype');
		graphtypeObj.setFieldLabel(screenLabels['reporter.comparison.GraphType']);
		
		var showdataObj = settingsForm.findField('showdata');
		showdataObj.setFieldLabel(screenLabels['reporter.common.ShowData']);
		
		var commonMaximumObj = settingsForm.findField('CommonMaximum');
		commonMaximumObj.setFieldLabel(screenLabels['reporter.comparison.CommonMaximum']);
		
		var autoMaximumObj = settingsForm.findField('autoMaximum');
		autoMaximumObj.setFieldLabel(screenLabels['reporter.comparison.AutoMaximum']);
		
		var maxValueObj = settingsForm.findField('maxValue');
		maxValueObj.setFieldLabel(screenLabels['reporter.comparison.MaxValue']);
		
		var reportGenerationObj = settingsForm.findField('reportGeneration');
		reportGenerationObj.setFieldLabel(screenLabels['reporter.consolidated.ReportGeneration']);
		
		var bgReportNameObj = settingsForm.findField('bgReportName');
		bgReportNameObj.setFieldLabel(screenLabels['reporter.consolidated.ReportName']);
		
		var graphTypeObj = settingsForm.findField('graphtype');
		var graphTypeData = jsonData['graphTypeCombo'];
		var showGraphTypeSelected = jsonData['showGraphTypeSelected'];
		if ( !Ext.isEmpty( graphTypeData ) )
		{
			graphTypeObj.suspendEvents(true);
			graphTypeObj.getStore().loadRawData(graphTypeData);
			if ( !Ext.isEmpty( showGraphTypeSelected ) )
			{
				graphTypeObj.setValue( showGraphTypeSelected );
			}else{
				graphTypeObj.setValue(graphTypeData[0].valueField);
			}
			graphTypeObj.resumeEvents();
		}
		var showdataObj = settingsForm.findField('showdata');
		var showdataVal = jsonData['showDataCombo'];
		if ( !Ext.isEmpty( showdataVal ) )
		{
			var showDataSelected = jsonData['showDataSelected'];
			showdataObj.suspendEvents(true);
			showdataObj.getStore().loadRawData( showdataVal );
			if ( !Ext.isEmpty( showDataSelected ) )
			{
				showdataObj.setValue( showDataSelected );
			}
			showdataObj.resumeEvents();
		}
		var trendenablee = jsonData['hiddens'].trendenable;
		if(trendenablee == 'false')
		{
			Ext.getCmp('showdata').hide();
		}
		else
		{
			Ext.getCmp('showdata').show();
		}
		var commonMaxObj = settingsForm.findField('CommonMaximum');
		var commonMaxComboData = jsonData['commonMaxCombo'];
		if ( !Ext.isEmpty( commonMaxComboData ) )
		{
			var commonMaxComboSelected = jsonData['commonMaxComboSelected'];
			commonMaxObj.suspendEvents(true);
			commonMaxObj.getStore().loadRawData(commonMaxComboData);
			if ( !Ext.isEmpty( commonMaxComboSelected ) )
			{
				commonMaxObj.setValue(commonMaxComboSelected);
			}
			commonMaxObj.resumeEvents();
			//me.changeCommonMaximum();
		}
		var autoMaxComboObj = settingsForm.findField('autoMaximum');
		var autoMaxComboData = jsonData['autoMaxCombo'];
		if ( !Ext.isEmpty( autoMaxComboData ) )
		{
			var autoMaxComboSelectedData = jsonData['autoMaxComboSelected'];
			autoMaxComboObj.suspendEvents(true);
			autoMaxComboObj.getStore().loadRawData(autoMaxComboData);
			if ( !Ext.isEmpty( autoMaxComboSelectedData ) )
			{
				autoMaxComboObj.setValue(autoMaxComboSelectedData);
			}
			autoMaxComboObj.resumeEvents();
			//me.changeAutoMaximum();
		}
		var durationComboObj = settingsForm.findField('duration');
		var durationComboData = jsonData['duration'];
		if ( !Ext.isEmpty( durationComboData ) )
		{
			var autoMaxComboSelectedData = jsonData['durationcomboSelected'];
			durationComboObj.suspendEvents(true);
			durationComboObj.getStore().loadRawData(durationComboData);
			if ( !Ext.isEmpty( autoMaxComboSelectedData ) )
			{
				durationComboObj.setValue(autoMaxComboSelectedData);
			}
			durationComboObj.resumeEvents();
		}
		var gtypeComboObj = settingsForm.findField('gtype');
		var gtypeComboData = jsonData['trendGraphtypecombo'];
		if ( !Ext.isEmpty( gtypeComboData ) )
		{
			var autoMaxComboSelectedData = jsonData['trendGraphtypecomboSelected'];
			gtypeComboObj.suspendEvents(true);
			gtypeComboObj.getStore().loadRawData(gtypeComboData);
			if ( !Ext.isEmpty( autoMaxComboSelectedData ) )
			{
				gtypeComboObj.setValue(autoMaxComboSelectedData);
			}
			gtypeComboObj.resumeEvents();
		}
		if(showdataObj != undefined && showdataObj.getValue() == 'Trend'){
			if(durationComboObj != undefined && gtypeComboObj != undefined){
				durationComboObj.show();
				gtypeComboObj.show();
			}
		}
		this.changeCommonMaximum();
		var commonMaxRangeValueData = jsonData['commonMaxRangeValue'];
		if ( !Ext.isEmpty( commonMaxRangeValueData ) )
		{
			var maxValueObj = settingsForm.findField('maxValue');
			maxValueObj.suspendEvents(true);
			maxValueObj.setValue(commonMaxRangeValueData);
			maxValueObj.resumeEvents();
		}
		var reportGenerationData = jsonData['reportGeneration'];
		var reportGenerationObj = settingsForm.findField('reportGeneration');
		if ( !Ext.isEmpty( reportGenerationData ) )
		{
			var reportGenerationSelectedData = jsonData['reportGenerationSelected'];
			reportGenerationObj.suspendEvents(true);
			reportGenerationObj.getStore().loadRawData(reportGenerationData);
			if ( !Ext.isEmpty( reportGenerationSelectedData ) )
			{
				reportGenerationObj.setValue( reportGenerationSelectedData );
			}
			reportGenerationObj.resumeEvents();
		}
				 updatingAppSettings();
		var bgReportNameVal = jsonData['bgReportName'];
		var bgReportNameObj = settingsForm.findField('bgReportName');
		if ( !Ext.isEmpty( bgReportNameVal ) )
		{
			bgReportNameObj.suspendEvents(true);
			bgReportNameObj.setValue( bgReportNameVal );
			bgReportNameObj.resumeEvents();
		}
	},
	goTo: function (btn) {
			// by karthikeyan
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Comparision Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
//
		appConstants.formButtonId = btn.getId();
	var hiddenFields = appConstants.publicJSON['hiddens'];
	var from_fav = hiddenFields["fromFavoriteModify"];

	if ((from_fav != null && from_fav == "Yes")) {
		//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.showFavorite(btn);
		} else {
			this.showSchedules(btn)
	}
	},
	beforeFormSubmit: function () {
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		var getMaxDaysInMonth =appConstants.publicJSON.hiddens['getMaxDaysInMonth'];
		var er_usertimeline =appConstants.publicJSON.hiddens['er_usertimeline'];
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		//
		var starttime =Ext.getCmp('er_stdate').getValue();
		starttime.setHours(Ext.getCmp('er_sthr').getValue());
		var endtime =  Ext.getCmp('er_enddate').getValue();
		endtime.setHours(Ext.getCmp('er_endhr').getValue());
		var timeVal = true;
		var bool = checkDateTime(starttime, endtime);
		if (!bool)
		{
			return;
		}
		//
		var limitforbg =appConstants.publicJSON.hiddens['limitforbg'];

		var reportgenVal = appConstants.publicJSON['reportGenerationSelected'];
		if (isSettingsEnabled)
		{
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
		}
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
				{
					Ext.Msg.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
				} else {
					this.showResult('yes');
				}
			} else {
				this.showResult('yes');
			}
		}else {
				this.showResult('yes');
			}
	},
       changeEr_mode: function (combo) {
			var hiddenFields = appConstants.publicJSON['hiddens'];
			favorite_id = hiddenFields["favorite_id"];
			var fromScheduleModify = hiddenFields["fromScheduleModify"];
			if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(fromScheduleModify == null || fromScheduleModify == 'null'))
			{
				return;
			}
			Ext.get('configMod').animate({
					duration: 250,
					to: {
					y: -530
				}
			});
			this.beforeFormSubmit();
     },
	showFavorite: function( obj )
	{
		var qString = this.updateQueryString();
 		/*var split = qString.split('&');
		for ( var i = 0; i < split.length; i++ )
		{
			var reqParam = split[i].substring(0, split[i].indexOf('=') );
			var reqValue = split[i].substring( split[i].indexOf('=') + 1 );
			if ( qString.indexOf( reqParam ) == 0 )
			{
				qString += '&'+reqParam+'='+encodeURIComponent(reqValue);
			}
		}*/
 		var favorite_id = "";
		var hiddenFields = appConstants.publicJSON['hiddens'];
		favorite_id = hiddenFields["favorite_id"];
		var target = '/final/servlet/com.eg.ErFavoriteC?'+qString+'&cmd=client&com.eg.CSRF_NONCE='+csrfToken;//&FavoriteId='+favorite_id;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id+'&showLegend='+Ext.getCmp('showLegend').getValue();
			target+='&showWindow=no'+'&FavoriteId='+favorite_id+'&showLegend='+Ext.getCmp('showLegend').getValue();
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			targetsource=target+'&showLegend='+Ext.getCmp('showLegend').getValue();
			parent.favouriteWindowFn(targetsource);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		}
	},
	showSchedules: function(obj)
	{
		var qString = this.updateQueryString();
		var hiddenFields = appConstants.publicJSON['hiddens']; 		
		/*var split = qString.split('&');
		for ( var i = 0; i < split.length; i++ )
		{
			var reqParam = split[i].substring(0, split[i].indexOf('=') );
			var reqValue = split[i].substring( split[i].indexOf('=') + 1 );
			if ( qString.indexOf( reqParam ) == 0 )
			{
				qString += '&'+reqParam+'='+encodeURIComponent(reqValue);
			}
		}*/
		var target = '/final/reporter/ErSaveSchedule.jsp?'+qString+'&cmd=client'+'&showLegend='+Ext.getCmp('showLegend').getValue()+'&com.eg.CSRF_NONCE='+csrfToken;
		target+='&CSVFileAsExcel=yes';
			
 		//Ext.widget('scheduleWindow').show();
		//Ext.select('#schWin').set({src :target});
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail: function()
	{
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			 appConstants.drillDownParams = "&showLegend="+islegendEnabled;
		}
		Ext.widget('sendmail').show();

		
	},
	saveExcel:function(){
		window.location="../servlet/com.eg.ErXlsController?er_csvrequest=yes";
	},
	showReportData: function()
	{
		
	parent.maximizeDataWindowLightBox(appConstants.publicJSON['DATA_URL'],'REPORTER DATA');//this method is defined in ErReporterMenuDashBoard.jsp for loading drilldown app
	},
	printReport: function()
	{
		var s_querString = appConstants.publicJSON['PRINT_URL']+'&showLegend='+ Ext.getCmp('showLegend').getValue(); 		
		parent.printWindowFn( s_querString ); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveReport: function()
	{
		if ( !Ext.isEmpty( appConstants.publicJSON['PDF_URL'] ) )
		{
			if (Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils = Ext.widget("erutils");
			}
			var s_querString = appConstants.publicJSON['PDF_URL']+'&showLegend='+ Ext.getCmp('showLegend').getValue(); 	
			appConstants.erUtils.savePDF(s_querString);
		}
	},
	bookletQuery: function(obj)
	{
		if ( !Ext.isEmpty( appConstants.publicJSON['PDF_URL'] ) )
		{
			var s_querString = appConstants.publicJSON['PDF_URL']+'&showLegend='+ Ext.getCmp('showLegend').getValue(); 	
			s_querString=s_querString.replace('../reporter/ErHtmlToSavePdf.jsp?','');
		}
		return s_querString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var qString = this.updateQueryString();
		if(qString != null)
			bookletquery+=qString;
		bookletquery+='&cmd=client'+'&showLegend='+Ext.getCmp('showLegend').getValue()+'&CSVFileAsExcel=yes';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	changeReportGeneration: function( combo )
	{
		if ( combo.getValue() == 'background' )
		{
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showData: function( URL )
	{
		if ( !Ext.isEmpty( URL ) )
		{
			Ext.widget('comparisondata').show();
			var dataContentDiv = Ext.select('#dataContentDiv');
			dataContentDiv.set(
			{
				src :  URL
			});
		}
		else
		{
			//alert('I am not calling...');
		}
	},
	 filterMultiselect: function (obj) {
        var compId = obj.getId();
   		var compName,compStore;
		if(compId =='compSearch')
		 {
			compStore=appConstants.rawDataForComponents;
			compName='component';
		 }
		else if(compId =='descSearch')
		 {
			compStore=appConstants.rawDataForDescriptor;
			compName='Descriptor';
		 }
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
  		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
    },
	selectComponents: function( thisObj, newValue, oldValue, eOpts )
	{
		if ( newValue == '-1' || newValue == '' )
		{
			return;
		}
		else
		{
			var cmpName = Ext.getCmp('component').getValue();
			if((Ext.Array.contains(cmpName,'All')|| Ext.Array.contains(cmpName,'all')) && cmpName.length>1)
			{
				Ext.MessageBox.show({
					title: alert_text,
					msg:  all_individual_alert,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			var funcName = 'getInfos1';
			if ( thisObj.getValue().length > 1 )
			{
				funcName = 'getMultiInfos';
			}
			var reportForVal = Ext.getCmp('Report').getValue();
			var getCriteria = Ext.getCmp('criteria').getValue();
			var selectedServices = 'NULL';
			if ( reportForVal == 'Zone' )
			{
				selectedServices = Ext.getCmp('zone').getValue();
			}
			else if ( reportForVal == 'Segment' )
			{
				selectedServices = Ext.getCmp('segment').getValue();
			}
			else if ( reportForVal == 'Service' )
			{
				selectedServices = Ext.getCmp('service').getValue();
			}
			var no_params = '';
			var getTestVal = Ext.getCmp('test').getValue();
			var getUserId = appConstants.publicJSON.hiddens['us_id'];
			Ext.getCmp('descSearch_TxtField').hide();
			var metricVal = Ext.getCmp('metric').getValue();
			if ( getCriteria == 'Test' )
			{
				no_params = '&P0=['+selectedServices+']&P1=['+getTestVal+']&P2=['+cmpName+']&P3=['+getUserId+']';
			}
			else
			{
				no_params = '&P0=['+selectedServices+']&P1=['+appConstants.testVal+']&P2=['+cmpName+']&P3=['+getUserId+']';
			}
			var param = 'F='+funcName+'&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params: param,
				method: 'POST',
				scope: this,
				success: function( response )
				{
					myMask.hide();
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var descriptorObj = Ext.getCmp('Descriptor');
						var descriptorData = jsonData['combo'];
						var disableInfoCombo = jsonData['disableInfoCombo'];
						var infoTextFieldValue = jsonData['infoTextFieldValue'];
						Ext.getCmp('descSearchCont').show();
						if ( !Ext.isEmpty( descriptorData ) )
						{
							appConstants.rawDataForDescriptor = descriptorData;
							descriptorObj.suspendEvents(true);
							descriptorObj.getStore().loadRawData(descriptorData);
							var allDesc  = {displayField:appConstants.mappingDesc,valueField:''};
							descriptorObj.getStore().insert(0,allDesc);
							appConstants.rawDataForDescriptor.unshift(allDesc)
							descriptorObj.setValue(descriptorObj.getStore().getAt(0).get('valueField'));
							descriptorObj.setDisabled(false);
							descriptorObj.fireEvent('select');
							descriptorObj.resumeEvents();
						}
						else if(!Ext.isEmpty( disableInfoCombo ) && disableInfoCombo != undefined && disableInfoCombo=='yes'){
							//appConstants.rawDataForDescriptor = descriptorData;
							Ext.getCmp('descSearch_TxtField').show();
							Ext.getCmp('descSearch_TxtField').setValue(infoTextFieldValue);
							Ext.getCmp('descSearchCont').hide();
						}
						else
						{
							descriptorObj.suspendEvents(true);
							descriptorObj.setDisabled(true);
							this.insertNotApplicable(descriptorObj);
							descriptorObj.resumeEvents();
						}
					}
				}
			});
		}
	},
	showConfiguration: function()
	{
		var popup = Ext.getCmp('popup');
		popup.hide();
		if ( !Ext.isEmpty(Ext.get('linkId')) ) 
		{
		   Ext.get('linkId').show();
		}
		var buttonConObj= Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(false);
	},
	updateQueryString: function()
	{
		try
		{
			var mainform=this.getDefineconfiguration().getForm();
			var configForm = Ext.getCmp('popup').getForm();
			var genQString = '';
			var us_id = appConstants.publicJSON.hiddens['us_id'];
			var schedule_id = 'null';//Ext.getCmp('schedule_id').getValue();
			var er_trgttype = configForm.findField('criteria').getValue();
			var er_mode = mainform.findField('er_mode').getValue();
			var er_info_list = configForm.findField('Descriptor').getValue();
			var endhr = mainform.findField('er_endhr').dataArray;
			var starthr = mainform.findField('er_sthr').dataArray; 
			var limitforbg = appConstants.publicJSON.hiddens['limitforbg'];
			var inidate = appConstants.publicJSON.hiddens['inidate'];
			var getCriteria = configForm.findField('criteria').getValue()
			var template = ( getCriteria == 'Metrics' )?true:false;
			var er_templateEnable = '';
			if ( template )
			{
				er_templateEnable = 'Yes';
			}
			else
			{
				er_templateEnable = 'No';
			}
			var bgenabled = appConstants.publicJSON.hiddens['bgenabled'];
			var er_test = configForm.findField('test').getValue();
			var reportForVal = configForm.findField('Report').getValue();
			var subZoneVal = configForm.findField('subzone').getValue();
			
			var includesubzone = 'null';
			if ( reportForVal == 'Zone' )
			{
				includesubzone = subZoneVal;
			}
			var servletName = appConstants.publicJSON.hiddens['servletName'];
			var startdate = mainform.findField('er_stdate').dataArray;
			var er_timeline = mainform.findField('er_timeline').getValue();
			var enddate = mainform.findField('er_enddate').dataArray;
			var er_usertimeline = appConstants.publicJSON.hiddens['er_usertimeline'];
			var getMaxDaysInMonth = appConstants.publicJSON.hiddens['getMaxDaysInMonth'];
			var reporttype = 'null';//Ext.getCmp('reporttype').getValue();
			var er_mode = mainform.findField('er_mode').getValue();
			var savereport = appConstants.publicJSON.hiddens['savereport'];
			var currTime = appConstants.publicJSON.hiddens['currTime']; 
			var detailtime = appConstants.publicJSON.hiddens['detailtime'];
			var forwardto = appConstants.publicJSON.hiddens['forwardto'];
			var er_dataFrom = configForm.findField('Report').getValue();

			var jsonData = appConstants.publicJSON;
			var settingsForm;
			var er_commonMax = jsonData['commonMaxComboSelected'];
			var er_commonMaxRange = '0';
			var er_graphtype = jsonData['showGraphTypeSelected'];
			var er_reportgenration = jsonData['reportGenerationSelected'];
			var bgReportName = '';
			var er_trenddata = (jsonData['showDataSelected'] == 'Trend')?'Yes':'No';
			var trendenable = ( jsonData['showDataSelected'] == 'Trend')?true:false;

			var er_AutoCommonMax = jsonData['autoMaxComboSelected'];
			var durationVal=jsonData['durationcomboSelected'];
			var trendGtypeVal=jsonData['trendGraphtypecomboSelected'];
			if (isSettingsEnabled)
			{
				settingsForm = Ext.getCmp('configsettings').getForm();
				er_commonMax = settingsForm.findField('CommonMaximum').getValue();
				er_commonMaxRange = settingsForm.findField('maxValue').getValue();
				er_graphtype = settingsForm.findField('graphtype').getValue();
				er_reportgenration = settingsForm.findField('reportGeneration').getValue();
				bgReportName = settingsForm.findField('bgReportName').getValue();
				er_trenddata = (settingsForm.findField('showdata').getValue() == 'Trend')?'Yes':'No';
				trendenable = ( settingsForm.findField('showdata').getValue() == 'Trend')?true:false;
				er_AutoCommonMax= settingsForm.findField('autoMaximum').getValue();
				if(er_trenddata != undefined && er_trenddata == 'Yes' ){
					durationVal=settingsForm.findField('duration').getValue();
					trendGtypeVal=settingsForm.findField('gtype').getValue();
				}
			}

			if(Ext.isEmpty(appConstants.erUtils))
			{
				appConstants.erUtils =Ext.widget("erutils");
			}
			
			var fromSchedule = 'null';//Ext.getCmp('fromSchedule').getValue();
			var fromScheduleModify = appConstants.publicJSON.hiddens['fromScheduleModify'];
			var fromFavouriteModify = appConstants.publicJSON.hiddens['fromFavoriteModify'];
			if ((fromScheduleModify != null && fromScheduleModify == "Yes"))
				schedule_id = appConstants.publicJSON.hiddens['schedule_id'];

			var modify = 'null';//Ext.getCmp('modify').getValue();
			var er_optionselect = er_dataFrom;
			var er_component = configForm.findField('component').getValue();
			var er_ViewName  = appConstants.publicJSON.hiddens['er_ViewName'];
			var measureVal = configForm.findField('measure').getValue();
			var toScrpText = '';
			var er_combination = '';
			var er_selectionVal = '';
			var selectedObj = Ext.getCmp('configdatas').getSelectionModel();
			var gridStore = Ext.getCmp('configdatas').getStore();
			for ( var i = 0; i < gridStore.getCount(); i++ )
			{
				if ( selectedObj.isSelected(gridStore.getAt(i)) )
				{
					var getHiddenVal = gridStore.getAt(i).get('Hiddens');
					getHiddenVal = appConstants.erUtils.specialCharEncode(getHiddenVal);
					toScrpText += getHiddenVal+'0eghash0';
					er_combination += getHiddenVal+'0eghash0eghash0';
					er_selectionVal += '&er_selection='+getHiddenVal;
				}
			}
			genQString ='uid='+encodeURIComponent(us_id);
			if ( er_reportgenration == 'background' )
			{
				forwardto = 'ErCompareTestJSON';
				bgReportName=checkFileName(bgReportName);
				genQString += '&bg_reportname='+encodeURIComponent(bgReportName);
			}
			genQString += '&fromScheduleModify='+fromScheduleModify+'&schedule_id='+encodeURI(schedule_id)+'&er_trgttype=Tests&er_info_list='+appConstants.erUtils.specialCharEncode(er_info_list)+'&endhr='+encodeURI(endhr)+'&starthr='+encodeURI(starthr)+'&er_commonMaxRange='+encodeURI(er_commonMaxRange)+'&limitforbg='+encodeURI(limitforbg)+'&er_flag=true&er_trenddata='+encodeURI(er_trenddata)+'&inidate='+encodeURI(inidate)+'&template='+encodeURI(template)+'&bgenabled='+encodeURI(bgenabled)+'&er_gtype=Comparison&er_test='+encodeURI(appConstants.testVal)+'&includesubzone='+encodeURI(includesubzone)+'&us_id='+encodeURIComponent(us_id)+'&servletName='+encodeURI(servletName)+'&map_measure='+encodeURI(appConstants.mapMeasureVal)+'&map_test='+encodeURI(appConstants.mapTestVal)+'&startdate='+encodeURI(startdate)+'&er_timeline='+encodeURI(er_timeline)+'&er_templateEnable='+encodeURI(er_templateEnable)+'&enddate='+encodeURI(enddate)+'&er_usertimeline='+encodeURI(er_usertimeline)+'&toScrpt=&getMaxDaysInMonth='+encodeURI(getMaxDaysInMonth)+'&er_rtype=Comparison&reporttype='+encodeURI(reporttype)+'&er_graphtype='+encodeURI(er_graphtype)+'&er_reportgenration='+encodeURI(er_reportgenration)+'&savereport='+encodeURI(savereport)+'&currTime='+encodeURI(currTime)+'&endmin='+encodeURI(mgr_enmin)+'&startmin='+encodeURI(mgr_stmin)+'&er_measure='+encodeURI(measureVal)+'&detailtime='+encodeURI(detailtime)+'&forwardto='+encodeURI(forwardto)+'&er_commonMax='+encodeURI(er_commonMax)+'&er_AutoCommonMax='+encodeURI(er_AutoCommonMax)+'&er_dataFrom='+encodeURI(er_dataFrom)+'&fromSchedule='+encodeURI(fromSchedule)+'&toScrpText=&modify='+encodeURI(modify)+'&er_optionselect='+encodeURI(er_optionselect)+'&er_component='+encodeURI(er_component)+'&trendenable='+encodeURI(trendenable)+'&userID='+encodeURI(us_id)+'&er_bgreportfrom=Comparison_Test&er_ViewName='+encodeURI(er_ViewName)+'&er_search=&er_combination='+er_combination+'&toScrpText='+toScrpText+er_selectionVal+'&er_mode='+encodeURI(er_mode)+'&fromFavoriteModify='+fromFavouriteModify+'&showLegend='+Ext.getCmp('showLegend').getValue();
			//
			var s_service = '';
				if ( reportForVal != 'Component' )
				{
					s_service = configForm.findField(reportForVal.toLowerCase()).getValue();
					genQString+='&er_service='+encodeURIComponent(s_service);

				}
				if(er_trenddata != undefined && er_trenddata == 'Yes' ){
					genQString += '&er_duration='+encodeURIComponent(durationVal)+'&er_trendGraphType='+encodeURIComponent(trendGtypeVal);
				}

			//
			return genQString;
		}
		catch ( e )
		{
			alert('[Exception] @ updateQueryString '+e);
		}
	},
	formSubmit:function(obj)
	{
		var showLegend = false;
		var gridStore = Ext.getCmp('configdatas').getStore();
		var mainform=this.getDefineconfiguration().getForm();
		var result = true;
		var fromFav = false;
		var resultMsg = '';
		if ( gridStore.getCount() == 0 )
		{
			result = false;
			resultMsg = appConstants.chooseCombination;
		}
		else
		{
			var selectedObj = Ext.getCmp('configdatas').getSelectionModel();
			result = false;
			for ( var i = 0;i < Ext.getCmp('configdatas').getStore().getCount(); i++ )
			{
				if ( selectedObj.isSelected(gridStore.getAt(i)) )
				{
					result = true;
					break;
				}
			}
			resultMsg = appConstants.chooseCombination;
		}
		if (!result)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.chooseCombination,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var me = this;
		var configForm = Ext.getCmp('popup').getForm();
		var jsonData = appConstants.publicJSON;
		var settingsForm;
		var er_commonMax = jsonData['commonMaxComboSelected'];
		var er_commonMaxRange = '0';
		var er_graphtype = jsonData['showGraphTypeSelected'];
		var er_reportgenration = jsonData['reportGenerationSelected'];
		var bgReportName = '';
		var er_trenddata = (jsonData['showDataSelected'] == 'Trend')?'Yes':'No';
		var trendenable = ( jsonData['showDataSelected'] == 'Trend')?true:false;
		var er_AutoCommonMax = jsonData['autoMaxComboSelected'];
		var durationVal=jsonData['durationcomboSelected'];
		var trendGtypeVal=jsonData['trendGraphtypecomboSelected'];

		if (isSettingsEnabled)
		{
			settingsForm = Ext.getCmp('configsettings').getForm();
			er_commonMax = settingsForm.findField('CommonMaximum').getValue();
			er_commonMaxRange = settingsForm.findField('maxValue').getValue();
			er_graphtype = settingsForm.findField('graphtype').getValue();
			er_reportgenration = settingsForm.findField('reportGeneration').getValue();
			bgReportName = settingsForm.findField('bgReportName').getValue();
			er_trenddata = (settingsForm.findField('showdata').getValue() == 'Trend')?'Yes':'No';
			trendenable = ( settingsForm.findField('showdata').getValue() == 'Trend')?true:false;
			if(er_trenddata != undefined && er_trenddata == 'Yes' ){
				durationVal=settingsForm.findField('duration').getValue();
				trendGtypeVal=settingsForm.findField('gtype').getValue();
			}
			er_AutoCommonMax= settingsForm.findField('autoMaximum').getValue();
			showLegend = Ext.getCmp('showLegend').getValue();
		}
		showLegend = Ext.getCmp('showLegend').getValue();
		var genQString = '';
		var us_id = appConstants.publicJSON.hiddens['us_id'];
		var schedule_id = 'null';//Ext.getCmp('schedule_id').getValue();
		var er_trgttype = configForm.findField('criteria').getValue();
		var er_mode = mainform.findField('er_mode').getValue();
		var er_info_list = configForm.findField('Descriptor').getValue();
		var endhr = mainform.findField('er_endhr').dataArray;
		var starthr = mainform.findField('er_sthr').dataArray;
		//var er_commonMaxRange = settingsForm.findField('maxValue').getValue();
		//var er_AutoCommonMax= settingsForm.findField('autoMaximum').getValue();
		var limitforbg = appConstants.publicJSON.hiddens['limitforbg'];
		//var er_trenddata = (settingsForm.findField('showdata').getValue() == 'Trend')?'Yes':'No';
		var inidate = appConstants.publicJSON.hiddens['inidate'];
		var getCriteria = configForm.findField('criteria').getValue()
		var template = ( getCriteria == 'Metrics' )?true:false;
		var er_templateEnable = '';
		if (template)
		{
			er_templateEnable = 'Yes';
		}
		else
		{
			er_templateEnable = 'No';
		}
		var bgenabled = appConstants.publicJSON.hiddens['bgenabled'];
		var er_test = configForm.findField('test').getValue();
		var reportForVal = configForm.findField('Report').getValue();
		var subZoneVal = configForm.findField('subzone').getValue();
		
		var fromScheduleModify = appConstants.publicJSON.hiddens['fromScheduleModify'];
		if (fromScheduleModify != null && fromScheduleModify == "Yes")
			schedule_id = appConstants.publicJSON.hiddens['schedule_id'];

		var s_service = '';
		if ( reportForVal != 'Component' )
		{
			s_service = configForm.findField(reportForVal.toLowerCase()).getValue();
		}
		var includesubzone = 'null';
		if ( reportForVal == 'Zone' )
		{
			includesubzone = subZoneVal;
		}
		var servletName = appConstants.publicJSON.hiddens['servletName'];
		var startdate = mainform.findField('er_stdate').dataArray;
		var er_timeline = mainform.findField('er_timeline').getValue();
		var enddate = mainform.findField('er_enddate').dataArray;
		var er_usertimeline = '-1';
		var  getMaxDaysInMonth = appConstants.publicJSON.hiddens['getMaxDaysInMonth'];
		var reporttype = 'null';
		if ( !Ext.isEmpty( Ext.getCmp('reporttype') ) )
		{
			reporttype = appConstants.publicJSON.hiddens['reporttype'];
		}
		//var er_graphtype = settingsForm.findField('graphtype').getValue();
		var er_mode = mainform.findField('er_mode').getValue();
		//var er_reportgenration = settingsForm.findField('reportGeneration').getValue();
		//var bgReportName = settingsForm.findField('bgReportName').getValue();
		var savereport = appConstants.publicJSON.hiddens['savereport'];
		var currTime = appConstants.publicJSON.hiddens['currTime']; 
		var detailtime = appConstants.publicJSON.hiddens['detailtime'];
		var forwardto = appConstants.publicJSON.hiddens['forwardto'];
		//var er_commonMax = settingsForm.findField('CommonMaximum').getValue();
		var er_dataFrom = configForm.findField('Report').getValue();
		
		var measureVal = configForm.findField('measure').getValue();
		var fromSchedule = 'null';
		var er_template = Ext.getCmp('metric').getValue();
		if ( !Ext.isEmpty( Ext.getCmp('fromSchedule') ) )
		{
			fromSchedule = appConstants.publicJSON.hiddens['fromSchedule'];
		}
		var modify = 'null';
		if ( !Ext.isEmpty( Ext.getCmp('modify') ) )
		{
			modify = appConstants.publicJSON.hiddens['modify'];
		}
		var er_optionselect = er_dataFrom;
		var er_component = configForm.findField('component').getValue();
		//var trendenable = ( settingsForm.findField('showdata').getValue() == 'Trend')?true:false;
		var er_ViewName = appConstants.publicJSON.hiddens['er_ViewName'];
		var toScrpText = '';
		var er_combination = '';
		var er_selectionVal = '';
		var selectedObj = Ext.getCmp('configdatas').getSelectionModel();
		var addCombination = '';
		var getServers = '';
		var getCompTypes = '';
		var getTests = '';
		var getMeasures = '';
		var getDesc = '';
		var getHiddens = ''
		for ( var i = 0; i < gridStore.getCount(); i++ )
		{
			if ( selectedObj.isSelected(gridStore.getAt(i)) )
			{
				var getHiddenVal = gridStore.getAt(i).get('Hiddens');
				var tempHiddens = encodeURIComponent(getHiddenVal);
				getHiddenVal = appConstants.erUtils.specialCharEncode(getHiddenVal);
				toScrpText += getHiddenVal+'0eghash0';
				er_combination += getHiddenVal+'0eghash0eghash0';
				if(er_reportgenration!=null && er_reportgenration == 'foreground')
				{
					er_selectionVal += '&er_selection='+tempHiddens;
				}
				else
				{
					er_selectionVal += '&er_selection='+getHiddenVal;
				}
			}
			getServers += '|amp|'+gridStore.getAt(i).get('Name');
			getCompTypes += '|amp|'+gridStore.getAt(i).get('Type');
			getTests += '|amp|'+appConstants.erUtils.specialCharEncode(gridStore.getAt(i).get('Test'));
			getMeasures += '|amp|'+appConstants.erUtils.specialCharEncode(gridStore.getAt(i).get('Measure'));
			getDesc += '|amp|'+appConstants.erUtils.specialCharEncode(gridStore.getAt(i).get('Descriptor'));
			getHiddens += '|amp|'+appConstants.erUtils.specialCharEncode(gridStore.getAt(i).get('Hiddens'));
			
			/*var getCompName = gridStore.getAt(k).get('Name');
			var getCompType = gridStore.getAt(k).get('Type');
			var getTestName = gridStore.getAt(k).get('Test');
			var getMeasureName = gridStore.getAt(k).get('Measure');
			var getDescName = gridStore.getAt(k).get('Descriptor');*/
		}
		var URL = '';
		
		if ( er_reportgenration == 'foreground' )
		{
			URL = '/final/servlet/com.eg.ErRepoLiteC';
		}
		else
		{
			forwardto = 'ErCompareTestJSON';
			URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
		    bgReportName=checkFileName(bgReportName);
			genQString += '&bg_reportname='+encodeURIComponent(bgReportName);
		}
		genQString += '&uid='+encodeURIComponent(us_id)+'&fromScheduleModify='+fromScheduleModify+'&schedule_id='+encodeURI(schedule_id)+'&er_trgttype=Tests&er_info_list='+appConstants.erUtils.specialCharEncode(er_info_list)+'&endhr='+encodeURI(endhr)+'&starthr='+encodeURI(starthr)+'&er_commonMaxRange='+encodeURI(er_commonMaxRange)+'&er_AutoCommonMax='+encodeURI(er_AutoCommonMax)+'&limitforbg='+encodeURI(limitforbg)+'&er_flag=true&er_trenddata='+encodeURI(er_trenddata)+'&inidate='+encodeURI(inidate)+'&template='+encodeURI(template)+'&bgenabled='+encodeURI(bgenabled)+'&er_gtype=Comparison&includesubzone='+encodeURI(includesubzone)+'&us_id='+encodeURIComponent(us_id)+'&servletName='+encodeURI(servletName)+'&map_measure='+encodeURI(appConstants.mapMeasureVal)+'&map_test='+encodeURI(appConstants.mapTestVal)+'&startdate='+encodeURI(startdate)+'&er_timeline='+encodeURI(er_timeline)+'&er_templateEnable='+encodeURI(er_templateEnable)+'&isSubmit=true&enddate='+encodeURI(enddate)+'&er_usertimeline='+encodeURI(er_usertimeline)+'&toScrpt=&getMaxDaysInMonth='+encodeURI(getMaxDaysInMonth)+'&er_rtype=Comparison&reporttype='+encodeURI(reporttype)+'&er_graphtype='+encodeURI(er_graphtype)+'&er_reportgenration='+encodeURI(er_reportgenration)+'&savereport='+encodeURI(savereport)+'&currTime='+encodeURI(currTime)+'&endmin='+encodeURI(mgr_enmin)+'&startmin='+encodeURI(mgr_stmin)+'&er_measure='+encodeURI(measureVal)+'&detailtime='+encodeURI(detailtime)+'&forwardto='+encodeURI(forwardto)+'&er_commonMax='+encodeURI(er_commonMax)+'&er_dataFrom='+encodeURI(er_dataFrom)+'&fromSchedule='+encodeURI(fromSchedule)+'&toScrpText=&modify='+encodeURI(modify)+'&er_optionselect='+encodeURI(er_optionselect)+'&er_component='+encodeURI(er_component)+'&trendenable='+encodeURI(trendenable)+'&userID='+encodeURI(us_id)+'&er_bgreportfrom=Comparison_Test&er_ViewName='+encodeURI(er_ViewName)+'&er_search=&er_combination='+encodeURI(er_combination)+'&toScrpText='+encodeURI(toScrpText)+er_selectionVal+'&er_mode='+encodeURI(er_mode)+'&er_service='+encodeURIComponent(s_service)+'&er_test='+encodeURIComponent(er_test)+'&er_template='+encodeURI(er_template);
		genQString += '&servers='+encodeURIComponent(getServers)+'&comptypes='+encodeURIComponent(getCompTypes)
					 +'&tests='+encodeURIComponent(getTests)+'&measures='+encodeURIComponent(getMeasures)
					 +'&infos='+appConstants.erUtils.specialCharEncode(getDesc)+'&hiddens='+appConstants.erUtils.specialCharEncode(getHiddens)+'&showLegend='+showLegend;
		if(er_trenddata != undefined && er_trenddata == 'Yes' ){
			genQString += '&er_duration='+encodeURIComponent(durationVal)+'&er_trendGraphType='+encodeURIComponent(trendGtypeVal);
		}
		if((obj!=undefined && (obj.getId() == 'favoriteTool' || obj.getId() == 'favImg'  ||  obj.getId() == 'scheduleTool' || obj.getId() == 'scheduleImg')) || (fromScheduleModify != null && fromScheduleModify == "Yes"))
		{
			fromFav = true;
		}
		if (fromFav)
		{
			queryString = genQString;
			return;
		}
 		genQString+= '&er_RmDispName='+appConstants.er_RmDispName;
 		Ext.Ajax.request({
			url: URL,
			params: genQString+'&call=json',
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					myMask.hide();
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					//var showReportObj = me.getShowcomparisonreport();
					
					if (er_reportgenration == 'foreground' )
					{
						me.loadCharts(jsonData,er_graphtype); 
					}
					else if (er_reportgenration == 'background' && !Ext.isEmpty(jsonData['backgroundrResponseText']) )
					{
						var showReportObj =Ext.getCmp('resultPanel');
						var backgroundrResponseText = jsonData['backgroundrResponseText'];
						var backgroundStatus = jsonData['backgroundStatus'];
						var backgroundLinkText = jsonData['backgroundLinkText'];
						var backgroundURL = jsonData['backgroundURL'];
						showReportObj.hide();
						var genHtml = '';
						if (backgroundStatus == 'duplicate')
						{
							genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundrResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundURL +'>'+ backgroundLinkText + '</a></div></td></tr></table></td></tr></table>';
							
							//genHtml = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+backgroundrResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundURL+'">'+backgroundLinkText+'</a></div></div></center>'
						}
						else
						{
							genHtml = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundrResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundURL +'>'+ backgroundLinkText + '</a></div></td></tr></table></td></tr></table>';

							//	genHtml = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+backgroundrResponseText+'</b><br /><a class="backgroundMsgLink" href="'+backgroundURL+'">'+backgroundLinkText+'</a></div></div></center>'
						}
						me.getBackGroundPanel().show();
						me.getBackGroundPanel().update(genHtml);
					}
					else
					{
						var showReportObj =Ext.getCmp('resultPanel');
						me.getBackGroundPanel().hide();
						showReportObj.show();
						showReportObj.removeAll();
						showReportObj.add({
							xtype: 'container',
							columnWidth: '1',
							style: 'text-align:center',
							border: false,
							html: '<div style="margin:10% auto 0 auto"></div><div><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>'
						});
						showReportObj.doLayout();
					}
				}
			}
		});
	},
	loadCharts:function(jsonData,er_graphtype)
	{
		var showReportObj =Ext.getCmp('resultPanel');
		var resultsData = jsonData['results'];
		if ( !Ext.isEmpty( resultsData ) )
		{
			var timeFormatData = jsonData['timeFormat'];
			var chartType = jsonData['chartType'];
			var highChartUrls = new Array();
			var highChartIds = new Array();
			var highChartdrilldwonUrls = new Array();
			showReportObj.show();
			showReportObj.removeAll();
			Ext.getCmp('backGroundPanel').hide();
			var noItems = new Array();
			if (er_graphtype == 'Multiple')
			{
				Ext.get('timeformate').update('<span class="xAxisLabelFontForReporter ">'+timeFormatData+'</span>'); // adding to tools
//				if (!Ext.isEmpty(Ext.get('timeformat')))
//				{
//					Ext.get('timeformat').update('<b style="font-style:12px;">'+timeFormatData+'</b>');
//				}
				/*showReportObj.add(
				{
					xtype:'container',
					columnWidth:'1',
					style:{'text-align':'left'},
					html: '<b>'+timeFormatData+'</b>'
				});
				showReportObj.doLayout();*/
			}
			var disableTools = new Array();
			Ext.getCmp('bookletTool').setDisabled(false);
			Ext.getCmp('saveTool').setDisabled(false);
			Ext.getCmp('printTool').setDisabled(false);
			Ext.getCmp('mailTool').setDisabled(false);
			Ext.getCmp('dataTool').setDisabled(true);
			Ext.getCmp('excelTool').setDisabled(false);
			var content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
			var col=0;
			for(var i = 0;i < resultsData.length; i++)
			{
				var evenLastTd=false;
				var title = resultsData[i]['TITLE'];
				var IMAGE_URL = resultsData[i]['IMAGE_URL'];
				var CSV_URL = resultsData[i]['CSV_URL'];
				var DATA_URL = resultsData[i]['DATA_URL'];
				var IMAGE_DRILL_DOWN_URL = resultsData[i]['IMAGE_DRILL_DOWN_URL'];
				//highChartdrilldwonUrls.push(IMAGE_DRILL_DOWN_URL);

				if (resultsData.length == 1)
				{
					Ext.getCmp('dataTool').setDisabled(false);
					//showReportObj.setTitle("");
				}
				else
				{
					//showReportObj.setTitle("<span class='font_bold'>"+'COMPARISON'+"</span>");
				}
				if (col==2)
				{
					col=0;
					content+='</tr>';
					content+='<tr>';
				}
				if(i == 0){
					if (resultsData.length>2)
					{
						content+='<td style="padding:0px 5px 5px 10px">';
					}
					else if(resultsData.length==2)
					{
						content+='<td style="padding:0px 5px 10px 10px">';
					}
					else
					{
						content+='<td style="padding:0px 10px 10px 10px">';
					}
				}
				else if(i == 1){
					if (resultsData.length>2)
					{
						content+='<td style="padding:0px 10px 5px 5px">';
					}
					else
					{
						content+='<td style="padding:0px 10px 10px 5px">';
					}
				}
				else if((i%2) == 0){
					if (i==resultsData.length-1)
					{
						evenLastTd=true;
						content+='<td style="padding:5px 5px 10px 10px">';
					}
					else if (i==resultsData.length-2)
					{
						content+='<td style="padding:5px 5px 10px 10px">';
					}
					else{
						content+='<td style="padding:5px 5px 5px 10px">';
					}
				}
				else if((i%2) != 0){
					if (i==resultsData.length-1)
					{
						content+='<td style="padding:5px 10px 10px 5px">';
					}
					else{
						content+='<td style="padding:5px 10px 5px 5px">';
					}
				}
				content+='<div width="100%" class="graphMainDiv">';

				if (resultsData.length>0)
				{
					if (er_graphtype == 'Multiple' ){
						content+='<div class="htmlGraphTableHeader"><div style="float:left;">'+title+'</div>';
						content+='<div style="float:right;margin:3px 0px 4px 5px;">';
						content+='<div style="float:right;cursor:pointer;margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+IMAGE_DRILL_DOWN_URL+'\');"></div>';
						content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconCsv" onclick="window.location=\''+CSV_URL+'\'"></div>';
						content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconData" onclick="javascript:loadDataWindow(\''+DATA_URL+'\');"></div>';
						content+='</div></div>';
						content+='<div class="headerBottomBorder" ></div>';
					}
				}

				var dom='img_'+i;
				highChartIds.push(dom);
				if ( resultsData.length == 1 )
					content+='<div id="'+dom+'" style="height:450px;width:100%;" class="htmlTableBody showDiv">';
				else
					content+='<div id="'+dom+'" style="height:270px;width:100%;" class="htmlTableBody showDiv">';
				if(chartType != "highchart")
				{
					content+='<table width="100%" height="100%"><tr><td valign="middle" align="center"><img src="'+IMAGE_URL+'"></img></td></tr></table>';
				}
				else
				{
					highChartUrls.push(IMAGE_URL+"&chartType="+chartType);
				}
				content+='</div>';
				content+='<div style="height:60px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
				content+='<div id="'+dom+'_legend" style="height:51px;width:100%;overflow:hidden;display:inline-block; vertical-align: middle;" class="showDiv">';
				content+='</div></div>';
				if (resultsData.length==1 && chartType != "highchart")
				{
					var singleSelectionDetailsData = resultsData[0]['singleSelectionDetails'];
					if ( !Ext.isEmpty(singleSelectionDetailsData ) )
					{
						content += '<div><table width="100%">';
						var legendHeight = ( singleSelectionDetailsData.length / 2 ) * 10;
						height += legendHeight;
						for ( var tmp = 0; tmp < singleSelectionDetailsData.length; tmp+=2 )
						{
							var imageColor1 = singleSelectionDetailsData[tmp]['IMAGE_COLOR'];
							var descriptors1 = singleSelectionDetailsData[tmp]['DESCRIPTORS'];
							var imageColor2 = '';
							var descriptors2 = '';
							if (!Ext.isEmpty(singleSelectionDetailsData[tmp]['IMAGE_COLOR']) && !Ext.isEmpty( singleSelectionDetailsData[tmp]['DESCRIPTORS'] ) )
							{
								imageColor2 = singleSelectionDetailsData[tmp]['IMAGE_COLOR'];
								descriptors2 = singleSelectionDetailsData[tmp]['DESCRIPTORS'];
							}
							content += '<tr><td width="50%"><img src="/final/servlet/com.eg.ErImageDrawC?req='+imageColor1+'" />&nbsp;'+descriptors1+'</td><td width="50%"><img src="/final/servlet/com.eg.ErImageDrawC?req='+imageColor2+'" />&nbsp;'+descriptors2+'</td></tr>';
						}
						content += '</table></div>';
					}
				}
				content+='</div></td>';
				if (evenLastTd)
				{
					content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
				}
				col++;
			}
			if (col==2)
			{
				content+='</tr>';
			}
			content+='</table></div>';
			showReportObj.add({
				columnWidth:1,
				cls:'newChk',
				html:content,
				listeners:{
					boxready:function(){
						var islegendEnabled = Ext.getCmp('showLegend').getValue();
						if(islegendEnabled == "false" || islegendEnabled ==false){
							var elms = document.getElementsByClassName("commonLeg");
							for(var i = 0; i < elms.length; i++) {
								var chkkk=elms[i].id;
								var tmp_div=document.getElementById(chkkk);
								if(tmp_div != null && tmp_div != undefined)
									tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
							}
						}
					}
				}
			});
//			showReportObj.update(content);
			if(chartType == "highchart"){
				for( var l in highChartIds){
					reportHighStockChart(highChartUrls[l],highChartIds[l],'','','');
				}
			}
			showReportObj.doLayout();
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
			this.enableOrDisableTools(disableTools);
			if ( !Ext.isEmpty( jsonData['PDF_URL'] ) )
			{
				appConstants.publicJSON['PDF_URL'] = jsonData['PDF_URL'];
			}
			if ( !Ext.isEmpty( jsonData['PRINT_URL'] ) )
			{
				appConstants.publicJSON['PRINT_URL'] = jsonData['PRINT_URL'];
			}
			if ( !Ext.isEmpty(jsonData['DATA_URL']))
			{
				appConstants.publicJSON['DATA_URL'] = jsonData['DATA_URL'];
			}
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = this.getDefineconfiguration();
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	renderPopUp:function(popupPanle)
	{
 		Ext.getCmp("component").on('focus',this.callMe);
		Ext.EventManager.onWindowResize(function()
		{
			popupPanle.doComponentLayout();
			popupPanle.setWidth(Ext.getBody().getViewSize().width-80);
		});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateSettings())
		{
			this.beforeFormSubmit();
		}
	},
	validateSettings: function()
	{
		var er_usertimeline =appConstants.publicJSON.hiddens['er_usertimeline'];

		var getMaxDaysInMonth =appConstants.publicJSON.hiddens['getMaxDaysInMonth'];

		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		if(tmpStartDate!='null')
			tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		var CommonMaximumVal = Ext.getCmp('CommonMaximum').getValue();
		var autoMaximumVal = Ext.getCmp('autoMaximum').getValue();
		var maxValue = Ext.getCmp('maxValue').getValue();
		if(isNaN(maxValue))
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.wrongInput,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			Ext.getCmp('maxValue').focus();
			return false;
		}
		if (CommonMaximumVal =='Yes' && autoMaximumVal == 'No' && ( Ext.isEmpty( maxValue ) || !( maxValue >= 0 || maxValue <= 0 ) ) )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.wrongInput,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			Ext.getCmp('maxValue').focus();
			return false;
		}
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg =appConstants.publicJSON.hiddens['limitforbg'];

		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		var isSettingsOk = true;
		if ( reportgenVal == 'background' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				return false;
			}
			else
			{
				return true;
			}
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return isSettingsOk;
	},
	showResult : function(btn)
	{
		if ( btn == 'yes' )
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(Ext.get('configMod') != null){Ext.get('configMod').animate({duration: 500,to: {y: -500}});}
			var hiddenFields = appConstants.publicJSON['hiddens'];
			var from_schedule = hiddenFields["fromScheduleModify"];
			var from_fav = hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes")) {
				var submitObj = Ext.getCmp('submit');
				var submitText = submitObj.getText();
				if ((submitText != null && submitText == "Save")) {
					this.showSchedules(new Object());
				}
			}else if((from_fav != null && from_fav == "Yes")){
				this.showFavorite(new Object());
			}
			else
			{
				var reportgenVal = appConstants.publicJSON['reportGenerationSelected'];
				if (isSettingsEnabled)
				{
					reportgenVal = Ext.getCmp('reportGeneration').getValue();
				}
				if (reportgenVal == 'background')
				{
					if (!validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
					{
						Ext.getCmp('bgReportName').focus();
						return false;
					}
				}
				this.formSubmit();
			}
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').setValue('')
			validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true);
			return false;
		}
	},
	insertNotApplicable2: function( fieldName )
	{
		var obj = Ext.getCmp(fieldName);
		var naArray=[];
		naArray.push({
			'displayField': appConstants.notApplicabletxt,
			'valueField': '-1'
		});
		obj.suspendEvents(true);
 		obj.getStore().loadRawData(naArray);
 		if(fieldName=='Descriptor')
		{
			appConstants.rawDataForDescriptor=naArray;
		}
		else if(fieldName=='component')
		{
			appConstants.rawDataForComponents=naArray;
		}
		obj.setValue('-1');
		obj.resumeEvents();
	},
	loadDefaults:function()
	{
		Ext.getCmp('er_mode').hide();
		Ext.widget('defineconfigurationpopup').hide();		 
		var me = this;
		var jsonData = appConstants.publicJSON;
		var hiddens = jsonData['hiddens'];
        var from_schedule = hiddens["fromScheduleModify"];
		var from_favourite = hiddens["fromFavoriteModify"];
        if ((from_schedule != null && from_schedule == "Yes") || (from_favourite != null && from_favourite == "Yes")){
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var disableTools = new Array();
		disableTools['bookletTool'] = 'true';
		disableTools['saveTool'] = 'true';
		disableTools['printTool'] = 'true';
		disableTools['mailTool'] = 'true';
		disableTools['dataTool'] = 'true';
		disableTools['closeTool'] = 'true';
		disableTools['excelTool'] = 'true';
		this.enableOrDisableTools(disableTools);
		var configForm = Ext.getCmp('popup').getForm();
		//var settingsForm = Ext.getCmp('configsettings').getForm();
		var mainform=this.getDefineconfiguration().getForm();
		/*********************To load Default Settings*************************/
		
		var jsonData = appConstants.publicJSON;
		var selectedData = jsonData['selectedValues'];
		if ( !Ext.isEmpty( jsonData ) )
		{
//			publicJSON = jsonData;
			me.loadScreenLabels(jsonData['screenLabels']);
			//me.loadHiddens(jsonData['hiddens']);
			var reportObj = configForm.findField('Report');
			var reportForComboData = jsonData['reportForCombo'];
			if ( !Ext.isEmpty( reportForComboData ) )
			{
				var reportForComboSelected = jsonData['reportForComboSelected'];
				this.setValueWithOptionInList( configForm, 'Report', reportForComboData, reportForComboSelected);
				if ( reportForComboSelected != 'Component' )
				{
					var subSystemCombo = jsonData[reportForComboSelected];
					var er_serviceSelected = '';
					if ( !Ext.isEmpty( jsonData['er_serviceSelected'] ) )
					{
						er_serviceSelected = jsonData['er_serviceSelected'];
					}
					this.setValueWithOptionInList(configForm, reportForComboSelected.toLowerCase(), subSystemCombo, er_serviceSelected);
					this.selectReportFor();
				}
			}
			var criteriaCombo = jsonData['criteriaCombo'];
			if ( !Ext.isEmpty( criteriaCombo ) )
			{
				var criteriaComboSelected = '';
				if ( !Ext.isEmpty( jsonData['criteriaComboSelected'] ) )
				{
					criteriaComboSelected = jsonData['criteriaComboSelected'];
				}
				this.setValueWithOptionInList( configForm, 'criteria', criteriaCombo, criteriaComboSelected );
				
				Ext.getCmp('configdatas').getStore().removeAll();
				var configForm = Ext.getCmp('popup').getForm();
				var criteriaObj = configForm.findField('criteria');
				var descObj = configForm.findField('Descriptor');
				var loadTestMetric = false;
				if ( !Ext.isEmpty( criteriaObj ) )
				{
					var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
					var no_params = '';
					var reportForVal = configForm.findField('Report').getValue();
					if ( reportForVal == 'Component' )
					{
						no_params = '&P0=[Component]&P1=[Component]&P2=[no]';
						loadTestMetric = true;
					}
					else if ( reportForVal == 'Zone')
					{
						var zoneVal = configForm.findField('zone').getValue();
						var subZoneVal = configForm.findField('subzone').getValue();
						if ( zoneVal == '-1' )
						{
							loadTestMetric = false;
						}
						else
						{
							loadTestMetric = true;
						}
						no_params = '&P0=['+reportForVal+']&P1=['+zoneVal+']&P2=['+subZoneVal+']';
					}
					else if ( reportForVal == 'Segment' )
					{
						var segmentVal = configForm.findField('segment').getValue();
						no_params = '&P0=['+reportForVal+']&P1=['+segmentVal+']&P2=[no]';
						if ( segmentVal == '-1' )
						{
							loadTestMetric = false;
						}
						else
						{
							loadTestMetric = true;
						}
					}
					else if ( reportForVal == 'Service' )
					{
						var serviceVal = configForm.findField('service').getValue();
						no_params = '&P0=['+reportForVal+']&P1=['+serviceVal+']&P2=[no]';
						if ( serviceVal == '-1' )
						{
							loadTestMetric = false;
						}
						else
						{
							loadTestMetric = true;
						}
					}
					if ( loadTestMetric )
					{
						if ( criteriaObj.getValue() == 'Test' )
						{
							var testObj = configForm.findField('test');
							var measureObj = configForm.findField('measure');
							if ( !Ext.isEmpty( appConstants.publicJSON.screenLabels['reporter.comparison.Test'] ) )
							{
								testObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Test']);
							}
							if ( !Ext.isEmpty( appConstants.publicJSON.screenLabels['reporter.comparison.Measure'] ) )
							{
								measureObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Measure']);
							}
							testObj.show();
							measureObj.show();
							var metricObj = configForm.findField('metric');
							metricObj.hide();
					        var param = 'F=getTestsForSite&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
							if(appConstants.rmComponentType != 'null')
							{
								param += '&er_compType='+appConstants.rmComponentType;
							}
					         Ext.Ajax.request({
					            url: remoteURL,
					            params:param,
					            scope:this,
					            success:function(response)
					            {
					                var jsonText = response.responseText;
					                var jsonData = Ext.decode(jsonText);
					                if ( !Ext.isEmpty( jsonData ) )
					                {
					                	var testComboData = jsonData['combo'];
					                	var testObj = configForm.findField('test');
					                	testObj.suspendEvents(true);
										testObj.getStore().clearFilter(true); 
										testObj.getStore().loadRawData(testComboData);
					                	var tmpStore = testObj.getStore();
					                	tmpStore.insert(0, {
					                		displayField: appConstants.mapping_test,
					                		valueField: '-1'
					                	});
					                	if ( !Ext.isEmpty( appConstants.publicJSON['testComboSelected'] ) )
					                	{
					                		testObj.setValue(appConstants.publicJSON['testComboSelected']);
					                	}
					                	else
					                	{
					                		testObj.setValue('-1');
					                	}
					                	testObj.resumeEvents();
					                }
					            }
					        });
					        var measureObj = configForm.findField('measure');
					        this.insertNotApplicable(measureObj);
						}
						else
						{
							var testObj = configForm.findField('test');
							var measureObj = configForm.findField('measure');
							var metricObj = configForm.findField('metric');
							if ( !Ext.isEmpty(appConstants.publicJSON.screenLabels['reporter.comparison.Metric']) )
							{
								metricObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Metric']);
							}
							var param = 'F=getTemplateForSite&C=jsrs1'+no_params+'&U=1360127833994872&fromajax=true';
							if(appConstants.rmComponentType != 'null')
							{
								param += '&er_compType='+appConstants.rmComponentType;
							}							
					         Ext.Ajax.request({
					            url: remoteURL,
					            params:param,
					            scope:this,
					            success:function(response){
					                
					                var jsonText = response.responseText;
					                var jsonData = Ext.decode(jsonText);
					                if ( !Ext.isEmpty( jsonData ) )
					                {
					                	var metricObj = configForm.findField('metric');
					                	metricObj.suspendEvents(true);
					                	var metricComboData = jsonData['combo'];
										metricObj.getStore().clearFilter(true); 
					                	metricObj.getStore().loadRawData(metricComboData);
					                	metricObj.getStore().insert(0,{
					                		displayField: appConstants.mapping_metric,
					                		valueField: '-1'
					                	});
					                	if ( !Ext.isEmpty( appConstants.publicJSON['metricComboSelected'] ) )
					                	{
					                		metricObj.setValue(appConstants.publicJSON['metricComboSelected']);
					                	}
					                	else
					                	{
					                		metricObj.setValue('-1');
					                	}
					                	
					                	metricObj.resumeEvents();
					                }
					            }
					        });
							metricObj.show();
							testObj.hide();
							measureObj.hide();
						}
					}
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					var metricObj = configForm.findField('metric');
					var compObj = configForm.findField('component');
					var descriptorObj = configForm.findField('Descriptor');
					this.insertNotApplicable(testObj);
					this.insertNotApplicable(measureObj);
					this.insertNotApplicable(metricObj);
					this.insertNotApplicable(compObj);
					this.insertNotApplicable(descriptorObj);
				}
			}
			var testComboData = jsonData['testCombo'];
			if ( !Ext.isEmpty( testComboData ) )
			{
				var testComboSelectedVal = jsonData['testComboSelected'];
				this.setValueWithOptionInList( configForm, 'test', testComboData, testComboSelectedVal );
			}
			else
			{
				this.insertNotApplicable2('test');
			}
			var metricComboData = jsonData['metricCombo'];
			if ( !Ext.isEmpty( metricComboData ) )
			{
				var metricObj = Ext.getCmp('metric');
				var metricComboSelectedVal = jsonData['metricComboSelected'];
				this.setValueWithOptionInList( configForm, 'metric', metricComboData, metricComboSelectedVal );
				configForm.findField('metric').setValue(metricComboSelectedVal);
			}
			else
			{
				this.insertNotApplicable2('metric');
			}
			var measureComboData = jsonData['measureCombo'];
			if ( !Ext.isEmpty( measureComboData ) )
			{
				var measureObj = Ext.getCmp('measure');
				measureObj.getStore().clearFilter(true); 
				measureObj.getStore().loadRawData(measureComboData);
				var measureComboSelected = jsonData['measureComboSelected'];
				this.setValueWithOptionInList( configForm, 'measure', measureComboData, measureComboSelected);
			}
			else
			{
				this.insertNotApplicable2('measure');
				Ext.getCmp('measure').setValue('-1');
			}
			
			if ( jsonData['criteriaComboSelected'] == 'Test' )
			{
				var selectedTest = jsonData['testComboSelected'];
				var param = 'F=getMeasuresForTest1&C=jsrs1&P0=['+selectedTest+']&U='+new Date().getTime()+'&fromajax=true';
				Ext.Ajax.request({
					url: remoteURL,
					params: param,
					async: false,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var measureData = jsonData['combo'];
								var measureObj = Ext.getCmp('measure');
								if ( !Ext.isEmpty( measureData ) )
								{
									measureObj.suspendEvents(true);
									measureObj.getStore().clearFilter(true); 
									measureObj.getStore().loadRawData(measureData);
									measureObj.getStore().insert(0,{
										displayField: appConstants.mapping_measure,
										valueField: '-1'
									});
									measureObj.setValue('-1');
									measureObj.resumeEvents();
								}
								else
								{
									me.insertNotApplicable(measureObj);
								}
							}
						}
					}
				});
				if ( !Ext.isEmpty( jsonData['measureComboSelected'] ) )
				{
					Ext.getCmp('measure').setValue(jsonData['measureComboSelected']);
				}
				else
				{
					Ext.getCmp('measure').setValue('-1');
				}
				var getUserId = appConstants.publicJSON.hiddens['us_id'];
				no_params = '&P0=['+encodeURIComponent(selectedTest)+']&P1=['+encodeURIComponent(appConstants.publicJSON['hiddens']['userID'])+']';
				var getTestVal = Ext.getCmp('test').getValue();
				var reportForVal = Ext.getCmp('Report').getValue();
				var methodName='';
				if ( reportForVal == 'Component' )
				{
					no_params = '&P0=['+getTestVal+']';
					methodName = 'getComponentsForTest1';
					no_params = '&P0=['+encodeURIComponent(getTestVal)+']&P1=['+encodeURIComponent(getUserId)+']';
				}
				else
				{
					methodName = 'getComponentsForTest';
					if ( reportForVal == 'Zone' )
					{
						categoryVal = Ext.getCmp('zone').getValue();
						isSubZone = Ext.getCmp('subzone').getValue().toLowerCase();
						no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=['+isSubZone+']&P3=['+getTestVal+']';
					}
					else if ( reportForVal == 'Segment' )
					{
					categoryVal = Ext.getCmp('segment').getValue();
					no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=[no]&P3=['+getTestVal+']';
					}
					else if ( reportForVal == 'Service' )
					{
					categoryVal = Ext.getCmp('service').getValue();
					no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=[no]&P3=['+getTestVal+']';
					}
				}
					var param = 'F='+methodName+'&C=jsrs1'+ no_params+'&U=1360217653961521&fromajax=true';
					//
				Ext.Ajax.request({
					url: remoteURL,
					params: param,
					async: false,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var compData = jsonData['combo'];
								var compObj = Ext.getCmp('component');
								if ( !Ext.isEmpty( compData ) )
								{
									compObj.suspendEvents(true);
									compObj.getStore().loadRawData(compData);
									me.dataArray = compObj.getStore();
									compObj.resumeEvents();
								}
							}
						}
					}
				});
				Ext.getCmp('component').setValue(appConstants.publicJSON['selectedComponent']);
				//me.changeTest();	
			}
			else
			{
				var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
				var getMetricVal = appConstants.publicJSON['metricComboSelected'];
				var getUserId = appConstants.publicJSON['hiddens']['userID'];
				var no_params = '';
	// by karthikeyan
		var reportForVal = Ext.getCmp('Report').getValue();
		var param = '';
		if(reportForVal == 'Zone')
		{
			var selectedZone=Ext.getCmp('zone').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedZone+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		}
		else if(reportForVal == 'Segment')
		{
			var selectedSeg = Ext.getCmp('segment').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedSeg+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		}
			else if(reportForVal == 'Service')
		{
			var selectedSer = Ext.getCmp('service').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedSer+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		}
			else
		{
			no_params = '&P0=['+getMetricVal+']&P1=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate1&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		}
			if(getMetricVal != undefined && appConstants.rmComponentType != 'null')
			{
				param += '&er_compType='+appConstants.rmComponentType;
			}
				Ext.Ajax.request({
					url: remoteURL,
					params: param,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonData ) )
							{
								var componentObj = Ext.getCmp('component');
								var compData = jsonData['combo'];
								componentObj.suspendEvents(true);
								componentObj.getStore().loadRawData(compData);
								componentObj.resumeEvents();
							}
						}
					}
				});
				no_params = '&P0=['+getMetricVal+']';
				param = 'F=getTestForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			    Ext.Ajax.request({
		    		url: remoteURL,
		    		params: param,
		    		async: false,
		    		success: function( response )
		    		{
		    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		    			{
		    				var jsonText = response.responseText;
		    				var jsonData = Ext.decode(jsonText);
		    				if ( !Ext.isEmpty( jsonData ) )
		    				{
		    					var getTestValues = jsonData['values'];
		    					getTestValues = JSON.stringify(getTestValues);
								var prevTestVal = appConstants.testVal;
								if ( !Ext.isEmpty( getTestValues ) )
		    					{
									if(typeof getTestValues != 'undefined')
									{
										appConstants.testVal = getTestValues.substring( 0, getTestValues.indexOf(":") );
										appConstants.testVal = appConstants.testVal.substring(2);
										if ( prevTestVal != '' && prevTestVal != appConstants.testVal )
										{
											hasMultipleTest = true;
										}
										appConstants.mapTestVal = getTestValues.substring( getTestValues.indexOf(":") + 1 );
										appConstants.mapTestVal = appConstants.mapTestVal.substring( 0, appConstants.mapTestVal.lastIndexOf('"') );
									}
								}
		    				}
		    			}
		    		}
		    	});
		    	no_params = '&P0=['+getMetricVal+']';
				param = 'F=getMeasuresForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
			    Ext.Ajax.request({
		    		url: remoteURL,
		    		params: param,
		    		async: false,
		    		success: function( response )
		    		{
		    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		    			{
		    				var jsonText = response.responseText;
		    				var jsonData = Ext.decode(jsonText);
		    				if ( !Ext.isEmpty( jsonData ) )
		    				{
		    					var getTestValues = jsonData['values'];
								getTestValues = JSON.stringify(getTestValues);
								if(!Ext.isEmpty( getTestValues ))
								{
									if(typeof getTestValues != 'undefined')
									{
										appConstants.measureVal = getTestValues.substring( 0, getTestValues.indexOf(":") );
										appConstants.appConstants.measureVal = appConstants.measureVal.substring(2);
										appConstants.mapMeasureVal = getTestValues.substring( getTestValues.indexOf(":") + 1 );
										appConstants.mapMeasureVal = appConstants.mapMeasureVal.substring( 0, appConstants.mapMeasureVal.lastIndexOf('"') );
									}
								}
		    				}
		    			}
		    		}
		    	});
		    	Ext.getCmp('component').setValue(appConstants.publicJSON['selectedComponent']);
		    	me.selectComponents(Ext.getCmp('component'));
			}
			if ( !Ext.isEmpty( jsonData['infosSelected'] ) )
			{
				Ext.getCmp('Descriptor').setValue(jsonData['infosSelected'])
			}
			/************ Timeline Settings STARTS *****************/
			var er_timelineObj = mainform.findField('er_timeline');
			var timelineComboData = jsonData['timelineCombo'];
			if ( !Ext.isEmpty( timelineComboData ) )
			{
				var selectedTimelineData = jsonData['selectedTimeline'];
				er_timelineObj.suspendEvents(true);
				er_timelineObj.getStore().loadRawData(timelineComboData);
				if ( !Ext.isEmpty( selectedTimelineData ) )
				{
					er_timelineObj.setValue(selectedTimelineData);
				}
				er_timelineObj.resumeEvents();
			}
			
			var er_stdateObj = mainform.findField('er_stdate');
			var startDateVal = jsonData['startDate'];
			if ( !Ext.isEmpty( startDateVal ) )
			{
				er_stdateObj.suspendEvents(true);
				er_stdateObj.setValue(jsonData['startDateForDisplay']);
				er_stdateObj.dataArray = startDateVal;
				er_stdateObj.resumeEvents();
			}
			
			var er_enddateObj = mainform.findField('er_enddate');
			var endDateVal = jsonData['endDate'];
			if ( !Ext.isEmpty( endDateVal ) )
			{
				er_enddateObj.suspendEvents(true);
				er_enddateObj.setValue(jsonData['endDateForDisplay']);
				er_enddateObj.dataArray =endDateVal;
				er_enddateObj.resumeEvents();
			}
			
			var er_sthrObj = mainform.findField('er_sthr');
			var startHourVal = jsonData['startHour'];
			if ( !Ext.isEmpty( startHourVal ) )
			{
				er_sthrObj.suspendEvents(true);
				er_sthrObj.setValue(jsonData['startHourForDisplay']);
				er_sthrObj.dataArray=startHourVal;
				er_sthrObj.resumeEvents();
			}
			
			var er_endhrObj = mainform.findField('er_endhr');
			var endHourVal = jsonData['endHour'];
			if ( !Ext.isEmpty( endHourVal ) )
			{
				er_endhrObj.suspendEvents(true);
				er_endhrObj.setValue(jsonData['endHourForDisplay']);
				er_endhrObj.dataArray=endHourVal;
				er_endhrObj.resumeEvents();
			}
			
			var selectedGraphModeVal = jsonData['selectedGraphMode'];
			var er_modeObj = mainform.findField('er_mode');
			if ( !Ext.isEmpty( selectedGraphModeVal ) )
			{
				er_modeObj.suspendEvents(true);
				er_modeObj.setValue( selectedGraphModeVal );
				er_modeObj.resumeEvents();
			}

			stmin = jsonData.startMinForDisplay;
			enmin = jsonData.endMinForDisplay;
			mgr_stmin = jsonData.startmin;
			mgr_enmin = jsonData.endmin;
			
			/************ Timeline Settings ENDS *****************/
		}
 		var gridObj = Ext.getCmp('configdatas');
		var combination = appConstants.publicJSON['combination'];
		var submitObj = Ext.getCmp('submit');
		var hiddenFields = appConstants.publicJSON['hiddens'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) 
		{
			var submitObj = Ext.getCmp('save');
			submitObj.setText(appConstants.publicJSON.screenLabels['reporter.common.SAVE']);
		}
		else
			submitObj.setText(submitValue);
		submitObj.show();
		if ( !Ext.isEmpty( appConstants.isSubmit ) && appConstants.isSubmit == 'true'  && (from_schedule == null || from_schedule == "No"))
		{
			var er_graphtype = jsonData['showGraphTypeSelected'];
			if (isSettingsEnabled)
			{
				er_graphtype = settingsForm.findField('graphtype').getValue();
			}
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);

			this.loadCharts(jsonData,er_graphtype); 
		}
		else
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);

		if ( !Ext.isEmpty( appConstants.publicJSON['gridValues'] ) )
		{
 			var gridValues = appConstants.publicJSON['gridValues'];
			var gridObj = Ext.getCmp('configdatas'); 
			gridObj.getStore().loadRawData(gridValues);
			var rowCount=gridObj.getStore().getCount();
			if (rowCount>0)
			{
				Ext.getCmp('my_formouter').show();
				for ( var i = 0;i <rowCount ; i++ )
				{
						gridObj.getSelectionModel().select(i, true);
				}
			}
			
		}
		if(appConstants.isForceSubmit=='true')
		{
			
			this.beforeFormSubmit();
			appConstants.isForceSubmit='false';
		} 
	if(!hideBackButton){
		Ext.getCmp('defineConfig').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJSON['ID']
			}
		);
	}
		/********************* To load Default Settings *************************/
		this.autoCompareTest();
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);
			
		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	changeZone: function()
	{
		var configForm = Ext.getCmp('popup').getForm();
		var getZoneVal = configForm.findField('zone').getValue();
		if ( getZoneVal != '-1' )
		{
			this.changeCriteria();
		}
		else
		{
			var compObj = configForm.findField('component');
			var descriptorObj = configForm.findField('Descriptor');
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			this.insertNotApplicable(compObj);
			this.insertNotApplicable(descriptorObj);
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);	
		}
	},
	changeSegment: function()
	{
		var configForm = Ext.getCmp('popup').getForm();
		var getSegmentVal =configForm.findField('segment').getValue();
		if ( getSegmentVal != '-1' )
		{
			this.changeCriteria();
		}
		else
		{
			var compObj = configForm.findField('component');
			var descriptorObj = configForm.findField('Descriptor');
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			this.insertNotApplicable(compObj);
			this.insertNotApplicable(descriptorObj);
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);	
		}
	},
	changeService: function()
	{
		var configForm = Ext.getCmp('popup').getForm();
		var getServiceVal = configForm.findField('service').getValue();
		if ( getServiceVal != '-1' )
		{
			this.changeCriteria();
		}
		else
		{
			var compObj = configForm.findField('component');
			var descriptorObj = configForm.findField('Descriptor');
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			this.insertNotApplicable(compObj);
			this.insertNotApplicable(descriptorObj);
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);	
		}
	},
	changeMetric:function( obj )
	{
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var getMetricVal = Ext.getCmp('metric').getValue();
		var getUserId = appConstants.publicJSON.hiddens['us_id'];

		var no_params = '';
	// by karthikeyan
		var reportForVal = Ext.getCmp('Report').getValue();
		var param = '';
		if(reportForVal == 'Zone')
		{
			var selectedZone=Ext.getCmp('zone').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedZone+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';

		}
		else if(reportForVal == 'Segment')
		{
			var selectedSeg = Ext.getCmp('segment').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedSeg+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';

		}
			else if(reportForVal == 'Service')
		{
			var selectedSer = Ext.getCmp('service').getValue();
			no_params = '&P0=['+reportForVal+']&P1=['+selectedSer+']&P2=['+getMetricVal+']'+'&P3=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';

		}
			else
		{
			no_params = '&P0=['+getMetricVal+']&P1=['+encodeURIComponent(getUserId)+']';
			param = 'F=getComponentsForTemplate1&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		}
		if(appConstants.rmComponentType != 'null')
		{
			param += '&er_compType='+appConstants.rmComponentType;
		}
		if ( !Ext.isEmpty( obj ) )
		{
			Ext.Ajax.request({
				url: remoteURL,
				params: param,
				method: 'POST',
				async: false,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if ( !Ext.isEmpty( jsonData ) )
						{
							var componentObj = Ext.getCmp('component');
							var compData = jsonData['combo'];
							appConstants.rawDataForComponents = compData;
							componentObj.suspendEvents(true);
							componentObj.getStore().loadRawData(compData);
							componentObj.resumeEvents();
						}
					}
				}
			});
			no_params = '&P0=['+getMetricVal+']';
			param = 'F=getTestForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		    Ext.Ajax.request({
	    		url: remoteURL,
	    		params: param,
	    		async: false,
	    		success: function( response )
	    		{
	    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	    			{
	    				var jsonText = response.responseText;
	    				var jsonData = Ext.decode(jsonText);
	    				if ( !Ext.isEmpty( jsonData ) )
	    				{
	    					var getTestValues = jsonData['values'];
	    					getTestValues = JSON.stringify(getTestValues);
							if(!Ext.isEmpty( getTestValues ))
							{
								if(typeof getTestValues !='undefined')
								{
									var prevTestVal = appConstants.testVal;
									appConstants.testVal = getTestValues.substring( 0, getTestValues.indexOf(":") );
									appConstants.testVal = appConstants.testVal.substring(2);
									if ( prevTestVal != '' && prevTestVal != appConstants.testVal )
									{
										hasMultipleTest = true;
									}
									appConstants.mapTestVal = getTestValues.substring( getTestValues.indexOf(":") + 1 );
									appConstants.mapTestVal = appConstants.mapTestVal.substring( 0, appConstants.mapTestVal.lastIndexOf('"') );
								}
							}
	    				}
	    			}
	    		}
	    	});
	    	
	    	no_params = '&P0=['+getMetricVal+']';
			param = 'F=getMeasuresForTemplate&C=jsrs1'+no_params+'&U='+new Date().getTime()+'&fromajax=true';
		    Ext.Ajax.request({
	    		url: remoteURL,
	    		params: param,
	    		async: false,
	    		success: function( response )
	    		{
	    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	    			{
	    				var jsonText = response.responseText;
	    				var jsonData = Ext.decode(jsonText);
	    				if ( !Ext.isEmpty( jsonData ) )
	    				{
	    					var getTestValues = jsonData['values'];
							getTestValues = JSON.stringify(getTestValues);
							if(!Ext.isEmpty( getTestValues ))
							{
								if(typeof getTestValues != 'undefined')
								{
									appConstants.measureVal = getTestValues.substring( 0, getTestValues.indexOf(":") );
									appConstants.measureVal = appConstants.measureVal.substring(2);
									appConstants.mapMeasureVal = getTestValues.substring( getTestValues.indexOf(":") + 1 );
									appConstants.mapMeasureVal = appConstants.mapMeasureVal.substring( 0, appConstants.mapMeasureVal.lastIndexOf('"') );
								}
							}
	    				}
	    			}
	    		}
	    	});
		}
	},
	changeTest: function( obj )
	{
		var me = this;
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var getTestVal = Ext.getCmp('test').getValue();
		var reportForVal = Ext.getCmp('Report').getValue();
		var categoryVal = '';
		var isSubZone = 'no';
		
		var no_params = '';
		var funcName = '';
		var methodName='';
		if ( getTestVal != '-1' && !Ext.isEmpty( obj ) )
		{
			if ( reportForVal == 'Component' )
			{
				no_params = '&P0=['+getTestVal+']';
			
				methodName = 'getComponentsForTest1';
				no_params = '&P0=['+encodeURIComponent(getTestVal)+']&P1=['+encodeURIComponent(getUserId)+']';
			}
			else
			{
				methodName = 'getComponentsForTest';
				if ( reportForVal == 'Zone' )
				{
					categoryVal = Ext.getCmp('zone').getValue();
					isSubZone = Ext.getCmp('subzone').getValue().toLowerCase();
					no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=['+isSubZone+']&P3=['+getTestVal+']';
				}
				else if ( reportForVal == 'Segment' )
				{
				categoryVal = Ext.getCmp('segment').getValue();
				no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=[no]&P3=['+getTestVal+']';
				}
				else if ( reportForVal == 'Service' )
				{
				categoryVal = Ext.getCmp('service').getValue();
				no_params = '&P0=['+reportForVal+']&P1=['+categoryVal+']'+'&P2=[no]&P3=['+getTestVal+']';
				}

			}
			var param = 'F=getMeasuresForTest1&C=jsrs1&P0=['+getTestVal+']&U=1360067356100817&fromajax=true';
			if(appConstants.rmComponentType != 'null')
			{
				param += '&er_compType='+appConstants.rmComponentType;
			}
			if ( !Ext.isEmpty( obj ) )
			{
				Ext.Ajax.request({
					url: remoteURL,
					params: param,
					async: false,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							if ( !Ext.isEmpty( jsonData ) )
							{
								var measureData = jsonData['combo'];
								var measureObj = Ext.getCmp('measure');
								if ( !Ext.isEmpty( measureData ) )
								{
									measureObj.suspendEvents(true);
									measureObj.getStore().loadRawData(measureData);
									measureObj.getStore().insert(0,{
										displayField: appConstants.mapping_measure,
										valueField: '-1'
									});
									measureObj.setValue('-1');
									measureObj.resumeEvents();
								}
								else
								{
									me.insertNotApplicable(measureObj);
								}
							}
						}
					}
				});
			}
			var getUserId = appConstants.publicJSON.hiddens['us_id'];
			var param = 'F='+methodName+'&C=jsrs1'+ no_params+'&U=1360217653961521&fromajax=true';
			if(appConstants.rmComponentType != 'null')
			{
				param += '&er_compType='+appConstants.rmComponentType;
			}
			Ext.Ajax.request({
				url: remoteURL,
				params: param,
				async: false,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						if ( !Ext.isEmpty( jsonData ) )
						{
							var compData = jsonData['combo']; 
							var compObj = Ext.getCmp('component');
							if ( !Ext.isEmpty( compData ) )
							{
								appConstants.rawDataForComponents = compData;
								compObj.suspendEvents(true);
								compObj.getStore().loadRawData(compData);
								me.dataArray = compObj.getStore();
								compObj.resumeEvents();
							}
						}
					}
				}
			});
		}
		else
		{
			var compObj = Ext.getCmp('component');
			var DescriptorObj = Ext.getCmp('Descriptor');
			var measureObj = Ext.getCmp('measure');
			me.insertNotApplicable(compObj);
			me.insertNotApplicable(measureObj);
		}
		var DescriptorObj = Ext.getCmp('Descriptor');
		this.insertNotApplicable(DescriptorObj);
	},
	changeTimeline: function(combo)
	{
		Ext.getCmp('resultPanel').hide();
		var mainform=this.getDefineconfiguration().getForm();
		var settingsForm = Ext.getCmp('configsettings').getForm();
		var time = Ext.getCmp('er_timeline').getValue();
		var er_trenddata;
		if(isSettingsEnabled)
		{
			var settingsForm = Ext.getCmp('configsettings').getForm();
			er_trenddata = (settingsForm.findField('showdata').getValue() == 'Trend')?'Yes':'No';
		}
		else
		{
			var jsonData = appConstants.publicJSON;
			 er_trenddata = (jsonData['showDataSelected'] == 'Trend')?'Yes':'No';
		}
		if(er_trenddata != undefined && er_trenddata == 'Yes'){
			var durtnCombo=Ext.getCmp('CommonMaximum');
			if(durtnCombo != undefined){
				durtnCombo.getEl().setStyle({'margin-top':'10px'});
			}
			var autoMaxCombo=Ext.getCmp('autoMaximum');
			if(autoMaxCombo != undefined){
				autoMaxCombo.getEl().setStyle({'margin-top':'10px'});
			}
		}else{
			var durtnCombo=Ext.getCmp('CommonMaximum');
			if(durtnCombo != undefined){
				durtnCombo.getEl().setStyle({'margin-top':'0px'});
			}
			var autoMaxCombo=Ext.getCmp('autoMaximum');
			if(autoMaxCombo != undefined){
				autoMaxCombo.getEl().setStyle({'margin-top':'0px'});
			}
		}
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1,
				scope : this,
				async : true,
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var comboVal=jsonData.combo;
					var timelineCombo = mainform.findField('er_timeline');
					timelineCombo.getStore().removeAll();
					timelineCombo.getStore().loadRawData(jsonData.combo);
					var flag=false;
					for(var i = 0; i < comboVal.length; i++)
					{
					  if(comboVal[i].valueField == time)
					  {
						flag=true;
					  }
					}
					if(flag)
						timelineCombo.setValue(time);
					else
						timelineCombo.setValue("1 day");
				}
			});
		}
		var er_stdateObj = mainform.findField('er_stdate');
		var er_sthrObj = mainform.findField('er_sthr');
		var er_enddateObj = mainform.findField('er_enddate');
		var er_endhrObj = mainform.findField('er_endhr');
		var getVal = mainform.findField('er_timeline').getValue();
		if ( getVal == 'Any' )
		{
			er_stdateObj.setDisabled(false);
			er_sthrObj.setDisabled(false);
			er_enddateObj.setDisabled(false);
			er_endhrObj.setDisabled(false);
		}
		else
		{
			er_stdateObj.setDisabled(true);
			er_sthrObj.setDisabled(true);
			er_enddateObj.setDisabled(true);
			er_endhrObj.setDisabled(true);
		}
		var showDataVal = settingsForm.findField('showdata').getValue();
			var er_timeline = mainform.findField('er_timeline');
			var er_timelineVal = er_timeline.getValue();
			
			var er_stdate = mainform.findField('er_stdate');
			var er_enddate = mainform.findField('er_enddate');
			var er_sthr = mainform.findField('er_sthr');
			var er_endhr = mainform.findField('er_endhr');
			var inidateVal = appConstants.publicJSON.hiddens['inidate'];
			var er_stdateVal = Ext.Date.dateFormat(er_stdate.getValue(), mgrDateFormat);
			var er_enddateVal = Ext.Date.dateFormat(er_enddate.getValue(), mgrDateFormat);
			if ( showDataVal == 'Trend' && er_timelineVal.indexOf('hour') > -1 )
			{
				er_timelineVal = '1 day';
			}
		var param_val = "";  
		var durtnCombo=Ext.getCmp("duration");
		var gtypeCombo=Ext.getCmp("gtype");

		if (er_trenddata == "No")
		{
			if(durtnCombo != undefined && gtypeCombo != undefined){
				durtnCombo.hide();
				gtypeCombo.hide();
			}
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr.getValue()
					+ "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			if(durtnCombo != undefined && gtypeCombo != undefined){
				durtnCombo.show();
				gtypeCombo.show();
			}
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js

			if (er_timelineVal.indexOf("hour") > -1)
				er_timelineVal = "1 day";
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
		var mainform=this.getDefineconfiguration().getForm();
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param_val,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonObject = Ext.decode(jsonText);
					var values = jsonObject.timeline;
					Ext.getCmp('er_stdate').dataArray=values[0];
					Ext.getCmp('er_enddate').dataArray=values[1];
					Ext.getCmp('er_sthr').dataArray=values[2];
					Ext.getCmp('er_endhr').dataArray=values[3]; 
					mgr_stmin = values[4];
					mgr_enmin = values[5];

					Ext.getCmp('er_stdate').setValue(values[6]);
					Ext.getCmp('er_enddate').setValue(values[7]); 
					Ext.getCmp('er_sthr').setValue(values[8]);
					Ext.getCmp('er_endhr').setValue(values[9]); 
					stmin =values[10];
					enmin = values[11];
			}
		});
	},
	changeTrendTimeline: function(combo)
	{
		Ext.getCmp('resultPanel').hide();
		var mainform=this.getDefineconfiguration().getForm();
		var settingsForm = Ext.getCmp('configsettings').getForm();
		var time = Ext.getCmp('er_timeline').getValue();
		var er_trenddata;


		if(isSettingsEnabled)
		{
			var settingsForm = Ext.getCmp('configsettings').getForm();
			er_trenddata = settingsForm.findField('duration').getValue();
		}
		else
		{
			var jsonData = appConstants.publicJSON;
			 er_trenddata = jsonData['durationcomboSelected'];
		}
		{
			var param1 = "F=getTrendTimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1,
				scope : this,
				async : false,
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var comboVal=jsonData.combo;
					var timelineCombo = mainform.findField('er_timeline');
					timelineCombo.getStore().removeAll();
					timelineCombo.getStore().loadRawData(jsonData.combo);
					if(er_trenddata == 'D')
						timelineCombo.setValue("1 week");
					else if(er_trenddata == 'M')
						timelineCombo.setValue("3 months");
					else
						timelineCombo.setValue("1 day");
				}
			});
		}
		
		var er_stdateObj = mainform.findField('er_stdate');
		var er_sthrObj = mainform.findField('er_sthr');
		var er_enddateObj = mainform.findField('er_enddate');
		var er_endhrObj = mainform.findField('er_endhr');
		var getVal = mainform.findField('er_timeline').getValue();
		if ( getVal == 'Any' )
		{
			er_stdateObj.setDisabled(false);
			er_sthrObj.setDisabled(false);
			er_enddateObj.setDisabled(false);
			er_endhrObj.setDisabled(false);
		}
		else
		{
			er_stdateObj.setDisabled(true);
			er_sthrObj.setDisabled(true);
			er_enddateObj.setDisabled(true);
			er_endhrObj.setDisabled(true);
		}
		var er_timeline = mainform.findField('er_timeline');
		var er_timelineVal = er_timeline.getValue();
		var er_stdate = mainform.findField('er_stdate');
		var er_enddate = mainform.findField('er_enddate');
		var er_sthr = mainform.findField('er_sthr');
		var er_endhr = mainform.findField('er_endhr');
		var inidateVal = appConstants.publicJSON.hiddens['inidate'];
		var er_stdateVal = Ext.Date.dateFormat(er_stdate.getValue(), mgrDateFormat);
		var er_enddateVal = Ext.Date.dateFormat(er_enddate.getValue(), mgrDateFormat);


		var param_val = "";  

 
		{
			///////////

			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js

			if (er_timelineVal.indexOf("hour") > -1)
				er_timelineVal = "1 day";
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr.getValue() + "]&P4=[" + er_endhr.getValue() + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
		var mainform=this.getDefineconfiguration().getForm();
		Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param_val,
				scope : this,
				async : true,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonObject = Ext.decode(jsonText);
					var values = jsonObject.timeline;
					Ext.getCmp('er_stdate').dataArray=values[0];
					Ext.getCmp('er_enddate').dataArray=values[1];
					Ext.getCmp('er_sthr').dataArray=values[2];
					Ext.getCmp('er_endhr').dataArray=values[3]; 
					mgr_stmin = values[4];
					mgr_enmin = values[5];

					Ext.getCmp('er_stdate').setValue(values[6]);
					Ext.getCmp('er_enddate').setValue(values[7]); 
					Ext.getCmp('er_sthr').setValue(values[8]);
					Ext.getCmp('er_endhr').setValue(values[9]); 
					stmin =values[10];
					enmin = values[11];
			}
		});
	},
	changeAutoMaximum: function()
	{
		var getVal = Ext.getCmp('autoMaximum').getValue();
		var maxValueObj = Ext.getCmp('maxValue');
		if ( getVal == 'No' )
		{
			maxValueObj.setValue('');
			maxValueObj.show();
		}
		else
		{
			maxValueObj.hide();
		}
	},
	changeCommonMaximum: function()
	{
		var settingsForm = Ext.getCmp('configsettings').getForm();
		var getVal = settingsForm.findField('CommonMaximum').getValue();
		var autoMaximumObj = settingsForm.findField('autoMaximum');
		var autogetVal = Ext.getCmp('autoMaximum').getValue();
		var maxValueObj = Ext.getCmp('maxValue');
		var showdataObj = Ext.getCmp('showdata').getValue();
		if ( getVal == 'Yes' )
		{
			autoMaximumObj.show();
			if( autoMaximumObj.getValue() == 'No')
			{
				maxValueObj.show();
			}
			var durtnCombo=Ext.getCmp('autoMaximum');
			if(durtnCombo != undefined && showdataObj == 'Detailed'){
				durtnCombo.getEl().setStyle({'margin-top':'0px'});
			}
		}
		else
		{
			autoMaximumObj.hide();
			maxValueObj.hide();
		}
	},
	selectReportFor:function(combo)
	{
		var configForm = Ext.getCmp('popup').getForm();
	
		var thisform=this.getDefineconfiguration().getForm();
		var getVal = configForm.findField('Report').getValue();
		var zoneObj = configForm.findField('zone');
		var subZoneObj = configForm.findField('subzone');
		var serviceObj = configForm.findField('service');
		var segmentObj = configForm.findField('segment');
		var er_service = null;
		if  (getVal == 'Zone')
		{
            er_service = getVal;
			zoneObj.suspendEvents(true);
			zoneObj.setFieldLabel(appConstants.defaultLabels['zone']);
			zoneObj.resumeEvents();
			subZoneObj.suspendEvents(true);
			subZoneObj.setFieldLabel(appConstants.defaultLabels['subzone']);
			//subZoneObj.resumeEvents();
			zoneObj.show();

			//
			if ( !Ext.isEmpty(appConstants.publicJSON))
			{
				var subZoneComboData = appConstants.publicJSON['subzone'];
				var selectedSubZone = appConstants.publicJSON['subszoneSelected'];
					if ( !Ext.isEmpty( subZoneComboData ) )
						{
						subZoneObj.getStore().loadRawData(subZoneComboData);
						if ( !Ext.isEmpty( selectedSubZone ) )
						   subZoneObj.setValue(selectedSubZone);
						else
							 subZoneObj.setValue(subZoneComboData[0].valueField);

						subZoneObj.resumeEvents();
						}
			}
			//
			subZoneObj.show();
			serviceObj.hide();
			segmentObj.hide();
		}
		else if ( getVal == 'Segment' )
		{
            er_service = getVal;
			segmentObj.suspendEvents(true);
			segmentObj.setFieldLabel(appConstants.defaultLabels['segment']);
			segmentObj.resumeEvents();
			zoneObj.hide();
			subZoneObj.hide();
			serviceObj.hide();
			segmentObj.show();
		}
		else if ( getVal == 'Service' )
		{
			er_service = getVal;
			serviceObj.suspendEvents(true);
			serviceObj.setFieldLabel(appConstants.defaultLabels['service']);
			serviceObj.resumeEvents();
			zoneObj.hide();
			subZoneObj.hide();
			serviceObj.show();
			segmentObj.hide();
		}
		else
		{
			zoneObj.hide();
			subZoneObj.hide();
			serviceObj.hide();
			segmentObj.hide();
			this.changeCriteria();
		}
		if ( !Ext.isEmpty( combo ) )
		{
			var er_templateEnable = '';
			var getCriteriaVal = configForm.findField('criteria').getValue();
			er_templateEnable = ( getCriteriaVal == 'Test' )?'no':'yes';
			var er_timelineVal = thisform.findField('er_timeline').getValue();
			var er_graphtypeVal = appConstants.publicJSON['showGraphTypeSelected'];
			if (isSettingsEnabled)
			{
				var settingsForm = Ext.getCmp('configsettings').getForm();
				var er_graphtypeVal = settingsForm.findField('graphtype').getValue();
			}
			var params = 'er_gtype='+appConstants.er_gtype+'&er_timeline='+encodeURIComponent(er_timelineVal)+'&er_bound=Fixed&er_graphtype='+encodeURIComponent(er_graphtypeVal)+'&er_dataFrom='+encodeURIComponent(getVal)+'&er_templateEnable='+er_templateEnable+'&er_measure=-1&er_test=-1'+ '&er_service='+er_service;
			Ext.Ajax.request({
				url: '/final/reporter/ErCompareTestJSON.jsp',
				params: params,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						if ( !Ext.isEmpty( jsonData ) )
						{
							if ( getVal == 'Zone' )
							{
								var zoneComboData = jsonData['Zone'];
								zoneObj.suspendEvents(true);
								zoneObj.getStore().clearFilter(true); 
								zoneObj.getStore().loadRawData(zoneComboData);
								zoneObj.setValue('-1');
								zoneObj.resumeEvents();
								var subZoneComboData = jsonData['subzone'];
								var selectedSubZone = jsonData['subszoneSelected'];
								if ( !Ext.isEmpty( subZoneComboData ) )
								{
									var subZoneObj = Ext.getCmp('subzone');
									subZoneObj.suspendEvents(true);
									subZoneObj.getStore().loadRawData(subZoneComboData);
									if ( !Ext.isEmpty( selectedSubZone ) )
									   subZoneObj.setValue(selectedSubZone);
									else
										 subZoneObj.setValue(subZoneComboData[0].valueField);

									subZoneObj.resumeEvents();
								}
							}
							else if ( getVal == 'Segment' )
							{
								var segmentComboData = jsonData['Segment'];
								segmentObj.suspendEvents(true);
								segmentObj.getStore().clearFilter(true); 
								segmentObj.getStore().loadRawData(segmentComboData);
								segmentObj.setValue('-1');
								segmentObj.resumeEvents();
							}
							else if ( getVal == 'Service' )
							{
								var serviceComboData = jsonData['Service'];
								serviceObj.suspendEvents(true);
								serviceObj.getStore().clearFilter(true); 
								serviceObj.getStore().loadRawData(serviceComboData);
								serviceObj.setValue('-1');
								serviceObj.resumeEvents();
							}
						}
					}
				}
			});
			var compObj = configForm.findField('component');
			var descriptorObj = configForm.findField('Descriptor');
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			this.insertNotApplicable(compObj);
			this.insertNotApplicable(descriptorObj);
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);
		}
		else
		{
			//alert('I am Empty...');
		}
		Ext.getCmp('configdatas').getStore().removeAll();
	},
	changeCriteria: function( obj )
	{
		Ext.getCmp('configdatas').getStore().removeAll();
		var configForm = Ext.getCmp('popup').getForm();
		var criteriaObj = configForm.findField('criteria');
		var descObj = configForm.findField('Descriptor');
		var loadTestMetric = false;
		if ( !Ext.isEmpty( criteriaObj ) )
		{
			var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
			var no_params = '';
			var reportForVal = configForm.findField('Report').getValue();
			if ( reportForVal == 'Component' )
			{
				no_params = '&P0=[Component]&P1=[Component]&P2=[no]';
				loadTestMetric = true;
			}
			else if ( reportForVal == 'Zone')
			{
				var zoneVal = configForm.findField('zone').getValue();
				var subZoneVal = configForm.findField('subzone').getValue();
				if ( zoneVal == '-1' )
				{
					loadTestMetric = false;
				}
				else
				{
					loadTestMetric = true;
				}
				no_params = '&P0=['+reportForVal+']&P1=['+zoneVal+']&P2=['+subZoneVal+']';
			}
			else if ( reportForVal == 'Segment' )
			{
				var segmentVal = configForm.findField('segment').getValue();
				no_params = '&P0=['+reportForVal+']&P1=['+segmentVal+']&P2=[no]';
				if ( segmentVal == '-1' )
				{
					loadTestMetric = false;
				}
				else
				{
					loadTestMetric = true;
				}
			}
			else if ( reportForVal == 'Service' )
			{
				var serviceVal = configForm.findField('service').getValue();
				no_params = '&P0=['+reportForVal+']&P1=['+serviceVal+']&P2=[no]';
				if ( serviceVal == '-1' )
				{
					loadTestMetric = false;
				}
				else
				{
					loadTestMetric = true;
				}
			}
			if ( loadTestMetric )
			{
				if ( criteriaObj.getValue() == 'Test' )
				{
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					if ( !Ext.isEmpty( appConstants.publicJSON.screenLabels['reporter.comparison.Test'] ) )
					{
						testObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Test']);
					}
					if ( !Ext.isEmpty( appConstants.publicJSON.screenLabels['reporter.comparison.Measure'] ) )
					{
						measureObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Measure']);
					}
					testObj.show();
					measureObj.show();
					var metricObj = configForm.findField('metric');
					metricObj.hide();
					var param = 'F=getTestsForSite&C=jsrs1'+no_params+'&U=1360067356100817&fromajax=true';
					if(appConstants.rmComponentType != 'null')
					{
						param += '&er_compType='+appConstants.rmComponentType;
					}			
					Ext.Ajax.request({
						url: remoteURL,
						params:param,
						scope:this,
						success:function(response)
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if (!Ext.isEmpty(jsonData))
							{
								var testComboData = jsonData['combo'];
								var testObj = configForm.findField('test');
								testObj.suspendEvents(true);
								testObj.getStore().clearFilter(true); 
								testObj.getStore().loadRawData(testComboData);
								var tmpStore = testObj.getStore();
								tmpStore.insert(0, {
									displayField: appConstants.mapping_test,
									valueField: '-1'
								});
								testObj.setValue('-1');
								testObj.resumeEvents();
							}
						}
					});
					var measureObj = configForm.findField('measure');
					this.insertNotApplicable(measureObj);
				}
				else
				{
					var testObj = configForm.findField('test');
					var measureObj = configForm.findField('measure');
					var metricObj = configForm.findField('metric');
					if ( !Ext.isEmpty(appConstants.publicJSON.screenLabels['reporter.comparison.Metric']) )
					{
						metricObj.setFieldLabel(appConstants.publicJSON.screenLabels['reporter.comparison.Metric']);
					}
					var param = 'F=getTemplateForSite&C=jsrs1'+no_params+'&U=1360127833994872&fromajax=true';
					if(appConstants.rmComponentType != 'null')
					{
						param += '&er_compType='+appConstants.rmComponentType;
					}
					 Ext.Ajax.request({
						url: remoteURL,
						params:param,
						scope:this,
						success:function(response){
							
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if ( !Ext.isEmpty( jsonData ) )
							{
								var metricObj = configForm.findField('metric');
								metricObj.suspendEvents(true);
								var metricComboData = jsonData['combo'];
								metricObj.getStore().clearFilter(true); 
								metricObj.getStore().loadRawData(metricComboData);
								metricObj.getStore().insert(0,{
									displayField: appConstants.mapping_metric,
									valueField: '-1'
								});
								metricObj.setValue('-1');
								metricObj.resumeEvents();
							}
						}
					});
					metricObj.show();
					testObj.hide();
					measureObj.hide();
				}
			}
			var testObj = configForm.findField('test');
			var measureObj = configForm.findField('measure');
			var metricObj = configForm.findField('metric');
			var compObj = configForm.findField('component');
			var descriptorObj = configForm.findField('Descriptor');
			this.insertNotApplicable(testObj);
			this.insertNotApplicable(measureObj);
			this.insertNotApplicable(metricObj);
			this.insertNotApplicable(compObj);
			this.insertNotApplicable(descriptorObj);
		}
	},
	insertNotApplicable: function(comboObj)
	{
		if ( !Ext.isEmpty( comboObj ) )
		{
			var tmpStore = comboObj.getStore();
			var naArray=[];
 			naArray.push({
				displayField: appConstants.notApplicabletxt,
				valueField: '-1'
			});
			tmpStore.loadRawData(naArray);
			comboObj.setValue('-1');
			if(comboObj.getId()=='Descriptor')
			{
				appConstants.rawDataForDescriptor=naArray;
			}
			else if(comboObj.getId()=='component')
			{
				appConstants.rawDataForComponents=naArray;
			}
		}
	},
	getHiddenQueryString: function()
	{
		var hiddens = appConstants.publicJSON['hiddens'];
		hiddenQStr = '';
		for ( var key in hiddens )
		{
			hiddenQStr += '&'+key+'='+encodeURIComponent(hiddens[key]);
		}
		return hiddenQStr;
	},
	/*loadHiddens: function( hiddens )
	{
		try
		{
			var mainForm = this.getMain();
			for ( var key in hiddens )
			{
				if ( Ext.getCmp(key) == undefined )
				{
					mainForm.add(
						{
							xtype: 'hidden',
							id: key,
							name: key,
							value: hiddens[key]
						}
					);
				}
				else
				{
					if ( !Ext.isEmpty( Ext.getCmp(key) ) )
					{
						Ext.getCmp(key).setValue(data[key]);
					}
				}
			}	
		}
		catch ( e )
		{
			alert('Exception @ loadHiddens '+e);
		}
	},*/
	loadScreenLabels: function(screenLabels)
	{
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(screenLabels['reporter.comparison.ComparisonTitle']);
		var mainform=this.getDefineconfiguration().getForm();
		var configForm = Ext.getCmp('popup').getForm();
		//var settingsForm = Ext.getCmp('configsettings').getForm();
		var reportForObj = configForm.findField('Report');
		reportForObj.setFieldLabel(screenLabels['reporter.comparison.Reportfor']);
		var criteriaObj = configForm.findField('criteria');
		criteriaObj.setFieldLabel(screenLabels['reporter.comparison.SelectByCriteria']);
		/*var metricRadioObj = configForm.findField('metricRadio');
		metricRadioObj.boxLabelEl.update(screenLabels['reporter.comparison.Metrics']);
		var testRadioObj = configForm.findField('testRadio');
		testRadioObj.boxLabelEl.update(screenLabels['reporter.comparison.Test']);*/

		var testObj = configForm.findField('test');
		testObj.setFieldLabel(screenLabels['reporter.comparison.Test']);
		
		var measureObj = configForm.findField('measure');
		measureObj.setFieldLabel(screenLabels['reporter.comparison.Measure']);
		
		//var compSearchObj = configForm.findField('compSearch');
		//compSearchObj.setFieldLabel(screenLabels['reporter.common.FilterByOptional']);
		
		var compLabelObj = Ext.getCmp('compLabel');
		compLabelObj.setText(screenLabels['reporter.comparison.Component']);
		
		var descLabelObj = Ext.getCmp('descLabel');
		descLabelObj.setText(screenLabels['reporter.comparison.Descriptor']);
		
		var addObj = Ext.getCmp('addtogrid');
		addObj.setText(screenLabels['reporter.common.Add']);
		
		/***********Timeline Settings STARTS****************/
		
		var er_timelineObj = mainform.findField('er_timeline');
		var er_stdateObj = mainform.findField('er_stdate');
		var er_enddateObj = mainform.findField('er_enddate');
		var er_sthrObj = mainform.findField('er_sthr');
		var er_endhrObj = mainform.findField('er_endhr');
		var er_modeObj = mainform.findField('er_mode');
		/***********Timeline Settings ENDS****************/
		var submitObj = Ext.getCmp('submit');
		//submitObj.setText(screenLabels['reporter.common.SUBMIT']);
	},
	enableOrDisableTools: function(params)
	{
		for ( var id in params )
		{
			if ( !Ext.isEmpty( Ext.getCmp(id) ) )
			{
				Ext.getCmp(id).setDisabled(params[id]);
			}
		}
	},
	hideTools:function()
	{
 		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //data
			false, //csv
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
		);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
 	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	defineConfigurationPOPUP:function(panel){
		if (Ext.get('linkId')) {
            Ext.get('linkId').hide();
        }
		var buttonConObj= Ext.getCmp('defineconfiguration');
		buttonConObj.setDisabled(true);
		var selectionDetails=Ext.getCmp("selectionDetails");
		if (!Ext.isEmpty(selectionDetails) && !selectionDetails.isHidden()) {
			this.toggleForm(selectionDetails);
		}
		Ext.getCmp('popup').show();
	},
	addToGrid:function(c)
	{		
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}		
		//this code is for demo please remove in development
		var configForm = Ext.getCmp('popup').getForm();
		var me = this;
		var formObj = this.getDefineconfigurationpopup().getForm();
		//var report = formObj.findField('displayname').getValue()+(tmpIdx++);
		var gridObj = Ext.getCmp('configdatas');
		var gridStore = gridObj.getStore();
		var compObj = configForm.findField('component');
		
		var componentVal = configForm.findField('component').getValue();
		var cmpStore = compObj.getStore();
		var testStore = configForm.findField('test').getStore();
		var testObj = configForm.findField('test');
		var measureObj = configForm.findField('measure');
		var metricObj = configForm.findField('metric');
		var descObj = configForm.findField('Descriptor');
		var reportForVal = configForm.findField('Report').getValue();
		var zoneVal = configForm.findField('zone').getValue();
		var segmentVal = configForm.findField('segment').getValue();
		var serviceVal = configForm.findField('service').getValue();
		var compName = '';
		var compType = '';
		var testName = '';
		var measureName = '';
		var descName = descObj.getValue();
		var descObjTxtFieldValue = '';
		if(Ext.getCmp('descSearchCont').isHidden())
		{
			descObjTxtFieldValue = configForm.findField('descSearch_TxtField').getValue();
			descName = descObjTxtFieldValue.split(',');
		}
		var descTxtEmpty = true;
		if (Ext.getCmp('descSearchCont').isHidden())
		{
			var descArray=configForm.findField('descSearch_TxtField').getValue();
			descArray = descArray.split(',');
			if(descArray!=null && descArray!='undefined' && descArray.length>0)
			{
				for(var k=0;descArray.length>k;k++)
				{
					if(descArray[k].trim() != "" && descArray[k].trim().length > 0)
					{
						descTxtEmpty = false;
					}
				}
			}
		}
		if(Ext.getCmp('descSearchCont').isHidden() && descTxtEmpty){
			Ext.MessageBox.show({
				title: 'Alert',
				msg: 'Descriptor field is not empty',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if(!multiSelectAllvalidation(descName,"")||(descName.length>1 && descName.indexOf('*')>-1))
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Individual and aggregate Descriptor cannot be selected simultaneously',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var getCriteria = Ext.getCmp('criteria').getValue();
		var compIntlVal = '';
		var compTypeIntlVal = '';
		var descIntlVal = '';
		var result = true;
		if ( reportForVal != 'Component' )
		{
			if ( reportForVal == 'Zone' &&  zoneVal == '-1' )
			{
				result = false;
			}
			else if ( reportForVal == 'Segment' && segmentVal == '-1' )
			{
				result = false;
			}
			else if ( reportForVal == 'Service' && serviceVal == '-1' )
			{
				result = false;
			}
		}
		if ( getCriteria == 'Test' )
		{
			if ( testObj.getValue() == '-1' )
			{
				result = false;
			}
			else if ( measureObj.getValue() == '-1' )
			{
				result = false;
			}
		}
		else
		{
			if ( metricObj.getValue == '-1' )
			{
				result = false;
			}
		}
		if ( Ext.isEmpty( componentVal ) || componentVal=='-1' )
		{
			result = false;
		}
		if ( !result )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.requiredParamsMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if((Ext.Array.contains(componentVal,'All')|| Ext.Array.contains(componentVal,'all')) && componentVal.length>1)
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg:  all_individual_alert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}

		if(descName.length==1&&(descName[0] == '-1' || descName[0] == ''|| descName[0] == '*'))
		{
			descName = "-";			
		}
		var remoteURL = '/final/servlet/com.eg.ErRemoteScriptingServlet';
		var params = 'addToGrid=yes';
		params+='&componentVal='+componentVal;
		descName = appConstants.erUtils.specialCharEncode(descName);
		params+='&descName='+descName;
		params+='&getCriteria='+getCriteria;
		params+='&testNameDisp='+appConstants.erUtils.specialCharEncode(Ext.String.htmlEncode(testObj.getRawValue()));
		params+='&measureNameDisp='+appConstants.erUtils.specialCharEncode(Ext.String.htmlEncode(measureObj.getRawValue()));
		params+='&testNameVal='+testObj.getValue();
		params+='&measureNameVal='+measureObj.getValue();
		params+='&metricObj_measureName='+metricObj.getRawValue();
		params+='&appTestVal='+appConstants.testVal;
		params+='&appMeasureVal='+appConstants.measureVal;
		if(gridStore.getCount()>0)
		{
			var gridStoreAry = new Array();
			for ( var k = 0; k < gridStore.getCount(); k++ )
			{
				var tmpData = gridStore.getAt(k).data;
				var gridsObj = new Object();
				gridsObj = {
					Name : tmpData.Name,
					Type : tmpData.Type,
					Test : appConstants.erUtils.specialCharEncode(tmpData.Test),
					Measure : appConstants.erUtils.specialCharEncode(tmpData.Measure),
					Descriptor : appConstants.erUtils.specialCharEncode(tmpData.Descriptor),
					Hiddens : appConstants.erUtils.specialCharEncode(tmpData.Hiddens),
					testVal : tmpData.testVal,
				}
					gridStoreAry.push(gridsObj);
			}//
				params+='&gridStore='+Ext.encode(gridStoreAry);
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		Ext.Ajax.request({
			url: remoteURL,
			params: params,
			async: false,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.hasMultipleTests = false;
				if (!Ext.isEmpty( jsonData ))
				{
					var status = jsonData['status'];
					var hasMultipleTests = jsonData['hasMultipleTests'];
					var gridData = jsonData['gridData'];
					if(status=='success')
					{
						Ext.getCmp('my_formouter').show();
						if(hasMultipleTests=='true')
						{
							appConstants.hasMultipleTests = true;
						}
						if(appConstants.hasMultipleTests)
						{
							if (!isSettingsEnabled)
							{
								me.showConfigDropdown();
							}
							var multipleData = appConstants.publicJSON['graphTypeComboForMultiple'];
							if ( !Ext.isEmpty( multipleData ) )
							{
								Ext.getCmp('graphtype').getStore().loadRawData( multipleData );
								Ext.getCmp('graphtype').setValue( multipleData[0].valueField );
							}
						}
						else
						{
							if (!isSettingsEnabled)
							{
								me.showConfigDropdown();
							}
							 var graphTypeComboData = appConstants.publicJSON['graphTypeCombo'];
							if ( !Ext.isEmpty( graphTypeComboData ) )
							{
								Ext.getCmp('graphtype').getStore().loadRawData( graphTypeComboData );
							}
						}
						gridStore.removeAll();
						gridStore.loadRawData(gridData);
						gridObj.getSelectionModel().selectAll();
						gridObj.doLayout();
						Ext.getCmp('submit').show();
					}
					else
					{
						Ext.MessageBox.show({
							title: 'Alert',
							msg: appConstants.currentSelMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return;
					}
				}
			}
		});
	},
	autoCompareTest:function(){
 			if(appConstants.isCompareTest)
			{
				var gridObj = Ext.getCmp('configdatas');
				var gridStore = gridObj.getStore();
				var hiddensList=appConstants.compareATestHiddens;
				var hidden=hiddensList.split(",");
				for(var k=0;k<hidden.length;k++)
				{
 					var temp=hidden[k];
					var hdParm=temp.split("|");
					var setDescription='-';
					if(hdParm.length>2)
						setDescription=hdParm[2];
				var setTest=hdParm[0].replace('Test','');
				var setMeasure=hdParm[1].replace('_',' ');
				var componentNameList=appConstants.compareATestName;
				var componentName=componentNameList.split(",")
 				var hiddenComParm=appConstants.compareATestHiddenComParm;
				var hiddencomponent=hiddenComParm.split(",");
				var typeList=appConstants.compareATestType;
				var type=typeList.split(",");
				for(var i=0; i<componentName.length; i++)
				{
 					gridStore.add(
									[
										{
											'Name': componentName[i],
											'Type': type[i],
											'Test': setTest,
											'Measure': setMeasure,
											'Descriptor': setDescription,
											'Hiddens': hiddencomponent[i]+'| |'+hdParm[0]+'|'+hdParm[1]+'|',
											'testVal': hdParm[0]
										}
									]);
						}
				}
				Ext.getCmp('my_formouter').show();
				gridObj.getSelectionModel().selectAll();
				gridObj.doLayout();
				Ext.getCmp('submit').show();
 				this.formSubmit();
		}
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('component'),Ext.getCmp('compLabel').text,btn);
	},
	expandMe2:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('Descriptor'),Ext.getCmp('descLabel').text,btn);
	}
});