// JavaScript Document

Ext.Loader.setConfig({
 	enabled:true,
	garbageCollect:true,
	preserveScripts:false,
	disableCaching: false	
});

Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

Ext.application({
		name:'ComplianceEventlog',
		requires:['ComplianceEventlog.view.Main','utilities.TimeLineSave'],
		controllers: ['ComplianceEventlog.controller.Main'],
		appFolder:['../reporter/scripts/ComplianceEventlogApp'],

		launch:function(){
				appConstants.appObj = this;
				appConstants.appController='Main';
				if (Ext.firefoxVersion >= 18) { // To support in FireFox 18
					var noArgs = [];
					Ext.override(Ext.Base, {
						callParent : function(args) {
							var method, superMethod = (method = this.callParent.caller) &&
									(method.$previous || ((method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]));
							try {
							} catch (e) {
							}
							return superMethod.apply(this, args || noArgs);
						}
					});
				};
				var URL = '/final/reporter/ErEventLogViewerJSON.jsp';
				if ( appConstants.formSubmit == 'submit' || appConstants.formSubmit == 'true' )
				{
					isResultloaded = true;
					URL = '/final/servlet/com.eg.ErEventLogController';
					appConstants.defaultParams = 'call=json&' + appConstants.defaultParams+'&sessionID='+appConstants.sessionID+'&eruserid='+appConstants.userID;
				}
				else
				{
					appConstants.defaultload=true;
					appConstants.defaultParams = 'call=json&' + appConstants.defaultParams+"&defaultloadd=defaultload&sessionID="+appConstants.sessionID+'&userID='+appConstants.userID;
				}
			Ext.Ajax.request(
				{
					url: URL,
					params: appConstants.defaultParams,
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode( jsonText );
							appConstants.publicJSON = jsonData;
							Ext.create('Ext.container.Viewport',{
								layout:'fit',
								items:[
									{ 
										xtype:'main'
									}
								]
							});
							Ext.get('loadmask').remove();
						}
					}
				});
			}
	});