Ext.define('ComplianceEventlog.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'}, 
		{selector:'newUtilities', ref:'newUtilities'}, 
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function()
	{
		this.control(
		{
			'main':
			{
				'afterrender':this.afterMainRender
			},
			'main newUtilities':
			{
				'afterrender': this.hideTools
			},
			'MoreOptions': 
			{
            	'afterrender': this.closeMoreOptionButton
            },
			'MoreOptions button[id="moreOptionCloseId_app"]':
			{
				 "click": this.validateAndCloseSettings
			},
			'complianceeventlogmainform combo[id="er_criteria"]':
			{
				'select': this.onSelectCriteria
			},
		   'complianceeventlogmainform combo[id="componontType"]':
			{
				'select': this.onSelectComponentTypeVal
			},
			'complianceeventlogmainform combo[id="er_logType"]':
			{
				'select': this.onSelectLogType
			},
			'complianceeventlogmainform combo[id="er_descriptor"]':
			{
				'select': this.onSelectDescriptor
			},
			'complianceeventlogmainform combo[id="er_eventSource"]':
			{
				'select': this.onSelectEventSource
			},
			'complianceeventlogmainform combo[id="categoryType"]':
			{
				'select': this.onSelectcategoryType
			},
			'eventtype multiselect[id="er_eventType"]':
			{
				'change': this.onSelectEventType
			},
			'complianceeventlogmainform combo[id="er_user"]':
			{
				'select': this.onSelectUser
			},
			'egcomponent multiselect[id="components"]':
			{
				'change': this.onChangeComponents
			},
			'complianceeventlogmainform combo[id="zone"]':
			{
				'select': this.changeSiteCombo
			},
			'complianceeventlogmainform combo[id="subzone"]':
			{
				'select': this.changeSiteCombo
			},
			'egcomponent button[id="expandSelector"]': {
		                'click': this.expandMe
		    },
			'complianceeventlogmainform combo[id="reportGeneration"]':
			{
				'select': this.changeReportType
			},
			'mainform button[id="submit"]':
			{
				'click': this.beforeFormSubmit
			},
			'mainform button[name="save"]':
			{
				 "click": this.modifySchedule
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.componentSearch
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveMe
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printMe
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.showSchedules
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.showFavorites
			},
			'newUtilities > #csvTool > button': 
			{
				'click': this.saveDataInCSVFormat
            },
			'mainform button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            }
		});
	},
	getTimeLinePrams:function()
	{
		var params='er_timeline='+Ext.getCmp('er_timeline').getValue();
		var er_stdate =Ext.getCmp('er_stdate').dataArray; 
		var er_enddate = Ext.getCmp('er_enddate').dataArray;
		var er_sthr =Ext.getCmp('er_sthr').dataArray; 
		var er_endhr = Ext.getCmp('er_endhr').dataArray;
		params+='&er_stdate='+er_stdate;
		params+='&er_sthr='+er_sthr;
		params+='&er_enddate='+er_enddate;
		params+='&er_endhr='+er_endhr;
		params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue()+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin; 	 
		var hiddens=appConstants.publicJSON.hiddens;
		for ( var key in hiddens)
		{
			if ( !Ext.isEmpty(hiddens[key] ) )
			{
				params += '&'+key+'='+encodeURIComponent(hiddens[key]);
			}
		}
		return params;
	},
	changeSiteCombo: function( obj )
	{
		this.clearReportData();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_userOption="+Ext.getCmp('zone').getValue()+'&reportfrom='+appConstants.reportfrom;
		    params += '&er_subzone='+Ext.getCmp('subzone').getValue();
		/*if (appConstants.reportfrom=='Printer Management')
		{ 
			params+='&er_componontType='+Ext.getCmp('componontType').getValue();
		}*/
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj); 
	},		 
	changeService: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	onChangeComponents: function (obj, newValue, oldValue, eOpt)
	{
		this.clearReportData();
 		if(!Ext.isEmpty(newValue))
		{
 			var er_componontTypeval = Ext.getCmp('componontType').getValue();
			var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
			var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+"&changecomp=true"+"&reportfrom="+appConstants.reportfrom+"&er_userOption="+Ext.getCmp('zone').getValue();

			var getComponents = Ext.getCmp('components').getValue();
			for ( var key in getComponents )
			{
				params += '&er_system='+encodeURIComponent( getComponents[key] );
			}
			var hiddens=appConstants.publicJSON.hiddens;
			for ( var key in hiddens)
			{
				if ( !Ext.isEmpty(hiddens[key] ) )
				{
					params += '&'+key+'='+encodeURIComponent(hiddens[key]);
				}
			}
			//this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
		}
	},
	onSelectUser: function (obj)
	{
		this.clearReportData();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+Ext.getCmp('componontType').getValue()+'&er_logType='+encodeURI(Ext.getCmp('er_logType').getValue())+'&er_descriptor='+encodeURIComponent(Ext.getCmp('er_descriptor').getValue())+'&er_user='+encodeURIComponent(Ext.getCmp('er_user').getValue())+"&reportfrom="+appConstants.reportfrom;

		var getComponents = Ext.getCmp('components').getValue();
		for ( var key in getComponents )
		{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		//this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);		
	},
	onSelectEventType: function (obj)
	{
		if(isResultloaded)
		{
			isResultloaded = false;
			return;
		}

		var eventType = Ext.getCmp('er_eventType').getValue();
		if(eventType.length==0)
			return;
		if(eventType.length>1)
		{
			if(eventType.indexOf('-1')>-1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'All Types and particular Event Type are cannot be selected',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				}); 
				this.hideResult();
				this.disableTools();
				return;
			}
		}
        this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();
    	var er_descriptorVal = Ext.getCmp('er_descriptor').getValue();
		var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
		var er_eventTypeVal = mainForm.findField('er_eventType').getValue();
		var er_componontTypeval = Ext.getCmp('componontType').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+'&er_descriptor='+encodeURIComponent(er_descriptorVal)
			+'&er_eventType='+encodeURI(er_eventTypeVal)+"&reportfrom="+appConstants.reportfrom;
		var getComponents = mainForm.findField('components').getValue();
		for ( var key in getComponents )
		{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectcategoryType: function (obj)
	{ 
		this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();
		var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
		var er_componontTypeval = Ext.getCmp('componontType').getValue();
		var er_descriptorVal = Ext.getCmp('er_descriptor').getValue();
		var er_categoryTypeval = Ext.getCmp('categoryType').getValue();	
		var er_eventTypeVal = mainForm.findField('er_eventType').getValue();
		var er_eventSourceval = Ext.getCmp('er_eventSource').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+'&er_descriptor='+encodeURIComponent(er_descriptorVal)
			+"&er_categoryType="+er_categoryTypeval+"&er_eventType="+encodeURI(er_eventTypeVal)+"&er_eventSource="+encodeURI(er_eventSourceval)+"&reportfrom="+appConstants.reportfrom;
		var getComponents = mainForm.findField('components').getValue();
		for ( var key in getComponents )
		{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectDescriptor: function (obj)
	{ 
		this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();		
		var er_descriptorVal = Ext.getCmp('er_descriptor').getValue();
		var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
		var er_componontTypeval = Ext.getCmp('componontType').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+'&er_descriptor='+encodeURIComponent(er_descriptorVal)+"&reportfrom="+appConstants.reportfrom;
		var getComponents = mainForm.findField('components').getValue();
		for ( var key in getComponents )
		{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectEventSource: function (obj) { 
		this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();		
		var er_descriptorVal = Ext.getCmp('er_descriptor').getValue();
		var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
		var er_componontTypeval = Ext.getCmp('componontType').getValue();
		var er_eventTypeval = Ext.getCmp('er_eventType').getValue();
		var er_eventSourceval = Ext.getCmp('er_eventSource').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+'&er_descriptor='+encodeURIComponent(er_descriptorVal)+"&reportfrom="+appConstants.reportfrom+'&er_eventType='+encodeURI(er_eventTypeval)+'&er_eventSource='+encodeURI(er_eventSourceval);
		var getComponents = mainForm.findField('components').getValue();
		for ( var key in getComponents )
	{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectLogType: function (obj) {
		this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();	
		var er_logTypeVal =  Ext.getCmp('er_logType').getValue();
		var er_componontTypeval = Ext.getCmp('componontType').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+"&er_componontType="+er_componontTypeval+'&er_logType='+encodeURI(er_logTypeVal)+"&reportfrom="+appConstants.reportfrom;
		var getComponents = mainForm.findField('components').getValue();
		for ( var key in getComponents )
		{
			params += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		params += "&er_userOption="+Ext.getCmp('zone').getValue();
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectComponentTypeVal: function (obj)
	{  
		this.clearReportData();
		var er_criteria=Ext.getCmp('er_criteria').getValue();
		var params=this.getTimeLinePrams()+'&er_criteria='+er_criteria+"&er_componontType="+obj.getValue()+"&reportfrom="+appConstants.reportfrom;
		if (er_criteria!='System')
		{ 
			params+='&er_userOption='+Ext.getCmp('zone').getValue();
		}
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	onSelectCriteria: function (obj)
	{
		this.clearReportData();
		var params=this.getTimeLinePrams()+'&er_criteria='+obj.getValue()+"&reportfrom="+appConstants.reportfrom;
		this.callAjax('/final/reporter/ErEventLogViewerJSON.jsp',params,obj);
	},
	callAjax:function(url,param,obj)
	{
 		var me=this;
		initLdgMask.show();
		Ext.Ajax.request({
			url:url,
			params:param,
			scope:this,
			success : function(response)
			{
				 appConstants.publicJSON=Ext.decode(response.responseText);
				 appConstants.currentPage = 1;// reset the page values // vengat
				 appConstants.totalRec = 0;
				 customPaging = true;
				 initLdgMask.hide();
				 me.onAjaxSuccess(obj,appConstants.publicJSON);
			},
			failure:function(err)
			{
				Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
			}
		});
	},
	onAjaxSuccess: function(obj, json)
	{
		var mainForm = Ext.getCmp('mainform').getForm();
		if (obj.getId() == 'zone' || obj.getId() == 'subzone' )
		{
			mainForm.findField('subzone').hide();
			var component;
			//if (appConstants.reportfrom!='Printer Management')
			//{
				component = Ext.getCmp('componontType'); 
				component.getStore().clearFilter(true);
				component.getStore().loadRawData(json.componentTypeCombo);
				if(appConstants.reportfrom=='Printer Management')
				   component.setValue(json.componentTypeCombo[0]['valueField']);
				else
				   component.setValue(json.componentTypeCombo[1]['valueField']);
				component.show();
			//}
			component = Ext.getCmp('components');
			var systemcombo = json.systemCombo;
			component.getStore().clearFilter(true);
			component.getStore().loadRawData(systemcombo);
			if (!Ext.isEmpty(systemcombo)) {
				var selVal = new Array();
				for (var key in systemcombo) {
					selVal[selVal.length] = systemcombo[key]['valueField'];
				}
				component.setValue(selVal);
			}else{
				console.log('else part executing here ');
			}
			component.show(); 
			 var selectedData = json['selectedValues'];

			var descObj2 = mainForm.findField('er_descriptor');
			if (!Ext.isEmpty(json['descCombo'])) {
				var descComboData = json['descCombo'];
				descObj2.getStore().clearFilter(true);
				descObj2.getStore().loadRawData(descComboData);
				if (!Ext.isEmpty(selectedData['descSelected'])) {
					descObj1.setValue(selectedData['descSelected']);
				} else {
					descObj2.setValue(descComboData[0]['valueField']);
				}
				} else {
				this.insertNotApplicable(descObj2);
			}
			var er_criteriaVal=Ext.getCmp("er_criteria").getValue();
			var subzoneObj = mainForm.findField('subzone');
			subzoneObj.hide();
			if (er_criteriaVal=='Zone')
			{
				var subzoneComboData = json['subzoneCombo'];
				if ( !Ext.isEmpty(subzoneComboData) )
				{
					subzoneObj.suspendEvents(true);
					subzoneObj.getStore().loadRawData(subzoneComboData);
					if ( !Ext.isEmpty( selectedData['subzoneSelected'] ) )
					{
						subzoneObj.setValue(selectedData['subzoneSelected']);
					}
					else
					{
						subzoneObj.setValue(subzoneComboData[0]['valueField']);
					}
					subzoneObj.resumeEvents();
					subzoneObj.show();
				}
			}
			this.insertNotForDesc();
		} 
		else if (obj.getId() == 'er_criteria')
		{
			mainForm.findField('subzone').hide();
			var component = Ext.getCmp('zone'); 
			if (obj.getValue() != 'System')
			{
				component.setFieldLabel(json.screenLabels.seg_ser_zoneLabel);
				component.getStore().clearFilter(true);
				component.getStore().loadRawData(json.indCriteriaCombo);
				component.setValue(json.indCriteriaCombo[0]['valueField']);
				component.show();
				if (appConstants.reportfrom!='Printer Management')
				{
					component = Ext.getCmp('componontType'); 
					component.getStore().clearFilter(true);
					component.getStore().loadRawData(json.componentTypeCombo);
					component.setValue(json.componentTypeCombo[0]['valueField']);
					component.show();
				}
				component = Ext.getCmp('components');
				var systemcombo = json.systemCombo;
				component.getStore().clearFilter(true);
				component.getStore().loadRawData(systemcombo);
				if (!Ext.isEmpty(systemcombo))
				{
					var selVal = new Array();
					for (var key in systemcombo)
					{
						selVal[selVal.length] = systemcombo[key]['valueField'];
					}
					component.setValue(selVal);
				}
				this.insertNotApplicable(mainForm.findField('components'));
				this.insertNotApplicable(mainForm.findField('componontType'));
				this.insertNotApplicable(mainForm.findField('er_descriptor'));
				component.show();
			}
			else
			{
			    component = Ext.getCmp('componontType'); 
				component.getStore().clearFilter(true);
				component.getStore().loadRawData(json.componentTypeCombo);
                if(appConstants.reportfrom=='Printer Management')
					component.setValue(json.componentTypeCombo[0]['valueField']);
				else
                    component.setValue(json.componentTypeCombo[1]['valueField']);
				
				component = Ext.getCmp('components');
			    var systemcombo = json.systemCombo;
			    component.getStore().clearFilter(true);
			    component.getStore().loadRawData(systemcombo);
			    
				if (!Ext.isEmpty(systemcombo))
				{
					var selVal = new Array();
				    for (var key in systemcombo) 
					{
						selVal[selVal.length] = systemcombo[key]['valueField'];
					}
					component.setValue(selVal);
				}
				 var componentZone = Ext.getCmp('zone'); 
				 componentZone.hide();
			   var descObj = mainForm.findField('er_descriptor');
				if (!Ext.isEmpty(json['descCombo']))
				{
					var descComboData = json['descCombo'];
					descObj.getStore().clearFilter(true);
					descObj.getStore().loadRawData(descComboData);
					descObj.setValue(descComboData[0]['valueField']);
				}
			}
			this.insertNotForDesc();
		} 
		else if (obj.getId() == 'componontType')
		{
			var selectedData = json['selectedValues'];
			var component = Ext.getCmp('components');
			var systemcombo = json['systemCombo'];
			component.getStore().clearFilter(true);
			component.getStore().loadRawData(systemcombo);
			if (!Ext.isEmpty(systemcombo))
			{
				var selVal = new Array();
				for (var key in systemcombo) 
				{
					selVal[selVal.length] = systemcombo[key]['valueField'];
				}
				component.setValue(selVal);
			}
			if (!Ext.isEmpty(json['logTypeCombo']))
			{
				var logTypeComboData = json['logTypeCombo'];
				var logTypeObj = mainForm.findField('er_logType');
				logTypeObj.suspendEvents(true);
				logTypeObj.getStore().loadRawData(logTypeComboData);
				if ( !Ext.isEmpty( selectedData['logTypeSelected'] ) )
				{
					logTypeObj.setValue(selectedData['logTypeSelected']);
				}
				else
				{
					logTypeObj.setValue(logTypeComboData[0]['valueField']);
				}
				logTypeObj.resumeEvents();
			}
			var descObj1 = mainForm.findField('er_descriptor');
			if (!Ext.isEmpty(json['descCombo']))
			{
				var descComboData = json['descCombo'];
				descObj1.getStore().clearFilter(true);
				descObj1.getStore().loadRawData(descComboData);
				if (!Ext.isEmpty(selectedData['descSelected']))
				{
					descObj1.setValue(selectedData['descSelected']);
				} 
				else
				{
					descObj1.setValue(descComboData[0]['valueField']);
				}
			} 
			else
			{
				console.log('Test Not 333 inserting here');
				this.insertNotApplicable(descObj1);
			}
			this.insertNotForDesc();
		}
		else if (obj.getId() == 'er_logType')
		{
			var descObj = mainForm.findField('er_descriptor');
			if (!Ext.isEmpty(json['descCombo']))
			{
				var descComboData = json['descCombo'];
				descObj.getStore().clearFilter(true);
				descObj.getStore().loadRawData(descComboData);
				descObj.setValue(descComboData[0]['valueField']);
			}
			else
			{
				 this.insertNotApplicable(descObj);
			}
			this.insertNotForDesc();
		}
		else if (obj.getId() == 'er_descriptor') 
		{
			var userObj = mainForm.findField('er_user');
			if (!Ext.isEmpty(json['userCombo'])) 
			{
				userObj.getStore().clearFilter(true);
				userObj.getStore().loadRawData(json['userCombo']);
				userObj.setValue(json['userCombo'][0]['valueField']);
			}
			else
			{
				this.insertNotApplicable(userObj);
			}
			var categoryTypeObj = mainForm.findField('categoryType');
			if (!Ext.isEmpty(json['categoryCombo'])) 
			{
				var eventTypeComboData = json['categoryCombo'];
				categoryTypeObj.getStore().loadRawData(eventTypeComboData);
				categoryTypeObj.setValue(eventTypeComboData[0]['valueField']);
			}
			else 
			{
				this.insertNotApplicable(categoryTypeObj);
			}

			var eventTypeObj = mainForm.findField('er_eventType');

			if (!Ext.isEmpty(json['eventCombo'])) {
				var eventTypeComboData = json['eventCombo'];
				eventTypeObj.getStore().loadRawData(eventTypeComboData);
				eventTypeObj.setValue(eventTypeComboData[0]['valueField']);
			} else {
				this.insertNotApplicable(eventTypeObj);
			}
			var er_eventSourceObj = mainForm.findField('er_eventSource');
			if (!Ext.isEmpty(json['eventSourceCombo'])) {
				var eventSourceComboData = json['eventSourceCombo'];
				er_eventSourceObj.getStore().loadRawData(eventSourceComboData);
				er_eventSourceObj.setValue(eventSourceComboData[0]['valueField']);
			} else {
				this.insertNotApplicable(er_eventSourceObj);
			}
    } else if (obj.getId() == 'er_eventSource') {
        var userObj = mainForm.findField('er_user');
        if (!Ext.isEmpty(json['userCombo'])) {
            userObj.getStore().clearFilter(true);
            userObj.getStore().loadRawData(json['userCombo']);
            userObj.setValue(json['userCombo'][0]['valueField']);
        } else {
            this.insertNotApplicable(userObj);
        }
        var categoryTypeObj = mainForm.findField('categoryType');
        if (!Ext.isEmpty(json['categoryCombo'])) {
            var eventTypeComboData = json['categoryCombo'];
            categoryTypeObj.getStore().loadRawData(eventTypeComboData);
            categoryTypeObj.setValue(eventTypeComboData[0]['valueField']);
        } else {
            this.insertNotApplicable(categoryTypeObj);
        }
    } else if (obj.getId() == 'categoryType') {
      var userObj = mainForm.findField('er_user');
        if (!Ext.isEmpty(json['userCombo'])) {
            userObj.getStore().clearFilter(true);
            userObj.getStore().loadRawData(json['userCombo']);
            userObj.setValue(json['userCombo'][0]['valueField']);
        } else {
            this.insertNotApplicable(userObj);
        }
		} else if (obj.getId() == 'er_eventType') {
			var er_eventSourceObj = mainForm.findField('er_eventSource');
			if (!Ext.isEmpty(json['eventSourceCombo'])) {
				var eventSourceComboData = json['eventSourceCombo'];
				er_eventSourceObj.getStore().loadRawData(eventSourceComboData);
				er_eventSourceObj.setValue(eventSourceComboData[0]['valueField']);
			} else {
				this.insertNotApplicable(er_eventSourceObj);
			}
		var categoryTypeObj = mainForm.findField('categoryType');

        if (!Ext.isEmpty(json['categoryCombo'])) {
            var eventTypeComboData = json['categoryCombo'];
            categoryTypeObj.getStore().loadRawData(eventTypeComboData);
            categoryTypeObj.setValue(eventTypeComboData[0]['valueField']);
        } else {
            this.insertNotApplicable(categoryTypeObj);
		} 
		var userObj = mainForm.findField('er_user');
        if (!Ext.isEmpty(json['userCombo'])) {
            userObj.getStore().clearFilter(true);
            userObj.getStore().loadRawData(json['userCombo']);
            userObj.setValue(json['userCombo'][0]['valueField']);
        } else {
            this.insertNotApplicable(userObj);
        }
    } 
	else if (obj.getId() == 'er_user') {
			var categoryTypeObj = mainForm.findField('categoryType');
			if (!Ext.isEmpty(json['categoryCombo']))
			{
				var eventTypeComboData = json['categoryCombo'];
				categoryTypeObj.getStore().loadRawData(eventTypeComboData);
				categoryTypeObj.setValue(eventTypeComboData[0]['valueField']);
			}
			else 
			{
				this.insertNotApplicable(categoryTypeObj);
			}
		}
		else if (obj.getId() == 'components')
		{
			var descObj = mainForm.findField('er_descriptor');
			var selectedData = json['selectedValues'];
			//descObj.suspendEvents(true);
			if (!Ext.isEmpty(json['descCombo'])) 
			{
				var descComboData = json['descCombo'];
				descObj.getStore().clearFilter(true);
				descObj.getStore().loadRawData(descComboData);
				if (!Ext.isEmpty(selectedData['descSelected']))
				{
					descObj.setValue(selectedData['descSelected']);
				}
				else
				{
					descObj.setValue(descComboData[0]['valueField']);
				}
			}
			else
			{
				this.insertNotApplicable(descObj);
				this.insertNotApplicable(mainForm.findField('er_user'));
				this.insertNotApplicable(mainForm.findField('er_eventType'));
				this.insertNotApplicable(mainForm.findField('er_eventSource'));
			}
			var userComboObj = mainForm.findField('er_user');
			if (!Ext.isEmpty(json['userCombo']))
			{
				var userComboData = json['userCombo'];
				userComboObj.getStore().clearFilter(true);
				userComboObj.getStore().loadRawData(userComboData);
				userComboObj.setValue(userComboData[0]['valueField']);
			}
			else
			{
				 this.insertNotApplicable(mainForm.findField('er_user'));
			}
			var categorycomboObj = mainForm.findField('categoryType');
			if (!Ext.isEmpty(json['categoryCombo']))
			{
				var categoryComboData = json['categoryCombo'];
				categorycomboObj.getStore().loadRawData(categoryComboData);
				if (!Ext.isEmpty(selectedData['categorytSelected']))
				{
					categorycomboObj.setValue(selectedData['categorytSelected']);
				}
				else 
				{
					categorycomboObj.setValue(categoryComboData[0]['valueField']);
				}
			}
			var eventComboObj = mainForm.findField('er_eventType');
			if (!Ext.isEmpty(json['eventCombo']))
			{
				var eventComboData = json['eventCombo'];
				eventComboObj.getStore().loadRawData(eventComboData);
				eventComboObj.setValue(eventComboData[0]['valueField']);
			}
			var eventSourceComboObj = mainForm.findField('er_eventSource');
			if (!Ext.isEmpty(json['eventSourceCombo']))
			{
				var eventSourceData = json['eventSourceCombo'];
				eventSourceComboObj.getStore().loadRawData(eventSourceData);
				eventSourceComboObj.setValue(eventSourceData[0]['valueField']);
			} 
       //----------------------------------------------------------------------------------
            var descObj = mainForm.findField('er_descriptor');
			descObj.suspendEvents(true);
			if ( !Ext.isEmpty( json['descCombo'] ) )
			{
				var descComboData = json['descCombo'];
				descObj.getStore().loadRawData( descComboData );
				if ( !Ext.isEmpty( selectedData['descSelected'] ) )
				{
					descObj.setValue(selectedData['descSelected']);
				}
				else
				{
					descObj.setValue(descComboData[0]['valueField']);
					//descObj.fireEvent('select');
				}
			}
			else
			{
				this.insertNotApplicable( descObj );
			}
			descObj.resumeEvents();
			var categoryComboeObj = mainForm.findField('categoryType');
			if ( !Ext.isEmpty( json['categoryCombo'] ) )
			{
				var categoryComboData = json['categoryCombo'];
				categoryComboeObj.suspendEvents(true);
				categoryComboeObj.getStore().loadRawData(categoryComboData);
				if ( !Ext.isEmpty( selectedData['categorytSelected'] ) )
				{
					categoryComboeObj.setValue(selectedData['categorytSelected']);
				}
				else
				{
					categoryComboeObj.setValue(categoryComboData[0]['valueField']);
				}
				categoryComboeObj.resumeEvents();
			}
			else
			{
				this.insertNotApplicable(categoryComboeObj);
			}
        //--------------------------------------------------------------------------------------
		}
	},
	filterMultiselect: function (obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
			obj.toggleTriggger();
       appConstants.erUtils.filterComboStore(obj,Ext.getCmp('component'),appConstants.publicjsonData['systemCombo']);
    },
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),Ext.getCmp('componentLbl').text,btn);
	},
	componentSearch: function( obj )
	{
		var getCriteriaVal = Ext.getCmp('er_criteria').getValue();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();

		// To avoid hitting server while system selection not selected  By gowtham
		if(getCriteriaVal != 'Please select a criteria')
       appConstants.erUtils.filterComboStore(obj,Ext.getCmp('components'),appConstants.publicJSON['systemCombo']);
	},
	showFavorites: function(obj)
	{
		if(this.beforeFormSubmit(obj))
		{
			//to validate all fields
			// by karthikeyan
			/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
			{
				Ext.MessageBox.show({
					title : appConstants.msgTitle,
					msg : 'Chosen timeline not allowed',
					buttons : Ext.Msg.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			} */
			var mainForm = Ext.getCmp('mainform').getForm();
			var er_criteriaVal=mainForm.findField('er_criteria').getValue();
			var params=this.getTimeLinePrams()+'&er_criteria='+er_criteriaVal+"&reportfrom="+appConstants.reportfrom;
			if ( er_criteriaVal != 'System' )
			{
				var zoneVal = mainForm.findField('zone').getValue(); 
				params += '&er_userOption='+encodeURIComponent(zoneVal);
				if (er_criteriaVal=='Zone')
				{
					var subzoneVal = mainForm.findField('subzone').getValue();
					params+='&er_subzone='+encodeURI(subzoneVal);
				}
			}
			params+= '&er_componontType='+mainForm.findField('componontType').getValue();
			params+= '&er_logType='+mainForm.findField('er_logType').getValue();
			
			var components = mainForm.findField('components').getValue();
			for ( var key in components )
			{
				params += '&er_system='+encodeURIComponent(components[key]);
			}
			params+= '&er_descriptor='+mainForm.findField('er_descriptor').getValue();
			params+= '&er_user='+mainForm.findField('er_user').getValue();
			params+= '&er_categoryType='+mainForm.findField('categoryType').getValue();
			params+= '&er_eventType='+mainForm.findField('er_eventType').getValue();
			params+= '&er_eventSource='+mainForm.findField('er_eventSource').getValue();  
			params+= '&forwardto=ErEventLogViewerJSON&call=json&er_option=submit&er_sortOrder=Descending&er_sortBy=EVENT_TYPE';  

				var eventID = Ext.getCmp('eventID').getValue();
				var descKeyword = Ext.getCmp('descKeyword').getValue();
	    if (eventID == 1||eventID == 0) {
					var eventIDs = Ext.getCmp('eventIDs').getValue(); 
					params += "&eventID=" + eventID + "&eventIDs=" + eventIDs + "&descKeyword=" + descKeyword;
	    } else if (eventID == 2) {
					var eventIDFrom = Ext.getCmp('eventIDFrom').getValue();
					var eventIDTo = Ext.getCmp('eventIDTo').getValue();
					params += "&eventID=" + eventID + "&eventIDFrom=" + eventIDFrom + "&eventIDTo=" + eventIDTo + "&descKeyword=" + descKeyword;
				}
		
			var favorite_id =  appConstants.publicJSON["hiddens"]['favorite_id'];
			appConstants.formButtonId = obj.getId();

			var target  = '/final/servlet/com.eg.ErFavoriteC?'+params+'&isSubmit=true&cmd=client'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
    saveDataInCSVFormat: function() 
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return ;
		}
        var s_qryString = "../servlet/egurkha.reporter.SaveInCSVFormat";
        window.location = s_qryString;
    },
	showSchedules: function(obj)
	{
		if(this.beforeFormSubmit(obj))
		{
			//to validate all fields
			// by karthikeyan
			if (Ext.getCmp('er_timeline').getValue() == 'Any')
			{
				Ext.MessageBox.show({
				title : appConstants.msgTitle,
				msg : 'Chosen timeline not allowed',
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
				});
				return;
			}
			var mainForm = Ext.getCmp('mainform').getForm();
			
			var er_criteriaVal=mainForm.findField('er_criteria').getValue();
			var params=this.getTimeLinePrams()+'&er_criteria='+er_criteriaVal+"&reportfrom="+appConstants.reportfrom;
			if ( er_criteriaVal != 'System' )
			{
				var zoneVal = mainForm.findField('zone').getValue(); 
				params += '&er_userOption='+encodeURIComponent(zoneVal);
				if (er_criteriaVal=='Zone')
				{
					var subzoneVal = mainForm.findField('subzone').getValue();
					params+='&er_subzone='+encodeURI(subzoneVal);
				}
			}
			
			params+= '&er_componontType='+mainForm.findField('componontType').getValue();
			params+= '&er_logType='+mainForm.findField('er_logType').getValue();
			
			var components = mainForm.findField('components').getValue();
			for ( var key in components )
			{
				params += '&er_system='+encodeURIComponent(components[key]);
			}

			params+= '&er_descriptor='+mainForm.findField('er_descriptor').getValue();
			params+= '&er_user='+mainForm.findField('er_user').getValue();
			params+= '&er_categoryType='+mainForm.findField('categoryType').getValue();
			params+= '&er_eventType='+mainForm.findField('er_eventType').getValue();
			params+= '&er_eventSource='+mainForm.findField('er_eventSource').getValue();  
			params+= '&forwardto=ErEventLogViewerJSON&call=json&er_option=submit&er_sortOrder=Descending&er_sortBy=EVENT_TYPE';  

		
		         var eventID = Ext.getCmp('eventID').getValue();
		         var descKeyword = Ext.getCmp('descKeyword').getValue();
			  if (eventID == 1 || eventID==0) {
					var eventIDs = Ext.getCmp('eventIDs').getValue(); 
					params += "&eventID=" + eventID + "&eventIDs=" + eventIDs + "&descKeyword=" + descKeyword;
			 }
			 else if (eventID == 2) 
			 {
					var eventIDFrom = Ext.getCmp('eventIDFrom').getValue();
					var eventIDTo = Ext.getCmp('eventIDTo').getValue();
					params += "&eventID=" + eventID + "&eventIDFrom=" + eventIDFrom + "&eventIDTo=" + eventIDTo + "&descKeyword=" + descKeyword;
			}
	   
			params +='&totalRecFound=1'
			var target= '/final/reporter/ErSaveSchedule.jsp?'+params+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	sendMail: function()
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return;
		}
		Ext.widget('sendmail').show();
	},
	saveMe: function()
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(appConstants.publicJSON['PDF_URL']);
	},
	bookletQuery: function(obj)
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var s_qryString =appConstants.publicJSON['PDF_URL'].replace('../reporter/ErHtmlToSavePdf.jsp?','');
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var bookletquery="";
		var mainForm = Ext.getCmp('mainform').getForm();
		
		var er_criteriaVal=mainForm.findField('er_criteria').getValue();
		bookletquery+=this.getTimeLinePrams()+'&er_criteria='+er_criteriaVal+"&reportfrom="+appConstants.reportfrom;
		if ( er_criteriaVal != 'System' )
		{
			var zoneVal = mainForm.findField('zone').getValue(); 
			bookletquery += '&er_userOption='+encodeURIComponent(zoneVal);
			if (er_criteriaVal=='Zone')
			{
				var subzoneVal = mainForm.findField('subzone').getValue();
				bookletquery+='&er_subzone='+encodeURI(subzoneVal);
			}
		}
		
		bookletquery+= '&er_componontType='+mainForm.findField('componontType').getValue();
		bookletquery+= '&er_logType='+mainForm.findField('er_logType').getValue();
		
		var components = mainForm.findField('components').getValue();
		for ( var key in components )
		{
			bookletquery += '&er_system='+encodeURIComponent(components[key]);
		}

 		bookletquery+= '&er_descriptor='+mainForm.findField('er_descriptor').getValue();
		bookletquery+= '&er_user='+mainForm.findField('er_user').getValue();
		bookletquery+= '&er_categoryType='+mainForm.findField('categoryType').getValue();
		bookletquery+= '&er_eventType='+mainForm.findField('er_eventType').getValue();
		bookletquery+= '&er_eventSource='+mainForm.findField('er_eventSource').getValue();  
		bookletquery+= '&forwardto=ErEventLogViewerJSON&call=json&er_option=submit&er_sortOrder=Descending&er_sortBy=EVENT_TYPE';  

            var eventID = Ext.getCmp('eventID').getValue();
            var descKeyword = Ext.getCmp('descKeyword').getValue();
	    if (eventID == 1 || eventID==0) {
			var eventIDs = Ext.getCmp('eventIDs').getValue(); 
			bookletquery += "&eventID=" + eventID + "&eventIDs=" + eventIDs + "&descKeyword=" + descKeyword;
	    } else if (eventID == 2) {
			var eventIDFrom = Ext.getCmp('eventIDFrom').getValue();
			var eventIDTo = Ext.getCmp('eventIDTo').getValue();
			bookletquery += "&eventID=" + eventID + "&eventIDFrom=" + eventIDFrom + "&eventIDTo=" + eventIDTo + "&descKeyword=" + descKeyword;
			}
       bookletquery+="&er_RmDispName="+appConstants.er_RmDispName;
		
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printMe();
	},
	printMe: function()
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var s_qryString='../servlet/com.eg.ErEventLogController?'+appConstants.publicJSON['PRINT_URL']+'&er_option=print';
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	checkResult: function()
	{
		var getResultPanel = this.getMain().getComponent('result');
		if ( getResultPanel.hidden )
		{
			Ext.getCmp('upbutton').setDisabled(true);
		}
		else
		{
			Ext.getCmp('upbutton').setDisabled(false);
		}
	},
	afterMainRender: function()
	{
		this.loadPage();
		var myTitle = appConstants.publicJSON["rm_titleDisplay"];
		if (myTitle!= null && myTitle!= 'undefined')
			this.getMain().setTitle(myTitle);
		var hiddenFields = appConstants.publicJSON["hiddens"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var isFrmFavSchMdfy = false;
        if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) 
		{
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
			Ext.getCmp("reportGeneration").setDisabled(true);
            isFrmFavSchMdfy = true;
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		if ( appConstants.formSubmit == 'submit' && !isFrmFavSchMdfy )
		{
			this.enableTools();
		}
		else
		{
			this.disableTools();
		}
		if(!hideBackButton)
		{
			Ext.getCmp('complianceeventlogmainform').add({
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicJSON['ID']
			});
		}
		var me = this;
		var mainForm =Ext.getCmp('mainform').getForm();
		var jsonData = appConstants.publicJSON;
		if ( !Ext.isEmpty( jsonData ) )
		{
			var selectedData = jsonData['selectedValues'];
			if ( !Ext.isEmpty( jsonData['criteriaCombo'] ) )
			{
				var criteriaComboData = jsonData['criteriaCombo'];
				var er_criteria = mainForm.findField('er_criteria');
				er_criteria.suspendEvents(true);
				er_criteria.getStore().loadRawData(criteriaComboData);
				if ( !Ext.isEmpty( selectedData['criteriaSelected'] ) )
				{
					er_criteria.setValue(selectedData['criteriaSelected']);
				}
				else
				{
					er_criteria.setValue(criteriaComboData[0]['displayField']);
				}
				er_criteria.resumeEvents();
			}
			if ( !Ext.isEmpty( jsonData['indCriteriaCombo'] ) )
			{
				var er_criteriaVal = jsonData.selectedValues.criteriaSelected;
				var indCriteriaComboVal = jsonData['indCriteriaCombo'];
				if ( er_criteriaVal != 'System' )
				{
					var zoneObj = mainForm.findField('zone');
					zoneObj.setFieldLabel(jsonData.screenLabels.seg_ser_zoneLabel);
					
					zoneObj.suspendEvents(true);
					zoneObj.getStore().clearFilter(true);
					zoneObj.getStore().loadRawData(indCriteriaComboVal);
					if ( !Ext.isEmpty( selectedData['indCriteriaSelected'] ) )
					{
						zoneObj.setValue( selectedData['indCriteriaSelected'] );
					}
					else
					{
						zoneObj.setValue( indCriteriaComboVal[0]['valueField'] );
					}
					zoneObj.resumeEvents();
					zoneObj.show();
					if (er_criteriaVal=='Zone')
					{
						var subzoneObj = mainForm.findField('subzone');
						if ( !Ext.isEmpty( jsonData['subzoneCombo'] ) )
						{
							var subzoneComboData = jsonData['subzoneCombo'];
							subzoneObj.suspendEvents(true);
							subzoneObj.getStore().loadRawData(subzoneComboData);
							if ( !Ext.isEmpty( selectedData['subzoneSelected'] ) )
							{
								subzoneObj.setValue(selectedData['subzoneSelected']);
							}
							else
							{
								subzoneObj.setValue(subzoneComboData[0]['valueField']);
							}
							subzoneObj.resumeEvents();
							subzoneObj.show();
						}
					}
				}
			}
			var componentTypeObj = mainForm.findField('componontType');
			//////////////timeline//////////////
			var er_timelineObj = mainForm.findField('er_timeline');
			er_timelineObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['timelineCombo'] ) )
			{
				var timelineComboData = jsonData['timelineCombo'];
				er_timelineObj.getStore().loadRawData( timelineComboData );
				if ( !Ext.isEmpty( jsonData['selectedTimeline'] ) )
				{
					er_timelineObj.setValue(jsonData['selectedTimeline']);
				}
			}
			er_timelineObj.resumeEvents();

			var er_stdateObj = mainForm.findField('er_stdate');
			var er_sthrObj = mainForm.findField('er_sthr');
			var er_enddateObj = mainForm.findField('er_enddate');
			var er_endhrObj = mainForm.findField('er_endhr');
			if ( !Ext.isEmpty( jsonData['startDateForDisplay'] ) )
			{
				er_stdateObj.suspendEvents(true);
				er_stdateObj.setValue(jsonData['startDateForDisplay']);
				er_stdateObj.resumeEvents();
				er_stdateObj.dataArray=jsonData['startDate'];
			}
			if ( !Ext.isEmpty( jsonData['endDateForDisplay'] ) )
			{
				er_enddateObj.suspendEvents(true);
				er_enddateObj.setValue(jsonData['endDateForDisplay']);
				er_enddateObj.resumeEvents();
				er_enddateObj.dataArray=jsonData['endDate'];
			}
			//if ( !Ext.isEmpty( jsonData['timelineHourCombo'] ) )
			{
				var getHoursData = jsonData['timelineHourCombo'];
				er_sthrObj.suspendEvents(true);
				//er_sthrObj.getStore().loadRawData(getHoursData);
				if ( !Ext.isEmpty( jsonData['startHourForDisplay'] ) )
				{
					er_sthrObj.setValue(jsonData['startHourForDisplay']);
				}
				er_sthrObj.resumeEvents();
				er_sthrObj.dataArray=jsonData['startHour'];
				er_endhrObj.suspendEvents(true);
				//er_endhrObj.getStore().loadRawData(getHoursData);
				if ( !Ext.isEmpty( jsonData['endHourForDisplay'] ) )
				{
					er_endhrObj.setValue(jsonData['endHourForDisplay']);
				}
				er_endhrObj.resumeEvents();
				er_endhrObj.dataArray=jsonData['endHour'];
			}
			mgr_stmin=jsonData['startmin'];
			mgr_enmin=jsonData['endmin'];
			//me.changeTimeline();
			updatingAppSettings();
			var reportGenObj = mainForm.findField('reportGeneration');
			reportGenObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['reportGenerationCombo'] ) )
			{
				var reportGenerationComboData = jsonData['reportGenerationCombo'];
				reportGenObj.getStore().loadRawData(reportGenerationComboData);
				if ( !Ext.isEmpty( selectedData['reportGenSelected'] ) )
				{
					reportGenObj.setValue(selectedData['reportGenSelected']);
				}
				else
				{
					reportGenObj.setValue(reportGenerationComboData[0]['valueField']);
				}
				//me.changeReportType();
			}
			reportGenObj.resumeEvents();
			var reportNameObj = mainForm.findField('bgReportName');
			if ( !Ext.isEmpty( selectedData['bgReportName'] ) )
			{
				reportNameObj.suspendEvents(true);
				reportNameObj.setValue(selectedData['bgReportName']);
				reportNameObj.resumeEvents();
			}
			/**********To Load Timeline Settings ENDS*************/
            if ( !Ext.isEmpty( jsonData['componentTypeCombo'] ) )
			{
				var componentTypeComboData = jsonData['componentTypeCombo'];
				componentTypeObj.suspendEvents(true);
				componentTypeObj.getStore().clearFilter(true);
				componentTypeObj.getStore().loadRawData(componentTypeComboData);
				if ( !Ext.isEmpty( selectedData['componontTypeSelected'] ) )
				{
					componentTypeObj.setValue(selectedData['componontTypeSelected']);
				}
				else
				{
					componentTypeObj.setValue(componentTypeComboData[0]['valueField']);
				}
				
				componentTypeObj.resumeEvents();
			}
			else
			{
				me.insertNotApplicable(componentTypeObj);
			}

			if ( !Ext.isEmpty( jsonData['logTypeCombo'] ) )
			{
				var logTypeComboData = jsonData['logTypeCombo'];
				var logTypeObj = mainForm.findField('er_logType');
				logTypeObj.suspendEvents(true);
				logTypeObj.getStore().loadRawData(logTypeComboData);
				if ( !Ext.isEmpty( selectedData['logTypeSelected'] ) )
				{
					logTypeObj.setValue(selectedData['logTypeSelected']);
				}
				else
				{
					logTypeObj.setValue(logTypeComboData[0]['valueField']);
				}
				logTypeObj.resumeEvents();
			}
			var categoryComboeObj = mainForm.findField('categoryType');
			/*var descObj = mainForm.findField('er_descriptor');
			descObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['descCombo'] ) )
			{
				var descComboData = jsonData['descCombo'];
				descObj.getStore().loadRawData( descComboData );
				if ( !Ext.isEmpty( selectedData['descSelected'] ) )
				{
					descObj.setValue(selectedData['descSelected']);
				}
				else
				{
					descObj.setValue(descComboData[0]['valueField']);
					
					//descObj.fireEvent('select');
				}
			}
			else
			{
				me.insertNotApplicable( descObj );
			}
			descObj.resumeEvents();
			  if ( !Ext.isEmpty( jsonData['categoryCombo'] ) )
			{
				var categoryComboData = jsonData['categoryCombo'];
				categoryComboeObj.suspendEvents(true);
				categoryComboeObj.getStore().loadRawData(categoryComboData);
				if ( !Ext.isEmpty( selectedData['categorytSelected'] ) )
				{
					categoryComboeObj.setValue(selectedData['categorytSelected']);
				}
				else
				{
					categoryComboeObj.setValue(categoryComboData[0]['valueField']);
				}
				categoryComboeObj.resumeEvents();
			}
			else
			{
				me.insertNotApplicable(categoryComboeObj);
			}

			var userObj = mainForm.findField('er_user');
			userObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['userCombo'] ) )
			{
				var userComboData = jsonData['userCombo'];
				userObj.getStore().loadRawData(userComboData);
				if ( !Ext.isEmpty( selectedData['userSelected'] ) )
				{
					userObj.setValue(selectedData['userSelected']);
				}
				else
				{
					userObj.setValue(userComboData[0]['valueField']);
				}
			}
			else
			{
				me.insertNotApplicable( userObj );
			}
			userObj.resumeEvents();

			var eventTypeObj = mainForm.findField('er_eventType');
			eventTypeObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['eventCombo'] ) )
			{
				var eventTypeComboData = jsonData['eventCombo'];
				
				eventTypeObj.getStore().loadRawData(eventTypeComboData);
				if ( !Ext.isEmpty( selectedData['eventSelected'] ) )
				{
					eventTypeObj.setValue( selectedData['eventSelected'] );
				}
				else
				{
					eventTypeObj.setValue(eventTypeComboData[0]['valueField']);
				}
			}
			else
			{
				me.insertNotApplicable(eventTypeObj);
			}
			eventTypeObj.resumeEvents();

			var er_eventSourceObj = mainForm.findField('er_eventSource');
			er_eventSourceObj.suspendEvents(true);
			if ( !Ext.isEmpty( jsonData['eventSourceCombo'] ) )
			{
				var eventSourceComboData = jsonData['eventSourceCombo'];
				er_eventSourceObj.getStore().loadRawData(eventSourceComboData);
				if ( !Ext.isEmpty( selectedData['eventSourceSelected'] ) )
				{
					er_eventSourceObj.setValue(selectedData['eventSourceSelected'])
				}
				else
				{
					er_eventSourceObj.setValue(eventSourceComboData[0]['valueField']);
				}
			}
			else
			{
				me.insertNotApplicable(er_eventSourceObj);
			}
			er_eventSourceObj.resumeEvents();
*/
			var array=new Array();
			array.push({
				displayField:'Loading...',
				valueField:'-1'
			});
			/*var comp=mainForm.findField('er_descriptor');
			comp.getStore().loadRawData(array);
			comp.setValue('-1');
			comp=mainForm.findField('er_user');
			comp.getStore().loadRawData(array);
			comp.setValue('-1');
			comp=mainForm.findField('categoryType');
			comp.getStore().loadRawData(array);
			comp.setValue('-1');
			comp=mainForm.findField('er_eventType');
			comp.getStore().loadRawData(array);
			comp.setValue('-1');
			comp=mainForm.findField('er_eventSource');
			comp.getStore().loadRawData(array);
			comp.setValue('-1');
			array=null;
			delete array;*/

			var componentLbl = Ext.getCmp('componentLbl');
			componentLbl.setText(jsonData['reporter.compliance.eventlog.System']);
			var componentsObj=Ext.getCmp('components'); 
			var systemcombo = jsonData['systemCombo'];
			componentsObj.getStore().loadRawData(systemcombo);
			if ( !Ext.isEmpty( systemcombo ) )
			{
				var selVal = new Array();
				var systemSelected =selectedData['systemSelected']
 
				if ( !Ext.isEmpty( selectedData['systemSelected'] ) )
				{
					componentsObj.setValue(selectedData['systemSelected']);  }
				else
				{
					componentsObj.setValue(systemcombo[0]['valueField']); 
				}
			}
			else
			{
				me.insertNotApplicable(componentsObj);
			}
			/**********To Load Timeline Settings STARTS*************/
			var hasData=false;
			if ( !Ext.isEmpty( jsonData['RESULTS'] )  && from_schedule ==null && fromFavoriteModify == null)
			{
				var resultsData = jsonData['RESULTS'];
				var otherInfo = resultsData['OTHER_INFO'];
				var tableResultData = resultsData['TABLE_RESULT'];
				if ( !Ext.isEmpty( tableResultData ) )
				{
					var dataPageNo = parseInt(otherInfo['dataPageNo']);// current page no
					var isRangeNeed = otherInfo['isRangeNeed'];
					if(isRangeNeed != 'true' && dataPageNo == 1)
					{
						customPaging =false;
						me.loadTableTemplate( tableResultData );
					}
					me.enableTools();
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
				}
				var gridResultData = resultsData['GRID_RESULTS'];
				if ( !Ext.isEmpty( gridResultData ) )
				{
					hasData=true;	
					me.loadGrid(gridResultData);
					me.loadOverAllPageNavigation(otherInfo);
					fromPerBtn = false;
				}
			}
			if(!hasData && (appConstants.formSubmit=="true"))
			{
				me.getNomeasurepanel().show();
				me.disableTools();
			}
			initLdgMask.hide();
		}

		if ( !Ext.isEmpty( jsonData['screenLabels'] ) )
		{
			me.loadScreenLabels( jsonData['screenLabels'] );
		}
		if ( !Ext.isEmpty( jsonData['hiddens'] ) )
		{
			me.loadHiddens( jsonData['hiddens'] );
		}
		var selectedData = jsonData['selectedValues'];//Selected Values
       //For Description Value Setting 	
		var descObj = mainForm.findField('er_descriptor');
        
		if (!Ext.isEmpty(jsonData['descCombo'])) 
		{
            var descComboData = jsonData['descCombo'];
			descObj.getStore().clearFilter(true);
            descObj.getStore().loadRawData(descComboData);
            if (!Ext.isEmpty(selectedData['descSelected'])) 
			{
                descObj.setValue(selectedData['descSelected']);
            }
			else
			{
                descObj.setValue(descComboData[0]['valueField']);
            }
        } 
		else
		{
			console.log('Test Not inserting here');
            this.insertNotApplicable(descObj);
        }
		//For User Value Setting 
		var userComboObj = mainForm.findField('er_user');
        
		if (!Ext.isEmpty(jsonData['userCombo'])) 
		{
            var userComboData = jsonData['userCombo'];
            userComboObj.getStore().clearFilter(true);
            userComboObj.getStore().loadRawData(userComboData);
            if (!Ext.isEmpty(selectedData['userSelected'])) 
			{
                userComboObj.setValue(selectedData['userSelected']);
            }
			else 
			{
                 userComboObj.setValue(userComboData[0]['valueField']);;
            }
        }
		else
		{
			console.log('Test Not inserting here user Combo');
			 this.insertNotApplicable(userComboObj);
		}
		//For Category Value Setting
		var categorycomboObj = mainForm.findField('categoryType');
        
		if (!Ext.isEmpty(jsonData['categoryCombo'])) 
		{
            var categoryComboData = jsonData['categoryCombo'];
            categorycomboObj.getStore().loadRawData(categoryComboData);
            
			if (!Ext.isEmpty(selectedData['categorytSelected'])) 
			{
                categorycomboObj.setValue(selectedData['categorytSelected']);
            }
			else 
			{
                categorycomboObj.setValue(categoryComboData[0]['valueField']);
            }
        }
		else
		{
			 console.log('Test Not inserting here Category');
			 this.insertNotApplicable(categorycomboObj);
		}
		//For Event 
		var eventComboObj = mainForm.findField('er_eventType');
        if (!Ext.isEmpty(jsonData['eventCombo'])) 
		{
            var eventComboData = jsonData['eventCombo'];
            eventComboObj.getStore().loadRawData(eventComboData);
            eventComboObj.setValue(eventComboData[0]['valueField']);
			if (!Ext.isEmpty(selectedData['eventSelected']))
			{
                eventComboObj.setValue(selectedData['eventSelected']);
            }
			else 
			{
                eventComboObj.setValue(eventComboData[0]['valueField']);
            }
        }
		else
		{
			 console.log('Test Not inserting here event combo');
			 this.insertNotApplicable(eventComboObj);
		}
		//For Source 
		var eventSourceComboObj = mainForm.findField('er_eventSource');
        if (!Ext.isEmpty(jsonData['eventSourceCombo'])) 
		{
            var eventSourceData = jsonData['eventSourceCombo'];
            eventSourceComboObj.getStore().loadRawData(eventSourceData);
            eventSourceComboObj.setValue(eventSourceData[0]['valueField']);
            if (!Ext.isEmpty(selectedData['eventSourceSelected'])) 
			{
                eventSourceComboObj.setValue(selectedData['eventSourceSelected']);
            }
			else 
			{
                eventSourceComboObj.setValue(eventSourceData[0]['valueField']);
            }
       }
	   else
	   {
           this.insertNotApplicable(eventSourceComboObj);
	   }
	   this.loadSettingData();
	},
	changeReportType: function( obj )
	{
		this.clearReportData();
		var mainForm =Ext.getCmp('mainform').getForm();
		var getReportVal = mainForm.findField('reportGeneration').getValue();
		var bgReportNameObj = mainForm.findField('bgReportName');
		if ( getReportVal == 'background' )
		{
			bgReportNameObj.show();
		}
		else if ( getReportVal == 'background-csv')
		{
			bgReportNameObj.show();
		}
		else
		{
			bgReportNameObj.hide();
		}
	},
	changeTimeline: function( obj )
	{
		try
		{
			var mainForm =Ext.getCmp('mainform').getForm();
			var er_timelineVal = mainForm.findField('er_timeline').getValue();
			var er_stdateObj = mainForm.findField('er_stdate');
			var er_enddateObj = mainForm.findField('er_enddate');
			var er_sthrObj = mainForm.findField('er_sthr');
			var er_endhrObj = mainForm.findField('er_endhr');
			if ( er_timelineVal == 'Any' )
			{
				er_stdateObj.setDisabled(false);
				er_enddateObj.setDisabled(false);
				er_sthrObj.setDisabled(false);
				er_endhrObj.setDisabled(false);
			}
			else
			{
				er_stdateObj.setDisabled(true);
				er_enddateObj.setDisabled(true);
				er_sthrObj.setDisabled(true);
				er_endhrObj.setDisabled(true);
			}
			if ( !Ext.isEmpty( obj ) )
			{
				this.formSubmit( obj );
				//this.disableSubmit();
				this.hideResult();
				this.disableTools();
			}
		}
		catch ( e )
		{
			alert('[Exception] @ changeTimeline '+e);
		}
	},
	disableSubmit: function()
	{
		Ext.getCmp('submit').setDisabled(true);
	},
	enableSubmit: function()
	{
		Ext.getCmp('submit').setDisabled(false);
	},
	changeCriteria: function( obj )
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var getCriteriaVal = mainForm.findField('er_criteria').getValue();
		var zoneObj = mainForm.findField('zone');
		var subzoneObj = mainForm.findField('subzone');
 		if ( getCriteriaVal != '-1' && getCriteriaVal != 'System' )
		{
			if ( !Ext.isEmpty( obj ) )
			{
				this.setLoadingMask( zoneObj );
 			}
			zoneObj.show(); 
		}
		else
		{
			if ( getCriteriaVal != 'System' )
			{
				this.insertNotApplicable(mainForm.findField('components'));
			}
			zoneObj.hide();
 		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},	
	changeComponents: function( obj, record, item, index, e, eOpts )
	{
 		var mainForm =Ext.getCmp('mainform').getForm();
		var getCompVal = mainForm.findField('components').getValue();
		if ( getCompVal.length == 1 && getCompVal == '-1' )
		{
			return;
		}
		else
		{
			if ( !Ext.isEmpty( obj ) )
			{
				this.setLoadingMask(mainForm.findField('er_descriptor'));
				//this.disableSubmit();
				this.formSubmit( obj );
				this.hideResult();
				this.disableTools();
			}
		}
	},
	changeEventSource: function ( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changecategoryType: function ( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changeEventType: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			this.setLoadingMask(Ext.getCmp('er_eventSource'));
			//this.disableSubmit();
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changeUser: function( obj )
	{
		if ( !Ext.isEmpty( obj ) )
		{
			var mainForm =Ext.getCmp('mainform').getForm();
			this.setLoadingMask(mainForm.findField('er_eventType'));
			this.setLoadingMask(mainForm.findField('er_eventSource'));
			//this.disableSubmit();
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changeDescriptor: function ( obj )
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var getDescVal = mainForm.findField('er_descriptor').getValue();
		var er_userObj = mainForm.findField('er_user');
		var er_eventTypeObj = mainForm.findField('er_eventType');
		var er_eventSourceObj = mainForm.findField('er_eventSource');
		var categoryComboeObj = mainForm.findField('categoryType');
		if ( getDescVal == '-1' && !Ext.isEmpty( obj ) )
		{
			this.insertNotApplicable( er_userObj );
			this.insertNotApplicable( er_eventTypeObj );
			this.insertNotApplicable( er_eventSourceObj );
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.setLoadingMask(er_userObj);
			this.setLoadingMask(er_eventTypeObj);
			this.setLoadingMask(er_eventSourceObj);
			this.setLoadingMask(categoryComboeObj);
			//this.disableSubmit();
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changeLogType: function( obj )
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var getLogTypeVal = mainForm.findField('er_logType').getValue();
		var getComponentVal = mainForm.findField('components').getValue();
		if ( getComponentVal.length == 1 && getComponentVal ==  '-1' && !Ext.isEmpty( obj ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.selectSystem,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if ( getLogTypeVal != '-1' )
		{
			this.setLoadingMask(mainForm.findField('er_descriptor'));
			//this.disableSubmit();
		}
		else
		{
			this.insertNotApplicable(mainForm.findField('er_descriptor'));
			this.insertNotApplicable(mainForm.findField('er_user'));
		}
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	changecomponontTypeval: function( obj )
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var getcomponentTypeVal = mainForm.findField('componontType').getValue();

	/*	var getComponentVal = mainForm.findField('components').getValue();
		if ( getComponentVal.length == 1 && getComponentVal ==  '-1' && !Ext.isEmpty( obj ) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: appConstants.selectSystem,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}*/
		/*if ( getcomponentTypeVal == '-1' )
		{
			this.insertNotApplicable(mainForm.findField('componontType'));
			//this.disableSubmit();
		}*/
		
		if ( !Ext.isEmpty( obj ) )
		{
			this.formSubmit( obj );
			this.hideResult();
			this.disableTools();
		}
	},
	setLoadingMask: function( obj )
	{
		obj.suspendEvents(true);
		obj.getStore().removeAll();
		obj.setValue('Loading ...');
		obj.resumeEvents();
	},
	getMeassageBox: function(obj)
	{
  		Ext.MessageBox.show({
			title: 'Alert',
			msg: obj.getStore().getAt(0).get('displayField'),
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		}); 
	},
	beforeFormSubmit: function( object )
	{
 		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
        var starthr = mainForm.findField('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = mainForm.findField('er_enddate').getValue();
        var endhr = mainForm.findField('er_endhr').getValue();
        enddate.setHours(endhr);
 		if (!checkDateTime(startdate, enddate)) 
		{
            return;
        }
		var resultObj = this.getMain().getComponent('result');
		if(!keepResult)
		{
			// Reseting Values
			appConstants.currentPage = 1;
			appConstants.totalRec = 0;
			customPaging = true;
			if(object.id!=undefined && object.id=='submit')
			{
				resultObj.removeAll();
			}
		}
	
		var obj=mainForm.findField('zone');
		var erCriteriaObj = mainForm.findField('er_criteria');

 		if (erCriteriaObj.getRawValue()!='System' && (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1))
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('componontType');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('components');
		if (obj.getValue()=='-1')
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('er_logType');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('er_descriptor');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('er_user');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('categoryType');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);
			return;
		}
		obj=mainForm.findField('er_eventType');
		var eventType = Ext.getCmp('er_eventType').getValue();
		if(eventType.length>1)
		{
			if(eventType.indexOf('-1')>-1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'All Types and particular Event Type are cannot be selected',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				}); 
				return;
			}
		}
		if (obj.getValue()=='Not Applicable' || obj.getValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		}
		obj=mainForm.findField('er_eventSource');
		if (obj.getRawValue()=='Not Applicable' || obj.getRawValue().indexOf("Please select")>-1)
		{
			this.getMeassageBox(obj);return;
		} 
		if ( object.name == 'submit' && this.validateSettings() && this.validateSetting())
		{
			this.formSubmit(object);
		}
		else if(object.id=='favImg' || object.id == 'scheduleImg')
		{

			return true;
		}
		else
		{
			return ;
		}
	} ,
	checkFields: function()
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var descVal = mainForm.findField('er_descriptor').getValue();
		var userVal = mainForm.findField('er_user').getValue();
		var eventVal = mainForm.findField('er_eventType').getValue();
		var eventSourceVal = mainForm.findField('er_eventSource').getValue();
		if ( descVal == 'Loading...' || userVal == 'Loading...' || eventVal == 'Loading...' || eventSourceVal == 'Loading...' )
		{
			return false;
		}
		else
		{
			return true;
		}
	},
	modifySchedule: function( obj )
	{
		// by karthikeyan
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
					title : appConstants.msgTitle,
					msg : 'Chosen timeline not allowed',
					buttons : Ext.Msg.OK,
					icon: Ext.MessageBox.WARNING
			});
			return;
		}
		var me = this;
		var mainForm = Ext.getCmp('mainform').getForm();

		var genQueryString = '';
		var isCriteria = false;
		var isZone = false;
		var isSegment = false;
		var isService = false;
		var isSystem = false;
		var isLogType = false;
		var isSubZone = false;
		var isDescriptor = false;
		var isUser = false;
		var isEventType = false;
		var isEventSource = false;
		var isTimeline = false;
		var isSubmit = false;
		var isBackground = false;
		var isForeground = false;
		var componentsObj = mainForm.findField('components');
		var er_criteriaVal = mainForm.findField('er_criteria').getValue();
		//genQueryString += '&er_criteria='+encodeURI(er_criteriaVal);
		var URL = '/final/reporter/ErEventLogViewerJSON.jsp';
		if ( !Ext.isEmpty( obj ) )
		{
			var actionFrom = obj.getId();
			if ( actionFrom == 'er_criteria' )
			{
				isCriteria = true;
			}
			else if ( actionFrom == 'zone' )
			{
				isZone = true;
			}
			else if ( actionFrom == 'segment' )
			{
				isSegment = true;
			}
			else if ( actionFrom == 'service' )
			{
				isService = true;
			}
			else if  ( actionFrom == 'components' || actionFrom == 'componentsSelector' )
			{
				isSystem = true;
			}
			else if ( actionFrom == 'er_logType' )
			{
				isLogType = true;
			}
			else if ( actionFrom == 'subzone' )
			{
				isSubZone = true;
			}
			else if ( actionFrom == 'er_descriptor' )
			{
				isDescriptor = true;
			}
			else if ( actionFrom == 'er_user' )
			{
				isUser = true;
			}
			else if ( actionFrom == 'er_eventType' )
			{
				isEventType = true;
			}
			else if ( actionFrom == 'er_timeline' )
			{
				isTimeline = true;
			}
			else if ( actionFrom == 'er_eventSource')
			{
				isEventSource = true;
			}
			else if ( actionFrom == 'submit' )
			{
				if ( !this.checkFields() )
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: appConstants.requiredParamsMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
				initLdgMask.show();
				isSubmit = true;
				genQueryString += '&er_option=submit';
				URL = '/final/servlet/com.eg.ErEventLogController';
			}
		}
		if ( er_criteriaVal != 'System' )
		{
			var zoneVal = mainForm.findField('zone').getValue(); 
			genQueryString += '&er_userOption='+encodeURIComponent(zoneVal);
			if (er_criteriaVal=='Zone')
			{
				var subzoneVal = mainForm.findField('subzone').getValue();
				genQueryString+='&er_subzone='+encodeURI(subzoneVal);
			}
		}
		var er_eventTypeVal = mainForm.findField('er_eventType').getValue();
		var eventType = Ext.getCmp('er_eventType').getValue();
		if(eventType.length>1)
		{
			if(eventType.indexOf('-1')>-1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'All Types and particular Event Type are cannot be selected',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				}); 
				return;
			}
		}
		var er_logTypeVal = mainForm.findField('er_logType').getValue();
		var er_descriptorVal = mainForm.findField('er_descriptor').getValue();
		var er_userVal  = mainForm.findField('er_user').getValue();
		var er_categoryTypeVal = mainForm.findField('categoryType').getValue()
		var er_eventSourceVal = mainForm.findField('er_eventSource').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var reportGenerationVal = mainForm.findField('reportGeneration').getValue();
		var forwardtoVal = 'ErEventLogViewer';
		if ( reportGenerationVal == 'background' )
		{
			isBackground = true;
			isForeground = false;
			URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
			genQueryString += '&isSubmit=true';
			forwardtoVal = 'ErEventLogViewerJSON';
		}
		else if ( reportGenerationVal == 'background-csv' )
		{
			isBackground = true;
			isForeground = false;
			URL =' ../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV';
			genQueryString += '&isSubmit=true';
			forwardtoVal = 'ErEventLogViewerJSON';
		}
		else
		{
			isBackground = false;
			isForeground = true;
		}
		var bgReportNameVal = mainForm.findField('bgReportName').getValue();

		var er_stdate =Ext.getCmp('er_stdate').dataArray; 
		var er_enddate = Ext.getCmp('er_enddate').dataArray;
		var er_sthr =Ext.getCmp('er_sthr').dataArray; 
		var er_endhr = Ext.getCmp('er_endhr').dataArray;
		var getComponents = mainForm.findField('components').getValue();
		var er_systemVal = '';
		for ( var key in getComponents )
		{
			er_systemVal += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		bgReportNameVal=checkFileName(bgReportNameVal);
		genQueryString += '&'+appConstants.hiddenQStr;
		genQueryString += '&er_criteria='+encodeURI(er_criteriaVal)+'&er_sortOrder=Descending&Previous=null&er_descriptor='+encodeURIComponent(er_descriptorVal)+'&er_enddate='+encodeURI(er_enddate)+'&er_endhr='+encodeURI(er_endhr)+'&er_user='+encodeURIComponent(er_userVal)+'&er_eventType='+encodeURI(er_eventTypeVal)+'&er_stdate='+encodeURI(er_stdate)+'&er_sthr='+encodeURI(er_sthr)+'&er_timeline='+encodeURI(er_timelineVal)+'&er_eventSource='+encodeURI(er_eventSourceVal)+'&er_sortBy=EVENT_TYPE&er_logType='+encodeURI(er_logTypeVal)+er_systemVal+'&er_reportgenration='+encodeURI(reportGenerationVal)+'&bg_reportname='+encodeURI(bgReportNameVal)+'&call=json&forwardto='+encodeURI(forwardtoVal)+'&er_categoryType='+encodeURI(er_categoryTypeVal)+'&er_option=submit';
		genQueryString+= '&er_componontType='+mainForm.findField('componontType').getValue();
		appConstants.queryString = genQueryString;
		if (appConstants.reportfrom!='null')
		{
			appConstants.queryString+='&reportfrom=Printer Management';
		}

		var fromScheduleModify =  appConstants.publicJSON["hiddens"]['fromScheduleModify'];
		var fromFavouriteModify =  appConstants.publicJSON["hiddens"]['fromFavoriteModify'];
		var favorite_id =  appConstants.publicJSON["hiddens"]['favorite_id'];
		var tempParm ="";
            var eventID = Ext.getCmp('eventID').getValue();
            var descKeyword = Ext.getCmp('descKeyword').getValue();
			if (eventID == 1 || eventID==0) {
			var eventIDs = Ext.getCmp('eventIDs').getValue(); 
			tempParm += "&eventID=" + eventID + "&eventIDs=" + eventIDs + "&descKeyword=" + descKeyword;
			} else if (eventID == 2) {
			var eventIDFrom = Ext.getCmp('eventIDFrom').getValue();
			var eventIDTo = Ext.getCmp('eventIDTo').getValue();
			tempParm += "&eventID=" + eventID + "&eventIDFrom=" + eventIDFrom + "&eventIDTo=" + eventIDTo + "&descKeyword=" + descKeyword;
			}
			
 		if ( fromScheduleModify == 'Yes' && obj.getId() == 'save' )
		{ 
			var target = '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString+tempParm;
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else if ( fromFavouriteModify == 'Yes' && obj.getId() == 'save' )
		{ 
			var target = '../servlet/com.eg.ErFavoriteC?'+appConstants.queryString+ '&cmd=client&FavoriteId='+favorite_id+tempParm;
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
	},
	formSubmit: function( obj )
	{
		var me = this;
		var mainForm = Ext.getCmp('mainform').getForm();
		me.getNomeasurepanel().hide();
		var genQueryString = '';
		var isCriteria = false;
		var isZone = false;
		var isSegment = false;
		var isService = false;
		var isSystem = false;
		var isLogType = false;
		var isSubZone = false;
		var iscategoryType=false;
		var iscomponontTypeval=false;
		var isDescriptor = false;
		var isUser = false;
		var isEventType = false;
		var isEventSource = false;
		var isTimeline = false;
		var isSubmit = false;
		var isBackground = false;
		var isForeground = false;
		var componentsObj = mainForm.findField('components');
		var er_criteriaVal = mainForm.findField('er_criteria').getValue();
		var er_componontTypeval = mainForm.findField('componontType').getValue();
		var er_categoryTypeval = mainForm.findField('categoryType').getValue();
		
		var hiddenFields = appConstants.publicJSON["hiddens"];
		var favorite_id = hiddenFields["favorite_id"];
		if (favorite_id != null)
		{
			genQueryString += "&id="+favorite_id+"&er_option=submit";
		}
	    genQueryString +="&er_RmDispName="+appConstants.er_RmDispName;
		//genQueryString += '&er_criteria='+encodeURI(er_criteriaVal);

		var URL = '/final/reporter/ErEventLogViewerJSON.jsp';
		if ( !Ext.isEmpty( obj ) )
		{
			var actionFrom = obj.getId();
			if ( actionFrom == 'er_criteria' )
			{
				isCriteria = true;
			}
			else if ( actionFrom == 'zone' )
			{
				isZone = true;
			}
			else if ( actionFrom == 'segment' )
			{
				isSegment = true;
			}
			else if ( actionFrom == 'service' )
			{
				isService = true;
			}
			else if  ( actionFrom == 'components' || actionFrom == 'componentsSelector' )
			{
				isSystem = true;
			}
			else if ( actionFrom == 'er_logType' )
			{
				isLogType = true;
			}
			else if ( actionFrom == 'subzone' )
			{
				isSubZone = true;
			}
			else if ( actionFrom == 'er_descriptor' )
			{
				isDescriptor = true;
			}
			else if ( actionFrom == 'categoryType' )
			{
				iscategoryType = true;
			}
			else if ( actionFrom == 'componontType' )
			{
				iscomponontTypeval = true;
			}
			else if ( actionFrom == 'er_user' )
			{
				isUser = true;
			}
			else if ( actionFrom == 'er_eventType' )
			{
				isEventType = true;
			}
			else if ( actionFrom == 'er_timeline' )
			{
				isTimeline = true;
			}
			else if ( actionFrom == 'er_eventSource')
			{
				isEventSource = true;
			}
			else if ( actionFrom == 'submit' )
			{
 				if ( !this.checkFields() )
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: appConstants.requiredParamsMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
				initLdgMask.show();
				isSubmit = true;
				genQueryString += '&er_option=submit';
				URL = '/final/servlet/com.eg.ErEventLogController';
			}
		}
 		if ( er_criteriaVal != 'System' )
		{
			genQueryString += '&er_userOption='+mainForm.findField('zone').getValue();
		} 

		var er_eventTypeVal = mainForm.findField('er_eventType').getValue();
		var eventType = Ext.getCmp('er_eventType').getValue();
		if(eventType.length>1)
		{
			if(eventType.indexOf('-1')>-1)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'All Types and particular Event Type are cannot be selected',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				}); 
				return;
			}
		}
		var er_logTypeVal = mainForm.findField('er_logType').getValue();
		var er_descriptorVal = mainForm.findField('er_descriptor').getValue();
		var er_userVal = mainForm.findField('er_user').getValue();
		var er_eventSourceVal = mainForm.findField('er_eventSource').getValue();
		var er_timelineVal = mainForm.findField('er_timeline').getValue();
		var reportGenerationVal = mainForm.findField('reportGeneration').getValue();
        var zoneValTmp          = mainForm.findField('zone').getValue();
        if(zoneValTmp != '--Default--'){
		  genQueryString += '&er_subzone='+mainForm.findField('subzone').getValue();
		}
		var forwardtoVal = 'ErEventLogViewer';
		if ( reportGenerationVal == 'background' )
		{
			isBackground = true;
			isForeground = false;
			URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
			genQueryString += '&isSubmit=true';
			forwardtoVal = 'ErEventLogViewerJSON';
		}
		else if ( reportGenerationVal == 'background-csv' )
		{
			isBackground = true;
			isForeground = false;
			URL = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			genQueryString += '&isSubmit=true';
			forwardtoVal = 'ErEventLogViewerJSON';
		}
		else
		{
			isBackground = false;
			isForeground = true;
		}
		var bgReportNameVal = mainForm.findField('bgReportName').getValue();

		var er_stdate =Ext.getCmp('er_stdate').dataArray; 
		var er_enddate = Ext.getCmp('er_enddate').dataArray;
		var er_sthr =Ext.getCmp('er_sthr').dataArray; 
		var er_endhr = Ext.getCmp('er_endhr').dataArray;

		var getComponents = mainForm.findField('components').getValue();
		var er_systemVal = '';
		for ( var key in getComponents )
		{
			er_systemVal += '&er_system='+encodeURIComponent( getComponents[key] );
		}
		bgReportNameVal=checkFileName(bgReportNameVal);
		genQueryString += '&'+appConstants.hiddenQStr;
		genQueryString += '&er_criteria='+encodeURI(er_criteriaVal)+'&er_sortOrder=Descending&Previous=null&er_descriptor='+encodeURIComponent(er_descriptorVal)+'&er_enddate='+encodeURI(er_enddate)+'&er_endhr='+encodeURI(er_endhr)+'&er_user='+encodeURIComponent(er_userVal)+'&er_eventType='+encodeURI(er_eventTypeVal)+'&er_stdate='+encodeURI(er_stdate)+'&er_sthr='+encodeURI(er_sthr)+'&er_timeline='+encodeURI(er_timelineVal)+'&er_eventSource='+encodeURI(er_eventSourceVal)+'&er_sortBy=EVENT_TYPE&er_logType='+encodeURI(er_logTypeVal)+er_systemVal+'&er_reportgenration='+encodeURI(reportGenerationVal)+'&bg_reportname='+encodeURI(bgReportNameVal)+'&forwardto='+encodeURI(forwardtoVal)+'&reportfrom='+appConstants.reportfrom+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin;
		appConstants.queryString = genQueryString+"&er_componontType="+er_componontTypeval+"&er_categoryType="+er_categoryTypeval;

		var fromSchedule = '';
		if ( !Ext.isEmpty( Ext.getCmp('fromSchedule') ) )
		{
			fromSchedule = Ext.getCmp('fromSchedule').getValue();
			if ( fromSchedule == 'Yes' && obj.getId() == 'submit' )
			{
				document.location = '/final/reporter/ErSaveSchedule.jsp?'+appConstants.queryString;
			}
		}
		genQueryString += "&er_componontType="+er_componontTypeval+"&er_categoryType="+er_categoryTypeval+'&call=json';
		
		var eventID = Ext.getCmp('eventID').getValue();

		var descKeyword = Ext.getCmp('descKeyword').getValue();
		if (eventID == 1 || eventID==0) {
			var eventIDs = Ext.getCmp('eventIDs').getValue();
			genQueryString +="&eventID=" + eventID +  "&eventIDs=" + eventIDs + "&descKeyword=" + descKeyword;

		} else if (eventID == 2) {
			var eventIDFrom = Ext.getCmp('eventIDFrom').getValue();
			var eventIDTo = Ext.getCmp('eventIDTo').getValue();
			genQueryString += "&eventID=" + eventID + "&eventIDFrom=" + eventIDFrom + "&eventIDTo=" + eventIDTo + "&descKeyword=" + descKeyword;
		}
       console.log(genQueryString);
		genQueryString +="&overAllRecCount="+appConstants.totalRec+"&dataPageNo="+appConstants.currentPage;
		Ext.Ajax.request(
		{
			url: URL,
			method: 'POST',
			params: genQueryString,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					keepResult = false;
					if ( !Ext.isEmpty( jsonData ) )
					{
						appConstants.publicJSON = jsonData;
						var selectedData = jsonData['selectedValues'];
						var categoryComboeObj = mainForm.findField('categoryType');

						if ( !Ext.isEmpty( jsonData['categoryCombo'] ) )
						{
							var categoryComboData = jsonData['categoryCombo'];
							categoryComboeObj.suspendEvents(true);
							categoryComboeObj.getStore().loadRawData(categoryComboData);
							if ( !Ext.isEmpty( selectedData['categorytSelected'] ) )
							{
								categoryComboeObj.setValue(selectedData['categorytSelected']);
							}
							else
							{
								categoryComboeObj.setValue(categoryComboData[0]['valueField']);
							}
							categoryComboeObj.resumeEvents();
						}
						else
						{
							me.insertNotApplicable(categoryComboeObj);
						}

						if (actionFrom=='componontType')
						{
							var comp=Ext.getCmp('components');
							comp.getStore().loadRawData(jsonData.systemCombo);
							if(!Ext.isEmpty(selectedData.systemSelected))
							comp.setValue(selectedData.systemSelected);
							else
							{
							comp.setValue(comp.getStore().getAt(0).valueField);
							}
							return;
						}
						if ( isCriteria )
						{
							var indCriteriaComboData = jsonData['indCriteriaCombo'];
							if ( er_criteriaVal== 'Zone' )
							{
								var zoneObj = mainForm.findField('zone');
								zoneObj.suspendEvents(true);
								if ( !Ext.isEmpty( indCriteriaComboData ) )
								{
									zoneObj.getStore().clearFilter(true);
									zoneObj.getStore().loadRawData(indCriteriaComboData);
									zoneObj.setValue(indCriteriaComboData[0]['valueField']);
								}
								else
								{
									me.insertNotApplicable( zoneObj );
								}
								zoneObj.resumeEvents();
							}
							else if ( er_criteriaVal == 'Segment' )
							{
								var segmentObj = mainForm.findField('segment');
								segmentObj.suspendEvents(true);
								if ( !Ext.isEmpty( indCriteriaComboData ) )
								{
									segmentObj.getStore().clearFilter(true);
									segmentObj.getStore().loadRawData(indCriteriaComboData);
									segmentObj.setValue(indCriteriaComboData[0]['valueField']);
								}
								else
								{
									me.insertNotApplicable( segmentObj );
								}
								segmentObj.resumeEvents();
							}
							else if ( er_criteriaVal == 'Service' )
							{
								var serviceObj = mainForm.findField('service');
								serviceObj.suspendEvents(true);
								if ( !Ext.isEmpty( indCriteriaComboData ) )
								{
									serviceObj.getStore().clearFilter(true);
									serviceObj.getStore().loadRawData(indCriteriaComboData);
									serviceObj.setValue(indCriteriaComboData[0]['valueField']);
								}
								else
								{
									me.insertNotApplicable( serviceObj );
								}
								serviceObj.resumeEvents();
							}
							else if ( er_criteriaVal == 'System' )
							{
								var systemComboData = jsonData['systemCombo'];
								rawDataForComponents = jsonData['systemCombo'];
								var compObj = mainForm.findField('components');
								compObj.suspendEvents(true);
								if ( !Ext.isEmpty( systemComboData ) )
								{
									compObj.getStore().loadRawData(systemComboData);
									if ( !Ext.isEmpty( selectedData['systemSelected'] ) )
									{
										compObj.setValue(selectedData['systemSelected']);
									}
									else
									{
										var selVal = new Array();
										for ( var key in systemComboData )
										{
											selVal[selVal.length] = systemComboData[key]['valueField'];
										}
										compObj.setValue(selVal);
									}
									compObj.resumeEvents();
								}

								if ( !Ext.isEmpty( jsonData['logTypeCombo'] ) )
								{
									var logTypeComboData = jsonData['logTypeCombo'];
									var logTypeObj = mainForm.findField('er_logType');
									logTypeObj.suspendEvents(true);
									logTypeObj.getStore().loadRawData(logTypeComboData);
									if ( !Ext.isEmpty( selectedData['logTypeSelected'] ) )
									{
										logTypeObj.setValue(selectedData['logTypeSelected']);
									}
									else
									{
										logTypeObj.setValue(logTypeComboData[0]['valueField']);
									}
									logTypeObj.resumeEvents();
									me.changeDescriptor( mainForm.findField('er_descriptor') );
								}
							}
							if ( er_criteriaVal != 'System' )
							{
								me.insertNotApplicable( mainForm.findField('components') );
								me.insertNotApplicable( mainForm.findField('er_descriptor') );
								me.insertNotApplicable( mainForm.findField('er_user') );
								me.insertNotApplicable( mainForm.findField('er_eventType') );
								me.insertNotApplicable( mainForm.findField('er_eventSource') );
							}
						}
						else if ( isZone || isSegment || isService )
						{
							if ( isZone )
							{
								var subzoneComboData = jsonData['subzoneCombo'];
								if ( !Ext.isEmpty( subzoneComboData ) )
								{
									var subzoneObj = mainForm.findField('subzone');
									subzoneObj.suspendEvents(true);
									subzoneObj.getStore().loadRawData(subzoneComboData);
									subzoneObj.setValue(subzoneComboData[0]['valueField']);
									subzoneObj.resumeEvents();
								}
							}
							var componentsObj = mainForm.findField('components');
							var systemComboData = jsonData['systemCombo'];
							componentsObj.suspendEvents(true);
							if (!Ext.isEmpty( systemComboData ) )
							{
								componentsObj.getStore().loadRawData(systemComboData);
								if ( !Ext.isEmpty( selectedData['systemSelected'] ) )
								{
									componentsObj.setValue(selectedData['systemSelected']);
								}
								else
								{
									var selVal = new Array();
									for ( var key in systemComboData )
									{
										selVal[selVal.length] = systemComboData[key]['valueField'];
									}
									componentsObj.setValue(selVal);
								}
							}
							else
							{
								me.insertNotApplicable(componentsObj);
							}
							componentsObj.resumeEvents();

							if ( !Ext.isEmpty( jsonData['logTypeCombo'] ) )
							{
								var logTypeComboData = jsonData['logTypeCombo'];
								var logTypeObj = mainForm.findField('er_logType');
								logTypeObj.suspendEvents(true);
								logTypeObj.getStore().loadRawData(logTypeComboData);
								if ( !Ext.isEmpty( selectedData['logTypeSelected'] ) )
								{
									logTypeObj.setValue(selectedData['logTypeSelected']);
								}
								else
								{
									logTypeObj.setValue(logTypeComboData[0]['valueField']);
								}
								logTypeObj.resumeEvents();
								me.changeDescriptor();
							}
							me.changeLogType( mainForm.findField('er_logType') );
						}
						else if ( isLogType || isSystem )
						{
							var descObj = mainForm.findField('er_descriptor');
							descObj.suspendEvents(true);
							if ( !Ext.isEmpty( jsonData['descCombo'] ) )
							{
								var descComboData = jsonData['descCombo'];
								descObj.getStore().clearFilter(true);
								descObj.getStore().loadRawData( descComboData );
								descObj.setValue(descComboData[0]['valueField']);
							}
							else
							{
								me.insertNotApplicable( descObj );
								me.insertNotApplicable( mainForm.findField('er_user') );
								me.insertNotApplicable(mainForm.findField('er_eventType'));
								me.insertNotApplicable(mainForm.findField('er_eventSource'));
							}
							descObj.resumeEvents();
							if ( isSystem )
							{
								me.changeDescriptor( mainForm.findField('er_descriptor') );
							}
						}
						else if ( isDescriptor )
						{
							var userObj = mainForm.findField('er_user');
							userObj.suspendEvents(true);
							if ( !Ext.isEmpty( jsonData['userCombo'] ) )
							{
								userObj.getStore().clearFilter(true);
								userObj.getStore().loadRawData(jsonData['userCombo']);
								userObj.setValue(jsonData['userCombo'][0]['valueField']);
							}
							else
							{
								me.insertNotApplicable( userObj );
							}
							userObj.resumeEvents();
							me.formSubmit( userObj );
						}
						else if(iscategoryType)
						{
							var eventTypeObj = mainForm.findField('er_eventType');
							eventTypeObj.suspendEvents(true);
							if ( !Ext.isEmpty( jsonData['eventCombo'] ) )
							{
								var eventTypeComboData = jsonData['eventCombo'];
								eventTypeObj.getStore().loadRawData(eventTypeComboData);
								eventTypeObj.setValue(eventTypeComboData[0]['valueField']);
							}
							else
							{
								me.insertNotApplicable(eventTypeObj);
							}
							eventTypeObj.resumeEvents();
							me.formSubmit( eventTypeObj );
						}
						else if(iscomponontTypeval)
						{
							var componentsObj = mainForm.findField('components');
							var systemComboData = jsonData['systemCombo'];
							componentsObj.suspendEvents(true);
							if (!Ext.isEmpty( systemComboData ) )
							{
								componentsObj.getStore().loadRawData(systemComboData);
								if ( !Ext.isEmpty( selectedData['systemSelected'] ) )
								{
									componentsObj.setValue(selectedData['systemSelected']);
								}
								else
								{
									var selVal = new Array();
									for ( var key in systemComboData )
									{
										selVal[selVal.length] = systemComboData[key]['valueField'];
									}
									componentsObj.setValue(selVal);
								}
							}
							else
							{
								me.insertNotApplicable(componentsObj);
							}
							componentsObj.resumeEvents();
							me.formSubmit( componentsObj );
						}
						else if ( isUser )
						{
							var eventTypeObj = mainForm.findField('er_eventType');
							eventTypeObj.suspendEvents(true);
							if ( !Ext.isEmpty( jsonData['eventCombo'] ) )
							{
								var eventTypeComboData = jsonData['eventCombo'];
								eventTypeObj.getStore().loadRawData(eventTypeComboData);
								eventTypeObj.setValue(eventTypeComboData[0]['valueField']);
							}
							else
							{
								me.insertNotApplicable(eventTypeObj);
							}
							eventTypeObj.resumeEvents();
							me.formSubmit( eventTypeObj );
						}
						else if ( isEventType )
						{
							var er_eventSourceObj = mainForm.findField('er_eventSource');
							er_eventSourceObj.suspendEvents(true);
							if ( !Ext.isEmpty( jsonData['eventSourceCombo'] ) )
							{
								var eventSourceComboData = jsonData['eventSourceCombo'];
								er_eventSourceObj.getStore().loadRawData(eventSourceComboData);
								er_eventSourceObj.setValue(eventSourceComboData[0]['valueField']);
							}
							else
							{
								me.insertNotApplicable(er_eventSourceObj);
							}
							er_eventSourceObj.resumeEvents();
						}
						else if ( isTimeline )
						{
							var er_stdateObj = mainForm.findField('er_stdate');
							var er_sthrObj = mainForm.findField('er_sthr');
							var er_enddateObj = mainForm.findField('er_enddate');
							var er_endhrObj = mainForm.findField('er_endhr');

							if ( !Ext.isEmpty( jsonData['startDate'] ) )
							{
								er_stdateObj.suspendEvents(true);
								er_stdateObj.setValue(jsonData['startDate']);
								er_stdateObj.resumeEvents();
							}
							if ( !Ext.isEmpty( jsonData['endDate'] ) )
							{
								er_enddateObj.suspendEvents(true);
								er_enddateObj.setValue(jsonData['endDate']);
								er_enddateObj.resumeEvents();
							}
							if ( !Ext.isEmpty( jsonData['startHour'] ) )
							{
								er_sthrObj.suspendEvents(true);
								er_sthrObj.setValue(jsonData['startHour']);
								er_sthrObj.resumeEvents();
							}
							if ( !Ext.isEmpty( jsonData['endHour'] ) )
							{
								er_endhrObj.suspendEvents(true);
								er_endhrObj.setValue(jsonData['endHour']);
								er_endhrObj.resumeEvents();
							}
							me.changeComponents(mainForm.findField('components'));
							me.changeDescriptor(mainForm.findField('er_descriptor'));
						}
						else if ( isSubmit && isForeground && !isBackground )
						{
							var resultObj = me.getMain().getComponent('result');
							resultObj.removeAll();
							resultObj.show();
							me.getNomeasurepanel().hide();
							me.getBackGroundPanel().hide();
							if ( isForeground && !isBackground )
							{
								if ( !Ext.isEmpty(jsonData['RESULTS']))
								{
									var resultsData = jsonData['RESULTS'];
									var tableResultData = resultsData['TABLE_RESULT'];
									var gridResultData = resultsData['GRID_RESULTS'];
									var otherInfo = resultsData['OTHER_INFO'];
									if (tableResultData != undefined && gridResultData != undefined)
									{
										var dataPageNo = parseInt(otherInfo['dataPageNo']);// current page no
										var isRangeNeed = otherInfo['isRangeNeed'];
										if(isRangeNeed != 'true' && dataPageNo == 1)
										{
											customPaging =false;
											me.loadTableTemplate( tableResultData );
										}
										me.loadGrid(gridResultData);
										me.loadOverAllPageNavigation(otherInfo);
										me.enableTools();
										fromPerBtn=false;
										Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
									}else
									{
										resultObj.hide();
										me.getNomeasurepanel().show();
										me.disableTools();
									}
									initLdgMask.hide();
								}
								else
								{
										me.getNomeasurepanel().show();
										initLdgMask.hide();
								}
							}
							else
							{
								me.getNomeasurepanel().show();
								initLdgMask.hide();
							}
						}
						else if ( isSubmit && !isForeground && isBackground )
						{
							var backgroundData = jsonData['backgroundResults'];
							var backgroundResultsData = jsonData['backgroundResults'];
							var backgroundResultStatus = backgroundResultsData['status'];
							var backgroundResponseText = backgroundResultsData['backgroundResponseText'];
							var backgroundResponseLink = backgroundResultsData['backgroundResponseLink'];
							var backgroundResponseLinkText = backgroundResultsData['backgroundResponseLinkText'];
							var htmlStr = '';
							if ( backgroundResultStatus == 'success' )
							{								
								htmlStr =  '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResponseLink +'>'+ backgroundResponseLinkText + '</a></div></td></tr></table></td></tr></table>';
							}
							else if ( backgroundResultStatus == 'duplicate' )
							{
								htmlStr =  '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundResponseText+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundResponseLink +'>'+ backgroundResponseLinkText + '</a></div></td></tr></table></td></tr></table>';
							}
							me.getBackGroundPanel().update(htmlStr);
							me.getBackGroundPanel().show();
							initLdgMask.hide();
						}
 					}
					if ( !Ext.isEmpty( jsonData['screenLabels'] ) )
					{
						me.loadScreenLabels( jsonData['screenLabels'] );
					}
					if ( !Ext.isEmpty( jsonData['hiddens'] ) )
					{
						me.loadHiddens( jsonData['hiddens'] );
					}
					me.enableSubmit();
				}
			}
		});
	},
	loadGrid: function( gridResultData )
	{
		activePage = 1;
 		var resultObj = this.getMain().getComponent('result');
		resultObj.show();
 		var gridColumnNames = gridResultData['GRID_COLUMN_NAMES'];
		var logGridObj=Ext.getCmp('loggrid');
		var gridValues=gridResultData['GRID_VALUES'];
		var isPagingHidden;
 		if (gridValues.length<gridPageSize)
			isPagingHidden=true;
		else
			isPagingHidden=false;
		
		if(customPaging)
			isPagingHidden = true;

		if(fromPerBtn)
		{
			activePage = Math.ceil(gridValues.length/gridPageSize);
		}
			
		if (!Ext.isEmpty(logGridObj))
		{
 			logGridObj.getStore().loadRawData(gridResultData['GRID_VALUES']);
		}
		else
		{
			var store=Ext.create('Ext.data.Store', {
					fields:['TYPE', 'DATE','SOURCE','CATEGORY','ID','USER','COMPUTER','DESCRIPTION'],
					proxy : {
						type : 'pagingmemory',
						reader : {
							type : 'json'
						}
					},
					pageSize:gridPageSize,
					autoLoad : true,
					data : gridValues
				});
			var mainDivHeight=document.getElementById("compliance_eventlog").offsetHeight;
			if(gridValues.length < 16)
			{
				mainDivHeight = "auto";
			}
			else
			{
				if(mainDivHeight>100)
				{
					mainDivHeight = mainDivHeight-50;
				}
				else
				{
			  	  mainDivHeight=500;
				}
			}
			resultObj.add({
				xtype:'container',
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				//title :  gridResultData['TITLE'],
				items:[
					{
						xtype:'container',
						html:"<div class='newFont_bold14'>"+ gridResultData['TITLE']+"</div>",
					},
					{
						xtype:'customgrid',
						ui:'newGridPanel',
						id:'loggrid',
						//cls:'gridSkin complainelog',
						//header:{cls:'complaineloghead'},
						margin:'10 0 0 0',
						height:mainDivHeight,
						border:true,
						frame:false,
						autoScroll: true,
						viewConfig: {
							emptyText: 'No records'
						},
						store:store,
						columns : [{
							text: gridColumnNames[0],
							dataIndex: 'TYPE',
							flex:0.3,
							align:'left'
						}, {
							text: gridColumnNames[1],
							dataIndex: 'DATE',
							flex:0.5,
							align:'left'
						},
						{
							text: gridColumnNames[2],
							dataIndex: 'SOURCE',
							flex:0.5,
							align:'left',
							renderer: function(val)
							{

								var genHtml = '';
								for ( var i in val )
								{
									genHtml += val[i]+',';
								}
								if ( !Ext.isEmpty( genHtml ) )
								{
									genHtml = genHtml.substring(0, genHtml.length - 1 );
								}
								return genHtml;
							}
						},
						{
							text: gridColumnNames[3],
							dataIndex: 'CATEGORY',
							flex:0.3
						},
						{
							text:gridColumnNames[4],
							dataIndex: 'ID',
							align:'center',
							flex:0.2,
							//prakash
							renderer:function(value)
							{
								value = Ext.getCmp('loggrid').getDecimalAlignFormat(value);
								return value;
							}
							//
						},
						{
							text: gridColumnNames[5],
							dataIndex: 'USER',
							flex:0.6,
							align:'left',
							renderer: function( val )
							{
								var genHTML = '';
								for ( var key in val )
								{
									genHTML += val[key]+'<br>';
								}
								return genHTML;
							}
						},
						{
							text: gridColumnNames[6],
							dataIndex: 'COMPUTER',
							flex:0.3,
							align:'left',
							renderer: function ( val )
							{
								var genHTML = '';
								for ( var key in val )
								{
									genHTML += val[key]+'<br>';
								}
								return genHTML;
							}
						},
						{
							text: gridColumnNames[7],
							dataIndex: 'DESCRIPTION',
							flex:1,
							align:'left',
							renderer: function ( val )
							{
								var genHTML = '';
								for ( var key in val )
								{
									genHTML += val[key]+'<br>';
								}
								return genHTML;
							}
						}],
						listeners:{
							sortchange:function(ct, column, e, t, eOpts ){
								this.getStore().loadPage(activePage);
							},
						},
						dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							//cls:'pagingtoolbar',
							store: store,
							id:'pageingTool',
							hidden:isPagingHidden,
							//hidden:false,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{  
									activePage = params.currentPage;
								}
							}
						}]
					}]
				});
			logGridObj=Ext.getCmp('loggrid');
			console.log(logGridObj)
			if(fromPerBtn)
				logGridObj.getStore().loadPage(activePage);
		}
	},
	loadOverAllPageNavigation:function(other_Info)
	{
		var me = this;
		var resultObj = this.getMain().getComponent('result');
		var isRangeNeed = other_Info['isRangeNeed'];
		var dataPageNo = parseInt(other_Info['dataPageNo']);// current page no
		var overAllRecCount = parseInt(other_Info['overAllRecCount']);
		var recordPerPage = parseInt(other_Info['recordPerPage']);
		
		var dataPageNo_disp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + 1; 
	
		if(fromPerBtn)
		{
			dataPageNo_disp = dataPageNo_disp+activePage-1
		}
		
		if(isRangeNeed != 'true' && dataPageNo == 1)
		{
			return;
		}
		else
		{
			var nextDisable = false;
			var perDisable = false;
			var totalPage = Math.ceil(overAllRecCount/gridPageSize);
			if(dataPageNo == 1 && dataPageNo_disp == 1)
				perDisable=true;
			if(dataPageNo_disp == totalPage)
				nextDisable=true;
			var labelText = '<div style="text-align:center">Page '+dataPageNo_disp+' of '+totalPage+'<div>';
			var totatLabelText = '<div style="text-align:right";">Total Records: '+overAllRecCount+'</div>';
			appConstants.totalRec = overAllRecCount;
			resultObj.add(
			{
				xtype:'container',
				style:
				{
					'border':'1px solid #C5C4C5',
					'border-top':'0px !important'
				},
				height:28,
				layout: 'column',
				margin: '0 10 10 10',
				padding:'5 0 10 0',
				items:[
				{
					xtype:'container',
					layout: 'hbox',
					columnWidth:.5,
					margin: '0 0 10 0',
					items:[
					{
						xtype:'container',
						width:48,
						margin: '0 0 10 5',
						items:[
						{
							xtype:'button',
							id:'firstPageBtn',
							tooltip: '<b>First Page</b>',
							iconCls: 'al_first_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									infolabel.update('<div style="text-align:center">Page '+1+' of '+totalPage+'</div>');
									
									if(dataPageNo > 1)
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide(); 
										appConstants.currentPage = 1;
										keepResult = true;
										me.beforeFormSubmit(Ext.getCmp('submit'));
									}
									else
									{
										Ext.getCmp('firstPageBtn').setDisabled(true);
										Ext.getCmp('customPer').setDisabled(true);
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(1);
										}
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_previous_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customPer',
							tooltip: '<b>Previous Page</b>',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									var temp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + last; 
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(last == 0 && dataPageNo > 1)
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide(); 
										fromPerBtn = true;
										appConstants.currentPage = this.currentPage-1;
										keepResult = true;
										me.beforeFormSubmit(Ext.getCmp('submit'));
									}
									else
									{
										if(temp == 1)
										{
											Ext.getCmp('customPer').setDisabled(true);
											Ext.getCmp('firstPageBtn').setDisabled(true);
										}
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(last);
										}
									}
								}
							}
						}
						]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'label',
						width:101,
						id:'infolabel',
						html :labelText
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						margin: '0 0 10 0',
						width:48,
						items:[
						{
							xtype:'button',
							iconCls: 'al_next_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customNext',
							tooltip: '<b>Next Page</b>',
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = pageingTool.store.currentPage + 1;
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(next <= Math.ceil(recordPerPage/gridPageSize))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										if(temp == totalPage)
										{
											Ext.getCmp('customNext').setDisabled(true);
											Ext.getCmp('lastPageBtn').setDisabled(true);
										}
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.nextPage();
										}
									}
									else
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide();
										appConstants.currentPage = this.currentPage+1;
										keepResult = true;
										me.beforeFormSubmit(Ext.getCmp('submit'));
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_last_enabled',
							style: {
								background: 'none',
								border: '0px'
							}, 
							id:'lastPageBtn',
							tooltip: '<b>Last Page</b>',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = true;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = Math.ceil(pageingTool.store.totalCount/gridPageSize);
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+totalPage+' of '+totalPage+'</div>');
									
									if(dataPageNo == Math.ceil(overAllRecCount/recordPerPage))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										Ext.getCmp('customNext').setDisabled(true);
										Ext.getCmp('lastPageBtn').setDisabled(true);
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.loadPage(next);
										}
									}
									else
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide();
										appConstants.currentPage = Math.ceil(overAllRecCount/recordPerPage);
										keepResult = true;
										me.beforeFormSubmit(Ext.getCmp('submit'));
									}
								}
							}
						}
						]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						width:25,
						margin: '0 0 10 0',
						items:[
						{
							xtype:'button',
							iconCls: 'al_refresh_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 0 0 0',
							currentPage:dataPageNo,
							listeners:
							{
								click:function()
								{
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage ;
									if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
									{
										pageingTool.store.loadPage(last);
									}
								}
							}
						}]
					}]
				},
				{
					xtype:'container',
					margin: '0 0 0 0',
					columnWidth:.5,
					layout :
					{
						type : 'hbox',
						pack : 'end'
					},
					items:
					{
						xtype:'label',
						html :totatLabelText
					}
				}]
			});
		}
	},
	loadTableTemplate: function (tableResultData)
	{
		var resultObj = this.getMain().getComponent('result');
		var getTableTitle = tableResultData['TITLE'];
		var EVENT_TYPE = tableResultData['EVENT_TYPE'];
		var COUNT = tableResultData['COUNT'];
		var TABLE_VALUES = tableResultData['TABLE_VALUES'];
		var tableTpl = new Ext.XTemplate(
		'<div class="newTable">',
		'<table cellspacing="0" cellpadding="0" border="0" style="margin:10px 0px 0px 0px;">',
		'<thead>',
		//'<tr class="x-grid-row">',
	   // '<th colspan="2" class="x-grid-cell style="width:220;text-align:center"><div class="x-grid-cell-inner" style="overflow:visible;text-align:center">'+getTableTitle+'</div></th>',
		//'</tr>',
		'<tr>',
		'<th style="width:220px;"><div style="overflow:visible;">'+EVENT_TYPE+'</div></th>',
		'<th style="width:220px;"><div align="center" style="overflow:visible;">'+COUNT+'</div></th>',
		'</tr>',
		'</thead>',
		'<tbody>',
		'<tpl for=".">',
		'<tr>',
		'<td style="width:220px"><div>{EVENT_TYPE}</div></td><td style="width:220px"><div align="center" >{COUNT}</div></td>',
		'</tr>',
		'</tpl>',
		'</tbody>',
		'</table>',
		'</div>'
		);
		resultObj.add({
			xtype:'panel',
			//title:"<div class='printOuterBoxHeader'>"+getTableTitle+"</div>",
			//title:getTableTitle,
			//width : '100%',	  
			//layout:{type:'vbox',columns:1,align:'center'},
			//layout:{type:'hbox', align:'left'},
			margin:'10 10 10 10',
			items:[{
				xtype:'container',
				html:"<div class='newFont_bold14'>"+getTableTitle+"</div>",
				id:'titleId',
				style:'text-align:left',
				
			},{
				xtype:'panel',
				frame:false,
				padding:0,
				margin:'0 10 0 0',
				width:500,
				items:[{
					xtype: 'dataview',
					//ui:'newGraphPanel',
					cls:'newTable',
					margin:'0 10 10 0',
					store: new Ext.data.Store({
						fields: ['EVENT_TYPE', 'COUNT'],
						data: TABLE_VALUES
					}),
					tpl: tableTpl
				}]
			}]
		});
	},
	insertNotApplicable: function( obj )
	{
		obj.getStore().removeAll();
		var tmpStore = obj.getStore();
		tmpStore.insert(0,{
			displayField: appConstants.notApplicable,
			valueField: '-1'
		});
		obj.setValue('-1');
	},
	hideResult: function()
	{
		this.getMain().getComponent('result').hide();
	},
	loadHiddens: function( hiddens )
	{
		try
		{
			appConstants.hiddenQStr = '';
			var mainForm = this.getMain();
			appConstants.hiddenJSON = hiddens;
			for ( var key in hiddens )
			{
				if ( !Ext.isEmpty( hiddens[key] ) )
				{
					appConstants.hiddenQStr += '&'+key+'='+encodeURIComponent(hiddens[key]);
				}
			}
		}
		catch ( e )
		{
			alert('Exception @ loadHiddens '+e);
		}
	},
	loadScreenLabels: function( screenLabels )
	{
		var mainForm =Ext.getCmp('mainform').getForm();
 		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.searchBy'] ) )
		{
			var er_criteria = mainForm.findField('er_criteria');
			er_criteria.suspendEvents(true);
			er_criteria.setFieldLabel(screenLabels['reporter.compliance.eventlog.searchBy']);
			er_criteria.resumeEvents();
		}
		var getCriteriaVal = mainForm.findField('er_criteria').getValue();
		mainForm.findField('zone').setFieldLabel(screenLabels.seg_ser_zoneLabel);

		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.Component Type'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.Component Type'];
			var componentsObj = Ext.getCmp('componontType');
			componentsObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.Event Description'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.Event Description'];
			var eventDistObj = Ext.getCmp('descKeyword');
			eventDistObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.IDs'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.IDs'];
			var eventDistObj = Ext.getCmp('eventIDs');
			eventDistObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.From'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.From'];
			var eventDistObj = Ext.getCmp('eventIDFrom');
			eventDistObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.To'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.To'];
			var eventDistObj = Ext.getCmp('eventIDTo');
			eventDistObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.CategoryType'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.CategoryType'];
			var categoryTypeObj = Ext.getCmp('categoryType');
			categoryTypeObj.setFieldLabel(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.System'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.System'];
			var componentsObj = Ext.getCmp('componentLbl');
			componentsObj.setText(getFieldLabel);
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.LogType'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.LogType'];
			var er_logTypeObj = mainForm.findField('er_logType');
			er_logTypeObj.suspendEvents(true);
			er_logTypeObj.setFieldLabel(getFieldLabel);
			er_logTypeObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.Descriptor'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.Descriptor'];
			var er_descriptorObj = mainForm.findField('er_descriptor');
			er_descriptorObj.suspendEvents(true);
			er_descriptorObj.setFieldLabel(getFieldLabel);
			er_descriptorObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.User'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.User'];
			var er_userObj = mainForm.findField('er_user');
			er_userObj.suspendEvents(true);
			er_userObj.setFieldLabel(getFieldLabel);
			er_userObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.EventType'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.EventType'];
			var er_eventTypeObj = mainForm.findField('er_eventType');
			er_eventTypeObj.suspendEvents(true);
			Ext.getCmp('eventtypeLbl').setText(getFieldLabel);
			er_eventTypeObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.compliance.eventlog.EventSource'] ) )
		{
			var getFieldLabel = screenLabels['reporter.compliance.eventlog.EventSource'];
			var er_eventSourceObj = mainForm.findField('er_eventSource');
			er_eventSourceObj.suspendEvents(true);
			er_eventSourceObj.setFieldLabel(getFieldLabel);
			er_eventSourceObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.consolidated.ReportGeneration'] ) )
		{
			var getFieldLabel = screenLabels['reporter.consolidated.ReportGeneration'];
			var reportGenObj = mainForm.findField('reportGeneration');
			reportGenObj.suspendEvents(true);
			reportGenObj.setFieldLabel(getFieldLabel);
			reportGenObj.resumeEvents();
		}
		/***********Timeline Settings STARTS***************/
		if ( !Ext.isEmpty( screenLabels['reporter.common.Timeline'] ) )
		{
			var getFieldLabel = screenLabels['reporter.common.Timeline'];
			var er_timelineObj = mainForm.findField('er_timeline');
			er_timelineObj.suspendEvents(true);
			er_timelineObj.setFieldLabel(getFieldLabel);
			er_timelineObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.From'] ) )
		{
			var getFieldLabel = screenLabels['reporter.common.From'];
			var er_stdateObj = mainForm.findField('er_stdate');
			er_stdateObj.suspendEvents(true);
			er_stdateObj.setFieldLabel(getFieldLabel);
			er_stdateObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.To'] ) )
		{
			var getFieldLabel = screenLabels['reporter.common.To'];
			var er_enddateObj = mainForm.findField('er_enddate');
			er_enddateObj.suspendEvents(true);
			er_enddateObj.setFieldLabel(getFieldLabel);
			er_enddateObj.resumeEvents();
		}
		if ( !Ext.isEmpty( screenLabels['reporter.common.Hr'] ) )
		{
			var getFieldLabel = screenLabels['reporter.common.Hr'];
			var er_sthrObj = mainForm.findField('er_sthr');
			var er_endhrObj = mainForm.findField('er_endhr');
			er_sthrObj.suspendEvents(true);
			er_sthrObj.setFieldLabel(getFieldLabel);
			er_sthrObj.resumeEvents();
			er_endhrObj.suspendEvents(true);
			er_endhrObj.setFieldLabel(getFieldLabel);
			er_endhrObj.resumeEvents();
		}
		/***********Timeline Settings ENDS***************/
	},
	validateSettings: function()
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		var er_usertimeline = appConstants.hiddenJSON['er_usertimeline'];
		var getMaxDaysInMonth = appConstants.hiddenJSON['getMaxDaysInMonth'];
		var tmpStartDate = mainForm.findField('er_stdate').getValue();
		tmpStartDate.setHours(mainForm.findField('er_sthr').getValue());
		var tmpEndDate = mainForm.findField('er_enddate').getValue();
		tmpEndDate.setHours(mainForm.findField('er_endhr').getValue());
		if ( er_usertimeline != '-1' )
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
		{
			Ext.MessageBox.show({
					title: 'Alert',
					msg: dateValidateError,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		var limitforbg = appConstants.hiddenJSON['limitforbg'];
		var reportgenVal = mainForm.findField('reportGeneration').getValue();
		var isSettingsOk = true;
		if ( reportgenVal == 'foreground' )
		{
			if ( !Ext.isEmpty(limitforbg ) )
			{
				if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				}
			}
			return isSettingsOk;
		}
		if ( reportgenVal == 'background' || reportgenVal == 'background-csv')
		{
			var reportName = mainForm.findField('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				mainForm.findField('bgReportName').focus();
				return false;
			}
			else
			{
				return true;
			}
		}
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			this.formSubmit(getButtonObj);
		}
		else
		{
			Ext.getCmp('reportGeneration').setValue('background');
			var reportNameObj = Ext.getCmp('bgReportName');
			reportNameObj.show();
			reportNameObj.focus();
		}
	},
	loadPage:function()
	{
		Ext.getCmp('er_mode').hide();
		initLdgMask.show();
		/*Ext.EventManager.onWindowResize(function()
		{
			Ext.get('configMod').setStyle('left', '');
		});
		var me = this;
		Ext.get('closeSettings').on('click',function()
		{
			var result = me.validateSettings();
			if ( !result )
			{
				return;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		});*/
	},
	resizePanel:function(panel)
	{ //resize the panel
		Ext.getCmp('selectionDetails').setWidth(Ext.getBody().getViewSize().width- 85);
		Ext.EventManager.onWindowResize(function () {
		Ext.getCmp('selectionDetails').setWidth(Ext.getBody().getViewSize().width-85);
		panel.doComponentLayout();
		});
	},
	sendMail:function()
	{
		if(customPaging)
		{
			this.exportDataAlert();
			return;
		}
		Ext.widget('sendmail').show();
	},
	saveFile:function()
	{
		Ext.MessageBox.progress({
			title: 'Downloading',
			value: 5,
			width: 350,
			increment: 15,
			closable: false,
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: '<b>Downloading Please wait...</b>',
			scope: this,
			handler: function()
			{
				this.updateText('Done!');
			}
		//	buttons: Ext.MessageBox.CANCEL
		});
	},
	hideTools:function()
	{
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklet
			);
		Ext.getCmp('favoriteTool').setDisabled(false);
		Ext.getCmp('scheduleTool').setDisabled(false);
	},
	toggleForm:function(obj)
	{
			Ext.getCmp('panelinsidetoggle').show();
			var ornt = Ext.getCmp('mainform');
			if (ornt.isHidden())
			{
				ornt.show();
				Ext.getCmp('selectionDetails').hide();
			}
			else
			{
				ornt.hide();
				Ext.getCmp('selectionDetails').show();
			}
	},
	disableTools: function()
	{
		Ext.getCmp('bookletTool').setDisabled(true);
		Ext.getCmp('saveTool').setDisabled(true);
		Ext.getCmp('printTool').setDisabled(true);
		Ext.getCmp('mailTool').setDisabled(true);
		 Ext.getCmp("csvTool").setDisabled(true);
		//Ext.getCmp('upbutton').setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp('bookletTool').setDisabled(false);
		Ext.getCmp('saveTool').setDisabled(false);
		Ext.getCmp('printTool').setDisabled(false);
		Ext.getCmp('mailTool').setDisabled(false);
        Ext.getCmp("csvTool").setDisabled(false);
		//Ext.getCmp('upbutton').setDisabled(false);
	},
	showConfigDropdown: function() 
	{
        /* var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px" class="settingsfont">More Options</div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings"></div></div>');
        //config dropdown mode
        Ext.create('Ext.container.Container', {
			width: 580,
			padding: 5,
			id: 'configMod',
			//cls: 'configMode_popup',
			ui:'settingsWindowContainer',
			items: [{
				xtype: 'container',
				cls: 'configMode_popupArrow',
				style: {
					'top': '-14px',
					'left': '370px'
				}
			}, {
				xtype: 'container',
				html: tpl.apply(),
				cls:'containerHeader',
				style: {
					'top': '0px',
					'margin': '2px'
				}
			}, {
				xtype: 'MoreOptions',
				parent: this
			}],
            renderTo: 'compliance_eventlog'
        });*/
       this.loadSettingData();
    },
	loadSettingData:function()
	{
        if (appConstants.formSubmit == 'submit' || appConstants.formSubmit == 'true') 
		{
            var favoriteResponse = Ext.Object.fromQueryString(appConstants.defaultParams);
            var moreOptionIDs = ['eventID', 'eventIDFrom', 'eventIDTo', 'eventIDs', 'descKeyword'];
            var eventID = favoriteResponse[moreOptionIDs[0]];

            for (i = 0; i < moreOptionIDs.length; i++)
			{
                var favResMoreVal = favoriteResponse[moreOptionIDs[i]];
                if (favResMoreVal != 'undefined' && favResMoreVal != null && favResMoreVal.trim() != '')
				{
                    Ext.getCmp(moreOptionIDs[i]).setValue(favResMoreVal);
                }
            }
            var moreOptionObj = Ext.getCmp('MoreOptions');

            if (eventID == 1) {
                this.showSpecfic();
            } else if (eventID == 2) {
                this.showRange();
            } else if (eventID == 0) {
                this.hideRange();
            } else {
                console.log('Am Here');
            }
        }
	},
	validateAndCloseSettings:function()
	{
		var eID = Ext.getCmp('eventID').getValue();
		if (eID == '1') 
		{
			if (!Ext.getCmp('eventIDs').isValid())
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Event IDs is invalid',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
				   fn : function(){
						Ext.getCmp('eventIDs').focus();
					}
				});
				 return false;
			}
		}
		else if (eID == '2') 
		{
			var fromID = Ext.getCmp('eventIDFrom').getValue();
			var toID = Ext.getCmp('eventIDTo').getValue();
			if ((fromID == null && toID == null) || (fromID != null && toID != null && toID >= fromID))
			{
					}
			else
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Please enter a valid range',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING,
				   fn : function(){
						if(toID == null)
							Ext.getCmp('eventIDTo').focus();
						else
							Ext.getCmp('eventIDFrom').focus();
					}
				});
				 return false;
			}
		}
		return true;
	},
    closeMoreOptionButton: function() 
	{
		var me = this;
        Ext.get('closeSettings').on('click', function() { 
			me.validateAndCloseSettings();
		});
    },
	validateSetting:function()
	{
		var eID = Ext.getCmp('eventID').getValue();
		if (eID == '1') 
		{
			if (!Ext.getCmp('eventIDs').isValid())
			{
				Ext.MessageBox.show({
				   title: 'Alert',
				   msg: 'Event IDs is invalid',
				   buttons: Ext.MessageBox.OK,
				   icon: Ext.MessageBox.WARNING,
				   fn : function(){
						Ext.getCmp('eventIDs').focus();
					 }
				 });
				 return false;
			}
		}
		else if (eID == '2') 
		{
			var fromID = Ext.getCmp('eventIDFrom').getValue();
			var toID = Ext.getCmp('eventIDTo').getValue();
			if ((fromID == null && toID == null) || (fromID != null && toID != null && toID >= fromID))
			{
			}
			else
			{
				 Ext.MessageBox.show({
				   title: 'Alert',
				   msg: 'Please enter a valid range',
				   buttons: Ext.MessageBox.OK,
				   icon: Ext.MessageBox.WARNING,
				   fn : function(){
						if(toID == null)
							Ext.getCmp('eventIDTo').focus();
						else
							Ext.getCmp('eventIDFrom').focus();
					 }
				 });
				 return false;
			}
		}
		return true;
	},
	insertNotForDesc:function()
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		this.insertNotApplicable(mainForm.findField('er_user'));
		this.insertNotApplicable(mainForm.findField('categoryType'));
		this.insertNotApplicable(mainForm.findField('er_eventType'));
		this.insertNotApplicable(mainForm.findField('er_eventSource'));
	},
	clearReportData:function(){
		//this.getMain().getComponent('result').hide();
	},
	exportDataAlert:function()
	{
		Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Exporting the report may take too long to complete. Choose the Background option to export this report',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},
	showSpecfic: function() {
		console.log('Specific Calling 2');
        Ext.getCmp('eventIDFrom').hide();
        Ext.getCmp('eventIDTo').hide();
        Ext.getCmp('eventIDs').show();
    },
    showRange: function() {
        Ext.getCmp('eventIDFrom').show();
        Ext.getCmp('eventIDTo').show();
        Ext.getCmp('eventIDs').hide();
    },
	hideRange:function()
	{
		Ext.getCmp('eventIDFrom').hide();
        Ext.getCmp('eventIDTo').hide();
        Ext.getCmp('eventIDs').hide();
	}
});