Ext.define('ComplianceEventlog.view.ComplianceEventlogMainForm', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.complianceeventlogmainform',
    id: 'compliance_event_log',   
	layout: 'column',
	defaults: {
		labelAlign: 'top',
		margin: '0 10 10 0',
		labelSeparator: ''
	},
    items: [
		{
			xtype: 'scrollcombo',
			cls: 'dropdown',
			width: 150,
			editable: false,
			fieldLabel: 'Search by',
			name: 'er_criteria',
			style: {'vertical-align': 'top'},
			id: 'er_criteria',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'scrollcombo',
			width: 150,
			cls: 'dropdown',
			editable: true,
			fieldLabel: 'Zone',
			hidden: true,
			id: 'zone',
			listConfig:{
					emptyText:noMatch
				},
			style: {'vertical-align': 'top'},
			name: 'zone',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'scrollcombo',
			width: 100,
			labelStyle: 'white-space: nowrap;',
			cls: 'dropdown',
			editable: false,
			style: {'vertical-align': 'top'},
			fieldLabel: 'Include Subzone',
			hidden: true,
			id: 'subzone',
			name: 'subzone',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},      
		{
			xtype: 'scrollcombo',
			width: 150,
			cls: 'dropdown',
			style: {'vertical-align': 'top'},
			editable: true,
			listConfig:{
				emptyText:noComponentTypeMatch
			},
			fieldLabel: 'Component Type',
			id: 'componontType',
			name: 'componontType',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'scrollcombo',
			width: 150,
			cls: 'dropdown',
			style: {'vertical-align': 'top'},
			editable: false,
			fieldLabel: 'Log Type',
			id: 'er_logType',
			name: 'er_logType',
			name: 'zone',
					store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
			
		{
			xtype: 'scrollcombo',
			width: 150,
			cls: 'dropdown',
			editable: true,
			listConfig:{
					emptyText:noDescriptorsMatch
				},
			fieldLabel: 'Descriptor',
			style: {'vertical-align': 'top'},
			id: 'er_descriptor',
			name: 'er_descriptor',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			fieldLabel: 'Event Source',
			xtype: 'scrollcombo',
			style: {'vertical-align': 'top'},
			id: 'er_eventSource',
			name: 'er_eventSource',
			editable: false,
			width: 150,
			cls: 'dropdown',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			})
		},
		{
			xtype: 'combobox',
			fieldLabel: eventIDLabel,
			name: 'eventID',
			id: 'eventID',
			queryMode: 'local',
			width: 150,
			value: '0',
			store: {
				fields: ['ID', 'event'],
				data: [{
					//"event": "All Event ID",
					"event": eventId,
					"ID": "0"
				},
				{
					//"event": "Specific",
					"event": eventSpecific,
					"ID": "1"
				},{
					//"event": "Range",
					"event": eventRange,
					"ID": "2"
				}]
				
			},
			displayField: 'event',
			valueField: 'ID',
			cls: 'dropdown',
			editable: false,
			listeners:
			{
				select: function() 
				{
					var eID = Ext.getCmp('eventID').getValue();
					if (eID == 1) {
						console.log('Specific Calling 1');
						appConstants.appObj.getController(appConstants.appController).showSpecfic();
						
					} else if (eID == 2) {
						appConstants.appObj.getController(appConstants.appController).showRange();

					} else if (eID == 0) {
						appConstants.appObj.getController(appConstants.appController).hideRange();

					}else {
						console.log('Am Here');
					}
				}
			}
		},
		{
			xtype: 'numberfield',
			name: 'eventIDFrom',
			id: 'eventIDFrom',
			width: 70,
			labelWidth: 35,
			cls: 'textbox',
			fieldLabel: 'From',
			labelAlign: 'top',
			margin:'0 10 10 0',
			hidden: true,
			allowNegative: false,
			allowDecimals: false,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			minValue: 0
		}, 
		{
			xtype: 'numberfield',
			name: 'eventIDTo',
			id: 'eventIDTo',
			hidden: true,
			width: 70,
			labelWidth: 25,
			cls: 'textbox',
			fieldLabel: 'To',
			labelAlign: 'top',
			allowNegative: false,
			allowDecimals: false,
			hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			minValue: 0
		}, 
		{
			xtype: 'textfield',
			width: 150,
			cls: 'textbox',
			fieldLabel: 'IDs',
			name: 'eventIDs',
			hidden:true,
			id: 'eventIDs',
			maskRe: /[\d,]+/,
			regex: /^[0-9]+(,[0-9]+)*$/,
			regexText: 'It allow only IDs Sepated by comma',
			//emptyText:'IDs separated by comma'
			emptyText:idType
		},
		{
			xtype: 'scrollcombo',
			width: 150,
			cls: 'dropdown',
			style: {'vertical-align': 'top'},
			editable: false,
			fieldLabel: 'Category Type',
			id: 'categoryType',
			name: 'categoryType',
			
					store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local'
		},
		{
			xtype: 'textfield',
			name: 'descKeyword',
			cls: 'textbox',
			width: 150,
			labelAlign: 'top',
			id: 'descKeyword',
			value:'*',
			fieldLabel: 'Event Description',
			emptyText:'Event Description'
		},
		{
			fieldLabel: 'User',
			xtype: 'scrollcombo',
			id: 'er_user',
			style: {'vertical-align': 'top'},
			name: 'er_user',
			editable: true,
			listConfig:{
					emptyText:noUserMatch
				},
			width: 150,
			cls: 'dropdown',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			store: new Ext.data.Store({
				fields: ['displayField', 'valueField'],
				data: []
			})
		}, 
		{xtype:'timeline', margin: 0},
		{xtype:'reportgeneration', margin: '0 10 10 0'},
		{xtype:'timelinesave', margin: '0 5 0 10',hidden:true},
		{
			xtype:'button',
			text: submitValue,
			margin: "20 10 0 0",
			ui: 'newButtonSmall',
			id: 'submit',
			name: 'submit'
		},
		{
			xtype:'button',
			text: "Save",
			ui: "newButtonSmall",
			id: "save",
			name: "save",
			margin: "20 10 0 0"
		},
	]
});