Ext.define('ConsolidatedServer.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
 		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'consolidatedserversettings', ref:'consolidatedserversettings'},
 		{selector:'consolidatedservermainform', ref:'consolidatedservermainform'},
		{selector:'ReporterSettings', ref:'ReporterSettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
 	],
	init:function()
	{
		this.control(
		{
			'main':{
				'boxready':this.loadpageTitle
			},
			'main newUtilities':{
				'afterrender': this.hideTools
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.saveFile
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #printTool > button':
			{
				'click':this.print
			},
			'consolidatedserversettings':
			{
				'afterrender':this.loadSettings
 			},
			'consolidatedservermainform combo[name="componentSelectBox"]':
			{
				'select': this.selectedComponent
			},
			'reportgeneration combo[name="reportGeneration"]':
			{
				'select': this.showBackgroundReport
			},
			'consolidatedserversettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'consolidatedserversettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			/*'consolidatedserversettings combo[name="excludeWeekendsCombo"]':
			{
				'select': this.showExcludeWeekendOptions
			},*/
			'consolidatedservermainform  combo[name="showVirtualServer"]':
			{
				'select': this.enableVirtualServerComboBox
			},
			'timeline combo[name="er_timeline"]':
			{
				//'select': this.enableTimeline
			},
			'consolidatedserversettings combo[name="showdetailsCombo"]':
			{
				'select' :  this.changeTrend
			},
			'consolidatedservermainform button[id="submit"]':
			{
				'click': this.beforeFormSubmit
			},
			'consolidatedservermainform button[name="save"]': {
					'click': this.addTo
				},
			'newUtilities > #favoriteTool > button' : {
						'click' : this.addTo
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.addTo
			},
			'print' : {
				'afterrender':this.printPageRender
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveDataInCSVFormat
			},
			 'consolidatedservermainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	showConfigDropdown:function(){
			var thisController = this;
			isSettingsEnabled = true;
 		    var tpl = new Ext.XTemplate('<div style="float:left;">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
				width:565,
				id:'configMod',
				//padding:5,
				//cls:'configMode_popup',
				ui:'settingsWindowContainer',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						cls:'containerHeader',
						border:true,
						//style:{'top':'0px','margin':'2px'}
					},
					{
						xtype:'consolidatedserversettings',
						parent:this
					}
				],
				onRender:function(){
					Ext.get('closeSettings').on('click',function(){
						thisController.validateAndCloseSettings();
					});
				},
				renderTo:'consolidatedserverdata-body'
			});
	},
	enableVirtualServerComboBox : function(combo)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var select_guestObj = consolidatedServerForm.findField("select_guest");
		if(combo.getValue()=="Yes")
		{
			select_guestObj.show();
		}
		else
		{
			select_guestObj.hide();
		}
	},
	selectedComponent : function(combo)
	{
		var params1 = '';//defaultParams;
		var mainForm = this.getConsolidatedservermainform();
		var consolidatedServerForm = mainForm.getForm();
		var showVirtualServer = Ext.getCmp("showVirtualServer");
		if(!showVirtualServer.isHidden())
		{
			params1 = params1+'&er_vmpresent=No&virtualServer=No';
		}
		Ext.Ajax.request({
			url : '/final/reporter/ErServerReportJSON.jsp',
			params: params1+"&consolidatedServerAction=defaultLoad&select_server="+combo.getValue(),
			scope:this,
//			async:true,
		    success: function(response)
			{
				var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
				var isVMResent = jsonData.pageParams['isVMResent'];

				if(!Ext.isEmpty(isVMResent) && isVMResent=="true")
				{

					jsonData.screenLabels['reporter.consolidated.Filter by VM'];
					jsonData.screenLabels['reporter.consolidated.Optional'];
					jsonData.screenLabels['reporter.consolidated.Virtual Machine"'];

					var isVMSearchNeeded = jsonData.pageParams['isVMSearchNeeded'];

 					var showVirtualServer = consolidatedServerForm.findField("showVirtualServer");
					showVirtualServer.setFieldLabel(jsonData.screenLabels['reporter.consolidated.Show virtual machine']);
					var yesNoOptionsRawData = jsonData['yesNoOptionsArr'];
					showVirtualServer.getStore().loadRawData(yesNoOptionsRawData);
					showVirtualServer.setValue("No");
					showVirtualServer.show();

					var select_guestObj = consolidatedServerForm.findField("select_guest");
					select_guestObj.setFieldLabel(jsonData.screenLabels['reporter.consolidated.Virtual Machine']);
					var vmJsonArr =jsonData['vmJsonArr'];
					var selectedVM =jsonData.pageParams['selectedVM'];
					select_guestObj.getStore().loadRawData(vmJsonArr);
					select_guestObj.setValue(selectedVM);
					appConstants.publicJsonData['hiddenParams']['virtualServer'] = jsonData['hiddenParams']['virtualServer']
				}
				else
				{
 					Ext.getCmp("showVirtualServer").hide();
					var select_guestObj = consolidatedServerForm.findField("select_guest");
					select_guestObj.hide();
				}
		    }
		});

	},
	validateSettings :  function()
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var stDate = consolidatedServerForm.findField('er_stdate').getValue();
		var enDate = consolidatedServerForm.findField('er_enddate').getValue();
		stDate.setHours(consolidatedServerForm.findField('er_sthr').getValue());
		enDate.setHours(consolidatedServerForm.findField('er_endhr').getValue());
		var localhidden=appConstants.publicJsonData['hiddenParams'];
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		if(er_timeline!=null && er_timeline=="Any")
		{
			if(!checkDateTime(stDate,enDate))
			{
				return;
			}
		}

		var reportgen;
		if (isSettingsEnabled)
		{
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen=appConstants.publicJsonData.pageParams.selectedRepGenType;
		}

		var getMaxDaysInMonth = localhidden['getMaxDaysInMonth'];

		var maxDaysInMonth = "";
		if(!Ext.isEmpty(getMaxDaysInMonth))
		{
			maxDaysInMonth = getMaxDaysInMonth;
		}
		var er_usertimeline = "";
		var er_usertimelineObj = localhidden['er_usertimeline'];
		if(!Ext.isEmpty(er_usertimelineObj))
		{
			er_usertimeline = er_usertimelineObj;
		}

		if(er_usertimeline!=null && er_usertimeline!="-1")
		{
			if(!isUserTimelineLimitExceeded(er_usertimeline,maxDaysInMonth,stDate,enDate))
			{
				Ext.MessageBox.show({
						title: 'Consolidated server performance',
						msg: _invalidUserTime,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
			}
		}

		var isSettingsOk = true;

		if ( reportgen!=null && reportgen == 'foreground' )
		{
			var limitforbg =localhidden['limitforbg'];

			if(!Ext.isEmpty(limitforbg))
			{
				if(!checkTimeLineForBgLimit(limitforbg,maxDaysInMonth,stDate,enDate))
				{
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showResult,this);
					isSettingsOk = false;
				}
			}
		}
		else
		{
 				var reportName;
				if (isSettingsEnabled)
				{
					reportName= Ext.getCmp('bgReportName').getValue();
				}
				else
				{
					reportName=appConstants.publicJsonData.bgReportName;
				}
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
 					return false;
				}
		}
		if(isSettingsOk && isSettingsEnabled)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		}
		return isSettingsOk;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('uptimereportform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	beforeFormSubmit: function()
	{
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
	var stDateTime = Ext.getCmp('er_stdate').getValue();
        var tmpStartHour = Ext.getCmp('er_sthr').getValue();
        stDateTime.setHours(tmpStartHour);
        var enDateTime = Ext.getCmp('er_enddate').getValue();
        var tmpEndHour = Ext.getCmp('er_endhr').getValue();
        enDateTime.setHours(tmpEndHour);
        var result = checkDateTime(stDateTime, enDateTime);
		if (!result) {
            return;
        }
		var isValidForm = this.validateForm();
		if(isValidForm)
		{
			var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
			var fromSchedule =  appConstants.publicJsonData['hiddenParams']['fromScheduleModify'];
			if(fromSchedule!=null && fromSchedule=="Yes")
			{
				this.addTo(Ext.getCmp('scheduleImg'),null,null);
			}
			else
			{
  				if (this.validateSettings())
				{
					var getButtonObj = Ext.getCmp('submit');
					this.formSubmit(getButtonObj);
				}
			}
		}
	},
	showResult : function(btn)
	{
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
			this.formSubmit(getButtonObj);
		}
		else
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var settingsForm = this.getConsolidatedserversettings().getForm();
			settingsForm.findField('reportGeneration').setValue('background');
			var reportNameObj = settingsForm.findField('bgReportName');
			reportNameObj.show();
			reportNameObj.focus();
			this.beforeFormSubmit();
 		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.beforeFormSubmit();
		}
	},
	validateAndCloseSettings :  function()
	{
 		var settingsForm = this.getConsolidatedserversettings().getForm();
		var timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
		var timePeriodFromMins = settingsForm.findField('minfrom').getValue();
		var timePeriodToHrs = settingsForm.findField('timeto').getValue();
		var timePeriodToMins = settingsForm.findField('minto').getValue();
		if(!checkTimePeriod(timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins))
		{
			return false;
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
  			return false;
		}
		else if (Ext.getCmp('reportGeneration').getValue() == 'background-csv' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
  			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
 	},
	loadpageTitle:function(){
		this.getMain().setTitle('Consolidated - Server');
		var graphModeComboObj = Ext.getCmp("er_mode");
		if(!Ext.isEmpty(graphModeComboObj))
			graphModeComboObj.hide();

		this.defaultLoad();
		if(!appConstants.hideBackButton){
			Ext.getCmp('uptimereportform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}

	},
	sendMail:function(){
		Ext.widget('sendmail').show();
	},
	/*showExcludeWeekendOptions : function() {
 		var excludeWeekendLbl = Ext.getCmp("excludeWeekendLbl");
		var isExcludeWeekEnd = Ext.getCmp("excludeWeekendsCombo").getValue();
		if(isExcludeWeekEnd == "Yes")
		{
			excludeWeekendLbl.show();
		}
		else
		{
			excludeWeekendLbl.hide();
		}
	},*/
	saveFile:function(){

		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();

		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate = consolidatedServerForm.findField('er_enddate').dataArray;

		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timefrom,minfrom,timeto,minto,reportgen,excludeWeekEnd,er_show_details,reportName;
		if (isSettingsEnabled)
		{

			 var settingsForm = this.getConsolidatedserversettings().getForm();
			 timefrom = settingsForm.findField('timefrom').getValue();
			 minfrom = settingsForm.findField('minfrom').getValue();
			 timeto = settingsForm.findField('timeto').getValue();
			 minto = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			 er_show_details = settingsForm.findField('showdetailsCombo').getValue();
			 reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{


			 var localjson=appConstants.publicJsonData.pageParams;
			 timefrom = localjson.Hourfrom;
			 minfrom = localjson.Minfrom;
			 timeto = localjson.Hourto;
			  minto =localjson.Minto;
			 reportgen = localjson.selectedRepGenType;
			 excludeWeekEnd = localjson.selectedExcludeWeekend;
			 er_show_details =localjson.selectedShowData;
			 reportName =localjson.selectedReportName;
		}

		var sthr = consolidatedServerForm.findField('er_sthr').dataArray;
		var endhr = consolidatedServerForm.findField('er_endhr').dataArray;
		var localjson=appConstants.publicJsonData;
 		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();
		var virtualServer = localjson['hiddenParams']['virtualServer'];
		var er_rtype = localjson['hiddenParams']['er_rtype']
		var er_gtype = localjson['hiddenParams']['er_gtype']
		var er_trgttype = localjson['hiddenParams']['er_trgttype'];
		var grpmode = localjson['hiddenParams']['grpmode'];

		//var er_show_details = settingsForm.findField('showdetailsCombo').getValue();

		//var s_qryString="../reporter/ErHtmlToSavePdf.jsp?er_rtype="+er_rtype+"&er_gtype="+er_gtype+"&er_trgttype="+er_trgttype+"&er_mode="+grpmode+"&er_view=PRINT&";
		var s_qryString="../reporter/ErHtmlToSavePdf.jsp?er_rtype="+er_rtype+"&er_gtype="+er_gtype+"&er_trgttype="+er_trgttype+"&er_view=PRINT&";

		s_qryString = s_qryString+"&select_server="+component+"&er_timeline="+er_timeline+"&startdate="+startdate+"&enddate="+enddate
					+"&timefrom="+timefrom+"&timeto="+timeto+"&starthr="+sthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_excwe="+excludeWeekEnd+"&minfrom="+minfrom+"&minto="+minto
					+"&er_trenddata="+er_show_details;

		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			s_qryString = s_qryString+'&er_type='+showVirtualServer.getValue()+'&forwardto=ErServerReport&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}
		else
		{
			s_qryString = s_qryString+'&er_type=No';
		}

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate = consolidatedServerForm.findField('er_enddate').dataArray;
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timefrom,minfrom,timeto,minto,reportgen,excludeWeekEnd,er_show_details,reportName;
		if (isSettingsEnabled)
		{
			 var settingsForm = this.getConsolidatedserversettings().getForm();
			 timefrom = settingsForm.findField('timefrom').getValue();
			 minfrom = settingsForm.findField('minfrom').getValue();
			 timeto = settingsForm.findField('timeto').getValue();
			 minto = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			 er_show_details = settingsForm.findField('showdetailsCombo').getValue();
			 reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{
			 var localjson=appConstants.publicJsonData.pageParams;
			 timefrom = localjson.Hourfrom;
			 minfrom = localjson.Minfrom;
			 timeto = localjson.Hourto;
			  minto =localjson.Minto;
			 reportgen = localjson.selectedRepGenType;
			 excludeWeekEnd = localjson.selectedExcludeWeekend;
			 er_show_details =localjson.selectedShowData;
			 reportName =localjson.selectedReportName;
		}
		var sthr = consolidatedServerForm.findField('er_sthr').dataArray;
		var endhr = consolidatedServerForm.findField('er_endhr').dataArray;
		var localjson=appConstants.publicJsonData;
 		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();
		var virtualServer = localjson['hiddenParams']['virtualServer'];
		var er_rtype = localjson['hiddenParams']['er_rtype']
		var er_gtype = localjson['hiddenParams']['er_gtype']
		var er_trgttype = localjson['hiddenParams']['er_trgttype'];
		var grpmode = localjson['hiddenParams']['grpmode'];
		var s_qryString=er_rtype+"&er_gtype="+er_gtype+"&er_trgttype="+er_trgttype+"&er_view=PRINT&";
		s_qryString = s_qryString+"&select_server="+component+"&er_timeline="+er_timeline+"&startdate="+startdate+"&enddate="+enddate
					+"&timefrom="+timefrom+"&timeto="+timeto+"&starthr="+sthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_excwe="+excludeWeekEnd+"&minfrom="+minfrom+"&minto="+minto
					+"&er_trenddata="+er_show_details;
		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			s_qryString = s_qryString+'&er_type='+showVirtualServer.getValue()+'&forwardto=ErServerReport&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}
		else
		{
			s_qryString = s_qryString+'&er_type=No';
		}
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var reportgen;
		var settingsForm ;
		var timePeriodFromHrs ;
		var timePeriodFromMins;
		var timePeriodToHrs ;
		var timePeriodToMins;
		var excludeWeekEnd ;
		var er_show_details;
		if (isSettingsEnabled)
		{
			settingsForm = this.getConsolidatedserversettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			er_show_details = settingsForm.findField('showdetailsCombo').getValue();
		}else
		{
			var jsonData=appConstants.publicJsonData;
			timePeriodFromHrs = jsonData.pageParams.Hourfrom;
			timePeriodFromMins = jsonData.pageParams.Minfrom;
			timePeriodToHrs = jsonData.pageParams.Hourto;
			timePeriodToMins = jsonData.pageParams.Minto;
			reportgen = jsonData.pageParams['selectedRepGenType'];
			er_show_details = jsonData.pageParams.selectedShowData;
			excludeWeekEnd = jsonData.pageParams.selectedExcludeWeekend;
		}
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate =consolidatedServerForm.findField('er_enddate').dataArray;
		var startHour = consolidatedServerForm.findField('er_sthr').dataArray;
		var endHour = consolidatedServerForm.findField('er_endhr').dataArray;

		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();

		if(select_guest!=null &&  select_guest=="-1") // this is done to fix consolidated server favorite issue
			select_guest = "";

		var virtualServer = appConstants.publicJsonData['hiddenParams']['virtualServer'];

		bookletquery+= '&select_server='+component+'&er_timeline='+er_timeline+'&er_trenddata='+er_show_details;
		bookletquery+="&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;


		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			bookletquery+='&er_vmpresent='+showVirtualServer.getValue()+'&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}

		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			bookletquery+=hiddenQstr;
		}

		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
				reportName=checkFileName(reportName);
			bookletquery+="&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
		}
		else if ( reportgen!=null && reportgen == 'background-csv' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
				reportName=checkFileName(reportName);
			bookletquery+="&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
		}
		else
		{
			bookletquery+="&forwardto=ErServerReport";
		}
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	saveDataInCSVFormat  : function()
	{
		var s_qryString = "../servlet/egurkha.reporter.SaveInCSVFormat";
		 window.location=s_qryString;
	},
	hideTools:function(){
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			true, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true //booklets
			);

		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);


	},
	printPageRender : function() {
		
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var settingsForm = this.getConsolidatedserversettings().getForm();

		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate = consolidatedServerForm.findField('er_enddate').dataArray;

		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		var timefrom = settingsForm.findField('timefrom').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('timeto').getValue();
		var timeto = settingsForm.findField('minto').getValue();

		var sthr = settingsForm.findField('er_sthr').dataArray;

		var endhr = settingsForm.findField('er_endhr').dataArray;

		var excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
		var localhiddens=appConstants.publicJsonData['hiddenParams'];
		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();
		var virtualServer = localhiddens['virtualServer'];
		var er_rtype = localhiddens['er_rtype']
		var er_gtype =localhiddens['er_gtype']
		var er_trgttype =localhiddens['er_trgttype'];
		var grpmode =localhiddens['grpmode'];

		var er_show_details = settingsForm.findField('showdetailsCombo').getValue();

		var s_qryString="../servlet/com.eg.ErCtxServerReportC?er_rtype="+er_rtype+"&er_gtype="+er_gtype+"&er_trgttype="+er_trgttype+"&er_mode="+grpmode+"&er_view=PRINT&pdfPrint=yes";

			s_qryString = s_qryString+"&select_server="+component+"&er_timeline="+er_timeline+"&startdate="+startdate+"&enddate="+enddate
					+"&timefrom="+timefrom+"&timeto="+timeto+"&starthr="+sthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_excwe="+excludeWeekEnd+"&minfrom="+minfrom+"&minto="+minto
					+"&er_trenddata="+er_show_details;

		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			s_qryString = s_qryString+'&er_type='+showVirtualServer.getValue()+'&forwardto=ErServerReport&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}
		else
		{
			s_qryString = s_qryString+'&er_type=No';
		}
	},
	print:function()
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate = consolidatedServerForm.findField('er_enddate').dataArray;

		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var timefrom,minfrom,timeto,minto,reportgen,excludeWeekEnd,er_show_details,reportName;
		if (isSettingsEnabled)
		{
			 var settingsForm = this.getConsolidatedserversettings().getForm();
			 timefrom = settingsForm.findField('timefrom').getValue();
			 minfrom = settingsForm.findField('minfrom').getValue();
			 timeto = settingsForm.findField('timeto').getValue();
			 minto = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			 er_show_details = settingsForm.findField('showdetailsCombo').getValue();
			 reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{
			 var localjson=appConstants.publicJsonData.pageParams;
			 timefrom = localjson.Hourfrom;
			 minfrom = localjson.Minfrom;
			 timeto = localjson.Hourto;
			  minto =localjson.Minto;
			 reportgen = localjson.selectedRepGenType;
			 excludeWeekEnd = localjson.selectedExcludeWeekend;
			 er_show_details =localjson.selectedShowData;
			 reportName =localjson.selectedReportName;
		}
		//prakash
		var jsonDatas = appConstants.publicJsonData;
		var titles = jsonDatas['screenLabels'].pageTitle;
		var printName='';
		if(appConstants.er_RmDispName!=null && appConstants.er_RmDispName!='null')
			 printName = appConstants.er_RmDispName;
		else
			 printName = titles;
		//
		var sthr = consolidatedServerForm.findField('er_sthr').dataArray;
		var endhr = consolidatedServerForm.findField('er_endhr').dataArray;;
		var localhiddens=appConstants.publicJsonData['hiddenParams'];
		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();
		var virtualServer = localhiddens['virtualServer'];
		var er_rtype =localhiddens['er_rtype'];
		var er_gtype = localhiddens['er_gtype'];
		var er_trgttype = localhiddens['er_trgttype'];
		var grpmode =localhiddens['grpmode'];
		//var er_show_details = settingsForm.findField('showdetailsCombo').getValue();
		var s_qryString="../servlet/com.eg.ErCtxServerReportC?er_rtype="+er_rtype+"&er_gtype="+er_gtype+"&er_trgttype="+er_trgttype+"&er_mode="+grpmode+"&er_view=PRINT&pdfPrint=yes";
		s_qryString = s_qryString+"&select_server="+component+"&er_timeline="+er_timeline+"&startdate="+startdate+"&enddate="+enddate
					+"&timefrom="+timefrom+"&timeto="+timeto+"&starthr="+sthr+"&endhr="+endhr+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_excwe="+excludeWeekEnd+"&minfrom="+minfrom+"&minto="+minto
					+"&er_trenddata="+er_show_details+"&er_RmDispName="+printName;
		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			s_qryString = s_qryString+'&er_type='+showVirtualServer.getValue()+'&forwardto=ErServerReport&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}
		else
		{
			s_qryString = s_qryString+'&er_type=No';
		}
      parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	addTo :  function(btn, e, val)
	{
		// by karthikeyan
		/*if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Consolidated Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}*/
//
		var btnID = btn.getId();
		var formButtonId=btnID;

		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();

		var component = consolidatedServerForm.findField('componentSelectBox').getValue();

		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}
		var reportgen;
		var settingsForm ;
		var timePeriodFromHrs ;
		var timePeriodFromMins;
		var timePeriodToHrs ;
		var timePeriodToMins;
		var excludeWeekEnd ;
		var er_show_details;
		if (isSettingsEnabled)
		{
			settingsForm = this.getConsolidatedserversettings().getForm();
			timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			timePeriodToHrs = settingsForm.findField('timeto').getValue();
			timePeriodToMins = settingsForm.findField('minto').getValue();
			reportgen = settingsForm.findField('reportGeneration').getValue();
			excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			er_show_details = settingsForm.findField('showdetailsCombo').getValue();
		}else
		{
			var jsonData=appConstants.publicJsonData;
			timePeriodFromHrs = jsonData.pageParams.Hourfrom;
			timePeriodFromMins = jsonData.pageParams.Minfrom;
			timePeriodToHrs = jsonData.pageParams.Hourto;
			timePeriodToMins = jsonData.pageParams.Minto;
			reportgen = jsonData.pageParams['selectedRepGenType'];
			er_show_details = jsonData.pageParams.selectedShowData;
			excludeWeekEnd = jsonData.pageParams.selectedExcludeWeekend;
		}
		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate =consolidatedServerForm.findField('er_enddate').dataArray;
		var startHour = consolidatedServerForm.findField('er_sthr').dataArray;
		var endHour = consolidatedServerForm.findField('er_endhr').dataArray;

		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();

		if(select_guest!=null &&  select_guest=="-1") // this is done to fix consolidated server favorite issue
			select_guest = "";

		var virtualServer = appConstants.publicJsonData['hiddenParams']['virtualServer'];

		var paramsForCompChange = '&select_server='+component+'&er_timeline='+er_timeline+'&er_trenddata='+er_show_details;
		paramsForCompChange = paramsForCompChange+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;


		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			paramsForCompChange = paramsForCompChange+'&er_vmpresent='+showVirtualServer.getValue()+'&virtualServer='+virtualServer+'&select_guest='+select_guest;
		}

		var hiddenQstr = '';
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		for( var hid in hiddenData)
		{
			hiddenQstr +='&'+hid+'='+hiddenData[hid];
		}
		if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
		{
			paramsForCompChange = hiddenQstr+paramsForCompChange;
		}

		if ( reportgen!=null && reportgen == 'background' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
				reportName=checkFileName(reportName);
			paramsForCompChange = paramsForCompChange+"&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
		}
		else if ( reportgen!=null && reportgen == 'background-csv' )
		{
			var reportName = settingsForm.findField('bgReportName').getValue();
				reportName=checkFileName(reportName);
			paramsForCompChange = paramsForCompChange+"&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
		}
		else
		{
			paramsForCompChange = paramsForCompChange+"&forwardto=ErServerReport";
		}
     		var from_schedule = hiddenData["fromScheduleModify"];
			var favorite_id = hiddenData["favorite_id"];
        if (from_schedule != null && from_schedule == "Yes")
			btnID = 'scheduleImg';



		var target = "";
		var windowClass;
		var frameId;
		if (btnID != null && btnID == 'scheduleImg') {
			//windowClass='scheduleWindow';
			//frameId='#schWin';
			target = "/final/reporter/ErSaveSchedule.jsp?" + paramsForCompChange+"&com.eg.CSRF_NONCE="+csrfToken;
			if (formButtonId=='save')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp




		} else {//if (btnID != null && btnID == 'favImg') {
			//windowClass='favouriteWindow';
			//frameId='#favWin';
			target = "../servlet/com.eg.ErFavoriteC?er_view=GRAPH&cmd=client&" + paramsForCompChange+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken ;//+"&FavoriteId="+favorite_id;;

        if (formButtonId=='save')
		{
			//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		}
		//var target = url;
		//Ext.widget(windowClass).show();
		//Ext.select(frameId).set({src :target});
	},
	validateForm : function()
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var component = consolidatedServerForm.findField('componentSelectBox').getValue();
		if(component=="-1")
		{
			Ext.MessageBox.show({
						title: 'Consolidated Server Report',
						msg: appConstants.compTypeAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
				return false;
		}

		var showVirtualServer = Ext.getCmp("showVirtualServer");
//		var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');

		if(!showVirtualServer.isHidden())
		{
			var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
			if(!Ext.isEmpty(showVirtualServer) && showVirtualServer=='Yes')
			{
				var select_guest = consolidatedServerForm.findField('select_guest').getValue();

				if(select_guest=="-1")
				{
					Ext.MessageBox.show({
								title: 'Consolioated Server Report',
								msg: appConstants.reqParamsAlert,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
						return false;
				}
			}

		}
		return true;
	},
	updateQueryString: function(ctrlObjId)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var isSubmit = false;

		if(ctrlObjId!=null && ctrlObjId=="submit")
			isSubmit = true;


		var component = consolidatedServerForm.findField('componentSelectBox').getValue();

		var er_timeline = consolidatedServerForm.findField('er_timeline').getValue();
		if ( Ext.isEmpty( er_timeline ) )
		{
			er_timeline = '1 day';
		}

		var timePeriodFromHrs,timePeriodFromMins,timePeriodToHrs,timePeriodToMins,reportgen,excludeWeekEnd,er_show_details,reportName;
		if (isSettingsEnabled)
		{
			 var settingsForm = this.getConsolidatedserversettings().getForm();
			 timePeriodFromHrs = settingsForm.findField('timefrom').getValue();
			 timePeriodFromMins = settingsForm.findField('minfrom').getValue();
			 timePeriodToHrs = settingsForm.findField('timeto').getValue();
			 timePeriodToMins = settingsForm.findField('minto').getValue();
			 reportgen = settingsForm.findField('reportGeneration').getValue();
			 excludeWeekEnd = settingsForm.findField('excludeWeekendsCombo').getValue();
			 er_show_details = settingsForm.findField('showdetailsCombo').getValue();
			 reportName = settingsForm.findField('bgReportName').getValue();
		}
		else
		{
			 var localjson=appConstants.publicJsonData.pageParams;
			 timePeriodFromHrs = localjson.Hourfrom;
			 timePeriodFromMins = localjson.Minfrom;
			 timePeriodToHrs = localjson.Hourto;
			 timePeriodToMins =localjson.Minto;
			 reportgen = localjson.selectedRepGenType;
			 excludeWeekEnd = localjson.selectedExcludeWeekend;
			 er_show_details =localjson.selectedShowData;
			 reportName =localjson.selectedReportName;
		}


		var startdate = consolidatedServerForm.findField('er_stdate').dataArray;
		var enddate = consolidatedServerForm.findField('er_enddate').dataArray;
		var startHour = consolidatedServerForm.findField('er_sthr').dataArray
		var endHour = consolidatedServerForm.findField('er_endhr').dataArray;
		var showVirtualServer = Ext.getCmp("showVirtualServer");
		var select_guest = consolidatedServerForm.findField('select_guest').getValue();
		var virtualServer = appConstants.publicJsonData['hiddenParams']['virtualServer'];

		var paramsForCompChange = '&select_server='+component+'&er_timeline='+er_timeline+'&er_trenddata='+er_show_details;

		paramsForCompChange = paramsForCompChange+"&startdate="+startdate+"&enddate="+enddate+"&starthr="+startHour+"&endhr="+endHour+"&timeto="+timePeriodToHrs
								+"&minto="+timePeriodToMins+"&er_excwe="+excludeWeekEnd
								+"&timefrom="+timePeriodFromHrs
								+"&minfrom="+timePeriodFromMins+"&er_reportgenration="+reportgen+"&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		if(isSubmit)
		{
			if(!showVirtualServer.isHidden())
			{
				var showVirtualServer = consolidatedServerForm.findField('showVirtualServer');
				paramsForCompChange = paramsForCompChange+'&er_vmpresent='+showVirtualServer.getValue()+'&virtualServer='+virtualServer;

				if(!Ext.isEmpty(showVirtualServer) && showVirtualServer.getValue()=='Yes')
				{
						paramsForCompChange = paramsForCompChange+'&select_guest='+select_guest;
				}
				else
				{
					paramsForCompChange = paramsForCompChange+'&select_guest=';
				}
			}


			var hiddenQstr = '';
			var hiddenData = appConstants.publicJsonData['hiddenParams'];
			for( var hid in hiddenData)
			{
					hiddenQstr +='&'+hid+'='+hiddenData[hid];
			}
			if(hiddenQstr!=null && (hiddenQstr!="null" && hiddenQstr!="undefined"))
			{
				paramsForCompChange = hiddenQstr+paramsForCompChange;
			}

			if ( reportgen!=null && reportgen == 'background' )
			{
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC";
			}
			else if ( reportgen!=null && reportgen == 'background-csv' )
			{
				reportName=checkFileName(reportName);
				paramsForCompChange = paramsForCompChange+"&forwardto=ErServerReportJSON&consolidatedServerAction=submit&bg_reportname="+reportName+"&trackerLanguage="+appConstants.trackerLanguage;
				appConstants.urlForSubmit = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			}
			else
			{
				appConstants.urlForSubmit = "../servlet/com.eg.ErCtxServerReportC?isSubmit=true&forwardto=ErServerReport&";
			}
		}

		appConstants.queryString = paramsForCompChange;

	},
	loadConsolidatedServerReportData : function(jsonData)
	{
		var thisController=this;
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
 		var reportgen;
		if (isSettingsEnabled)
		{
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen=appConstants.publicJsonData.pageParams.selectedRepGenType;
		}
		var consolidatedServerResultPanel = Ext.getCmp("consolidatedServerResultPanel");
		consolidatedServerResultPanel.removeAll();
		var localhiddens=appConstants.publicJsonData['hiddenParams'];

		var virtualServerHidVal = jsonData['hiddenParams']['virtualServer'];
		if(virtualServerHidVal!=null && virtualServerHidVal!="undefined")
		{
				localhiddens['virtualServer'] = virtualServerHidVal;
		}
		var er_rtypeVal = jsonData['hiddenParams']['er_rtype'];
		if(er_rtypeVal!=null && er_rtypeVal!="undefined")
		{
				localhiddens['er_rtype'] = er_rtypeVal;
		}
		var er_gtypeHidVal = jsonData['hiddenParams']['er_gtype'];
		if(er_gtypeHidVal!=null && er_gtypeHidVal!="undefined")
		{
				localhiddens['er_gtype'] = er_gtypeHidVal;
		}
		var er_trgttypeHidVal = jsonData['hiddenParams']['er_trgttype'];
		if(er_trgttypeHidVal!=null && er_trgttypeHidVal!="undefined")
		{
				localhiddens['er_trgttype'] = er_trgttypeHidVal;
		}
		var grpmodeHidVal = jsonData['hiddenParams']['grpmode'];
		if(er_trgttypeHidVal!=null && er_trgttypeHidVal!="undefined")
		{
				localhiddens['grpmode'] = er_trgttypeHidVal;
		}
		var grpmodeHidVal = jsonData['hiddenParams']['pdfTime'];
		if(er_trgttypeHidVal!=null && er_trgttypeHidVal!="undefined")
		{
				localhiddens['pdfTime'] = er_trgttypeHidVal;
		}
		var grpmodeHidVal = jsonData['hiddenParams']['option'];
		if(er_trgttypeHidVal!=null && er_trgttypeHidVal!="undefined")
		{
				localhiddens['option'] = er_trgttypeHidVal;
		}

		if(!Ext.isEmpty(jsonData))
		{
			var dataAvailable = jsonData.dataAvailable;

			if(reportgen!=null && (reportgen == "background" || reportgen == "background-csv"))
			{
				var resultObj = this.getBackGroundPanel();
				resultObj.removeAll();
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(false);
//						Ext.getCmp("upbutton").setDisabled(false);


				var bgGroundMsg = jsonData.pageParams['bggroundStr'];
				var status = jsonData.pageParams['status'];
				var langSupportString = jsonData.screenLabels['langSupportStr'];
				var bgReportUrl = jsonData.pageParams['bgUrl'];
				var bgreportlinkMsg = jsonData.screenLabels['reporter.common.Click here to see a list of generated and processing reports'];
				var reporter_Skin = jsonData.screenLabels['reporter_Skin'];
				var tableTitle='';
				var htmlStr = "";
				var statusCssClass='iconSuccess';
				if((status != null && status == "duplicate") || (bgGroundMsg!=null && bgGroundMsg == "User background report generationlimit is finished"))
				{
					//htmlStr += "<img src=\"/final/reporter/images/"+reporter_Skin+"/exclamation-icon.gif\"><br>";
					statusCssClass = 'iconExclamation';
				}
					htmlStr += '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+langSupportString+'.</br>'+'<a class="backgroundMsgLink" href='+ bgReportUrl +'>'+ bgreportlinkMsg + '</a></div></td></tr></table></td></tr></table>';

				resultObj.update({
				xtype: 'panel',
					//style:{'background':'#E6E6E6'},
					margin:0,
					bodyPadding:0,
					height: '100%',
					width: '100%',
					html: htmlStr
				});
				resultObj.doLayout();
				resultObj.show();
				appConstants.loadMask.hide();
			}
			else
			{
				if(dataAvailable!=null && dataAvailable=="true")
				{
					var backEnable = jsonData.pageParams['backEnable'];

					var isBackButtonNeeded =false;
					var backButtonUrl = '../reporter/EgReporterback.jsp';
					if(!Ext.isEmpty(backEnable))
					{
						var enableBackButton = jsonData.pageParams['enableBackButton'];

						var backButtonType = jsonData.pageParams['backButtonType'];

						if(!Ext.isEmpty(enableBackButton) && enableBackButton=="true")
						{
							isBackButtonNeeded = true;
						}
						else if( !Ext.isEmpty(backButtonType) && (backButtonType == "Zone" || backButtonType == "User" || backButtonType == "Session") )
						{
							backButtonUrl = jsonData.pageParams['backButtonUrl'];

							if (backButtonType=='Zone')
							{
								localhiddens['er_rtype']="Farm";
								localhiddens['er_trgttype']="Farm Report";
							}else if(backButtonType=='User')
							{
								localhiddens['er_rtype']="User";
								localhiddens['er_trgttype']="User Report";
							}
							else if(backButtonType=='Session')
							{
								localhiddens['er_rtype']="Session";
								localhiddens['er_trgttype']="Session Report";
							}
							this.updateQueryString('ctrlObjID');
							backButtonUrl+'&'+appConstants.queryString
						}
					}
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("upbutton").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);

					var measureTable=jsonData.tableJsonArr;

					var tableTitle = jsonData.screenLabels['selectedDisplayTitle'];

					if(!Ext.isEmpty(measureTable))
					{
						var submitArr = new Array();

						 var addSubmittedReports = Ext.widget('panel',
						 {
							bodyPadding:'0',
							margin:'5 10 10 10',
 							//cls:'datapanel',
							ui:'newGraphPanel',
							layout:{
								type:'vbox',
								align: 'stretch'
							},
							flex:1,
							title:tableTitle,
							//header:{cls:'serverreporthead'},
							titleAlign:'left',
							height : '100%',
 							items:[
								 {
									xtype : 'button',
									width : '30',
									text : '<<',
									listeners :
									 {
										'click' : function()
										 {
											document.location = backButtonUrl;
										 },
										'afterrender' : function()
										 {
											 if(isBackButtonNeeded)
											 {
												 this.show();
											 }
										 }
									 },
									hidden : true
								 },
								{
								xtype:'dataview',
								scroll:true,
							//	cls:'',
								flex:1,
								autoScroll:true,
								padding:'0 10 10 10',
								store: new Ext.data.Store({
									fields:['measDisplayTitle','Avg','Max','Min','qryString'],
									data:measureTable
								}),
								tpl:new Ext.XTemplate(
							'<div class="newTable">',
							'<table cellspacing="0" cellpadding="0" border="0" width="100%" style="table-layout:fixed">',
								'<thead>',
								'<tpl if="backEnable == true">',
									'<tr>',
										'<th colspan="5">',
											'<div >#########backbuttonFalse</div>',
										'</th>',
									'</tr>',
								'</tpl>',
									'<tr>',
										'<th style="width:38%;text-align:left" >',
											'<div style="overflow:visible">'+jsonData.screenLabels["reporter.consolidated.Measures"]+'</div>',
										'</th>',
											'{[this.getKidClass()]}',
										/*'<th class=" x-grid-cell" style="width:100">',
											'<div class="x-grid-cell-inner"  style="overflow:visible">'+jsonData.screenLabels["reporter.common.Avg"]+'</div>',
										'</th>',
										'<th class=" x-grid-cell" style="width:100">',
											'<div class="x-grid-cell-inner"  style="overflow:visible">'+jsonData.screenLabels["reporter.common.Max"]+'</div>',
										'</th>',
										'<th class=" x-grid-cell" style="width:100">',
											'<div class="x-grid-cell-inner"  style="overflow:visible">'+jsonData.screenLabels["reporter.common.Min"]+'</div>',
										'</th>',*/
										'<th style="width:30px">',
											'<div style="overflow:visible">&nbsp;</div>',
										'</th>',
									'</tr>',
								'</thead>',
							'<tbody>',
							'<tpl for=".">',
								'<tr>',
									'{[this.getKidClass1(values)]}',
									'<td style="width:30px" class="iconColumn">',
										'<div class="iconLineChart" onClick=\'javascript:loadUrlInDrillDown("{qryString}");\' style="width:16px;height:16px;display:block;cursor:pointer"></div>',
									'</td>',
								'</tr>',
							'</tpl>',
							'</tbody>',
							'</table>',
							'</div>',
							{
								getKidClass:function(){
									var screenLabels1=jsonData.screenLabels1;
									var thContent='';
									for(var key in screenLabels1)
									{
										thContent+='<th style="width:15%;text-align:center" align="center"><div style="overflow:visible">'+screenLabels1[key]+'</div></th>';
									}
									return thContent;
							   },
								 getKidClass1:function(val){
									var thContent='';
									
									var len=Object.keys(val).length;
									var count=0;
									for(var key in val)
									{
										if(!Ext.isEmpty(val[key]))
										{
											if(count!=len-1)
											{
												if (count==0)
												{
													thContent+='<td style="width:15%" align="left"><div>'+val[key]+'</div></td>';
												}
												else
												{
													var val1 = val[key];
													//thContent+='<td style="width:15%" align="center"><div>'+thisController.getDecimalAlignFormat(val1)+'</div></td>';
													thContent+='<td style="width:15%" align="center"><div>'+val1+'</div></td>';
												}
											}
										}
										count++;
									}
									return thContent;
							   }
							}
									),
								itemSelector: 'div.newTable'
								}]
						 });
						submitArr.push(addSubmittedReports);
 						consolidatedServerResultPanel.add(submitArr);
 						appConstants.loadMask.hide();
						consolidatedServerResultPanel.show();
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}
					else
					{
						Ext.getCmp('consolidatedServerResultPanel').hide();
 						this.getNomeasurepanel().show();
						appConstants.loadMask.hide();
					}
				}
				else
				{
					Ext.getCmp('consolidatedServerResultPanel').hide();
 					this.getNomeasurepanel().show();
					appConstants.loadMask.hide();
				}
			}
		}
		else
		{
			Ext.getCmp('consolidatedServerResultPanel').hide();
 			this.getNomeasurepanel().show();
			appConstants.loadMask.hide();
		}
	},
	formSubmit: function(obj)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
 		var ctrlObjID="";
		if(obj!=null && obj!="undefined")
		{
			ctrlObjID = obj.getId();
		}
		var reportgen;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen=appConstants.publicJsonData.pageParams.selectedRepGenType;
		}



	//by karthikeyan
 	appConstants.queryString+= '&er_RmDispName='+appConstants.er_RmDispName;
                //
		if(ctrlObjID != null && ctrlObjID=="submit")
		{
			this.updateQueryString(ctrlObjID);
			if(reportgen!=null && reportgen == "foreground")
			{
				appConstants.urlForSubmit = appConstants.urlForSubmit+'&generateJson=true';
			}
			appConstants.loadMask.show();
			this.getNomeasurepanel().hide();
			this.getBackGroundPanel().hide();
			var thisController =this;
			var resultJson = '';
			Ext.Ajax.request({
				url : appConstants.urlForSubmit,
				params: appConstants.queryString,
				timeout : 180000,
			//	async:true,
				scope:this,
				success: function(response)
				{
					var jsonText  = response.responseText;
					var jsonData=Ext.decode(jsonText);
					this.loadConsolidatedServerReportData(jsonData);
				},
				failure : function(response)
				{

					appConstants.loadMask.hide();
					Ext.getCmp("bookletTool").setDisabled(true);
					Ext.getCmp("saveTool").setDisabled(true);
				    	Ext.getCmp("printTool").setDisabled(true);
                    			Ext.getCmp("mailTool").setDisabled(true);
                    			Ext.getCmp("csvTool").setDisabled(true);
					this.getNomeasurepanel().doLayout();
					this.getNomeasurepanel().show();
				}
			});
		}
	},
	defaultLoad: function()
	{
		var localjson=appConstants.publicJsonData;
		this.loadFields(localjson);
 		var from_schedule = localjson['hiddenParams']['fromScheduleModify'];
		var fromFavoriteModify = localjson['hiddenParams']["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
			stmin = localjson.pageParams.startMinForDisplay;
			enmin = localjson.pageParams.endMinForDisplay;
			mgr_stmin = localjson.pageParams.startmin;
			mgr_enmin = localjson.pageParams.endmin;
		if(appConstants.isSubmit=="true"|| appConstants.fromSchView=="Yes"||appConstants.fromSessionReport == 'true')
		{
			this.beforeFormSubmit();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.beforeFormSubmit();
			}
		}
	
	},
	loadSettings:function(){
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenData = appConstants.publicJsonData['hiddenParams'];
		var favorite_id = hiddenData["favorite_id"];
		if(!Ext.isEmpty(favorite_id) && (appConstants.fromSchView !="Yes" && appConstants.executeFavorite!="true")){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		var jsonData=appConstants.publicJsonData;
		var screenLabels=jsonData.screenLabels;
		var settingsForm = this.getConsolidatedserversettings().getForm();
		var showDataLbl=jsonData.screenLabels['reporter.consolidated.Show data'];
		var excludeWeekendsLbl=jsonData.screenLabels['reporter.consolidated.Exclude weekends'];
		var excludesLbl=jsonData.screenLabels['reporter.common.Excludes'];
		var timePeriodLbl=jsonData.screenLabels['reporter.common.Time period'];
		var hrsLbl=jsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=jsonData.screenLabels['reporter.common.From'];
		//	var minsLbl=jsonData.screenLabels['reporter.common.Mins'];
		var toLbl=jsonData.screenLabels['reporter.common.To'];
		var reportGenerationLbl=jsonData.screenLabels['reporter.consolidated.Report Generation'];
		var reportNameLbl=jsonData.screenLabels['reporter.consolidated.Report Name'];

		var showDataOptionsRawData = jsonData['showDataOptionsArr'];
		var showdetailsCombo = settingsForm.findField('showdetailsCombo');
		showdetailsCombo.setFieldLabel(showDataLbl);
		showdetailsCombo.getStore().loadRawData(showDataOptionsRawData);
		showdetailsCombo.setValue(jsonData.pageParams.selectedShowData);
		if (jsonData.pageParams.selectedShowData=='Yes')
		{
			isTrend=true;
		}
		var trendenablee=jsonData['hiddenParams'].trendenable;
		if(trendenablee == 'false')
		{
			Ext.getCmp('showdetailsCombo').hide();
		}
		else
		{
			Ext.getCmp('showdetailsCombo').show();
		}
		var excludeWeekendMainLbl = Ext.getCmp('excludeWeekendsCombo');
		excludeWeekendMainLbl.setFieldLabel(excludeWeekendsLbl);

		var excludeWeekendsComboRawData = jsonData['excludeWeekendsCombo'];
 		var excludeWeekendsCombo = settingsForm.findField('excludeWeekendsCombo');
		excludeWeekendsCombo.getStore().loadRawData(excludeWeekendsComboRawData);
		excludeWeekendsCombo.setValue(jsonData.pageParams.selectedShowData);

		/*var excludeWeekendLbl = Ext.getCmp('excludeWeekendLbl');
		excludeWeekendLbl.update(excludesLbl);*/

		var timeperiodLblObj = Ext.getCmp('timeperiodLbl');
		timeperiodLblObj.setText(timePeriodLbl);

		var fromTimeLblObj = Ext.getCmp('fromTimeLbl');
		fromTimeLblObj.setText(fromLbl);

		var fromHrsLblObj =  Ext.getCmp('fromHrsLbl');
		fromHrsLblObj.setText(hrsLbl);

		var toTimeLblObj = Ext.getCmp('toTimeLbl');
		toTimeLblObj.setText(toLbl);

		var toHrsLblObj =  Ext.getCmp('toHrsLbl');
		toHrsLblObj.setText(hrsLbl);

		var timePeriodFromHrsObj = settingsForm.findField('timefrom');
		timePeriodFromHrsObj.setValue(jsonData.pageParams.Hourfrom);

		var timePeriodFromMinsObj = settingsForm.findField('minfrom');
		timePeriodFromMinsObj.setValue(jsonData.pageParams.Minfrom);


		var timePeriodToHrsObj = settingsForm.findField('timeto');
		timePeriodToHrsObj.setValue(jsonData.pageParams.Hourto);

		var timePeriodToMinsObj = settingsForm.findField('minto');
		timePeriodToMinsObj.setValue(jsonData.pageParams.Minto);

		var reportGenerationRawData = jsonData['repGenOptionsArr'];
		var reportGenObj = settingsForm.findField('reportGeneration');
		reportGenObj.getStore().loadRawData(reportGenerationRawData);
		reportGenObj.setValue(jsonData.pageParams['selectedRepGenType']);
		reportGenObj.setFieldLabel(reportGenerationLbl);

		var reportNameObj = settingsForm.findField('bgReportName');
		reportNameObj.setFieldLabel(reportNameLbl);
	},
	loadFields: function(jsonData)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var hrsLbl=jsonData.screenLabels['reporter.common.Hrs'];
		var fromLbl=jsonData.screenLabels['reporter.common.From'];
		//	var minsLbl=jsonData.screenLabels['reporter.common.Mins'];
		var toLbl=jsonData.screenLabels['reporter.common.To'];
		var pageTitle = jsonData.screenLabels['pageTitle'];
		var serverLbl=jsonData.screenLabels['reporter.consolidated.Server'];
		var timelineLbl=jsonData.screenLabels['reporter.common.Timeline'];
		var submitBtnLbl=jsonData.screenLabels['submitBtnLbl'];

		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(pageTitle);

		//var submitButtonObj = Ext.getCmp("submit");
		//submitButtonObj.setText(submitBtnLbl);
		if (jsonData.pageParams.selectedShowData=='Yes')
		{
			isTrend=true;
		}
		var er_show_details = jsonData.pageParams.selectedShowData;
        var hiddenFields = jsonData.hiddenParams;
        var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes")||(fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var selectedReportType = jsonData.pageParams.selectedReportType;

		var componentSelectBox = consolidatedServerForm.findField('componentSelectBox');
		var compTypeOptionsRawData = jsonData['compTypeOptionsArr'];
		componentSelectBox.setFieldLabel(serverLbl);
		componentSelectBox.getStore().loadRawData(compTypeOptionsRawData);
		componentSelectBox.setValue(jsonData.pageParams['selectedCompType']);
 

		var isVMResent = jsonData.pageParams['isVMResent'];

		if(!Ext.isEmpty(isVMResent) && isVMResent=="true")
		{

			jsonData.screenLabels['reporter.consolidated.Filter by VM'];
			jsonData.screenLabels['reporter.consolidated.Optional'];
			jsonData.screenLabels['reporter.consolidated.Virtual Machine"'];

			var isVMSearchNeeded = jsonData.pageParams['isVMSearchNeeded'];

			var showVirtualServer = Ext.getCmp("showVirtualServer");
			var showVirtualServerLbl = Ext.getCmp("showVirtualServer");//"showVirtualServerLbl");
			var showVirtualServer = consolidatedServerForm.findField("showVirtualServer");
			showVirtualServerLbl.setFieldLabel(jsonData.screenLabels['reporter.consolidated.Show virtual machine']);
			var yesNoOptionsRawData = jsonData['yesNoOptionsArr'];
			showVirtualServer.getStore().loadRawData(yesNoOptionsRawData);
			var isShowVirtualServer = jsonData.pageParams['showVirtualMachine'];

			var select_guestObj = consolidatedServerForm.findField("select_guest");

			if(!Ext.isEmpty(isShowVirtualServer) && isShowVirtualServer == "Yes")
			{
				showVirtualServer.setValue("Yes");
				select_guestObj.show();
			}
			else
			{
				showVirtualServer.setValue("No");
				select_guestObj.hide();
			}
			showVirtualServer.show();

			select_guestObj.setFieldLabel(jsonData.screenLabels['reporter.consolidated.Virtual Machine']);
			var vmJsonArr =jsonData['vmJsonArr'];
			var selectedVM =jsonData.pageParams['selectedVM'];
			select_guestObj.getStore().loadRawData(vmJsonArr);
			select_guestObj.setValue(selectedVM);

		}
		else
		{
			var showVirtualServer = Ext.getCmp("showVirtualServer");
			showVirtualServer.hide();

			var select_guestObj = consolidatedServerForm.findField("select_guest");
			select_guestObj.hide();
		}

		var graphModeComboObj = Ext.getCmp("er_mode"); // since,there is no graph mode option for this report,
 		if(!Ext.isEmpty(graphModeComboObj))
			graphModeComboObj.hide();

		var timelineJSONArray = jsonData['timelineJSONArray'];
		var timeLineComboObj = consolidatedServerForm.findField('er_timeline');
		timeLineComboObj.getStore().loadRawData(timelineJSONArray);
		timeLineComboObj.setValue(jsonData.pageParams.selectedTimeline);

		var startdateObj = consolidatedServerForm.findField('er_stdate');
		var enddateObj = consolidatedServerForm.findField('er_enddate');
		var startHourObj = consolidatedServerForm.findField('er_sthr');
		var endHourObj = consolidatedServerForm.findField('er_endhr');
		//
		var timelineComboVal = timeLineComboObj.getValue();
		if ( timelineComboVal == 'Any' )
		{
			startdateObj.setDisabled(false);
			enddateObj.setDisabled(false);
			startHourObj.setDisabled(false);
			endHourObj.setDisabled(false);
		}
		else
		{
			startdateObj.setDisabled(true);
			enddateObj.setDisabled(true);
			startHourObj.setDisabled(true);
			endHourObj.setDisabled(true);
		}
		//
		var stDate = jsonData.pageParams['s_st_time'];
		var endDate = jsonData.pageParams['s_en_time'];
		var startHr = jsonData.pageParams['starthr'];
		var endHr = jsonData.pageParams['endhr'];

		startdateObj.setValue(jsonData.pageParams['startDateForDisplay']);
		startdateObj.dataArray=stDate;
		enddateObj.setValue(jsonData.pageParams['endDateForDisplay']);
		enddateObj.dataArray=endDate;
		startHourObj.setValue(jsonData.pageParams['startHourForDisplay']);
		startHourObj.dataArray=startHr;
		endHourObj.setValue(jsonData.pageParams['endHourForDisplay']);
		endHourObj.dataArray=endHr;
		 updatingAppSettings();
		appConstants.loadMask.hide();
	},
	changeTrend: function(combo)
	{
		var consolidatedServerForm = this.getConsolidatedservermainform().getForm();
		var settingsForm = this.getConsolidatedserversettings().getForm();
		var timelineComboObj = consolidatedServerForm.findField('er_timeline');
		var timelineComboVal = timelineComboObj.getValue();
		var startdateObj =  consolidatedServerForm.findField('er_stdate');
		var enddateObj =  consolidatedServerForm.findField('er_enddate');
		var startHourObj =  consolidatedServerForm.findField('er_sthr');
		var endHourObj =  consolidatedServerForm.findField('er_endhr');
		var er_show_details = settingsForm.findField('showdetailsCombo').getValue();

		var  comboBoxId = combo.getId();

		var changeTimeline = false;

		if ( timelineComboVal == 'Any' )
		{
			startdateObj.setDisabled(false);
			enddateObj.setDisabled(false);
			startHourObj.setDisabled(false);
			endHourObj.setDisabled(false);

			if(comboBoxId=="showdetailsCombo")
			{
				changeTimeline = true;
			}
		}
		else
		{
			startdateObj.setDisabled(true);
			enddateObj.setDisabled(true);
			startHourObj.setDisabled(true);
			endHourObj.setDisabled(true);
			changeTimeline = true;
		}
		if(changeTimeline===true)
		{
			var er_timeline=Ext.getCmp('er_timeline').getValue();
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_show_details + "]";
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1,
				scope : this,
				async : true,
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					var comboVal=jsonData.combo;
					var timelineRawData = jsonData.combo;
					var timelineCombo = Ext.getCmp('er_timeline');
					timelineCombo.getStore().removeAll();
					timelineCombo.getStore().loadRawData(jsonData.combo);
					var flag=false;
					for(var i = 0; i < comboVal.length; i++)
					{
					  if(comboVal[i].valueField == er_timeline)
					  {
						flag=true;
					  }
					}
					if(flag)
						timelineCombo.setValue(er_timeline);
					else
						timelineCombo.setValue("1 day");
				}
			});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal =appConstants.publicJsonData['hiddenParams']['inidate']
			
			var param_val = "";  
		
		if (er_show_details == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
			});
		}
	},
	showBackgroundReport: function(combo)
	{
		var settingsForm = this.getConsolidatedserversettings().getForm();
		var val = combo.getValue();
		var reportNameObj = settingsForm.findField('bgReportName');
		if ( val == 'background' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else if ( val == 'background-csv' )
		{
			reportNameObj.show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else
		{
			reportNameObj.hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	insertTypeAndAll: function( screenLabel , key , loadObj)
	{
		var tmpStore = loadObj.getStore();
		tmpStore.insert(0,{
			'displayField':screenLabel,
			'valueField':'-1'
		});
		if ( tmpStore.getCount() > 2 )
		{
			tmpStore.insert( tmpStore.getCount(),{
			'displayField':'All',
			'valueField':'All'
			});
		}
	},
	insertNotApplicable: function( val, loadObj )
	{
		var tmpStore = loadObj.getStore();
		tmpStore.removeAll();
		tmpStore.insert(0,{
			'displayField': val,
			'valueField': val
		});
		if ( loadObj.getId() != 'components' )
		{
			loadObj.setValue(val);
		}
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});