Ext.define('ConsolidatedService.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			},{
				selector : 'newUtilities',
				ref : 'newUtilities'
			}, {
				selector : 'consolidatedservicesettings',
				ref : 'consolidatedservicesettings'
			},{
				selector : 'consolidatedservicemainform',
				ref : 'consolidatedservicemainform'
			},
			{selector:'nomeasurepanel', ref:'nomeasurepanel'},
			{selector: 'backGroundPanel',ref: 'backGroundPanel'}],
	init : function() {
		this.control({
			'main' : {
				'boxready' : this.boxReadyFn,
				'afterrender' : this.loadDefaultComponenets
			},
			'main newUtilities' : {
				'afterrender' : this.hideTools
			},
			'reportgeneration combo[id=reportGeneration]' : {
				'select' : this.enableReportNameField
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'excludeweekends combo[id=excludeWeekendsCombo]' : {
				'select' : this.enableExcludeWeekendLabel
			},
			'consolidatedservicesettings combo[id=er_timeline]' : {
				'select' : this.enableTimeFields
			},
			'consolidatedservicemainform combo[id=reportSelectBox]' : {
				'select' : this.enableReportContainers
			},
			'consolidatedservicemainform combo[id=er_hservice]' : {
				'select' : this.filterServiceHealth
			},
			'consolidatedservicemainform combo[id=er_iisservice]' : {
				'select' : this.filterIISTransaction
			},				
			'consolidatedservicemainform button[id="submit"]' : {
				'click' : this.showData
			},
			'consolidatedservicemainform button[name="save"]': {
				'click': this.add
			 },
			'consolidatedservicemainform multiselect[name="multiselect"]' : {
				'change' : this.filtermultiselectonIIS
			},				
			'consolidatedservicemainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},			
			'datagrid textfield[name="livesearch"]' : {
				keyup : this.changeval
			},
			'datagrid textfield[name="livesearch1"]' : {
				keyup : this.changeval
			},
			'newUtilities > #favoriteTool > button' : {
				'click' : this.add
			},
			'newUtilities > #scheduleTool > button' : {
				'click' : this.add
			},
			'newUtilities > #saveTool > button' : {
				'click' : this.saveFileTool
			},
			'newUtilities > #printTool > button' : {
				'click' : this.printFile
			},
			'newUtilities > #mailTool > button' : {
				'click' : this.sendMail
			},
			'newUtilities > #csvTool > button':{
				 'click':this.saveCsv
			 },
			'main button[id="expandComponent"]':
			{
				'click':this.expandComponent
			},
			'main button[id="expandTranscations"]':
			{
				'click':this.expandTransaction
			},
			'main trigger[id="componentSearch"]':
			{
				'change':this.filterMultiselect
			},
			'main trigger[id="transactionSearch"]':
			{
				'change':this.filterMultiselect
			}
		});
	},
	filterMultiselect:function(obj){
	if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var compId = obj.getId();
		if(compId=='componentSearch')
		{
			compStore = appConstants.rawDataForComponents;
			compName='multiselect';
		}else if(compId=='transactionSearch')
		{
			compStore = appConstants.rawDataForTransaction;
			compName='multiselect1';
		}
		obj.toggleTriggger();
	  appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
		
	expandComponent:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('multiselect'),Ext.getCmp('components').text,btn);
	},
	expandTransaction:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('multiselect1'),Ext.getCmp('transaction').text,btn);
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('serviceform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	 filterIISTransactionclick: function (combo) {
		this.filterIISTransaction();
	 },
	 boxReadyFn:function()
	 {
		
		//----added for  auto  enableReportContainers---------
		//Ext.getCmp('reportSelectBox').setValue(select_report);
		this.enableReportContainers();			
		
		//-----------------------------------------------------
		if((appConstants.isSubmit=='yes' || appConstants.executeFavorite=="true" ) && appConstants.fromSchModify==null)
		{
			this.enableReportContainers();			
			this.filterServiceHealth();
		}

		if(appConstants.isSubmit=='yes' || appConstants.executeFavorite=="true")
		{
			this.showData();
		}
	 },
	loadDefaultComponenets : function() {
		 Ext.getCmp('moreOptionCloseId').show();
				if(!hideBackButton){
			Ext.getCmp('serviceform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: defaultJSON.json['ID']
				}
			);
		}
		var hiddenParams =defaultJSON['hiddenFields'];
		if(hiddenParams!=undefined){
			 var from_schedule = hiddenParams['fromScheduleModify'];
			var fromFavoriteModify = hiddenParams["fromFavoriteModify"];
			if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
				Ext.getCmp("favoriteTool").setDisabled(true);
			        Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}
		}
		var screenLabels = defaultJSON['screenLabels'];
		var reportCombo = defaultJSON['reportCombo'];
		Ext.getCmp("er_mode").hide();
		this.getConsolidatedservicemainform().loadDefaultScreenLabels(screenLabels);
		
		this.getConsolidatedservicemainform().loadDefaultComboValues(defaultJSON);
		
// by karthikeyan
		if (!Ext.isEmpty(appConstants.er_RmDispName) && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
	/*	else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);*/
//
		this.getConsolidatedservicesettings().loadDatas(defaultJSON);
		
		
		
	},
	hideTools : function() {

		this.getNewUtilities().loadIcon(true, // save
				true, // print
				true, // mail
				false, // data
				true, // cvs
				true, // fav
				true,// schedule
				false, // daignosis
				false, // togglebutton
				false, // close
				true // booklets
				);

		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);	

	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showData();
		}
	},
	validateAndCloseSettings:function()
	{
		if ((Ext.getCmp('reportGeneration').getValue() == 'background' || Ext.getCmp('reportGeneration').getValue() == 'background-csv' )&& !validateTextBox(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	enableReportNameField : function(combo) {
		if (combo.getValue() == 'background' || combo.getValue() == 'background-csv') {
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		} else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}	
	},
	enableExcludeWeekendLabel : function(combo) {
		if (combo.getValue() == 'Yes') {
			Ext.getCmp('excludeWeekendLbl').show();
		} else
			Ext.getCmp('excludeWeekendLbl').hide();
	},
	enableTimeFields : function(combo) {
		var form = combo.up('form').getForm();
		if (combo.getValue() == 'Any') {
			form.findField('er_enddate').setDisabled(false);
			form.findField('er_endhr').setDisabled(false);
			form.findField('er_sthr').setDisabled(false);
			form.findField('er_stdate').setDisabled(false);
		} else {
			form.findField('er_enddate').setDisabled(true);
			form.findField('er_endhr').setDisabled(true);
			form.findField('er_sthr').setDisabled(true);
			form.findField('er_stdate').setDisabled(true);

			var timeline = form.findField("er_timeline").getValue();
			var strthour = form.findField("er_sthr").getValue();
			var endhr = form.findField("er_endhr").getValue();

			var strtdt = form.findField("er_stdate").getValue();
			var enddt = form.findField("er_enddate").getValue();

			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);

			var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=["
					+ enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=["
					+ mgrDateFormat + "]";

			var param = "F=getTime&C=id" + no_params;

			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param,
				scope : this,
				method : 'POST',
				success : function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					if (!Ext.isEmpty(jsonData)) {

						var timedata = jsonData.timeline;
						var startDate = "";
						var endDate = "";
						var starthr = "";
						var endhr = "";
						var startmin = "";
						var endmin = "";
						for (var ctr = 0; ctr < timedata.length; ctr = ctr + 5) {
							startDate = timedata[0];
							endDate = timedata[1];
							starthr = timedata[2];
							endhr = timedata[3];

							startmin = timedata[4];
							endmin = timedata[5];
						}
						formated_sdate = Ext.Date.dateFormat(startDate,mgrDateFormat);
						formated_edate = Ext.Date.dateFormat(endDate,mgrDateFormat);

						form.findField("er_stdate").setValue(startDate);
						form.findField("er_enddate").setValue(endDate);
						form.findField("er_sthr").setValue(starthr);
						form.findField("er_endhr").setValue(endhr);
					}
				}
			});
		}
	},
	enableReportContainers : function() {
		this.getConsolidatedservicemainform().enableReportContainers();
	},
	enableTransaction : function() {
		Ext.getCmp('er_showTransaction').show();
	},
	filterServiceHealth : function(combo) {
		var val =Ext.getCmp('er_hservice').getValue();

		if (val == '-1') {
			var form = Ext.getCmp('serviceform').getForm();
			var serviceform = Ext.getCmp('serviceform');
			this.setNotApplicable(form, 'er_comptype',serviceform.screenLabels);
		} else {
			var url = '/final/servlet/com.eg.ErConsolidatedServiceDispatcher';
			var param = 'isFromClient=yes&controller=servicehealth&isSubmit=no&isFilter=yes&select_report='+ val+'&userID='+appConstants.userID;
			this.doFilter('er_comptype', url, param, Ext.getCmp('er_hservice'));
		}
	},
	filterIISTransaction : function(combo) {

				var resultObj = Ext.getCmp('result');
		resultObj.removeAll();
		var val = combo.getValue();
				//var val =Ext.getCmp('er_iisservice').getValue();


		if (val == '-1') {
			var form = combo.up('.form').getForm();
			var serviceform = Ext.getCmp('serviceform');
			this
					.setNotApplicable(form, 'multiselect',
							serviceform.screenLabels);
			this.setNotApplicable(form, 'multiselect1',
					serviceform.screenLabels);
		} else {
			var url = '/final/servlet/com.eg.ErConsolidatedServiceDispatcher';
			var param = 'isFromClient=yes&controller=iistransaction&isSubmit=no&isFilter=yes&comp=false&er_service='+ val;
			if(val !=null && val == '--DefaultService--')
				param +='&userID='+appConstants.userID;

			this.doFilter('multiselect', url, param, combo);



		}
	},
	filtermultiselectonIIS : function(me, newValue, oldValue, eOpts) {
		var val = newValue;
		
		if (oldValue == "" || oldValue == "-1" || oldValue == undefined) {
			
		}
		var resultObj = Ext.getCmp('result');
		resultObj.removeAll();

		var form = me.up('.form').getForm();
		if (val == '-1') {
			var serviceform = Ext.getCmp('serviceform');
			this.setNotApplicable(form, 'multiselect1',
					serviceform.screenLabels);
		} else {
			var er_service = form.findField('er_iisservice').getValue();
			var url = '/final/servlet/com.eg.ErConsolidatedServiceDispatcher';
			var param = 'isFromClient=yes&controller=iistransaction&isSubmit=no&isFilter=yes&comp=true&er_service='
					+ er_service + '&comps=' + val;

			this.doFilter('multiselect1', url, param, me);

		}

	},
	doFilter : function(field, url, param, combo) {

		var me = this;
		Ext.Ajax.request({
					url : url,
					params : param+"&er_RmDispName="+appConstants.er_RmDispName,
					anync:false,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);

						var form = combo.up('.form').getForm();
						if (field == 'er_comptype') {
							if (jsonObject['ComptypeCombo'] != null
									&& jsonObject['ComptypeCombo'] != undefined) {
								form.findField(field).getStore().clearFilter(true); 
								form.findField(field).getStore().loadRawData(jsonObject['ComptypeCombo']);
								if (jsonObject['ComptypeCombo'].length > 1)
					form.findField(field).setValue(form.findField(field).getStore().getAt(1));
								else if (jsonObject['ComptypeCombo'].length == 1)
					form.findField(field).setValue(form.findField(field).getStore().getAt(0));
								if (jsonObject['er_service'].length > 1){
									combo.setValue(jsonObject['er_service']);
								}else{
								combo.setValue(form.findField('er_hservice').getStore().getAt(1));
								}
							}
							if (jsonObject['showTransCombo'] != null && jsonObject['showTransCombo'] != undefined) 
							{
								if (jsonObject['enableShowTransCombo'] != null && jsonObject['enableShowTransCombo'] == 'yes') 
								{
									form.findField('er_showTransaction').show();
									form.findField('er_showTransaction').getStore().loadRawData(jsonObject['showTransCombo']);
									if (jsonObject['showtransValue']!=null && jsonObject['showtransValue']!=undefined && jsonObject['showtransValue'].length > 1){
										form.findField('er_showTransaction').setValue(jsonObject['showtransValue']);
									}else{
												form.findField('er_showTransaction').setValue(form
												.findField('er_showTransaction').getStore()
												.getAt(1));
									}
								}
								else
								{
									form.findField('er_showTransaction').hide();
								}
							}
							if(appConstants.isSubmit=='yes' || (appConstants.executeFavorite=="true" || appConstants.fromSchModify=='Yes') )
							{
								Ext.getCmp('er_showTransaction').setValue(appConstants.er_showTransaction);
							}
						} else if (field == 'multiselect1') {
							if (jsonObject['transMultiSelect'] != null && jsonObject['transMultiSelect'] != undefined) {
								appConstants.rawDataForTransaction=jsonObject['transMultiSelect'];
								form.findField('multiselect1').getStore().loadRawData(jsonObject['transMultiSelect']);
								form.findField('multiselect1').setValue(jsonObject['transMultiSelectValue']);
							}
						} else {
							if (jsonObject['compMultiselect'] != null
									&& jsonObject['compMultiselect'] != undefined) {
								// var vall =Ext.getCmp('er_iisservice').getValue();
								 //  if(val.equals(jsonObject['compMultiselect']))
							//	{
								
								appConstants.rawDataForComponents=jsonObject['compMultiselect'];
								form.findField('multiselect').getStore().loadRawData(jsonObject['compMultiselect']);
								form.findField('multiselect').setValue(jsonObject['compMultiselectValue']);
							//}
							}
							if (jsonObject['transMultiSelect'] != null&& jsonObject['transMultiSelect'] != undefined) {
								appConstants.rawDataForTransaction=jsonObject['transMultiSelect'];
								form.findField('multiselect1').getStore().loadRawData(jsonObject['transMultiSelect']);
								form.findField('multiselect1').setValue(jsonObject['transMultiSelectValue']);
							}
						}
						if(appConstants.isFromClient==null || appConstants.isFromClient =='null' || appConstants.isFromClient==undefined){
							if( appConstants.isSubmit=='yes' || appConstants.executeFavorite=="true")
							{
								me.showData();
							}
						}
					}
				});


	},
	setNotApplicable : function(form, fieldname, screenLabel) {
		form.findField(fieldname).getStore().removeAll();
		form.findField(fieldname).getStore().loadRawData([{
					"displayField" : screenLabel['reporter.common.Not Applicable'],
					"valueField" : "-1"
				}]);
		form.findField(fieldname).setValue("-1");
	},
	showData : function(button) {
		var mainForm = Ext.getCmp('serviceform').getForm();
		var report = appConstants.select_report;//mainForm.findField('reportSelectBox').getValue();

		if (report != null && report == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please choose the Report',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		Ext.getCmp('panelinsidetoggle').setDisabled(false);//by ezhil
		if (report == 'WebTransactions') {
			this.submitWebTransactionData(mainForm, report);
		} else if (report == 'ServicesHealth') {
			this.submitData(mainForm, report);
		} else {
			this.submitSlowTransaction(mainForm, report);
		}

	},
	submitWebTransactionData : function(mainForm, report) {
		var er_service = mainForm.findField('er_service').getValue();

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = mainForm.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration')
				.getValue();

		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);

		var starttime = formatDate(new Date(getDateFromFormat(startdate,
						appConstants.currdtFormat)), "MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,
						appConstants.currdtFormat)), "MM/dd/yyyy");

		var bool = checktime(starttime, endtime, starthr, endhr);

		if (report == 'Not Applicable' && er_service == 'Not Applicable') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.naalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		if (er_service == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.sitealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		if (timefrom > 00) {
			if (timefrom > timeto) {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.timealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;

			} else if (timefrom == timeto) {
				if (minfrom == minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;

				} else if (minfrom > minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;

				}

			}
		}

		if (timefrom >= timeto && minfrom >= 00 && (minfrom > minto)
				&& (timeto < 24)) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.timealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;

		}

		if (timeto == '24' && minto > 0) {
			Ext.Msg.show({
						title : 'Alert',
						msg : minselalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;

		}

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;

		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";

		}

		if ((minfrom == 'undefined' || minfrom == undefined) || (minfrom == null || minfrom == 'null'))
			minfrom='00';
		if ((minto == 'undefined' || minto == undefined) || (minto == null || minto == 'null'))
			minto='00';


		param += "er_service=" + er_service + "&timefrom=" + timefrom
				+ "&timeto=" + timeto + "&minfrom=" + minfrom + "&minto="
				+ minto;

		param += "&select_report=" + report + "&er_timeline=" + er_timeline;

		param += "&er_reportgenration=" + er_reportgenration
				+ "&isFromClient=yes&controller=webtransaction&isSubmit=yes";

		param += "&startdate=" + startdate + "&enddate=" + enddate
				+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		var bdenabled = hiddenFields['bgenabled'];

		var msxdays = hiddenFields["getMaxDaysInMonth"];
		var inidate = hiddenFields["inidate"];
		var usertimeline = '-1';
		
		if (bool) 
		{
			var limitforbg = hiddenFields['limitforbg'];
				var bgtime = getTimeValues(limitforbg, msxdays, startdate,enddate, inidate);
				var getimeline = getTimeValues(er_timeline, msxdays, startdate,enddate, inidate);
				var selectbackground = er_reportgenration;
				var bg_reportname = settingsForm.findField('bgReportName').getValue();
				if (selectbackground=='background')
				{
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname;
							this.ShowWebTransactionData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
						} 
					}
				}
				else if (selectbackground=='background-csv')
				{
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname;
							this.ShowWebTransactionData(param,"../servlet/com.eg.ErStartBackGroundReportC?isSubmit=yes&SaveFormat=CSV");
						} 
					}
				}
				else if (getimeline >bgtime && selectbackground == 'foreground')
				{
						Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn) 
						{
						if (btn == "no") 
						{
							settingsForm.findField('reportGeneration').setValue('background');
							settingsForm.findField('bgReportName').setValue("");
							settingsForm.findField('bgReportName').show();
							if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) 
							{
								var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
								if (timeVal) 
								{ 
									bg_reportname=checkFileName(bg_reportname);
									param += "&bg_reportname=" + bg_reportname;
									this.ShowWebTransactionData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
								} 
							}
						} 
						else 
						{
							var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
							if (timeVal) 
							{
								this.ShowWebTransactionData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
							}
						}

					}, this);
				}
				else if (selectbackground == 'foreground')
				{
					var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
					if (timeVal) 
					{
						this.ShowWebTransactionData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
					}
				}
		}
		else
		{
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
		}
	},
	submitData : function(mainForm, report) {

		var er_service = mainForm.findField('er_hservice').getValue();
		var er_comptype = mainForm.findField('er_comptype').getValue();
		var er_showTransaction = mainForm.findField('er_showTransaction')
				.getValue();


		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = mainForm.findField('er_timeline').getValue();

		var er_reportgenration = settingsForm.findField('reportGeneration')
				.getValue();
		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);

		var starttime = formatDate(new Date(getDateFromFormat(startdate,
						appConstants.currdtFormat)), "MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,
						appConstants.currdtFormat)), "MM/dd/yyyy");

		var bool = checktime(starttime, endtime, starthr, endhr);

		if (report == 'Not Applicable' && er_service == 'Not Applicable') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.naalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		if (er_service == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.sitealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		if (er_comptype == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.ctypealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		if (timefrom > 00) {
			if (timefrom > timeto) {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.timealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;

			} else if (timefrom == timeto) {
				if (minfrom == minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;

				} else if (minfrom > minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;
				}
			}
		}
		if (timefrom >= timeto && minfrom >= 00 && (minfrom > minto)
				&& (timeto < 24)) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.timealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		if (timeto == '24' && minto > 0) {
			Ext.Msg.show({
						title : 'Alert',
						msg : minselalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";
		}
		param += "&er_service=" + er_service + "&timefrom=" + timefrom
				+ "&timeto=" + timeto + "&minfrom=" + minfrom + "&minto="
				+ minto;
		param += "&er_service=" + er_service + "&er_comptype=" + er_comptype;

		param += "&er_showTransaction=" + er_showTransaction
				+ "&select_report=" + report + "&er_timeline=" + er_timeline;

		param += "&er_reportgenration=" + er_reportgenration
				+ "&isFromClient=yes&controller=servicehealth&isSubmit=yes";

		param += "&startdate=" + startdate + "&enddate=" + enddate
				+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
				
		param +="&select_farm=Consolidated Report&ercontype=consolidated&erservice=Service Health";

		var bdenabled = hiddenFields['bgenabled'];

		var msxdays = hiddenFields["getMaxDaysInMonth"];
		var inidate = hiddenFields["inidate"];
		var usertimeline = '-1';
		if (bool) 
		{
			var limitforbg = hiddenFields['limitforbg'];
				var bgtime = getTimeValues(limitforbg, msxdays, startdate,enddate, inidate);
				var getimeline = getTimeValues(er_timeline, msxdays, startdate,enddate, inidate);
				var selectbackground = er_reportgenration;
				var bg_reportname = settingsForm.findField('bgReportName').getValue();
				if (selectbackground=='background')
				{
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname+"&pageWidthProces="+appConstants.pageWidth;
							this.ShowServiceHealthData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
						} 
					}
				}
				else if (selectbackground=='background-csv')
				{
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname;
							this.ShowServiceHealthData(param,"../servlet/com.eg.ErStartBackGroundReportC?isSubmit=yes&SaveFormat=CSV");
						} 
					}
				}
				else if (getimeline >bgtime && selectbackground == 'foreground')
				{
						Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn) 
						{
						if (btn == "no") 
						{
							settingsForm.findField('reportGeneration').setValue('background');
							settingsForm.findField('bgReportName').setValue("");
							settingsForm.findField('bgReportName').show();
							if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) 
							{
								var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
								if (timeVal) 
								{			
									bg_reportname=checkFileName(bg_reportname);
									param += "&bg_reportname=" + bg_reportname;
									this.ShowServiceHealthData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
								} 
							}
						} 
						else 
						{
							var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
							if (timeVal) 
							{
								this.ShowServiceHealthData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
							}
						}

					}, this);
				}
				else if (selectbackground == 'foreground')
				{
					var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
					if (timeVal) 
					{
						this.ShowServiceHealthData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
					}
				}
		}
		else
		{
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
		}
	},
	submitSlowTransaction : function(mainForm, report) {

		var er_service = mainForm.findField('er_iisservice').getValue();
		

		var er_component = mainForm.findField('multiselect').getValue();
		var er_transaction = mainForm.findField('multiselect1').getValue();
		var er_category = mainForm.findField('er_category').getValue();

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = mainForm.findField('er_timeline').getValue();

		var er_reportgenration = settingsForm.findField('reportGeneration').getValue();
		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = mainForm.findField('er_stdate').dataArray;
		var starthr = mainForm.findField('er_sthr').dataArray;
		var enddate = mainForm.findField('er_enddate').dataArray;
		var endhr = mainForm.findField('er_endhr').dataArray;

		//startdate = Ext.Date.dateFormat(startdate, mgrDateFormat);
		//enddate = Ext.Date.dateFormat(enddate, mgrDateFormat);

		var starttime = formatDate(new Date(getDateFromFormat(startdate,appConstants.currdtFormat)), "MM/dd/yyyy");
		var endtime = formatDate(new Date(getDateFromFormat(enddate,appConstants.currdtFormat)), "MM/dd/yyyy");

		var bool = checktime(starttime, endtime, starthr, endhr);

		if (report == 'Not Applicable' && er_service == 'Not Applicable') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.naalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		if (er_service == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.sitealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}
		
		if (er_transaction == '-1') {
			Ext.Msg.show({
						title : 'Alert',
						msg : 'Please choose the parameter',
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;
		}

		if (timefrom > 00) {
			if (timefrom > timeto) {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.timealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;

			} else if (timefrom == timeto) {
				if (minfrom == minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;

				} else if (minfrom > minto) {
					Ext.Msg.show({
								title : 'Alert',
								msg : appConstants.timealert,
								buttons : Ext.Msg.OK,
								icon : Ext.Msg.WARNING
							});
					return;

				}

			}
		}

		if (timefrom >= timeto && minfrom >= 00 && (minfrom > minto)
				&& (timeto < 24)) {
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.timealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;

		}

		if (timeto == '24' && minto > 0) {
			Ext.Msg.show({
						title : 'Alert',
						msg : minselalert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
			return;

		}

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;
		var param = "";
		for (var hiddenField in hiddenFields) {

			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += hiddenField + "=" + val;
			param += "&";

		}

		var transParam = "";

		for (var tr in er_transaction) {
			transParam += "&er_transaction=" + er_transaction[tr];
		}

		var compparms = "";
		for (var cr in er_component) {
			compparms += "&er_component=" + er_component[cr];
		}

		param += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="
				+ minfrom + "&minto=" + minto;

		param += "&er_service=" + er_service + compparms + transParam;
		param += "&select_report=" + report + "&er_timeline=" + er_timeline
				+ "&er_category=" + er_category;
		param += "&er_reportgenration=" + er_reportgenration
				+ "&isFromClient=yes&controller=iistransaction&isSubmit=yes";

		param += "&startdate=" + startdate + "&enddate=" + enddate
				+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		var bdenabled = hiddenFields['bgenabled'];

		var msxdays = hiddenFields["getMaxDaysInMonth"];
		var inidate = hiddenFields["inidate"];
		var usertimeline = '-1';
		if (bool) 
		{
			var limitforbg = hiddenFields['limitforbg'];
				var bgtime = getTimeValues(limitforbg, msxdays, startdate,enddate, inidate);
				var getimeline = getTimeValues(er_timeline, msxdays, startdate,enddate, inidate);
				var selectbackground = er_reportgenration;
				var bg_reportname = settingsForm.findField('bgReportName').getValue();	
				if (selectbackground=='background') {
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname;
							this.ShowSlowTransactionData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
						} 
					}
				}
				else if (selectbackground=='background-csv') {
					if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) {
						var timeVal = getTimeForcurrentuser(startdate, enddate,usertimeline, er_timeline, msxdays, inidate);
						if (timeVal) 
						{
							bg_reportname=checkFileName(bg_reportname);
							param += "&bg_reportname=" + bg_reportname;
							this.ShowSlowTransactionData(param,"../servlet/com.eg.ErStartBackGroundReportC?isSubmit=yes&SaveFormat=CSV");
						} 
					}
				}
				else if (getimeline >bgtime && selectbackground == 'foreground')
				{
						Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn) 
						{
						if (btn == "no") 
						{
							settingsForm.findField('reportGeneration').setValue('background');
							settingsForm.findField('bgReportName').setValue("");
							settingsForm.findField('bgReportName').show();
							if (validateTextBoxWithSpecialChars(bg_reportname,'Attachment',true)) 
							{
								var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
								if (timeVal) 
								{
									bg_reportname=checkFileName(bg_reportname);
									param += "&bg_reportname=" + bg_reportname;
									this.ShowSlowTransactionData(param,'/final/servlet/com.eg.ErStartBackGroundReportC');
								} 
							}
						} 
						else 
						{
							var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
							if (timeVal) 
							{
								this.ShowSlowTransactionData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
							}
						}

					}, this);
				}
				else if (selectbackground == 'foreground')
				{
					var timeVal = getTimeForcurrentuser(startdate, enddate,	usertimeline, er_timeline, msxdays, inidate);
					if (timeVal) 
					{
						this.ShowSlowTransactionData(param,'/final/servlet/com.eg.ErConsolidatedServiceDispatcher');
					}
				}
		}
		else
		{
			Ext.Msg.show({
						title : 'Alert',
						msg : appConstants.datealert,
						buttons : Ext.Msg.OK,
						icon : Ext.Msg.WARNING
					});
		}
	},
	getSubColumns : function(subColumns, i, mcol, colwidth) {

		var subcolumarray = new Array();

		subcolumarray.push({
					header : '(' + subColumns[i] + ')',
					sortable : true,
					align:'center',
					//width : colwidth,
					dataIndex : subColumns[i] + mcol

				});

		return subcolumarray;
	},
	getMainColumnArray : function(mainColumn, fieldstoStore) {

		var maincolumnarray = new Array();
		for (var i in mainColumn) {
			maincolumnarray.push({
						text : mainColumn[i],
						dataIndex : mainColumn[i]
					});
			fieldstoStore.push(mainColumn[i]);
		}
		return maincolumnarray;

	},
	ShowWebTransactionData : function(param, url) {

//by karthikeyan
	param+= '&er_RmDispName='+appConstants.er_RmDispName;
	var loadMask = new Ext.LoadMask(Ext.getBody(), {
		msg : "Loading ..."
	});
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		loadMask.show();
		var resultObj = Ext.getCmp('result');
		resultObj.removeAll();

		Ext.Ajax.request({
			url : url,
			params : param,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonObject = Ext.decode(jsonText);
				if (jsonObject.hasOwnProperty("pageWidth"))
				{
					appConstants.pageWidth=jsonObject.pageWidth;
				}
				else
				{
					appConstants.pageWidth=1024;
				}

				loadMask.hide();
				if (jsonObject != null && !Ext.isEmpty(jsonObject)) {
					try {
						
						var gridObj = jsonObject['gridObj'];
						if (!Ext.isEmpty(gridObj) && gridObj.length > 0) {
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("csvTool").setDisabled(false);
							var itemsArray = new Array();
							for (var i in gridObj) {
								var gridDataObj = gridObj[i];
								var columns = gridDataObj.mainColumns;
								var data = gridDataObj.data;
								var units = gridDataObj.unit;
								var fieldstoStore = new Array();
								var colObject = new Array();
								var mainColumnArray = new Array();
								var needLockedCol = true;
								if(data[0].length<9)
									needLockedCol = false;
								if (i == 0)
								{
									var k = 0;
									var gridWidth = resultObj.getWidth();

									var collen = 0;
									for (var mm in columns) {
										var subarray = new Array();
										subarray = columns[mm];

										if (subarray != undefined
												&& !Ext.isEmpty(subarray)) {

											for (var j = 0; j < subarray.length; j++)
											{
												collen++;
											}
										} else {
											collen++;
										}
									}
									var colWidth = gridWidth / collen;
									for (var mcol in columns) {
										var subarray = new Array();
										subarray = columns[mcol];
										var subColumnArray = new Array();
										var measureColumnArray = new Array();
										if (k == 0)
										{
											fieldstoStore.push(mcol);
											subColumnArray.push({
														header : '&nbsp;',
														dataIndex : mcol,
														align:'center',
														renderer: function( val,metaData )
														{
															metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
															return val;
														}
													});
										}
										if (k == 1)
										{
											for (var j = 0; j < units.length; j++) {
												fieldstoStore.push(subarray[j]
														+ mcol);
												measureColumnArray.push({
															header : units[j],
															columns : this
																	.getSubColumns(
																			subarray,
																			j,
																			mcol,
																			colWidth)
														});
											}
										}
										else if (k == 0) 
										{
											measureColumnArray.push({
														header : '&nbsp;',
														columns : subColumnArray
													});
										}
										if(needLockedCol)
										{
											if (k == 0) 
											{
												mainColumnArray.push({
													header : mcol,
													locked:true,
													dataIndex : mcol,
													align:'left',
													renderer: function( val,metaData )
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
														return val;
													}
												});
											} 
											else 
											{
												mainColumnArray.push({
													header : mcol,
													locked:false,
													columns : measureColumnArray
												});
											}
										}
										else
										{
											if (k == 0)
											{
												mainColumnArray.push({
													header : mcol,
													dataIndex : mcol,
													align:'left',
													renderer: function( val,metaData )
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
														return val;
													}
												});
											} 
											else
											{
												mainColumnArray.push({
													header : mcol,
													columns : measureColumnArray
												});
											}
										}
										k++;
									}
								} 
								else 
								{
									var k = 0;
									var val = "";
									var gridWidth = resultObj.getWidth();

									var collen = 0;
									for (var mm in columns) {
										var subarray = new Array();
										subarray = columns[mm];
										if (subarray != undefined&& !Ext.isEmpty(subarray))
										{
											for (var j = 0; j < subarray.length; j++)
											{
												collen++;
											}
										} 
										else
										{
											collen++;
										}
									}
									var colWidth = (gridWidth / collen)-10;
									for (var mcol in columns) {
										var subarray = new Array();
										subarray = columns[mcol];
										var subColumnArray = new Array();
										var measureColumnArray = new Array();
										if (subarray != undefined
												&& !Ext.isEmpty(subarray)) {
											for (var j = 0; j < subarray.length; j++) {

												subColumnArray.push({
															header : subarray[j],
															sortable : true,
															align:'center',
															//width : colWidth,
															dataIndex : mcol + subarray[j],
															renderer : function(value, metaData, record, row, col, store, gridView) 
															{
																metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
																return value;
														
															}
														});
												fieldstoStore.push(mcol+ subarray[j]);
											}
										} 
										else 
										{
											fieldstoStore.push(mcol);
											subColumnArray.push({
												header : '&nbsp;',
												sortable : true,
												align:'center',
												dataIndex : mcol,
												renderer : function(value, metaData, record, row, col, store, gridView) 
												{
													metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
													if (col == 0) 
													{
														if (!Ext.isEmpty(val) && val != undefined) 
														{
															if (value == val) 
															{
																metaData.style = "overflow:visible;padding-top:5px;";
																return "";
															} 
															else 
															{
																val = value;
																return value;
															}
														} 
														else 
														{
															val = value;
															return value;
														}
													} 
													else 
													{
														return value;
													}

												}
											});
										}
										var isLocked = false;
										if(k==0)
											isLocked = true;
										if (units[k] != undefined
												&& !Ext.isEmpty(units[k])) {
											measureColumnArray.push({
														header : '(' + units[k]
																+ ')',
														columns : subColumnArray
													});
										} else {
											measureColumnArray.push({
														header : '&nbsp;',
														columns : subColumnArray
													});
										}
										if(needLockedCol)
										{
											if (k == 0 || k == 1) 
											{
												mainColumnArray.push({
													header : mcol,
													locked:isLocked,
													dataIndex : mcol,
													width:115,
													renderer: function( val,metaData )
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
														return val;
													}
													//flex : 0.5,
													//minWidth : 100

												});
											}
											else 
											{
												mainColumnArray.push({
													header : mcol,
													locked:isLocked,
													columns : measureColumnArray
												});
											}
										}
										else
										{
											if (k == 0 || k == 1) 
											{
												mainColumnArray.push({
													header : mcol,
													dataIndex : mcol,
													renderer: function( val,metaData )
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
														return val;
													}
													//flex : 0.5,
													//minWidth : 100

												});
											}
											else 
											{
												mainColumnArray.push({
													header : mcol,
													columns : measureColumnArray
												});
											}
										}

										k++;
									}
								}

								var storeObj = Ext.create(
										'Ext.data.ArrayStore', {
											fields : fieldstoStore,
											data : data,
											remoteSort : true,
											autoLoad : true,
											sorters: { property: fieldstoStore[0], direction : 'ASC' }// vengat
										});
								var gridpanel = Ext.widget('customgrid', {
											store : storeObj,
											autoScroll : true,
											scroll : true,
											needtoFixColumn:true,
											ui:'newGridPanel withHeader withShade',
											frame:false,
											border:true,
											margin:'10 10 10 10',
											popUpData:'noToolTip',
											columns : mainColumnArray,
											padding :'8 10 10 10',
											header:{
												style:{
													padding:'0px 10px 8px 0px'
												}
											},
											title : gridDataObj['title'],
											forceFitColsCount:9,
											viewConfig: {
												emptyText: 'No records',
											},
											listeners:{
													render:function(obj){
														Ext.defer(function() {
															//obj.columns[0].setSortState("ASC",true,true);
														},100);
													}
												}
										});

								itemsArray.push(gridpanel);

							}

							resultObj.add(itemsArray);
							resultObj.doLayout();
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);
						} else {
							var nomeas = jsonObject['emptyArray'];
							if (!Ext.isEmpty(nomeas) && nomeas.length > 0) {								
								Ext.getCmp("bookletTool").setDisabled(true);
								Ext.getCmp("saveTool").setDisabled(true);
								Ext.getCmp("printTool").setDisabled(true);
								Ext.getCmp("mailTool").setDisabled(true);
								Ext.getCmp("csvTool").setDisabled(true);
								this.getNomeasurepanel().show();
							} else {
								this.generateBackgroundData(jsonObject,resultObj);
							}
						}

					} catch (e) {
						alert(e);
					}
				}
			}
		});
	},
	generateBackgroundData : function(jsonObject, resultObj) {

		var itemsArray = new Array();
		var grpahQueryString = jsonObject.grpahQueryString;
		var status = grpahQueryString.status;
		var resultObj = this.getBackGroundPanel();
		resultObj.removeAll();

		var htm='';
		if(status!=undefined && status =='success'){
			//htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
		
			htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2+ '</a></div></td></tr></table></td></tr></table>';
		}
		else
		{
			htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';

			htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+grpahQueryString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ grpahQueryString.queryString +'>'+ grpahQueryString.bgstr2+ '</a></div></td></tr></table></td></tr></table>';
		}

		resultObj.update({
			xtype: 'panel',
			margin:0,
			bodyPadding:0,
			height: '100%',
			html: htm
		});
		resultObj.doLayout();
		resultObj.show();
	},
	ShowServiceHealthData : function(param, url) {
//by karthikeyan
	param+= '&er_RmDispName='+appConstants.er_RmDispName;
	var loadMask = new Ext.LoadMask(Ext.getBody(), {
		msg : "Loading ..."
	});
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		loadMask.show();
		var resultObj = Ext.getCmp('result');
		resultObj.removeAll();

		Ext.Ajax.request({
			url : url,
			params : param,
			scope : this,
			success : function(response)
			{
				var jsonText = response.responseText;
				var jsonObject = Ext.decode(jsonText);
				if (jsonObject.hasOwnProperty("pageWidth"))
				{
					appConstants.pageWidth=jsonObject.pageWidth;
				}
				else
				{
					appConstants.pageWidth=1024;
				}
				loadMask.hide();
				if (jsonObject != null && !Ext.isEmpty(jsonObject)) {
					try {

						var gridObj = jsonObject['gridObj'];
						if (!Ext.isEmpty(gridObj) && gridObj.length > 0) 
						{
							Ext.getCmp("printTool").setDisabled(false);
							Ext.getCmp("bookletTool").setDisabled(false);
							Ext.getCmp("saveTool").setDisabled(false);
							Ext.getCmp("mailTool").setDisabled(false);
							Ext.getCmp("csvTool").setDisabled(false);
							var itemsArray = new Array();
							for (var i in gridObj) {
								var gridDataObj = gridObj[i];
								var columns = gridDataObj.mainColumns;
								var data = gridDataObj.data;
								var units = gridDataObj.unit;
								var fieldstoStore = new Array();
								var colObject = new Array();
								var mainColumnArray = new Array();
								var gridWidth = resultObj.getWidth();
								var collen = 0;
								var needGridLock = true;
								if(data[0].length<9)
									needGridLock = false;
								for (var mm in columns) {
									var subarray = new Array();
									subarray = columns[mm];

									if (subarray != undefined&& !Ext.isEmpty(subarray))
									{
										for (var j = 0; j < subarray.length; j++)
										{
											collen++;
										}
									} 
									else 
									{
										collen++;
									}
								}
								var colWidth = (gridWidth / collen)+18;
								var k = 0;
								for (var mcol in columns) {
									var subarray = new Array();
									subarray = columns[mcol];
									var subColumnArray = new Array();
									var measureColumnArray = new Array();
									if (subarray != undefined && !Ext.isEmpty(subarray)) 
									{
										for (var j = 0; j < subarray.length; j++)
										{
											subColumnArray.push({
														header : subarray[j]+" ("+units[k]+")",
														sortable : true,
														align: 'center',
														dataIndex : mcol+ subarray[j],
														doSort: function(state) {
															var ds = this.up('grid').store;
															var field = this.getSortParam();
															ds.sort({
																property: field,
																direction: state,
																sorterFn: function(v1, v2){
																	if (v1.index==0)
																		return;
																	v1 = v1.get(field);
																	v2 = v2.get(field);
																	v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
																	v1= isNaN(v1) ? 0 : v1;
																	v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
																	v2= isNaN(v2) ? 0 : v2;
																	// transform v1 and v2 here
																	return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
																	}
															});
														},
														renderer: function( val,metaData )
														{
															metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
															return val;
														}
													});
											fieldstoStore.push(mcol+ subarray[j]);
										}
									}
									else
									{
										fieldstoStore.push(mcol);
										subColumnArray.push({
											header : " ("+units[k]+")",
											align: 'center',
											sortable : true,
											dataIndex : mcol,
											doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														if (v1.index==0)
															return;
														v1 = v1.get(field);
														v2 = v2.get(field);
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
														}
												});
											},
											renderer : function(value, metaData, record, row, col, store, gridView) 
											{
												if (col == 0) 
												{
													var href = value['href'];
													if (href != undefined) 
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value['value']+'"';
														return '<a class="anchorLinkDefault" href=' + href + '>' + value['value'] + '</a>';
													} 
													else 
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
														return value;
													}
												} 
												else 
												{
													var href = value['href'];
													if (href != undefined) 
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value['value']+'"';
														return '<a class="anchorLinkDefault" href=' + href + '>' + value['value'] + '</a>';
													}
													else
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
														return value;
													}
												}
											}
										});
									}
									if (k == 0) 
									{
										if(needGridLock)
										{
										mainColumnArray.push({
											header : this.wrapText(mcol),
											align: 'left',
											locked:true,
											dataIndex : mcol,
											renderer : function(value, metaData, record, row, col, store, gridView) 
											{
												var href = value['href'];
												if (href != undefined) 
												{
													metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value['value']+'"';
													return '<a class="anchorLinkDefault" href=' + href + '>' + value['value'] + '</a>';
												}
												else
												{
													metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
													return value;
												}
											},
											doSort: function(state) {
												var ds = this.up('grid').store;
												var field = this.getSortParam();
												ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														if (v1.index==0)
															return;
														v1 = v1.get(field);
														v2 = v2.get(field);
														v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
														v1= isNaN(v1) ? 0 : v1;
														v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
														v2= isNaN(v2) ? 0 : v2;
														// transform v1 and v2 here
														return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
														}
												});
											}
										});
									}
									else 
									{
											mainColumnArray.push({
												header : this.wrapText(mcol),
												align: 'left',
												dataIndex : mcol,
												renderer : function(value, metaData, record, row, col, store, gridView) 
												{
													var href = value['href'];
													if (href != undefined) 
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value['value']+'"';
														return '<a class="anchorLinkDefault" href=' + href + '>' + value['value'] + '</a>';
													}
													else
													{
														metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
														return value;
													}
												},
												doSort: function(state) {
													var ds = this.up('grid').store;
													var field = this.getSortParam();
													ds.sort({
														property: field,
														direction: state,
														sorterFn: function(v1, v2){
															if (v1.index==0)
																return;
															v1 = v1.get(field);
															v2 = v2.get(field);
															v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
															v1= isNaN(v1) ? 0 : v1;
															v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
															v2= isNaN(v2) ? 0 : v2;
															// transform v1 and v2 here
															return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
															}
													});
												}
											});
										}
									}
									else 
									{
										if (mcol.indexOf('$$$') > -1)
										{
											mcol = mcol.substring(0,mcol.indexOf("$$$"));
										}if(needGridLock)
										{
										mainColumnArray.push({
													header : this.wrapText(mcol),
													columns :subColumnArray,
													locked:false
												});
										}
										else
										{
											mainColumnArray.push({
												header : this.wrapText(mcol),
												columns :subColumnArray,
											});
										}
									}
									k++;
								}
								var storeObj = Ext.create(
										'Ext.data.ArrayStore', {
											fields : fieldstoStore,
											data : data,
											remoteSort : true,
											autoLoad : true,
											sorters: { property: fieldstoStore[0], direction : 'ASC' }// vengat
										});

								itemsArray.push({
									xtype:'panel',
									ui:'newGraphPanel',
									title:gridDataObj['title'],
									margin:'10 10 10 10',
									items:[{
										xtype:'customgrid',
										store : storeObj,
										columns : mainColumnArray,
										frame:false,
										border:true,
										needtoFixColumn:true,
										ui:'newGridPanel',
										margin:'0 10 10 10',
										forceFitColsCount:9,
										popUpData:'noToolTip',
										viewConfig: {
											emptyText: 'No records',
											getRowClass: function(record, rowIndex, rowParams, store){
											if (rowIndex==0)
													return 'firstRowClass'; //configured in ext-custom-com.css
											}
										},
										listeners:{
											render:function(obj){
												Ext.defer(function() {
													//obj.columns[0].setSortState("ASC",true,true);
												},100);
											}
										}
									}]
								});
							}
							resultObj.add(itemsArray);
							resultObj.doLayout();
							Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);

						} else {
							var nomeas = jsonObject['emptyArray'];
							if (!Ext.isEmpty(nomeas) && nomeas.length > 0)
							{
								Ext.getCmp("bookletTool").setDisabled(true);
								Ext.getCmp("saveTool").setDisabled(true);
								Ext.getCmp("printTool").setDisabled(true);
								Ext.getCmp("mailTool").setDisabled(true);
								Ext.getCmp("csvTool").setDisabled(true);
								this.getNomeasurepanel().show();
							} 
							else 
							{
								this.generateBackgroundData(jsonObject,
										resultObj);
							}
						}
					} catch (e) {
						alert(e);
					}
				}
			}
		});
	},
	ShowSlowTransactionData : function(param, url) {
	param+= '&er_RmDispName='+appConstants.er_RmDispName;
		var loadMask = new Ext.LoadMask(Ext.getBody(), {
					msg : "Loading ..."
				});
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		loadMask.show();
		var resultObj = Ext.getCmp('result');
		resultObj.removeAll();

		Ext.Ajax.request({
			url : url,
			params : param,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonObject = Ext.decode(jsonText);
				loadMask.hide();
				try {
					var gridObj = jsonObject['gridObj'];

					if (!Ext.isEmpty(gridObj) && gridObj.length > 0) {
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp("csvTool").setDisabled(false);
						var itemsArray = new Array();
						var userDtIndex = "";
						var ipdtindex = "";

						for (var i in gridObj) {
							var gridDataObj = gridObj[i];
							var columns = gridDataObj.mainColumns;
							var data = gridDataObj.data;
							var units = gridDataObj.unit;
							var fieldstoStore = new Array();
							var colObject = new Array();

							var mainColumnArray = new Array();
							var gridWidth = resultObj.getWidth();
							var collen = 0;
							for (var mm in columns) {
								var subarray = new Array();
								subarray = columns[mm];

								if (subarray != undefined && !Ext.isEmpty(subarray))
								{
									for (var j = 0; j < subarray.length; j++) {
										collen++;
									}
								} else {
									collen++;
								}
							}
							var colWidth = (gridWidth / collen)+15;
							var k = 0;
							for (var mcol in columns) {
								var subarray = new Array();
								subarray = columns[mcol];
								var subColumnArray = new Array();

								if (k == 4)
									userDtIndex = mcol;
								if (k == 5)
									ipdtindex = mcol;
								if (k == 6 || k == 7) {
									subColumnArray.push({
												header : units[k],
												dataIndex : mcol,
												align:'center',
												sortable : true,
												renderer : function(value,
														metaData, record, row,
														col, store, gridView) {
													return value;
												}
											});
								}
								if (k == 6 || k == 7) {
									mainColumnArray.push({
												header : mcol,
												columns : subColumnArray
											});
									fieldstoStore.push(mcol);
								} else {
									mainColumnArray.push({
												header : mcol,
												//flex : 0.5,
												dataIndex : mcol,
												align:'left',
												renderer : function(value,
														metaData, record, row,
														col, store, gridView) {
													return value;
												}
											});
									fieldstoStore.push(mcol);
								}
								k++;
							}
							var storeObj = Ext.create('Ext.data.ArrayStore', {
										fields : fieldstoStore,
										data : data
									});
							if (i == 0 && gridDataObj['details'] == 'no') {
								var gridpanel = Ext.widget('customgrid', {
												store : storeObj,
												columns : mainColumnArray,
												bodyPadding : '0 0 0 0',
												margin:'5 10 10 10',
												//cls:'gridSkin horizontal-scroll',
												ui:'newGridPanel widthHeader',
												frame:false,
												forceFitColsCount:7,
												title : gridDataObj['title'],
												viewConfig: {
												emptyText: 'No records',
												getRowClass: function(record, rowIndex, rowParams, store){
														}
											},
											listeners:{
												render:function(obj){
													Ext.defer(function() {
														obj.columns[0].setSortState("ASC",true,true);
															},100);
												}
											}

										});
							} else {

								var gridpanel = Ext.widget('customgrid', {
									store : storeObj,
									id : 'iistransgrid',
									columns : mainColumnArray,
									//cls:'gridSkin horizontal-scroll',
									ui:'newGridPanel withHeader withShade',
									needtoFixColumn:true,
									margin:'5 10 10 10',
									forceFitColsCount:7,
									bodyPadding : '0 0 0 0',
									frame:false,
									title : gridDataObj['title'],
									scroll : true,
									autoScroll : true,
									listeners:{
										render:function(obj){
											Ext.defer(function() {
												obj.columns[0].setSortState("ASC",true,true);
												},100);
											}
									},
									dockedItems : [{
										xtype : 'toolbar',
										cls : 'toolbar',
										layout : 'column',
										items : [{
													xtype : 'textfield',
													fieldLabel : 'Filter by User Name',
													name : 'livesearch',
													labelWidth : 150,
													padding : '5',
													dock : 'top',
													enableKeyEvents : true
												}, {
													xtype : 'textfield',
													fieldLabel : 'Filter by User IP',
													name : 'livesearch1',
													labelWidth : 150,
													padding : '5',
													dock : 'top',
													enableKeyEvents : true
												}]
									}]
								});
								var filters = {
									ftype : 'filters',
									// encode and local configuration options defined previously for easier reuse
									encode : false, // json encode the filter query
									local : true, // defaults to false (remote filtering)
									filters : [ // Filters are most naturally placed in the column definition, but can also be // added here.
									{
												dataIndex : userDtIndex,
												type : 'string'

											}, {
												dataIndex : ipdtindex,
												type : 'string'
											}]
								};
								gridpanel.features = [filters];
							}
							itemsArray.push(gridpanel);
						}
						resultObj.add(itemsArray);
						resultObj.doLayout();
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonObject.selectionDetails);

					} else {
						var nomeas = jsonObject['emptyArray'];
						if (!Ext.isEmpty(nomeas) && nomeas.length > 0) {
								Ext.getCmp("bookletTool").setDisabled(true);
								Ext.getCmp("saveTool").setDisabled(true);
								Ext.getCmp("printTool").setDisabled(true);
								Ext.getCmp("mailTool").setDisabled(true);
								Ext.getCmp("csvTool").setDisabled(true);
								this.getNomeasurepanel().show();
						} else {
							this.generateBackgroundData(jsonObject, resultObj);
						}
					}

				} catch (e) {
					alert(e);
				}
			}
		});
	},
	updateNoMeasuresPanel : function(resultObj) {
		var itemsArray = new Array();
		var cheight=Ext.getBody().getViewSize().height-180;
		var htm = '<table width="100%" height="190px"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><span style="font-size: 13px;">'+ appConstants.nomeasures +'</span></td></tr></table>';
		Ext.getCmp('panelinsidetoggle').setDisabled(true);
		
		var additems = {
			xtype: 'panel',
			layout: 'auto',
			cls:'panelWithoutHeader',
			margin:0,
			height:cheight,
			items: [{
			xtype: 'container',
			padding: 100,
			id : 'nomeasures',
			style: {
			'text-align': 'center'
			},
			html:htm
			}]
			}
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
		Ext.select('#result').setStyle('box-shadow', '2px 2px 3px #666666');
		Ext.select('#result').setStyle('-webkit-box-shadow',' 2px 2px 3px #666666');
		
		itemsArray.push(additems);
		resultObj.removeAll();
		resultObj.add(itemsArray);
		resultObj.setHeight(cheight);
		resultObj.doLayout();
	},
	changeval : function(field, event) {

		if (Ext.String.trim(field.value).length > 0
				&& (Ext.String.trim(field.value) != '' || Ext.String
						.trim(field.value) != null)) {
			var regex = RegExp(field.value, 'i');
			Ext.getCmp('iistransgrid').getStore().filter(new Ext.util.Filter({
						caseSensitive : true,
						filterFn : function(object) {
							var match = false;
							Ext.Object.each(object.data, function(property,
											value) {
										match = match
												|| regex.test(String(value));

									});

							return match;
						}
					}));
		} else {
			Ext.getCmp('iistransgrid').getStore().clearFilter();
		}
		field.focus();
	},
	add : function(button) {
// by karthikeyan
			/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
			{
				Ext.MessageBox.show({
				title : 'Consolidated Reports',
				msg : 'Chosen timeline not allowed',
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
				});
			return;
			} */
//
		var form = Ext.getCmp('serviceform').getForm();
		var param = "";
		param += "select_report=" + appConstants.select_report +"&isFromClient=yes&isFilter=yes&isSubmit=no";
		var er_service = '';
		var comptype = '';
		if (appConstants.select_report == 'WebTransactions') {
			er_service = form.findField('er_service').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null && er_service==null)
					er_service=appConstants.er_service1;
				param += "&er_repType=webTransaction";
			}
			param += "&er_service=" + er_service + "&controller=webtransaction&pageWidthProces="+appConstants.pageWidth;

		} else if (appConstants.select_report == 'ServicesHealth') {
			er_service = form.findField('er_hservice').getValue();
			comptype = form.findField('er_comptype').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if (comptype == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.ctypealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null && er_service==null)
					er_service=appConstants.er_service1;
				if(appConstants.er_comptype!=null &&comptype ==null)
					comptype=appConstants.er_comptype;
				param += "&er_subrtype=servicesHealth";
			}
			var er_showTransaction = form.findField('er_showTransaction').getValue();
			param += "&er_service=" + er_service + "&er_comptype=" + comptype;
			if(er_showTransaction!=null)
				param += "&er_showTransaction=" + er_showTransaction ;
			param += "&controller=servicehealth&pageWidthProces="+appConstants.pageWidth;

		} else {

			er_service = form.findField('er_iisservice').getValue();
			var er_component = form.findField('multiselect').getValue();
			var er_transaction = form.findField('multiselect1').getValue();
			var er_category = form.findField('er_category').getValue();

			var transParam = "";

			for (var tr in er_transaction) {
				transParam += "&er_transaction=" + er_transaction[tr];
			}

			var compparms = "";
			for (var cr in er_component) {
				compparms += "&er_component=" + er_component[cr];
			}
			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null&& er_service==null)
					er_service=appConstants.er_service1;
			}
			param += "&er_service=" + er_service + compparms + transParam + "&controller=iistransaction";
		}

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = form.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration').getValue();

		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
				if(appConstants.fromSchModify=='Yes' && hiddenField=='schedule_id' && val == "NONE"){
					continue;
				}
			if (val == "NONE")
				val = "";
			param += "&" + hiddenField + "=" + val;
			param += "&";
		}
		param += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="+ minfrom + "&minto=" + minto;

		param += "&er_timeline=" + er_timeline;

		param += "&er_reportgenration=" + er_reportgenration;

		param += "&startdate=" + startdate + "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		var target = "";
		if (button.getId() == "scheduleImg" || appConstants.fromSchModify=='Yes')
		{
			target = "/final/reporter/ErSaveSchedule.jsp?"+ param+"&com.eg.CSRF_NONCE="+csrfToken;
			if (button.getId() == "save")
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			} else 
					 parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

		}else if (button.getId() == "favImg" || appConstants.fromFavoriteModify == "Yes")
		{
			target = "../servlet/com.eg.ErFavoriteC?cmd=client&" + param+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+appConstants.favorite_id;
			if (button.getId() == "save")
			{
				//document.location=url+'&showWindow=no'+'&FavoriteId='+appConstants.favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+appConstants.favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});

			} else 
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		}
		else {
			return;
		}
	},
	saveFileTool : function(tool) {

		var form = Ext.getCmp('serviceform').getForm();
		var er_service = '';
		var comptype = '';

		var param = "";
		param += "select_report=" + appConstants.select_report;
		if (appConstants.select_report == 'WebTransactions') {
			er_service = form.findField('er_service').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			param += "&er_service=" + er_service + "&subrtype=webtransaction"+ "&ercontype=consolidated";

		} else if (appConstants.select_report == 'ServicesHealth') {
			er_service = form.findField('er_hservice').getValue();
			comptype = form.findField('er_comptype').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if (comptype == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.ctypealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			var er_showTransaction = form.findField('er_showTransaction').getValue();
			param += "&er_service=" + er_service + "&er_comptype=" + comptype
					+ "&ercontype=consolidated" + "&show=yes"
					+ "&erservice=Service Health"
					+ "&select_farm=Consolidated Report&er_showTransaction="
					+ er_showTransaction;

		} else {

			er_service = form.findField('er_iisservice').getValue();
			var er_component = form.findField('multiselect').getValue();
			var er_transaction = form.findField('multiselect1').getValue();
			var er_category = form.findField('er_category').getValue();

			var transParam = "";

			for (var tr in er_transaction) {
				transParam += "&er_transaction=" + er_transaction[tr];
			}

			var compparms = "";
			for (var cr in er_component) {
				compparms += "&er_component=" + er_component[cr];
			}

			param += "&er_service=" + er_service + compparms + transParam
					+ "&er_category=" + er_category;
		}

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = form.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration').getValue();

		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += "&" + hiddenField + "=" + val;
			param += "&";
		}
		param += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="+ minfrom + "&minto=" + minto;

		param += "&er_timeline=" + er_timeline;

		param += "&er_reportgenration=" + er_reportgenration;

		param += "&startdate=" + startdate + "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + param+ "&er_view=PRINT&pageWidthProces="+appConstants.pageWidth+"&erservice=Service Health&pdfPrint=no";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var form = Ext.getCmp('serviceform').getForm();
		var er_service = '';
		var comptype = '';
		var param = "";
		param += "select_report=" + appConstants.select_report;
		if (appConstants.select_report == 'WebTransactions') {
			er_service = form.findField('er_service').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			param += "&er_service=" + er_service + "&subrtype=webtransaction"+ "&ercontype=consolidated";
		} else if (appConstants.select_report == 'ServicesHealth') {
			er_service = form.findField('er_hservice').getValue();
			comptype = form.findField('er_comptype').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if (comptype == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.ctypealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			var er_showTransaction = form.findField('er_showTransaction').getValue();
			param += "&er_service=" + er_service + "&er_comptype=" + comptype
					+ "&ercontype=consolidated" + "&show=yes"
					+ "&erservice=Service Health"
					+ "&select_farm=Consolidated Report&er_showTransaction="
					+ er_showTransaction;
		} else {
			er_service = form.findField('er_iisservice').getValue();
			var er_component = form.findField('multiselect').getValue();
			var er_transaction = form.findField('multiselect1').getValue();
			var er_category = form.findField('er_category').getValue();
			var transParam = "";
			for (var tr in er_transaction) {
				transParam += "&er_transaction=" + er_transaction[tr];
			}
			var compparms = "";
			for (var cr in er_component) {
				compparms += "&er_component=" + er_component[cr];
			}
			param += "&er_service=" + er_service + compparms + transParam
					+ "&er_category=" + er_category;
		}
		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = form.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration').getValue();
		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();
		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;
		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;
		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += "&" + hiddenField + "=" + val;
			param += "&";
		}
		param += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="+ minfrom + "&minto=" + minto;
		param += "&er_timeline=" + er_timeline;
		param += "&er_reportgenration=" + er_reportgenration;
		param += "&startdate=" + startdate + "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var s_qryString = param+ "&er_view=PRINT&pageWidthProces="+appConstants.pageWidth+"&erservice=Service Health&pdfPrint=no";
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var form = Ext.getCmp('serviceform').getForm();
		bookletquery += "select_report=" + appConstants.select_report +"&isFromClient=yes&isFilter=yes&isSubmit=no";
		var er_service = '';
		var comptype = '';
		if (appConstants.select_report == 'WebTransactions') {
			er_service = form.findField('er_service').getValue();

			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null && er_service==null)
					er_service=appConstants.er_service1;
				bookletquery += "&er_repType=webTransaction";
			}
			bookletquery += "&er_service=" + er_service + "&controller=webtransaction&pageWidthProces="+appConstants.pageWidth;

		} else if (appConstants.select_report == 'ServicesHealth') {
			er_service = form.findField('er_hservice').getValue();
			comptype = form.findField('er_comptype').getValue();
			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null && er_service==null)
					er_service=appConstants.er_service1;
				if(appConstants.er_comptype!=null &&comptype ==null)
					comptype=appConstants.er_comptype;
				bookletquery += "&er_subrtype=servicesHealth";
			}
			var er_showTransaction = form.findField('er_showTransaction').getValue();
			bookletquery += "&er_service=" + er_service + "&er_comptype=" + comptype;
			if(er_showTransaction!=null)
				bookletquery += "&er_showTransaction=" + er_showTransaction ;
			bookletquery += "&controller=servicehealth&pageWidthProces="+appConstants.pageWidth;

		} else {

			er_service = form.findField('er_iisservice').getValue();
			var er_component = form.findField('multiselect').getValue();
			var er_transaction = form.findField('multiselect1').getValue();
			var er_category = form.findField('er_category').getValue();

			var transParam = "";

			for (var tr in er_transaction) {
				transParam += "&er_transaction=" + er_transaction[tr];
			}

			var compparms = "";
			for (var cr in er_component) {
				compparms += "&er_component=" + er_component[cr];
			}
			if(appConstants.fromSchModify=='Yes'){
				if(appConstants.er_service1!=null&& er_service==null)
					er_service=appConstants.er_service1;
			}
			bookletquery += "&er_service=" + er_service + compparms + transParam + "&controller=iistransaction";
		}

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = form.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration').getValue();

		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
				if(appConstants.fromSchModify=='Yes' && hiddenField=='schedule_id' && val == "NONE"){
					continue;
				}
			if (val == "NONE")
				val = "";
			bookletquery += "&" + hiddenField + "=" + val;
			bookletquery += "&";
		}
		bookletquery += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="+ minfrom + "&minto=" + minto;

		bookletquery += "&er_timeline=" + er_timeline;

		bookletquery += "&er_reportgenration=" + er_reportgenration;

		bookletquery += "&startdate=" + startdate + "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile : function(){
		var form = Ext.getCmp('serviceform').getForm();
		 var er_service = '';
		var comptype = '';

		var param = "";
		param += "select_report=" + appConstants.select_report;
		var s_qryString="";
		if (appConstants.select_report == 'WebTransactions') {
			er_service = form.findField('er_service').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			param += "&er_service=" + er_service + "&subrtype=webtransaction"
					+ "&ercontype=consolidated";
		   s_qryString ="../servlet/com.eg.ErServiceReportServlet?";

		} else if (appConstants.select_report == 'ServicesHealth') {
			er_service = form.findField('er_hservice').getValue();
			comptype = form.findField('er_comptype').getValue();
			if (er_service == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.sitealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			if (comptype == '-1') {
				Ext.Msg.show({
							title : 'Alert',
							msg : appConstants.ctypealert,
							buttons : Ext.Msg.OK,
							icon : Ext.Msg.WARNING
						});
				return;
			}
			var er_showTransaction = form.findField('er_showTransaction').getValue();
			param += "&er_service=" + er_service + "&er_comptype=" + comptype
					+ "&ercontype=consolidated" + "&show=yes"
					+ "&er_sortby=-1"
					+ "&orderBy=-1"
					+ "&select_farm=Consolidated Report&er_showTransaction="
					+ er_showTransaction;
					
			 s_qryString ="../servlet/com.eg.ErServiceReportServlet?";
		} else {
			er_service = form.findField('er_iisservice').getValue();
			var er_component = form.findField('multiselect').getValue();
			var er_transaction = form.findField('multiselect1').getValue();
			var er_category = form.findField('er_category').getValue();

			var transParam = "";

			for (var tr in er_transaction) {
				transParam += "&er_transaction=" + er_transaction[tr];
			}

			var compparms = "";
			for (var cr in er_component) {
				compparms += "&er_component=" + er_component[cr];
			}
			param += "&er_service=" + er_service + compparms + transParam+ "&er_category=" + er_category;
			s_qryString = "/final/reporter/ErSlowTransPrint.jsp?";
		}

		var settingsForm = Ext.getCmp('settings').getForm();
		var er_timeline = form.findField('er_timeline').getValue();
		var er_reportgenration = settingsForm.findField('reportGeneration')
				.getValue();

		var timefrom = settingsForm.findField('timefrom').getValue();
		var timeto = settingsForm.findField('timeto').getValue();
		var minfrom = settingsForm.findField('minfrom').getValue();
		var minto = settingsForm.findField('minto').getValue();

		var startdate = form.findField('er_stdate').dataArray;
		var starthr = form.findField('er_sthr').dataArray;
		var enddate = form.findField('er_enddate').dataArray;
		var endhr = form.findField('er_endhr').dataArray;

		var hiddenFields = Ext.getCmp('serviceform').hiddenFields;

		for (var hiddenField in hiddenFields) {
			var val = hiddenFields[hiddenField];
			if (val == "NONE")
				val = "";
			param += "&" + hiddenField + "=" + val;
			param += "&";
		}
		param += "timefrom=" + timefrom + "&timeto=" + timeto + "&minfrom="+ minfrom + "&minto=" + minto;

		param += "&er_timeline=" + er_timeline;

		param += "&er_reportgenration=" + er_reportgenration;

		param += "&startdate=" + startdate + "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr+ "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

		s_qryString +=param+"&pdfPrint=yes"+"&er_view=PRINT&erservice=Service Health";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail : function() {
	   Ext.widget('sendmail').show();
	 },
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	wrapText : function(value){
		
		if(value.indexOf(" ")>-1)
		{
			var tmp = value.split(" ");
			var append=' ';
			for (var i in tmp)
			{
				append += tmp[i]+' ';
			}
			return append;
		}
		else
		{
			return (value);
		}
	}
});