Ext.define('ConsolidatedService.controller.MainNew', {
	extend : 'Ext.app.Controller',
	views : ['Main'],	
	refs : [
				{selector : 'main',ref : 'main'	},
				{selector : 'emptypanel',ref : 'emptypanel'	},
				{selector:'utilitiestool',ref:'utilitiestool'}
		],
	init : function() {
		this.control({
			'utilitiestool':{
				'afterrender':this.loadTools
			},
			'main':{
				'afterrender':this.showConfigDropDown,
				'boxready' : this.mainBoxReady
			},	
			'mainform':{
				afterrender:this.loadData
			},
			'configform':{
				afterrender:this.loadSettings
			},
			'mainform combo[id="er_hservice"]':{
				select:this.onChange
			},
			'mainform combo[id="er_iisservice"]':{
				select:this.onChange
			},
			'egcomponent multiselectfield[id=compmulti]':{
				select:this.componentOnChange
			},
			'mainform button[id="submit"]':{
				click:this.onSubmit
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},
			'configform combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'utilitiestool > #printTool > button':
			{
				'click':this.printFile
			},
			'utilitiestool > #saveTool > button':{
					'click': this.saveAsPDF
			},
			'utilitiestool > #mailTool > button':{
					'click':this.sendMail
			},
			'utilitiestool > #csvTool > button':{
					'click':this.saveASCsv
			},
			'utilitiestool > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'utilitiestool > #scheduleTool > button':{
					'click':this.saveSchedule
			},			
			'mainform button[name="save"]': {
				'click': this.goTo
			},
			'utilitiestool > #upbutton':{
				'click':this.toggleForm
			}
			
		});
	},
	saveASCsv:function(){
        window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
    },
	sendMail : function() {
       Ext.widget('sendmail').show();
     },
	saveAsPDF : function(){
		this.updateQueryString();
		var target = "../reporter/ErHtmlToSavePdf.jsp?" + queryString+ "&er_view=PRINT";
		Ext.widget('erutils').savePDF(target); 	 
 	},
	printReport : function(){
		this.updateQueryString();
		var target;
		if (select_report!='IIS_Transaction_Analysis')
		{
			target ="../servlet/com.eg.ErServiceReportServlet?";
		}
		else
			target = "/final/reporter/ErSlowTransPrint.jsp?";
		target+=queryString+"&pdfPrint=yes&er_view=PRINT";
		Ext.widget('erutils').savePDF(target); 	 
 	},
	saveFavorite : function(obj){
		var isValid = this.validateMainForm();
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Consolidated Service',
				msg: 'Choosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		} 		
		if(isValid){
		this.updateQueryString(); 	
		var target="../servlet/com.eg.ErFavoriteC?cmd=client&" + queryString;//+"&FavoriteId="+favorite_id;
		if (obj.getId()!='save')	  
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		else
			document.location=target+'&showWindow=no'
   		} 
 	},
	saveSchedule : function(obj){
		var isValid = this.validateMainForm();
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Consolidated Service',
				msg: 'Choosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		} 		
		if(isValid){
		this.updateQueryString(); 	
		var target="/final/reporter/ErSaveSchedule.jsp?"+queryString;
		if (obj.getId()!='save')	  
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
		else
			document.location=target+'&showSchWindow=no'
		} 
 	},
	goTo: function (obj) {
		var from_schedule = hiddens['fromScheduleModify'];
  		if (from_schedule == "Yes")  
			 this.saveSchedule(obj);
		 else 
 			this.saveFavorite(obj);
		 
    },
	loadTools : function(){
 		this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, true, false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
 	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	}, 
	hidePanels:function()
	{
		Ext.getCmp('resultpanel').hide();
		this.getEmptypanel().hide();
	},
	reportGenChange:function(){
		this.hidePanels();
		//this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},	
	showConfigDropDown:function()
	{	
		Ext.create('ConsolidatedService.view.ConfigForm');
	},
	componentOnChange: function(me, newValue, oldValue, eOpts) 
	{	
 		if (oldValue != '' || oldValue == '-1') {
			return;
		}
		queryString = 'isFromClient=yes&controller=iistransaction&isSubmit=no&isFilter=yes&comp=true&er_service='+ Ext.getCmp('er_iisservice').getValue() + '&comps=' + newValue;
		this.updateAjaxFormData(false,true);
	},
	onChange:function(object)
	{
		//alert('onChange---'+object.getValue());
 		if (select_report == 'ServicesHealth')
				queryString = 'isFromClient=yes&controller=servicehealth&isSubmit=no&isFilter=yes&select_report='+object.getValue();
		if (select_report == 'IIS_Transaction_Analysis')		
		 		queryString = 'isFromClient=yes&controller=iistransaction&isSubmit=no&isFilter=yes&comp=false&er_service='+object.getValue();
		this.updateAjaxFormData(false,false);
	},
	doUpdate:function(isCompChange)
	{
		if (select_report == 'ServicesHealth')
		{
 			this.loadComboField('er_comptype',defaultJSON.ComptypeCombo,null,null,false,null,null,false);
 		}
		if (select_report == 'IIS_Transaction_Analysis')	
		{			
			if (!isCompChange)
			{
				this.loadComboField('compmulti',defaultJSON.compMultiselect,null,defaultJSON.compMultiselectValue,true,'complbl','compfield',false);
			}
			this.loadComboField('transmulti',defaultJSON.transMultiSelect,null,defaultJSON.transMultiSelectValue,true,'translbl','transfield',false);
  		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
 		var MaxDaysInMonth = hiddens['getMaxDaysInMonth'];
		var er_usertimeline =hiddens['userTimeline'];
		var reportgen=Ext.getCmp('reportGeneration').getValue();

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Consolidated Service Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			var limitforbg = hiddens['limitforbg'];
			if(!Ext.isEmpty(limitforbg)){
				if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
					Ext.MessageBox.confirm('Confirm', forGrdReportConfirmMsg,this.showConfirmResult,this);
					isSettingsOk = false;
				}
			}
		}
		else{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	mainBoxReady:function()
	{
		var thisController = this;
		console.log(defaultJSON);
		if (er_RmDispName!= null && er_RmDispName!= 'null' && er_RmDispName!= 'undefined')
			this.getMain().setTitle(er_RmDispName);
		else
			this.getMain().setTitle(defaultJSON.screenLabelsDeafult['reporter.consolidated.CONSOLIDATED REPORTS']);

		Ext.get('closeSettings').on('click',function(){
			var isSettingsOk = thisController.validateSettings();			
			if(isSettingsOk)
			{				
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}			 
		});

		if((isSubmit!=null && isSubmit=='yes') || executeFavorite=="true")
		{
			this.onSubmit();
		}
	},
	loadSettings:function()
	{	
		
 		this.loadComboField('excludeWeekendsCombo',defaultJSON.excludeWeekendsCombo,defaultJSON.screenLabelsDeafult['reporter.common.Exclude weekends'],defaultJSON.excludeWeekendsCombo_value,false,null,null,true);
		this.loadComboField('reportGeneration',defaultJSON.reportgenComboArray,defaultJSON.screenLabelsDeafult['reporter.consolidated.Report Generation'],defaultJSON.reportgenCombo_value,false,null,null,true);
		this.setVal('timefrom',null,defaultJSON.timePeriod.Hourfrom,true);
		this.setVal('minfrom',null,defaultJSON.timePeriod.Minfrom,true);
		this.setVal('timeto',null,defaultJSON.timePeriod.Hourto,true);
		this.setVal('minto',null,defaultJSON.timePeriod.Minto,true);
 
  //  loadComboField(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)

 	},
	loadData:function()
	{		
 		if (defaultJSON["hiddenFields"]["fromScheduleModify"] == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		this.setVal('er_stdate',defaultJSON.timeline.startDateForDisplay,defaultJSON.timeline.startDateValue,false);
		this.setVal('er_enddate',defaultJSON.timeline.endDateForDisplay,defaultJSON.timeline.endDateValue,false);
		this.setVal('er_sthr',defaultJSON.timeline.startHourForDisplay,defaultJSON.timeline.starthour_value,false);
		this.setVal('er_endhr',defaultJSON.timeline.endHourForDisplay,defaultJSON.timeline.endhour_value,false);
 		this.loadComboField('er_timeline',defaultJSON.timeline.timelineCombo,defaultJSON.screenLabelsDeafult['reporter.common.Timeline'],defaultJSON.timeline.timeline_value,false,null,null,true);
		this.loadForm(); 		
 	},
	loadForm:function()
	{			
		if (select_report == 'WebTransactions') 
		{
			 this.loadComboField('er_service',defaultJSON.siteCombo,defaultJSON.screenLabel,null,false,null,null,true);
 		}
		else if (select_report == 'ServicesHealth')
		{
			this.loadComboField('er_hservice',defaultJSON.serviceCombo,defaultJSON.screenLabels['reporter.consolidated.Service'],null,false,null,null,true);
			this.loadComboField('er_comptype',defaultJSON.comptypeCombo,defaultJSON.screenLabels['reporter.common.Component Type'],null,false,null,null,true);
 		}
		else
		{
			this.loadComboField('er_iisservice',defaultJSON.serviceCombo,defaultJSON.screenLabels['reporter.consolidated.Service'],defaultJSON.serviceComboValue,false,null,null,true);
			this.loadComboField('compmulti',defaultJSON.compMultiselect,defaultJSON.screenLabels['reporter.common.Component'],null,true,'complbl','compfield',true);
			this.loadComboField('transmulti',defaultJSON.transMultiSelect,defaultJSON.screenLabels['reporter.consolidated.Transaction'],defaultJSON.transMultiSelectValue,true,'translbl','transfield',true);
			this.loadComboField('er_category',defaultJSON.catagoryComboArray,defaultJSON.screenLabels['reporter.common.Category'],null,false,null,null,true);
 		}	
 
 	},
	getMessageBox:function(title,msg)
	{
	   Ext.MessageBox.show({
				title: title,
				msg: msg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
		});
	},
	validateMainForm:function(){
		
		if (select_report == 'WebTransactions') 
		{
			var er_service = Ext.getCmp('er_service');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
   		}
		else if (select_report == 'ServicesHealth')
		{
			var er_service = Ext.getCmp('er_hservice');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
			er_service = Ext.getCmp('er_comptype');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
 		}
		else
		{
			var er_service = Ext.getCmp('er_iisservice');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
			er_service = Ext.getCmp('transmulti');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
			er_service = Ext.getCmp('er_category');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
			er_service = Ext.getCmp('compmulti');
			if(er_service.getValue() == '-1'){
				this.getMessageBox('Consolidated Service',er_service.getStore().getAt(0).get('displayField'));
				return false;		
			}
 		}		
		return true;
	},
	onSubmit:function()
	{
		var isSettingsOk = this.validateSettings();
        if (!isSettingsOk) {
            return;
        }
		var isValid = this.validateMainForm();
		if(isValid)
		{
			this.updateQueryString();
			this.updateAjaxFormData(true,false);
		}

	},
	loadReportData:function()
	{
		this.hidePanels();
		if (select_report == 'WebTransactions') 
		{
			this.ShowWebTransactionData(defaultJSON);
  		}
		else if (select_report == 'ServicesHealth')
		{
			this.ShowServiceHealthData(defaultJSON);
		}
		else
		{
			this.ShowSlowTransactionData(defaultJSON);
		}
	},
	getAjaxUrl:function()
	{
		var url;
 		if (Ext.getCmp('reportGeneration').getValue() == 'foreground') {
			 url='/final/servlet/com.eg.ErConsolidatedServiceDispatcher';
		} else{
			url='../servlet/com.eg.ErStartBackGroundReportC';
			queryString+='&bg_reportname='+Ext.getCmp('bgReportName').getValue();
		}
 		return url;
	},
	updateAjaxFormData:function(isFormSubmitted,isCompChange)
    {		
 		var url= this.getAjaxUrl();
 		console.log('queryString---'+queryString);
  		Ext.Ajax.request(
				{
					url : url,
					params:queryString,
   					scope:this,
					async: true,
					success: function(response, opts){ 						
 						defaultJSON=Ext.decode(response.responseText);
						if(defaultJSON.hasOwnProperty('hiddenFields'))
						hiddens=defaultJSON.hiddenFields;
						console.log(defaultJSON);
 						if(isFormSubmitted)							  
							this.loadReportData();						
						else 						
						{
							this.doUpdate(isCompChange);
						}						
					},
					failure: function(response, opts) {
						  console.log('server-side failure with status code ' + response.status);
					}
				});	
   },
    loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,isMultiSelect,multiSelectLabelId,multiSelectContainerId,isSetLabel)
	{ 		 
 		 var component = Ext.ComponentManager.get(comboId);  
 		 if(!Ext.isEmpty(comboProperty))
		 {		 
 			//	 var rawData = parentJsonProperty[comboProperty];
 				 component.getStore().loadRawData(comboProperty);
				 if(!Ext.isEmpty(comboSelectedProperty))
  					 component.setValue(comboSelectedProperty); 						
 				 else 				 
					component.setValue(comboProperty[0].valueField); 		

				 if (isSetLabel)
				 {
					 if(!Ext.isEmpty(comboLabelProperty))
					 {
						if(!isMultiSelect) 					
							component.setFieldLabel(comboLabelProperty);
 						else
							Ext.ComponentManager.get(multiSelectLabelId).setText(comboLabelProperty);
					 }
				 } 				 
				 if(component.isHidden())
				 component.show();
 		 }
		 else
		 {
		 		if(!isMultiSelect)
				{  
					if(!component.isHidden())
					component.hide();
				}
				else
			    {
					var m=Ext.ComponentManager.get(multiSelectContainerId);
					if(!m.isHidden())
					m.hide();
				}
		 }
 	},
	setVal:function(id,displayProperty,valueProperty,isCombo)
	{
		var component = Ext.ComponentManager.get(id); 
		if (!isCombo) //for datefield
		{
			component.setValue(displayProperty);
			component.dataArray =  valueProperty;
			//alert(component.dataArray);
		}
		else //for combofield
		  component.setValue(valueProperty);
	},
	updateQueryString:function()
	{
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray;// + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		
		var timperiodParams="&timefrom="+Ext.getCmp('timefrom').getValue()+"&minfrom="+Ext.getCmp('minfrom').getValue()+"&timeto="+Ext.getCmp('timeto').getValue()+"&minto="+Ext.getCmp('minto').getValue();

		queryString="select_report="+select_report;
		queryString+=timelineParams+timperiodParams;
		
		for (var hiddenField in hiddens){
			queryString+="&"+hiddenField+"="+hiddens[hiddenField];
		}
  
		if (select_report == 'WebTransactions') 
		{
			queryString+=Ext.getCmp('er_service').getValue()+"&isFromClient=yes&controller=webtransaction&isSubmit=yes";;
  		}
		else if (select_report == 'ServicesHealth')
		{
 			queryString += "er_service=" + Ext.getCmp('er_hservice').getValue() + "&er_comptype=" + Ext.getCmp('er_comptype').getValue()+"&er_showTransaction=" + Ext.getCmp('er_showTransaction').getValue()+'&select_farm=Consolidated Report&ercontype=consolidated&isFromClient=yes&controller=servicehealth&isSubmit=yes&erservice=Service Health';
		}
		else
		{
 			queryString += "er_service=" + Ext.getCmp('er_iisservice').getValue() + "&er_category=" + Ext.getCmp('er_category').getValue();
			
			var er_component=Ext.getCmp('compmulti').getValue();
			for (var cr in er_component) {
				queryString += "&er_component=" + er_component[cr];
			}
			var er_transaction=Ext.getCmp('transmulti').getValue();
			for (var tr in er_transaction) {
				queryString += "&er_transaction=" + er_transaction[tr];
			}
		
			queryString += "&isFromClient=yes&controller=iistransaction&isSubmit=yes";
		}

		queryString += "&er_reportgenration=" + Ext.getCmp('reportGeneration').getValue();
 	},
	ShowWebTransactionData : function(jsonObject) {
	
		var resultObj = Ext.getCmp('resultpanel');
		resultObj.removeAll();
		if (Ext.getCmp('reportGeneration').getValue()=='foreground')
		{		
			if (!Ext.isEmpty(jsonObject)) {
						try {

							var gridObj = jsonObject['gridObj'];
							if (!Ext.isEmpty(gridObj) && gridObj.length > 0) {
								var itemsArray = new Array();
								for (var i in gridObj) {
									var gridDataObj = gridObj[i];
									var columns = gridDataObj.mainColumns;
									var data = gridDataObj.data;
									var units = gridDataObj.unit;
									//var subs = gridDataObj.subcolumns;
									var fieldstoStore = new Array();
									var colObject = new Array();

									var mainColumnArray = new Array();

									if (i == 0) {
										var k = 0;
										var gridWidth = resultObj.getWidth();

										var collen = 0;
										for (var mm in columns) {
											var subarray = new Array();
											subarray = columns[mm];

											if (subarray != undefined
													&& !Ext.isEmpty(subarray)) {

												for (var j = 0; j < subarray.length; j++) {

													collen++;

												}
											} else {

												collen++;
											}
										}

										var colWidth = gridWidth / collen;
										for (var mcol in columns) {
											var subarray = new Array();
											subarray = columns[mcol];
											var subColumnArray = new Array();
											var measureColumnArray = new Array();
											if (k == 0) {

												fieldstoStore.push(mcol);
												subColumnArray.push({
															header : '&nbsp;',
															dataIndex : mcol

														});
											}

											if (k == 1) {

												for (var j = 0; j < units.length; j++) {
													fieldstoStore.push(subarray[j]
															+ mcol);
													measureColumnArray.push({
																header : units[j],
																columns : this
																		.getSubColumns(
																				subarray,
																				j,
																				mcol,
																				colWidth)
															});

												}
											} else if (k == 0) {
												measureColumnArray.push({
															header : '&nbsp;',
															columns : subColumnArray
														});
											}
											if (k == 0) {
												mainColumnArray.push({
															header : mcol,
															dataIndex : mcol,
															minWidth : 100,
															flex : 0.5
														});
											} else {
												mainColumnArray.push({
															header : mcol,
															columns : measureColumnArray
														});
											}

											k++;
										}
									} else {
										var k = 0;
										var val = "";
										var gridWidth = resultObj.getWidth();

										var collen = 0;
										for (var mm in columns) {
											var subarray = new Array();
											subarray = columns[mm];

											if (subarray != undefined
													&& !Ext.isEmpty(subarray)) {

												for (var j = 0; j < subarray.length; j++) {

													collen++;

												}
											} else {

												collen++;
											}
										}

										var colWidth = (gridWidth / collen)-10;

										for (var mcol in columns) {
											var subarray = new Array();
											subarray = columns[mcol];
											var subColumnArray = new Array();
											var measureColumnArray = new Array();
											if (subarray != undefined
													&& !Ext.isEmpty(subarray)) {
												for (var j = 0; j < subarray.length; j++) {

													subColumnArray.push({
																header : subarray[j],
																sortable : true,
																width : colWidth,
																dataIndex : mcol
																		+ subarray[j],
																renderer : function(
																		value,
																		metaData,
																		record,
																		row, col,
																		store,
																		gridView) {

																	return value;
																}
															});
													fieldstoStore.push(mcol
															+ subarray[j]);

												}
											} else {
												fieldstoStore.push(mcol);
												subColumnArray.push({
													header : '&nbsp;',
													sortable : true,
													dataIndex : mcol,
													renderer : function(value,
															metaData, record, row,
															col, store, gridView) {
														if (col == 0) {
															if (!Ext.isEmpty(val)
																	&& val != undefined) {
																if (value == val) {
																	metaData.style = "overflow:visible;padding-top:5px;";
																	return "";
																} else {
																	val = value;
																	return value;
																}
															} else {
																val = value;
																return value;
															}
														} else {
															return value;
														}

													}
												});
											}

											if (units[k] != undefined
													&& !Ext.isEmpty(units[k])) {
												measureColumnArray.push({
															header : '(' + units[k]
																	+ ')',
															columns : subColumnArray
														});
											} else {
												measureColumnArray.push({
															header : '&nbsp;',
															columns : subColumnArray
														});
											}

											if (k == 0 || k == 1) {
												mainColumnArray.push({
															header : mcol,
															dataIndex : mcol,
															flex : 0.5,
															minWidth : 100

														});
											} else {
												mainColumnArray.push({
															header : mcol,
															columns : measureColumnArray
														});
											}

											k++;
										}
									}

									var storeObj = Ext.create(
											'Ext.data.ArrayStore', {
												fields : fieldstoStore,
												data : data
											});

									var gridpanel = Ext.widget('customgrid', {
												store : storeObj,
												autoScroll : true,
												scroll : true,
												frame:false,
												columns : mainColumnArray,
												bodyPadding : '0 0 0 0',
												title : gridDataObj['title']
											});

									itemsArray.push(gridpanel);

								}

								resultObj.add(itemsArray);
								resultObj.show();

								//this.setSelectionDetails(jsonObject);
							} else {
								var nomeas = jsonObject['emptyArray'];
								if (!Ext.isEmpty(nomeas) && nomeas.length > 0) {
									this.getEmptypanel().show();
								}
							}

						} catch (e) {
							alert(e);
						}
					}
				}else
				{
					this.generateBackgroundData(jsonObject, resultObj);
				}
	},
	ShowServiceHealthData : function(jsonObject) {
	
		var resultObj = Ext.getCmp('resultpanel');
		resultObj.removeAll();
		if (Ext.getCmp('reportGeneration').getValue()=='foreground')
		{
				 if (!Ext.isEmpty(jsonObject)) {
					try {

						var gridObj = jsonObject['gridObj'];
						if (!Ext.isEmpty(gridObj) && gridObj.length > 0) {
							var itemsArray = new Array();
							for (var i in gridObj) {
								var gridDataObj = gridObj[i];
								var columns = gridDataObj.mainColumns;
								var data = gridDataObj.data;
								var units = gridDataObj.unit;
								//var subs = gridDataObj.subcolumns;
								var fieldstoStore = new Array();
								var colObject = new Array();

								var mainColumnArray = new Array();

								var gridWidth = resultObj.getWidth();

								var collen = 0;
								for (var mm in columns) {
									var subarray = new Array();
									subarray = columns[mm];

									if (subarray != undefined
											&& !Ext.isEmpty(subarray)) {

										for (var j = 0; j < subarray.length; j++) {

											collen++;

										}
									} else {

										collen++;
									}
								}

								var colWidth = (gridWidth / collen)+18;

								var k = 0;
								for (var mcol in columns) {
									var subarray = new Array();
									subarray = columns[mcol];
									var subColumnArray = new Array();
									var measureColumnArray = new Array();
									if (subarray != undefined
											&& !Ext.isEmpty(subarray)) {
										for (var j = 0; j < subarray.length; j++) {

											subColumnArray.push({
														header : subarray[j],
														sortable : true,
														width : colWidth,
														minWidth:35,
														dataIndex : mcol
																+ subarray[j],
														renderer : function(
																value,
																metaData,
																record, row,
																col, store,
																gridView) {

															return value;
														}
													});
											fieldstoStore.push(mcol
													+ subarray[j]);

										}
									} else {
										fieldstoStore.push(mcol);
										subColumnArray.push({
											header : '&nbsp;',
											minWidth:35,
											sortable : true,
											dataIndex : mcol,
											renderer : function(value,
													metaData, record, row, col,
													store, gridView) {
												if (col == 0) {

													var href = value['href'];

													if (href != undefined) {
														return '<a href='
																+ href
																+ '>'
																+ value['value']
																+ '</a>'
													} else {
														return value;
													}
												} else {
													var href = value['href'];
													if (href != undefined) {
														return '<a href='
																+ href
																+ '>'
																+ value['value']
																+ '</a>'
													} else {

														return value;
													}
												}

											}
										});
									}

									if (units[k] != undefined
											&& !Ext.isEmpty(units[k])) {
										measureColumnArray.push({
													header : '(' + units[k]
															+ ')',
													minWidth:35,
													columns : subColumnArray
												});
									} else {
										measureColumnArray.push({
													header : '&nbsp;',
													minWidth:35,
													columns : subColumnArray
												});
									}
									if (k == 0) {
										mainColumnArray.push({
													header : this.wrapText(mcol),
													flex : 0.5,
													minWidth:120,
													dataIndex : mcol,
													renderer : function(value,
															metaData, record,
															row, col, store,
															gridView) {

														var href = value['href'];
														if (href != undefined) {
															return '<a href='
																	+ href
																	+ '>'
																	+ value['value']
																	+ '</a>'
														} else {

															return value;
														}
													}

												});
									} else {
										mainColumnArray.push({
													header : this.wrapText(mcol),
													minwidth:80,
													columns : measureColumnArray
												});
									}

									k++;
								}

								var storeObj = Ext.create(
										'Ext.data.ArrayStore', {
											fields : fieldstoStore,
											data : data
										});

								var gridpanel = Ext.widget('customgrid', {
											store : storeObj,
											columns : mainColumnArray,
											frame:false,
											bodyPadding : '0 0 0 0',
											title : gridDataObj['title']

										});

								itemsArray.push(gridpanel);

							}
							resultObj.add(itemsArray);
							resultObj.show();
							//this.setSelectionDetails(jsonObject);
						} else {
							var nomeas = jsonObject['emptyArray'];
							if (!Ext.isEmpty(nomeas) && nomeas.length > 0) {
								this.getEmptypanel().show();
							} 
						}
					} catch (e) {
						alert(e);
					}
				}
			}
			else
			{
				this.generateBackgroundData(jsonObject, resultObj);
			}

	},
	ShowSlowTransactionData : function(jsonObject) {
 
		var resultObj = Ext.getCmp('resultpanel');
		resultObj.removeAll();
 		var gridObj = jsonObject['gridObj'];
		if (Ext.getCmp('reportGeneration').getValue()=='foreground')
		{
				if (!Ext.isEmpty(gridObj) && gridObj.length > 0) {
					var itemsArray = new Array();
					var userDtIndex = "";
					var ipdtindex = "";

					for (var i in gridObj) {
						var gridDataObj = gridObj[i];
						var columns = gridDataObj.mainColumns;
						var data = gridDataObj.data;
						var units = gridDataObj.unit;
						//var subs = gridDataObj.subcolumns;
						var fieldstoStore = new Array();
						var colObject = new Array();

						var mainColumnArray = new Array();

						var gridWidth = resultObj.getWidth();

						var collen = 0;
						for (var mm in columns) {
							var subarray = new Array();
							subarray = columns[mm];

							if (subarray != undefined
									&& !Ext.isEmpty(subarray)) {

								for (var j = 0; j < subarray.length; j++) {

									collen++;

								}
							} else {

								collen++;
							}
						}

						var colWidth = (gridWidth / collen)+15;
						var k = 0;
						for (var mcol in columns) {
							var subarray = new Array();
							subarray = columns[mcol];
							var subColumnArray = new Array();

							if (k == 4)
								userDtIndex = mcol;
							if (k == 5)
								ipdtindex = mcol;
							if (k == 6 || k == 7) {
								subColumnArray.push({
											header : units[k],
											dataIndex : mcol,
											width : colWidth,
											sortable : true,
											renderer : function(value,
													metaData, record, row,
													col, store, gridView) {
												return value;
											}
										});

							}

							if (k == 6 || k == 7) {
								mainColumnArray.push({
											header : mcol,
											columns : subColumnArray
										});
								fieldstoStore.push(mcol);
							} else {
								mainColumnArray.push({
											header : mcol,
											flex : 0.5,
											dataIndex : mcol,
											renderer : function(value,
													metaData, record, row,
													col, store, gridView) {
												return value;
											}
										});
								fieldstoStore.push(mcol);
							}
							k++;
						}

						var storeObj = Ext.create('Ext.data.ArrayStore', {
									fields : fieldstoStore,
									data : data
								});

						if (i == 0 && gridDataObj['details'] == 'no') {
							var gridpanel = Ext.widget('datagrid', {
										store : storeObj,
										columns : mainColumnArray,
										bodyPadding : '0 0 0 0',
										frame:false,
										title : gridDataObj['title']

									});
						} else {

							var gridpanel = Ext.widget('datagrid', {
								store : storeObj,
								id : 'iistransgrid',
								columns : mainColumnArray,
								bodyPadding : '0 0 0 0',
								frame:false,
								title : gridDataObj['title'],
								scroll : true,
								autoScroll : true,
								dockedItems : [{
									xtype : 'toolbar',
									//width:900,
									cls : 'toolbar',
									layout : 'column',
									items : [{
												xtype : 'textfield',
												fieldLabel : 'Filter by User Name',
												//labelAlign:'left',
												name : 'livesearch',
												labelWidth : 150,
												padding : '5',
												width : 300,
												dock : 'top',
												enableKeyEvents : true
											}, {
												xtype : 'textfield',
												fieldLabel : 'Filter by User IP',
												//labelAlign:'left',
												name : 'livesearch1',
												labelWidth : 150,
												padding : '5',
												width : 300,
												dock : 'top',
												enableKeyEvents : true
											}]
								}]

							});

							var filters = {
								ftype : 'filters',
								// encode and local configuration options defined previously for easier reuse
								encode : false, // json encode the filter query
								local : true, // defaults to false (remote filtering)
								filters : [ // Filters are most naturally placed in the column definition, but can also be // added here.
								{
											dataIndex : userDtIndex,
											type : 'string'

										}, {
											dataIndex : ipdtindex,
											type : 'string'

										}]
							};

							gridpanel.features = [filters];
						}

						itemsArray.push(gridpanel);

					}

					resultObj.add(itemsArray);
					resultObj.show();

					this.setSelectionDetails(jsonObject);

				} else {
					var nomeas = jsonObject['emptyArray'];
					if (!Ext.isEmpty(nomeas) && nomeas.length > 0) {
						this.getEmptypanel().show();
					} 
				}
			}
			else
			{
				this.generateBackgroundData(jsonObject, resultObj);
			}

	},
	generateBackgroundData : function(jsonObject, resultObj) {

 		var grpahQueryString = jsonObject.grpahQueryString;
		var status = grpahQueryString.status;

		var htm='';
		if(status!=undefined && status =='success'){
		htm = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1
				+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
				+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2
				+ '</a> </div></div></center>';}
		else{
		htm = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + grpahQueryString.bgstr1
				+ '</b>.</br>' + '<a class="backgroundMsgLink" href='
				+ grpahQueryString.queryString + '>' + grpahQueryString.bgstr2
				+ '</a> </div></div></center>';
		}
		var additems = {
			xtype : 'panel',
			cls:'measuresErrorPanelBg',
			title : '',
			html : htm,
			columnWidth : '1',
			id : 'backgroundpanel'
		}

 		resultObj.add(additems); 
		resultObj.show();
	},
	setSelectionDetails : function(jsonObject) {
		var selectionDetailsObj = Ext.getCmp('selectionDetails');
		var selectionDetailsData = jsonObject['selectionDetails'];
		var selectionDetailsTitle = selectionDetailsData['heading'];
		selectionDetailsObj.setTitle(selectionDetailsTitle);
		var fieldContainerArray = new Array();
		for (var key in selectionDetailsData) {
			var htmlStr = selectionDetailsData[key];
			if (key != 'heading') {

				var fieldAdd = {
					xtype : 'fieldcontainer',
					fieldLabel : key,
					items : [{
								xtype : 'container',
								html : htmlStr
							}]
				};
				fieldContainerArray.push(fieldAdd);
			}
		}
		selectionDetailsObj.removeAll();
		selectionDetailsObj.add(fieldContainerArray);
	}	
});