Ext.define('ConsolidatedService.view.ConsolidatedServiceMainForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.consolidatedservicemainform',
	requires : ['Ext.ux.form.MultiSelect',
				  'utilities.ScrollCombo'
	],
	id : 'uptimereportform',
	collapseMode : 'mini',
	margin : '0 0 10 0',
	initComponent : function() {
		this.bodyPadding = '0 20 0 20';
		this.buttonAlign = 'center';
		this.callParent()
	},
	items : [{
		xtype : 'fieldcontainer',
		layout : 'column',
		defaults : {
			margin : '0 20 5 0',
			labelSeparator : ''
		},
		items : [{
					xtype : 'scrollcombo',
					cls : 'dropdown',
					width : 200,
					labelSeparator : '',
					editable : false,
					labelAlign : 'top',
					fieldLabel : 'Report',
					name : 'reportSelectBox',
					id : 'reportSelectBox',
					store : new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local'
				}, {
					xtype : 'fieldcontainer',
					id : 'serviceHealth',
					name : 'serviceHealth',
					hidden : true,
					//width:500,
					layout : 'column',
					defaults : {
						margin : '0 20 5 0',
						labelSeparator : '',
						labelAlign : 'top'
					},
					items : [{
								xtype : 'scrollcombo',
								editable : false,
								id : 'er_hservice',
								name : 'er_hservice',
								width : 180,
								fieldLabel : 'Service',
								cls : 'dropdown',
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								store : new Ext.data.Store({
											fields : ['displayField',
													'valueField'],
											data : []
										})
							}, {
								xtype : 'scrollcombo',
								editable : false,
								id : 'er_comptype',
								name : 'er_comptype',
								width : 180,
								fieldLabel : 'ComponentType',
								cls : 'dropdown',
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								store : new Ext.data.Store({
											fields : ['displayField',
													'valueField'],
											data : []
										})
							}, {
								xtype : 'scrollcombo',
								editable : false,
								id : 'er_showTransaction',
								name : 'er_showTransaction',
								width : 180,
								fieldLabel : 'show transactions',
								cls : 'dropdown',
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								store : new Ext.data.Store({
											fields : ['displayField',
													'valueField'],
											data : []
										})
							}]
				}, {
					xtype : 'fieldcontainer',
					id : 'iistransaction',
					name : 'iistransaction',
					hidden : true,
					width : 900,
					layout : 'hbox',
					defaults : {
						margin : '0 20 5 0',
						labelSeparator : ''
					},
					items : [{
								xtype : 'scrollcombo',
								editable : true,
								id : 'er_iisservice',
								name : 'er_iisservice',
								fieldLabel : 'Service',
								labelAlign : 'top',
								width : 200,
								cls : 'dropdown',
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								listConfig:{
												emptyText:noMatch
											},
								store : new Ext.data.Store({
											fields : ['displayField',
													'valueField'],
											data : []
										})
							}, {
								xtype : 'fieldcontainer',
								layout : 'vbox',
								items : [{
											xtype : 'label',
											text : 'Components0',
											margins : '0 0 5 0'
										}, {

											xtype : 'multiselectorpanel',
											cls : 'multiselect',
											height : 90,
											items : [{
												width : 200,
												xtype : 'multiselectfield',
												//msgTarget: 'side',
												autoScroll : false,
												scroll : false,
												labelAlign : 'left',
												//height:50,
												allowBlank : false,
												id : 'components',
												name : 'components',
												value : '',
												store : new Ext.data.Store({
															fields : [
																	'displayField',
																	'valueField'],
															data : []
														}),
												displayField : 'displayField',
												valueField : 'valueField',
												queryMode : 'local'
											}

											]
										},
                                        {
											xtype:'fieldcontainer',
											layout:'vbox',
											items:[
												{
													xtype:'label',
													text:'Components',
													margins: '0 0 5 0'
												},
												{
                    
                                            xtype:'multiselectorpanel',
                                            cls:'multiselect',
                                            height:90,
                                            items:[
												
                                                {
                                                width: 200,
                                                
                                                xtype: 'multiselectfield',
                                                //msgTarget: 'side',
                                                autoScroll:false,
                                                scroll:false,
                                                name: 'multiselect1',
                                                labelAlign:'left',
                                                //height:50,
                                                allowBlank: false,
                                                //id: 'components',
                                                name: 'components',
                                    
                                                value: '',
                                                store: new Ext.data.Store({
                                                    fields : ['displayField', 'valueField'],
                                                    data : [],
                                                    listeners:{
                                                            'load': function(store, records)
                                                            {
                                                                var compsObj = Ext.getCmp('components');
                                                                if ( !Ext.isEmpty( store ) && !Ext.isEmpty( compsObj ) )
                                                                {
                                                                    var getNAIndex = store.findExact('valueField', 'Not Applicable', 0);
                                                                    if ( getNAIndex == -1 )
                                                                    {
                                                                        var getModel = store.getAt(0);
                                                                        var getFirstValueField = getModel.get('valueField');
                                                                        compsObj.setValue(getFirstValueField);
                                                                    }
                                                                }
                                                            }
                                                    }                               
                                                }),
                                                displayField: 'displayField',
                                                valueField: 'valueField',
                                                queryMode: 'local'
                                                }
                                                
                                            ]
                                        }
											]
										},
                                        {
                                            xtype : 'scrollcombo',
                                            editable : false,
                                            id : 'er_category',
                                            name : 'er_category',
                                            fieldLabel:'Category',
                                            labelAlign:'top',
                                            width : 150,
                                            cls : 'dropdown',
                                            displayField : 'displayField',
                                            valueField : 'valueField',
                                            queryMode : 'local',
                                            store : new Ext.data.Store({
                                                        fields : ['displayField',
                                                                'valueField'],
                                                        data : []
                                                    })
                                        }
                                    ]
                        }, 
                        {
							xtype : 'scrollcombo',
							cls : 'dropdown',
							width : 200,
							labelSeparator : '',
							editable : false,
							labelAlign : 'top',
							fieldLabel : 'Site',
							name : 'er_service',
							id : 'er_service',
							store : new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						}]
			}]
		}],
			buttons : [{
						text : 'Submit',
						formBind : true,
						disabled : true,
						ui:'newButtonSmall',
						id : 'submit',
						name : 'submit'
					}],
			loadDefaultScreenLabels : function(screenLabels) {
				this.getForm().findField('reportSelectBox').labelEl.dom.innerHTML = screenLabels['reporter.consolidated.Report'];
			},
			loadDefaultComboValues : function(reportCombo) {
                
				var report = this.getForm().findField('reportSelectBox');
				report.getStore().loadRawData(reportCombo);
				this.getForm().findField('reportSelectBox').setValue(report.getStore().getAt(0));
				
			},
	enableReportContainers : function(scrollcombo) {
		var val = scrollcombo.getValue();
		var thisForm = this.getForm();
		if (val == 'WebTransactions') {
			thisForm.findField('er_service').show();
			Ext.getCmp('serviceHealth').hide();
			Ext.getCmp('iistransaction').hide();
			var param = 'isFromClient=yes&controller=webtransaction&isSubmit=no';
			this.clearStoreValue('er_service', thisForm);
			this.loadDefaultCombosOnReportSelect(param,
					'/final/servlet/com.eg.ErConsolidatedServiceDispatcher',
					'er_service', thisForm);
		} else if (val == 'ServicesHealth') {
			Ext.getCmp('serviceHealth').show();
			thisForm.findField('er_service').hide();
			Ext.getCmp('iistransaction').hide();
			this.clearStoreValue('er_hservice', thisForm);
			this.clearStoreValue('er_comptype', thisForm);
			this.clearStoreValue('er_showTransaction', thisForm);
			var param = 'isFromClient=yes&controller=servicehealth&isSubmit=no&select_report=ServicesHealth';
			this.loadDefaultCombosOnReportSelect(param,
					'/final/servlet/com.eg.ErConsolidatedServiceDispatcher',
					'er_hservice', thisForm);
		} else {
			Ext.getCmp('iistransaction').show();
			thisForm.findField('er_service').hide();
			Ext.getCmp('serviceHealth').hide();
			this.clearStoreValue('er_iisservice', thisForm);
			this.clearStoreValue('components', thisForm);
			this.clearStoreValue('components1', thisForm);
			var param = 'isFromClient=yes&controller=iistransaction&isSubmit=no&select_report=iistransaction';
			this.loadDefaultCombosOnReportSelect(param,
					'/final/servlet/com.eg.ErConsolidatedServiceDispatcher',
					'er_iisservice', thisForm);
		}

	},
	loadDefaultCombosOnReportSelect : function(param, url, field, form) {

		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;

						var jsonObject = Ext.decode(jsonText);
						if (field == 'er_hservice') {
							if (jsonObject['serviceCombo'] != null
									&& jsonObject['serviceCombo'] != undefined) {
								form
										.findField('er_hservice')
										.getStore()
										.loadRawData(jsonObject['serviceCombo']);
								if (jsonObject['serviceCombo'].length > 1)
									form.findField('er_hservice').setValue(form
											.findField('er_hservice')
											.getStore().getAt(1));
								else if (jsonObject['serviceCombo'].length == 1)
									form.findField('er_hservice').setValue(form
											.findField('er_hservice')
											.getStore().getAt(0));
							}
							if (jsonObject['comptypeCombo'] != null
									&& jsonObject['comptypeCombo'] != undefined) {
								form
										.findField('er_comptype')
										.getStore()
										.loadRawData(jsonObject['comptypeCombo']);
								if (jsonObject['comptypeCombo'].length > 1)
									form.findField('er_comptype').setValue(form
											.findField('er_comptype')
											.getStore().getAt(1));
								else if (jsonObject['comptypeCombo'].length == 1)
									form.findField('er_comptype').setValue(form
											.findField('er_comptype')
											.getStore().getAt(0));
							}
							if (jsonObject['showTransCombo'] != null
									&& jsonObject['showTransCombo'] != undefined) {
								form
										.findField('er_showTransaction')
										.getStore()
										.loadRawData(jsonObject['showTransCombo']);
								form.findField('er_showTransaction')
										.setValue(jsonObject['showtransValue']);
							}
						} else if (field == 'er_service') {
							form.findField(field).getStore()
									.loadRawData(jsonObject['siteCombo']);
							form.findField(field).setValue(form
									.findField(field).getStore().getAt(0));
						} else if (field == 'er_iisservice') {
							if (jsonObject['serviceCombo'] != null
									&& jsonObject['serviceCombo'] != undefined) {
								form
										.findField('er_iisservice')
										.getStore()
										.loadRawData(jsonObject['serviceCombo']);
								form
										.findField('er_iisservice')
										.setValue(jsonObject['serviceComboValue']);
							}
							if (jsonObject['compMultiselect'] != null
									&& jsonObject['compMultiselect'] != undefined) {
								/*form
										.findField('components')
										.getStore()
										.loadRawData(jsonObject['compMultiselect']);
								form
										.findField('components')
										.setValue(jsonObject['compMultiselectValue']);*/
							}
						}
					}
				});
	},
	clearStoreValue : function(field, form) {

		form.findField(field).getStore().removeAll();
	}
})