Ext.define('ConsolidatedService.view.ConsolidatedServiceSettings', {
			extend : 'Ext.form.Panel',
			alias : 'widget.consolidatedservicesettings',			
		    id:'settings',
			//cls:'configMode_popup_inner',
			defaults:{
				labelSeparator : '',
				labelAlign: 'top',
				margin: '0 20 0 0'
			},
			layout : 'column',
			items : [{
						xtype : 'excludeweekends',
						margin: '8 20 0 0',
						width: 110,
					},{
						xtype : 'timeperiod', margin: '8 0 0 0'
					}, {
						xtype: 'splitter',
						height: 2,
						margin: '10px 0px 10px 0px',
						draggable:false,
						style: {
							'cursor': 'default'
						}
					},
					{
						xtype : 'reportgeneration', margin: '0 0 0 0'
					},
				{
					xtype: 'splitter',
					id:'RTMSplitter',
					height: 2,
					margin: '10px 0px 10px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
				},
				{xtype:'timelinesave', margin: '0 0 0 0'}],
					loadScreenLabels : function(screenLabels){
						var consolidatedSettingsForm = this.getForm();
						 Ext.getCmp('excludeWeekendsCombo').setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
                        Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
                        Ext.getCmp('fromTimeLbl').setText(screenLabels['reporter.common.From']);
                        Ext.getCmp('toTimeLbl').setText(screenLabels['reporter.common.To']);
                        Ext.getCmp('fromHrsLbl').setText(screenLabels['reporter.common.Hrs']);
                        Ext.getCmp('fromMinsLbl').setText(screenLabels['reporter.common.Mins']);
                        Ext.getCmp('toHrsLbl').setText(screenLabels['reporter.common.Hrs']);
                        Ext.getCmp('toMinsLbl').setText(screenLabels['reporter.common.Mins']);
                        
					},
					loadDatas : function(jsonData){
                        var me = this;
                        
                        var screenLabels = jsonData['screenLabels'];
                        me.loadScreenLabels(screenLabels);
                        
                        var consolidatedSettingsForm = me.getForm();
                        
                        me.setComboOptionsInList(consolidatedSettingsForm, 'reportGeneration', jsonData.reportgenComboArray, jsonData.reportgenCombo_value);
                        me.setComboOptionsInList(consolidatedSettingsForm, 'excludeWeekendsCombo', jsonData.excludeWeekendsCombo, jsonData.excludeWeekendsComno_value);
                      
                        me.setComboValue(consolidatedSettingsForm, 'timefrom', jsonData.timePeriod.Hourfrom);
                        me.setComboValue(consolidatedSettingsForm, 'minfrom', jsonData.timePeriod.Minfrom);
                        me.setComboValue(consolidatedSettingsForm, 'timeto', jsonData.timePeriod.Hourto);
                        me.setComboValue(consolidatedSettingsForm, 'minto', jsonData.timePeriod.Minto);
						 
						  
                        
                   },
                    setComboOptionsInList : function(form, fieldName, list, value){
                        form.findField(fieldName).getStore().loadRawData(list);
                        form.findField(fieldName).suspendEvents(false);
                        var valueAssigned = false;
                        for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
                            if(list[listCounter].valueField == value && value != "" && value != null){
                                form.findField(fieldName).setValue(value);
                                valueAssigned = true;
                            }
                        }
                        if(!valueAssigned){
                            form.findField(fieldName).setValue(list[0].valueField);
                        }
                        form.findField(fieldName).resumeEvents();
                    },
                     setComboValue : function(form,fieldName,value){
                         form.findField(fieldName).suspendEvents(false);
                         form.findField(fieldName).setValue(value);
                         form.findField(fieldName).resumeEvents();
                    }
		});