Ext.define('zonereport.controller.ConsolidatedZone', {
	extend: 'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	views: ['Main'],
	refs: [{
		selector: 'main',
		ref: 'main'
	}, {
		selector: 'newUtilities',
		ref: 'newUtilities'
	},{
		selector: 'ReporterSettings',
		ref: 'ReporterSettings'
	}, {
		selector: 'resultpanel',
		ref: 'resultpanel'
	},
	{selector:'nomeasurepanel', ref:'nomeasurepanel'},
	{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init: function () {
		this.control({
			'newUtilities': {
				'afterrender': this.loadTools
			},
			'main': {
				'boxready': this.afterMainRender
			},
			'reportsettings': {
				'afterrender': this.loadSettings
			},
			'zonereportform combo[name="select_farm"]': {
				'select': this.ReloadFields
			},
			'zonereportform combo[name="er_comptype"]': {
				'select': this.ReloadFields
			},
			'zonereportform combo[name="er_type"]': {
				'select': this.typeChange
			},
			/*'reportsettings combo[name="er_excwe"]': {
				'select': this.weekendOnChange
			},*/
			'reportsettings combo[name="er_trenddata"]':
			{
				'select' :  this.changeTrend
			},
			'reportsettings combo[name="reportGeneration"]': {
				'select': this.reportGenChange
			},
			'reportsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'zonereportform button[name="submit"]': {
				'click': this.showResult
			},
			'zonereportform button[name="save"]': {
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'newUtilities > #printTool > button': {
				'click': this.printFile
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveReportAsPDF
			},
			'newUtilities > #csvTool > button': {
				'click': this.saveCsv
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			
			'newUtilities > #scheduleTool > button': {
				'click': this.saveSchedule
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.saveFavorite
			},
			  'zonereportform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'resultpanel': {
				'render': this.resizePanel
			}
		});
	},
	changeTrend: function( combo )
	{
		var localjson=appConstants.publicjsonData;
		var er_trenddata;
		if (isSettingsEnabled)
		{
			er_trenddata = Ext.getCmp("er_trenddata").getValue();
		}
		else
		{
			er_trenddata = localjson.er_trenddata;
		}
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var trendenable = 'true';
		if (trendenable == 'true') 
		{
			var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params : param1,
						scope : this,
						async : true,
						success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							var comboVal=jsonData.combo;
							var timelineRawData = jsonData.combo;
							var timelineCombo = Ext.getCmp('er_timeline');
							timelineCombo.getStore().removeAll();
							timelineCombo.getStore().loadRawData(jsonData.combo);
							var flag=false;
							for(var i = 0; i < comboVal.length; i++)
							{
							  if(comboVal[i].valueField == er_timeline)
							  {
								flag=true;
							  }
							}
							if(flag)
								timelineCombo.setValue(er_timeline);
							else
								timelineCombo.setValue("1 day");
						}
					});
			var er_timelineVal = Ext.getCmp('er_timeline').getValue();
			var er_stdateVal = Ext.getCmp('er_stdate').dataArray;
			var er_enddateVal = Ext.getCmp('er_enddate').dataArray;
			var er_sthr = Ext.getCmp('er_sthr').dataArray;
			var er_endhr =Ext.getCmp('er_endhr').dataArray;
			var inidateVal = appConstants.publicjsonData.hiddenfields.inidate;

			if ( er_timelineVal == 'Any' )
			{
				Ext.getCmp('er_stdate').setDisabled(false);
				Ext.getCmp('er_enddate').setDisabled(false);
				Ext.getCmp('er_sthr').setDisabled(false);
				Ext.getCmp('er_endhr').setDisabled(false);
			}
			else
			{
				Ext.getCmp('er_stdate').setDisabled(true);
				Ext.getCmp('er_enddate').setDisabled(true);
				Ext.getCmp('er_sthr').setDisabled(true);
				Ext.getCmp('er_endhr').setDisabled(true);
			}
			var param_val = "";  
		
		if (er_trenddata == "No")
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js

			param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["
					+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr
					+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param_val = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidateVal
					+ "]";
			}
			else
			{
				param_val = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal
					+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["
					+ er_sthr + "]&P4=["+er_endhr+"]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidateVal
					+ "]";
			}
		}
					Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param_val,
					scope : this,
					async : true,
					success : function(response) {
						var jsonText = response.responseText;
						var jsonObject = Ext.decode(jsonText);
						var values = jsonObject.timeline;
						Ext.getCmp('er_stdate').dataArray=values[0];
						Ext.getCmp('er_enddate').dataArray=values[1];
						Ext.getCmp('er_sthr').dataArray=values[2];
						Ext.getCmp('er_endhr').dataArray=values[3]; 
						mgr_stmin = values[4];
						mgr_enmin = values[5];

						Ext.getCmp('er_stdate').setValue(values[6]);
						Ext.getCmp('er_enddate').setValue(values[7]); 
						Ext.getCmp('er_sthr').setValue(values[8]);
						Ext.getCmp('er_endhr').setValue(values[9]); 
						stmin =values[10];
						enmin = values[11];
				}
				});
		}
	},
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController = this;
			var tpl = new Ext.XTemplate('<div style="float:left;margin: 0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:564,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'354px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype:'reportsettings',
					parent:this
				}
			],
			onRender:function(){
				Ext.EventManager.onWindowResize(function () {
					Ext.get('configMod').setStyle('left', '');
				});
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
			renderTo:'zonereport-body'
			});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
			return false;
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		else if (Ext.getCmp('reportGeneration').getValue() == 'background-csv' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	goTo: function(btn){
		var from_sch = appConstants.publicjsonData['hiddenfields']['fromScheduleModify'];
		 if (from_sch != null && from_sch == "Yes")
			 this.saveSchedule(btn);
		 else
			 this.saveFavorite(btn);
	},
	resizePanel: function () {
		var me = this;
		Ext.EventManager.onWindowResize(function () {
			if (!Ext.isEmpty(appConstants.publicGridData)) {
				me.loadGrid(appConstants.publicGridData);
			}
		});
	},
	  changeEr_mode: function (combo) {
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({
						duration: 250,
						to: {
							y: -530
						}
					});
		}
		this.showResult();
	 },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('zonereportform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	sendMail: function () {
		Ext.widget('sendmail').show();
	 },
	saveSchedule: function (btn) {
		var isValid = this.validateMainForm();
		if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Consolidated Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		}
		if (isValid) {
				this.updateQueryString();
				var qryStr=null;
				//	    var from_sch = appConstants.publicjsonData['hiddenfields']['fromScheduleModify'];
				//    if (from_sch != null && from_sch == "Yes")
				var target= "/final/reporter/ErSaveSchedule.jsp?" + appConstants.queryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (btn.getId()=='save')
				{
					//document.location=target+'&showSchWindow=no';
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	saveFavorite: function (btn) {
		var isValid = this.validateMainForm();
		/* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Consolidated Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		} */
		if (isValid) {
			this.updateQueryString();
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			var favorite_id = hiddenFields["favorite_id"];
			var target = "../servlet/com.eg.ErFavoriteC?" + appConstants.queryString + "&er_view=GRAPH&cmd=client&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getId()=='save')
			{
				//document.location=target+'&showSchWindow=no';
					target+='&FavoriteId='+favorite_id+'&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	showResult: function () {
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		 var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var result = checkDateTime(stDateTime, enDateTime);
		if (!result) {
			return;
		}
		if (this.validateMainForm() && this.validateSettings())
		{
			this.submitReport();
		}
	},
	validateMainForm: function () {
		var zone = Ext.getCmp('select_farm');
		var componenttype = Ext.getCmp('er_comptype');
		var reportType = Ext.getCmp('er_type').getValue();
		if (zone.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Consolidated Reports',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if (componenttype.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Consolidated Reports',
				msg: componenttype.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if (reportType == 'Yes') {
			var measure = Ext.getCmp('select_testmes');
			if (measure.getValue() == '-1') {
				Ext.MessageBox.show({
					title: 'Consolidated Reports',
					msg: measure.getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		return true;
	},
	validateSettings: function () {
		var localhiddens=appConstants.publicjsonData['hiddenfields'];
		var isSettingsOk = true;
		var MaxDaysInMonth = localhiddens['getMaxDaysInMonth'];
		var er_usertimeline = localhiddens['userTimeline'];
		var reportgen;
		if (isSettingsEnabled)
		{
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen= appConstants.publicjsonData.reportGeneration;
		}

		var er_timeline = Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		if (!checkDateTime(stDate, enDate)) {
			isSettingsOk = false;
		}
		var usertimelineValid=true;
		if (er_usertimeline != null && er_usertimeline != '-1') {
			
			usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
						
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: 'Consolidated Reports Settings',
					msg: _invalidUserTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if (reportgen != null && reportgen == 'foreground' && usertimelineValid) {
			var limitforbg = localhiddens['limitforbg']
			if (!Ext.isEmpty(limitforbg)) {
				if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					isSettingsOk = false;
				}
			}
		} else if(usertimelineValid) {
			var reportName;
			if (isSettingsEnabled)
			{
				reportName= Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				reportName= appConstants.publicjsonData.bgReportName;
			}
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult: function (btn) {
		if (btn == "yes") {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
			this.submitReport();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType = Ext.getCmp('reportGeneration');
			var bgreportNameObj = Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			this.showResult();
		 }
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	printFile: function () {
		var saveQString = appConstants.publicjsonData.saveQString;
		var s_qryString = "../servlet/com.eg.ErCtxServerReportC?" + saveQString;
		var reportType = appConstants.publicjsonData.selectedreportType;
		if (reportType == 'Yes')
			s_qryString += "printGraph=yes&opt=chart&pdfPrint=yes";
		else
			s_qryString += "&er_view=PRINT&pdfPrint=yes";
		s_qryString=this.getGridColSortParam(s_qryString);

		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	saveReportAsPDF: function () {
		var saveQString = appConstants.publicjsonData.saveQString;
		var reportType = appConstants.publicjsonData.selectedreportType;
		if (reportType == 'Yes')
			saveQString += "printGraph=yes&opt=chart";
		else
			saveQString += "&er_view=PRINT";
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
		s_qryString=this.getGridColSortParam(s_qryString);

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var saveQString = appConstants.publicjsonData.saveQString;
		var reportType = appConstants.publicjsonData.selectedreportType;
		if (reportType == 'Yes')
			saveQString += "printGraph=yes&opt=chart";
		else
			saveQString += "&er_view=PRINT";
		var s_qryString = saveQString;
		s_qryString=this.getGridColSortParam(s_qryString);
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	saveCsv: function () {
		
		window.location = '../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	disableTools: function () {
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		//Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	getXmlForUrl: function (URL) {
		try {
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function (response) {
					var jsonText = response.responseText;
					chartAttrib = Ext.decode(jsonText);
				},
				failure: function () {
					alert('I am not loading...' + URL);
				}
			});
			return chartAttrib;
		} catch (e) {
			alert('[Exception] ' + e);
		}
	},
	loadGrid: function (GridArrays) {

		var thisController=this;
		var resultPanelObj = Ext.getCmp('resultPanel');
				var itemArray = new Array();    
			for (var i in GridArrays) 
			{
				var gridDataObj = GridArrays[i];	 
				var mainColArray = new Array();
				var fieldsToStore = new Array();
				//var gridDataObj = GridArrays[0];
				var gridColumn = gridDataObj.columns;
				var count=0; 
				var units= gridDataObj.units;
				for (var key in gridColumn)
				{
					var mainColumn = key;
					subColArrJson = gridColumn[key];
					if (subColArrJson.length>0)
					{
						var subColArray = new Array();
						for (var subKey in subColArrJson)
						{ 
							subcol = subColArrJson[subKey]+" (" + units[mainColumn]+ ")";
							var dataind=subcol+(count++);
							fieldsToStore.push(dataind);
							subColArray.push({ 
								header: subcol,
								sortable: true,
								align:'center',
								dataIndex: dataind,
								listeners:
								{
									headerclick:function(ct, column, e, t, eOpts ){
										thisController.gridColIndexParam=column.getIndex();
										thisController.gridColStateParam=column.sortState;
									}
								},
								renderer: function( val,metaData )
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+val+'"';
									val = Ext.getCmp('gridId'+i).getDecimalAlignFormat(val);
									return val;
								},
								doSort: function(state) {
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2){
											if (v1.index==0)
												return;
											if(v1.data.Server0 == 'Summary')
												return;
											v1 = v1.get(field);
											v2 = v2.get(field);
											if(!isNaN(v1) && !isNaN(v2))
											{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v1= isNaN(v1) ? 0 : v1;

											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											v2= isNaN(v2) ? 0 : v2;
											}
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									});
								}
							});
						}
						mainColArray.push({ 
							header: key,
							sortable: true,
							columns:subColArray,
							locked:false,
						})
					}
					else 
					{
						var isLocked = false;
						var width = null;
						var needModify = 'yes';
						if(count == 0)
						{
							isLocked = true;
							width = 150;
							needModify = 'no';
						}
						var dataind=key+(count++);
						fieldsToStore.push(dataind);
						var setAlign='left';
						if (key.toLowerCase()=='health')
						{
							setAlign='center';
						}
						mainColArray.push({ 
							header: key,
							sortable: true,
							locked:isLocked,
							align:setAlign,
							needModify:needModify,
							dataIndex: dataind,
							renderer: function (value, metaData, record, row, col, store, gridView) 
							{
								if (value.indexOf('~') > -1) 
								{
									var text = value.substring(0, value.indexOf('~'));
									var url = value.substring(value.indexOf('~') + 1);
									value = '<a class="anchorLinkDefault" href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" >' + text + '</a>';
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+text+'"';
								}
								else
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = Ext.getCmp('gridId'+i).getDecimalAlignFormat(value);
								}
								return value;
							},
							listeners:{
								headerclick:function(ct, column, e, t, eOpts ){
									thisController.gridColIndexParam=column.getIndex();
									thisController.gridColStateParam=column.sortState;
								}
							},
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										if (v1.index==0)
											return;
										if(v1.data.Server0 == 'Summary')
											return;
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(isNaN(v1))
											v1=v1.substring(0,v1.indexOf('~'));
										if(isNaN(v2))
											v2=v2.substring(0,v2.indexOf('~'));
										if(!isNaN(v1) && !isNaN(v2))
										{
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
										}
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								});
							}
						});
						if(isLocked)
						{
							mainColArray[mainColArray.length-1].flex=1.0;
							mainColArray[mainColArray.length-1].width=width;
						}
						else
						{
							mainColArray[mainColArray.length-1].flex=1.0;
							mainColArray[mainColArray.length-1].minWidth=80;
						}

					}
				}
				var isPagingHidden;
				if (gridDataObj.dataAray.length<gridPageSize)
					isPagingHidden=true;
				else
					isPagingHidden=false;
				var activePage = 1;
				 var storeObj = Ext.create('Ext.data.ArrayStore', {
					 fields:fieldsToStore,
					 proxy : {
						type : 'pagingmemory',
						reader : {
							type : 'array'
						}
					}, 					
					 remoteSort : true,
					 pageSize:gridPageSize,
					 autoLoad : true,
					 sorters: { property: fieldsToStore[0], direction : 'ASC' },// vengat
					 data : gridDataObj.dataAray,
 
				});
			itemArray.push({
				xtype:'panel',
				ui:'newGraphPanel',				
					 title:gridDataObj.gridTitle,			
				items:[{
				  xtype:'customgrid',
					store: storeObj,
					columns: mainColArray,
					frame:false,
					id:'gridId'+i,
					margin:'0 10 10 10',
					autoScroll:true,
					scroll:true,
					ui:'newGridPanel',
					border:true,
					layout: 'border',
					split: true,
					lockedGridConfig: {
						emptyText: '',
						collapsible: false,
						flex: 1/4
					},
					sortableColumns: true,
					needtoFixColumn:true,
					forceFitColsCount:9,
					viewConfig: 
					 {
						getRowClass: function(record, rowIndex, rowParams, store)
						{
							if (rowIndex==0)
								return 'firstRowClass'; //configured in ext-custom-com.css
						}
					},
					dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'newPagination',
							dock: 'bottom',
							displayInfo: true,
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
							listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
					}],
					listeners:{
						render:function(obj){
							Ext.defer(function() {
								//obj.columns[0].setSortState("ASC",true,true);
							},100);
						}
					} 
			}],
			});
			}
			resultPanelObj.removeAll();
			resultPanelObj.add(itemArray);
			resultPanelObj.show();

	   /* if (!Ext.isEmpty(GridArrays)) {
			for (var i in GridArrays) {
				
				var gridDataObj = GridArrays[i];
				var columnDetails = gridDataObj.columns;
				var dataArraytoStore = gridDataObj.dataAray;
				var noOfColumns = gridDataObj.TOTAL_COLUMN_COUNT;
				var singleColumnCount = gridDataObj.SINGLE_SUBCOLUMN_COUNT;
				var viewPortWidth = this.getMain().getWidth();
				var COLUMN_MIN_WIDTH = 55;
				var SINGLE_COLUMN_WIDTH = 80;
				var SERVER_MIN_WIDTH = 160;
				var count = 0;
				noOfColumns += 1; // ADDED FOR HEALTH COLUMN;
				var mutipleColumns = noOfColumns - singleColumnCount;
				var widthNeeded = 150 + (mutipleColumns * COLUMN_MIN_WIDTH) + (singleColumnCount * SINGLE_COLUMN_WIDTH);
				var units = gridDataObj.units;
				var fieldstoStore = new Array();
				var mainColumnsObjArray = new Array();
				var eachWidth = 0;
				if (viewPortWidth > widthNeeded) {
					eachWidth = (viewPortWidth - (SERVER_MIN_WIDTH)) / noOfColumns;
				} else {
					eachWidth = COLUMN_MIN_WIDTH;
				}
				var columnIndx=this.gridColIndexParam;
							if(columnIndx==-1)
								columnIndx=0;
							else if(columnIndx>=noOfColumns)
								columnIndx=0;
				 for (var key in columnDetails) {
					var mainColumn = key;
					var subColumns = new Array();
					var subColObjArray = new Array();
					subColumns = columnDetails[key];
					if (subColumns != undefined && !Ext.isEmpty(subColumns)) {
						var subColumnCount = subColumns.length;
						var adujstedWidth = eachWidth;
						if (subColumnCount == 1) {
							if (eachWidth < SINGLE_COLUMN_WIDTH)
								adujstedWidth = SINGLE_COLUMN_WIDTH;
						}
						var measureColumnName = " (" + units[mainColumn] + ")";

						for (var j in subColumns) {
							var tmp = subColumns[j];
							tmp+=measureColumnName;


							 //fieldstoStore.push( {name: mainColumn + "_" + tmp, type: 'string'});
							  fieldstoStore.push( mainColumn + "_" + tmp);
							 var colgridwidth=adujstedWidth+60;
							 subColObjArray.push({
								header: tmp,
								sortable: true,
								dataIndex: mainColumn + "_" + tmp,
								align: 'center',
								width: colgridwidth,
								listeners:{
									headerclick:function(ct, column, e, t, eOpts ){
										thisController.gridColIndexParam=column.getIndex();
										thisController.gridColStateParam=column.sortState;
									}
								},
								doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);

													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v1= isNaN(v1) ? 0 : v1;

													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													v2= isNaN(v2) ? 0 : v2;
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										}
								});
						}

						mainColumnsObjArray.push({
							header: mainColumn,
							columns: subColObjArray
						});
					} else {
						if (count == 0) {
							// fieldstoStore.push({name: mainColumn,  type: 'string'});//sortType: 'asString',
							 fieldstoStore.push( mainColumn);
							  mainColumnsObjArray.push({
								header: mainColumn,
								sortable: true,
								minWidth: SERVER_MIN_WIDTH,
								dataIndex: mainColumn,
								align: 'left',
								//flex: 1,
								doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										},
								renderer: function (value, metaData, record, row, col, store, gridView) {
									  if (value.indexOf('~') > -1) {
										var text = value.substring(0, value.indexOf('~'));
										var url = value.substring(value.indexOf('~') + 1);
										value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" >' + text + '</a>';
									}
									return value;
								}
							});
						} else {
								var s_unit = units[mainColumn];
								var colHeader;
								if (s_unit != undefined) {
									colHeader = " (" + units[mainColumn] + ")";
								} else {
									colHeader="";
								}
							  //fieldstoStore.push( {name: mainColumn, type: 'string'});
							  fieldstoStore.push( mainColumn);
							  subColObjArray.push({
								header: colHeader,
								sortable: true,
								dataIndex: mainColumn,
								align: 'center',
								width: eachWidth,
								renderer: function (value, metaData, record, row, col, store, gridView) {

									 if (value.indexOf('~') > -1) {
										var text = value.substring(0, value.indexOf('~'));
										var url = value.substring(value.indexOf('~') + 1);
										value = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" >' + text + '</a>';
									}
									return value;
								},
								doSort: function(state) {
											var ds = this.up('grid').store;
											var field = this.getSortParam();
											ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													if (v1.index==0)
														return;
													v1 = v1.get(field);
													v2 = v2.get(field);
													// transform v1 and v2 here
													return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
										},
								listeners:{
									headerclick:function(ct, column, e, t, eOpts ){
										thisController.gridColIndexParam=column.getIndex();
										thisController.gridColStateParam=column.sortState;
									}
								}

							 });

							mainColumnsObjArray.push({
								header: mainColumn,
								columns: subColObjArray
							});
						}
					}
					count++;
				}

			var fetchedData = function(){
				this.data = null;
				this.total = 0;
			}

			var isPagingHidden;
			if (dataArraytoStore.length<gridPageSize)
				isPagingHidden=true;
			else
				isPagingHidden=false;
			var storeObj = Ext.create('Ext.data.Store', {
				fields: fieldstoStore,
					data:dataArraytoStore,
					autoLoad : true,
				 proxy : {
						type : 'memory',
						reader : {
							type: 'array', root : 'data', totalProperty : 'total'
						},
					}, 
				//pageSize:gridPageSize,	//gridPageSize is added in ErTracker.jsp
				//autoLoad : true,
				 listeners : {
					beforeload : function(store, operation, eOpts){
						var page = operation.page;
						var limit = operation.limit;
						var dataArraytoStoreLen=dataArraytoStore.length;
						var start=(page-1)*limit;
						var totalRec=page*limit;
						fetchedData.data = dataArraytoStore.slice(start,totalRec);
						fetchedData.total =dataArraytoStoreLen;
						store.proxy.data = fetchedData;
					}
				} 
			});
			var gridpanel = Ext.widget('customgrid', {
				store: storeObj,
				frame:false,
				autoScroll:true,
				scroll:true,
				cls:'gridSkin horizontal-scroll',
				border:true,
				sortableColumns: true,
				needtoFixColumn:true,
				columns: mainColumnsObjArray,
				title: gridDataObj.gridTitle,
				viewConfig: {
					getRowClass: function(record, rowIndex, rowParams, store){
							if (rowIndex==0)
									return 'firstRowClass'; //configured in ext-custom-com.css
							}
				},
				listeners:{
					render:function(obj){
						Ext.defer(function() {
							obj.columns[columnIndx].setSortState("ASC",true,true);
						},100);
					}
				},
				dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'pagingtoolbar',
							dock: 'bottom',
							displayInfo: true,
							cls:'pagingtoolbar',
							store: storeObj,
							hidden:isPagingHidden,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display"
						}]
			});
				itemsArray.push(gridpanel);
			}
			Ext.getCmp("csvTool").setDisabled(false);
			if (resultPanelObj.getHeader() != undefined && resultPanelObj.getHeader().show()) {
				resultPanelObj.getHeader().hide();
			}
			resultPanelObj.removeAll();
			resultPanelObj.add(itemsArray);
			 resultPanelObj.show();
			 getHeightPanel = resultPanelObj.getHeight();
			conditionalHeight = Ext.getBody().getViewSize().height / 2;
			if (getHeightPanel > conditionalHeight) {
				Ext.select('.gridSkin').setStyle('margin', '0px 10px 10px 0px');
			} else {
				Ext.select('.gridSkin').setStyle('margin', '0px');
			} 
		}*/
	},
	loadReportData: function (jsonData) {
		var dataAvailable = false;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.select('.dataPanel ').setStyle('border-width','1px');
		var backgroundresultsObj = Ext.getCmp('backgroundresults');
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (reportGeneration == 'foreground') {
		 //   backgroundresultsObj.hide();
			resultPanelObj.removeAll();
			itemsArray = new Array();
			var reportData = jsonData.reportData;
			
			var selectionDetailsjson = jsonData.selectionDetails;
			if (jsonData.hasOwnProperty('reportData')) {
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(false);
				//Ext.getCmp("upbutton").setDisabled(false);
				var reportData = jsonData.reportData;
				reportType = jsonData.selectedreportType;
				
				if (reportType == 'Yes') {
					Ext.getCmp("csvTool").setDisabled(true);
					var chartUrlArray = new Array();
					chartUrlArray = reportData.chartUrls;
					noOfchart = chartUrlArray.length;
					for (var i = 0; noOfchart > i; i++) {
						var url = chartUrlArray[i];
						var chartProperties = this.getXmlForUrl(url);
						 if (!Ext.isEmpty(chartProperties) && chartProperties.hasOwnProperty('XML')) {
							dataAvailable = true;
							var margin;
							if (i==0)
							{
								//margin=10;
								margin='0 0 10 10';
								flex=0.65;
							}
							else
							{
								margin='0 10 10 10';
								flex=1;
							}
							var chartbox = {
								xtype: 'panel',
								ui:'newGraphPanel',
								//title:"<div class='printOuterBoxHeader'>"+chartProperties.chartTitle+"</div>",
								title:chartProperties.chartTitle,
								margin:margin,
								flex:flex,
								data: chartProperties,
								id: 'fusion' + i
							};
							itemsArray.push(chartbox);
						}
					}
			
					if (dataAvailable) {                        
						 resultPanelObj.add({
							xtype:'panel',
							ui:'multiGraphPanel',
							title: "<div class='printOuterBoxHeader'>"+reportData.title+"</div>",
							//margin:'0 10 5 10',
							//cls:'datapanel',
							layout:{
								type:'hbox',
								align:'stretch'
							},
							items:itemsArray
						});
						resultPanelObj.show();
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						} 
						for (var i = 0; i < noOfchart; i++) {
							var containerObj = Ext.getCmp('fusion' + i);
							var data = containerObj.data;
							if (!Ext.isEmpty(data) && data.hasOwnProperty('XML')) {
							   // var innerHtml = data.innerHtml;
								var chartFor = data.chartFor;
								var chartHight = data.chartHight;
								if (chartFor == 'Top') {
									//appConstants.BarDrillDownURLs = data.UrlForDrillDown;
									appConstants.erUtils.updateBarChart(appConstants.chartType,'',data.XML,data.swfpath,data,data.chartHeight-20,data.chartWidth,containerObj);
								} else if (chartFor == 'distribution') {
									appConstants.erUtils.updatePieChart(appConstants.chartType,data,'pieColors','urlLinks','pieLabels','',data.XML,data.swfpath,data,containerObj);
									//appConstants.PieDrillDownURLs = data.UrlForDrillDown;                                   
								}
							} else {
								containerObj.update('<div><img src="/final/reporter/images/nographformeasure.gif" width="100%" /></div>');
							}
						}
						appConstants.initLdgMask.hide();
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails); 						
					} else {
						this.disableTools();
						resultPanelObj.hide();
						this.getNomeasurepanel().show();
						appConstants.initLdgMask.hide();
					}
				} else {
					appConstants.publicGridData = reportData.gridArray;
					this.loadGrid(appConstants.publicGridData);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					appConstants.initLdgMask.hide();
				}
			} else {
				this.disableTools();
				resultPanelObj.hide();
				this.getNomeasurepanel().show();
				appConstants.initLdgMask.hide();
			}
		} else if (reportGeneration == 'background' || reportGeneration == 'background-csv') {
			resultPanelObj.hide();
			var htmlStr = '';
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;

				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} else {
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>';
			}
			 this.getBackGroundPanel().update('<div>'+htmlStr+'</div>');
			 this.getBackGroundPanel().show();
			appConstants.initLdgMask.hide();
		}
	},
	submitReport: function () {
		appConstants.initLdgMask.show();
		var resultPanelObj = Ext.getCmp('resultPanel');
		var selectionDetailsObj = Ext.getCmp('selectionDetails');
		var backgroundresultsObj = Ext.getCmp('backgroundresults');

		var reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportGeneration=appConstants.publicjsonData.reportGeneration;
		}

		this.updateQueryString();
		var reportType = '';
		var noOfchart = 0;
		 resultPanelObj.removeAll();
		var finalParams = '';
		var urlforAjax = '';
		if (reportGeneration == 'foreground') {
			urlforAjax = '../servlet/com.eg.ErCtxServerReportC';
			finalParams = appConstants.queryString + "&isSubmit=true&responseType=json";
		}
		else if (reportGeneration == 'background')
		{
			urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
			var bg_reportname;
			if (isSettingsEnabled)
			{
				bg_reportname=  Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				bg_reportname=appConstants.publicjsonData.bg_reportname;
			}
			finalParams = appConstants.queryString + "&bg_reportname=" +bg_reportname+ "&isSubmit=true&responseType=json";
		}
		else if (reportGeneration == 'background-csv')
		{
			urlforAjax ="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
			var bg_reportname;
			if (isSettingsEnabled)
			{
				bg_reportname=  Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				bg_reportname=appConstants.publicjsonData.bg_reportname;
			}
			finalParams = appConstants.queryString + "&bg_reportname=" +bg_reportname+ "&isSubmit=true&responseType=json";
		}
		//by karthikeyan
			finalParams+= '&er_RmDispName='+appConstants.er_RmDispName;
			Ext.Ajax.request({
			url: urlforAjax,
			params: finalParams,
			method: 'POST',
			scope: this,
			async: true,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadReportData(appConstants.publicjsonData);
			}
		});
	},
	reportGenChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType = Ext.getCmp('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if (reportGenType == 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			
		} 
		else if (reportGenType == 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		} 
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	timeLineOnChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var startDateObj = Ext.getCmp('er_stdate');
		var startHrObj = Ext.getCmp('er_sthr');
		var endDateObj = Ext.getCmp('er_enddate');
		var endHrObj = Ext.getCmp('er_endhr');
		var timelineObj = Ext.getCmp('er_timeline');
		if (timelineObj.getValue() == 'Any') {
			startDateObj.setDisabled(false);
			startHrObj.setDisabled(false);
			endDateObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			timelineObj.suspendEvents(true);
			this.updateQueryString();
			Ext.Ajax.request({
				url: '/final/reporter/ErZoneReportJson.jsp',
				params: appConstants.queryString,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.publicjsonData = jsonData;
					var start_hour = jsonData.startHour;
					var end_hour = jsonData.endHour;
					var start_date = jsonData.startDate;
					var end_date = jsonData.endDate;
					startDateObj.setDisabled(true);
					startHrObj.setDisabled(true);
					endDateObj.setDisabled(true);
					endHrObj.setDisabled(true);
					startDateObj.setValue(start_date);
					startHrObj.setValue(start_hour);
					endDateObj.setValue(end_date);
					endHrObj.setValue(end_hour);
				}
			});
			timelineObj.resumeEvents();
		}
	},
	/* weekendOnChange: function () {
		var weekendvalue = Ext.getCmp('er_excwe').getValue();
		var excludeDaysObj = Ext.getCmp('excludeDays');
		if (weekendvalue == 'Yes') {
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
		} else {
			excludeDaysObj.hide();
		}
	},*/
	typeChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportType = Ext.getCmp('er_type').getValue();
			Ext.Ajax.request({
				url: '/final/reporter/ErZoneReportJson.jsp?&er_type='+reportType,
				params: appConstants.queryString,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					appConstants.repotgene=jsonData;
					if (reportType == 'Yes')
					{
						var screenLabels = jsonData.screenLabels;
						if (isSettingsEnabled)
						{
							Ext.getCmp('er_priority').show();
							var jsonData=appConstants.publicjsonData;							
							var comboRawData = jsonData.showDataCombo;
							comboRawData = jsonData.priorityCombo;
							selectedComboOption = jsonData.selectedPriority;
							comboObject = Ext.getCmp('er_priority');
							comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
							comboObject.getStore().loadRawData(comboRawData);
							if (!Ext.isEmpty(selectedComboOption)) {
								comboObject.setValue(selectedComboOption);
							} else {
								comboObject.setValue(comboRawData[0].valueField);
							}
							var reportGenCombo=jsonData.reportGenerationCombo;
							var selreportGeneration=jsonData.reportGeneration;
							var reportGen=Ext.getCmp('reportGeneration');
							var setRepoGen= jsonData.reportGeneration;
							var reportNameObj = Ext.getCmp('bgReportName');
							reportGen.getStore().loadRawData(reportGenCombo);
							reportGen.setValue(setRepoGen);
							if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
							{
								reportNameObj.hide();
								Ext.getCmp('moreOptionCloseId').show();
								Ext.getCmp('submitViaSetting').hide();
							}
							else
							{
								reportNameObj.show();
								Ext.getCmp('moreOptionCloseId').hide();
								Ext.getCmp('submitViaSetting').show();
							}
						}
						comboObject = Ext.getCmp('select_testmes');
						comboObject.setFieldLabel(screenLabels['reporter.consolidated.Measure']);
						comboObject.show();
						Ext.getCmp('er_mode').hide();
					}
					else
					{
						if (isSettingsEnabled)
						{
							Ext.getCmp('er_priority').hide();
							var reportGenCombo=jsonData.reportGenerationCombo;
							var selreportGeneration=jsonData.reportGeneration;
							var reportGen=Ext.getCmp('reportGeneration');
							var setRepoGen= jsonData.reportGeneration;
							var reportNameObj = Ext.getCmp('bgReportName');
							reportGen.getStore().loadRawData(reportGenCombo);
							reportGen.setValue(setRepoGen);
							if(setRepoGen!=undefined && setRepoGen!=null && setRepoGen=='foreground')
							{
								reportNameObj.hide();
								Ext.getCmp('moreOptionCloseId').show();
								Ext.getCmp('submitViaSetting').hide();
							}
							else
							{
								reportNameObj.show();
								Ext.getCmp('moreOptionCloseId').hide();
								Ext.getCmp('submitViaSetting').show();
							}

						}
						else
						{
							var er_priorityobj = Ext.getCmp('er_priority');
							if (reportType == 'No')
							{
								if (er_priorityobj!=undefined && er_priorityobj!=null && er_priorityobj!="")
								{
									er_priorityobj.hide();
								}
							}
						}
						Ext.getCmp('select_testmes').hide();
						Ext.getCmp('er_mode').hide();
					}
				}
			});
	},
	ReloadFields: function (obj) {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		clickedButton = obj.getId();
		var reportType = Ext.getCmp('er_type').getValue();
		this.updateQueryString();
		var Qstring = appConstants.queryString;
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		if (clickedButton == 'er_comptype') {
			if (reportType == 'No')
				return;
			else {
				var option = appConstants.publicjsonData.hiddenfields.option;
				Qstring = "select_farm=" + Ext.getCmp('select_farm').getValue() + "&er_comptype=" + Ext.getCmp('er_comptype').getValue()+"&option="+option;
			}
		}
		Ext.Ajax.request({
			url: '/final/reporter/ErZoneReportJson.jsp',
			params: Qstring,
			scope: this,
			async: false,
			method: 'GET',
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				if (clickedButton == 'select_farm') {
					comboRawData = jsonData.compTypeCombo;
					selectedComboOption = jsonData.selectedcompType;
					comboObject = Ext.getCmp('er_comptype');
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				if (reportType == 'Yes')
				{
					comboRawData = jsonData.measureCombo;
					selectedComboOption = jsonData.selectedMeasure;
					comboObject = Ext.getCmp('select_testmes');
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					comboObject.setValue(comboRawData[0].valueField);
					comboObject.show();
				} else {
					if (isSettingsEnabled)
					{
						Ext.getCmp('er_priority').hide();
					}
					Ext.getCmp('select_testmes').hide();
					Ext.getCmp('er_mode').hide();
				}
			}
		});
	},
	loadTools: function () {
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function () {
		if(!appConstants.hideBackButton){
			Ext.getCmp('zonereportform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		this.fillFormFields(appConstants.publicjsonData);
		this.refreshReportData();
	},
	refreshReportData: function () {
		if (appConstants.isSubmit == "true") {
			appConstants.initLdgMask.show();
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	updateQueryString: function () {
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString = '';
		var timelineParams;
		var timePeriodParams;
		var localjson=appConstants.publicjsonData;
		var reportGeneration,er_trenddata,er_excwe,er_priority,timefrom,minfrom,timeto,minto;

		if (!isSettingsEnabled)
		{
			reportGeneration=localjson.reportGeneration;
			er_trenddata=localjson.SelactedshowData;
			er_excwe=localjson.excludeWeek;
			er_priority=localjson.selectedPriority;
			timefrom=localjson.selectedTimeFrom;
			minfrom=localjson.selectedMinsFrom;
			timeto=localjson.selectedTimeTo;
			minto=localjson.selectedMinsTo;
		}
		else
		{
			reportGeneration= Ext.getCmp('reportGeneration').getValue();
			er_trenddata= Ext.getCmp('er_trenddata').getValue();
			er_excwe= Ext.getCmp('er_excwe').getValue();
			er_priority= Ext.getCmp('er_priority').getValue();
			timefrom= Ext.getCmp('timefrom').getValue();
			minfrom= Ext.getCmp('minfrom').getValue();
			timeto= Ext.getCmp('timeto').getValue();
			minto= Ext.getCmp('minto').getValue();
		}
		if ((minfrom == 'undefined' || minfrom == undefined) || (minfrom == null || minfrom == 'null'))
			minfrom='00';
		if ((minto == 'undefined' || minto == undefined) || (minto == null || minto == 'null'))
			minto='00';

		var reportType = Ext.getCmp('er_type').getValue();
		mainFormParams = "select_farm=" + Ext.getCmp('select_farm').getValue() + "&er_comptype=" + Ext.getCmp('er_comptype').getValue() + "&er_type=" + reportType + "&er_trenddata=" + er_trenddata + "&er_excwe=" +er_excwe + "&er_reportgenration=" +reportGeneration;
		if (reportType == 'Yes') {
			mainFormParams += "&select_testmes=" + Ext.getCmp('select_testmes').getValue() + "&er_priority=" + er_priority + "&er_mode=" + Ext.getCmp('er_mode').getValue() + "&opt=chart";
		} else {
			mainFormParams += "&er_sortby=-1&&opt=data"; // ommitting sort by combo beacause using  grid panel
		}
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" +timeto + "&minto=" + minto;
		if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			for (var hiddenField in hiddenFields) {
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		appConstants.queryString = mainFormParams + timelineParams + hiddenfieldQString + timperiodParams;
				appConstants.queryString += '&er_RmDispName='+appConstants.er_RmDispName;

	 },
	fillFormFields: function (jsonData) {
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted = "false";
		if (jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted = jsonData.isSubmit;
		var hiddenFields = jsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite= hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes")||(from_favourite != null && from_favourite == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var screenLabels = jsonData.screenLabels;
		comboRawData = jsonData.zoneCombo;
		selectedComboOption = jsonData.selectedZone;
		comboObject = Ext.getCmp('select_farm');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.compTypeCombo;
		selectedComboOption = jsonData.selectedcompType;
		comboObject = Ext.getCmp('er_comptype');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Component Type']);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.reportTypeCombo;
		selectedComboOption = jsonData.selectedreportType;
		comboObject = Ext.getCmp('er_type');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Report Type']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var selectedReporttype = jsonData.selectedreportType;
	   // if (selectedReporttype == 'Yes') 
		{
			comboRawData = jsonData.measureCombo;
			selectedComboOption = jsonData.selectedMeasure;
			comboObject = Ext.getCmp('select_testmes');
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Measure']);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			if (selectedReporttype == 'Yes') 
				comboObject.show();
			else
				comboObject.hide();
		} 
		if (selectedReporttype != 'Yes')  {
			Ext.getCmp('select_testmes').hide();
			if (isSettingsEnabled)
		{
			Ext.getCmp('er_priority').hide();
		}
			Ext.getCmp('er_mode').hide();
		}
		if (jsonData.SelactedshowData=='Yes')
		{
			isTrend=true;
		}
		var timelineRawData = jsonData.timelineCombo;
		var selectedTimeline = jsonData.selectedTimeline;
		var timelineObj = Ext.getCmp('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				timelineObj.setValue(selectedTimeline);
			} else {
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		updatingAppSettings();
	},
	loadSettings:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var reportType = Ext.getCmp('er_type').getValue();
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData=appConstants.publicjsonData;
		var screenLabels = jsonData.screenLabels;
		var comboRawData = jsonData.showDataCombo;
		var selectedComboOption = jsonData.SelactedshowData;
		var comboObject = Ext.getCmp('er_trenddata');
		comboObject.setFieldLabel(screenLabels['reporter.common.Show Data']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		if (comboObject.getValue()=='Yes')
		{
			isTrend=true;
		}
		var trendenalee=appConstants.publicjsonData.hiddenfields['trendenable'];
		if(trendenalee == 'false'){
			Ext.getCmp('er_trenddata').hide();
		}
		else
		{
			Ext.getCmp('er_trenddata').show();
		}
        comboRawData = jsonData.excludeWeekCombo;
        selectedComboOption = jsonData.excludeWeek;
        comboObject = Ext.getCmp('er_excwe');
        comboObject.setFieldLabel(screenLabels['reporter.consolidated.Exclude weekends']);
        comboObject.getStore().loadRawData(comboRawData);
        if (!Ext.isEmpty(selectedComboOption)) {
            comboObject.setValue(selectedComboOption);
        } else {
            comboObject.setValue(comboRawData[0].valueField);
        }
		if (reportType!=null && reportType!=undefined && reportType=="Yes")
		{
			comboRawData = jsonData.priorityCombo;
			selectedComboOption = jsonData.selectedPriority;
			comboObject = Ext.getCmp('er_priority');
			comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
		}
		else
		{
			Ext.getCmp('er_priority').hide();
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
		Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
		Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
		Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo = jsonData.reportGenerationCombo;
		var selreportGeneration = jsonData.reportGeneration;
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
	}
});
