Ext.define('CrashFaultApp.controller.CrashFaultAppController', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'EgComponentsGroup'],
	refs: [
		{
			selector: 'main',
			ref: 'main'
		},
		{
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{
			selector: 'egcomponentsGroup',
			ref: 'egcomponentsGroup'
		}, 
		{
			selector: 'crashFaultDetailsForm',
			ref: 'crashFaultDetailsForm'
		},
		{
			selector: 'crashFaultAppSettings',
			ref: 'crashFaultAppSettings'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
			selector: 'resultpanel',
			ref: 'resultpanel'
		},
		{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		},
		{
			selector: 'backGroundPanel',
			ref: 'backGroundPanel'
		},
		{
			selector: 'customtrigger',
			ref:'customtrigger'
		}
	],
	init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click': this.modifyScheduleFavorite
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'mainform button[id="appExpandSelector"]':
			{
				'click': this.appExpandMe
			},
			'crashFaultDetailsForm combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'crashFaultDetailsForm combo[id="er_site"]':
			{
				'select': this.onSelectSiteBy
			},
			'crashFaultDetailsForm combo[id="er_compType"]':
			{
				'select': this.onSelectComponentType
			},
			'egcomponentsGroup multiselectfield[name="er_CompGrp"]':
			{
				//'change': this.ComponentOnChange
			},
			'mainform trigger[id="compGroupSearch"]':
			{
				'change': this.compMultiselect
			},
			'mainform trigger[id="appGroupSearch"]':
			{
				'change': this.appMultiselect
			},
			'crashFaultAppSettings':
			{
				'afterrender': this.closeSetting
			},
			'crashFaultAppSettings combo[name="reportGeneration"]':
			{
				'select': this.reportGenChange
			},
			'crashFaultAppSettings button[id="moreOptionCloseId"]':
			{
				'click': this.validateAndCloseSettings
			},
			'crashFaultAppSettings button[id="submitViaSetting"]':
			{
				'click': this.closeSettingAndSubmit
			},
		  /* 'crashFaultAppSettings combo[id="er_excwe"]': {
				'select': this.excludeWeekendsChange
			},*/
	       'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	loadTools: function() 
	{
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function()
	{
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData = appConstants.defaultLoadData;
		this.setErOptionData(jData);
		var analysisBy = Ext.getCmp('er_option');
		var er_site=Ext.getCmp('er_site');
		var er_subZone=Ext.getCmp('er_subZone');
		if(analysisBy != undefined && analysisBy.getValue() != undefined && analysisBy.getValue() != 'Component' && analysisBy.getValue() != '-1')
		{				
			this.setSiteOptionData(jData);
			er_site.show();
			er_subZone.show();
		}
		else
		{
			er_site.hide();
			er_subZone.hide();
		}
		this.setComponentTypeData(jData);
		this.setApplicationData(jData);
		this.setComponentData(jData);
		var erTimeline = Ext.getCmp('er_timeline');
		erTimeline.getStore().loadRawData(jData['timelineCombo']);
		erTimeline.setValue(jData['selectedTimeline']);
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray = jData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray = jData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		mgr_stmin=appConstants.defaultLoadData.startmin;
		mgr_enmin=appConstants.defaultLoadData.endmin;
		Ext.getCmp('crashFaultDetailsForm').add({
			xtype: 'hidden',
			id: 'ID',
			name: 'ID',
			value: jData['ID']
		});
	},
	expandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_Component'), Ext.getCmp('compLbl').text, btn);
	},
	appExpandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_application'), Ext.getCmp('appLbl').text, btn);
	},
	setSiteOptionData:function(jData)
	{
		var siteBy = Ext.getCmp('er_site');
		var er_subZone = Ext.getCmp('er_subZone');
		if(jData.subZoneCombo != undefined)
		{
			var analysisBy = Ext.getCmp('er_option');
			//siteBy.setFieldLabel(analysisBy.getValue());
			siteBy.setFieldLabel(jData.screenLabels['reporter.common.site']);
			siteBy.getStore().loadRawData(jData['siteCombo']);
			siteBy.setValue(jData.selectedField['selectedSiteCombo']);
			var er_subZone=Ext.getCmp('er_subZone');
			er_subZone.setFieldLabel(jData.screenLabels['reporter.common.Sub Zone']);
			er_subZone.getStore().loadRawData(jData['subZoneCombo']);
			er_subZone.setValue(jData.selectedField['selectedSubZone']);
			siteBy.show();
			er_subZone.show();
		}
		else
		{
			siteBy.hide();
			er_subZone.hide();
		}
	},
	setErOptionData: function(jData)
	{ 
		var analysisBy = Ext.getCmp('er_option');
		analysisBy.setFieldLabel(jData.screenLabels['reporter.common.analysisBy']);
		analysisBy.getStore().loadRawData(jData['analysisBy']);
		if(jData.selectedField != undefined && jData.selectedField['selectedAnalysisBy'] != undefined)
		{
			analysisBy.setValue(jData.selectedField['selectedAnalysisBy']);
		}
		else
		{
			var analysisByData=jData['analysisBy'];
			if(analysisByData != undefined && analysisByData.length > 0)
			{
				analysisBy.setValue(analysisByData[0].valueField);
			}
		}
	},
	setComponentTypeData:function(jData)
	{
		var er_componentType=Ext.getCmp('er_compType');
		er_componentType.setFieldLabel(jData.screenLabels['reporter.common.Component Type']);
		er_componentType.getStore().loadRawData(jData['compTypeCombo']);
		if(jData.selectedField != undefined && jData.selectedField['selectedComponentTypes'] != undefined)
		{
			er_componentType.setValue(jData.selectedField['selectedComponentTypes']);
		}
		else
		{
			var compTypeCombo=jData['compTypeCombo'];
			if(compTypeCombo != undefined && compTypeCombo.length > 0)
			{
				er_componentType.setValue(compTypeCombo[0].valueField);
			}
		}		
	},
	setApplicationData:function(jData)
	{
		var er_application=Ext.getCmp('er_application');
		var appLbl = Ext.getCmp('appLbl');
		appLbl.setText(jData.screenLabels['reporter.common.Applications']);
		er_application.getStore().loadRawData(jData['applicationCombo']);
		if(jData.selectedField != undefined && jData.selectedField['selectedApplication'] != undefined && jData.selectedField['selectedApplication'].length > 0)
		{
			er_application.setValue(jData.selectedField['selectedApplication']);
		}
		else
		{
			var applicationCombo=jData['applicationCombo'];
			if(applicationCombo != undefined && applicationCombo.length > 0)
			{
				er_application.setValue(applicationCombo[0].valueField);
			}
		}
	},
	setComponentData:function(jData)
	{
		var er_Component=Ext.getCmp('er_Component');
		var compLbl = Ext.getCmp('compLbl');
		compLbl.setText(jData.screenLabels['reporter.common.Components']);
		er_Component.getStore().clearFilter(true);
		er_Component.getStore().loadRawData(jData['componentCombo']);
		if(!Ext.isEmpty(jData.selectedField['selectedComponents']) && jData.selectedField['selectedComponents'] != undefined)
		{
			er_Component.setValue(jData.selectedField['selectedComponents']);
		}
		else
		{
			er_Component.setValue(jData['componentCombo'][0].valueField);
		}
	},		
	onSelectAnalysisBy: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var reportBy = 'analysisBy=' + thisVal;
		reportBy += '&supportedComponents='+appConstants.supportedComponents;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCrashFaultJSON.jsp',
			scope: this,
			method: 'POST',
			params: reportBy,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				if(thisVal != 'Component')
				{
					formObj.setSiteOptionData(jsonData);
					Ext.getCmp('er_site').show();
					Ext.getCmp('er_subZone').show();
				}
				else
				{
					Ext.getCmp('er_site').hide();
					Ext.getCmp('er_subZone').hide();
				}
				formObj.setComponentTypeData(jsonData);
				formObj.setApplicationData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectSiteBy: function(obj)
	{
		var thisVal=Ext.getCmp('er_site').getValue();
		var paramsObj='analysisBy='+Ext.getCmp('er_option').getValue()+"&er_site="+thisVal+"&er_subZone="+Ext.getCmp('er_subZone').getValue();
		paramsObj += '&supportedComponents='+appConstants.supportedComponents;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCrashFaultJSON.jsp',
			scope: this,
			method: 'POST',
			params: paramsObj,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentTypeData(jsonData);
				formObj.setApplicationData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectComponentType: function()
	{
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_application=Ext.getCmp('er_application').getValue();
		var params='&analysisBy='+er_option;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		params += '&supportedComponents='+appConstants.supportedComponents;
		for(var c=0;c<er_application.length;c++)
		{
			params += "&er_application="+ er_application[c];
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErCrashFaultJSON.jsp',
			scope:this,
			method: 'POST',
			params: params,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
		

	},
	ComponentOnChange: function(obj, newValue, oldValue, eOpts)
	{
		var er_option = Ext.getCmp('er_option').getValue();
		if(er_option != undefined && er_option == 'Aggregate')
		{
			return;
		}
		if (newValue.length > 1 && (newValue.indexOf('All') > -1 || newValue.indexOf("all") > -1))
		{
			this.showMessage('Chosen components group not allowed');
			return;
		}
		if (Ext.isEmpty(oldValue) || oldValue == undefined) 
		{
			return false;
		}
		var er_type = Ext.getCmp('er_type').getValue();		
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_CompGrp = Ext.getCmp('er_CompGrp').getValue();
		var params='reportType='+er_type+'&analysisBy='+er_option;
		params += "&er_compType=all";
		for(var c=0;c<er_CompGrp.length;c++)
		{
			params += "&selectedGroups="+er_CompGrp[c];
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErCrashFaultJSON.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				formObj.setComponentTypeData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	saveReportAsPDF: function() 
	{
		//var qryString = "../reporter/ErHtmlToSavePdf.jsp?pageWidthProces=1024&pageWidth=1024";
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.defaultLoadData;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.getQueryString();
		bookletquery+="&er_rtype=ApplicationCrashFault&er_trgttype=&er_ViewName=ErCrashFault.jsp&er_RmDispName=ApplicationCrashFault";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	
	printReport: function() 
	{
		var s_qryString = "/final/reporter/ErCrashFaultPrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate;
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{
		window.location = '../servlet/com.eg.ErCrashFaultReportC?er_view=CSV';
	},
	saveSchedule: function(obj)
	{
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype=ApplicationCrashFault&er_trgttype=&er_ViewName=ErCrashFault.jsp&er_RmDispName=ApplicationCrashFault&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.scheduleWindowFn(qryString);
	},
	saveFavorite: function()
	{
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=&er_rtype=ApplicationCrashFault&er_ViewName=ErCrashFault.jsp&er_RmDispName=ApplicationCrashFault&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		} */
		parent.favouriteWindowFn(target);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype=&er_rtype=ApplicationCrashFault&er_ViewName=ErCrashFault.jsp&er_RmDispName=ApplicationCrashFault&fromFavoriteModify=Yes&cmd=client'
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=ApplicationCrashFault';
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: qryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	compMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_Component'), appConstants.defaultLoadData['componentCombo']);
	},
	appMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_application'), appConstants.defaultLoadData['applicationCombo']);
	},
	submitReport: function(qryStr)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if(!isSettingsEnabled)
			this.showConfigDropdown();//..
		var params ='';
		
		if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
		{
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			stDate.setHours(startHr);
			enDate.setHours(endHr);          
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			params += '&servletName=ErCrashFaultReportC&er_rtype=ApplicationCrashFault&er_ViewName=ErCrashFault.jsp&er_RmDispName=ApplicationCrashFault';
			params += '&er_trgttype=&forwardto=ApplicationCrashFault&er_bgreportfrom=ApplicationCrashFault&bgenabled=Yes&savereport=save';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
					
			}
			appConstants.LoadingMask.show();
			this.getNomeasurepanel().hide();
			Ext.Ajax.request({
				url: bgUrl,
				scope: this,
				method: 'POST',
				params: params,
				success: function(response)
				{
					var resultObj = Ext.getCmp('backGroundPanel');
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
					if ( status == 'success' )
					{
						//htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';

					}
					else if ( status == 'duplicate' )
					{
						//htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}
			});
		}
	},
	getFocusToGrid:function()
	{
		Ext.getCmp('grid0').focus();
	},
	submitReportByAjaxCall:function(params)
	{
		appConstants.LoadingMask.show();
		params += '&er_view=submit';
		var me=this;
		var url='/final/servlet/com.eg.ErCrashFaultReportC';
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');
				resultPanelObj.removeAll();		
				var jsonObject=response.responseText;
				var jsonData=Ext.decode(jsonObject);
				
				resultPanelObj.show();
			
				if(jsonData.isData != undefined && jsonData.isData)
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);	
					
					var crashHangDigitalCollection=jsonData.crashHangDigitalCollection;
				/*	var donutHtml = '<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" style="border-collapse:collapse;"><tr><td id="donuts_id" width="50%"></td><td width="50%"><table cellpadding="0" cellspacing="0" border="0" style="margin:5px;"><tr></tr><tr><td><div style="background-color:'+jsonData.crashColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Number of Crashes</td><td class="font_normal11">'+jsonData.totalCrash+'</td></tr><tr><td><div style="background-color:'+jsonData.hangColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Number of Hangs</td><td class="font_normal11">'+jsonData.totalHang+'</td></tr></table></td></tr></table>';
					var digitalAllFailArry=new Array();
					for(var k in crashHangDigitalCollection)
					{
						var eachCol=crashHangDigitalCollection[k];
						var dispUnit=eachCol.unit==undefined?"":eachCol.unit;
						digitalAllFailArry.push({
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'100%',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
								//padding:'10px 10px 10px 10px',
							},
							items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+eachCol.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+eachCol.value+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">'+eachCol.displayName+dispUnit+'</span>'
									}]
						});
					}
					
					digitalAllFailArry.push(
					{
						xtype:'container',
						align:'center',
						flex:.34,
						autoSize: true,
						layout: {
							type: 'table',
							rows:1,
							columns:1,
							align:'center',
							tableAttrs: {
								style: {
									'text-align':'center',
									'width':'100%',
								}
							},
						},
						items: [
						{
							html: donutHtml,
						}]
					});
					
					resultPanelObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						margin:'10 10 0 10',
						title:'Overview ',
						//title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">Overview</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
						bodyPadding: '0 0 4 0',
						padding:0,
						layout:{
							type:'hbox',
							align:'center'
						},
						defaults:{
							flex:.22,
						},
						items:digitalAllFailArry,
					});*/
					//..dummy
					var digitalAllFailArry=new Array();
					var donutHtml = '<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" style="border-collapse:collapse;"><tr><td id="donuts_id" width="40%"></td><td width="60%"><table cellpadding="0" cellspacing="0" border="0" style="margin:5px;"><tr></tr><tr><td><div style="background-color:'+jsonData.crashColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Number of Crashes</td><td class="font_normal11">'+jsonData.totalCrash+'</td></tr><tr><td><div style="background-color:'+jsonData.hangColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Number of Hangs</td><td class="font_normal11">'+jsonData.totalHang+'</td></tr></table></td></tr></table>';
					var eachCol=crashHangDigitalCollection[2];
					var dispUnit=eachCol.unit==undefined?"":eachCol.unit;
					digitalAllFailArry.push({
						xtype:'container',
						autoSize: true,
						align:'stretch',
						cls:'mouseOverHighlight',
						//height:'100%',
						margin:'5 10 10 10',
						bodyPadding: '0 0 4 0',
						padding:0,
						layout:{
							type:'vbox',
							align:'center',
							pack:'center'
						},
						defaults: {
							padding:'6px 5px 5px 5px',
							//padding:'10px 10px 10px 10px',
						},
						items: [{
									xtype:'container',
									html: '<table align="center" style="cursor:pointer" onclick="javascript:getFocusToGrid()"><tr><td align="right" style="padding-right:5px"><div class="'+eachCol.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+eachCol.value+'</td></tr></table>',
									width:'100%',
									style: {
										textAlign:'center',
										width:'50px'
									}
								},
								{
									html:'<span class="newFont_normal13">'+eachCol.displayName+dispUnit+'</span>'
								}]
					});
					
					for(var k in crashHangDigitalCollection)
					{
						if(k==2)
							continue;
						var eachCol=crashHangDigitalCollection[k];
						var dispUnit=eachCol.unit==undefined?"":eachCol.unit;
						digitalAllFailArry.push({
							xtype:'container',
							autoSize: true,
							align:'stretch',
						//	height:'100%',
							margin:'5 10 10 10',
							bodyPadding: '0 0 4 0',
							padding:0,
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
								//padding:'10px 10px 10px 10px',
							},
							items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+eachCol.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+eachCol.value+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">'+eachCol.displayName+dispUnit+'</span>'
									}]
						});
					}
					digitalAllFailArry.push(
					{
						xtype:'container',
						align:'center',
						flex:.34,
						margin:'-5 10 10 10',
						bodyPadding: '0 0 4 0',
						padding:0,
						autoSize: true,
						layout: {
							type: 'table',
							rows:1,
							columns:1,
							align:'center',
							tableAttrs: {
								style: {
									'text-align':'center',
									'width':'100%',
								}
							},
						},
						items: [
						{
							html: donutHtml,
						}]
					});
					
					resultPanelObj.add({
						xtype:'panel',
						ui:'newGraphPanel',
						//margin:'10 10 0 10',
						title:'Overview ',
						//title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14">Overview</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRenameWidget+'"></td></tr></table>',
						margin:'5 10 10 10',
						bodyPadding: '0 0 4 0',
						padding:0,
						layout:{
							type:'hbox',
							align:'center'
						},
						defaults:{
							flex:.22,
						},
						items:digitalAllFailArry,
					});

					//..
					if(!Ext.isEmpty(jsonData.donutChartCrashHang) && jsonData.donutChartCrashHang!=undefined)
					{
						var donutGraphs = {};
						donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('donuts_id',150,150), donutGraphs);
						donutGraphs.setData(jsonData.donutChartCrashHang,'','');
						donutGraphs.drawChart(); 
					}
					//var topNApplicationByFail='';
					var topNApplicationByFail='<div id="topNApplByFail" style="height:300px;width:450px !important;overflow:auto;padding:0px"></div>';
					var topNServerByFail='<div id="topNSerByFail" style="height:300px;width:450px !important;overflow:auto;padding:0px"></div>';					
					var topNAppContainer = Ext.create('Ext.container.Container', {	
						layout :'column',
						//margin:'5 2 10 10',
						margin:'10 10 10 10',
						items:[{
							xtype:'panel',
							margin:'0 10 0 0',			
							columnWidth:0.5,	
							ui:'newGraphPanel',
							title:'Top 10 Applications With Most Number Of Failures',
							html: topNApplicationByFail,
						},	
						{
							xtype:'panel',		
							columnWidth:0.5,
							ui:'newGraphPanel',
							title:'Top 10 Servers With Most Number Of Failures',
							html: topNServerByFail
						},
						]
					});
					resultPanelObj.add(topNAppContainer);
					var topNAppSBar = {};
					topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('topNApplByFail',260,170), topNAppSBar);
					topNAppSBar.setData(jsonData.topNApplication,'<%=currentDateFormat%>','');
					topNAppSBar.drawChart();
					var topNAppSBar = {};
					topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('topNSerByFail',260,170), topNAppSBar);
					topNAppSBar.setData(jsonData.topNServer,'<%=currentDateFormat%>','');
					topNAppSBar.drawChart();

					//..appliacation crash time column chart
					var applCrashContent='<div id="applCrashTimeId" style="height:300px;width:97% !important;overflowY:hidden;padding:0px"></div>'; 
					resultPanelObj.add({
						xtype:'panel',
						//margin:'5 2 10 10',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						title:'Application Crashes/ Hangs Trend',
						html:applCrashContent
					});
					var topNAppSBar = {};
					topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('applCrashTimeId',300,300), topNAppSBar);
					topNAppSBar.setData(jsonData.applicationCrashTime,'<%=currentDateFormat%>','');
					topNAppSBar.drawChart();
					//..detail data grid
					var appExpandDetail = '';
					var appDetailData='';
					if(jsonData['expandFoundInfo']!=''){
						appExpandDetail=[{
								ptype: 'rowexpander',
								selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
								expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
								expandOnEnter : false,
								collapsible: true,
								animCollapse: false,
								rowBodyTpl: ['<div style="padding:10px 20px 10px 10px;" >{detailData}</div>']
							}];
						var headings = new Array();
						if (!Ext.isEmpty(jsonData.heading) && jsonData.heading!=undefined)
						{
							var s=0;
							for(var key in jsonData.heading)
							{
								headings[s] = key;
								s++;
							}
						}
						var colm = new Array();
						for(var keys in jsonData.heading)
						{
							colm.push({
								header: jsonData.heading[keys],
								sortable: true,
								dataIndex: keys,
								align:keys=='appName'?'left':'center',
								width:keys=='appName'?300:100,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									//value=me.getNumberFormat(value.toString());
									return value;
								}
							});
						}
						var activePage=1;
						var gridPageSize=15;
						var isPagingHiddenDetailApp=false;
						if (jsonData.applicationDetailData.length<gridPageSize)
							isPagingHiddenDetailApp = true;
						else
							isPagingHiddenDetailApp = false;
						headings[s] = 'detailData';
						var store = Ext.create('Ext.data.Store', {
							fields: headings,
							data: jsonData.applicationDetailData,
							pageSize:gridPageSize,
							autoLoad : true,
							sortable: true,
							proxy : {
							  type : 'pagingmemory'
							}
						});
						var me=this;
						appDetailData=Ext.create('Ext.panel.Panel',{
							title : 'Application Failure Details',
							ui:'newGraphPanel',
							//margin:'0 2 10 0',
							margin:'10 10 10 10',
							items:[
								{
									xtype:'customgrid',
									sortableColumns: true,
									ui:'newGridPanel',
									id:'grid0',
									margin:'0 10 10 10',
									border:true,
									scroll: true,
									autoScroll:true,
									forceFit:true,
									sortableColumns: true,		
									store: store,
									columns: colm,
									plugins: appExpandDetail,
									viewConfig:
									{
										stripeRows: true,
										getRowClass: function (record, rowIndex, rowParams, store)
										{
											if (record.raw.detailData =='')
											{
												return 'hidePlus';
											}
											else
											{
												return;
											}
										},
										listeners: 
										{
											sortchange:function(ct, column, e, t, eOpts ){
												this.getStore().loadPage(activePage);
											}
										}
									},
									dockedItems:[{
										xtype:'pagingtoolbar',
										cls:'newPagination',
										dock: 'bottom',
										displayInfo: true,
										store: store,
										hidden:isPagingHiddenDetailApp,
										displayInfo: true,
										displayMsg: 'Displaying topics {0} - {1} of {2}',
										emptyMsg: "No topics to display",
										listeners: {
											change : function(thisd, params)
											{   
												if(!Ext.isEmpty(params))
													activePage = params.currentPage;
												else
													activePage=1;
											}
										}
									}]
								}
							]
						});
					}
					else
					{
						appDetailData = Ext.create('Ext.panel.Panel', {
							ui:'newGraphPanel',
							title : 'Application Crash Details',
							html:"<div align='center' style=\"height:250px;\"><img style='margin-top:50px;' src='/final/images/Light/nomeasures_custom.png' /></div>"
						});
					}
					resultPanelObj.add(appDetailData);
					this.getNomeasurepanel().hide();
				}
				else
				{				
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();			
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
				appConstants.LoadingMask.hide();			
			}
		});
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},	
	/*excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },	*/
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		//var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:563,
				margin: 0,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'353px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype : 'crashFaultAppSettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 

		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.setFieldLabel(appConstants.defaultLoadData.screenLabels['reporter.common.ExcludeWeekend']);
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 

		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var me = this;
		Ext.get('closeSettings').on('click', function() {
		if(me.validateSettings())
		{
			me.validateAndCloseSettings();
		}
		});
	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({
				duration: 500,
				to: 
				{
					y: -500
				}
			 });	
			return true;
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	validateSettings :function(){
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}		
		return true;
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_Component = Ext.getCmp('er_Component').getValue();
		if(er_Component[0] == '-1')
		{
			this.showMessage('Components is Not Applicable');
			return false;
		}
		if (er_Component.length > 1 && (er_Component.indexOf('All') > -1 || er_Component.indexOf('all') > -1))
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		var params='&analysisBy='+er_option;
		if(er_option != undefined && er_option != 'Component')
		{
			params += '&er_site='+Ext.getCmp('er_site').getValue();
			params += '&er_subZone='+Ext.getCmp('er_subZone').getValue();
		}
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		var er_application=Ext.getCmp('er_application').getValue();
		for(var c=0;c<er_application.length;c++)
		{
			params += "&er_application="+ er_application[c];
		}
		for(var c=0;c<er_Component.length;c++)
		{
			params += "&er_Component="+er_Component[c];
		}
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue()
		startDate.setHours(startHr);
		endDate.setHours(endHr); 
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		//var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+appConstants.defaultLoadData.startmin+'&endmin='+appConstants.defaultLoadData.endmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
			}
			params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
			params2+= '&er_reportgenration='+rGenType+'&bg_reportname='+reportName;

		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		params += params1;
		params += params2;
		params += userID;
		params += '&supportedComponents='+appConstants.supportedComponents;
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title: 'Application Crash/Fault Report',
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});