Ext.define("CtxLogonSimulator.controller.CtxLogonSimulator", {
	extend: "Ext.app.Controller",
	gridColStateParam:'ASC',
	gridColIndexParam:-1,
	views: ["Main"],
	refs: [{
			selector: "main",
			ref: "main"
		}, {
			selector: "newUtilities",
			ref: "newUtilities"
		},
		{
			selector: 'thinclientapplicationform',
			ref: 'thinclientapplicationform'
		},
		{
		  selector: 'egcomponent',
		  ref: 'egcomponent'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
		  selector: 'thinclientapplicationsettings',
		  ref: 'thinclientapplicationsettings'
		},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'} ],
	init: function() {
		this.control({
			"main": {
				"boxready": this.afterMainRender
			},
			"mainform": {
				"afterrender": this.loadFormElements
			},
			"thinclientapplicationsettings": {
				"afterrender": this.loadSettingsElements
			},
			"newUtilities": {
				"afterrender": this.loadTools
			},
			"newUtilities > #printTool > button": {
				"click": this.printReport
			},
			"newUtilities > #saveTool > button": {
				"click": this.saveReportAsPDF
			},
			"newUtilities > #mailTool > button": {
				"click": this.sendMail
			},
			"newUtilities > #favoriteTool > button": {
				"click": this.saveFavorite
			},
			"newUtilities > #scheduleTool > button": {
				"click": this.saveSchedule
			},
			'timeline combo[name="er_mode"]':
			{
			 'select': this.changeEr_mode
			},
			'mainform combo[name="select_farm"]': {
				"select": this.zoneOnChange
			},
			'mainform button[id="expandAppln"]': {
				"click": this.expandAppln
			}, 
			'mainform combo[name="er_applicationX"]': {
				"select": this.appOnChange
			},
			'mainform combo[name="er_location"]': {
				"select": this.locationOnChange
			},
			'mainform combo[name="er_compType"]': {
				"select": this.compTypeOnChange
			},
			'thinclientapplicationsettings combo[name="er_excwe"]': {
				"select": this.weekendOnChange
			},
			'thinclientapplicationsettings combo[name="reportGeneration"]': {
				"select": this.reportGenChange
			},	
			'thinclientapplicationsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'thinclientapplicationsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'mainform button[name="submit"]': {
				"click": this.showResult
			},
			'mainform button[name="save"]': {
				"click": this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'mainform button[id="expandSelectorActivity"]': {
				"click": this.expandMeActivity
			},
			'mainform button[id="expandSelectorUsage"]': {
				"click": this.expandMeUsage
			},
			'mainform trigger[id="compSearch"]':
			{
			'change': this.filterMultiselect
			},
			'mainform trigger[id="appSearch"]':
			{
			'change': this.filterMultiselect
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.er_siteOnChange
			}
		});
	},
	appOnChange:function(){
			var er_option=Ext.getCmp('er_option').getValue();
			var er_zone=Ext.getCmp('select_farm').getValue();
			var er_compType=Ext.getCmp('er_compType').getValue();
			var er_applicationX=Ext.getCmp('er_applicationX').getValue();
			var params='&er_option='+er_option+'&er_zone='+er_zone+"&er_compType="+er_compType+"&er_applicationX="+encodeURIComponent(er_applicationX)+"&er_trgttype="+targetType;
			var urlstr='';
			urlstr = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
			Ext.Ajax.request({
			url: urlstr,
			params: params,
			success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				if (er_applicationX!=undefined && er_applicationX!='All')
				{
					if (isSettingsEnabled)
					{
						Ext.getCmp('lowLimitLbl').hide();
						Ext.getCmp('lowLimitLbl_enum').hide();
						Ext.getCmp('lowLimitLbl_appl').hide();
						Ext.getCmp('logonStatusSepId').hide();
					}
				}
				else
				{
					if (isSettingsEnabled)
					{
						Ext.getCmp('lowLimitLbl').show();
						Ext.getCmp('lowLimitLbl_enum').show();
						Ext.getCmp('lowLimitLbl_appl').show();
						Ext.getCmp('logonStatusSepId').show();
						if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
						if(!Ext.isEmpty(jsonData.minorValue))
							Ext.getCmp('upperminor').setValue(jsonData.minorValue);
						if(!Ext.isEmpty(jsonData.criticalValue))
							Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
						if(!Ext.isEmpty(jsonData.uppermajor_enum))
							Ext.getCmp('uppermajor_enum').setValue(jsonData.uppermajor_enum);
						if(!Ext.isEmpty(jsonData.upperminor_enum))
							Ext.getCmp('upperminor_enum').setValue(jsonData.upperminor_enum);
						if(!Ext.isEmpty(jsonData.upperCritical_enum))
							Ext.getCmp('upperCritical_enum').setValue(jsonData.upperCritical_enum);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
						if(!Ext.isEmpty(jsonData.uppermajor_appl))
							Ext.getCmp('uppermajor_appl').setValue(jsonData.uppermajor_appl);
						if(!Ext.isEmpty(jsonData.upperminor_appl))
							Ext.getCmp('upperminor_appl').setValue(jsonData.upperminor_appl);
						if(!Ext.isEmpty(jsonData.upperCritical_appl))
							Ext.getCmp('upperCritical_appl').setValue(jsonData.upperCritical_appl);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
					}
				}
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
			}
		 });
	},
	locationOnChange:function(){
			var er_option=Ext.getCmp('er_option').getValue();
			var er_zone=Ext.getCmp('select_farm').getValue();
			var er_compType=Ext.getCmp('er_compType').getValue();
			var er_location=Ext.getCmp('er_location').getValue();
			var params='&er_option='+er_option+'&er_zone='+er_zone+"&er_compType="+er_compType+"&er_location="+er_location+"&er_trgttype="+targetType;
			var urlstr='';
			urlstr = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
			Ext.Ajax.request({
			url: urlstr,
			params: params,
			success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				if (er_location!=undefined && er_location!='all')
				{
					if (isSettingsEnabled)
					{
						Ext.getCmp('lowLimitLbl').hide();
						Ext.getCmp('lowLimitLbl_enum').hide();
						Ext.getCmp('lowLimitLbl_appl').hide();
						Ext.getCmp('logonStatusSepId').hide();
					}
				}
				else
				{
					if (isSettingsEnabled)
					{
						Ext.getCmp('lowLimitLbl').show();
						Ext.getCmp('lowLimitLbl_enum').show();
						Ext.getCmp('lowLimitLbl_appl').show();
						Ext.getCmp('logonStatusSepId').show();
						if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
						if(!Ext.isEmpty(jsonData.minorValue))
							Ext.getCmp('upperminor').setValue(jsonData.minorValue);
						if(!Ext.isEmpty(jsonData.criticalValue))
							Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
						if(!Ext.isEmpty(jsonData.uppermajor_enum))
							Ext.getCmp('uppermajor_enum').setValue(jsonData.uppermajor_enum);
						if(!Ext.isEmpty(jsonData.upperminor_enum))
							Ext.getCmp('upperminor_enum').setValue(jsonData.upperminor_enum);
						if(!Ext.isEmpty(jsonData.upperCritical_enum))
							Ext.getCmp('upperCritical_enum').setValue(jsonData.upperCritical_enum);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
						if(!Ext.isEmpty(jsonData.uppermajor_appl))
							Ext.getCmp('uppermajor_appl').setValue(jsonData.uppermajor_appl);
						if(!Ext.isEmpty(jsonData.upperminor_appl))
							Ext.getCmp('upperminor_appl').setValue(jsonData.upperminor_appl);
						if(!Ext.isEmpty(jsonData.upperCritical_appl))
							Ext.getCmp('upperCritical_appl').setValue(jsonData.upperCritical_appl);
						if(!Ext.isEmpty(jsonData.criticalColor))
							Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
						if(!Ext.isEmpty(jsonData.majorColor))
							Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
						if(!Ext.isEmpty(jsonData.minorColor))
							Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
					}
				}
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
			}
		 });
	},
	onSelectAnalysisBy: function (obj) {
		var er_option=obj.getValue();
		var params='er_option='+er_option;
		var urlstr='';
		urlstr = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
		 Ext.Ajax.request({
			url: urlstr,
			params: params,
			success: function(response) {
				var jsonData=Ext.decode(response.responseText);
				var component;
				if (er_option=='Zone')
				{
					Ext.getCmp('er_site').hide();
					component=Ext.getCmp('select_farm');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.zoneCombo);
					component.setValue(jsonData.selectedZone);
					component.show();
				}
				else if (er_option=='Component') 
				{
					Ext.getCmp('select_farm').hide();
					Ext.getCmp('er_site').hide();
				}
				else 
				{
					Ext.getCmp('select_farm').hide();
					component=Ext.getCmp('er_site');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.siteCombo);
					component.setFieldLabel(jsonData.siteComboLabel);
					component.setValue(jsonData.selectedSiteCombo);
					component.show();
				}
				component=Ext.getCmp('er_compType');
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.compTypeCombo);
				component.setValue(jsonData.compTypeCombo[0].valueField);
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				if(targetType == 'applicationBased')
				{
					Ext.getCmp('er_location').hide();
					var selectedApp = jsonData.selectedAppln;
					component=Ext.getCmp('er_applicationX');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.applnCombo);
					if (!Ext.isEmpty(selectedApp) && selectedApp!=undefined)
					{
						component.setValue(selectedApp);
					} 
					else if(!Ext.isEmpty(jsonData.applnCombo))
					{
						component.setValue(jsonData.applnCombo[0].valueField);
					}
					else
					{
						component.setValue("-1");
					}
				}
				else
				{
					var selectedLoc = jsonData.locationselectOptions.selectedLocationsType;
					Ext.getCmp('er_applicationX').hide();
					component=Ext.getCmp('er_location');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.locationCmbo);
					if (!Ext.isEmpty(selectedLoc) && selectedLoc!=undefined)
					{
						component.setValue(selectedLoc);
					} 
					else if(!Ext.isEmpty(jsonData.locationCmbo))
					{
						component.setValue(jsonData.locationCmbo[0].valueField);
					}
					else
					{
						component.setValue("-1");
					}
				}
			}
		 });
	},
	er_siteOnChange: function (obj) {
		var er_site=obj.getValue();
		var params;
		var urlstr='';
		urlstr = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
		params='er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+encodeURIComponent(er_site);
		 Ext.Ajax.request({
			url: urlstr,
			params: params,
			method: "GET",
			success: function(response) {
				var component;
				var jsonData=Ext.decode(response.responseText);
				component=Ext.getCmp('er_compType');
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.compTypeCombo);
				component.setValue(jsonData.selectedCompType);
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				if(targetType == 'applicationBased')
				{
					Ext.getCmp('er_location').hide();
					component=Ext.getCmp('er_applicationX');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.applnCombo);
					component.setValue(jsonData.selectedAppln);
				}
				else
				{
					Ext.getCmp('er_applicationX').hide();
					component=Ext.getCmp('er_location');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.locationCmbo);
					component.setValue(jsonData.locationselectOptions.selectedLocationsType);
				}
			}
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		var compId = obj.getId();
		if(compId=='compSearch')
		{
			compStore = appConstants.rawDataForComponents;
			compName='er_server';
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	changeEr_mode: function (combo) {
		var from_schModify='';
		var favorite_id='';
		favorite_id=appConstants.publicjsonDataUsage['hiddenfields']["favorite_id"];
		from_schModify=appConstants.publicjsonDataUsage['hiddenfields']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		Ext.get('configMod').animate({
			duration: 250,
			to: {
				y: -530
			}
		});
		this.showResult();
	 },
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  '';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("printPageIdentify",appConstants.printPageIdentify);
		hiddenFields=appConstants.publicjsonDataUsage['hiddenfields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule();
		}else{
			this.saveFavorite();
		}
	},
	compTypeOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		var url;
		var er_option=Ext.getCmp('er_option').getValue();
		var params='&er_trgttype='+targetType+'&er_option='+er_option+'&er_compType='+Ext.getCmp('er_compType').getValue()+'&fromComponentChange=yes';
		var mainForm =Ext.getCmp('mainform').getForm();
		var zoneval=mainForm.findField("select_farm").getValue();
		if (er_option=='Zone')
		{
			params+="&er_zone="+encodeURIComponent(zoneval);
		}
		else
		{
			params+="&er_site="+encodeURIComponent(Ext.getCmp("er_site").getValue());
		}
		url = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
		Ext.Ajax.request({
			url: url,
			params: params,
			scope: this,
			method: "GET",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				comboRawData = appConstants.publicjsonDataUsage.componentCombo;
				selectedComboOption = appConstants.publicjsonDataUsage.selectedComponents;
				comboObject = Ext.getCmp("er_server");
				appConstants.rawDataForComponents = comboRawData;
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboObject.resumeEvents();
				if(targetType == 'applicationBased')
				{
					comboRawData = appConstants.publicjsonDataUsage.applnCombo;
					selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
					comboObject = mainForm.findField("er_applicationX");
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
					var er_applicationX = Ext.getCmp("er_applicationX").getValue();
					if(er_applicationX!=undefined && er_applicationX!='All')
					{
						if (isSettingsEnabled)
						{
							Ext.getCmp('lowLimitLbl').hide();
							Ext.getCmp('lowLimitLbl_enum').hide();
							Ext.getCmp('lowLimitLbl_appl').hide();
							Ext.getCmp('logonStatusSepId').hide();
						}
					}
					else
					{
						if (isSettingsEnabled)
						{
							Ext.getCmp('lowLimitLbl').show();
							Ext.getCmp('lowLimitLbl_enum').show();
							Ext.getCmp('lowLimitLbl_appl').show();
							Ext.getCmp('logonStatusSepId').show();
							if(!Ext.isEmpty(jsonData.majorValue))
							Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
							if(!Ext.isEmpty(jsonData.minorValue))
								Ext.getCmp('upperminor').setValue(jsonData.minorValue);
							if(!Ext.isEmpty(jsonData.criticalValue))
								Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
							if(!Ext.isEmpty(jsonData.uppermajor_enum))
								Ext.getCmp('uppermajor_enum').setValue(jsonData.uppermajor_enum);
							if(!Ext.isEmpty(jsonData.upperminor_enum))
								Ext.getCmp('upperminor_enum').setValue(jsonData.upperminor_enum);
							if(!Ext.isEmpty(jsonData.upperCritical_enum))
								Ext.getCmp('upperCritical_enum').setValue(jsonData.upperCritical_enum);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
							if(!Ext.isEmpty(jsonData.uppermajor_appl))
								Ext.getCmp('uppermajor_appl').setValue(jsonData.uppermajor_appl);
							if(!Ext.isEmpty(jsonData.upperminor_appl))
								Ext.getCmp('upperminor_appl').setValue(jsonData.upperminor_appl);
							if(!Ext.isEmpty(jsonData.upperCritical_appl))
								Ext.getCmp('upperCritical_appl').setValue(jsonData.upperCritical_appl);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
						}
					}
				}
				else
				{
					var selectedLoc = jsonData.locationselectOptions.selectedLocationsType;
					comboObject=Ext.getCmp('er_location');
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(jsonData.locationCmbo);
					if (!Ext.isEmpty(selectedLoc) && selectedLoc!=undefined)
					{
						comboObject.setValue(selectedLoc);
					} 
					else if(!Ext.isEmpty(jsonData.locationCmbo))
					{
						comboObject.setValue(jsonData.locationCmbo[0].valueField);
					} 
					else
					{
						comboObject.setValue("-1");
					}
					comboRawData = appConstants.publicjsonDataUsage.applnCombo;
					selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
					comboObject = mainForm.findField("appForAgent");
					comboObject.getStore().clearFilter(true); 
					comboObject.getStore().loadRawData(comboRawData);
					if (!Ext.isEmpty(selectedComboOption) && selectedComboOption!=undefined) {
						comboObject.setValue(selectedComboOption);
					} 
					else if(!Ext.isEmpty(comboRawData))
					{
						comboObject.setValue(comboRawData[0].valueField);
					}
					else
					{
						comboObject.setValue("-1");
					}
					//
					var er_location = Ext.getCmp("er_location").getValue();
					if (er_location!=undefined && er_location!='all')
					{
						if (isSettingsEnabled)
						{
							Ext.getCmp('lowLimitLbl').hide();
							Ext.getCmp('lowLimitLbl_enum').hide();
							Ext.getCmp('lowLimitLbl_appl').hide();
							Ext.getCmp('logonStatusSepId').hide();
						}
					}
					else
					{
						if (isSettingsEnabled)
						{
							Ext.getCmp('lowLimitLbl').show();
							Ext.getCmp('lowLimitLbl_enum').show();
							Ext.getCmp('lowLimitLbl_appl').show();
							Ext.getCmp('logonStatusSepId').show();
							if(!Ext.isEmpty(jsonData.majorValue))
							Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
							if(!Ext.isEmpty(jsonData.minorValue))
								Ext.getCmp('upperminor').setValue(jsonData.minorValue);
							if(!Ext.isEmpty(jsonData.criticalValue))
								Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
							if(!Ext.isEmpty(jsonData.uppermajor_enum))
								Ext.getCmp('uppermajor_enum').setValue(jsonData.uppermajor_enum);
							if(!Ext.isEmpty(jsonData.upperminor_enum))
								Ext.getCmp('upperminor_enum').setValue(jsonData.upperminor_enum);
							if(!Ext.isEmpty(jsonData.upperCritical_enum))
								Ext.getCmp('upperCritical_enum').setValue(jsonData.upperCritical_enum);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
							if(!Ext.isEmpty(jsonData.uppermajor_appl))
								Ext.getCmp('uppermajor_appl').setValue(jsonData.uppermajor_appl);
							if(!Ext.isEmpty(jsonData.upperminor_appl))
								Ext.getCmp('upperminor_appl').setValue(jsonData.upperminor_appl);
							if(!Ext.isEmpty(jsonData.upperCritical_appl))
								Ext.getCmp('upperCritical_appl').setValue(jsonData.upperCritical_appl);
							if(!Ext.isEmpty(jsonData.criticalColor))
								Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
							if(!Ext.isEmpty(jsonData.majorColor))
								Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
							if(!Ext.isEmpty(jsonData.minorColor))
								Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
						}
					}
				}
			}
		});
	},
	zoneOnChange: function() {
		Ext.getCmp("resultPanel").hide();
		var mainForm =Ext.getCmp('mainform').getForm();
		var url;
		var zoneval=mainForm.findField("select_farm").getValue();
		var er_optionVal=mainForm.findField("er_option").getValue();
		
		if(zoneval!='-1')
		{
			url = "/final/reporter/ErCtxLogonSimulatorJSON.jsp?er_zone="+encodeURIComponent(zoneval);
			Ext.Ajax.request({
				url: url,
				scope: this,
				method: "GET",
				success: function(response) {
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataUsage=jsonData;
					var globalScreenLabel = appConstants.publicjsonDataUsage.screenLabels;
						comboRawData = appConstants.publicjsonDataUsage.compTypeCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedCompType;
						comboObject = mainForm.findField("er_compType");
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboRawData = appConstants.publicjsonDataUsage.componentCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedComponents;
						comboObject = Ext.getCmp("er_server");
						appConstants.rawDataForComponents = comboRawData;
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						comboRawData = appConstants.publicjsonDataUsage.applnCombo;
						selectedComboOption = appConstants.publicjsonDataUsage.selectedAppln;
						comboObject = mainForm.findField("er_applicationX");
						appConstants.rawDataForApplication=comboRawData;
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						//..
						comboObject = mainForm.findField("appForAgent");
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(comboRawData);
						if (!Ext.isEmpty(selectedComboOption)) {
							comboObject.setValue(selectedComboOption);
						} else {
							comboObject.setValue(comboRawData[0].valueField);
						}
						var selectedLoc = jsonData.locationselectOptions.selectedLocationsType;
						comboObject=Ext.getCmp('er_location');
						comboObject.getStore().clearFilter(true); 
						comboObject.getStore().loadRawData(jsonData.locationCmbo);
						if (!Ext.isEmpty(selectedLoc) && selectedLoc!=undefined)
						{
							comboObject.setValue(selectedLoc);
						} 
						else if(!Ext.isEmpty(jsonData.locationCmbo))
						{
							comboObject.setValue(jsonData.locationCmbo[0].valueField);
						}
						else
						{
							comboObject.setValue("-1");
						}
						//..
				}
			});
		}
	}, 
	LoadFieldsForUsage: function() {
		var url = "/final/reporter/ErCtxLogonSimulatorJSON.jsp";
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: "POST",
			success: function(response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage = jsonData;
				this.getMain().setTitle(jsonData.reportTitle);
				this.fillFormFieldsForUsage(jsonData);
			}
		});
	},
	fillFormFieldsForUsage: function(jsonData)
	{
		var mainForm =Ext.getCmp('mainform').getForm();
		mainForm.findField("er_mode").hide();
		if(Ext.getCmp("er_excwe")!=undefined)
		{
			Ext.getCmp("er_excwe").hide();
			Ext.getCmp("logonStatusSepId").hide();
		}
			
		Ext.getCmp("egcomponent").show();
		Ext.getCmp("er_server").show();
		mainForm.findField("er_compType").show();
		mainForm.findField("er_applicationX").show();
		var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		} else {
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var screenLabels = jsonData.screenLabels;
		comboRawData = jsonData.viewApplnCombo;
		selectedComboOption = jsonData.selectedViewAppln;
		var selectedAnalysisByCombo='';
		if (jsonData.hasOwnProperty('selectedAnalysisByCombo'))
		{
			selectedAnalysisByCombo=jsonData.selectedAnalysisByCombo;
		}
		if(selectedAnalysisByCombo=='Zone' || Ext.isEmpty(selectedAnalysisByCombo))
		{
			Ext.getCmp('er_site').hide();
			comboRawData = jsonData.zoneCombo;
			selectedComboOption = jsonData.selectedZone;
			comboObject = mainForm.findField("select_farm");
			comboObject.setFieldLabel(screenLabels["reporter.common.Zone"]);
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		}
		else if(selectedAnalysisByCombo=='Segment')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Segment');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) 
			{
				comboObject.setValue(selectedComboOption);
			} 
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Service')
		{
			Ext.getCmp('select_farm').hide();
			comboRawData = jsonData.siteCombo;
			selectedComboOption = jsonData.selectedSiteCombo;
			comboObject = mainForm.findField("er_site");
			comboObject.setFieldLabel('Service');
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if (!Ext.isEmpty(selectedComboOption)) {
				comboObject.setValue(selectedComboOption);
			} else {
				comboObject.setValue(comboRawData[0].valueField);
			}
			comboObject.show();
		}
		else if(selectedAnalysisByCombo=='Component')
		{
			Ext.getCmp('select_farm').hide();
			Ext.getCmp('er_site').hide();
		}
		comboRawData = jsonData.compTypeCombo;
		selectedComboOption = jsonData.selectedCompType;
		comboObject = mainForm.findField("er_compType");
		comboObject.setFieldLabel(screenLabels["reporter.common.Component Type"]);
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		component = Ext.getCmp("er_server");
		var totalComponents = jsonData.componentCombo;
		var selectedComponents = jsonData.selectedComponents;
		appConstants.rawDataForComponents = totalComponents;
		component.getStore().loadRawData(totalComponents);
		if (!Ext.isEmpty(selectedComponents))
		{
			component.setValue(selectedComponents);
		} 
		else if(!Ext.isEmpty(totalComponents))
		{
			component.setValue(totalComponents[0].valueField);
		}
		else
		{
			component.setValue("-1");
		}
		comboObject.resumeEvents();
		if(targetType == 'applicationBased')
		{
			Ext.getCmp('er_location').hide();
			comboRawData = jsonData.applnCombo;
			selectedComboOption = jsonData.selectedAppln;
			comboObject = mainForm.findField("er_applicationX");
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if(appConstants.isThirdPage!=null && appConstants.isThirdPage=="true" && !Ext.isEmpty(jsonData.selectedapplicationX))
			{
				comboObject.setValue(jsonData.selectedapplicationX);
			}
			else if (!Ext.isEmpty(selectedComboOption) && appConstants.isThirdPage!=null && appConstants.isThirdPage!="true") 
			{
				comboObject.setValue(selectedComboOption);
			}
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			Ext.getCmp('appForAgent').hide();
		}
		else
		{
			Ext.getCmp('er_applicationX').hide();
			//
			comboRawData = jsonData.applnCombo;
			selectedComboOption = jsonData.selectedAppln;
			comboObject = mainForm.findField("appForAgent");
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if(appConstants.isThirdPage!=null && appConstants.isThirdPage=="true" && !Ext.isEmpty(jsonData.selectedapplicationX))
			{
				comboObject.setValue(jsonData.selectedapplicationX);
			}
			else if (!Ext.isEmpty(selectedComboOption) && appConstants.isThirdPage!=null && appConstants.isThirdPage!="true") 
			{
				comboObject.setValue(selectedComboOption);
			}
			else 
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			//
			comboRawData = jsonData.locationCmbo;
			selectedComboOption = jsonData.selectedAppln;
			comboObject = mainForm.findField("er_location");
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(jsonData.locationCmbo);
			if (!Ext.isEmpty(jsonData.selectedLocationsType) && jsonData.selectedLocationsType!=undefined)
			{
				comboObject.setValue(jsonData.locationselectOptions.selectedLocationsType);
			}
			else if(!Ext.isEmpty(comboRawData))
			{
				comboObject.setValue(comboRawData[0].valueField);
			}
			else
			{
				comboObject.setValue(jsonData.locationselectOptions.valueField);
			} 
		}
	},
	saveReportAsPDF:function(){
		var saveQString;
			saveQString=appConstants.queryStringUsage;
			saveQString+="&pageWidthProces=1024&options=graph&pdfPrint=yes&pdf=yes";

		if (appConstants.checkFull!=undefined)
		{
			saveQString+="&checkFull="+appConstants.checkFull;
		}
		if (appConstants.byName!=undefined)
		{
			saveQString+="&byName="+appConstants.byName;
		}
		if (appConstants.fromAppLaunchIcon!=undefined)
		{
			saveQString+="&fromAppLaunchIcon="+appConstants.fromAppLaunchIcon;
		}
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?&pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250&options=graph"+saveQString;
		var selectedCompnt = Ext.getCmp("er_server").getValue();
		var selectedLoc = Ext.getCmp("er_location").getValue();
		var selectedApp = Ext.getCmp("er_applicationX").getValue();
		s_qryString+="&selectedLoc="+selectedLoc+"&selectedApp="+encodeURIComponent(selectedApp)+"&selectedCompnt="+selectedCompnt;
		if (appConstants.commonPage!=null && appConstants.commonPage!=undefined && appConstants.commonPage=='yes')
		{
			s_qryString+="&commonPage="+appConstants.commonPage;
		}
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
			{
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled.toString() =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}
						else
						{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}
					else
						s_qryString+=setLegendVal;
				}
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		
		s_qryString=this.getGridColSortParam(s_qryString);
		appConstants.erUtils.savePDF(s_qryString);
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		var sortState='1';
		if (this.gridColStateParam=='ASC')
			sortState='1';
		else
			sortState='0';
		return query+'&orderBy='+sortState;
	},
	bookletQuery: function(obj)
	{
		//var s_qryString = appConstants.queryStringUsage;

///
		var saveQString;
		saveQString=appConstants.queryStringUsage;
		saveQString+="&pageWidthProces=1024&options=graph&pdfPrint=yes&pdf=yes";

		if (appConstants.checkFull!=undefined)
		{
			saveQString+="&checkFull="+appConstants.checkFull;
		}
		if (appConstants.byName!=undefined)
		{
			saveQString+="&byName="+appConstants.byName;
		}
		if (appConstants.fromAppLaunchIcon!=undefined)
		{
			saveQString+="&fromAppLaunchIcon="+appConstants.fromAppLaunchIcon;
		}
		var s_qryString = "pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250&options=graph"+saveQString;
		var selectedCompnt = Ext.getCmp("er_server").getValue();
		var selectedLoc = Ext.getCmp("er_location").getValue();
		var selectedApp = Ext.getCmp("er_applicationX").getValue();
		s_qryString+="&selectedLoc="+selectedLoc+"&selectedApp="+encodeURIComponent(selectedApp)+"&selectedCompnt="+selectedCompnt;
		if (appConstants.commonPage!=null && appConstants.commonPage!=undefined && appConstants.commonPage=='yes')
		{
			s_qryString+="&commonPage="+appConstants.commonPage;
		}
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
			var islegendEnabled = Ext.getCmp('showLegend').getValue();
			if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
			{
				var setLegendVal = "&showLegend="+islegendEnabled;
				if(s_qryString.indexOf(setLegendVal)==-1){
					if(s_qryString.indexOf("&showLegend=")>-1){
						if(islegendEnabled.toString() =='true'){
							s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
						}
						else
						{
							s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
						}
					}
					else
						s_qryString+=setLegendVal;
				}
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		s_qryString=this.getGridColSortParam(s_qryString);
///


		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="&er_trgttype="+targetType+appConstants.queryStringUsage;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	printReport:function(){
		var s_qryString;
		//..prakash for showing correct title in print
		if(appConstants.printPageIdentify!=null && appConstants.printPageIdentify == 'appSecondPage')
		{	 
			var selectedAppTemp = "&selectedApp="+Ext.getCmp('er_applicationX').getValue();
			if(appConstants.queryStringUsage.indexOf('&selectedApp=All')>-1)
			{
				appConstants.queryStringUsage = appConstants.queryStringUsage.replace('&selectedApp=All',selectedAppTemp);
			}
		}
		//
		s_qryString = "/final/reporter/ErCtxLogonSimulatorPRINT.jsp?&pdf=no&pdfPrint=yes&isChartRequest=true&er_width=450&er_height=250&options=graph"+appConstants.queryStringUsage;
		if (appConstants.checkFull!=undefined)
		{
			s_qryString+="&checkFull="+appConstants.checkFull;
		}
		if (appConstants.byName!=undefined)
		{
			s_qryString+="&byName="+appConstants.byName;
		}
		if (appConstants.fromAppLaunchIcon!=undefined)
		{
			s_qryString+="&fromAppLaunchIcon="+appConstants.fromAppLaunchIcon;
		}

		if (appConstants.commonPage!=null && appConstants.commonPage!=undefined && appConstants.commonPage=='yes')
		{
			s_qryString+="&commonPage="+appConstants.commonPage;
		}
		var selectedCompnt = Ext.getCmp("er_server").getValue();
		var selectedLoc = Ext.getCmp("er_location").getValue();
		var selectedApp = Ext.getCmp("er_applicationX").getValue();
		s_qryString+="&selectedLoc="+encodeURIComponent(selectedLoc)+"&selectedApp="+encodeURIComponent(selectedApp)+"&selectedCompnt="+selectedCompnt;
		var islegendEnabled = false;
		if(Ext.getCmp('showLegend')!=undefined){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined'){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(s_qryString.indexOf(setLegendVal)==-1){
				if(s_qryString.indexOf("&showLegend=")>-1){
					if(islegendEnabled.toString() =='true'){
						s_qryString = s_qryString.replace("&showLegend=false",setLegendVal);
					}else{
						s_qryString = s_qryString.replace("&showLegend=true",setLegendVal);
					}
					
				}else
					s_qryString+=setLegendVal;
			}
		}
		  s_qryString=this.getGridColSortParam(s_qryString);
		}
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveSchedule:function(){
		var mainForm =Ext.getCmp('mainform').getForm();
		var isValid = this.validateMainForm(false);
		if( isValid && mainForm.findField('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid){
			var s_qryString;
			this.updateQStringUsage();
			s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringUsage;
			if (appConstants.byName==null)
			{
				appConstants.byName='no';
			}
			s_qryString+="&byName="+appConstants.byName;
			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return
	},
	saveFavorite:function(){
		var isValid = this.validateMainForm(false);
		var mainForm =Ext.getCmp('mainform').getForm();
		
		/* if(isValid && mainForm.findField('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
			this.updateQStringUsage();
			var hiddenFields = appConstants.publicjsonDataUsage['hiddenfields'];
			var favorite_id = hiddenFields["favorite_id"];
			s_qryString="../servlet/com.eg.ErFavoriteC?cmd=client&er_trgttype="+targetType+"&"+appConstants.queryStringUsage+"&isFavorite=true&er_view=GRAPH&er_excwe=No";
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (appConstants.formButtonId=='save')
			{
				if((favorite_id=="null" ||  favorite_id=="undefined" || favorite_id==undefined) && appConstants.favorite_id!="null")
					favorite_id=appConstants.favorite_id;
				target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		else
			return;
	},
	validateMainForm:function(flag){
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
				var compType=mainForm.findField('er_compType');
				var component=mainForm.findField('er_server');
				var application=mainForm.findField('er_applicationX');
				var appForAgent = mainForm.findField("appForAgent");
				var er_location=mainForm.findField('er_location');
				if( compType.getValue() == '-1'){
					Ext.MessageBox.show({
						title: 'Logon Simulator',
						msg: compType.getStore().getAt(0).get('displayField'),
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if( component.getValue() == '-1'){
					Ext.MessageBox.show({
						title: 'Logon Simulator',
						msg: component.getStore().getAt(0).get('displayField'),
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(targetType == 'applicationBased')
				{
					if( application.getValue() == '-1' && appConstants.forceSubmit=='true')
					{
						return false;
					}
					else if( application.getValue() == '-1')
					{
						Ext.MessageBox.show({
							title: 'Logon Simulator',
							msg: application.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
					}
				}
				else
				{
					if( er_location.getValue() == '-1')
					{
						Ext.MessageBox.show({
							title: 'Logon Simulator',
							msg: er_location.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
					}
					if (appForAgent.getValue() == '-1')
					{
						Ext.MessageBox.show({
							title: 'Logon Simulator',
							msg: appForAgent.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
					}
				}
				
				var appCombo = Ext.getCmp('er_applicationX').getValue();
				var exCombo = Ext.getCmp('er_location').getValue();
				if(targetType == 'applicationBased')
				{
					exCombo=null;
				}
				else
				{
					appCombo=null;
				}
		if ((appCombo!=null && appCombo!=undefined && appCombo=='All') || (exCombo!=null && exCombo!=undefined && exCombo=='all'))
		{
			if(isSettingsEnabled)
			{
				var upperCriticalVal;
				var upperMinorVal;
				var upperMajorVal;
				upperCriticalVal=Ext.getCmp('upperCritical').getValue();
				if(Ext.isEmpty(upperCriticalVal) || upperCriticalVal.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Critical Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMajorVal=Ext.getCmp('uppermajor').getValue();
				if(Ext.isEmpty(upperMajorVal) || upperMajorVal.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Major Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMinorVal=Ext.getCmp('upperminor').getValue();
				if(Ext.isEmpty(upperMinorVal) || upperMinorVal.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Minor Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperCriticalVal<=upperMajorVal || upperCriticalVal<=upperMinorVal)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Critical Value Should be greater than other values',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperMajorVal<=upperMinorVal)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Major Value Should be greater than Minor value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var upperCriticalVal_enum; 
				var upperMinorVal_enum;
				var upperMajorVal_enum;
				upperCriticalVal_enum=Ext.getCmp('upperCritical_enum').getValue();
				if(Ext.isEmpty(upperCriticalVal_enum) || upperCriticalVal_enum.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Critical Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMajorVal_enum=Ext.getCmp('uppermajor_enum').getValue();
				if(Ext.isEmpty(upperMajorVal_enum) || upperMajorVal_enum.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Major Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false; 
				}
				upperMinorVal_enum=Ext.getCmp('upperminor_enum').getValue();
				if(Ext.isEmpty(upperMinorVal_enum) || upperMinorVal_enum.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Minor Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperCriticalVal_enum<=upperMajorVal_enum || upperCriticalVal_enum<=upperMinorVal_enum)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Critical Value Should be greater than other values',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperMajorVal_enum<=upperMinorVal_enum)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Major Value Should be greater than Minor value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var upperCriticalVal_appl;
				var upperMinorVal_appl;
				var upperMajorVal_appl;
				upperCriticalVal_appl=Ext.getCmp('upperCritical_appl').getValue();
				if(Ext.isEmpty(upperCriticalVal_appl) || upperCriticalVal_appl.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Critical Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMajorVal_appl=Ext.getCmp('uppermajor_appl').getValue();
				if(Ext.isEmpty(upperMajorVal_appl) || upperMajorVal_appl.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Major Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				upperMinorVal_appl=Ext.getCmp('upperminor_appl').getValue();
				if(Ext.isEmpty(upperMinorVal_appl) || upperMinorVal_appl.length==0)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Invalid Minor Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperCriticalVal_appl<=upperMajorVal_appl || upperCriticalVal_appl<=upperMinorVal_appl)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Critical Value Should be greater than other values',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				if(upperMajorVal_appl<=upperMinorVal_appl)
				{
					Ext.MessageBox.show({
						title: 'Logon Simulator settings',
						msg: 'Major Value Should be greater than Minor value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
		}
		var jsonData;
		jsonData = appConstants.publicjsonDataUsage
		var isSettingsOk = true;

		var hiddenFields = jsonData['hiddenfields'];

		var MaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var reportgen=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var er_usertimeline = '';
		if ( !Ext.isEmpty( hiddenFields['userTimeline'] ) ){
			er_usertimeline = hiddenFields['userTimeline'];
		}
		var er_timeline=mainForm.findField('er_timeline').getValue();
		var stDate = mainForm.findField('er_stdate').getValue();
		var enDate = mainForm.findField('er_enddate').getValue();
		var startHour = mainForm.findField('er_sthr').getValue();
		var endHour = mainForm.findField('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');

		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Thin Client Application settings',
				msg:  appConstants.userTimelineErrorMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if (reportgen!=null && reportgen == 'foreground')
		{
			var limitforbg = hiddenFields["limitforbg"];
			if(!Ext.isEmpty(limitforbg))
			{
				if(flag)
				{
					/*if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						isSettingsOk = false;
					}*/
				}
			}
		}
		else{
			var reportName = thinclientSettingsForm.findField('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			return true;
		}
		else
		{
			return false;
		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	showResult:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var mainForm =Ext.getCmp('mainform').getForm();
		var startdate = mainForm.findField('er_stdate').getValue();
		var starthr = mainForm.findField('er_sthr').getValue();
		startdate.setHours(starthr);
		var enddate = mainForm.findField('er_enddate').getValue();
		var endhr = mainForm.findField('er_endhr').getValue();
		enddate.setHours(endhr);
		var result = checkDateTime(startdate, enddate);
		if (!result) {
			return;
		}
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.submitReport();
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv') )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			this.submitReport();
		}
		else
		{
			if(!isSettingsEnabled)
				this.showConfigDropdown();
			var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
			var reportGenType=thinclientSettingsForm.findField('reportGeneration');
			var bgreportNameObj=thinclientSettingsForm.findField('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus();
			this.showResult();
		}
	},
	getXmlForUrl: function( URL )
	{
		try
		{
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					chartAttrib=Ext.decode(jsonText);
				},
				failure: function()
				{
					alert('I am not loading...'+URL);
				}
			});
			return chartAttrib;
		}
		catch ( e )
		{
			alert('[Exception] '+e);
		}
	},
	//LOGON External - BY External Agent STARTS
	//- by External Agent MainTable starts
	loadGrid:function(jsonData)
	{
		var resultPanelObj=Ext.getCmp('resultPanel');
		var mainForm =Ext.getCmp('mainform').getForm();
		var locName = Ext.getCmp("er_location").getValue();
		var appForAgent = Ext.getCmp("appForAgent").getValue();
		var compArray=new Array();
		compArray = Ext.getCmp("er_server").getValue();
		var me = this;
		resultPanelObj.removeAll();
		resultPanelObj.show();
		var enableEnumulation = jsonData.enableEnumulation
		var data = jsonData.table_data
		var firstPage =jsonData['firstPageData'];
		var isDirect = false;
		if(jsonData.table_data!=undefined && !Ext.isEmpty(jsonData.table_data))
		{
			var tableHtml='<div class="newTable" style="overflow:auto"><table align="center" valign="middle" width="100%">';
			tableHtml+='<thead>';
			tableHtml+='<tr>';
			tableHtml+=' <th align="center" rowspan="2" style="width:20%">SIMULATION</th > ';
			tableHtml+='<th align="center" rowspan="2" style="width:20%">EXTERNAL AGENT</th >';
			tableHtml+=' <th align="center" colspan="2" style="width:20%;text-align:center">WEB LOGON</th >';
			if(enableEnumulation)
				tableHtml+=' <th align="center" colspan="2" style="width:20%;text-align:center">APPLICATION/DESKTOP ENUMERATION</th >';
			tableHtml+='<th align="center" colspan="2"  style="width:20%;text-align:center">APPLICATION/DESKTOP LAUNCH</th >';
			tableHtml+='</tr>';
			tableHtml+='<tr>';
			tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th >';
			tableHtml+=' <th style="text-align:center" class="subHeader">Duration (secs)</th > ';
			if(enableEnumulation){
				tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th >';
				tableHtml+=' <th style="text-align:center" class="subHeader">Duration (secs)</th > ';
			}
			tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th >';
			tableHtml+=' <th style="text-align:center" class="subHeader">Duration (secs)</th >';
			tableHtml+='</tr>';
			tableHtml+='</thead>';
			tableHtml+'<tbody>';
			appConstants.printPageIdentify='locMainTable';
			appConstants.queryStringUsage+="&printPageIdentify="+appConstants.printPageIdentify;
			var d_count=1;
			for(var key in data)
			{
				if(d_count%2==0)
					className='alterColor2';
				else
					className='alterColor1';
				var components = key.substring(0, key.indexOf('#'));
				var rowspan = key.substring(key.indexOf('#')+1,key.length);
				var values = data[key];
				tableHtml+='<tr>';
				d_count=d_count+1;
				tableHtml+='<td rowspan="'+rowspan+'" class="'+className+'">'+components+'</td>';
				for(var i=0;i<values.length;i++)
				{
					var sepRow = values[i];
					for(var k=0;k<sepRow.length;k++)
					{
						var hrefUrl = firstPage['hrefUrl'];
						//..
						var erOption=Ext.getCmp('er_option');
						if(erOption!=undefined)
						{
							hrefUrl+="&er_option="+erOption.getValue();
							if(erOption.getValue()=='Zone')
							{
								var zoneval=mainForm.findField("select_farm").getValue();
								hrefUrl+="&er_zone="+zoneval;
							}
							else if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
							{
								var erSite=Ext.getCmp('er_site');
								hrefUrl+="&er_site="+erSite.getValue();
							}
						}
						//..
						if (appConstants.isFifthPage!=null && appConstants.isFifthPage!="true" && appConstants.isFourthPage!=null && appConstants.isFourthPage!="true" && locName!=undefined && locName=='all'  && !isDirect)
						{
							hrefUrl+='&er_location='+sepRow[0]+'&er_component='+components+"&isNavigation=true&isNeedBack=true&isFourthPage=false&isFifthPage=false&printPageIdentify=locFirstPage"+"&appForAgent="+encodeURIComponent(appForAgent);
							appConstants.isFromBack=false;
						}
						else
						{
							if (appConstants.isFromBack)
							{
								hrefUrl+='&er_location='+sepRow[0]+'&er_component='+components+'&isNeedBack='+appConstants.isNeedBack+"&appForAgent="+encodeURIComponent(appForAgent);
							}
							if (appConstants.isFifthPage!=null && appConstants.isFifthPage!="true" && appConstants.isFourthPage!=null && appConstants.isFourthPage!="true" && !appConstants.isFromBack)
							{
								isDirect=true;
								for(var k=0;compArray.length>k;k++)
								{
									hrefUrl+="&er_component="+compArray[k];
								}
								hrefUrl+='&er_location='+locName+'&firstpage=true'+'&er_trgttype='+targetType+'&isNeedBack='+appConstants.isNeedBack+"&isFourthPage=false&isFifthPage=false&printPageIdentify=locFirstPage"+"&appForAgent="+encodeURIComponent(appForAgent);
								this.goFirstPage(hrefUrl,appConstants.isNeedBack);
								return;
							}
							else if(appConstants.isFourthPage!=null && appConstants.isFourthPage=="true" && !appConstants.isFromBack)
							{
								for(var k=0;compArray.length>k;k++)
								{
									hrefUrl+="&er_component="+compArray[k];
								}
								hrefUrl+='&er_location='+locName+'&firstpage=true'+'&er_trgttype='+targetType+'&isFourthPage=true&pageNo=2&isNavigation=false&isNeedBack='+appConstants.isNeedBack+"&appForAgent="+encodeURIComponent(appForAgent);
								this.goFourthPage(hrefUrl);
								return;
							}
							else if(appConstants.isFifthPage!=null && appConstants.isFifthPage=="true" && !appConstants.isFromBack)
							{
								for(var k=0;compArray.length>k;k++)
								{
									hrefUrl+="&er_component="+compArray[k];
								}
								hrefUrl+='&er_location='+locName+'&firstpage=true'+'&er_trgttype='+targetType+'&isFifthPage=true&pageNo=2&isNavigation=false&isNeedBack='+appConstants.isNeedBack+"&appForAgent="+encodeURIComponent(appForAgent);
								this.goFifthPage(hrefUrl);
								return;
							}
						}
						tableHtml+= '<td style="cursor:pointer;" class="'+className+'" ><a href="javascript:void(0);" onClick="javascript:showDrillDownData(\''+hrefUrl+'\',\''+"true"+'\');" >'+sepRow[k]+'</a></td>'; 

						if (appConstants.isFifthPage!=null && appConstants.isFifthPage!="true" && appConstants.isFourthPage!=null && appConstants.isFourthPage!="true" && locName!=undefined && locName!='all' && !appConstants.isFromBack)
						{
							hrefUrl+='&er_location='+sepRow[0]+'&er_component='+components+'&firstpage=true'+'&er_trgttype='+targetType+'&isNeedBack='+appConstants.isNeedBack+"&printPageIdentify=locFirstPage"+"&appForAgent="+encodeURIComponent(appForAgent);
							this.goFirstPage(hrefUrl,"true");
							return;
						}
						else if(appConstants.isFourthPage!=null && appConstants.isFourthPage=="true" && !appConstants.isFromBack)
						{
							for(var k=0;compArray.length>k;k++)
							{
								hrefUrl+="&er_component="+compArray[k];
							}
							hrefUrl+='&er_location='+locName+'&firstpage=true'+'&er_trgttype='+targetType+'&isFourthPage=true&pageNo=2&isNavigation=false&isNeedBack='+appConstants.isNeedBack+"&appForAgent="+encodeURIComponent(appForAgent);
							this.goFourthPage(hrefUrl);
							return;
						}
						else if(appConstants.isFifthPage!=null && appConstants.isFifthPage=="true" && !appConstants.isFromBack) 
						{
							for(var k=0;compArray.length>k;k++)
							{
								hrefUrl+="&er_component="+compArray[k];
							}
							hrefUrl+='&er_location='+locName+'&firstpage=true'+'&er_trgttype='+targetType+'&isFifthPage=true&pageNo=2&isNeedBack='+appConstants.isNeedBack+"&appForAgent="+encodeURIComponent(appForAgent);
							this.goFifthPage(hrefUrl);
							return;
						}
						if(sepRow.length-k==1)
						{
							tableHtml+='</tr>';
						}
					}
					if(i<values.length-1)
						tableHtml+='<tr>';
				}
			}
			tableHtml+='</div>';
			tableHtml+='</div>';
			tableHtml+='</tbody></table>';
			tableHtml+='</div>';
			resultPanelObj.show();
			resultPanelObj.removeCls('containerShadow');
			resultPanelObj.addCls('');
			resultPanelObj.setTitle("LOGON SIMULATOR");
			resultPanelObj.add(
			{
				xtype:'container',
				border:true,
				html:tableHtml,
				flex:1,
				cls:'selectionDetailsBorder selectionDetailsBg',
				margin:'5 10 10 10',
				layout:{
					type:'fit',
					align:'stretch'
				},
			});
		}
		else
		{
			this.disableTools();
			resultPanelObj.hide();
			var errorPanelId = Ext.getCmp('errorPanelId');
			var tableHtmlNo ='<table width="100%" height="100%" style="height:100%;" border="0px" ><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>';
			errorPanelId.add(
			{
				xtype:'container',
				html:tableHtmlNo,
				margin:'5 10 10 10',
				flex:1,
				//cls:'selectionDetailsBorder selectionDetailsBg',
				layout:{
					type:'fit',
					align:'stretch'
				},
			});
			errorPanelId.show();
		}
	},
	//- by External Agent MainTable starts

	//- by External Agent First page starts
	goFirstPage:function(url,isFromBackB)
	{
		appConstants.commonPage=null;
		appConstants.printPageIdentify='locFirstPage';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locMainTable",appConstants.printPageIdentify);
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var summary_data ='';
		var hidden;
		var erLocation=Ext.getCmp('er_location');
		if (isFromBackB!=undefined && isFromBackB=='true')
		{
			hidden =false;
		}
		else if (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes' && (erLocation==undefined || (erLocation != undefined && erLocation.getValue() == 'All' || erLocation.getValue() == 'all')))//..
		//else if (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes')
		{
			hidden = false;
		}
		else if (appConstants.splEntry!=undefined && appConstants.splEntry=='yes')
		{
			hidden = false;
		}
		else
		{
			hidden=true;
		}
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				var checkData = jsonData.checkData
				appConstants.publicjsonDataUsage=jsonData;
				var enableEnumulation = jsonData.enableEnumulation;
				var firstPageData = jsonData.firstPageData;
				var totalLogon = firstPageData['summaryList_1']['totalLogon'];
				var successLogon = firstPageData['summaryList_1']['successLogon'];
				var failLogon = firstPageData['summaryList_1']['failLogon'];

				var logAva = firstPageData['availabilityList']['avgLogonAvail'];
				var enumAva = firstPageData['availabilityList']['avgEnumAvail'];
				var appAva = firstPageData['availabilityList']['avgAppLaunchAvail'];
				var donutHtml ='';
				if (totalLogon>0)
				{
					donutHtml += '<div margin:-6px auto 0px auto;" align="center"><table><tr><td align="right"><div id="donuts_id" ></div></td>';
					donutHtml += '<td align="left"><table align="center" cellpadding="0" cellspacing="0" border="0"><tbody>';
					if (jsonData.summSucc!=undefined && jsonData.summSucc!=null)
					{
						donutHtml += '<tr><td ><div style="background-color:#32B395;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.summSucc+'</td></tr>';
					}
					if (jsonData.summFail!=undefined && jsonData.summFail!=null)
					{
						donutHtml +='<tr><td><div style="background-color:#EC7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.summFail+'</td></tr>';
					}
					donutHtml +='</tbody></table></td></tr></table></div>';
				}
				if (logAva!=undefined  && appAva!=undefined && totalLogon>0)
				{
					var locName = Ext.getCmp("er_location").getValue();
					var component;
					component =Ext.getCmp('er_location');
					component.getStore().clearFilter(true); 
					component.getStore().loadRawData(jsonData.locationCmbo);
					component.setValue(jsonData.selectedLocation);
					if (jsonData.selectedLocation!=undefined && jsonData.selectedLocation!='all' && isSettingsEnabled)
					{
						Ext.getCmp('lowLimitLbl').hide();
						Ext.getCmp('lowLimitLbl_enum').hide();
						Ext.getCmp('lowLimitLbl_appl').hide();
						Ext.getCmp('logonStatusSepId').hide();
					}
					component = Ext.getCmp("er_server");
					var totalComponents = jsonData.componentCombo;
					var selectedComponents = jsonData.selectedComponents;
					appConstants.rawDataForComponents = totalComponents;
					component.getStore().loadRawData(totalComponents);
					if (!Ext.isEmpty(selectedComponents))
					{
						component.setValue(selectedComponents);
					} 
					else if(!Ext.isEmpty(totalComponents))
					{
						component.setValue(totalComponents[0].valueField);
					}
					else
					{
						component.setValue("-1");
					}
					initLdgMask.hide();
					if (appConstants.splEntry!=undefined && appConstants.splEntry=='yes')
					{
						this.insideBackButton(6,false);
					}
					else
					{
						this.insideBackButton(1,hidden);
					}
					resultPanelObj.add({
						xtype: 'panel',
						margin:'10 10 0 10',
						ui:'newGraphPanel',
						title:overviewOfSimsLabel+'<span class="f13-normal" style="margin-left:20px">('+simulatorLabel+' : '+jsonData.selectedComponents+', '+externalAgentLabel+' : '+jsonData.selectedLocation+')</span>',
						bodyPadding: '0 0 4 0',
						padding:0,
						layout:{
							type:'hbox',
							align:'center'
						},
						defaults:{
							flex:.22,
						},
						items:[
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'100%',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [
							{
								xtype:'container',
								cls:'mouseOverHighlight',
								html:'<table align="center" onClick="javascript:totalGraphs(\''+url+'&printPageIdentify=commonPage'+'\',\''+"true"+'\',\''+"full"+'\');" style="cursor:pointer;"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconTotalSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+totalLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+totalLabel+'</span></td></tr></table>'
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'100%',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [ 
							{
								xtype:'container',
								cls:'mouseOverHighlight',
								html:'<table align="center" onClick="javascript:totalGraphs(\''+url+'&printPageIdentify=commonPage'+'\',\''+"true"+'\',\''+"full"+'\');" style="cursor:pointer;"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconSuccessfulSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+successLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+successLabel+'</span></td></tr></table>'
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'100%',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [
							{
								xtype:'container',
								cls:'mouseOverHighlight',
								html:'<table align="center" onClick="javascript:totalGraphs(\''+url+'&printPageIdentify=commonPage'+'\',\''+"true"+'\',\''+"full"+'\');" style="cursor:pointer;"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconFailedSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+failLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+failureLabel+'</span></td></tr></table>'
							}]
						},{
							xtype:'container',
							align:'center',
							flex:.34,
							autoSize: true,
							layout: {
								type: 'table',
								rows:1,
								columns:1,
								align:'center',
								tableAttrs: {
									style: {
										'text-align':'center',
										'width':'100%',
									}
								},
							},
							items: [
							{
								html: donutHtml,
							}]
						}]
					});
					if(checkData && !Ext.isEmpty(jsonData.donutChart) && jsonData.donutChart!=undefined)
					{
						var donutGraphs = {};
						donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('donuts_id',150,150), donutGraphs);
						donutGraphs.setData(jsonData.donutChart,'','','donut');
						donutGraphs.drawChart(); 
						resultPanelObj.show();
					}
					var mainForm =Ext.getCmp('mainform').getForm();
					var tabl_1 = '';
					if (logAva!=undefined && logAva>=0) 
					{
						appConstants.fromAvailIcon='yes';
						tabl_1 = '<table class="mouseOverHighlight"  onClick="javascript:totalGraphs(\''+url+'&fromAppIcon=yes&printPageIdentify=commonPage'+'\',\''+"false"+'\',\''+"fromLogon"+'\');" style="cursor:pointer;" align="center" ><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconWebLogIn"/></div><div class="newFont_bold28" style="margin:5px;">'+logAva+'%</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+webLogonLabel+'</span></td></tr></table>';


					}
					var tabl_2 = '';
					if (enableEnumulation && enumAva!=undefined && enumAva>=0)
					{
						appConstants.fromEnumIcon='yes';
						tabl_2 = '<table class="mouseOverHighlight"  onClick="javascript:totalGraphs(\''+url+'&fromAppIcon=yes&printPageIdentify=commonPage'+'\',\''+"false"+'\',\''+"fromEnum"+'\');" style="cursor:pointer;" align="center" ><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconAppEnumeration"/></div><div class="newFont_bold28" style="margin:5px;">'+enumAva+'%</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+applnDesktopEnumLabel+'</span></td></tr></table>';
					}
					var tabl_3 = '';
					if (appAva!=undefined && appAva>=0)
					{
						appConstants.fromAppIcon='yes'; 
						tabl_3 = '<table class="mouseOverHighlight"  onClick="javascript:totalGraphs(\''+url+'&fromAppIcon=yes&printPageIdentify=commonPage'+'\',\''+"false"+'\',\''+"fromApp"+'\');" style="cursor:pointer;" align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconAppLaunch"/></div><div class="newFont_bold28" style="margin:5px;">'+appAva+'%</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+applnDesktopLaunchLabel+'</span></td></tr></table>';						
					}
					var html_a='';
					if(checkData && !Ext.isEmpty(jsonData.logonAvaiStBar) && jsonData.logonAvaiStBar!=undefined)
					{
						html_a= '<div id="logonAvai_id"></div>';
					}
					else
					{
						html_a= '<div style="height:300px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					if(enableEnumulation){
						var html_b='';
						if(checkData && !Ext.isEmpty(jsonData.enumAvai_graphMap) && jsonData.enumAvai_graphMap!=undefined)
						{
							html_b= '<div id="enumAvai_id"></div>';
						}
						else
						{
							html_b= '<div style="height:300px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
						}
					}
					var html_c='';
					if(checkData && !Ext.isEmpty(jsonData.appSuFaAvg) && jsonData.appSuFaAvg!=undefined)
					{
						html_c= '<div id="appLaucngAvg_id"></div>';
					}
					else
					{
						html_c= '<div style="height:300px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var flexVal=0.5;
					if(enableEnumulation)
						flexVal=0.3;
					resultPanelObj.add({
						xtype: 'panel',
						margin:'10 10 0 10',
						ui:'newGraphPanel',
						title:availabilityLabel,
						id:'availabltyGrph',
						bodyPadding: '0 0 0 0',
						padding:0,
						flex:1,
						listeners:{
									resize:function(){
										if(!Ext.isEmpty($('#logonAvai_id').highcharts())|| !Ext.isEmpty($('#enumAvai_id').highcharts())||!Ext.isEmpty($('#appLaucngAvg_id').highcharts()))
										{
											$('#logonAvai_id').highcharts().reflow();
											if(enableEnumulation)
												$('#enumAvai_id').highcharts().reflow();
											$('#appLaucngAvg_id').highcharts().reflow();
										}
									}
								},
						layout:{
							type:'hbox',
							align:'stretch'
						},
						defaults:{
							flex:flexVal,
						},
						items:[
						{
							xtype:'container',
							autoSize: true,
							height:370,
							margin:'0 0 20 0',
							cls:'graphSeperatorLineRight',
							defaults: {
								bodyStyle: 'padding:5px',
							},
							items: [
							{
								xtype:'container',
								margin:'0 0 0 0',
								html: tabl_1
							},{
								xtype:'container',
								padding:'10 10 0 10',
								
								html:html_a
								
								
							}]
						}]
					});
					if(enableEnumulation){
						Ext.getCmp('availabltyGrph').add({
							xtype:'container',
							margin:'0 0 20 0',
							defaults: {
								bodyStyle: 'padding:5px',
							},
							cls:'graphSeperatorLineRight',
							items: [
							{
								xtype:'container',
								margin:'0 0 0 0',
								html: tabl_2
							},
							{
								xtype:'container',
								padding:'10 10 0 10',
								
								html:html_b
							}]
						});
					}
					Ext.getCmp('availabltyGrph').add({
						xtype:'container',
						autoSize: true,
						margin:'0 0 20 0',
						
						defaults: {
							bodyStyle: 'padding:5px',
						},
						items: [
						{
							xtype:'container',
							margin:'0 0 0 0',
							html: tabl_3
						},{
							xtype:'container',
							padding:'10 10 0 10',
							html:html_c
							
						}]
					});
					var html_1='';
					var sec_padding = 5;
					if(checkData && !Ext.isEmpty(jsonData.avgDurationPie) && jsonData.avgDurationPie!=undefined)
					{
						html_1= '<div style="text-align:center;padding:0px 10px 10px 10px" class="newFont_bold13">'+responseDistrByStageLabel+'</div><div id="avgDura_id" style="height:260px;width:100%;overflow:hidden;padding:0px"></div>'
					}
					else
					{
						sec_padding=5;
						html_1= '<div style="text-align:center;padding:5px" class="newFont_bold13">'+responseDistrByStageLabel+'</div><div style="height:260px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var html_2='';
					var logonTitle= webLogonDurationLabel;
					if(enableEnumulation)
						logonTitle=webLogonEnumDurationLabel;
					if(checkData && !Ext.isEmpty(jsonData.timlinSuccFailAvg) && jsonData.timlinSuccFailAvg!=undefined)
					{
						html_2= '<div style="text-align:center;padding:10px 10px 0px 10px" class="newFont_bold13">'+logonTitle+'</div><div id="timlin_id" style="height:200px;width:100%;overflow:hidden;padding:0px 5px 0px 5px"></div>'
					}
					else
					{
						html_2= '<div style="text-align:center;padding:5px" class="newFont_bold13">'+logonTitle+'</div><div style="height:260px;width:100%;overflow:auto;padding:0px 10px 0px 10px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>'
					}
					var html_3='';
					if(checkData && !Ext.isEmpty(jsonData.applicationLaunchTime) && jsonData.applicationLaunchTime!=undefined)
					{
						html_3= '<div style="text-align:center;padding:10px" class="newFont_bold13">'+applnDesktopLaunchTimeLabel+'</div><div id="appLaunchMax_Avg_Time_id" style="height:260px;width:100%;overflow:hidden;padding:0px"></div>'
					}
					else
					{
						html_3= '<div style="text-align:center;padding:5px" class="newFont_bold13">'+applnDesktopLaunchTimeLabel+'</div><div style="height:260px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>'
					}
					var html_4='';
					if(checkData && !Ext.isEmpty(jsonData.diffAppDuratn)&& jsonData.diffAppDuratn!=undefined)
					{
						html_4= '<div style="text-align:center;padding:10px 10px 0px 25px" class="newFont_bold13">'+applnDesktopLaunchAnalysisLabel+'</div><div id="appLaunchTime_id" style="height:210px;width:100%;overflow:hidden;padding:0px 5px 0px 5px"></div>'
					} 
					else
					{
						html_4= '<div style="text-align:center;padding:5px" class="newFont_bold13">'+applnDesktopLaunchAnalysisLabel+'</div><div style="height:260px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>'
					}
					resultPanelObj.add({
						xtype: 'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						title:performanceLabel,
						bodyPadding: '0 0 0 0',
						padding:'5 10 10 0',
						flex:1,
						layout:{
							type:'column',
							align:'stretch'
						},
						defaults:{
							columnWidth:.5
						},
						items:[
						{
							xtype:'container',
							cls:'graphSeperatorLineBottomRight',
							padding:5,
							margin:'0 0 0 10',
							//height:'100%',
							height:305,
							html:html_1
						},{
							xtype:'container',
							cls:'graphSeperatorLineBottom',
							height:305,
							items:[
							{
								xtype:'container',
								//padding:5,
								id:'timlin_id_GraphPanel',
								html: html_2
							},
							{
								xtype:'container',
								id:'timlin_id_legendPanel',
								margin:'10 0 0 0',
								height:55,
								style:{'overflow':'hidden'},
							}]
						},{
							xtype:'container',
							cls:'graphSeperatorLineRight',
							padding:5,
							html:html_3
						},{
							xtype:'container',
							height:280,
							items:[{
								xtype:'container',
								//paddding:10,
								id:'appLaunchTime_id_GraphPanel',
								html:html_4
							},
							{
								xtype:'container',
								id:'appLaunchTime_id_legendPanel',
								margin:'10 0 0 0',
								height:55,
								style:{'overflow':'hidden'}
							}]
						}]
					});
					if(checkData && !Ext.isEmpty(jsonData.logonAvaiStBar) && jsonData.logonAvaiStBar!=undefined)
					{
						var chrtwidth=jsonData.logonAvaiStBar.chartWidth;
						if(!enableEnumulation)
							chrtwidth=400;
						var logonAvaiBar = {};
						logonAvaiBar = jQuery.extend(true, {}, getHighChartsBarInstance('logonAvai_id',jsonData.logonAvaiStBar.chartHeight,chrtwidth), logonAvaiBar);
//						logonAvaiBar = jQuery.extend(true, {}, getHighChartsBarInstance('logonAvai_id',jsonData.logonAvaiStBar.chartHeight,jsonData.logonAvaiStBar.chartWidth), logonAvaiBar);
						logonAvaiBar.setData(jsonData.logonAvaiStBar,'<%=currentDateFormat%>','');
						logonAvaiBar.drawChart();
					}
					if(enableEnumulation && checkData && !Ext.isEmpty(jsonData.enumAvai_graphMap) && jsonData.enumAvai_graphMap!=undefined)
					{
						var enumAvaiBar = {};
						enumAvaiBar = jQuery.extend(true, {}, getHighChartsBarInstance('enumAvai_id',jsonData.enumAvai_graphMap.chartHeight,jsonData.enumAvai_graphMap.chartWidth), enumAvaiBar);
						enumAvaiBar.setData(jsonData.enumAvai_graphMap,'<%=currentDateFormat%>','');
						enumAvaiBar.drawChart();
					}
					if(checkData && !Ext.isEmpty(jsonData.appSuFaAvg) && jsonData.appSuFaAvg!=undefined)
					{
						var appLaunchAvg = {};
						appLaunchAvg = jQuery.extend(true, {}, getHighChartsBarInstance('appLaucngAvg_id',jsonData.appSuFaAvg.chartHeight,jsonData.appSuFaAvg.chartWidth), appLaunchAvg);
						appLaunchAvg.setData(jsonData.appSuFaAvg,'<%=currentDateFormat%>','');
						appLaunchAvg.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.avgDurationPie) && jsonData.avgDurationPie!=undefined)
					{
						var avgDuration = {};
						avgDuration = jQuery.extend(true, {}, getHighChartsBarInstance('avgDura_id',jsonData.avgDurationPie.chartHeight,jsonData.avgDurationPie.chartWidth), avgDuration);
						avgDuration.setData(jsonData.avgDurationPie,'<%=currentDateFormat%>','');
						avgDuration.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.timlinSuccFailAvg) && jsonData.timlinSuccFailAvg!=undefined)
					{
						var timelineLgnEnum = {};
						timelineLgnEnum = jQuery.extend(true, {}, getHighChartsInstance('timlin_id',jsonData.timlinSuccFailAvg.chartHeight,jsonData.timlinSuccFailAvg.chartWidth), timelineLgnEnum);
						timelineLgnEnum.setData(jsonData.timlinSuccFailAvg,'MMM dd, yyyy','');
						timelineLgnEnum.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.applicationLaunchTime) && jsonData.applicationLaunchTime!=undefined)
					{
						var appL_max_avg = {};
						appL_max_avg = jQuery.extend(true, {}, getHighChartsBarInstance('appLaunchMax_Avg_Time_id',jsonData.applicationLaunchTime.chartHeight,jsonData.applicationLaunchTime.chartWidth), appL_max_avg);
						appL_max_avg.setData(jsonData.applicationLaunchTime,'MMM dd, yyyy','');
						appL_max_avg.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.diffAppDuratn)&& jsonData.diffAppDuratn!=undefined)
					{
						var diffAppTimln = {};
						diffAppTimln = jQuery.extend(true, {}, getHighChartsInstance('appLaunchTime_id',jsonData.diffAppDuratn.chartHeight,jsonData.diffAppDuratn.chartWidth), diffAppTimln);
						diffAppTimln.setData(jsonData.diffAppDuratn,'MMM dd, yyyy','');
						diffAppTimln.drawChart(); 
						resultPanelObj.show();
					}
				}
				else
				{
					this.disableTools();
					resultPanelObj.hide();
					var errorPanelId = Ext.getCmp('errorPanelId');
					var tableHtmlNo ='<table width="100%" height="100%" style="height:100%;" border="0px"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>';
					errorPanelId.add(
					{
						xtype:'container',
						html:tableHtmlNo,
						margin:'5 10 10 10',
						flex:1,
						layout:{
							type:'fit',
							align:'stretch'
						},
					});
					errorPanelId.show();
				}
			}
		});
	},
	//- by External Agent First page ends

	//- by External Agent Logon Availability starts
	goFourthPage:function(url)
	{
		appConstants.printPageIdentify='locSecondPage';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locMainTable",appConstants.printPageIdentify);
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locFirstPage",appConstants.printPageIdentify);
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var locName = Ext.getCmp('er_location').getValue();
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var summary_data ='';
		Ext.Ajax.request(
		{
			url : '../servlet/com.eg.ErCtxLogonSimulator',
			params : paramsForDrillDown+"&appForAgent="+encodeURIComponent(appForAgent)+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				var checkData = jsonData.checkData
				var enableEnumulation = jsonData.enableEnumulation;
				var firstPageData = jsonData.firstPageData;
				var totalLogon = firstPageData['summaryList']['totalLogon'];
				var successLogon = firstPageData['summaryList']['successLogon'];
				var failLogon = firstPageData['summaryList']['failLogon'];
				var failAppLaunch = firstPageData['summaryList']['failedApp'];
				var failEnum ='';
				if(enableEnumulation)
					failEnum = firstPageData['summaryList']['failedEnum'];
				var failedSimu = firstPageData['summaryList']['failedSimu'];
				var hideEnumData=true;
				if(enableEnumulation)
					hideEnumData=false;
				summary_data += '<div style="margin:1px auto 0px auto;" align="center"><table><tr><td align="right"><div  id="donuts_id" ></div></td>';
				if (totalLogon>0)
				{
					summary_data += '<td style="vertical-align:top;padding-top:10px !important"; align="top"><table align="top" cellpadding="0" cellspacing="0" border="0"><tbody>';
					if (jsonData.donSucc!=undefined && jsonData.donSucc!=null)
					{
						summary_data += '<tr><td><div style="background-color:#32B395;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donSucc+'</td></tr>';
					}
					if (jsonData.donEnum!=undefined && jsonData.donEnum!=null)
					{
						summary_data +='<tr><td><div style="background-color:#F8ABA7;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donEnum+'</td></tr>';
					}
					if (jsonData.donFail!=undefined && jsonData.donFail!=null) 
					{
						summary_data +='<tr><td><div style="background-color:#EF7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donFail+'</td></tr>';
					}
					if (jsonData.donfApp!=undefined && jsonData.donfApp!=null) 
					{
						summary_data +='<tr><td><div style="background-color:#EF7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donfApp+'</td></tr>';
					}
					summary_data +='</tbody></table></td>';
				}
				summary_data +='</tr></table></div>';
				initLdgMask.hide();
				this.insideBackButton(2,false);
				resultPanelObj.add({
					xtype: 'panel',
					margin:'10 10 0 10',
					ui:'newGraphPanel',
					title:overviewOfSimsLabel+'<span style="font-size:13px;font-family:roboto;font-weight:400;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;('+simulatorLabel+' : '+jsonData.selectedComponents+', '+externalAgentLabel+' : '+jsonData.selectedLocation+')</span>',
					bodyPadding: '0 0 0 0',
					padding:0,
					layout:{
						type:'column',
						align:'stretch'
					},
					items:[
					{
						xtype:'container',
						columnWidth:.66,
						padding:'6 5 0 5',
						layout:{
							type:'column',
							align:'center',
							pack:'center'
						},
						defaults:{
							columnWidth:.24,
							padding:'8px 5px 0px 5px',
						},
						items:[{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconTotalSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+totalLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 1px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+totalLabel+'<br/> '+simulationsLabel+'</td></tr></table>',
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconSuccessfulSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+successLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 1px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+successfulLabel+'<br/> '+simulationsLabel+'</td></tr></table>',
							}]
						},{
							xtype:'container',
							autoSize: true,
							hidden:hideEnumData,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconFailedEnumeration"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failEnum+'</span></td></tr><tr><td align="center" style="padding:6px 6px 1px 6px;word-break:break-all" colspan="2" class="newFont_normal13">'+failedLabel+'<br/> '+enumerationsLabel+'</td></tr></table>',
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconLogonFailed"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 1px 6px;word-break: break-all" colspan="2" class="newFont_normal13">'+failedLabel+' <br/> '+webLogonLabel+'</td></tr></table>',
							}]
						},
						{
							xtype:'container',
							items:[{
								html:'<table><tr><td align="right"><img src="/final/images/spacer.gif" class="iconAppLaunch"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failAppLaunch+'</span></td></tr><tr><td align="center" style="padding:6px 6px 1px 6px;word-break: break-all" colspan="2" class="newFont_normal13">'+failedLabel+'<br/>'+applnDesktopLaunchLabel+'</td></tr></table>'
						}]
						}
						]
					},{
						xtype:'container',
						columnWidth:.34,
						border:true,
						html:summary_data,
					}]
				});
				if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
				{
					var dounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+webLogonHealthPercLabel+'</div><div id="logonHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
					dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
					if (jsonData.lg_Critical!=undefined && jsonData.lg_Critical!=null)
					{
						dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.lg_Critical+'</td></tr>';
					}
					if (jsonData.lg_Major!=undefined && jsonData.lg_Major!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.lg_Major+'</td></tr>';
					}
					if (jsonData.lg_Minor!=undefined && jsonData.lg_Minor!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.lg_Minor+'</td></tr>';
					}
					if (jsonData.lg_Normal!=undefined && jsonData.lg_Normal!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.lg_Normal+'</td></tr>';
					}
					if (jsonData.lg_Unkown!=undefined && jsonData.lg_Unkown!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unknown - '+jsonData.lg_Unkown+'</td></tr>';
					}
					dounutHealth +='</tbody></table></td></tr></table></div>';
				}
				else
				{
					dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+webLogonHealthPercLabel+'</div><div style="height:270px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
				}
				var html_q ='';
				if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
				{
					html_q = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocLogonAvail" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
				}
				else
				{
					html_q = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:344px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
				}
				var html_w='';
				if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
				{
					html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocLogonDura" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
				}
				else
				{
					html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:344px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
				}
				resultPanelObj.add({
					xtype: 'panel',
					margin:'10 10 0 10',
					ui:'newGraphPanel',
					title:webLogonDetailsLabel,
					bodyPadding: '0 0 0 0',
					padding:'0 10 10 0',
					flex:1,
					layout:{
						type:'column',
						align:'stretch'
					},
					defaults:{
						columnWidth:.5
					},
					items:[
					{
						xtype:'container',
						cls:'graphSeperatorLineBottomRight',
						padding:'0 30 0 20',
						margin:'0 0 0 10',
						html:html_q
					},{
						xtype:'container',
						cls:'graphSeperatorLineBottom',
						padding:'0 20 0 30',
						html:html_w
					},{
						xtype:'container',
						cls:'graphSeperatorLineRight',
						padding:'0 30 0 20',
						html:dounutHealth
					}]
				});
				if(checkData && !Ext.isEmpty(jsonData.donutChartforApp) && jsonData.donutChartforApp!=undefined)
				{
					var donutGraphs = {}; 
					donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('donuts_id',jsonData.donutChartforApp.chartHeight,jsonData.donutChartforApp.chartWidth), donutGraphs);
					donutGraphs.setData(jsonData.donutChartforApp,'','','donut');
					donutGraphs.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
				{
					var appForLogonAvail = {};
					appForLogonAvail = jQuery.extend(true, {}, getHighChartsInstance('appLocLogonAvail',jsonData.appLogonAvail.chartHeight,jsonData.appLogonAvail.chartWidth), appForLogonAvail);
					appForLogonAvail.setData(jsonData.appLogonAvail,'MMM dd, yyyy','');
					appForLogonAvail.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
				{
					var appForLogonDura = {};
					appForLogonDura = jQuery.extend(true, {}, getHighChartsInstance('appLocLogonDura',jsonData.appLogonDura.chartHeight,jsonData.appLogonDura.chartWidth), appForLogonDura);
					appForLogonDura.setData(jsonData.appLogonDura,'MMM dd, yyyy','');
					appForLogonDura.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
				{
					var logondonutGraphs = {};
					logondonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('logonHealth',jsonData.chartWidth,jsonData.chartHeight), logondonutGraphs);
					logondonutGraphs.setData(jsonData.logonDonutHealth,'','','donut');
					logondonutGraphs.drawChart(); 
					resultPanelObj.show();
				}
			}
		});
	},
	//- by External Agent Logon Availability ends

	//- by External Agent Application Enumeration starts
	goFifthPage:function(url)
	{
		appConstants.printPageIdentify='locThirdPage';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locMainTable",appConstants.printPageIdentify);
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locFirstPage",appConstants.printPageIdentify);
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var summary_data ='';
		Ext.Ajax.request(
		{
			url : '../servlet/com.eg.ErCtxLogonSimulator',
			params : paramsForDrillDown+"&appForAgent="+encodeURIComponent(appForAgent)+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var checkData = jsonData.checkData
				var firstPageData = jsonData.firstPageData;
				var totalLogon = firstPageData['summaryList']['totalLogon'];
				var successLogon = firstPageData['summaryList']['successLogon'];
				var failLogon = firstPageData['summaryList']['failLogon'];
				var failEnum = firstPageData['summaryList']['failedEnum'];
				var failedSimu = firstPageData['summaryList']['failedSimu'];

				var component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				summary_data += '<div style="margin:1px auto 0px auto;" align="center"><table><tr><td align="right"><div  id="donuts_id" ></div></td>';
				if (totalLogon>0)
				{
					summary_data += '<td style="vertical-align:top;padding-top:10px !important"; align="top"><table align="top" cellpadding="0" cellspacing="0" border="0"><tbody>';
					if (jsonData.donSucc!=undefined && jsonData.donSucc!=null)
					{
						summary_data += '<tr><td><div style="background-color:#32B395;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donSucc+'</td></tr>';
					}
					if (jsonData.donEnum!=undefined && jsonData.donEnum!=null)
					{
						summary_data +='<tr><td><div style="background-color:#F8ABA7;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donEnum+'</td></tr>';
					}
					if (jsonData.donFail!=undefined && jsonData.donFail!=null) 
					{
						summary_data +='<tr><td><div style="background-color:#EF7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">'+jsonData.donFail+'</td></tr>';
					}
					summary_data +='</tbody></table></td>';
				}
				summary_data +='</tr></table></div>';
				var locName = Ext.getCmp('er_location').getValue();
				this.insideBackButton(3,false);
				resultPanelObj.add({
					xtype: 'panel',
					margin:'10 10 0 10',
					ui:'newGraphPanel',
					title:overviewOfSimsLabel+'<span style="font-size:13px;font-family:roboto;font-weight:400;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;('+simulatorLabel+' : '+jsonData.selectedComponents+', '+externalAgentLabel+' : '+jsonData.selectedLocation+')</span>',
					bodyPadding: '0 0 0 0',
					padding:0,
					layout:{
						type:'column',
						align:'stretch'
					},
					items:[
					{
						xtype:'container',
						columnWidth:.66,
						padding:'6 5 0 5',
						layout:{
							type:'column',
							align:'center',
							pack:'center'
						},
						defaults:{
							columnWidth:.24,
							padding:'8px 5px 0px 5px',
						},
						items:[{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconTotalSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+totalLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 2px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+totalLabel+'<br/> '+simulationsLabel+'</td></tr></table>',
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconSuccessfulSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+successLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 2px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+successfulLabel+'<br/> '+simulationsLabel+'</td></tr></table>',
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconLogonFailed"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failLogon+'</span></td></tr><tr><td align="center" style="padding:6px 6px 2px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+failedLabel+'<br/>'+webLogonLabel+'</td></tr></table>',
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconFailedEnumeration"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failEnum+'</span></td></tr><tr><td align="center" style="padding:6px 6px 2px 6px;word-break:break-all" colspan="2" class=newFont_normal13>'+failedLabel+'<br/> '+enumerationsLabel+'</td></tr></table>',
							}]
						}]
					},{
						xtype:'container',
						columnWidth:.34,
						border:true,
						html:summary_data,
					}
					]
				});
				var dounutHealth = ''
				if(checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
				{
					dounutHealth ='<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:5px" class="newFont_bold13">'+enumHealthPercLabel+'</div><div id="enumHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
					dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
					if (jsonData.enum_Critical!=undefined && jsonData.enum_Critical!=null)
					{
						dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.enum_Critical+'</td></tr>';
					}
					if (jsonData.enum_Major!=undefined && jsonData.enum_Major!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.enum_Major+'</td></tr>';
					}
					if (jsonData.enum_Minor!=undefined && jsonData.enum_Minor!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.enum_Minor+'</td></tr>';
					}
					if (jsonData.enum_Normal!=undefined && jsonData.enum_Normal!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.enum_Normal+'</td></tr>';
					}
					if (jsonData.enum_Unkown!=undefined && jsonData.enum_Unkown!=null)
					{
						dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.enum_Unkown+'</td></tr>';
					}
					dounutHealth +='</tbody></table></td></tr></table></div>';
				}
				else
				{
					dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+enumHealthPercLabel+'</div><div style="height:270px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
				}
				var html_e ='';
				if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
				{
					sec_padding = '0 20 0 30';
					html_e = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocEnumAvail" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
				}
				else
				{
					html_e = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:344px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
				}
				var html_r ='';
				if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
				{
					html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocEnumDura" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
				}
				else
				{
					html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+' </div><div style="height:265px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
				}
				resultPanelObj.add({
					xtype: 'panel',
					margin:'10 10 0 10',
					ui:'newGraphPanel',
					title:enumerationDetailsLabel,
					bodyPadding: '0 0 0 0',
					padding:'0 10 10 0',
					flex:1,
					layout:{
						type:'column',
						align:'stretch'
					},
					defaults:{
						columnWidth:.5
					},
					items:[
					{
						xtype:'container',
						cls:'graphSeperatorLineBottomRight',
						padding:'0 30 0 20',
						margin:'0 0 0 10',
						html:html_e
					},{
						xtype:'container',
						cls:'graphSeperatorLineBottom',
						padding:'0 20 0 30',
						html:html_r
					},{
						xtype:'container',
						cls:'graphSeperatorLineRight',
						padding:'0 30 0 20',
						html:dounutHealth
					}]
				});
				
				if(checkData && !Ext.isEmpty(jsonData.donutChartforApp) && jsonData.donutChartforApp!=undefined)
				{
					var donutGraphs = {};
					donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('donuts_id',jsonData.donutChartforApp.chartHeight,jsonData.donutChartforApp.chartWidth), donutGraphs);
					donutGraphs.setData(jsonData.donutChartforApp,'','','donut');
					donutGraphs.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
				{
					var appForEnumAvail = {};
					appForEnumAvail = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumAvail',jsonData.appEnumAvail.chartHeight,jsonData.appEnumAvail.chartWidth), appForEnumAvail);
					appForEnumAvail.setData(jsonData.appEnumAvail,'MMM dd, yyyy','');
					appForEnumAvail.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
				{
					var appForEnumDura = {};
					appForEnumDura = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumDura',jsonData.appEnumDura.chartHeight,jsonData.appEnumDura.chartWidth), appForEnumDura);
					appForEnumDura.setData(jsonData.appEnumDura,'MMM dd, yyyy','');
					appForEnumDura.drawChart(); 
					resultPanelObj.show();
				}
				if(checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
				{
					var enumdonutGraphs = {};
					enumdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('enumHealth',jsonData.chartWidth,jsonData.chartHeight), enumdonutGraphs);
					enumdonutGraphs.setData(jsonData.enumDonutHealth,'','','donut');
					enumdonutGraphs.drawChart(); 
					resultPanelObj.show();
				}
			}
		});
	},
	//- by External Agent Application Enumeration ends

	//LOGON External - BY APPLICATION STARTS
	//- by Application Main Table starts
	loadGridforApp:function(jsonData)
	{
		var resultPanelObj=Ext.getCmp('resultPanel');
		var mainForm =Ext.getCmp('mainform').getForm();
		var appName = Ext.getCmp("er_applicationX").getValue();
		var compArray=new Array();
		compArray = Ext.getCmp("er_server").getValue();
		var me = this;
		resultPanelObj.removeAll();
		resultPanelObj.show();
		var enableEnumulation = jsonData.enableEnumulation;
		var data = jsonData.table_data;
		var firstPage =jsonData['secondPageData'];
		var isDirect=false;
		appConstants.printPageIdentify='appMainTable';
		appConstants.queryStringUsage+="&printPageIdentify="+appConstants.printPageIdentify;
		if(data!=undefined && !Ext.isEmpty(data))
		{
			var tableHtml='<div class="plainTableReporterDynamicRowspan"><table align="center" valign="middle" width="100%">';
			tableHtml+='<thead>';
			tableHtml+='<tr>';
			tableHtml+=' <th align="center" rowspan="2">SIMULATION</th> ';
			tableHtml+='<th align="center" rowspan="2">APPLICATION/DESKTOP</th>';
			tableHtml+=' <th align="center" colspan="2" style="min-width:250px;text-align:center">WEB LOGON</th>';
			if(enableEnumulation)
				tableHtml+=' <th align="center" colspan="2" style="min-width:250px;text-align:center">APPLICATION/DESKTOP ENUMERATION</th>';
			tableHtml+='<th align="center" colspan="2"  style="min-width:250px;text-align:center">APPLICATION/DESKTOP LAUNCH</th>';
			tableHtml+='</tr>';
			tableHtml+='<tr>';
			tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th>';
			tableHtml+=' <th style="text-align:center" class="subHeader">Duration (Secs)</th> ';
			if(enableEnumulation){
				tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th>';
				tableHtml+=' <th style="text-align:center" class="subHeader">Duration (Secs)</th> ';
			}
			tableHtml+=' <th style="text-align:center" class="subHeader">Availability (%)</th>';
			tableHtml+=' <th style="text-align:center" class="subHeader">Duration (Secs)</th>';
			tableHtml+='</tr>';
			tableHtml+='</thead>';
			tableHtml+'<tbody>';
			var d_count=1;
			var className='alterColor1';
			for(var key in data)
			{
				if(d_count%2==0)
					className='alterColor2';
				else
					className='alterColor1';

				var components = key.substring(0, key.indexOf('#'));
				var rowspan = key.substring(key.indexOf('#')+1,key.length);
				var values = data[key];
				tableHtml+='<tr >';
				d_count=d_count+1;
				tableHtml+='<td rowspan="'+rowspan+'" class="'+className+'">'+components+'</td>';
				for(var i=0;i<values.length;i++)
				{
					var sepRow = values[i];
					for(var k=0;k<sepRow.length;k++)
					{
						var hrefUrl = firstPage['hrefUrl'];
						//..
						var erOption=Ext.getCmp('er_option');
						if(erOption!=undefined)
						{
							hrefUrl+="&er_option="+erOption.getValue();
							if(erOption.getValue()=='Zone')
							{
								var zoneval=mainForm.findField("select_farm").getValue();
								hrefUrl+="&er_zone="+zoneval;
							}
							else if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
							{
								var erSite=Ext.getCmp('er_site');
								hrefUrl+="&er_site="+erSite.getValue();
							}
						}
						//..
						if(appConstants.isThirdPage!=null && appConstants.isThirdPage!="true" && appName!=undefined && appName=='All' &&!isDirect)
						{
							hrefUrl+='&er_applicationX='+encodeURIComponent(sepRow[0])+'&er_component='+components+"&er_trgttype="+targetType;
						}
						else if (appName!=undefined && appName=='All')
						{
							hrefUrl+='&er_applicationX='+encodeURIComponent(sepRow[0])+'&er_component='+components+"&er_trgttype="+targetType;
						}
						else
						{
							if (appConstants.isFromBack)
							{
								hrefUrl+='&er_applicationX='+encodeURIComponent(sepRow[0])+'&er_component='+components+"&er_trgttype="+targetType;
							}
							if (!appConstants.isFromBack)
							{
								isDirect=true;
								for(var k=0;compArray.length>k;k++)
								{
									hrefUrl+="&er_component="+compArray[k];
								}
								hrefUrl+='&er_applicationX='+encodeURIComponent(appName)+"&er_trgttype="+targetType+'&isNavigation=false&secondpage=true&isThirdPage=true&pageNo=2';
								this.goThirdPage(hrefUrl,"false");
								return;
							}
						}
						tableHtml+= '<td style="cursor:pointer;" class="'+className+'"><a href="javascript:void(0);" onClick="javascript:appLaunchSimulator(\''+hrefUrl+'\',\''+sepRow[0]+'\',\''+"true"+'\');" >'+sepRow[k]+'</a></td>';
						if(appConstants.isThirdPage!=null && appConstants.isThirdPage=="true" && !appConstants.isFromBack && appName!=undefined && appName!='All')
						{
							for(var k=0;compArray.length>k;k++)
							{
								hrefUrl+="&er_component="+compArray[k];
							}
							hrefUrl+='&er_applicationX='+encodeURIComponent(appName)+"&er_trgttype="+targetType+'&isNavigation=false&secondpage=true&isThirdPage=true&pageNo=2';
							this.goThirdPage(hrefUrl,"true");
							return;
						}
						if(sepRow.length-k==1)
						{
							tableHtml+='</tr>';
						}
					}
					if(i<values.length-1)
						tableHtml+='<tr>';
				}
			}
			tableHtml+='</tbody></table>';
			tableHtml+='</div>';
			resultPanelObj.show();
			resultPanelObj.removeCls('containerShadow');
			resultPanelObj.addCls('');
			resultPanelObj.setTitle("LOGON SIMULATOR");
			resultPanelObj.add(
			{
				xtype:'container',
				html:tableHtml,
				margin:'10 10 10 10',
				padding:10,
				ui:'newContainer',
				layout:{
					type:'fit',
					align:'stretch'
				},
			});
		}
		else
		{
			this.disableTools();
			resultPanelObj.hide();
			var errorPanelId = Ext.getCmp('errorPanelId');
			var tableHtmlNo ='<table width="100%" height="100%" style="height:100%;" border="0px" ><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>';
			errorPanelId.add(
			{
				xtype:'container',
				html:tableHtmlNo,
				margin:'5 10 10 10',
				flex:1,
				//cls:'selectionDetailsBorder selectionDetailsBg',
				layout:{
					type:'fit',
					align:'stretch'
				},
			});
			errorPanelId.show();
		}
	},
	//- by Application Main Table ends

	//- by Application Second page starts
	goThirdPage:function(url,isFromBackB)
	{
		appConstants.fromAppLaunchIcon='yes';
		appConstants.printPageIdentify='appSecondPage';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("appMainTable",appConstants.printPageIdentify);
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locFirstPage",appConstants.printPageIdentify);
		initLdgMask.show();
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var summary_data ='';
		var hidden;
		if ((isFromBackB!=undefined && isFromBackB=='true') || (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes'))
		{
			hidden =false;
		}
		else
		{
			hidden=true;
		}
		Ext.Ajax.request(
		{
			url : '../servlet/com.eg.ErCtxLogonSimulator',
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var checkData = jsonData.checkData;
				var component;
				component =Ext.getCmp('er_applicationX');
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.applnCombo);
				component.setValue(jsonData.selectedapplicationX);
				component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				var firstPageData = jsonData.firstPageData;
				var totalLogon = firstPageData['summaryList']['totalLogon'];
				var successLogon = firstPageData['summaryList']['successLogon'];
				var failLogon = firstPageData['summaryList']['failLogon'];
				var failedSimu = firstPageData['summaryList']['failedSimu'];
				var failEnum = firstPageData['summaryList']['failedEnum'];
				var failedApp = firstPageData['summaryList']['failedApp'];
				this.insideBackButton(4,hidden);
				var er_location = Ext.getCmp("er_location").getValue();
				var summary_array = new Array();
				var summaryData =[];
				if (totalLogon!=undefined && totalLogon!=null && totalLogon>0 && totalLogon!='' && totalLogon!='-')
				{
					if ((appConstants.fromAppIcon!= undefined && appConstants.fromAppIcon=='yes') || (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes' && totalLogon >0  && totalLogon!='-')) // here icon
					{
						summary_data += '<div style="margin:1px auto 0px auto;height:150px;"><table border="0px" height="100%"><tr><td align="right" valign="middle"><div  id="donuts_id" ></div></td>';
						summary_data += '<td align="center" valign="middle">';
						if (jsonData.donSucc!=undefined && jsonData.donSucc!=null)
						{
							summary_data += '<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#32B395;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donSucc+'</td></tr></table></div>';
						}
						if (jsonData.donFail!=undefined && jsonData.donFail!=null) 
						{
							summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#EF7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donFail+'</td></tr></table></div>';
						}
						if (jsonData.donEnum!=undefined && jsonData.donEnum!=null)
						{
							summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F8ABA7;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donEnum+'</td></tr></table></div>';
						}
						if (jsonData.donSimu!=undefined && jsonData.donSimu!=null)
						{
							summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#DE4640;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donSimu+'</td></tr></table></div>';
						}
						if (jsonData.donfApp!=undefined && jsonData.donfApp!=null)
						{
							summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F7BD42;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donfApp+'</td></tr></table></div>';
						}
						summary_data +='</td></tr></table></div>';
						summaryData = [
							{ 
							xtype:'container',
							columnWidth:.7,
							layout:
							{
								type:'column',
								align:'center',
								pack:'center'
							},
							defaults:
							{
								columnWidth:.33,
								padding:'10 10 0 10',
							},
							items:[{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html:'<table align="center"><tr><td align="center" nowrap><div class="iconTotalSimulations"><div class="iconAppLaunch"/></div><div class="newFont_bold28" style="margin:5px;">'+totalLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+totalSimulationsLabel+'</span></td></tr></table>'
								}]
							},
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconSuccessfulSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+successLogon+'</span></td></tr><tr><td align="center" style="padding:7px 7px 0px 7px" colspan="2"><span class=newFont_normal13>'+succuessSimulationsLabel+'</span></td></tr></table>',
								}]
							},
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconFailedSimulations"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failedSimu+'</span></td></tr><tr><td align="center" style="padding:7px 7px 0px 7px" colspan="2"><span class=newFont_normal13>'+failedSimulationsLabel+'</span></td></tr></table>',
								}]
							},
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconLogonFailed"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failLogon+'</span></td></tr><tr><td align="center" style="padding:7px 7px 0px 7px" colspan="2"><span class=newFont_normal13>'+failedWebLogonsLabel+'</span></td></tr></table>',
								}]
							}, 
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconFailedEnumeration"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failEnum+'</span></td></tr><tr><td align="center" style="padding:7px 7px 0px 7px" colspan="2"><span class=newFont_normal13>'+failedEnumerationsLabel+'</span></td></tr></table>',
								}]
							},{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								items:[{
									xtype:'container',
									html: '<table ><tr><td align="right"><img src="/final/images/spacer.gif" class="iconFailedAppLaunch"/></td><td align="left" style="padding:5px"><span class="newFont_bold28">'+failedApp+'</span></td></tr><tr><td align="center" style="padding:7px 7px 0px 7px" colspan="2"><span class=newFont_normal13>'+failedApplnDesktopLabel+'</span></td></tr></table>',
								}]
							}]
						},
						{
							xtype:'container',
							columnWidth:.3,
							html:summary_data,
						}];
							initLdgMask.hide();
							resultPanelObj.add({
								xtype: 'panel',
								layout:'column',
								margin:'0 10 0 10',
								ui:'newGraphPanel',
								title:simsForApplnDesktopLabel+' - '+jsonData.selectedapplicationX,
								padding:0,
								bodyPadding:0,
								html:tableHtml,
								items:summaryData
						});
					}
					else // here table
					{
						var appCombo = Ext.getCmp('er_applicationX').getValue();
						var data = jsonData.summaryTableApp;
						var enableEnumulation = jsonData.enableEnumulation;
						var tableHtml="";
						var hUrl = "";
						hUrl='../reporter/ErCtxLogonSimulator.jsp?&er_trgttype=locationBased&isNeedBack='+appConstants.isNeedBack+"&isFourthPage=false&isFifthPage=false&printPageIdentify=locFirstPage"+"&appForAgent="+encodeURIComponent(appCombo)+"&splEntry=yes";
						var mainForm = Ext.getCmp('mainform').getForm();
						var thinclientSettingsForm =null;
						var er_compType = Ext.getCmp('er_compType').getValue();
						hUrl+="&er_compType="+er_compType;
						var compArray = new Array();
						if(isSettingsEnabled)
							thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
						var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
						var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
						var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
						var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
						var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
						var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
						hUrl+=timperiodParams+timelineParams;
						//
						var erOption=Ext.getCmp('er_option');
						if(erOption!=undefined)
						{
							hUrl+="&er_option="+erOption.getValue();
							if(erOption.getValue()=='Zone')
							{
								var zoneval=mainForm.findField("select_farm").getValue();
								hUrl+="&er_zone="+zoneval;
							}
							else if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
							{
								var erSite=Ext.getCmp('er_site');
								hUrl+="&er_site="+erSite.getValue();
							}
						}
						compArray=Ext.getCmp("er_server").getValue();
						for(var k=0;compArray.length>k;k++)
						{
							hUrl+="&er_component="+compArray[k];
						}
						if (data!=null && data!=undefined && !Ext.isEmpty(data) && data!='-')
						{
							tableHtml='<div class="newTable"><table width="100%"><thead><tr><th rowspan="2">'+externalAgentLabel+'</th><th colspan="3" style="text-align:center">'+simulationsLabel+'</th><th style="text-align:center;" rowspan="2">'+failedLogonsLabel+'</th>';
							if(enableEnumulation)
								tableHtml+='<th style="text-align:center;" rowspan="2">'+failedEnumerationsLabel+'</th>';
							tableHtml+='<th style="text-align:center;" rowspan="2">'+failedApplnDesktopLaunchesLabel+'</th></tr><tr><th colspan="1" class="subHeader">'+totalLabel+'</th><th colspan="1" class="subHeader">'+successfulLabel+'</th><th colspan="1" class="subHeader">'+failureLabel+'</th></tr></thead>';
							tableHtml+='<tbody>';
							for(var key in data)
							{
								tableHtml+='<tr>';
								hUrl+='&er_location='+key;
								tableHtml+= '<td style="cursor:pointer;text-align:center" onClick="javascript:fromAppToLoc(\''+hUrl+'\',\''+"true"+'\');" >'+key+'</td>';
								var values = data[key];
								if (values!=null && values!=undefined && !Ext.isEmpty(values))
								{
									for(var i=0;i<values.length;i++)
									{
										tableHtml+= '<td style="cursor:pointer;text-align:center" onClick="javascript:fromAppToLoc(\''+hUrl+'\',\''+"true"+'\');" >'+values[i]+'</td>';
									}
								}
								else
								{
									for(var i=0;i<6;i++)
									{
										tableHtml+='<td style="text-align:center">';
										tableHtml+="-";
										tableHtml+='</td>';
									}
								}
								tableHtml+='</tr>';
							}
							tableHtml+='</tbody></table></div>';
						}
						summaryData=[
						{
							xtype:'container',
							scroll:false,
							autoScroll:true,
							height:180,
							padding:0,
							margin:10,
							
						}]
						initLdgMask.hide();
						resultPanelObj.add({
							xtype: 'panel',
							layout:'column',
							margin:'10 10 0 10',
							ui:'newGraphPanel',
							title:simsForApplnDesktopLabel+' - '+jsonData.selectedapplicationX,
							padding:0,
							bodyPadding:10,
							html:tableHtml,
						});
					}
					if (totalLogon!=undefined && totalLogon!='' && totalLogon >0  && totalLogon!='-')
					{
						if ((appConstants.fromAppIcon!= undefined && appConstants.fromAppIcon=='yes') || (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes' ))
						{
							var dounutHealth='';
							if(checkData && !Ext.isEmpty(jsonData.appLaunchDonutHealth)&& jsonData.appLaunchDonutHealth!=undefined)
							{
								dounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+applnDesktopLaunchHealthPercLabel+'</div><div id="appLaunchHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
								dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
								if (jsonData.app_Critical!=undefined && jsonData.app_Critical!=null)
								{
									dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.app_Critical+'</td></tr>';
								}
								if (jsonData.app_Major!=undefined && jsonData.app_Major!=null)
								{
									dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.app_Major+'</td></tr>';
								}
								if (jsonData.app_Minor!=undefined && jsonData.app_Minor!=null)
								{
									dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.app_Minor+'</td></tr>';
								}
								if (jsonData.app_Normal!=undefined && jsonData.app_Normal!=null)
								{
									dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.app_Normal+'</td></tr>';
								}
								if (jsonData.app_Unkown!=undefined && jsonData.app_Unkown!=null)
								{
									dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.app_Unkown+'</td></tr>';
								}
								dounutHealth +='</tbody></table></td></tr></table></div>';
							}
							else
							{
								dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+applnDesktopLaunchHealthPercLabel+'</div><div style="height:330px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							var html_t ='';
							if(checkData && !Ext.isEmpty(jsonData.appLaunchAvailLocation)&& jsonData.appLaunchAvailLocation!=undefined)
							{
								html_t = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLaunchAvailTime_id" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
							}
							else
							{
								html_t = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+' </div><div style="height:264px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							var html_y ='';
							if(checkData && !Ext.isEmpty(jsonData.appLaunchDurationLocation)&& jsonData.appLaunchDurationLocation!=undefined)
							{
								html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+' </div><div id="appLaunchDurationTime_id" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
							}
							else
							{
								html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:264px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							resultPanelObj.add({
								xtype: 'panel',
								margin:'10 10 0 10',
								ui:'newGraphPanel',
								title:applnDesktopLabel,
								bodyPadding: '0 0 0 0',
								padding:'0 10 10 0',
								flex:1,
								layout:{
									type:'column',
									align:'stretch'
								},
								defaults:{
									columnWidth:.5,
								},
								items:[
								{
									xtype:'container',
									cls:'graphSeperatorLineBottomRight',
									padding:'0 30 0 20',
									margin:'0 0 0 10', 
									html:html_t
								},{
									xtype:'container',
									cls:'graphSeperatorLineBottom',
									padding:'0 20 0 30',
									html:html_y
								},{
									xtype:'container',
									cls:'graphSeperatorLineRight',
									padding:'0 30 0 20',
									html:dounutHealth
								}]
							});
							if ((appConstants.fromAppIcon!= undefined && appConstants.fromAppIcon=='yes') || (appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes' && totalLogon >0))
							{
								if(checkData && !Ext.isEmpty(jsonData.donutChartforApp) && jsonData.donutChartforApp!=undefined)
								{
									var donutGraphs = {};
									donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('donuts_id',jsonData.donutChartforApp.chartHeight,jsonData.donutChartforApp.chartWidth), donutGraphs);
									donutGraphs.setData(jsonData.donutChartforApp,'','','donut');
									donutGraphs.drawChart(); 
									resultPanelObj.show();
								}
							}
							if(checkData && !Ext.isEmpty(jsonData.appLaunchAvailLocation)&& jsonData.appLaunchAvailLocation!=undefined)
							{
								var appLaunchTimeAvai = {};
								appLaunchTimeAvai = jQuery.extend(true, {}, getHighChartsInstance('appLaunchAvailTime_id',jsonData.appLaunchAvailLocation.chartHeight,jsonData.appLaunchAvailLocation.chartWidth), appLaunchTimeAvai);
								appLaunchTimeAvai.setData(jsonData.appLaunchAvailLocation,'MMM dd, yyyy','');
								appLaunchTimeAvai.drawChart(); 
								resultPanelObj.show();
							}
							if(checkData && !Ext.isEmpty(jsonData.appLaunchDurationLocation)&& jsonData.appLaunchDurationLocation!=undefined)
							{
								var appLaunchTimeDura = {};
								appLaunchTimeDura = jQuery.extend(true, {}, getHighChartsInstance('appLaunchDurationTime_id',jsonData.appLaunchDurationLocation.chartHeight,jsonData.appLaunchDurationLocation.chartWidth), appLaunchTimeDura);
								appLaunchTimeDura.setData(jsonData.appLaunchDurationLocation,'MMM dd, yyyy','');
								appLaunchTimeDura.drawChart(); 
								resultPanelObj.show();
							}
							if(checkData && !Ext.isEmpty(jsonData.appLaunchDonutHealth)&& jsonData.appLaunchDonutHealth!=undefined)
							{
								var appdonutGraphs = {};
								appdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('appLaunchHealth',280,280), appdonutGraphs);
								appdonutGraphs.setData(jsonData.appLaunchDonutHealth,'','','donut');
								appdonutGraphs.drawChart(); 
								resultPanelObj.show();
							}
						}
						else
						{
							var checkData = jsonData.checkData;
							initLdgMask.hide();
							resultPanelObj.show();
							var html_q ='';
							var html_w ='';
							if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
							{
								html_q = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocLogonAvail" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
							}
							else
							{
								html_q = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
							{
								html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocLogonDura" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
							}
							else
							{
								html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							//--Avalilability
							resultPanelObj.add({
								xtype: 'panel',
								margin:'10 10 0 10',
								ui:'newGraphPanel',
								title:webLogonDetailsLabel,
								bodyPadding: '0 0 0 0',
								padding:'0 10 10 0',
								flex:1,
								layout:{
									type:'column',
									align:'stretch'
								},
								defaults:{
									columnWidth:.5
								},
								items:[
								{
									xtype:'container',
									cls:'graphSeperatorLineBottomRight',
									padding:'0 30 0 20',
									margin:'0 0 0 10',
									html:html_q
								},{
									xtype:'container',
									cls:'graphSeperatorLineBottom',
									padding:'0 20 0 30',
									html:html_w
								}]
							});
							if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
							{
								var appForLogonAvail = {};
								appForLogonAvail = jQuery.extend(true,{}, getHighChartsInstance('appLocLogonAvail',jsonData.appLogonAvail.chartHeight,jsonData.appLogonAvail.chartWidth), appForLogonAvail);
								appForLogonAvail.setData(jsonData.appLogonAvail,'MMM dd, yyyy','');
								appForLogonAvail.drawChart(); 
								resultPanelObj.show();
							}
							if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
							{
								var appForLogonDura = {};
								appForLogonDura = jQuery.extend(true,{}, getHighChartsInstance('appLocLogonDura',jsonData.appLogonDura.chartHeight,jsonData.appLogonDura.chartWidth), appForLogonDura);
								appForLogonDura.setData(jsonData.appLogonDura,'MMM dd, yyyy','');
								appForLogonDura.drawChart();
								resultPanelObj.show();
							}
							if(enableEnumulation){
								//---Duration
								var html_e ='';
								var sec_padding;
								var html_r ='';
								if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
								{
									sec_padding = '0 20 0 30';
									html_e = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocEnumAvail" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
								}
								else
								{
									sec_padding = '0 20 20 30';
									html_e = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
								}
								if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
								{
									sec_padding = '0 20 0 30';
									html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocEnumDura" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
								}
								else
								{
									sec_padding = '0 20 0 30';
									html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
								}
								resultPanelObj.add({
									xtype: 'panel',
									margin:'10 10 0 10',
									ui:'newGraphPanel',
									title:enumerationDetailsLabel,
									bodyPadding: '0 0 0 0',
									padding:'0 10 10 0',
									flex:1,
									layout:{
										type:'column',
										align:'stretch'
									},
									defaults:{
										columnWidth:.5
									},
									items:[
									{
										xtype:'container',
										cls:'graphSeperatorLineBottomRight',
										padding:'0 30 0 20',
										margin:'0 0 0 10',
										html:html_e
									},{
										xtype:'container',
										cls:'graphSeperatorLineBottom',
										padding:sec_padding,
										html:html_r
									}]
								});
								if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
								{
									var appForEnumAvail = {};
									appForEnumAvail = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumAvail',jsonData.appEnumAvail.chartHeight,jsonData.appEnumAvail.chartWidth), appForEnumAvail);
									appForEnumAvail.setData(jsonData.appEnumAvail,'MMM dd, yyyy','');
									appForEnumAvail.drawChart(); 
									resultPanelObj.show();
								}
								
								if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
								{
									var appForEnumDura = {};
									appForEnumDura = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumDura',jsonData.appEnumDura.chartHeight,jsonData.appEnumDura.chartWidth), appForEnumDura);
									appForEnumDura.setData(jsonData.appEnumDura,'MMM dd, yyyy','');
									appForEnumDura.drawChart(); 
									resultPanelObj.show();
								}
							}
							//---launch-----
							var html_t='';
							var html_y='';
							if(checkData && !Ext.isEmpty(jsonData.totalAppAvail)&& jsonData.totalAppAvail!=undefined)
							{
								html_t = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="tot_appLaunchAvailTime_id" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
							}
							else
							{ 
								html_t = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							if(checkData && !Ext.isEmpty(jsonData.totalAppDura)&& jsonData.totalAppDura!=undefined)
							{
								html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="tot_appLaunchDurationTime_id" style="height:250px;width:100%;overflow:hidden;padding:0px"></div>'
							}
							else
							{
								html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:250px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							//--Avalilability
							resultPanelObj.add({
								xtype: 'panel',
								margin:'10 10 0 10',
								ui:'newGraphPanel',
								title:applnDesktopLaunchDetailsLabel,
								bodyPadding: '0 0 0 0',
								padding:'0 10 10 0',
								flex:1,
								layout:{
									type:'column',
									align:'stretch'
								},
								defaults:{
									columnWidth:.5
								},
								items:[
								{
									xtype:'container',
									cls:'graphSeperatorLineBottomRight',
									padding:'0 30 0 20',
									margin:'0 0 0 10',
									html:html_t
								},{
									xtype:'container',
									cls:'graphSeperatorLineBottom',
									padding:'0 20 0 30',
									html:html_y
								}]
							});
							if(checkData && !Ext.isEmpty(jsonData.totalAppAvail)&& jsonData.totalAppAvail!=undefined)
							{
								var appLaunchTimeAvai = {};
								appLaunchTimeAvai = jQuery.extend(true, {}, getHighChartsInstance('tot_appLaunchAvailTime_id',jsonData.totalAppAvail.chartHeight,jsonData.totalAppAvail.chartWidth), appLaunchTimeAvai);
								appLaunchTimeAvai.setData(jsonData.totalAppAvail,'MMM dd, yyyy','');
								appLaunchTimeAvai.drawChart(); 
								resultPanelObj.show();
							}
							if(checkData && !Ext.isEmpty(jsonData.totalAppDura)&& jsonData.totalAppDura!=undefined)
							{
								var appLaunchTimeDura = {};
								appLaunchTimeDura = jQuery.extend(true, {}, getHighChartsInstance('tot_appLaunchDurationTime_id',jsonData.totalAppDura.chartHeight,jsonData.totalAppDura.chartWidth), appLaunchTimeDura);
								appLaunchTimeDura.setData(jsonData.totalAppDura,'MMM dd, yyyy','');
								appLaunchTimeDura.drawChart(); 
								resultPanelObj.show();
							}
							// - health
							var logon_dounutHealth = '';
							var appLadounutHealth = '';
							var enum_dounutHealth = '';
							if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
							{
								logon_dounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+webLogonLabel+'</div><div id="logonHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
								logon_dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
								if (jsonData.lg_Critical!=undefined && jsonData.lg_Critical!=null)
								{
									logon_dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.lg_Critical+'</td></tr>';
								}
								if (jsonData.lg_Major!=undefined && jsonData.lg_Major!=null)
								{
									logon_dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.lg_Major+'</td></tr>';
								}
								if (jsonData.lg_Minor!=undefined && jsonData.lg_Minor!=null)
								{
									logon_dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.lg_Minor+'</td></tr>';
								}
								if (jsonData.lg_Normal!=undefined && jsonData.lg_Normal!=null)
								{
									logon_dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.lg_Normal+'</td></tr>';
								}
								if (jsonData.lg_Unkown!=undefined && jsonData.lg_Unkown!=null)
								{
									logon_dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unknown - '+jsonData.lg_Unkown+'</td></tr>';
								}
								logon_dounutHealth +='</tbody></table></td></tr></table></div>';
							}
							else
							{
								logon_dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+webLogonLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							if(enableEnumulation){
								if(checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
								{
									enum_dounutHealth ='<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+applnDesktopEnumLabel+'</div><div id="enumHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
									enum_dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
									if (jsonData.enum_Critical!=undefined && jsonData.enum_Critical!=null)
									{
										enum_dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.enum_Critical+'</td></tr>';
									}
									if (jsonData.enum_Major!=undefined && jsonData.enum_Major!=null)
									{
										enum_dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.enum_Major+'</td></tr>';
									}
									if (jsonData.enum_Minor!=undefined && jsonData.enum_Minor!=null)
									{
										enum_dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.enum_Minor+'</td></tr>';
									}
									if (jsonData.enum_Normal!=undefined && jsonData.enum_Normal!=null)
									{
										enum_dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.enum_Normal+'</td></tr>';
									}
									if (jsonData.enum_Unkown!=undefined && jsonData.enum_Unkown!=null)
									{
										enum_dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.enum_Unkown+'</td></tr>';
									}
									enum_dounutHealth +='</tbody></table></td></tr></table></div>';
								}
								else
								{
									enum_dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+applnDesktopEnumLabel+' </div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
								}
							}
							if(checkData && !Ext.isEmpty(jsonData.total_appLaunchDonutHealth)&& jsonData.total_appLaunchDonutHealth!=undefined)
							{
								appLadounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+applnDesktopLaunchLabel+'</div><div id="tot_appLaunchHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
								appLadounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
								if (jsonData.tot_app_Critical!=undefined && jsonData.tot_app_Critical!=null)
								{
									appLadounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.tot_app_Critical+'</td></tr>';
								}
								if (jsonData.tot_app_Major!=undefined && jsonData.tot_app_Major!=null)
								{
									appLadounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.tot_app_Major+'</td></tr>';
								}
								if (jsonData.tot_app_Minor!=undefined && jsonData.tot_app_Minor!=null)
								{
									appLadounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.tot_app_Minor+'</td></tr>';
								}
								if (jsonData.tot_app_Normal!=undefined && jsonData.tot_app_Normal!=null)
								{
									appLadounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.tot_app_Normal+'</td></tr>';
								}
								if (jsonData.tot_app_Unkown!=undefined && jsonData.tot_app_Unkown!=null)
								{
									appLadounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.tot_app_Unkown+'</td></tr>';
								}
								appLadounutHealth +='</tbody></table></td></tr></table></div>';
							}
							else
							{
								appLadounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+applnDesktopLaunchLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
							}
							resultPanelObj.add({ 
								xtype: 'panel',
								margin:'10 10 10 10',
								ui:'newGraphPanel',
								title:healthPercLabel+'(%)',
								bodyPadding: '0 0 0 0',
								padding:'0 10 10 0',
								flex:1,
								id:'healthChrt',
								layout:{
									type:'column',
									align:'stretch'
								},
								defaults:{
									columnWidth:.5,
								},
								items:[
								{
									xtype:'container',
									cls:'graphSeperatorLineBottomRight',
									padding:'0 30 20 20',
									margin:'0 0 0 10', 
									html:logon_dounutHealth
								}]
							});
							if(enableEnumulation){
								Ext.getCmp('healthChrt').add(
								{
									xtype:'container',
									cls:'graphSeperatorLineBottom',
									padding:'0 20 20 30',
									html:enum_dounutHealth
								});
							}
							Ext.getCmp('healthChrt').add(
							{
								xtype:'container',
								cls:'graphSeperatorLineRight',
								padding:'0 30 0 20',
								html:appLadounutHealth
							});
							if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
							{
								var logondonutGraphs = {};
								logondonutGraphs = jQuery.extend(true,{},getHighChartsBarInstance('logonHealth',jsonData.chartWidth,jsonData.chartHeight), logondonutGraphs);
								logondonutGraphs.setData(jsonData.logonDonutHealth,'','','donut');
								logondonutGraphs.drawChart();
								resultPanelObj.show();
							}
							if(enableEnumulation && checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
							{
								var enumdonutGraphs = {};
								enumdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('enumHealth',jsonData.chartWidth,jsonData.chartHeight), enumdonutGraphs);
								enumdonutGraphs.setData(jsonData.enumDonutHealth,'','','donut');
								enumdonutGraphs.drawChart(); 
								resultPanelObj.show();
							}
							if(checkData && !Ext.isEmpty(jsonData.total_appLaunchDonutHealth)&& jsonData.total_appLaunchDonutHealth!=undefined)
							{
								var appdonutGraphs = {};
								appdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('tot_appLaunchHealth',280,280), appdonutGraphs);
								appdonutGraphs.setData(jsonData.total_appLaunchDonutHealth,'','','donut');
								appdonutGraphs.drawChart(); 
								resultPanelObj.show();
							}
						}
					}
					else
					{
						this.disableTools();
						resultPanelObj.hide();
						var errorPanelId = Ext.getCmp('errorPanelId');
						var tableHtmlNo ='<table width="100%" height="100%" style="height:100%;" border="0px" ><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>';
						errorPanelId.add(
						{
							xtype:'container',
							html:tableHtmlNo,
							margin:'5 10 10 10',
							flex:1,
							cls:'selectionDetailsBorder selectionDetailsBg',
							layout:{
								type:'fit',
								align:'stretch'
							},
						});
						errorPanelId.show();
					}
				}
				else
				{
					this.disableTools();
					resultPanelObj.hide();
					var errorPanelId = Ext.getCmp('errorPanelId');
					var tableHtmlNo ='<table width="100%" height="100%" style="height:100%;" border="0px" ><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table>';
					errorPanelId.add(
					{
						xtype:'container',
						html:tableHtmlNo,
						margin:'5 10 10 10',
						flex:1,
						cls:'selectionDetailsBorder selectionDetailsBg',
						layout:{
							type:'fit',
							align:'stretch'
						},
					});
					errorPanelId.show();
				}
			}
		});
	},
	//- by Application Second page ends

	loadReportData:function(jsonData)
	{
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var me=this;
		var reportData=jsonData.reportData;
		var dataAvailable=false;
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
		resultPanelObj.setTitle("<span class='font_bold'>"+reportData.title+"</span>");
		resultPanelObj.show();
		Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		Ext.getCmp("thinclientapplication").doLayout();
		Ext.getCmp("thinclientapplication").doComponentLayout();
	},
	submitReport:function(){
		if(!isSettingsEnabled)
		this.showConfigDropdown();
		var url;
		var backgroundUrl;
		var csvbackgroundUrl;
		var Qstring;
		var mainForm = Ext.getCmp('mainform').getForm();
		var isValid = this.validateMainForm(true);
		if (isValid)
		{
			this.updateQStringUsage();
		}
		var setLegendVal='';
		if(isSettingsEnabled){
		var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined && islegendEnabled!='undefined')
			 setLegendVal = "&showLegend="+islegendEnabled;
		}
		else
			 setLegendVal = "&showLegend=true";
		Qstring=appConstants.queryStringUsage+setLegendVal;
		url="../servlet/com.eg.ErCtxLogonSimulator?isSubmit=true&responseType=json";
		backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&responseType=json";
		var resultPanelObj=Ext.getCmp('resultPanel');
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportGeneration=this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		var errorPanelId = Ext.getCmp('errorPanelId');
		errorPanelId.hide();
		this.getBackGroundPanel().hide();
		Qstring += '&er_RmDispName='+appConstants.er_RmDispName;
		if(reportGeneration == 'foreground')
		{
			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					appConstants.publicjsonDataUsage=jsonData;
					this.loadReportData(jsonData);
					if(targetType == 'applicationBased')
					{
						this.loadGridforApp(jsonData);
					}
					else
					{
						this.loadGrid(jsonData);
					}
				}
			});
		}
		else if(reportGeneration == 'background')
		{
			resultPanelObj.hide();
			var htmlStr = '';
			var me=this;
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					publicjsonData=jsonData;
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					var bgGroundMsg=jsonData.bgGroundMsg;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success')
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass='iconSuccess';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
						else if(backgroundReportStatus== 'duplicate'|| (bgGroundMsg!=null))
						{
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgGroundMsg+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>';
							//var statusCssClass = 'iconExists';
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
						}
					}
					else
					{
						htmlStr = '<span>ErroR In BackGround Generation</span>';
					}
					me.getBackGroundPanel().update(htmlStr);
					me.getBackGroundPanel().show();
				}
			});
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		var reportGenType=thinclientSettingsForm.findField('reportGeneration').getValue();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
		if(reportGenType== 'background'){
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(reportGenType== 'background-csv'){
			thinclientSettingsForm.findField('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}

		else{

			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonDataActivity.screenLabels['MappedExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	updateQStringUsage:function(){
		var FormParams='';
		var hiddenfieldQString='';
		var timelineParams;
		var timePeriodParams;
		var compArray=new Array();
		var mainForm =Ext.getCmp('mainform').getForm();
		var thinclientSettingsForm =null;
		if(isSettingsEnabled)
			thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		compArray=Ext.getCmp("er_server").getValue();

		var er_location=Ext.getCmp("er_location").getValue();
		appConstants.er_location=appConstants;
		if(appConstants.isFourthPage!=null && appConstants.isFourthPage=="true" && appConstants.isNavigation!=null && appConstants.isNavigation=='false' && appConstants.isFifthPage!=null && appConstants.isFifthPage=="true" && appConstants.isThirdPage!=null && appConstants.isThirdPage=="true")
		{
			FormParams='';
		}
		else
		{
			if(appConstants.isFourthPage!=null && appConstants.isFourthPage!="false" && appConstants.isNavigation!=null && appConstants.isNavigation!='true' && appConstants.isFifthPage!=null && appConstants.isFifthPage!="false" && appConstants.isThirdPage!=null && appConstants.isThirdPage!="false")
			{
				FormParams ="&pageNo=0";
			}
		}
		if (targetType!=null && targetType!=undefined && targetType=='applicationBased' && appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes')
		{
			FormParams+='&fromLoc=yes'
		}
		else
		{
			FormParams+='&fromLoc=no'
		}
		FormParams+="&er_trgttype="+targetType+"&er_compType=" + mainForm.findField("er_compType").getValue()+ "&er_reportgenration=" + this.getSettingsFieldValue(thinclientSettingsForm,'reportGeneration',isSettingsEnabled,'reportGeneration');
		FormParams+='&isNeedBack='+appConstants.isNeedBack;
		if(targetType == 'applicationBased')
		{
			if (appConstants.isFromBack)
			{
				var component =Ext.getCmp('er_applicationX');
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(jsonData.applnCombo);
				component.setValue(jsonData.applnCombo[0].valueField);
				this.appOnChange();
			}
			FormParams+="&er_applicationX=" + encodeURIComponent(mainForm.findField("er_applicationX").getValue());
			if (targetType!=null && targetType!=undefined && targetType=='applicationBased' && appConstants.fromLoc!=undefined && appConstants.fromLoc=='yes')
			{
				//appConstants.queryStringUsage+="&fromLoc=yes";
			}
		}
		else
		{
			FormParams+="&er_location=" + encodeURIComponent(mainForm.findField("er_location").getValue());
		}
		var erOption=Ext.getCmp('er_option');
		if(erOption!=undefined)
		{
			FormParams+="&er_option="+erOption.getValue();
			if(erOption.getValue()=='Zone')
			{
				var zoneval=mainForm.findField("select_farm").getValue();
				FormParams+="&er_zone="+zoneval;
			}
			else if (erOption.getValue()=='Segment'||erOption.getValue()=='Service') 
			{
				var erSite=Ext.getCmp('er_site');
				FormParams+="&er_site="+erSite.getValue();
			}
		}
		if(Ext.get('showLegend')!=null)
			FormParams=FormParams+"&showLegend="+ mainForm.findField('showLegend').getValue();
		for(var k=0;compArray.length>k;k++)
		{
			FormParams+="&er_component="+compArray[k];
		}
		if(isSettingsEnabled)
		{
			var valueFor=Ext.getCmp('uppermajor').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&uppermajor='+valueFor;
			valueFor=Ext.getCmp('upperminor').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperminor='+valueFor;
			valueFor=Ext.getCmp('upperCritical').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperCritical='+valueFor;
			valueFor=Ext.getCmp('uppermajor_enum').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&uppermajor_enum='+valueFor;
			valueFor=Ext.getCmp('upperminor_enum').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperminor_enum='+valueFor;
			valueFor=Ext.getCmp('upperCritical_enum').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperCritical_enum='+valueFor;
			valueFor=Ext.getCmp('uppermajor_appl').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&uppermajor_appl='+valueFor;
			valueFor=Ext.getCmp('upperminor_appl').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperminor_appl='+valueFor;
			valueFor=Ext.getCmp('upperCritical_appl').getValue();
			if(!Ext.isEmpty(valueFor))
				FormParams+='&upperCritical_appl='+valueFor;
		}
		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
		var timefrom =this.getSettingsFieldValue(thinclientSettingsForm,'timefrom',isSettingsEnabled,'selectedTimeFrom');
		var minfrom =this.getSettingsFieldValue(thinclientSettingsForm,'minfrom',isSettingsEnabled,'selectedMinsFrom');
		var timeto =this.getSettingsFieldValue(thinclientSettingsForm,'timeto',isSettingsEnabled,'selectedTimeTo');
		var minto =this.getSettingsFieldValue(thinclientSettingsForm,'minto',isSettingsEnabled,'selectedMinsTo');
		var timperiodParams="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

		var selectedCompnt = Ext.getCmp("er_server").getValue();
		var selectedLoc = Ext.getCmp("er_location").getValue();
		var selectedApp = Ext.getCmp("er_applicationX").getValue();

		if(appConstants.publicjsonDataUsage.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataUsage.hiddenfields;
			for (var hiddenField in hiddenFields) 
			{
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		var loc = Ext.getCmp("er_location").getValue();
		var appN = Ext.getCmp("er_applicationX").getValue();
		var strprintPageIdentify = "";
		if (targetType!=null && appConstants.isThirdPage!=undefined && appConstants.isThirdPage!='true' && ((loc!=undefined && loc=='all')|| (appN!=undefined && appN=='All')))
		{
			if (targetType=='locationBased')
			{
				printPageIdentify='&printPageIdentify=locMainTable';
			}
			else
				printPageIdentify='&printPageIdentify=appMainTable';
		}
		//if (targetType!=null && targetType=='locationBased' && appConstants.isFourthPage!='true' && appConstants.isFifthPage!='true')
		if (targetType!=null && targetType=='locationBased' && appConstants.isFourthPage!='true' && appConstants.isFifthPage!='true' && loc!=undefined && loc!='all' )//..
		{
			printPageIdentify='&printPageIdentify=locFirstPage';
		}
		if (appConstants.isFourthPage!=undefined && appConstants.isFourthPage=='true')
		{
			printPageIdentify='&isFourthPage=true&printPageIdentify=locSecondPage';
		}
		if (appConstants.isFifthPage!=undefined && appConstants.isFifthPage=='true')
		{
			printPageIdentify='&isFifthPage=true&printPageIdentify=locThirdPage';
		}
		if ((appConstants.isThirdPage!=undefined && appConstants.isThirdPage=='true') || (selectedApp!=undefined && selectedApp!='All'))
		{
			printPageIdentify='&printPageIdentify=appSecondPage';
		}
		if (appConstants.commonPage!=null && appConstants.commonPage!=undefined && appConstants.commonPage=='yes')
		{
			FormParams+='&commonPage=yes';
			printPageIdentify='&printPageIdentify=commonPage';
		}
		FormParams+=printPageIdentify;
		console.log("-------venkatesan@eginnovations.com-----------");
		if (appConstants.showPartial!=undefined && appConstants.showPartial!=null)
		{
			FormParams+="&checkFull="+appConstants.showPartial;
		}
		if (appConstants.byName==null)
		{
			appConstants.byName='no';
		}
		FormParams+="&byName="+appConstants.byName;
		
		FormParams+="&selectedLoc="+selectedLoc+"&selectedApp="+encodeURIComponent(selectedApp)+"&selectedCompnt="+selectedCompnt;
		if (targetType=='locationBased')
		{
			var appForAgent = Ext.getCmp('appForAgent').getValue();
			FormParams+="&appForAgent="+encodeURIComponent(appForAgent);
		}
		appConstants.queryStringUsage=FormParams+timelineParams+hiddenfieldQString+timperiodParams;
	},
	afterMainRender:function()
	{
		var thisController = this;
		this.refreshReportData(appConstants.publicjsonDataUsage);
	},
	loadFormElements:function() 
	{
		registerAjaxEvents();
		var component;
		var mainForm =Ext.getCmp('mainform').getForm();
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonDataUsage.reportTitle);
		
		this.fillFormFieldsForUsage(appConstants.publicjsonDataUsage);
		Ext.getCmp('egcomponent').show();
		if(!hideBackButton){
			Ext.getCmp('thinclientapplicationform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonDataUsage['ID']
				}
			);
		}
		jsonData = appConstants.publicjsonDataUsage
		var screenLabels = jsonData.screenLabels;
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var er_option=mainForm.findField('er_option');
		er_option.getStore().loadRawData(jsonData.analysisByCombo);
		if (!Ext.isEmpty(jsonData.selectedAnalysisByCombo))
		{
			er_option.setValue(jsonData.selectedAnalysisByCombo);
		}
		else
		{
			if(jsonData.analysisByCombo!=undefined)
			er_option.setValue(jsonData.analysisByCombo[0].valueField);
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		if (appConstants.forceSubmit=='true')
		{
			this.showResult();
			appConstants.forceSubmit='false';
		}
	},
	refreshReportData:function(jsonData){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.gridColStateParam='ASC';
			this.gridColIndexParam=jsonData.selectedSort;
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
		if((appConstants.isThirdPage!=undefined && appConstants.isThirdPage=="true") || (appConstants.isFourthPage!=undefined && appConstants.isFourthPage=="true") || (appConstants.isFifthPage!=undefined && appConstants.isFifthPage=="true") || (appConstants.isSubmit!=null && appConstants.isSubmit=="true"))
		{
			var component;
			var er_applicationX = Ext.getCmp("er_applicationX").getValue();
			component=Ext.getCmp('er_location');
			component.getStore().clearFilter(true); 
			component.getStore().loadRawData(jsonData.locationCmbo);
			component.setValue(jsonData.locationselectOptions.selectedLocationsType);
			var er_location = Ext.getCmp("er_location").getValue();
			component = Ext.getCmp("er_server");
			var totalComponents = jsonData.componentCombo;
			var selectedComponents = jsonData.selectedComponents;
			component.getStore().loadRawData(totalComponents);
			appConstants.rawDataForComponents = totalComponents;
			if (!Ext.isEmpty(selectedComponents))
			{
				component.setValue(selectedComponents);
			} 
			else if(!Ext.isEmpty(totalComponents))
			{
				component.setValue(totalComponents[0].valueField);
			}
			else
			{
				component.setValue("-1");
			}
			this.submitReport();
		} 
	},

	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		
		var isSettingsOk = this.validateSettings();
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if(isSettingsOk)
		{
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		
	},
	loadSettingsElements: function()
	{
		var hiddenFields =  '';
		var favorite_id='';
		hiddenFields=appConstants.publicjsonDataUsage['hiddenfields'];
		favorite_id=hiddenFields["favorite_id"];
		Ext.getCmp('moreOptionCloseId').show();
		if(!Ext.isEmpty(favorite_id))
		{
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var thinclientSettingsForm = this.getThinclientapplicationsettings().getForm();
		jsonData = appConstants.publicjsonDataUsage
		var screenLabels=jsonData.screenLabels;
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		updatingAppSettings();

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);
		var thisController = this;
		Ext.EventManager.onWindowResize(function()
		{
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function()
		{
			thisController.validateAndCloseSettings();
		});
		thinclientSettingsForm.findField("er_excwe").hide();
		if(targetType == 'applicationBased')
		{
			var er_applicationX = Ext.getCmp("er_applicationX").getValue();
			if (er_applicationX!=undefined && er_applicationX!='All')
			{
				if (isSettingsEnabled)
				{
					Ext.getCmp('lowLimitLbl').hide();
					Ext.getCmp('lowLimitLbl_enum').hide();
					Ext.getCmp('lowLimitLbl_appl').hide();
					Ext.getCmp('logonStatusSepId').hide();
				}
			}
			else
			{
				if (isSettingsEnabled)
				{
					Ext.getCmp('lowLimitLbl').show();
					Ext.getCmp('lowLimitLbl_enum').show();
					Ext.getCmp('lowLimitLbl_appl').show();
					Ext.getCmp('logonStatusSepId').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
					Ext.getCmp('lowLimitLbl_enum').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor_enum').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor_enum').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical_enum').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
					Ext.getCmp('lowLimitLbl_enum').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor_appl').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor_appl').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical_appl').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
				}
			}
		}
		else
		{
			var er_location = Ext.getCmp("er_location").getValue();
			if (er_location!=undefined && er_location!='all')
			{
				if (isSettingsEnabled)
				{
					Ext.getCmp('lowLimitLbl').hide();
					Ext.getCmp('lowLimitLbl_enum').hide();
					Ext.getCmp('lowLimitLbl_appl').hide();
					Ext.getCmp('logonStatusSepId').hide();
				}
			}
			else
			{
				if (isSettingsEnabled)
				{
					Ext.getCmp('lowLimitLbl').show();
					Ext.getCmp('lowLimitLbl_enum').show();
					Ext.getCmp('lowLimitLbl_appl').show();
					Ext.getCmp('logonStatusSepId').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor').setStyle('background-color',jsonData.minorColor);
					Ext.getCmp('lowLimitLbl_enum').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor_enum').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor_enum').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical_enum').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical_enum').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor_enum').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor_enum').setStyle('background-color',jsonData.minorColor);
					Ext.getCmp('lowLimitLbl_enum').show();
					if(!Ext.isEmpty(jsonData.majorValue))
						Ext.getCmp('uppermajor_appl').setValue(jsonData.majorValue);
					if(!Ext.isEmpty(jsonData.minorValue))
						Ext.getCmp('upperminor_appl').setValue(jsonData.minorValue);
					if(!Ext.isEmpty(jsonData.criticalValue))
						Ext.getCmp('upperCritical_appl').setValue(jsonData.criticalValue);
					if(!Ext.isEmpty(jsonData.criticalColor))
					Ext.get('upperCritical_appl').setStyle('background-color',jsonData.criticalColor);
					if(!Ext.isEmpty(jsonData.majorColor))
						Ext.get('uppermajor_appl').setStyle('background-color',jsonData.majorColor);
					if(!Ext.isEmpty(jsonData.minorColor))
						Ext.get('upperminor_appl').setStyle('background-color',jsonData.minorColor);
				}
			}
		}
	},
	showConfigDropdown:function(){
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
			Ext.create('Ext.container.Container',{
				width:565,
				//padding:5,
				id:'configMod',
				//cls:'configMode_popup',
				ui:'settingsWindowContainer',
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'355px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'0px'},
						cls:'containerHeader'
					},
					{
						xtype : 'thinclientapplicationsettings',
						parent:this
					}
				],
				renderTo:'thinclientapplication'
		});
	},
	expandMeUsage:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('systemLabel').text,btn);
	},
	expandMeActivity:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_server'),Ext.getCmp('multiSelectLabel').text,btn);
	},
	getSettingsFieldValue:function(formObj,id,isEnabled,jsonParam)
	{
		var publicJsonData=null;
		publicJsonData = appConstants.publicjsonDataUsage
		var value='';
		if(isEnabled)
		{
			var item_field = formObj.findField(id);
			if(!Ext.isEmpty(item_field))
			{
				value = item_field.getValue();
			}
		}
		else
		{
			if(publicJsonData!=null)
				value = publicJsonData[jsonParam];
		}
		return value;
	},
	insideBackButton:function(bNum,hiddenStatus)
	{
		for (var i=1;i<7;i++)
		{
			if (i==bNum)
			{
				if (hiddenStatus)
				{
					Ext.getCmp("bckButton_"+i).hide();
				}
				else
				{
					Ext.getCmp("bckButton_"+i).show();
				}
			}
			else
			{
				Ext.getCmp("bckButton_"+i).hide();
			}
		}
	},
	goTotalGraphs:function(url,isFromBack,fromWhere)
	{
		appConstants.showPartial = fromWhere;
		appConstants.commonPage='yes';
		url+="&commonPage=yes&checkFull="+fromWhere+"&byName="+fromWhere;
		appConstants.printPageIdentify='commonPage';
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locMainTable",appConstants.printPageIdentify);
		appConstants.queryStringUsage=appConstants.queryStringUsage.replace("locFirstPage",appConstants.printPageIdentify);
		var meController = this;
		var paramsForDrillDown = url.substring(url.indexOf("?")+1);
		var controller = url.substring(0,url.indexOf("?"));
		var locName = Ext.getCmp('er_location').getValue();
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		var tot_summary_data ='';
		Ext.Ajax.request(
		{
			url : controller,
			params : paramsForDrillDown+"&responseType=json",
			method :'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonDataUsage=jsonData;
				var component = Ext.getCmp("er_server");
				var totalComponents = jsonData.componentCombo;
				var selectedComponents = jsonData.selectedComponents;
				appConstants.rawDataForComponents = totalComponents;
				component.getStore().loadRawData(totalComponents);
				if (!Ext.isEmpty(selectedComponents))
				{
					component.setValue(selectedComponents);
				} 
				else if(!Ext.isEmpty(totalComponents))
				{
					component.setValue(totalComponents[0].valueField);
				}
				else
				{
					component.setValue("-1");
				}
				var comboRawData = jsonData.applnCombo;
				var selectedComboOption = jsonData.selectedAppln;
				component = Ext.getCmp("appForAgent");
				component.getStore().clearFilter(true); 
				component.getStore().loadRawData(comboRawData);
				if(appConstants.isThirdPage!=null && appConstants.isThirdPage=="true" && !Ext.isEmpty(jsonData.selectedapplicationX))
				{
					component.setValue(jsonData.selectedapplicationX);
				}
				else if (!Ext.isEmpty(selectedComboOption) && appConstants.isThirdPage!=null && appConstants.isThirdPage!="true") 
				{
					component.setValue(selectedComboOption);
				}
				else 
				{
					component.setValue(comboRawData[0].valueField);
				}
				var enableEnumulation = jsonData.enableEnumulation
				var checkData = jsonData.checkData
				var firstPageData = jsonData.secondPageData;
				var totalLogon = firstPageData['summaryList']['totalLogon'];
				var successLogon = firstPageData['summaryList']['successLogon'];
				var failLogon = firstPageData['summaryList']['failLogon'];
				var failEnum = firstPageData['summaryList']['failedEnum'];
				var failedSimu = firstPageData['summaryList']['failedSimu'];
				var failedApp = firstPageData['summaryList']['failedApp'];

				tot_summary_data += '<div style="margin:10px auto 0px auto;height:150px;"><table border="0px" height="100%"><tr><td align="right" valign="middle"><div  id="tot_donuts_id" ></div></td>';
				tot_summary_data += '<td align="center" valign="middle">';
				if (totalLogon>0)
				{
					if (jsonData.donSucc!=undefined && jsonData.donSucc!=null)
					{
						tot_summary_data += '<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#32B395;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donSucc+'</td></tr></table></div>';
					}
					if (jsonData.donFail!=undefined && jsonData.donFail!=null) 
					{
						tot_summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#EF7672;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donFail+'</td></tr></table></div>';
					}
					if (jsonData.donEnum!=undefined && jsonData.donEnum!=null)
					{
						tot_summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F8ABA7;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donEnum+'</td></tr></table></div>';
					}
					if (jsonData.donSimu!=undefined && jsonData.donSimu!=null)
					{
						tot_summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#DE4640;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donSimu+'</td></tr></table></div>';
					}
					if (jsonData.donfApp!=undefined && jsonData.donfApp!=null)
					{
						tot_summary_data +='<div style="float:left"><table><tr><td valign="top" style="padding:3px"><div style="background-color:#F7BD42;height:8px;width:8px;">&nbsp;</div></td><td style="padding:0px 20px 5px 5px;" class="newFont_normal11_Legend" valign="top">'+jsonData.donfApp+'</td></tr></table></div>';
					}
				}
				tot_summary_data +='</td></tr></table></div>';
				initLdgMask.hide();
				var hideEnumData=true;
				if(enableEnumulation)
					hideEnumData=false
				this.insideBackButton(5,false);
				resultPanelObj.add({
					xtype: 'panel',
					layout:'column',
					margin:'10 10 0 10',
					ui:'newGraphPanel',
					//title:'Overview of Simulations - '+jsonData.selectedLocation,
					title:overviewOfSimsLabel+'<span class="f13-normal" style="margin-left:20px">('+simulatorLabel+' : '+jsonData.selectedComponents+', '+externalAgentLabel+' : '+jsonData.selectedLocation+')</span>',
					padding:0,
					bodyPadding:0,
					items:[
					{
						xtype:'container',
						columnWidth:.7,
						padding:'6 5 0 5',
						layout:{
							type:'column',
							align:'center',
							pack:'center'
						},
						defaults:{
							columnWidth:.33,
							padding:'10 10 0 10',
						},
						items:[{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconTotalSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+totalLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+totalSimulationsLabel+'</span></td></tr></table>'
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconSuccessfulSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+successLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+succuessSimulationsLabel+'</span></td></tr></table>'
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconFailedSimulations"/></div><div class="newFont_bold28" style="margin:5px;">'+failedSimu+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+failedSimulationsLabel+'</span></td></tr></table>'
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconLogonFailed"/></div><div class="newFont_bold28" style="margin:5px;">'+failLogon+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+failedWebLogonsLabel+'</span></td></tr></table>'
							}]
						}, 
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							hidden:hideEnumData,
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconFailedEnumeration"/></div><div class="newFont_bold28" style="margin:5px;">'+failEnum+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+failedEnumerationsLabel+'</span></td></tr></table>'
							}]
						},{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							items:[{
								xtype:'container',
								html:'<table align="center"><tr><td align="center" nowrap><div class="egFlexCenterByRowWise"><div class="iconFailedAppLaunch"/></div><div class="newFont_bold28" style="margin:5px;">'+failedApp+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:0px 5px 10px 5px"><span class="newFont_normal13">'+failedApplnDesktopLabel+'</span></td></tr></table>'
							}]
						}]
					},{
						xtype:'container',
						columnWidth:.3,
						html:tot_summary_data,
					}]
				});
				initLdgMask.hide();
				resultPanelObj.show();
				if(checkData && !Ext.isEmpty(jsonData.donutChartforApp) && jsonData.donutChartforApp!=undefined)
				{
					var donutGraphs = {};
					donutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('tot_donuts_id',150,150), donutGraphs);
					donutGraphs.setData(jsonData.donutChartforApp,'','','donut');
					donutGraphs.drawChart(); 
				}
				var dounutHealth ='';
				if(isFromBack=='true')
				{
					appConstants.fromAppLaunchIcon='no';
				}
				else
				{
					appConstants.fromAppLaunchIcon='yes';
				}
				if (fromWhere!=undefined  && (fromWhere=='fromLogon' || fromWhere=='full'))
				{
					if (fromWhere=='full')
					{
						appConstants.checkFull='full'
					}
					else
						appConstants.byName='fromLogon';
					if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
					{
						dounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+webLogonHealthPercLabel+'</div><div id="logonHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
						dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
						if (jsonData.lg_Critical!=undefined && jsonData.lg_Critical!=null)
						{
							dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.lg_Critical+'</td></tr>';
						}
						if (jsonData.lg_Major!=undefined && jsonData.lg_Major!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.lg_Major+'</td></tr>';
						}
						if (jsonData.lg_Minor!=undefined && jsonData.lg_Minor!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.lg_Minor+'</td></tr>';
						}
						if (jsonData.lg_Normal!=undefined && jsonData.lg_Normal!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.lg_Normal+'</td></tr>';
						}
						if (jsonData.lg_Unkown!=undefined && jsonData.lg_Unkown!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unknown - '+jsonData.lg_Unkown+'</td></tr>';
						}
						dounutHealth +='</tbody></table></td></tr></table></div>';
					}
					else
					{
						dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+webLogonHealthPercLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var html_q ='';
					if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
					{
						html_q = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocLogonAvail" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
					}
					else
					{
						html_q = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var html_w='';
					if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
					{
						html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocLogonDura" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
					}
					else
					{
						html_w = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					resultPanelObj.add({
						xtype: 'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						title:webLogonDetailsLabel,
						bodyPadding: '0 0 0 0',
						padding:'0 10 10 0',
						flex:1,
						layout:{
							type:'column',
							align:'stretch'
						},
						defaults:{
							columnWidth:.5
						},
						items:[
						{
							xtype:'container',
							cls:'graphSeperatorLineBottomRight',
							padding:'0 30 0 20',
							margin:'0 0 0 10',
							html:html_q
						},{
							xtype:'container',
							cls:'graphSeperatorLineBottom',
							padding:'0 20 0 30',
							html:html_w
						},{
							xtype:'container',
							cls:'graphSeperatorLineRight',
							padding:'0 30 0 20',
							html:dounutHealth
						}]
					});
					if(checkData && !Ext.isEmpty(jsonData.appLogonAvail)&& jsonData.appLogonAvail!=undefined)
					{
						var appForLogonAvail = {};
						appForLogonAvail = jQuery.extend(true,{}, getHighChartsInstance('appLocLogonAvail',jsonData.appLogonAvail.chartHeight,jsonData.appLogonAvail.chartWidth), appForLogonAvail);
						appForLogonAvail.setData(jsonData.appLogonAvail,'MMM dd, yyyy','');
						appForLogonAvail.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.appLogonDura)&& jsonData.appLogonDura!=undefined)
					{
						var appForLogonDura = {};
						appForLogonDura = jQuery.extend(true,{}, getHighChartsInstance('appLocLogonDura',jsonData.appLogonDura.chartHeight,jsonData.appLogonDura.chartWidth), appForLogonDura);
						appForLogonDura.setData(jsonData.appLogonDura,'MMM dd, yyyy','');
						appForLogonDura.drawChart();
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.logonDonutHealth)&& jsonData.logonDonutHealth!=undefined)
					{
						var logondonutGraphs = {};
						logondonutGraphs = jQuery.extend(true,{},getHighChartsBarInstance('logonHealth',jsonData.chartWidth,jsonData.chartHeight), logondonutGraphs);
						logondonutGraphs.setData(jsonData.logonDonutHealth,'','','donut');
						logondonutGraphs.drawChart();
						resultPanelObj.show();
					}
				}
				if (enableEnumulation && fromWhere!=undefined && (fromWhere=='fromEnum' || fromWhere=='full'))
				{
					if (fromWhere=='full')
					{
						appConstants.checkFull='full'
					}
					else
						appConstants.byName='fromEnum';
					//Enumeration
					var e_dounutHealth = ''
					if(checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
					{
						e_dounutHealth ='<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:5px" class="newFont_bold13">'+enumHealthPercLabel+'</div><div id="enumHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
						e_dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
						if (jsonData.enum_Critical!=undefined && jsonData.enum_Critical!=null)
						{
							e_dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.enum_Critical+'</td></tr>';
						}
						if (jsonData.enum_Major!=undefined && jsonData.enum_Major!=null)
						{
							e_dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.enum_Major+'</td></tr>';
						}
						if (jsonData.enum_Minor!=undefined && jsonData.enum_Minor!=null)
						{
							e_dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.enum_Minor+'</td></tr>';
						}
						if (jsonData.enum_Normal!=undefined && jsonData.enum_Normal!=null)
						{
							e_dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.enum_Normal+'</td></tr>';
						}
						if (jsonData.enum_Unkown!=undefined && jsonData.enum_Unkown!=null)
						{
							e_dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.enum_Unkown+'</td></tr>';
						}
						e_dounutHealth +='</tbody></table></td></tr></table></div>';
					}
					else
					{
						e_dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+enumHealthPercLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
					}
					var html_e ='';
					var sec_padding;
					if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
					{
						sec_padding = '0 20 0 30';
						html_e = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="appLocEnumAvail" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
					}
					else
					{
						sec_padding = '0 20 20 30';
						html_e = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
					}
					var html_r ='';
					var secPadd;
					if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
					{
						sec_padding = '0 20 0 30';
						html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="appLocEnumDura" style="height:250px;width:100%;overflow:auto;padding:0px"></div>'
					}
					else
					{
						sec_padding = '0 20 0 30';
						html_r = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available </div></td></tr></table></div>';
					}
					resultPanelObj.add({
						xtype: 'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						title:enumerationDetailsLabel,
						bodyPadding: '0 0 0 0',
						padding:'0 10 10 0',
						flex:1,
						layout:{
							type:'column',
							align:'stretch'
						},
						defaults:{
							columnWidth:.5
						},
						items:[
						{
							xtype:'container',
							cls:'graphSeperatorLineBottomRight',
							padding:'0 30 0 20',
							margin:'0 0 0 10',
							html:html_e
						},{
							xtype:'container',
							cls:'graphSeperatorLineBottom',
							padding:sec_padding,
							html:html_r
						},{
							xtype:'container',
							cls:'graphSeperatorLineRight',
							padding:'0 30 0 20',
							html:e_dounutHealth
						}]
					});
					if(checkData && !Ext.isEmpty(jsonData.appEnumAvail)&& jsonData.appEnumAvail!=undefined)
					{
						var appForEnumAvail = {};
						appForEnumAvail = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumAvail',jsonData.appEnumAvail.chartHeight,jsonData.appEnumAvail.chartWidth), appForEnumAvail);
						appForEnumAvail.setData(jsonData.appEnumAvail,'MMM dd, yyyy','');
						appForEnumAvail.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.appEnumDura)&& jsonData.appEnumDura!=undefined)
					{
						var appForEnumDura = {};
						appForEnumDura = jQuery.extend(true, {}, getHighChartsInstance('appLocEnumDura',jsonData.appEnumDura.chartHeight,jsonData.appEnumDura.chartWidth), appForEnumDura);
						appForEnumDura.setData(jsonData.appEnumDura,'MMM dd, yyyy','');
						appForEnumDura.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.enumDonutHealth)&& jsonData.enumDonutHealth!=undefined)
					{
						var enumdonutGraphs = {};
						enumdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('enumHealth',jsonData.chartWidth,jsonData.chartHeight), enumdonutGraphs);
						enumdonutGraphs.setData(jsonData.enumDonutHealth,'','','donut');
						enumdonutGraphs.drawChart(); 
						resultPanelObj.show();
					}
				}
				if (fromWhere!=undefined && (fromWhere=='fromApp' || fromWhere=='full'))
				{
					if (fromWhere=='full')
					{
						appConstants.checkFull='full'
					}
					else
						appConstants.byName='fromApp';
					//Application Launch
					dounutHealth='';
					if(checkData && !Ext.isEmpty(jsonData.total_appLaunchDonutHealth)&& jsonData.total_appLaunchDonutHealth!=undefined)
					{
						dounutHealth = '<div><table width="100%" ><col width="70%"><col width="30%"> <tr><td ><div style="text-align:center;padding:12px" class="newFont_bold13">'+applnDektopHealthPercLabel+'</div><div id="tot_appLaunchHealth" style="height:200px;width:100%;overflow:auto;padding:0px"></div></td>';
						dounutHealth += '<td><table align="left" cellpadding="0" cellspacing="0" border="0"><tbody>';
						if (jsonData.tot_app_Critical!=undefined && jsonData.tot_app_Critical!=null)
						{
							dounutHealth += '<tr><td><div style="background-color:#CC0000;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Critical - '+jsonData.tot_app_Critical+'</td></tr>';
						}
						if (jsonData.tot_app_Major!=undefined && jsonData.tot_app_Major!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#FA9D1C;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Major - '+jsonData.tot_app_Major+'</td></tr>';
						}
						if (jsonData.tot_app_Minor!=undefined && jsonData.tot_app_Minor!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#CCC100;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Minor - '+jsonData.tot_app_Minor+'</td></tr>';
						}
						if (jsonData.tot_app_Normal!=undefined && jsonData.tot_app_Normal!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#457E08;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Normal - '+jsonData.tot_app_Normal+'</td></tr>';
						}
						if (jsonData.tot_app_Unkown!=undefined && jsonData.tot_app_Unkown!=null)
						{
							dounutHealth +='<tr><td><div style="background-color:#49909F;height:8px;width:8px;">&nbsp;</div></td><td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal11_Legend">Unkown - '+jsonData.tot_app_Unkown+'</td></tr>';
						}
						dounutHealth +='</tbody></table></td></tr></table></div>';
					}
					else
					{
						dounutHealth = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+applnDektopHealthPercLabel+'</div><div style="height:250px;width:100%;overflow:auto;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var html_t ='';
					
					if(checkData && !Ext.isEmpty(jsonData.totalAppAvail)&& jsonData.totalAppAvail!=undefined)
					{
						html_t = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+availabilityLabel+'</div><div id="tot_appLaunchAvailTime_id" style="height:200px;width:100%;overflow:hidden;padding:0px"></div>'
					}
					else
					{ 
						html_t = '<div style="text-align:center;padding:5px" class="newFont_bold13">&nbsp;'+availabilityLabel+' </div><div style="height:200px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					var html_y ='';
					var paddin_2 = '0 20 20 30';
					if(checkData && !Ext.isEmpty(jsonData.totalAppDura)&& jsonData.totalAppDura!=undefined)
					{
						html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">'+durationLabel+'</div><div id="tot_appLaunchDurationTime_id" style="height:200px;width:100%;overflow:hidden;padding:0px"></div>'
					}
					else
					{
						paddin_2 = '0 20 20 30';
						html_y = '<div style="text-align:center;padding:12px" class="newFont_bold13">&nbsp;'+durationLabel+'</div><div style="height:200px;width:100%;overflow:hidden;padding:0px"><table width="100%" height="100%" style="height:100%;"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Measures Available</div></td></tr></table></div>';
					}
					resultPanelObj.add({ 
						xtype: 'panel',
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						title:applnDesktopDetailsLabel,
						bodyPadding: '0 0 0 0',
						padding:'0 10 10 0',
						flex:1,
						layout:{
							type:'column',
							align:'stretch'
						},
						defaults:{
							columnWidth:.5,
						},
						items:[
						{
							xtype:'container',
							cls:'graphSeperatorLineBottomRight',
							height:305,
							items:[
							{
								xtype:'container',
								id:'tot_appLaunchAvailTime_id_GraphPanel',
								margin:'0 10 0 10',
								html: html_t
							},
							{
								xtype:'container',
								id:'tot_appLaunchAvailTime_id_legendPanel',
								margin:'0 10 15 0',
								height:55,
								style:{'overflow':'hidden'},
							}]
						},{
							xtype:'container',
							cls:'graphSeperatorLineBottom',
							height:305,
							items:[
							{
								xtype:'container',
								id:'tot_appLaunchDurationTime_id_GraphPanel',
								margin:'0 10 0 10',
								html: html_y
							},
							{
								xtype:'container',
								id:'tot_appLaunchDurationTime_id_legendPanel',
								margin:'0 0 15 0',
								height:55,
								style:{'overflow':'hidden'},
							}]
						},{
							xtype:'container',
							cls:'graphSeperatorLineRight',
							padding:'0 30 0 20',
							html:dounutHealth
						}]
					});
					if(checkData && !Ext.isEmpty(jsonData.totalAppAvail)&& jsonData.totalAppAvail!=undefined)
					{
						var appLaunchTimeAvai = {};
						appLaunchTimeAvai = jQuery.extend(true, {}, getHighChartsInstance('tot_appLaunchAvailTime_id',jsonData.totalAppAvail.chartHeight,jsonData.totalAppAvail.chartWidth), appLaunchTimeAvai);
						appLaunchTimeAvai.setData(jsonData.totalAppAvail,'MMM dd, yyyy','');
						appLaunchTimeAvai.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.totalAppDura)&& jsonData.totalAppDura!=undefined)
					{
						var appLaunchTimeDura = {};
						appLaunchTimeDura = jQuery.extend(true, {}, getHighChartsInstance('tot_appLaunchDurationTime_id',jsonData.totalAppDura.chartHeight,jsonData.totalAppDura.chartWidth), appLaunchTimeDura);
						appLaunchTimeDura.setData(jsonData.totalAppDura,'MMM dd, yyyy','');
						appLaunchTimeDura.drawChart(); 
						resultPanelObj.show();
					}
					if(checkData && !Ext.isEmpty(jsonData.total_appLaunchDonutHealth)&& jsonData.total_appLaunchDonutHealth!=undefined)
					{
						var appdonutGraphs = {};
						appdonutGraphs = jQuery.extend(true, {}, getHighChartsBarInstance('tot_appLaunchHealth',280,280), appdonutGraphs);
						appdonutGraphs.setData(jsonData.total_appLaunchDonutHealth,'','','donut');
						appdonutGraphs.drawChart(); 
						resultPanelObj.show();
					}
				}
			}
		});
		this.updateQStringUsage();
	},
});
