$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsGuage(container_Id,jsonData,fromPage)
{
	var errHtml = '<center><div style="margin:12% 0 auto 0"><img class="iconExclamation" src="/final/images/spacer.gif"/><div >No measures available</div></div></center>';
	if( Ext.isEmpty( jsonData ) )
	{
		//Ext.getCmp(container_Id).update(errHtml);
	}
	else
	{
		var chartType = jsonData['chartType'];
		var title = (Ext.isEmpty(jsonData['title']))?'':jsonData['title']; 
		var gaugeUnit = (Ext.isEmpty(jsonData['unit']) )?'':'('+jsonData['unit']+')'; 
		var gaugeTitle = title+' '+gaugeUnit;
		var fontColor = (Ext.isEmpty(jsonData['fontColor']))?'':jsonData['guageData']['fontColor'];
		var fontFamily = (Ext.isEmpty(jsonData['fontName']))?'Arial':jsonData['fontName'];
		var strSkinclr = (Ext.isEmpty(jsonData['strSkinclr']) )?'':jsonData['strSkinclr'];
		var isRoundBorder = (Ext.isEmpty(jsonData['isRoundBorder']))?false:jsonData['isRoundBorder'];
		var startAngle = (Ext.isEmpty(jsonData['startAngle']))?-90:jsonData['startAngle'];
		var endAngle = (Ext.isEmpty(jsonData['endAngle']))?90:jsonData['endAngle'];
		var dataObj = jsonData['DataSet'];

		console.log('dataObj ',dataObj)

		if(fontColor==null || fontColor=="" || fontColor=="null" || fontColor=="undefined")
		{
			fontColor='black';
		}
		if(fontFamily==null || fontFamily=="" || fontFamily=="null" || fontFamily=="undefined")
		{
			fontFamily='Arial';
		}
		var margTop=0;
		var mouseHand="default";

		var yaxisLabelFontColor = (strSkin == 'Light')?"#606060":'#c0c0c0';		
		var maxDialVal = 0;
		if(!Ext.isEmpty(jsonData['maxValueForDial']))
		{
			maxDialVal = parseInt(jsonData['maxValueForDial']);
		}
		else
		{
			maxValueForDial = 500;
		}
		var gaugeOptions = {
			chart: {
				type: chartType,
				renderTo: container_Id,
				backgroundColor:'transparent',
				plotBackgroundColor : 'transparent',
				marginTop: margTop,
				spacing:[10, 10, 10, 10]
			},
			title: null,
			exporting: 
			{
				enabled: false
			},
			credits:
			{
				enabled: false
			},
			tooltip: 
			{
				enabled: false
			},
			pane: {
				startAngle: startAngle,
				endAngle: endAngle,
				outerRadius: '112%',
				innerRadius: '88%',
				background: 
				{
					backgroundColor: Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0.0).get(),
					borderWidth: 0
				}
			},
			yAxis: 
			{
				min: 0,
				max: maxDialVal,
				lineWidth: 0,
				tickPositions: []
			},
			plotOptions: 
			{
				solidgauge: 
				{
					dataLabels: 
					{
						enabled: true,
						y: -10,
						borderWidth: 0,
						style: 
						{
							//color : fontColor,
							//fontFamily: fontFamily,
							//fontSize: '18px',
							textOutline: false,
							textShadow: false
						}
					},
					rounded:isRoundBorder
				}
			},
			series: dataObj
		};
		this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
		var highChartObj=new Highcharts.Chart(gaugeOptions);
		return highChartObj;
	}
}

(function (H){
	 H.Chart.prototype.reflow = function () {
		var task = new Ext.util.DelayedTask(function(){
			 var clientWidth=renderTo.clientWidth; 
		 var clientHeight=renderTo.clientHeight; 
			 chart.setSize(clientWidth, clientHeight, false);
		});

		var chart = this,
		renderTo = chart.renderTo;
		Ext.EventManager.onWindowResize(function () {
			var initialClientWidth=renderTo.clientWidth; 
			if (initialClientWidth!=0)
			task.delay(100);
		});
  };
}(Highcharts));