$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsBarInstance(container_Id,chartHeight,chartWidth){
	var drawChart = true;
	var isDoNut = false;
 var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			plotBorderWidth: 0,
			plotBorderColor : '#e5e5e5',
			backgroundColor:'#ffffff',
			plotBackgroundColor: 'white',
			plotShadow: false,
			placeValuesInside:0,
			shadow: false,
			zoomType:'xy',
			align:'center',
			ignoreHiddenSeries:false,
			events: {
				load: function(event) {
					$('.highcharts-legend-item rect').attr('height', '8').attr('y', '7');
					$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
				}
			}   
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
		    min: 0,
			border :0,
			//tickPixelInterval:75,
			reversedStacks: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontSize: '11px',
				},
			    formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					//var val_ar = val.split('.');
					val = (parseFloat(val));
					/*if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
						else if (val_ar[1].lastIndexOf("000")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,1);
						}else if (val_ar[1].lastIndexOf("00")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,2);
						}
					}*/
					return val;
				},
			},
			showLastLabel: true,
			tickPositioner: function(min,max){
				var act = min,
				ticks = [];
				this.tickAmount=1;
				var flag=false;
				var interval=this.tickInterval;
				var second=0;
				if(min==max)
				{
					if(max>1)
						max=max+1;
					else if(max==0){
						max=max+1;
						second=0
						flag=true;
					}
					else
					{
						max=max+0.1;
					}
				}
				var cc=1
				while(act <= max){
					if(cc==2 && flag)
						ticks.push(second);
					else
						ticks.push(act);
					act+= interval;
					cc++;
				}
				if(!flag)
					ticks.push(act);
			  return ticks;  
			},
		},
		scrollbar: {
			enabled: false
		},
		legend: {
			verticalAlign: 'top',
			align:'center',
			layout: 'horizontal',
			borderWidth: 0,
			symbolWidth: 14,
			symbolHeight: 6,
			squareSymbol: false,
			symbolRadius: 6,

			//y:5,
			//x:5,
			//width: 300,
			adjustChartSize: false,
			navigation: {
				arrowSize: 5
			},
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'normal',
				fontSize: '10px',
			},
		},
		labels :{
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'Normal',
				fontSize: '10px',
			},
		},
		tooltip: {
			borderColor: 'black',
			valueDecimals: 4,
			style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '10px',
				},
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
			type:'datetime',
			//tickPixelInterval:50,
			min: 0,
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
				overflow: 'justify',
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				useHTML: false,
			},
			title: {
				style: {
					color : '#636363',
					fontSize: '11px',
				},
			},
		},
		title: {
				text: '',
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '12px',
				}
			},
		series: {
		}
	},
	setData: function(jsonData,currentDateFormat,drilldownurl) {
 		var toolTipFmt = '';
		var chartType = 'bar';
	   	var setStacking='normal';
		var setMinPointLength=0;
		var setendOnTick=true;
		var enable_Format=jsonData['enable_Format'];
		var enable_values=jsonData['enable_values'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var customFormatForPieChart=jsonData['customFormatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";
		if(Ext.isEmpty(enable_Format))
		{
			enable_Format="";
			formatForPieChart='{point.name}';
		}else{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}
		if(enable_values != null && enable_values != 'undefined' && enable_values == 'true')
		{
			formatForPieChart='{point.y}';
		}
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
            formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		      formatForPieChart='{point.percentage:.1f} %';
		if(customFormatForPieChart!=undefined && customFormatForPieChart!='')
		{
			formatForPieChart = customFormatForPieChart;
		}
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		var isExecutiveReport = jsonData['isExecutiveReport'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily='Arial';
		LegendFont='Arial';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		//valign = (LegendPosition == 'right')?'middle':'top';
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		else if(showLegends == 'false')
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var enablePointSelect =true;
		var PointSelect =jsonData['allowPointSelect'];
		if(PointSelect == "" || PointSelect == 'null' || PointSelect == 'undefined' || PointSelect == undefined)
			enablePointSelect=true;
		else if(PointSelect == 'false')
			enablePointSelect=false;
		var chartTitle =jsonData['title'];
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var chartContObj=document.getElementById(container_Id);
       //var setGroupPadding=-0.1;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var isReporterHome=jsonData['isReporterHome'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var yVal=0;
		var yValue=-10;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var forCpacityReport=jsonData['forCpacityReport'];
		var showInLegend = false;
		var allowDecimal = true;
		var legendYValue = -10;
		var legendXValue = 0;
		if(jsonData['allowDecimal']!=undefined)
		{
			allowDecimal = jsonData['allowDecimal'];
		}
		var isHourWise=false;
		if(jsonData['isHourWise'] != undefined && jsonData['isHourWise'])
			isHourWise = jsonData['isHourWise'];
		var legendLocation='top'

		var isFromNetScalerReport = jsonData['isFromNetScalerReport'];
		if(isFromNetScalerReport!=undefined && isFromNetScalerReport == 'Yes')
		{
			legendYValue = -30;
		}
			
			if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
						 legendLocation = jsonData['LegendPosition'];
			}
			if(isUptimeChart!=null && isUptimeChart=='uptimechart'){
                if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
                     legendLocation = jsonData['LegendPosition'];
					if(jsonData['barType']!= null && jsonData['barType']!= ''){
						legendXValue = 50;
					}
				}
			}
			
			if(jsonData['isVsxUptime']!= null && jsonData['isVsxUptime']!= ''){
				if(jsonData['isVsxUptime'])
				{
					legendYValue = -33;
					legendXValue = 90;
				}
			}
			if(jsonData['isActiveIdle']!= null && jsonData['isActiveIdle']!= ''){
				if(jsonData['isActiveIdle'])
				{
					legendYValue = -33;
				}
			}
		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked'){
				if(chartType!=null &&(chartType=='column' || chartType=='waterfall'))
					if(chartTitle == null || chartTitle == '')
						space=[10, 10, 10, 10];
				if(isExecutiveReport!=null && isExecutiveReport)
					space=[20, 10, 10, 10];
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		var calBarwidth=0;
		var calx=100;
		var changebarwidthinHomePage=false;
		if(data!=null && data.length>=1)
		{
			calx = (chartWidth/data.length)+40;
			var xx=data[0].data;
			calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
			//if(xx.length==1)
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
			if(chartType!=null && chartType=='combinedChart')
			{
				if(forCpacityReport == true)
				{
					
					if(xx.length>40)
					{
						setPointWidth=8;
					}
					else if(xx.length>30)
					{
						setPointWidth=10;
					}
					else if(xx.length>20)
					{
						setPointWidth=15;
					}
					else if(xx.length>10)
					{
						setPointWidth=20;
					}
					else if(xx.length>5)
					{
					   setPointWidth=25;
					}
					else
					{
						setPointWidth=30;
					}
				}
			}
			if(chartType!=null &&(chartType=='column' || chartType=='waterfall'))
			{
				 setPointWidth=27;
					
					if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=12;
					}
					else if(xx.length>=30)
				    {
					setPointWidth=17;
					}
//					else if(xx.length>21)
//				    {
//					setPointWidth=12;
//					}
//					else if(xx.length>=15)
//				    {
//					setPointWidth=17;
//					}
					else if(xx.length<=8)
			        {
                   setGroupPadding=0.2;
				   setPointPadding=0.2;
			        }


					if(isHypervisorResoucesChart==true)
					{
					setPointWidth=12;
					if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
					var isMonthlyChart=jsonData['isMonthlyChart'];
					if(isMonthlyChart==true)
							setPointWidth=null;
					}

					var isHistoryOfAlarm=jsonData['isHistoryOfAlarm'];
					if((xx.length<=30 &&xx.length>21) && isHistoryOfAlarm == true)
					{
						setPointWidth=15;
					}
			}
			if(xx.length > 5){
				changebarwidthinHomePage=true;
			}
		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
			if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
		}else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && chartType=='combinedChart')
		{
			var forCapacityReport=jsonData['forCapacityReport'];
			if(forCapacityReport != "" && forCapacityReport != 'null' && forCapacityReport != 'undefined' && forCapacityReport != undefined ){
				rotateDegree=270;
				yVal=20;
				xval=5;
			}
		}
		if(chartType!=null && (chartType=='column' || chartType=='waterfall' ||chartType=='line' || chartType=='spline' || chartType=='area' || chartType=='areaspline' ))
		{			
			rotateDegree=-90;
			if(chartType=='waterfall')
				rotateDegree=-60;
			yVal=10;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
				xval=2;
				strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
				strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
					showLegends=true;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				dataLabelColor='#2a292a';
				if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
				
				  setMinPointLength=10;
				  setPointWidth=21;
			}
		}
		var setStackingVal=jsonData['setStacking'];
		if(setStackingVal != undefined && setStackingVal != 'undefined' && setStackingVal != null && setStackingVal==false)
		{
			 setStacking=null;
		}
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily='Arial';
		if(chartType!=null && chartType=='pie'){
			fontsize="11px"
			fontfamily='Arial';
			fontweight="bold";
		}
		if(isCombinationLineChart==true)
		{
		setStacking=null;
        setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		if(strSkin=='Dark' || strSkin=='dark')
		{
			lablecolor='#636363';
			connColor='#9b9fa1';
		}
		var marginbottom=null;
		var marginright=null;
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var marginTop=20;
		var isTopNReport=jsonData['isTopNReport'];
		var fromSessionUsage = jsonData['fromSessionUsage'];
		if(fromSessionUsage!=undefined || fromSessionUsage != 'undefined' && fromSessionUsage == 'yes')
		{
			xval = 0;
		}

		if(xLabel.length>=6)
			marginbottom=chartHeight-20-(xLabel.length)*(setPointWidth+1);
		if(chartType!=null && chartType=='pie')
			marginTop=null;
		if(chartType!=null && (chartType=='column' || chartType=='waterfall'))
		{
			marginbottom=null;
			marginTop=null;
			//if(chartContObj!=null)
			//	chartContObj.style.height = '100%';
			if(xLabel.length>=6)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
			if(marginright>150)
				marginright =30;

			if(marginright<0)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+3);
			if(setPointWidth==null)
				marginright=30;
		}
		var adjustbarWidth=jsonData['adjustbarWidth'];//..
		if(adjustbarWidth != null && adjustbarWidth !=undefined && adjustbarWidth != 'undefined' && adjustbarWidth == 'yes' )
		{
			setPointWidth=18;
		}
		var allowMarginTop=jsonData['allowMarginTop'];//..
		if(allowMarginTop != null && allowMarginTop !=undefined && allowMarginTop != 'undefined' && allowMarginTop == 'yes' )
		{
			marginTop=jsonData['marginTop'];
		}
		var needxaxisLabelRotation=jsonData['needxaxisLabelRotation'];//..
		if(needxaxisLabelRotation != null && needxaxisLabelRotation !=undefined && needxaxisLabelRotation != 'undefined' && needxaxisLabelRotation == 'yes' )
		{
			rotateDegree=0;
		}
		if(chartType!=null && chartType=='bar')
		{
			mychartwidth=null;
			if(chartContObj!=null)
			{
				chartContObj.style.width = '100%';

				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					chartContObj.style.width = '100%';
					space =[10, 20, 10, 10];
				
				}

				if(isTopNReport!=undefined && isTopNReport!=null && isTopNReport==true)
					chartContObj.style.width = '100%';
				if(isReporterHome!=undefined && isReporterHome!=null && isReporterHome=='yes'){
					if(changebarwidthinHomePage)
						setPointWidth=null;
					chartContObj.style.width = '100%';
				}
			}


			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			setendOnTick=false;
			marginTop=null;
			marginbottom=null;
			mychartwidth=null;
			mychartheight=null;
//			if(chartContObj!=null)
//			{
//				chartContObj.style.height = '100%';
//				if(chartType=='pie')
//					chartContObj.style.width = '100%';
//				else
//					chartContObj.style.width = '97%';
//			}
			if(isReporterHome!=undefined && isReporterHome!=null && isReporterHome=='yes'){
				marginTop=30;
				yValue=-5;
			}
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var jsonYvalue=jsonData['yValue'];
		if(jsonYvalue != "" && jsonYvalue != 'null' && jsonYvalue != 'undefined' && jsonYvalue != undefined )
		{
			yVal=jsonYvalue;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='100%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];
		if(centerlegendPostion != "" && centerlegendPostion != 'null' && centerlegendPostion != 'undefined' && centerlegendPostion != undefined && centerlegendPostion=="true" )
		{
			calx=(chartWidth/4)+25;			
		}
		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var forVCCapacityPlanning=jsonData['forVCCapacityPlanning'];
		if(forVCCapacityPlanning != "" && forVCCapacityPlanning != 'null' && forVCCapacityPlanning != 'undefined' && forVCCapacityPlanning != undefined && forVCCapacityPlanning == 'Yes'){
			setPointWidth=70;
			rotateDegree=0;
			dataLabelColor='#000000';
		}
		//prakash
		var needToAdjustSeriesValue = jsonData['adjustSeriesValue'];
		var xSeriesValue=3;
		var itemMarginInTop=0;
		if(needToAdjustSeriesValue!=null && needToAdjustSeriesValue!='undefined' && needToAdjustSeriesValue == 'true')
		{
			xSeriesValue=0;
			itemMarginInTop=2;
		}
		//
		var forRUMHealthReport=jsonData['forRUMHealthReport'];
		var hourwise=jsonData['hourwise'];
		var weekly=jsonData['weekly'];
		var dayWise=jsonData['dayWise'];
		if(forRUMHealthReport != "" && forRUMHealthReport != 'null' && forRUMHealthReport != 'undefined' && forRUMHealthReport != undefined ){
			rotateDegree=270;
			yVal=45;
			xval=5;
			if(hourwise != undefined && hourwise != 'undefined'){
				yVal=25;
			}
			if(dayWise != undefined && dayWise != 'undefined'){
				yVal=35;
			}
			if(weekly != undefined && weekly != 'undefined'){
				xval=-5;
				yVal=40;
			}

		}
		var enableGroupingVal=jsonData['enableGrouping'];
		var enableGrouping=true;
		if(enableGroupingVal != "" && enableGroupingVal != 'null' && enableGroupingVal != 'undefined' && enableGroupingVal != undefined && enableGroupingVal == 'true'){
			enableGrouping=false;
		}
		var forSlowLogonTrend=jsonData['forSlowLogonTrend'];
		if(forSlowLogonTrend != "" && forSlowLogonTrend != 'null' && forSlowLogonTrend != 'undefined' && forSlowLogonTrend != undefined && forSlowLogonTrend == 'true'){
			xval=3;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var piechartBorder = 0;

		spacing_new = [10,20,20,20];
		if(chartType!=null && chartType=='donut')
		{
			piechartBorder = 1;
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight='100%';
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth='100%';
			piechartTitleVAlign='middle';
			piechartTitleY=0;
			spacing_new = [0,20,10,20];
		}
		if(chartContObj != null){
			if(mychartheight!=null && mychartheight<chartContObj.offsetHeight)
				mychartheight =null;
		}
		//if(mychartwidth!=null && mychartwidth<chartContObj.offsetWidth)
			mychartwidth =null;
		//	mychartwidth =chartContObj.offsetWidth-20;		
		var isSystemCapacity=jsonData['isSystemCapacity'];
		var markerEnable = true;
		var ygridLineWidth=1;
		var xgridLineWidth=0;
		yaixlinewidth=1;
		if(isReporterHome!=undefined && isReporterHome!=null && isReporterHome=='yes' && chartType!=null && (chartType=='column' || chartType=='waterfall')){
			yaixlinewidth=0;
		}
		if(isSystemCapacity == true)
		{	
			markerEnable = false;
			yaixlinewidth=1;
			ygridLineWidth=0;
			xgridLineWidth=1;
			xval = 5;
			chartType = 'line';
		}
		var disablelineChartMarker=jsonData['disablelineChartMarker'];
		if(disablelineChartMarker!=undefined && disablelineChartMarker!=null && disablelineChartMarker =='true'){
			markerEnable=false;
		}
	
		var changeAxisGridLine=jsonData['changeAxisGridLine'];
		if(changeAxisGridLine != undefined && changeAxisGridLine == true){
			ygridLineWidth=0;
			xgridLineWidth=1;
		}
		var showLastAxisLabel=jsonData['showLastAxisLabel'];
		if(showLastAxisLabel != undefined && showLastAxisLabel == true){
			setendOnTick=true;
		}
		var marginYAxis = 15;
		var marginXAxis = 10;
		var forRumReport = jsonData['forRumReport'];
		if(forRumReport!=undefined || forRumReport!='undefined' && forRumReport == 'true' )
		{
			marginYAxis = 30;
			marginXAxis = 20;
		}
    
    var topUsers=jsonData['topUsers'];
		var yAxisTitleYVal=0;
		if(topUsers!=undefined && topUsers!=null && topUsers ==true){
			marginYAxis=0;
			yAxisTitleYVal=15;
		}

		var chartingOptions = {
			chart:{
				height:mychartheight,
				width:mychartwidth,
				type : chartType,
				spacing:spacing_new,
				marginTop:marginTop,
				//marginRight:marginright,
				//marginBottom: marginbottom
			},
			title: {
				text: chartTitle,
		            align: 'center',
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY
			},
			tooltip: {
					enabled:tooltipEnable,
					//pointFormat: strpointFormat,
					valueDecimals: 4,
					useHTML	: true,
					shared:true,
					formatter: function() {
						var val = Highcharts.numberFormat (this.y,4, '.','');
						if(tooltipPercent)
							val = Highcharts.numberFormat (this.percentage,2, '.','');
						
						val = (parseFloat(val));   
						//if(val ==0)
						//	return false;
						var s ='';
						
						if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
						{
							if(tooltipPercent)
								val=val+' %';
							if(chartType != undefined && chartType == 'pie' && this.key != this.y){
								if(this.key != undefined){
									val='<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;"> '+this.key+'</span> : <span >'+val +' </span>';
								}
							}
							if(strSkin=='Dark' || strSkin=='dark')
							{
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+val+'</span></b>';
							}
							else
							{
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+val+'</span></b>';
							}
						}else{
							if(strSkin=='Dark' || strSkin=='dark')
							{
								if(tooltipPercent)
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+ this.x +'  :  '+val+' %</span></b>';
								else
								{
									//s += '<b><span style="color:white">'+ this.x +'  :  '+val+'</span></b>';
									s+='<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;">'+this.x+'</span>';
									s +='<table>'
									+'<tbody>';
									$.each(this.points,function(i,point){
										var seriesName=point.series.name;
										if(seriesName == undefined || seriesName == 'Series 1')
											seriesName=yaxisTitle;
//										if(seriesName != undefined && seriesName != 'number' && seriesName != 'Number')
//											val = Highcharts.numberFormat (point.y,4, '.','');
										if(typeof point.y == 'number'){
											val=Math.round(point.y * 10000) / 10000;
										}
										else{
											val=point.y;
										}
										s+='<tr>';
										if(jsonData['noNeedUnit'] != undefined && jsonData['noNeedUnit'] == 'yes')
										{
											s+='<td style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;padding-top: 10px;">'+val+'</td></tr>';
										}
										else
										{
											if(seriesName != undefined && seriesName!='undefined')
												s+='<td style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;padding-top: 10px;color: '+point.series.color+'">'+seriesName+'&nbsp;:&nbsp;</td>';
											s+='<td style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;padding-top: 10px;">'+val+'</td></tr>';
										}
									});							
									s+='</tbody></table>';
									return s;
								}
							}else
							{
								if(tooltipPercent)
									s += '<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;color:#2a292a">'+ this.x +'  :  '+val+' %</span>';
								else
								{
									s+='<span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;">'+this.x+'</span>';
									s +='<table>'
									+'<tbody>';
									$.each(this.points,function(i,point){
										var seriesName=point.series.name;
										if(seriesName == undefined || seriesName == 'Series 1')
											seriesName=yaxisTitle;
//										if(seriesName != undefined && seriesName != 'number' && seriesName != 'Number')
//											val = Highcharts.numberFormat (point.y,4, '.','');
										if(typeof point.y == 'number'){
											val=Math.round(point.y * 10000) / 10000;
										}
										else{
											val=point.y;
										}
										s+='<tr>';
										if(jsonData['noNeedUnit'] != undefined && jsonData['noNeedUnit'] == 'yes')
										{
											s+='<td style="font-size: 12px;padding-top: 10px;">'+val+'</td></tr>';
										}
										else
										{
											s+='<td style="font-size: 12px;padding-top: 10px;color: '+point.series.color+'">'+seriesName+': </td>';
											s+='<td style="font-size: 12px;padding-top: 10px;">'+val+'</td></tr>';
										}
									});							
									s+='</tbody></table>';
									return s;
								}
							}
						}
						return s;
					}
				},
			yAxis: {
					min: 0,
					max:ymax,
					tickWidth:0,
					allowDecimals:allowDecimal,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineWidth:ygridLineWidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					endOnTick:setendOnTick,
					labels: {
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontSize: '10px',
								whiteSpace: 'nowrap' 
							}
						},
					title: {
						text: yaxisTitle,
						margin: marginYAxis,
						y:yAxisTitleYVal,
						enabled: YtitleEnable,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
							whiteSpace: 'nowrap' 
							},
						},
				},
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: xgridLineWidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth:1,
					labels: {
						 rotation:rotateDegree,
						 x:xval,
						 y:yVal,
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontSize: '10px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
								var val=this.value;
								var val2=val.toString();
								if(val!=null && val.length>32)
								{
									var val2=val.substring(32);
									if(val2.length>3)
										val=val.substring(0,32)+'...'
								}
								//..
								if(isHourWise && val != null && val.trim().indexOf(" ") != -1)
								{
									val = val.substring(val.lastIndexOf(" ")+1);

								}
								//..
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						y:5,
						margin: marginXAxis,
						style: {
							color : '#0c9a12',
							fontWeight: 'bold',
							fontSize: '20px',
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: enablePointSelect,
						cursor: setCursor,
						borderColor:'transparent',
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
						point: {
							events: {
							   click: function() {
										var QString=this.options.url;
										if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
										{
										}
										else if(chartType!=null && chartType=='pie')
										{
											if(drilDown!=null && drilDown=='sametab')
											{
										       document.location.href=QString;
											}
											else if(drilDown!=null && drilDown=='newtab')
											{
												openInNewWin(QString);
											}
										}
								   }
							},
						}
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
							style:{
								fontWeight:'normal',
								textShadow: false,
								textOutline: false 
								},
							filter: {
								property: 'percentage',
								operator: '>',
								value: 0
							}
						},
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='bar')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						grouping:enableGrouping,
						pointWidth:setPointWidth
					
					 },
					waterfall:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						grouping:enableGrouping,
						pointWidth:setPointWidth
					},
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='line')
									{
										if(QString.indexOf("/")>-1)
										{
										  document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					series: {
							shadow: false,
							showEmpty:false,
							turboThreshold:100000,
							stacking: setStacking, 
							cursor: setCursor,
							borderWidth: piechartBorder,
							depth: 0,
							pointWidth:setPointWidth,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && (chartType=='line' || chartType=='spline'))
									{
										if(QString.indexOf("/")>-1)
										{
										  document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}
									}else if(chartType!=null && chartType=='column')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
								   }else if(chartType!=null && chartType=='pie')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
										   document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}else if(chartType!=null && chartType=='bar')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						},
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								x:xSeriesValue,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontfamily,
									fontSize: fontsize,
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: markerEnable,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: legendLocation,
					itemDistance:5,
					y:legendYValue,
					x:legendXValue,
					enabled: showLegends,
					//width:legendWidth,
					align:'center',
					maxHeight :maxLegendHeight,  
					itemMarginTop:itemMarginInTop,
					itemMarginBottom: 10,
					itemStyle: {
					   textAlign: 'top',
					  /// textAlign: 'right',
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					},
				}
			};

			var isVMSessionUsage=jsonData['isVMSessionUsage'];
			if(isVMSessionUsage != 'undefined' && isVMSessionUsage)
			{
				chartingOptions.chart.plotBackgroundColor = '#f2f2f2';
			}

		var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/noMeasureImg_new.png" /></td></tr></table>';
		var chartContObj=document.getElementById(container_Id);
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		var chartData=[];
		if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
		{
			drawChart = false;
			if(chartContObj!=null)
			{
				chartContObj.innerHTML=myhtml;
				
			}
		}else{
			this.highchart.series=jsonData['DataSet'];
			this.highchart.chart.renderTo = container_Id;
		}
	},

	drawChart: function() {
		if(drawChart)
		{
			Highcharts.setOptions({
				lang: {
						thousandsSep: ''
					}
			});
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset: timezoneOffsetValue
				}
			});
			this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
			if(isDoNut)
			{
				donutChartTitle= {
				   title: {
					   useHTML:true,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#2a292a',
							fontFamily:'Roboto',
							fontSize: '16px',
							fontWeight: '500'
						}
				   }
				}
				this.highchart= jQuery.extend(true, this.highchart, donutChartTitle);
			}


			Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
			new Highcharts.Chart(this.highchart);
		}
	}

};
return ErHighStockChart;
}

 (function (H) {
          H.Chart.prototype.reflow = function () {
				var task = new Ext.util.DelayedTask(function(){
					 var clientWidth=renderTo.clientWidth; 
				 var clientHeight=renderTo.clientHeight; 
				 if(chart.chartHeight>renderTo.clientHeight)
						clientHeight=chart.chartHeight;
					 chart.setSize(clientWidth, clientHeight, false);
  				});

				var chart = this,
				renderTo = chart.renderTo;
 				Ext.EventManager.onWindowResize(function () {
					var initialClientWidth=renderTo.clientWidth; 
					if (initialClientWidth!=0)
					task.delay(100);
				});
      };
    }(Highcharts));



