$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsBarInstance(container_Id,chartHeight,chartWidth){
	var drawChart = true;
	var isDoNut = false;
	var borderWidth=0;

 var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			plotBorderWidth: 0,
			plotBorderColor : '#e5e5e5',
			backgroundColor:'#ffffff',
			plotBackgroundColor: 'white',
			plotShadow: false,
			placeValuesInside:0,
			shadow: false,
			
			zoomType:'xy',
			align:'center',
			ignoreHiddenSeries:false,
			events: {
				load: function(event) {
					$('.highcharts-legend-item rect').attr('height', '8').attr('y', '7');
					$('.highcharts-legend-item rect').attr('width', '8').attr('x', '10');
				}
			}   
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
		    min: 0,
			border :0,
			//tickPixelInterval:75,
			reversedStacks: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
			    formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					val = (parseFloat(val));
					return val;
				},
			},
			showLastLabel: true,
			tickPositioner: function(min,max){
				var act = min,
				ticks = [];
				this.tickAmount=1;
				var flag=false;
				var interval=this.tickInterval;
				var second=0;
				if(min==max)
				{
					if(max>1)
						max=max+1;
					else if(max==0){
						max=max+1;
						second=0
						flag=true;
					}
					else
					{
						max=max+0.1;
					}
				}
				var cc=1
				while(act <= max){
					if(cc==2 && flag)
						ticks.push(second);
					else
						ticks.push(act);
					act+= interval;
					cc++;
				}
				if(!flag)
					ticks.push(act);
			  return ticks;  
			},
		},
		scrollbar: {
			enabled: false
		},
		legend: {
			verticalAlign: 'top',
			align:'center',
			layout: 'horizontal',
			borderWidth: 0,
			adjustChartSize: false,
			navigation: {
				arrowSize: 5
			},
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'normal',
				fontSize: '10px',
			},
			symbolWidth: 15,
		},
		labels :{
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'Normal',
				fontSize: '10px',
			},
		},
		tooltip: {
			borderColor: 'black',
			valueDecimals: 4,
			style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '10px',
				},
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
			type:'datetime',
			tickPixelInterval:50,
			min: 0,
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
				overflow: 'justify',
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				useHTML: false,
			},
			title: {
				style: {
					color : '#636363',
					fontWeight: 'Bold',
					fontSize: '11px',
				},
			},
		},
		title: {
				text: '',
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '12px',
				}
			},
		series: {
		}
	},
	setData: function(jsonData,currentDateFormat,drilldownurl) {
 		var toolTipFmt = '';
		var chartType = 'bar';
	    var setStacking='normal'
		var setMinPointLength=0;
		var setendOnTick=true;
		var enable_Format=jsonData['enable_Format'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";

		if(Ext.isEmpty(enable_Format))
		{
			enable_Format="";
			formatForPieChart='{point.name}';
		}
		else
		{
			formatForPieChart='{point.percentage:.2f} %';
		}
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
		{
           		formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		}

		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		{
		      formatForPieChart='{point.percentage:.1f} %';
		}
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily='Arial';
		LegendFont='Arial';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var chartTitle =jsonData['title'];
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var chartContObj=document.getElementById(container_Id);
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var yVal=0;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var showInLegend = false;
		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked')
			{
				if(chartType!=null && chartType=='column')
				{
					if(chartTitle == null || chartTitle == '')
					{
						space=[40, 10, 10, 10];
					}
				}
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		var calBarwidth=0;
		var calx=100;
		if(data!=null && data.length>=1)
		{
			calx = (chartWidth/data.length)+40;
			var xx=data[0].data;
			calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
			if(chartType!=null && chartType=='column')
			{
				setPointWidth=15;
			}
		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
			if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
		}
		else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && (chartType=='column' ||chartType=='line' || chartType=='combinedChart'))//..
		{
			rotateDegree=-90;
			yVal=20;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
				xval=2;
				strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
				strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				setPointWidth=15;
			}
			else
			{
				dataLabelColor='#2a292a';
				if(strSkin=='Dark' || strSkin=='dark')
					dataLabelColor='#c0c0c0';
				
				  setMinPointLength=10;
				  setPointWidth=15;
			}
		}
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily='Arial';
		if(chartType!=null && chartType=='pie'){
			fontsize="11px"
			fontweight="Bold";
		}
		if(isCombinationLineChart==true)
		{
			setStacking=null;
			setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		if(strSkin=='Dark' || strSkin=='dark')
		{
			lablecolor='#636363';
			connColor='#9b9fa1';
		}
		var marginbottom=null;
		var marginright=null;
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var marginTop=20;
		var isTopNReport=jsonData['isTopNReport'];

		if(xLabel.length>=6)
			marginbottom=chartHeight-20-(xLabel.length)*(setPointWidth+1);
		if(chartType!=null && (chartType=='column' || chartType=='combinedChart'))//..
		{
			marginbottom=null;
			marginTop=null;
			if(xLabel.length>=6)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
			if(marginright>150)
				marginright =30;

			if(marginright<0)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+3);
			if(setPointWidth==null)
				marginright=30;
			var isSimulator = jsonData['isSimulator'];
			if (isSimulator!=undefined && isSimulator!=null && (isSimulator==true || isSimulator=='true'))
			{
				marginright=-10;
				setPointWidth=15;
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			mychartwidth=null;
			if(chartContObj!=null)
			{
				chartContObj.style.width = '97%';
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					chartContObj.style.width = '100%';
					space =[10, 20, 10, 10];
				}
				if(isTopNReport!=undefined && isTopNReport!=null && isTopNReport==true)
				 chartContObj.style.width = '100%';
			}
			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			setendOnTick=false;
			marginTop=null;
			marginbottom=null;
			mychartwidth=null;
			mychartheight=null;
			if(chartContObj!=null)
			{
				chartContObj.style.height = '100%';
				if(chartType=='pie')
					chartContObj.style.width = '100%';
				else
					chartContObj.style.width = '97%';
			}
		}
		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];
		if(centerlegendPostion != "" && centerlegendPostion != 'null' && centerlegendPostion != 'undefined' && centerlegendPostion != undefined && centerlegendPostion=="true" )
		{
			calx=(chartWidth/4)+25;			
		}
		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		if(chartType!=null && chartType!='donut')
		{
			space =[2, 0, 5,0];
			marginTop = 25;
		}
		if(chartType!=null && chartType=='donut')
		{ 
			chartType='pie';
			isDoNut = true;
			
			pieSize=jsonData['pieSize'];
			var isborderWidth=jsonData['borderWidth'];
			if(isborderWidth != "" && isborderWidth != 'null' && isborderWidth != 'undefined' && isborderWidth != undefined && (isborderWidth==true || isborderWidth=='true'))
			{
				borderWidth=2;
			}
			else
			{
				borderWidth=0;
			}
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight='100%';
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth='100%';
			piechartTitleVAlign='middle';
			piechartTitleY=0;
			//space = 0;
			space = [10,10,10,10];
			marginTop = 0;
			marginright = 10;
			marginbottom = 0;
		}
		
		if(chartType!=null && chartType=='combinedChart')// vengat >> for cross X-axis label
		{
			rotateDegree=-60;
			xval=0;
			yVal=15;
		}


		var chartingOptions = {
			chart:{
				height:mychartheight,
				width:mychartwidth,
				type : chartType,
				spacing:space,
				marginTop:marginTop,
				marginRight:marginright,
				//marginBottom:marginbottom
				
			},
			title: {
				text: chartTitle,
		            align: 'center',
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY
			},
			tooltip: {
					enabled:tooltipEnable,
					//pointFormat: strpointFormat,
					valueDecimals: 4,
					formatter: function() {
						var val = Highcharts.numberFormat (this.y,4, '.','');
						if(tooltipPercent)
							val = Highcharts.numberFormat (this.percentage,2, '.','');
						
						val = (parseFloat(val));
						if(val ==0)
							return false;
						var s ='';
						
						if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
						{
							if(strSkin=='Dark' || strSkin=='dark')
							{
								if(tooltipPercent)
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+val+' %</span></b>';
								else
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+val+'</span></b>';
							}
							else
							{
								if(tooltipPercent)
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+val+' %</span></b>';
								else
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+val+'</span></b>';
							}
						}else{
							if(strSkin=='Dark' || strSkin=='dark')
							{
								if(tooltipPercent)
								s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+ this.x +'  :  '+val+' %</span></b>';
							else
								s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:white">'+ this.x +'  :  '+val+'</span></b>';
							}else
							{
								if(tooltipPercent)
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+ this.x +'  :  '+val+' %</span></b>';
								else
									s += '<b><span style="font-weight:normal;font-family:Arial;font-weight:500;font-size:11px;white-space:nowrap;color:#2a292a">'+ this.x +'  :  '+val+'</span></b>';
							}
						}
						return s;
					}
				},
			yAxis: {
					min: 0,
					max:ymax,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					endOnTick:setendOnTick,
					labels: {
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontSize: '10px',
							}
						},
					title: {
						text: yaxisTitle,
						margin: 10,
						enabled: YtitleEnable,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
							},
						},
				},
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth:1,
					labels: {
						 rotation:rotateDegree,
						 x:xval,
						// y:yVal,
						 align:'right',
						 style: {
								color : '#636363',
								fontWeight: 'Normal',
								fontSize: '10px',
							},
							formatter: function() {
								var val=this.value;
								var val2=val.toString();
								var valLength=32;
								if(chartType!=null && chartType=='combinedChart')
								{
									valLength=7;
								}
								if(val!=null && val.length>valLength)
								{
									var val2=val.substring(valLength);
									if(val2.length>3)
										val=val.substring(0,valLength)+'...'
								}
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						margin: 10,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: true,
						cursor: setCursor,
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
						point: {
							events: {
							   click: function() {
										var QString=this.options.url;
										if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
										{
										}
										else if(chartType!=null && chartType=='pie')
										{
											if(drilDown!=null && drilDown=='sametab')
											{
										       document.location.href=QString;
											}
											else if(drilDown!=null && drilDown=='newtab')
											{
												openInNewWin(QString);
											}
										}
								   }
							},
						}
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
						},
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='bar')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='column')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
								   }
							   }
							}
						}
					 },
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='line')
									{
										if(QString.indexOf("/")>-1)
										{
										  document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					 },
					series: {
							shadow: false,
							stacking: setStacking, 
							borderWidth: borderWidth,
							depth: 0,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								x:3,
								y:-1,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontfamily,
									fontSize: fontsize,
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: true,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: 'top',
					//y: -10,
					y: -20,
					x:-5,
					itemDistance:5,
					enabled: showLegends,
					align:'center',
					maxHeight :maxLegendHeight,
					symbolPadding:10,
					itemMarginBottom: 4,
					itemStyle: {
					   textAlign: 'top',
						fontFamily:'Arial',
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					}
				}
			};
		var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
		var chartContObj=document.getElementById(container_Id);
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		var chartData=[];
		if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
		{
			drawChart = false;
			if(chartContObj!=null)
			{
				chartContObj.innerHTML=myhtml;
				
			}
		}else{
			this.highchart.series=jsonData['DataSet'];
			this.highchart.chart.renderTo = container_Id;
		}
	},
	drawChart: function() {
		if(drawChart)
		{
			Highcharts.setOptions({
				lang: {
						thousandsSep: ''
					}
			});
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset: timezoneOffsetValue
				}
			});
			this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
			if(isDoNut)
			{
				borderWidth=2;
				donutChartTitle= {
				   title: {
					   useHTML:true,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#2a292a',
							fontFamily:'Roboto-Bold',
							fontSize: '16px',
						}
				   }
				}
				this.highchart= jQuery.extend(true, this.highchart, donutChartTitle);
			}
			Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
			new Highcharts.Chart(this.highchart);
		}
	}
};
return ErHighStockChart;
}
