$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getColumnInstance(container_Id,chartHeight,chartWidth){


// ignoreHiddenSeries  Should be true to auto Align Y axis when clicking legends
	var drawChart = true;
 var ErHighStockChart = {
	highchart: null,
	defaults: {
		chart: {
			plotBorderWidth: 0,
			plotBorderColor : '#e5e5e5',
			backgroundColor:'#ffffff',
			plotBackgroundColor: 'white',
			plotShadow: false,
			placeValuesInside:0,
			shadow: false,
			zoomType:'xy',
			align:'center',
			ignoreHiddenSeries:true,
			events: {
				load: function(event) {
					$('.highcharts-legend-item rect').attr('height', '8').attr('y', '7');
					$('.highcharts-legend-item rect').attr('width', '8').attr('x', '10');
				}
			}   
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		yAxis: {
		    min: 0,
			border :0,
			//tickPixelInterval:75,
			reversedStacks: true,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
			    formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					//var val_ar = val.split('.');
					val = (parseFloat(val));
					/*if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
						else if (val_ar[1].lastIndexOf("000")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,1);
						}else if (val_ar[1].lastIndexOf("00")>-1)
						{
							val = val_ar[0]+"."+val_ar[1].substring(0,2);
						}
					}*/
					return val;
				},
			},
			showLastLabel: true,
			tickPositioner: function(min,max){
				var act = min,
				ticks = [];
				this.tickAmount=1;
				var flag=false;
				var interval=this.tickInterval;
				var second=0;
				if(min==max)
				{
					if(max>1)
						max=max+1;
					else if(max==0){
						max=max+1;
						second=0
						flag=true;
					}
					else
					{
						max=max+0.1;
					}
				}
				var cc=1
				while(act <= max){
					if(cc==2 && flag)
						ticks.push(second);
					else
						ticks.push(act);
					act+= interval;
					cc++;
				}
				if(!flag)
					ticks.push(act);
			  return ticks;  
			},
		},
		scrollbar: {
			enabled: false
		},
		legend: {
			verticalAlign: 'top',
			align:'center',
			layout: 'horizontal',
			borderWidth: 0,
			//y:5,
			//x:5,
		//	width: 300,
			adjustChartSize: true,
			navigation: {
				arrowSize: 5
			},
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'normal',
				fontSize: '10px',
			},
			symbolWidth: 15,
		},
		labels :{
			itemStyle: {
				color : '#2a292a',
				fontWeight: 'Normal',
				fontSize: '10px',
			},
		},
		tooltip: {
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		xAxis: {
			type:'datetime',
			tickPixelInterval:50,
			min: 0,
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: true,
			labels: {
				style: {
					color : '#636363',
					fontWeight: 'Normal',
					fontSize: '11px',
				},
				overflow: 'justify',
				showLastLabel: true,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				useHTML: false,
			},
			title: {
				style: {
					color : '#636363',
					fontWeight: 'Bold',
					fontSize: '11px',
				},
			},
		},
		title: {
				text: '',
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontSize: '12px',
				}
			},
		series: {
		}
	},
	setData: function(jsonData,currentDateFormat,drilldownurl) {
 		var toolTipFmt = '';
		var chartType = 'column';
	    var setStacking='normal'
		var setMinPointLength=0;
		var setendOnTick=true;
		var toolTpHeader=jsonData['toolTpHeader'];
		var toolTpColName=jsonData['tooltipColumns'];
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		var xaxisInfo=jsonData['xAxisInfo'];
		yaxisTitle = jsonData['yAxisLabel'];
		//yaxisTitle = 
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily='Arial';
		LegendFont='Arial';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		//valign = (LegendPosition == 'right')?'middle':'top';
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=false;
		var pieDisableLegend =jsonData['pieDisableLegend'];
		if(pieDisableLegend == "" || pieDisableLegend == 'null' || pieDisableLegend == 'undefined' || pieDisableLegend == undefined)
			pieDisableLegend=true;
		else if(pieDisableLegend == 'true')
			pieDisableLegend=false;
		var tooltipEnable=false;
		
		var LegendAlign =jsonData['legendLeftAlign'];
		
		if(LegendAlign == "" || LegendAlign == 'null' || LegendAlign == 'undefined' || LegendAlign == undefined)
		{
			LegendAlign="top";
		}else if(LegendAlign == 'true')
		{
			LegendAlign="bottom";
		}
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var chartTitle =jsonData['title'];
		if(Ext.isEmpty(chartTitle))
			chartTitle='';
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var chartContObj=document.getElementById(container_Id);
       //var setGroupPadding=-0.1;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor='pointer';
		var isUptimeChart=jsonData['uptime'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var yval=0;
		var ymax=null;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var symbolPadding = 15;
		if(jsonData['loadDistributionReport']!='undefined' ||jsonData['loadDistributionReport']!=undefined && jsonData['loadDistributionReport']=='true')
		{
			symbolPadding =20;
		}

		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		if(!showLegends)
		{
			
						space=[40, 10, 10, 10];
			
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		
		var calBarwidth=0;
		var calx=100;
		if(data!=null && data.length>=1)
		{
			calx = (chartWidth/data.length)+40;
			var xx=data[0].data;
			calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
			//if(xx.length==1)
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
				 if(chartType!=null &&chartType=='column')
			{
				 setPointWidth=27;
					
					if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=8;
					}
					else if(xx.length>32)
				    {
					setPointWidth=10;
					}
					else if(xx.length>21)
				    {
					setPointWidth=12;
					}
					else if(xx.length>15)
				    {
					setPointWidth=17;
					}
					else if(xx.length<=8)
			        {
                   setGroupPadding=0.2;
				   setPointPadding=0.2;
			        }


					if(isHypervisorResoucesChart==true)
					{
					setPointWidth=12;
					if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
					var isMonthlyChart=jsonData['isMonthlyChart'];
					if(isMonthlyChart==true)
							setPointWidth=null;
					}
			}

		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		
			strpointFormat='<b>:{point.y}</b>';
		
		if(chartType!=null && (chartType=='column'))
		{
			rotateDegree=0;
			xtickwidth=1;
			ticklength=5;
			yval=20;
			xval=0;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			
		}
		
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily='Arial';
		
		if(isCombinationLineChart==true)
		{
		setStacking=null;
        setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		if(strSkin=='Dark' || strSkin=='dark')
		{
			lablecolor='#636363';
			connColor='#9b9fa1';
		}
		var extraCol="";
		var toolTpHeadVal="";
		if(toolTpHeader!=undefined)
		{
			toolTpHeadVal=toolTpHeader+" ";
		}
		
		if(toolTpColName!=undefined)
		{
			extraCol+='<tr>';
			for(var tp=0;tp<toolTpColName.length;tp++)
			{
				extraCol+='<th style="padding:3px">'+toolTpColName[tp]+'&nbsp;  &nbsp; </th>';
			}
			extraCol+='</tr>';
		}
		var marginbottom=null;
		var marginright=null;
		var mychartwidth=chartWidth;
	//	var mychartwidth=800;
		var mychartheight=chartHeight;

		var marginTop=20;
		if(xLabel.length>=6)
			marginbottom=chartHeight-20-(xLabel.length)*(setPointWidth+1);
		if(chartType!=null && chartType=='column')
		{
			mychartwidth=null;
			if(chartSubType=='unstacked')
			{				
				chartContObj.style.width = '97%';
			}			
			marginbottom=null;
			marginTop=null;
			
			if(xLabel.length>=6)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
			if(marginright>150)
				marginright =30;

			if(marginright<0)
				marginright=chartWidth-20-(xLabel.length)*(setPointWidth+3);
			if(setPointWidth==null)
				marginright=30;
		}
		
		if(pieDisableLegend)
		{
			tooltipEnable=true;
			chartTitle="";
		}
		
		var chartingOptions = {
			chart:{
				height:mychartheight,
				width:mychartwidth,
				type : chartType,
				spacing:space,
				marginRight:marginright,
				marginBottom: marginbottom
			},
			title: { 
				text: chartTitle,
			},					
			tooltip: {
					borderColor: 'black',
					enabled:tooltipEnable,
					style: {
						color : '#2a292a',
						fontWeight: 'Normal',
					},
					
					 headerFormat: '<span style="font-size:13px"><b>'+toolTpHeadVal+'{point.key} secs</b></span><table padding="0px" cellpadding="1px" border="0px"><tr height="10px"><td height="4px"></td></tr></table><table padding="3px" cellpadding="10px" border="1px">'+extraCol,
					pointFormat: '<tr><td style="color:{series.color};padding:3px">{series.name}&nbsp;  &nbsp; </td>' +					
						'<td style="padding:3px"><b>{point.y} </b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true,
					positioner: function(boxWidth, boxHeight, point) {   
						var clientWidth=this.chart.renderTo.clientWidth;
						if(point.plotY>150)
						{
							if(point.plotX>clientWidth-200)
								return {x:point.plotX-150,y:point.plotY-125}; 
							else 
								return {x:point.plotX,y:point.plotY-125}; 
						}else
						{
							if(point.plotX>clientWidth-200)
								return {x:point.plotX-150,y:point.plotY};   
							else
								return {x:point.plotX,y:point.plotY};   
						}						
					}				
			},
			yAxis: {
					min: 0,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					endOnTick:setendOnTick,
					labels: {
						style: {
							color : '#636363',
							fontWeight: 'Normal',
							fontSize: '10px',
						}
					},
					title: {
						margin:15,
						text: yaxisTitle,
						enabled: YtitleEnable,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
						},
					},
				},
				legend: {
					verticalAlign: LegendAlign,
					align:'center',
					layout: 'horizontal',
					borderWidth: 0,
					y:-50,
					adjustChartSize: false,
					navigation: {
						arrowSize: 5
					},
					itemStyle: {
						color : '#2a292a',
						fontWeight: 'normal',
						fontSize: '10px',
					},
					symbolWidth: symbolPadding,
					labelFormatter: function() {
						
						var retrunvar = this.name;
						if(!pieDisableLegend)
						{
							retrunvar=this.name+" [ "+this.percentage+"% ]";
						}						
					/*	if(retrunvar.length>28)
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}*/
						
						return retrunvar;
					},
				},
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth:1,
					labels: {
					 rotation:rotateDegree,
					 x:xval,
					 y:yval,
					 style: {
							color : '#636363',
							fontWeight: 'Normal',
							fontSize: '10px',
						},
						
					},	
					title: {
						margin:15,
						text: xaxisInfo,
						enabled: true,
						//y:5,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
						},
					},						
				},
			plotOptions: {					
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						padding:2,
						dataLabels: {
							enabled:false,	
							crop: false,
							overflow: 'none',
						},
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='column')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{										
											openInNewWin(QString);
										}										
								   }
							   }
							}
						}
					 },
					 pie: {
						shadow: false,
						borderWidth: 0, 
						size: '100%',
						allowPointSelect: isDataLabelEnable,
						cursor: setCursor,
						dataLabels: {
							enabled:false,	
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
						showInLegend:showLegends,
						point: {
							events: {
							   click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='pie')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
										   document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
							   }
							},
						}
					 },
					 series: {
						shadow: false,
						states: {
							hover: {
								enabled: false
							}
						},
						minPointLength:setMinPointLength
					},
				},		
			};
		var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
		var chartContObj=document.getElementById(container_Id);
		this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
		var chartData=[];
		if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
		{
			drawChart = false;
			if(chartContObj!=null)
			{
				chartContObj.innerHTML=myhtml;				
			}
		}else{
			this.highchart.series=jsonData['DataSet'];
			this.highchart.chart.renderTo = container_Id;
		}
	},

	drawChart: function() {
		if(drawChart)
		{			
			Highcharts.setOptions({
				global: {
					useUTC: true,
					timezoneOffset: timezoneOffsetValue
				}
			});
			this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
			Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
			new Highcharts.Chart(this.highchart);
		}
	}
};
return ErHighStockChart;
}
 (function (H) {
        H.Chart.prototype.reflow = function () {
				
			var task = new Ext.util.DelayedTask(function(){
				 var clientWidth=renderTo.clientWidth; 
				 var clientHeight=renderTo.clientHeight; 
				 chart.setSize(clientWidth, clientHeight, false);
			});

			var chart = this,
			renderTo = chart.renderTo;
			Ext.EventManager.onWindowResize(function () {
				var initialClientWidth=renderTo.clientWidth; 
				if (initialClientWidth!=0)
				task.delay(100);
			});
		};
    }(Highcharts));
